/*-
 * Copyright (C)2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: unrmufs2.h,v 1.12 2024/11/24 18:46:24 babolo Exp $
 */

typedef struct {
    u_int8_t ioerr: 1
           , nospc: 1
           , bdmsg: 1
           , noent: 1
           , nocrc: 1
           , crcer: 1
           , error: 1
           , empty: 1
    ;
} summary;
    
typedef struct {
    BLIN_flag         flags       ;                /*                                           */
# define  UNRMUFS2_CFILE   0x000400 /*       */
# define  UNRMUFS2_RTRAC   0x000800 /*      */
# define  UNRMUFS2_GEOM    0x001000 /*            */
# define  UNRMUFS2_DIRCT   0x002000 /*   direct    */
# define  UNRMUFS2_INDIR   0x004000 /*     */
    int               confd       ;                /*                           */
    const char       *conf        ;                /*                                    */
    const char       *ifs         ;                /* FS device or image path                        */
    mife_descriptor  *md          ;                /*                             */
    struct fs        *fs          ;                /*                      */
    size_t            cgsize      ;                /*  CG                                      */
    int               ifd         ;                /* FS device or image file descriptor             */
    uint32_t          cgmin       ;                /*    CG                     */
    uint32_t          cgmax       ;                /*    CG                     */
    uint32_t          dimax       ;                /*    dinode                 */
} unrmufs2_cf;

uint32_t   unrmufs2_sbtest   __P((unrmufs2_cf *cf, struct fs *fs));
int        unrmufs2_sbmain   __P((unrmufs2_cf *cf));
off_t     *unrmufs2_sbcg     __P((unrmufs2_cf *cf));
void       unrmufs2_cgsize   __P((unrmufs2_cf *cf));
void       unrmufs2_sbdif    __P((unrmufs2_cf *cf, uint32_t n, struct fs *fs1, struct fs *fs2));
struct cg *unrmufs2_cgtest   __P((unrmufs2_cf *cf, off_t cgoff));
uint32_t   unrmufs2_crc32t   __P((unrmufs2_cf *cf, uint8_t *b, int32_t s));
int        unrmufs2_readinog __P((unrmufs2_cf *cf, struct cg *cg, off_t cgoff, off_t cgn));
int        unrmufs2_doino    __P((unrmufs2_cf *cf, struct ufs2_dinode *ino));
int        unrmufs2_dir      __P((unrmufs2_cf *cf, struct ufs2_dinode *ino));
int        unrmufs2_inod     __P(( unrmufs2_cf *cf
                                 , struct ufs2_dinode *ig
                                 , off_t cgoff
                                 , off_t cgn
                                 , size_t i
                                ));
