/*-
 * Copyright (C)2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2024 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: sbdif.c,v 1.5 2024/11/10 12:48:25 babolo Exp $"

#define BLIN_COMPAT      4
#define MIFE_COMPAT      5

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <ufs/ffs/fs.h>
#include <babolo/BLINflag.h>
#include <mife.h>
#include "unrmufs2.h"

#define TINT(A)    if  (fs1->A != fs2->A) ifBLIN_QX3("%u %s %d <> %d", n, #A, fs1->A, fs2->A)
#define TUNT(A)    if  (fs1->A != fs2->A) ifBLIN_QX3("%u %s %u <> %u", n, #A, fs1->A, fs2->A)
#define LINT(A)    if  (fs1->A != fs2->A) ifBLIN_QX3("%u %s %ld <> %ld", n, #A, fs1->A, fs2->A)
#define LUNT(A)    if  (fs1->A != fs2->A) ifBLIN_QX3("%u %s %lu <> %lu", n, #A, fs1->A, fs2->A)
#define TTXT(L, A) if  (!!strncmp((char*)&fs1->A, (char*)&fs2->A, L)) {                               \
                       ifBLIN_QX1("%u %s %.*s <> %.*s", n, #A, L, (char*)&fs1->A, L, (char*)&fs2->A); \
                   }

void
/*****************************************************************************************************
 **                                                                                                 **/
unrmufs2_sbdif(unrmufs2_cf *cf, uint32_t n, struct fs *fs1, struct fs *fs2) {                      /**
 **                                                                                                 **
 *****************************************************************************************************/
#   define blin_internal_flags (cf->flags & BLIN_MASK)

    TINT(fs_firstfield);
    TINT(fs_unused_1);
    TINT(fs_sblkno);
    TINT(fs_cblkno);
    TINT(fs_iblkno);
    TINT(fs_dblkno);
    TINT(fs_old_cgoffset);
    TINT(fs_old_cgmask);
    TINT(fs_old_time);
    TINT(fs_old_size);
    TINT(fs_old_dsize);
    TUNT(fs_ncg);
    TINT(fs_bsize);
    TINT(fs_fsize);
    TINT(fs_frag);
    TINT(fs_minfree);
    TINT(fs_old_rotdelay);
    TINT(fs_old_rps);
    TINT(fs_bmask);
    TINT(fs_fmask);
    TINT(fs_bshift);
    TINT(fs_fshift);
    TINT(fs_maxcontig);
    TINT(fs_maxbpg);
    TINT(fs_fragshift);
    TINT(fs_fsbtodb);
    TINT(fs_sbsize);
    TINT(fs_spare1[0]);
    TINT(fs_spare1[1]);
    TINT(fs_nindir);
    TUNT(fs_inopb);
    TINT(fs_old_nspf);
    TINT(fs_optim);
    TINT(fs_old_npsect);
    TINT(fs_old_interleave);
    TINT(fs_old_trackskew);
    TINT(fs_id[0]);
    TINT(fs_id[1]);
    TINT(fs_old_csaddr);
    TINT(fs_cssize);
    TINT(fs_cgsize);
    TINT(fs_spare2);
    TINT(fs_old_nsect);
    TINT(fs_old_spc);
    TINT(fs_old_ncyl);
    TINT(fs_old_cpg);
    TUNT(fs_ipg);
    TINT(fs_fpg);
    TINT(fs_old_cstotal.cs_ndir);
    TINT(fs_old_cstotal.cs_nbfree);
    TINT(fs_old_cstotal.cs_nifree);
    TINT(fs_old_cstotal.cs_nffree);
    TINT(fs_fmod);
    TINT(fs_clean);
    TINT(fs_ronly);
    TINT(fs_old_flags);
    TTXT(MAXMNTLEN, fs_fsmnt);
    TTXT(MAXVOLLEN, fs_volname);
    LUNT(fs_swuid);
    TINT(fs_pad);
    TINT(fs_cgrotor);
//  void *fs_ocsp[NOCSPTRS];
#ifdef FS_OKAY
//  u_int8_t *fs_contigdirs;
//  struct csum *fs_csp;
//  int32_t *fs_maxcluster;
//  u_int *fs_active;
#else
//  struct fs_summary_info *fs_si;
#endif
    TINT(fs_old_cpc);
    TINT(fs_maxbsize);
    LINT(fs_unrefs);
    LINT(fs_providersize);
    LINT(fs_metaspace);
    LINT(fs_sparecon64[0]);
    LINT(fs_sparecon64[1]);
    LINT(fs_sparecon64[2]);
    LINT(fs_sparecon64[3]);
    LINT(fs_sparecon64[4]);
    LINT(fs_sparecon64[5]);
    LINT(fs_sparecon64[6]);
    LINT(fs_sparecon64[7]);
    LINT(fs_sparecon64[8]);
    LINT(fs_sparecon64[9]);
    LINT(fs_sparecon64[10]);
    LINT(fs_sparecon64[11]);
    LINT(fs_sparecon64[12]);
#ifdef FS_OKAY
    LINT(fs_sparecon64[13]);
#else
    LINT(fs_sblockactualloc);
#endif
    LINT(fs_sblockloc);
    LINT(fs_cstotal.cs_ndir);
    LINT(fs_cstotal.cs_nbfree);
    LINT(fs_cstotal.cs_nifree);
    LINT(fs_cstotal.cs_nffree);
    LINT(fs_cstotal.cs_numclusters);
    LINT(fs_cstotal.cs_spare[0]);
    LINT(fs_cstotal.cs_spare[1]);
    LINT(fs_cstotal.cs_spare[2]);
    LINT(fs_time);
    LINT(fs_size);
    LINT(fs_dsize);
    LINT(fs_csaddr);
    LINT(fs_pendingblocks);
    TUNT(fs_pendinginodes);
//  TUNT(fs_snapinum[FSMAXSNAP]);
    TUNT(fs_avgfilesize);
    TUNT(fs_avgfpdir);
    TINT(fs_save_cgsize);
    LINT(fs_mtime);
    TINT(fs_sujfree);
    TINT(fs_sparecon32[0]);
    TINT(fs_sparecon32[1]);
    TINT(fs_sparecon32[2]);
    TINT(fs_sparecon32[3]);
    TINT(fs_sparecon32[4]);
    TINT(fs_sparecon32[5]);
    TINT(fs_sparecon32[6]);
    TINT(fs_sparecon32[7]);
    TINT(fs_sparecon32[8]);
    TINT(fs_sparecon32[9]);
    TINT(fs_sparecon32[10]);
    TINT(fs_sparecon32[11]);
    TINT(fs_sparecon32[12]);
    TINT(fs_sparecon32[13]);
    TINT(fs_sparecon32[14]);
    TINT(fs_sparecon32[15]);
    TINT(fs_sparecon32[16]);
    TINT(fs_sparecon32[17]);
    TINT(fs_sparecon32[18]);
    TINT(fs_sparecon32[19]);
    TINT(fs_sparecon32[20]);
#ifdef FS_OKAY
    TINT(fs_sparecon32[21]);
    TINT(fs_sparecon32[22]);
#else
    TUNT(fs_ckhash);
    TUNT(fs_metackhash);
#endif
    TINT(fs_flags);
    TINT(fs_contigsumsize);
    TINT(fs_maxsymlinklen);
    TINT(fs_old_inodefmt);
    LUNT(fs_maxfilesize);
    LINT(fs_qbmask);
    LINT(fs_qfmask);
    TINT(fs_state);
    TINT(fs_old_postblformat);
    TINT(fs_old_nrpos);
    TINT(fs_spare5[0]);
    TINT(fs_spare5[1]);
    TINT(fs_magic);
#   undef blin_internal_flags
}
