/*-
 * Copyright Sergey Kosyakov ks@itp.ac.ru 1999
 * Copyright (C) @BABOLO  2002 http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright Sergey Kosyakov ks@itp.ac.ru 1999\n\
@(#)Copyright (C) @BABOLO  2002 http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: tund.c,v 1.2 2010/10/18 16:51:36 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <netdb.h>
#include <poll.h>
#include <time.h>
#include <errno.h>
#include "tund.h"

extern char *bindaddr;
int socket_control;
extern int debug;
int control_port;
extern Seq *stun;

static void
proceed_tunnel(int tun_ind) {
    struct sockaddr_in saddr;
    Tunnel *tun, *t;
    int res;
    int sd;
    int i;

    tun = (Tunnel *)stun->buf[tun_ind];

    for (i = 0; i < tun_ind; i++) {
        t = (Tunnel *)stun->buf[i];
        if  (t->dp == tun->dp)
            Error("Illegal configuration: tunnels should have different divert sockets");
        if  (t->tunAddr == tun->tunAddr)
            Error("Illegal configuration: tunnels should have different labels");
    }

    bzero(&saddr, sizeof(saddr));
    saddr.sin_port = htons((unsigned short)tun->dp);
    saddr.sin_family = AF_INET;
    sd = socket(PF_INET, SOCK_RAW, IPPROTO_DIVERT);
    res = bind(sd, (struct sockaddr*)&saddr, sizeof(saddr));
    if  (res) Error("Can not bind to divert port %d\n", tun->dp);
    fcntl(sd, F_SETFL, FNDELAY);                                              /* Set to non-blocking */
    tun->socketDivert = sd;
#ifdef DEBUG
    if  (debug) Log( "Divert port %d is binded to socket %d for t=%d"
                   , tun->dp, tun->socketDivert, tun_ind
                   );
#endif /* DEBUG */
}

static void
do_cycle(struct pollfd *fds, int nfd, CBF *cb) {
    int ret;
    int i;

    while (1) {                                                                             /* Main loop */
        ret = poll(fds, nfd, 15000);
        if  (ret < 0) {
            if  (errno == EINTR) continue;
            Error("Poll returns error %d", ret);
        }
#ifdef DEBUG
        if  (debug) Log("Poll returns %d", ret); 
#endif /*DEBUG*/
        for (i = 0; i < nfd; i++) {
            if  (fds[i].revents) {
#ifdef DEBUG
                if  (debug) Log("Event 0x%x on fd %d", fds[i].revents, fds[i].fd);
#endif /*DEBUG*/
                cb[i].f(cb[i].tun_ind, fds[i].fd);
}   }   }   }

static void
run_loop(int sc) {
    struct pollfd *fds;
    Tunnel *tun;
    CBF *cb;
    int nfd;
    int i;

    socket_control = sc;
    nfd = 1 + stun->length;
    fds = (struct pollfd*)malloc(nfd * sizeof(struct pollfd));
    if  (!fds) Error("Can not allocate memory for pollfd");
    bzero(fds, nfd * sizeof(struct pollfd));

    cb = (CBF*)malloc(nfd * sizeof(CBF));
    if  (!cb) Error("Can not allocate memory for callbacks");
    bzero(cb, nfd * sizeof(CBF));

    for (i = 0; i < stun->length; i++) {
        tun = (Tunnel*)stun->buf[i];
        fds[i].fd = tun->socketDivert;
        fds[i].events = POLLRDNORM;
        cb[i].tun_ind = i;
        cb[i].f = input_divert;
        if  (tun->flags & TUNF_ENC) {
            start_secur_tunnel(i);                            /* Initiate encryption for that tunnel */
        } else {
            tun->state = TUNS_PRC;
    }   }

    fds[stun->length].fd = sc;
    fds[stun->length].events = POLLRDNORM;
    cb[stun->length].f = read_packet;
    cb[stun->length].tun_ind = -1;                                           /*Does have no any means*/
    do_cycle(fds, nfd, cb);
}

void
do_it() {
    int i;
    int sc;
    struct addrinfo hints, *r;
    int res;

    memset(&hints, 0, sizeof(hints));
    hints.ai_flags = AI_PASSIVE;
    hints.ai_family = PF_INET;
    hints.ai_socktype = SOCK_DGRAM;
    res=getaddrinfo(bindaddr, "tund", &hints, &r);
    if  (res < 0) {
        Log("Error %s from getaddrinfo(%s)", strerror(errno), bindaddr);
        exit(1);
    }
    sc = socket(r->ai_family, r->ai_socktype, r->ai_protocol);/* There is list by r->ai_next pointer */
    res = bind(sc, r->ai_addr, r->ai_addrlen);
    if  (res) Error("Can not bind to control port %d\n", sc);
    fcntl(sc, F_SETFL, FNDELAY);                                                     /* Non-blocking */
    for (i = 0; i < stun->length; i++) proceed_tunnel(i);         /* Set up tunnel(s) divert sockets */
    Log("sc=%d", sc);
    run_loop(sc);
}
