/*-
 * Copyright Sergey Kosyakov ks@itp.ac.ru 1999
 * Copyright (C) @BABOLO  2002 http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright Sergey Kosyakov ks@itp.ac.ru 1999\n\
@(#)Copyright (C) @BABOLO  2002 http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: main.c,v 1.2 2010/10/18 16:51:36 babolo Exp $";
#endif /* not lint */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <unistd.h>
#include <errno.h>
#include <netdb.h>
#include "tund.h"

int debug=0;
Seq *stun;
char *bindaddr;

int
main(int argc, char **argv) {
    char **p;
    int ret;
    int i;

    bindaddr = NULL;
    p = argv;
    while (*p) {
        if  (strcmp(*p, "-d") == 0) {
            debug=1;
        } else if(strcmp(*p, "-b") == 0) {
          p++;
          bindaddr = *p;
        }
        p++;
    }
    if  (debug) {
        printf("Entering debug mode\n");
        tund_lock();
    } else {
        printf("To daemon...\n"); /*to daemon*/
        ret = fork();
        if  (ret < 0) {
            perror("Can not fork");
            exit(1);
        }
        if  (ret) exit(0);
        /*Child*/
        freopen("/dev/null", "r", stdin);
        freopen("/dev/null", "w", stdout);
        freopen("/dev/null", "w", stderr);
        for (i = 3; i < getdtablesize(); i++) close(i);
        if  (setsid() < 0) Error("setsid: %s", strerror(errno));
        tund_lock();
    }
    stun = seq_new();
    if  (parse_config()) {
        Log("Error while parsing config file");
        exit(1);
    }
    init_rng();
    init_secur();
    init_alarm();
    do_it();
    exit(1);
}
