/*-
 * Copyright Sergey Kosyakov ks@itp.ac.ru 1999
 * Copyright (C) @BABOLO  2002 http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright Sergey Kosyakov ks@itp.ac.ru 1999\n\
@(#)Copyright (C) @BABOLO  2002 http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: rsa_kg.c,v 1.2 2010/10/18 16:51:36 babolo Exp $";
#endif /* not lint */

#include <openssl/rand.h>
#include <openssl/rsa.h>
#include <sys/types.h>
#include <sys/time.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include "tund.h"

void
kgf_cb(int n, int num, void *arg) {
    char c;

    c = (n == 0) ? '-' : ((n == 1) ? '=' : ((n == 2) ? '+' : '*'));
    printf("%c", c);
    if  (n == 3) printf("\n");
    fflush(stdout);
}

int
main(int argc, char **argv) {
    unsigned char *pp,*p;
    struct timeval tp;
    unsigned int n;
    int keylen;
    double dn;
    RSA *rsa;
    int ret;
    FILE *f;
    int fd;
    int i;

    if  (argc == 2) keylen = atoi(argv[1]); else keylen = 1024;
    printf("Generating new %d bits RSA key:\n", keylen);
    ret = gettimeofday(&tp, NULL);
    if  (ret) {
        printf("Can not get time.\n");
        exit(1);
    }
    RAND_seed(&tp, sizeof(tp));
    rsa = RSA_generate_key(keylen, 3, kgf_cb, NULL);
    if  (!rsa) {
        printf("Error while RSA_generate_key.\n");
        exit(1);
    }
    f = fopen(RSAKEY_FILE, "w");
    if  (f < 0) {
        printf("Can not open rsa_priv.key\n");
        exit(1);
    }
    ret = i2d_RSAPrivateKey(rsa, NULL);
    printf("i2d_RSAPrivateKey returns %d\n", ret);
    pp = (unsigned char *)malloc(ret);
    bzero(pp, ret);
    p = pp;
    ret = i2d_RSAPrivateKey(rsa, &pp);
    for (i = 0; i < ret; i++) {
        fprintf(f, "%02x", p[i]);
    }
    fclose(f);

    /*Now generating RNG seed*/
    printf("Generating RND seed\n");
    fd = open(SEED_FILE, O_CREAT | O_WRONLY | O_TRUNC, 0644);
    if  (fd < 0) {
        perror("Can not get time"); /* XXXX time??? */
        exit(1);
    }
    ret = gettimeofday(&tp, NULL);
    if  (ret) {
        printf("Can not get time.\n");
        exit(1);
    }
    srand48(tp.tv_usec);
    do {
        dn = drand48();
        n = (int)(9689.0 * dn);
    } while(n == 0 || n == 9689);
    printf("F=%d\n", n);
    ret = write(fd, &n, 4);
    if  (ret != 4) {
        perror("Can not create seed file");
        exit(1);
    }
    for (i = 0; i < 9689; i++) {
        n = lrand48();
        ret = write(fd, &n, 4);
        if  (ret != 4) {
            perror("Can not write seed");
            exit(1);
    }   }
    close(fd);
    exit(0);
}
