/*-
 * Copyright Sergey Kosyakov ks@itp.ac.ru 1999
 * Copyright (C) @BABOLO  2002 http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright Sergey Kosyakov ks@itp.ac.ru 1999\n\
@(#)Copyright (C) @BABOLO  2002 http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: pkey_gen.c,v 1.1 2010/10/15 11:32:04 babolo Exp $";
#endif /* not lint */

#include <openssl/rsa.h>
#include <sys/types.h>
#include <sys/time.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <stdio.h>
#include "tund.h"

static char hostname[128];
static RSA *rsa_priv = NULL;
static unsigned char *rsa_pub = NULL;
static unsigned int len_rsa_pub = 0;


int
main(int argc, char **argv) {
    unsigned char key[8192];
    unsigned char *p;
    unsigned int n;
    RSA *rsa;
    FILE *f;
    int ret;
    int len;
    int i;

    if  (argc < 2) {
        printf("Usage: %s private_key_file\n", argv[0]);
        exit(1);
    }
    bzero(hostname, 128);
    ret = gethostname(hostname, 127);
    f = fopen(argv[1], "r");
    if  (!f) {
        printf("Can not open %s\n", argv[1]);
        exit(1);
    }
    bzero(key, 8192);
    len = 0; 
    do {
        ret = fscanf(f, "%2x", &n);
        if  (ret != 1) break;
        key[len] = n;
        len++;
    } while(len < 8190);
    printf("Read %d bytes as RSA private key\n", len);
    fclose(f);
    p = key;
    rsa = d2i_RSAPrivateKey(&rsa_priv, &p, (long)len);
    if  (!rsa || !rsa_priv) {
        printf("Error while d2i_RSAPrivateKey\n");
        exit(1);
    }
    len_rsa_pub = i2d_RSAPublicKey(rsa_priv, NULL);
    printf("i2d_RSAPublicKey returns %d\n", len_rsa_pub);
    rsa_pub = (unsigned char *)malloc(len_rsa_pub);
    if  (!rsa_pub) {
        printf("Can not allocate %d bytes for RSA pk\n", len_rsa_pub);
        exit(1);
    }
    bzero(rsa_pub, len_rsa_pub);
    p = rsa_pub;
    i2d_RSAPublicKey(rsa_priv, &p);
    f = fopen(RSAPUBKEY_FILE, "w");
    if  (!f) {
        printf("Can not open %s\n", RSAPUBKEY_FILE);
        exit(1);
    }
    fprintf(f, "%s ", hostname);
    for (i = 0; i < len_rsa_pub; i++) {
        fprintf(f, "%02x", rsa_pub[i]);
    }
    fprintf(f, "\n");
    fclose(f);
    printf("Done.\n");
    exit(0);
}
