/*-
 * Copyright Sergey Kosyakov ks@itp.ac.ru 1999
 * Copyright (C) @BABOLO  2002 http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright Sergey Kosyakov ks@itp.ac.ru 1999\n\
@(#)Copyright (C) @BABOLO  2002 http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: cipher.c,v 1.2 2010/10/18 16:51:36 babolo Exp $";
#endif /* not lint */

#include <openssl/blowfish.h>
#include <openssl/rc5.h>
#include <stdlib.h>
#ifndef NO_IDEA
# include <openssl/idea.h>
#endif
#include "tund.h"

static unsigned char ivec_ini[8] = {"kjsLd5Gh"};
static unsigned char iv_buf[8];
extern int debug;
extern Seq *stun;

static void *
must_malloc(int size) {
    void *ret;

    ret = malloc(size);
    if  (!ret) Error("Can not allocate %d bytes in must_malloc", size);
    return(ret);
}

void
set_cipher_key(int tun_ind, int remote) {
#ifndef NO_IDEA
    IDEA_KEY_SCHEDULE *idea_key1, *idea_key2;
#endif
    RC5_32_KEY *rc5_key;
    unsigned char *data;
    BF_KEY *bf_key;
    Tunnel *tun;
    int cipher;
    void *key;

    tun = (Tunnel *)stun->buf[tun_ind];
    cipher = (tun->flags) >> 16;
    if  (remote) {
        if  (tun->remoteCipherKey) free(tun->remoteCipherKey);
        tun->remoteCipherKey = NULL;
        data = tun->remote_key;
    } else {
        if  (tun->localCipherKey) free(tun->localCipherKey);
        tun->localCipherKey = NULL;
        data = tun->local_key;
    }
    switch(cipher) {
    case TUN_CIPHER_BF:
        bf_key = must_malloc(sizeof(BF_KEY));
        BF_set_key(bf_key, 16, data);
        key = bf_key;
        break;
#ifndef NO_IDEA
    case TUN_CIPHER_IDEA:
        idea_key1 = must_malloc(sizeof(IDEA_KEY_SCHEDULE));
        idea_set_encrypt_key(data, idea_key1);
        if  (remote) {
            idea_key2 = must_malloc(sizeof(IDEA_KEY_SCHEDULE));
            idea_set_decrypt_key(idea_key1, idea_key2);
            free(idea_key1);
            idea_key1 = idea_key2;
        }
        key = idea_key1;
        break;
#endif
    case TUN_CIPHER_RC5:
        rc5_key = must_malloc(sizeof(RC5_32_KEY));
        RC5_32_set_key(rc5_key, 16, data, RC5_8_ROUNDS);
        key = rc5_key;
        break;
    default:
        Error("Unknown cipher %d", cipher);
        exit(1);
    }
    if  (remote) tun->remoteCipherKey = key; else tun->localCipherKey = key;
#ifdef DEBUG
    if  (debug) Log( "New %s key for cipher %d for tunnel [%s]"
                   , remote ? "remote" : "local"
                   , cipher
                   , tun->label
                   );
#endif /* DEBUG */
}

int
cipher_encrypt(unsigned char *in, unsigned char *out, int len, int tun_ind) {
#ifndef NO_IDEA
    IDEA_KEY_SCHEDULE *idea_key;
#endif
    Tunnel *tun = (Tunnel *)stun->buf[tun_ind];
    int cipher;
    BF_KEY *bf_key;
    RC5_32_KEY *rc5_key;
    int length;

    length = ((len / 8) + 1) * 8;
    cipher = (tun->flags) >> 16;
    switch(cipher) {
    case TUN_CIPHER_BF:
        bf_key = tun->localCipherKey;
        bcopy(ivec_ini, iv_buf, 8);
        BF_cbc_encrypt(in, out, length, bf_key, iv_buf, BF_ENCRYPT);
        return(length);
#ifndef NO_IDEA
    case TUN_CIPHER_IDEA:
        idea_key = tun->localCipherKey;
        bcopy(ivec_ini, iv_buf, 8);
        idea_cbc_encrypt(in, out, length, idea_key, iv_buf, IDEA_ENCRYPT);
        return(length);
#endif
    case TUN_CIPHER_RC5:
        rc5_key = tun->localCipherKey;
        bcopy(ivec_ini, iv_buf, 8);
        RC5_32_cbc_encrypt(in, out, length, rc5_key, iv_buf, RC5_ENCRYPT);
        return(length);
    default:
        Error("Unknown cipher %d", cipher);
    }
    return(-1);
}

void
cipher_decrypt(unsigned char *in, unsigned char *out, int len, int tun_ind) {
#ifndef NO_IDEA
    IDEA_KEY_SCHEDULE *idea_key;
#endif
    Tunnel *tun=(Tunnel*)stun->buf[tun_ind];
    RC5_32_KEY *rc5_key;
    BF_KEY *bf_key;
    int cipher;
    int length;

    length=len;

    cipher=(tun->flags)>>16;
    switch(cipher) {
    case TUN_CIPHER_BF:
        bf_key = tun->remoteCipherKey;
        bcopy(ivec_ini, iv_buf, 8);
        BF_cbc_encrypt(in, out, length, bf_key, iv_buf, BF_DECRYPT);
        break;
#ifndef NO_IDEA
    case TUN_CIPHER_IDEA:
        idea_key = tun->remoteCipherKey;
        bcopy(ivec_ini, iv_buf, 8);
        idea_cbc_encrypt(in, out, length, idea_key, iv_buf, IDEA_DECRYPT);
        break;
#endif
    case TUN_CIPHER_RC5:
        rc5_key = tun->remoteCipherKey;
        bcopy(ivec_ini, iv_buf, 8);
        RC5_32_cbc_encrypt(in, out, length, rc5_key, iv_buf, RC5_DECRYPT);
        break;
    default:
        Error("Unknown cipher %d", cipher);
}   }
