/*-
 * Copyright (C)2020..2025 @BABOLO http://www.babolo.ru/
 * Inspired by su2-1.3.
 * This version written from scratch and FreeBSD's /usr/bin/su
 *
 * Copyright (c) 2002, 2005 Networks Associates Technologies, Inc.
 * All rights reserved.
 *
 * Portions of this software were developed for the FreeBSD Project by
 * ThinkSec AS and NAI Labs, the Security Research Division of Network
 * Associates, Inc.  under DARPA/SPAWAR contract N66001-01-C-8035
 * ("CBOSS"), as part of the DARPA CHATS research program.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Copyright (c) 1988, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2020..2025 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: su2.c,v 1.43 2025/12/21 19:16:40 babolo Exp $"

#define BLIN_COMPAT  3
#define Bpars_COMPAT 4
#define MIFE_COMPAT  5

#include <sys/mount.h>
#include <sys/types.h>
#include <sys/event.h>

#ifdef BLIN_OSLinux
# include <sys/vfs.h>
# include <sys/statvfs.h>
#else
# include <login_cap.h>
#endif

#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/uio.h>

#ifndef BLIN_OSLinux
# include <sys/ktrace.h>
#endif

#include <sysexits.h>
#include <string.h>
#include <stdlib.h>
#include <syslog.h>
#include <unistd.h>
#include <signal.h>
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <pwd.h>
#include <err.h>

#ifndef BLIN_OSLinux
# include <security/pam_appl.h>
#endif

#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <mife.h>
#include "su2.h"
#include "su2_env.h"

__attribute__((__noreturn__)) static void
usage(int ex) {
    fprintf( stderr
           , "su2 @BABOLO V.M "VERS"  "DATE" http://www.babolo.ru/\n"
             "     Switch user rights\n"
             "Usage: su2 [-OPTIONS] [toUNAME] [-c command | -- prog args...]\n"
             "    -- ...      - execve(...)\n"
             "    -           - login\n"
             "    -a UNAME    - use UNAMEs(or UIDs) access rights\n"
             "    -c COMMAND  - exec '/bin/sh -c command'\n"
             "    -d          - run /bin/csh\n"
             "    -f FILE     - run /bin/sh file\n"
             "    -l          - login\n"
             "    -n NICE     - nice\n"
             "    -q          - quiet\n"
             "    -s          - register new UID in utmp\n"
             "    -t CLASS    - login class\n"
             "    -u UNAME    - switsh to UNAME(or UID), mandatory password with -f\n"
             "    -v[v[v...]] - verbose\n"
           )
    ;
    exit(ex);
}

int
main(int argc, char *argv[]) {
    int                  statusp;
    struct sigaction     sa_pipe;
    struct sigaction     sa_quit;
    struct sigaction     sa_int;
    pid_t                gchild;
    pid_t                child;
    const char          *flar    = "-a:c:df:ln:qst:u:v=:?";
    int                  temp;
    int                  fds[2];
    int                  xfd;
    pid_t                pid;
    babolo_opts         *bos     = NULL;
    su2_cf              *cf      = NULL;
    struct sigaction     sa;
#ifndef BLIN_OSLinux
    login_cap_t         *lc;
#endif
    int                  ex      = EX_OK;
    const char          *o;
    int                  c;

#if 0
    {   int f = open("ktrace.in", O_RDWR | O_TRUNC | O_CREAT, 0666);
        close(f);
        ktrace( "ktrace.in"
              , KTROP_SET
              , KTRFAC_SYSCALL
              | KTRFAC_SYSRET
              | KTRFAC_NAMEI
              | KTRFAC_GENIO
              | KTRFAC_PSIG
              | KTRFAC_CSW
              | KTRFAC_USER
              | KTRFAC_STRUCT
              | KTRFAC_SYSCTL
              | KTRFAC_PROCCTOR
              | KTRFAC_PROCDTOR
              | KTRFAC_CAPFAIL
              | KTRFAC_FAULT
              | KTRFAC_FAULTEND
              | KTRFAC_INHERIT
              , getpid()
              );
    }
#endif
    if  (!(cf = calloc(1, sizeof(*cf)))) {
        warnx("Malloc failed #1");
        errno = ENOMEM;
        ex = EX_OSERR;
        goto out;
    }
#   define blin_internal_flags (cf->flags)
    openlog("su2", LOG_CONS, LOG_AUTH);
    BLIN_VERBOSE(cf->flags);
    cf->arsz = argc + ARGSHIFT + 3;
    if  (!(cf->args = malloc(cf->arsz * sizeof(char *)))) {
        ifBLIN_QW0("Malloc failed #2");
        errno = ENOMEM;
        ex = EX_OSERR;
        goto out;
    }
    if  (!(bos = babolo_openopts(Bpars_NONU | Bpars_SYME, 'Z'))) {
        ifBLIN_QW0("babolo_openopts");
        ex = EX_SOFTWARE;
        goto out;
    }
    if  (babolo_setopts(bos, Bpars_NONU, argc, argv, flar)) {
        ifBLIN_QW0("babolo_setopts");
        ex = EX_SOFTWARE;
        goto out;
    }
    for (; ;) {
        c = babolo_getopts(bos);
        ifBLIN_QX4("-%c(%02X)%02X", c ? c : 1, c, bos->c);
        if  (!c) break;
        if  (0 > c) {
            ifBLIN_QW0("babolo_getopts -%c(%02X)", bos->c, bos->c & 0x00FF);
            ex = EX_USAGE;
            goto out;
        }
        switch (c) {
        case '-':
        case 'l': cf->flags |= SU2_LOGIN;
                ; break;
        case 'a': if  (!(o = babolo_getoptsarg(bos))) {
                ;     ifBLIN_QW0("No -%c arg", bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; if  (!!cf->frompw) {
                ;     ifBLIN_QX1("Redefined -%c option: %s->%s", bos->c, cf->frompw->pw_name, o);
                ; }
                ; if  (!!su2_iniud(cf, bos->c, o, &cf->frompw, 0)) {
                ;     ifBLIN_QW0("No %s fromUID", o);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; break;
        case 'c': if  (!(o = babolo_getoptsarg(bos))) {
                ;     ifBLIN_QW0("No -%c arg", bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; if  (!!cf->command) {
                ;     ifBLIN_QX1("Redefined -%c option: %s->%s", bos->c, cf->command, o);
                ; }
                ; if  (!(cf->command = strdup(o))) {
                ;     ifBLIN_QW0("strdup=%s~", o);
                ;     ex = EX_OSERR;
                ;     goto out;
                ; }
                ; break;
        case 'd': cf->flags |= SU2_CSH;
                ; break;
        case 'f': if  (!(o = babolo_getoptsarg(bos))) {
                ;     ifBLIN_QW0("No -%c arg", bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; if  (!!cf->xfile) ifBLIN_QX1("Redefined -%c option: %s->%s", bos->c, cf->xfile, o);
                ; if  (!(cf->xfile = strdup(o))) {
                ;     ifBLIN_QW0("strdup=%s~", o);
                ;     ex = EX_OSERR;
                ;     goto out;
                ; }
                ; cf->flags |= SU2_XFILE;
                ; break;
        case 'n': {   int n = 0;

                ;     if  (SU2_NICE & cf->flags) {
                ;         cf->flags |= SU2_RENICE;
                ;         n = cf->nice;
                ;     }
                ;     cf->flags |= SU2_NICE;
                ;     errno = 0;
                ;     cf->nice = (int)babolo_getoptsnum(bos, 0);
                ;     if  (!!errno) {
                ;         ifBLIN_QW0("babolo_getoptunum");
                ;         ex = EX_USAGE;
                ;         goto out;
                ;     }
                ;     if  (SU2_RENICE & cf->flags) {
                ;         ifBLIN_QX1("Redefined -%c option: %d->%d", bos->c, n, cf->nice);
                ; }   }
                ; break;
        case 'q': BLIN_QUIET(cf->flags);
                ; break;
        case 's': cf->flags |= SU2_UREG;
                ; break;
        case 't': if  (!(o = babolo_getoptsarg(bos))) {
                ;     ifBLIN_QW0("No -%c arg", bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; if  (!!cf->class) {
                ;     ifBLIN_QX1("Redefined -%c option: %s->%s", bos->c, cf->class, o);
                ; }
                ; cf->class = optarg;
                ; break;
        case 'u': if  (!(o = babolo_getoptsarg(bos))) {
                ;     ifBLIN_QW0("No -%c arg", bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; if  (!!cf->topw) {
                ;     ifBLIN_QX1("Redefined -%c option: %s->%s", bos->c, cf->topw->pw_name, o);
                ; }
                ; if  (!!su2_iniud(cf, bos->c, o, &cf->topw, 0)) {
                ;     ifBLIN_QW0("No %s toUID", o);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; break;
        case 'v': BLIN_VERBOSE(cf->flags);
                ; break;
        case '=': if  (!(o = babolo_getoptsarg(bos))) {
                ;     ifBLIN_QW0("No -%c arg", bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; switch(o[0]) {
                  case '0': blin_ctl(BLIN_CTL_DUMP);    exit(EX_OK);
                  case '1': babolo_optest(flar);        exit(EX_OK);
                  case '2': babolo_optext(bos);         exit(EX_OK);
                  case '3': babolo_dumpopts(bos);       exit(EX_OK);
                  case 'D': cf->flags |= SU2_DUMP; break;
                  default : usage(EX_USAGE);
                  }
                ; break;
        case '?': usage(EX_OK);
        default : ifBLIN_QX0("Illegal flag -%c", c);
                ; usage(EX_USAGE);
    }   }
    ifBLIN_QX4("%08X %08X", bos->flags, Bpars_DASH);
    if  (Bpars_DASH & bos->flags) cf->flags |= SU2_DASH;
    cf->argp = cf->amax = ARGSHIFT;
    for (cf->args[cf->amax] = NULL; ;) {
        if  (  (cf->arsz <= cf->amax)
            && !(cf->args = realloc(cf->args, (cf->arsz *= 2) * sizeof(char *)))
            ) {
            ifBLIN_QW0("Realloc failed");
            ex = EX_OSERR;
            goto out;
        }
        o = babolo_getargs(bos);
        if  (!o) {
            cf->args[cf->amax++] = NULL;
            break;
        } else if (!(cf->args[cf->amax++] = strdup(o))) {
            ifBLIN_QW0("strdup");
            ex = EX_OSERR;
            goto out;
        }
        ifBLIN_QX4("[%d]=%s~", cf->amax - 1, cf->args[cf->amax - 1]);
    }
    if  (!!geteuid()) {
        ifBLIN_QX0("Not running setuid root");
        ex = EX_USAGE;
        goto out;
    }
    cf->uid = getuid();
    cf->gid = getgid();
    if  (!!su2_iniud(cf, ':', getlogin(), &cf->mypw, cf->uid)) {
        ifBLIN_QW0("No my UID %d", cf->uid);
        ex = EX_USAGE;
        goto out;
    }
    if  (!cf->frompw && !!su2_iniud(cf, '-', NULL, &cf->frompw, cf->uid)) {
        ifBLIN_QW0("No fromUID");
        ex = EX_OSERR;
        goto out;
    }
    ifBLIN_QX2("%08X", cf->flags);
    if  (SU2_XFILE & cf->flags) { /*  su2 -f, ,  */
        struct stat   sb;
        struct statfs mb;

    ;   if  (0 > (xfd = open(cf->xfile, O_RDONLY
#ifndef BLIN_OSLinux
                                      | O_SHLOCK
#endif
            )    )          ) {
    ;       ifBLIN_QW0("Script %s open", cf->xfile);
    ;       ex = EX_IOERR;
    ;       goto out;
    ;   }
    ;   if  (!!fstat(xfd, &sb)) {
    ;       ifBLIN_QW0("Script %s fstat", cf->xfile);
    ;       ex = EX_IOERR;
    ;       goto out;
    ;   }
    ;   if  (!!fstatfs(xfd, &mb)) {
    ;       ifBLIN_QW0("Script %s statfs", cf->xfile);
    ;       ex = EX_IOERR;
    ;       goto out;
    ;   }
    ;   if  (!(S_ISUID & sb.st_mode) || (
#ifdef BLIN_OSLinux
                                         (MS_NOEXEC | ST_NOSUID)
#else
                                         (MNT_NOSUID | MNT_NOEXEC)
#endif
                                        & mb.f_flags
            )                           ) {
    ;       cf->flags &= ~SU2_XFILE;
    ;       if  (!cf->topw && !!su2_iniud(cf, ':', "root", &cf->topw, 0)) {
    ;           ifBLIN_QW0("No root toUID");
    ;           ex = EX_NOPERM;
    ;           goto out;
    ;       }
    ;   } else if ((S_IWOTH | S_IWGRP | S_IWUSR) & sb.st_mode) {
    ;       ifBLIN_QX1("SUID excess permissions on script");
    ;       cf->flags &= ~SU2_XFILE;
    ;   } else if (  ((sb.st_uid != cf->mypw->pw_uid) || !(S_IXUSR & sb.st_mode))
                  && ((sb.st_gid != cf->mypw->pw_gid) || !(S_IXGRP & sb.st_mode))
                  && !(S_IXOTH & sb.st_mode)
                  ) {
    ;       ifBLIN_QX1( "SUID permission denied %u:%u %u:%u %08o %08o %08o %08o"
                      , cf->mypw->pw_uid
                      , cf->mypw->pw_gid
                      , sb.st_uid
                      , sb.st_gid
                      , sb.st_mode
                      , S_IXUSR
                      , S_IXGRP
                      , S_IXOTH
                      );
    ;       cf->flags &= ~SU2_XFILE;
    ;   } else if (!!cf->topw) {
    ;       if  (cf->topw->pw_uid != sb.st_uid) {
    ;           ifBLIN_QX1("SUID incorrect permissions in script");
    ;           cf->flags &= ~SU2_XFILE;
    ;       }
    ;   } else {
    ;       cf->flags |= SU2_XPASS;
    ;       if  (!!su2_iniud(cf, 0, NULL, &cf->topw, sb.st_uid)) {
    ;           ifBLIN_QW0("No %u toUID", sb.st_uid);
    ;           ex = EX_NOPERM;
    ;           goto out;
    ;   }   }
        ifBLIN_QX2("%08X", cf->flags);
    } else if (!(SU2_DASH & cf->flags)) {
        ifBLIN_QX4("DASH 0=%s~", !cf->args[ARGSHIFT] ? "" : cf->args[ARGSHIFT]);
    ;   if  (!cf->topw && !!su2_iniud(cf, '-', cf->args[ARGSHIFT], &cf->topw, 0)) {
    ;       ifBLIN_QW0("No %s toUID", !cf->args[ARGSHIFT] ? "root" : cf->args[ARGSHIFT]);
    ;       ex = EX_USAGE;
    ;       goto out;
    ;   }
    ;   if  (!!cf->args[ARGSHIFT]) {
    ;       ifBLIN_QX6("%"BLIN_X, BLIN_I(cf->args[ARGSHIFT]));
    ;       ifBLIN_QX4("%d[%d]=%s~", cf->argp, ARGSHIFT, cf->args[ARGSHIFT]);
    ;       ++cf->argp;
    ;   }
    ;   if  (!!cf->args[ARGSHIFT + 1]) {
    ;       ifBLIN_QX6("%"BLIN_X, BLIN_I(cf->args[ARGSHIFT + 1]));
    ;       ifBLIN_QX4("1=%s~", cf->args[ARGSHIFT + 1]);
    ;       if  (!strncmp(cf->args[ARGSHIFT + 1], "-c", 2)) {
    ;           ifBLIN_QX4("-c");
    ;           if  (2 < strnlen(cf->args[ARGSHIFT + 1], 3)) {
    ;               if  (!!cf->command) {
    ;                   ifBLIN_QX1( "Command redefined from=%s~ to=%s~"
                                  , cf->command
                                  , &cf->args[ARGSHIFT + 1][2]
                                  );
    ;               }
    ;               if  (!(cf->command = strdup(&cf->args[ARGSHIFT + 1][2]))) {
    ;                   ifBLIN_QW0("strdup=%s~", &cf->args[ARGSHIFT + 1][2]);
    ;                   ex = EX_OSERR;
    ;                   goto out;
    ;               }
    ;           } else if (!!cf->args[ARGSHIFT + 2]) {
    ;               ifBLIN_QX4("2=%s~", cf->args[ARGSHIFT + 2]);
    ;               if  (!!cf->command) {
    ;                   ifBLIN_QX1( "Command redefined from=%s~ to=%s~"
                                  , cf->command
                                  , cf->args[ARGSHIFT + 2]
                                  );
    ;               }
    ;               if  (!(cf->command = strdup(cf->args[ARGSHIFT + 2]))) {
    ;                   ifBLIN_QW0("strdup=%s~", cf->args[ARGSHIFT + 2]);
    ;                   ex = EX_OSERR;
    ;                   goto out;
    ;               }
    ;           } else {
    ;               ifBLIN_QX0("Command omited");
    ;               ex = EX_USAGE;
    ;               goto out;
    ;           }
    ;       } else if (!!strcmp(cf->args[ARGSHIFT + 1], "--")) {
    ;           ifBLIN_QX0("No --");
    ;           ex = EX_USAGE;
    ;           goto out;
    ;       } else {
    ;           cf->flags |= SU2_DASH;
    ;           ++cf->argp;
        }   }
    } else if (!cf->topw && !!su2_iniud(cf, ':', "root", &cf->topw, 0)) {
        ifBLIN_QW0("No root toUID");
    ;   ex = EX_USAGE;
        goto out;
    }
    if  (!cf->frompw) {
        ifBLIN_QX0("Unknown fromUID");
        ex = EX_USAGE;
        goto out;
    }
    if  (!cf->topw) {
        ifBLIN_QX0("Unknown toUID");
        ex = EX_USAGE;
        goto out;
    }
    /* cf->mypw   --                                            *
     * cf->frompw --   ,     *
     * cf->topw   --                                      */
    ifBLIN_QX2("my %u, from %u, to %u", cf->mypw->pw_uid, cf->frompw->pw_uid, cf->topw->pw_uid);
    if  (!!(ex = su2_shell(cf))) {
        ifBLIN_QX0("su2_shell");
        goto out;
    }
    if  (!!(ex = su2_nice(cf))) {
        ifBLIN_QX0("su2_nice");
        goto out;
    }
    if  (!!(ex = su2_tty(cf))) {
        ifBLIN_QX0("su2_tty");
        goto out;
    }
    if  (SU2_DUMP & cf->flags) su2_dump(cf);
    if  (!!(ex = su2_rc(cf))) {
        ifBLIN_QX0("su2_rc");
        goto out;
    }
    if  (!(SU2_XFILE & cf->flags) && !((SU2_NOCHCK | SU2_UFOUND) & (cf->cond | cf->next))) {
        su2_log(cf, 0);
        ifBLIN_QX0("Denied");
        ex = EX_NOPERM;
        goto out;
    }
#ifndef BLIN_OSLinux
    if  (!!(ex = su2_auth(cf))) {
        ifBLIN_QX0("Not preauthorized");
        ex = EX_NOPERM;
        goto out;
    }
#endif
    do {
        if  (!cf->uid) {
            ifBLIN_QX2("OK root");
            break;
        }
        if  (  (cf->uid == cf->frompw->pw_uid)
            && (  ((cf->next | cf->cond) & SU2_NOPASS)
               || !((SU2_XFILE | SU2_XPASS) & ~cf->flags)
            )  ) {
            ifBLIN_QX2("OK NOPASS %u %u %02X %02X", cf->frompw->pw_uid, cf->uid, cf->cond, cf->next);
            break;
        }
        if  (!(ex = su2_inpass(cf))) {
            ifBLIN_QX2("OK PASS");
            break;
        }
        su2_log(cf, 0);
        ifBLIN_QX0("Not authorized");
        ex = EX_NOPERM;
        goto out;
    } while(0);
    su2_log(cf, 1);
    if  (!!(ex = su2_reg(cf, 1))) {
        ifBLIN_QW0("su2_reg in");
        goto out;
    }
#ifndef BLIN_OSLinux
    if  (!cf->class) {
        if  (!(lc = login_getpwclass(cf->topw))) {
            ifBLIN_QW0("login_getpwclass %u", cf->topw->pw_uid);
            ex = EX_OSERR;
            goto out;
        }
    } else if (!!cf->mypw->pw_uid || !!cf->topw->pw_uid) {
        ifBLIN_QX0("Only root may use -t, now %u -> %u", cf->mypw->pw_uid, cf->topw->pw_uid);
        ex = EX_NOPERM;
        goto out;
    } else if (!(lc = login_getclass(cf->class))) {
        ifBLIN_QW0("login_getclass %s", cf->class);
        ex = EX_OSERR;
        goto out;
    } else {
        ifBLIN_QX6("login_getclass %s OK", cf->class);
    }
    if  (!!cf->class && (!lc->lc_class || !!strcmp(cf->class, lc->lc_class))) {
        ifBLIN_QX0("Unknown class: %s", cf->class);
        ex = EX_USAGE;
        goto out;
    }
    /* PAM modules might add supplementary groups in pam_setcred(), so initialize them first. */
    if  (0 > setusercontext(lc, cf->topw, cf->topw->pw_uid, LOGIN_SETGROUP)) {
        ifBLIN_QW0("setusercontext");
        ex = EX_OSERR;
        goto out;
    }
    if  (PAM_SUCCESS != (cf->pamret = pam_setcred(cf->pamh, PAM_ESTABLISH_CRED))) {
        ifBLIN_QX0("pam_setcred: %s", pam_strerror(cf->pamh, cf->pamret));
        ex = EX_OSERR;
        goto out;
    }
    if  (  (SU2_LOGIN & cf->flags)
        && (PAM_SUCCESS != (cf->pamret = pam_open_session(cf->pamh, 0)))
        ) {
        ifBLIN_QX0("pam_open_session: %s", pam_strerror(cf->pamh, cf->pamret));
        ex = EX_OSERR;
        goto out;
    }
#endif
    sa.sa_flags = SA_RESTART;
    sa.sa_handler = SIG_IGN;
    sigemptyset(&sa.sa_mask);
    sigaction(SIGINT, &sa, &sa_int);
    sigaction(SIGQUIT, &sa, &sa_quit);
    sigaction(SIGPIPE, &sa, &sa_pipe);
    sa.sa_handler = SIG_DFL;
    sigaction(SIGTSTP, &sa, NULL);
    statusp = 1;
    if  (pipe(fds) == -1) {
        ifBLIN_QX0("pipe");
        ex = EX_IOERR;
#ifndef BLIN_OSLinux
        if  (!!su2_pamend(cf)) ifBLIN_QX1("su2_pamend");
#endif
        goto out;
    }
    switch ((child = fork())) {
    case -1:
        ifBLIN_QW0("fork");
        ex = EX_OSERR;
#ifndef BLIN_OSLinux
        if  (!!su2_pamend(cf)) ifBLIN_QX1("su2_pamend");
#endif
        goto out;
    case 0 :
        close(fds[1]);
        read(fds[0], &temp, 1);
        close(fds[0]);
        sigaction(SIGPIPE, &sa_pipe, NULL);
        sigaction(SIGINT, &sa_int, NULL);
        sigaction(SIGQUIT, &sa_quit, NULL);
        if  (!!(ex = su2_posenv( cf
#ifndef BLIN_OSLinux
                               , lc
#endif
            )  )               ) {
            ifBLIN_QW0("su2_posenv");
            goto out;
        }
#ifndef BLIN_OSLinux
        login_close(lc);
#endif
        if  ((SU2_DASH & cf->flags) || !!cf->xfile) cf->shell = cf->args[cf->argp];
        ifBLIN_QX3("to execv %s(%d..%d)", !cf->shell ? "" : cf->shell, cf->argp, cf->amax);
        for (uint i = 0; i < cf->amax; ++i) {
            ifBLIN_QX3( "[%d]%c%s%s"
                      , i
                      , (i < cf->argp) ? '#' : '='
                      , !cf->args[i] ? "" : cf->args[i]
                      , !cf->args[i] ? "" : "~"
                      );
        }
        execv(cf->shell, (char * const*)&cf->args[cf->argp]);
        ifBLIN_QW0("exec=%s~", cf->shell);
        ex = EX_OSERR;
        goto out;
    default:
#ifndef BLIN_OSLinux
        login_close(lc);
#endif
        sa.sa_handler = SIG_IGN;
        sigaction(SIGTTOU, &sa, NULL);
        close(fds[0]);
        setpgid(child, child);
        if  (!!cf->tty && (tcgetpgrp(cf->ttyfd) == getpgrp())) tcsetpgrp(cf->ttyfd, child);
        close(fds[1]);
        sigaction(SIGPIPE, &sa_pipe, NULL);
        while (-1 != (pid = waitpid(child, &statusp, WUNTRACED))) {
            if  (WIFSTOPPED(statusp)) {
                gchild = getpgid(child);
                if  (!!cf->tty && (tcgetpgrp(cf->ttyfd) == gchild)) {
                    tcsetpgrp(cf->ttyfd, getpgrp());
                }
                kill(getpid(), SIGSTOP);
                if  (!!cf->tty && (tcgetpgrp(cf->ttyfd) == getpgrp())) {
                    gchild = getpgid(child);
                    tcsetpgrp(cf->ttyfd, gchild);
                }
                kill(child, SIGCONT);
                statusp = 1;
                continue;
            }
            break;
        }
        if  (!!cf->tty) tcsetpgrp(cf->ttyfd, getpgrp());
        if  (pid == -1) err(1, "waitpid");
#ifndef BLIN_OSLinux
        if  (!!su2_pamend(cf)) ifBLIN_QX1("su2_pamend");
#endif
        if  (!!(ex = su2_reg(cf, 0))) {
            ifBLIN_QW0("su2_reg out");
            goto out;
        }
        ex = WEXITSTATUS(statusp);
    }
    if  (!!cf->md && !!mife_fini(cf->md)) ifBLIN_QW0("mife_fini");
    endpwent();
out:
    exit(ex);
#   undef blin_internal_flags
}
