/*-
 * Copyright (C)2020 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: su2.h,v 1.8 2020/10/04 17:11:47 babolo Exp $
 */

#define MAXARGS  256
#define ARGSHIFT 3
#define SU2_NOPASS 0x08
#define SU2_NOCHCK 0x02
#define SU2_UFOUND 0x04
#define SU2_NOSUCC 0x01

typedef struct passwd su2_pass;

typedef enum
{   SU2_FNDNONE = 0x00
,   SU2_FNDFAIL = SU2_NOSUCC
,   SU2_FNDUSER = SU2_UFOUND
,   SU2_FNDPLUS = (SU2_UFOUND | SU2_NOPASS)
,   SU2_FNDSTAR = SU2_NOCHCK
,   SU2_FNDFULL = (SU2_NOCHCK | SU2_NOPASS)
} su2_found;

typedef struct {
    BLIN_flag      flags;
#       define SU2_EXECVE    0x000100 /*  execve()  --     */
#       define SU2_CSH       0x000200 /*  /bin/csh           */
#       define SU2_UREG      0x001000 /*  utmpx                 */
#       define SU2_DASH      0x004000 /*    --            */
#       define SU2_LOGIN     0x008000 /*            */
#       define SU2_NICE      0x200000 /*  nice                      */
#       define SU2_RENICE    0x400000 /*  nice                     */
#       define SU2_DUMP      0x800000 /*           */
    int            nice;
    char          *tty;
    char          *args[MAXARGS];
#ifdef SECURITY_PAM_APPL_H_INCLUDED
    pam_handle_t  *pamh;
#else
    void          *pamh;
#endif
    su2_pass      *topw;   /* Target credentials */
    su2_pass      *mypw;   /* Caller credentials */
    char          *shell;
    char          *class;
    su2_pass      *frompw; /* Whose credentials used */
    char          *command;
    int            pamret;
    int            ttyfd;
    int            argp;
    int            amax;
    su2_found      cond;
    su2_found      next;
    uid_t          uid;
    gid_t          gid;
    mode_t         rght;
} su2_cf;

int       su2_iniud    __P((su2_cf *cf, char c, const char *uname, su2_pass **pw, uid_t uid));
int       su2_reg      __P((su2_cf *cf, int mode));
void      su2_log      __P((su2_cf *cf, int mode));
int       su2_nice     __P((su2_cf *cf));
void      su2_dump     __P((su2_cf *cf));
int       su2_tty      __P((su2_cf *cf));
int       su2_shell    __P((su2_cf *cf));
int       su2_rc       __P((su2_cf *cf));
int       su2_pamend   __P((su2_cf *cf));
int       su2_auth     __P((su2_cf *cf));
int       su2_inpass   __P((su2_cf *cf));
