/*-
 * Copyright (C)2020 @BABOLO http://www.babolo.ru/
 * Inspired by su2-1.3.
 * This version written from scratch and FreeBSD's /usr/bin/su
 *
 * Copyright (c) 2002, 2005 Networks Associates Technologies, Inc.
 * All rights reserved.
 *
 * Portions of this software were developed for the FreeBSD Project by
 * ThinkSec AS and NAI Labs, the Security Research Division of Network
 * Associates, Inc.  under DARPA/SPAWAR contract N66001-01-C-8035
 * ("CBOSS"), as part of the DARPA CHATS research program.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Copyright (c) 1988, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2020 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: auth.c,v 1.4 2020/10/10 16:56:33 babolo Exp $"

#define BLIN_COMPAT  3
#define Bpars_COMPAT 4
#define MIFE_COMPAT  5

#include <sys/stat.h>
#include <sysexits.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <utmpx.h>
#include <pwd.h>
#include <err.h>
#include <security/pam_appl.h>
#include <security/openpam.h>
#include <babolo/BLINflag.h>
#include "su2.h"

void
/*****************************************************************************************************
 *****************************************************************************************************
 ****                                                                                  ****
 *****************************************************************************************************
 ****                                                                                             ****/
su2_log(su2_cf *cf, int mode) {                                                                  /****
 ****                                                                                             ****
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (cf->flags)
    FILE      *log;
    struct tm *tm;
    int        fd;
    time_t     t;

    ifBLIN_QX3("+ %d", mode);
    if  ((time_t)-1 == (t = time(NULL))) {
        ifBLIN_QW0("time");
        t = 0;
    }
    if  (!(tm = localtime(&t))) {
        ifBLIN_QW0("localtime");
        if  (!(tm = calloc(1, sizeof(struct tm)))) {
            ifBLIN_QW0("calloc");
            goto out;
    }   }
    if  (0 > (fd = open(SU2LOG, O_WRONLY | O_APPEND | O_CREAT, S_IRUSR | S_IWUSR | S_IRGRP))) {
        ifBLIN_QW0("open %s", SU2LOG);
        goto out;
    }
    if  (!(log = fdopen(fd, "a"))) {
        ifBLIN_QW0("fdopen %s", SU2LOG);
        goto out;
    }
    if  (0 > fprintf( log
                    , "%04u-%02u-%02u %02u:%02u:%02u %c %s-%s\n"
                    , tm->tm_year + 1900
                    , tm->tm_mon + 1
                    , tm->tm_mday
                    , tm->tm_hour
                    , tm->tm_min
                    , tm->tm_sec
                    , mode ? '+' : '-'
                    , cf->frompw->pw_name
                    , cf->topw->pw_name
        )           ) {
        ifBLIN_QW0("fprintf %s", SU2LOG);
    }
out:
    ifBLIN_QX3("-");
    return;
#   undef blin_internal_flags
}

int
/*****************************************************************************************************
 *****************************************************************************************************
 ****                                                              ****
 *****************************************************************************************************
 ****                                                                                             ****/
su2_auth(su2_cf *cf) {                                                                           /****
 ****                                                                                             ****
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (cf->flags)
    struct pam_conv conv = {openpam_ttyconv, NULL};
    int             ex   = EX_OK;

    ifBLIN_QX3("+");
    cf->pamret = pam_start("su", cf->topw->pw_name, &conv, &cf->pamh);
    if  (PAM_SUCCESS != cf->pamret) {
        ifBLIN_QX0("pam_start %s: %s", cf->topw->pw_name, pam_strerror(cf->pamh, cf->pamret));
        ex = EX_OSERR;
        goto out;
    }
    cf->pamret = pam_set_item(cf->pamh, PAM_RUSER, cf->frompw->pw_name);
    if  (PAM_SUCCESS != cf->pamret) {
        ifBLIN_QX0( "pam_set_item PAM_RUSER %s: %s"
                  , cf->frompw->pw_name
                  , pam_strerror(cf->pamh, cf->pamret)
                  );
        ex = EX_OSERR;
        goto out;
    }
    cf->pamret = pam_set_item(cf->pamh, PAM_TTY, !cf->tty ? "tty" : cf->tty);
    if  (PAM_SUCCESS != cf->pamret) {
        ifBLIN_QX0("pam_set_item PAM_TTY: %s", pam_strerror(cf->pamh, cf->pamret));
        ex = EX_OSERR;
        goto out;
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/*****************************************************************************************************
 *****************************************************************************************************
 ****                                                                        ****
 *****************************************************************************************************
 ****                                                                                             ****/
su2_inpass(su2_cf *cf) {                                                                         /****
 ****                                                                                             ****
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (cf->flags)
    int   ex = EX_OK;
    char *pass;

    ifBLIN_QX3("+ %d %d %d", cf->mypw->pw_uid, cf->frompw->pw_uid, cf->topw->pw_uid);
    if  (  (cf->mypw->pw_uid == cf->topw->pw_uid)
        || (  !!(pass = getpass("Password:"))
           && !!*pass
           && !strcmp(crypt(pass, cf->frompw->pw_passwd), cf->frompw->pw_passwd)
        )  ) goto out;
    ex = EX_NOPERM;
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/*****************************************************************************************************
 *****************************************************************************************************
 ****   PAM                                                                                ****
 *****************************************************************************************************
 ****                                                                                             ****/
su2_pamend(su2_cf *cf) {                                                                         /****
 ****                                                                                             ****
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (cf->flags)
    int ex = EX_OK;

    ifBLIN_QX3("+ %"BLIN_X" %"BLIN_X, BLIN_I(cf), BLIN_I(cf->pamh));
    if  (!!cf->pamh) {
        if  (PAM_SUCCESS != (cf->pamret = pam_setcred(cf->pamh, PAM_DELETE_CRED))) {
            ifBLIN_QX1("pam_setcred(PAM_DELETE_CRED): %s", pam_strerror(cf->pamh, cf->pamret));
        }
        if  (  (SU2_LOGIN & cf->flags)
            && (PAM_SUCCESS != (cf->pamret = pam_close_session(cf->pamh, 0)))
            ) {
            ifBLIN_QX1("pam_close_session: %s", pam_strerror(cf->pamh, cf->pamret));
        }
        if  (PAM_SUCCESS != (cf->pamret = pam_end(cf->pamh, cf->pamret))) {
            ifBLIN_QX1("pam_end: %s", pam_strerror(cf->pamh, cf->pamret));
    }   }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/*****************************************************************************************************
 *****************************************************************************************************
 ****   tty    utx                               ****
 *****************************************************************************************************
 ****                                                                                             ****/
su2_reg(su2_cf *cf, int mode) {                                                                  /****
 ****                                                                                             ****
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (cf->flags)
    int           ex   = EX_OK;
    struct stat   sb;

    ifBLIN_QX3("+ %d", mode);
    if  (!!cf->tty) {
        if  (!!fchown( cf->ttyfd
                     , mode ? cf->topw->pw_uid : cf->mypw->pw_uid
                     , mode ? cf->topw->pw_gid : cf->mypw->pw_gid
            )        ) {
            ifBLIN_QW0("fchown [%d]%s", cf->ttyfd, cf->tty);
            ex = EX_IOERR;
        }
        if  (!mode) {
            sb.st_mode = cf->rght;
        } else {
            cf->rght = sb.st_mode = 0;
            if  (!!fstat(cf->ttyfd, &sb)) {
                ifBLIN_QW0("fstat [%d]%s", cf->ttyfd, cf->tty);
                ex = EX_IOERR;
                sb.st_mode = 0;
            }
            cf->rght = sb.st_mode;
            sb.st_mode &= ~(S_ISUID | S_ISGID | S_ISVTX | S_IRWXO | S_IXGRP | S_IXUSR);
            if  (!cf->topw->pw_uid) sb.st_mode &= ~S_IRWXG;
        }
        if  (!!cf->rght && !!fchmod(cf->ttyfd, sb.st_mode)) {
            ifBLIN_QW0("fchmod [%d]%s", cf->ttyfd, cf->tty);
            ex = EX_IOERR;
        }
        if  (SU2_UREG & cf->flags) {
            struct utmpx *line = NULL;
            struct utmpx  id;
            char         *p;

            setutxent();
            p = cf->tty;
            if  (!strncmp(p, "/dev/", strlen("/dev/"))) {
                p += strlen("/dev/");
            } else if (!strncmp(p, "dev/", strlen("dev/"))) {
                p += strlen("dev/");
            }
            strncpy(id.ut_line, p, sizeof(id.ut_line));
            errno = 0;
            if  (!(line = getutxline(&id))) {
                ifBLIN_QX0("getutxline %s not found", p);
                if  (!errno) errno = ENOENT;
                ex = EX_OSERR;
                goto out;
            }
            strncpy( line->ut_user
                   , mode ? cf->topw->pw_name : cf->mypw->pw_name
                   , sizeof(line->ut_user)
                   );
            if  (!pututxline(line)) {
                ifBLIN_QW0("pututxline");
                ex = EX_OSERR;
                goto out;
    }   }   }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}
