/*-
 * Copyright (C)2018..2025 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2018..2025 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: ctest.c,v 1.13 2025/02/06 01:09:13 babolo Exp $"

#define MIFE_COMPAT     5
#define BLIN_COMPAT     4
#define Bpars_COMPAT    4
#define RECOBE_COMPAT   VMAJOR

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <strings.h>
#include <stdlib.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <mife.h>
#include "../lib/recobe.h"

int
main(int argc, char **argv) {
    ssize_t   hexlen = 0;
    u_char    o[16];
    u_char   *z;
    u_int64_t c;
    u_int64_t r;
    ssize_t   l;
    int       e;

    if  (argc < 4) exit(1);
    l = strtol(argv[2], NULL, 0);
    c = strtoull(argv[3], NULL, 0);
    bzero(o, 16);
    switch(argv[1][0]) {
    case 't':
        printf("%2zd %2d %016"BLIN_O"X\n", l, recobe_utest(c), c);
        exit(0);
    case 'o':
        e = (int)l;
        recobe_store(o, l, c);
        r = recobe_load(o, l);
        break;
    case 'u':
        l = 16;
        e = recobe_ustore(o, c);
        r = recobe_uload(o, &l);
        break;
    case 'c':
        l = 16;
        e = recobe_cstore(o, c);
        r = recobe_cload(o, &l);
        break;
    case 's':
        if  (!(z = babolo_hextrin(argv[4], &hexlen))) {
            fprintf(stderr, "babolo_hextrin\n");
            exit(1);
        }
        switch(c) {
        case 1: printf("csum1 = %02X\n"   , recobe_csum1  (z, l * hexlen));
                break;
        case 2: printf("crc24 = %06X\n"   , recobe_crc24  (z, l * hexlen));
                break;
        case 3: printf("crc32 = %08X\n"   , recobe_crc32  (z, l * hexlen));
                break;
        case 4: printf("crcCCITT = %04X\n", recobe_crccitt(z, l * hexlen));
                break;
        case 5: printf("csum = %02X\n"    , recobe_csum   (z, l * hexlen));
                break;
        default:
                fprintf(stderr, "Illegal code %d\n", (int)c);
        }
        exit(0);
    default:
        e = recobe_storeM(o, argv[1], c);
        r = recobe_loadM(o, argv[1]);
        break;
    }
    for (int i = 0; i < 16; ++i) printf(" %02X", o[i]);
# ifdef __amd64__
    printf(" [%d] =%016lX[%"BLIN_D"]\n", e, r, l);
# else /* !__amd64__ */
    printf(" [%d] =%016llX[%"BLIN_D"]\n", e, r, l);
# endif /* __amd64__ */
    exit(0);
}
