/*-
 * Copyright (C)2014..2025 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2014..2025 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: wchar.c,v 1.77 2025/12/21 18:27:27 babolo Exp $"

#define MIFE_COMPAT     5
#define BLIN_COMPAT     4
#define Bpars_COMPAT    4
#define RECOBE_COMPAT   VMAJOR
#define RECOBE_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <strings.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <mife.h>
#include "recobe.h"

#define WIDE_L 17

/*****************************************************************************************************
 *****************************************************************************************************/
static const char *                                                                              /****/
kode_k[] = {"KOI8"            , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_u[] = {"UTF8"            , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_0[] = {"8bit"            , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_1[] = {"UCS2"            , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_2[] = {"UCS3"            , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_3[] = {"UCS4"            , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_4[] = {"UCS5"            , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_5[] = {"UCS6"            , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_6[] = {"UCS7"            , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_7[] = {"UCS8"            , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_8[] = {"UCS9"            , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_9[] = {"UCS10"           , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_Z[] = {"SWAPcASE"        , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_Y[] = {"UP/lo"           , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_P[] = {"Puny"            , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_p[] = {"puny"            , NULL};                                                           /****/
/*****************************************************************************************************
 *****************************************************************************************************/

static const recobe_c_tnm
/*****************************************************************************************************
                                                                                                  ****/
encolist[WIDE_L] =                                                                               /****
                                                                                                  ****
 *****************************************************************************************************/
{ { NULL                , NULL   , NULL}
, { (const u_char *)"k" , &kode_k, NULL}
, { (const u_char *)"u" , &kode_u, NULL}
, { (const u_char *)"0" , &kode_0, NULL}
, { (const u_char *)"1" , &kode_1, NULL}
, { (const u_char *)"2" , &kode_2, NULL}
, { (const u_char *)"3" , &kode_3, NULL}
, { (const u_char *)"4" , &kode_4, NULL}
, { (const u_char *)"5" , &kode_5, NULL}
, { (const u_char *)"6" , &kode_6, NULL}
, { (const u_char *)"7" , &kode_7, NULL}
, { (const u_char *)"8" , &kode_8, NULL}
, { (const u_char *)"9" , &kode_9, NULL}
, { (const u_char *)"Z" , &kode_Z, NULL}
, { (const u_char *)"Y" , &kode_Y, NULL}
, { (const u_char *)"P" , &kode_P, NULL}
, { (const u_char *)"p" , &kode_p, NULL}
};

static u_int
/*****************************************************************************************************
                                                                                                  ****/
codnumbyid(const u_char *nm) {                                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
    u_int   r = 0;
    u_int   i;

    for (i = 1; i < WIDE_L; ++i) {
        if  (nm[0] == encolist[i].encoid[0]) {
            r = i;
            break;
    }   }
    return(r);
}

static recobe_conv
/*****************************************************************************************************
                                                                                                  ****/
convbyname(const char *name) {                                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
    recobe_conv cnv = {RECOBE_WIDE, 0, 0, 0, 0};

    if  (!name || !name[0]) {
        cnv.nonesrc = cnv.nonedst = 1;
    } else {
        cnv.encosrc = codnumbyid((const u_char *)name);
        if  (!name[1]) {
            cnv.nonedst = 1;
        } else if (!!name[2]) {
            cnv.encodst = 0;
        } else {
            cnv.encodst = codnumbyid((const u_char *)&name[1]);
    }   }
    return(cnv);
}

static int
/*****************************************************************************************************
                                                                                                  ****/
un(recobe_chain *chain, recobe_chunk *chunk) {                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
    int           ex = 0;
    ssize_t       intail;
    u_int64_t     wchr;

#   define blin_internal_flags (chain->flags)
    ifBLIN_QX3("+ %08X %"BLIN_X, chain->flags, BLIN_I(chain));
    intail = (ssize_t)recobe_chunksize(chain->tail);
    wchr = recobe_uload(&chain->tail->chunk[chain->tail->position], &intail);
    if  (0 > intail) {
        chain->tail->position += ~(size_t)intail;
        ifBLIN_QX1("uload");
        ex = -1;
        if  (!chunk->length && !chunk->position) chunk->position = RECOBE_EOT;
        goto out;
    }
    chain->tail->position += (size_t)intail;
    if  (0 > (ex = recobe_outword(chain, chunk, wchr))) {
        ifBLIN_QW2("outword");
        ex = 0;
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}


static int
/*****************************************************************************************************
                                                                                                  ****/
nw(recobe_chain *chain, recobe_chunk *chunk) {                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
    u_int16_t     trail;
    u_int64_t     wchr;
    u_int32_t     pos;
    int           ex;
    int           e;

#   define blin_internal_flags (chain->flags)
    ifBLIN_QX3("+ %08X %"BLIN_X, chain->flags, BLIN_I(chain));
    pos = chain->tail->position;
    if  (0 > (ex = recobe_inword(chain, chain->tail, &wchr))) {
        ifBLIN_QW1("inword %d", ex);
        if  (!chunk->length && !chunk->position) chunk->position = RECOBE_EOT;
        goto out;
    }
    trail = 0;
    if  ((0x010FFFF < wchr) || ((wchr & 0xF800) == 0xD800)) {
        ifBLIN_QX1("Surrogate");
        ex = -1;
        goto out;
    }
    if  (0x010000 <= wchr) {
        trail = 0xDC00 + (wchr & 0x3FF);
        wchr = 0xD7C0 + (wchr >> 10);
    }
    if  (0 > (ex = recobe_outword(chain, chunk, wchr))) {
        ifBLIN_QW2("outword");
        ex = 0;
        goto out;
    }
    if  (!!trail) {
        if  (0 > (e = recobe_outword(chain, chunk, trail))) ex = 0; else ex += e;
    }
out:
    if  (0 > ex) chain->tail->position = pos;
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
                                                                                                  ****/
wn(recobe_chain *chain, recobe_chunk *chunk) {                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
    u_int16_t     trail;
    u_int64_t     wchr;
    u_int32_t     pos;
    int           ex;

#   define blin_internal_flags (chain->flags)
    ifBLIN_QX3("+ %08X %"BLIN_X, chain->flags, BLIN_I(chain));
    pos = chain->tail->position;
    if  (0 > (ex = recobe_inword(chain, chain->tail, &wchr))) {
        ifBLIN_QW1("inword %d", ex);
        if  (!chunk->length && !chunk->position) chunk->position = RECOBE_EOT;
        goto out;
    }
    if  (  ((wchr & 0xFC00) == 0xD800)
        && (chain->inwlen + pos > chain->tail->length)
        ) {
        ifBLIN_QX1("Surrogate0: %016"BLIN_O"X", wchr);
        ex = -1;
        goto out;
    }
    if  ((4 >= chain->outwlen) && ((wchr & 0xFC00) == 0xDC00)) {
        ifBLIN_QX1("Surrogate1: %016"BLIN_O"X", wchr);
        ex = -1;
        goto out;
    }
    if  ((wchr & 0xFC00) == 0xD800) {
        trail = (u_int16_t)wchr;
        if  ((0 > (ex = recobe_inword(chain, chain->tail, &wchr))) || ((wchr & 0xFC00) != 0xDC00)) {
            ifBLIN_QX1("Surrogate2: %016"BLIN_O"X", wchr);
            ex = -1;
            goto out;
        }
        wchr = (wchr << 10) + trail - 0x035FDC00;
    }
    if  (0 > (ex = recobe_outword(chain, chunk, wchr))) {
        ifBLIN_QW2("outword");
        ex = 0;
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
                                                                                                  ****/
nn(recobe_chain *chain, recobe_chunk *chunk) {                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
    u_int64_t     wchr;
    int           ex;

#   define blin_internal_flags (chain->flags)
    ifBLIN_QX3("+ %08X %"BLIN_X, chain->flags, BLIN_I(chain));
    if  (0 > (ex = recobe_inword(chain, chain->tail, &wchr))) {
        ifBLIN_QW1("inword %d", ex);
        if  (!chunk->length && !chunk->position) chunk->position = RECOBE_EOT;
        goto out;
    }
    if  ((8 > chain->outwlen) && ((1ULL << (chain->outwlen * 8)) <= wchr)) {
        ifBLIN_QX1("Long outwlen %u", chain->outwlen);
        ex = -1;
        goto out;
    }
    if  (0 > (ex = recobe_outword(chain, chunk, wchr))) {
        ifBLIN_QW2("outword");
        ex = 0;
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
                                                                                                  ****/
nk(recobe_chain *chain, recobe_chunk *chunk) {                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
    u_int64_t     wchr;
    int           ex;

#   define blin_internal_flags (chain->flags)
    ifBLIN_QX3("+ %08X %"BLIN_X, chain->flags, BLIN_I(chain));
    if  (0 > (ex = recobe_inword(chain, chain->tail, &wchr))) {
        ifBLIN_QW1("inword %d", ex);
        if  (!chunk->length && !chunk->position) chunk->position = RECOBE_EOT;
        goto out;
    }
    if  ((0x00FFFF < wchr) || !recobe_1k[wchr]) {
        ifBLIN_QX1("Long or NO: %016"BLIN_O"X", wchr);
        ex = -ex;
        goto out;
    };
    for (int k = 0, e = 0; !!recobe_1k[wchr] && !!recobe_1k[wchr][k]; ++k) {
        if  (0 > (e = recobe_outword(chain, chunk, 0x0FF & recobe_1k[wchr][k]))) {
            ifBLIN_QW2("outword");
            ex = 0;
            break;
        }
        ex += e;
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
                                                                                                  ****/
kn(recobe_chain *chain, recobe_chunk *chunk) {                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
    u_int64_t     wchr;
    u_int32_t     pos;
    int           ex = 1;

#   define blin_internal_flags (chain->flags)
    ifBLIN_QX3("+ %08X %"BLIN_X, chain->flags, BLIN_I(chain));
    pos = chain->tail->position;
    wchr = recobe_k1[chain->tail->chunk[chain->tail->position++]];
    if  (0 > (ex = recobe_outword(chain, chunk, wchr))) {
        ex = 0;
        chain->tail->position = pos;
    }
    ifBLIN_QX3("- %d", 1);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
                                                                                                  ****/
nu(recobe_chain *chain, recobe_chunk *chunk) {                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
    u_int64_t     wchr;
    int           outw;
    int           ex;

#   define blin_internal_flags (chain->flags)
    ifBLIN_QX3("+ %08X %"BLIN_X, chain->flags, BLIN_I(chain));
    if  (0 > (ex = recobe_inword(chain, chain->tail, &wchr))) {
        ifBLIN_QW1("inword");
        if  (!chunk->length && !chunk->position) chunk->position = RECOBE_EOT;
        goto out;
    }
    if  (chunk->size < chunk->length + (u_int)recobe_utest(wchr)) {
        ex = 0;
        ifBLIN_QX1("Long");
        goto out;
    }
    outw = recobe_utest(wchr);
    if  (chunk->size < chunk->length + (u_int)outw) {
        ifBLIN_QX0( "size=%u < length=%u + utest(%"BLIN_O"X)=%u"
                  , chunk->size
                  , chunk->length
                  , wchr
                  , outw
                  );
        errno = ENOSPC;
        ex = -EX_CANTCREAT;
    }
    outw = recobe_ustore(&chunk->chunk[chunk->length], wchr);
    if  (0 > outw) {
        ex = -ex;
        goto out;
    }
    chunk->length += (u_int)outw;
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
                                                                                                  ****/
Yn(recobe_chain *chain, recobe_chunk *chunk) {                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
    u_int64_t     wchr;
    int           ex;

#   define blin_internal_flags (chain->flags)
    ifBLIN_QX3("+ %08X %"BLIN_X, chain->flags, BLIN_I(chain));
    if  (0 > (ex = recobe_inword(chain, chain->tail, &wchr))) {
        ifBLIN_QW1("inword");
        if  (!chunk->length && !chunk->position) chunk->position = RECOBE_EOT;
        goto out;
    }
    chain->tail->position += (u_int)ex;
    wchr ^= recobe_unicodelower(wchr);
    if  ((8 > chain->outwlen) && ((1ULL << (chain->outwlen * 8)) <= wchr)) {
        ifBLIN_QX1("Long");
        ex = -1;
        goto out;
    }
    if  (0 > (ex = recobe_outword(chain, chunk, wchr))) {
        ifBLIN_QW2("outword");
        ex = 0;
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
                                                                                                  ****/
nY(recobe_chain *chain, recobe_chunk *chunk) {                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
    u_int64_t     wchr;
    int           ex;

#   define blin_internal_flags (chain->flags)
    ifBLIN_QX3("+ %08X %"BLIN_X, chain->flags, BLIN_I(chain));
    if  (0 > (ex = recobe_inword(chain, chain->tail, &wchr))) {
        ifBLIN_QW1("inword");
        if  (!chunk->length && !chunk->position) chunk->position = RECOBE_EOT;
        goto out;
    }
    wchr ^= recobe_unicodeupper(wchr);
    if  ((8 > chain->outwlen) && ((1ULL << (chain->outwlen * 8)) <= wchr)) {
        ifBLIN_QX1("Long");
        ex = -1;
        goto out;
    }
    if  (0 > (ex = recobe_outword(chain, chunk, wchr))) {
        ex = 0;
        ifBLIN_QW2("outword");
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
                                                                                                  ****/
nZ(recobe_chain *chain, recobe_chunk *chunk) {                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
    u_int64_t     wchr;
    u_int64_t     wchz;
    int           ex;

#   define blin_internal_flags (chain->flags)
    ifBLIN_QX3("+ %08X %"BLIN_X, chain->flags, BLIN_I(chain));
    if  (0 > (ex = recobe_inword(chain, chain->tail, &wchr))) {
        ifBLIN_QW1("inword");
        if  (!chunk->length && !chunk->position) chunk->position = RECOBE_EOT;
        goto out;
    }
    chain->tail->position += (u_int)ex;
    wchz = recobe_unicodeupper(wchr);
    if  (!wchz) wchz = recobe_unicodelower(wchr);
    wchr ^= wchz;
    if  ((8 > chain->outwlen) && ((1ULL << (chain->outwlen * 8)) <= wchr)) {
        ifBLIN_QX1("Long");
        ex = -1;
        goto out;
    }
    if  (0 > (ex = recobe_outword(chain, chunk, wchr))) {
        ex = 0;
        ifBLIN_QW2("outword");
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

#define NO     NULL
#define nP     recobe_puny_encase
#define np     recobe_puny_encode
#define Pn     recobe_puny_decase
#define pn     recobe_puny_decode
#define PZ     RECOBE_PUNYMAX

static const recobe_chunker
/*****************************************************************************************************
                                                                                                  ****/
intercode[WIDE_L][WIDE_L] =                                                                      /****
                                                                                                  ****
 *****************************************************************************************************/
/*       k   u   0   1   2   3   4   5   6   7   8   9   Z   Y   P   p    out */
{ { NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO} /* in  */
, { NO, NO, NO, NO, kn, kn, kn, kn, kn, kn, kn, kn, kn, NO, NO, NO, NO} /* k k */
, { NO, NO, NO, NO, NO, un, un, un, un, un, un, un, un, NO, NO, NO, NO} /* u u */
, { NO, NO, nu, NO, nn, nn, nn, nn, nn, nn, nn, NO, NO, nZ, nY, nP, np} /* 0 n */
, { NO, nk, nu, NO, NO, wn, wn, wn, wn, wn, wn, wn, wn, nZ, nY, nP, np} /* 1 w */
, { NO, nk, nu, NO, nw, NO, nn, nn, nn, nn, nn, nn, nn, nZ, nY, nP, np} /* 2 n */
, { NO, nk, nu, NO, nw, nn, NO, nn, nn, nn, nn, nn, nn, nZ, nY, nP, np} /* 3 n */
, { NO, nk, nu, NO, nw, nn, nn, NO, nn, nn, nn, nn, nn, nZ, nY, nP, np} /* 4 n */
, { NO, nk, nu, NO, nw, nn, nn, nn, NO, nn, nn, nn, nn, nZ, nY, nP, np} /* 5 n */
, { NO, nk, nu, NO, nw, nn, nn, nn, nn, NO, nn, nn, nn, nZ, nY, nP, np} /* 6 n */
, { NO, nk, nu, NO, nw, nn, nn, nn, nn, nn, NO, nn, nn, nZ, nY, nP, np} /* 7 n */
, { NO, nk, nu, NO, nw, nn, nn, nn, nn, nn, nn, NO, nn, nZ, nY, nP, np} /* 8 n */
, { NO, nk, nu, NO, nw, nn, nn, nn, nn, nn, nn, nn, NO, nZ, nY, nP, np} /* 9 n */
, { NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO} /* Z n */
, { NO, NO, NO, Yn, Yn, Yn, Yn, Yn, Yn, Yn, Yn, Yn, Yn, NO, NO, NO, NO} /* Y n */
, { NO, NO, NO, Pn, Pn, Pn, Pn, Pn, Pn, Pn, Pn, Pn, Pn, NO, NO, NO, NO} /* P P */
, { NO, NO, NO, pn, pn, pn, pn, pn, pn, pn, pn, pn, pn, NO, NO, NO, NO} /* p p */
};

static const u_int16_t
/*****************************************************************************************************
 ****  Input word length                                                                          ****
 *****************************************************************************************************
                                                                                                  ****/
interinwlen[WIDE_L][WIDE_L] =                                                                    /****
                                                                                                  ****
 *****************************************************************************************************/
/*       k   u   0   1   2   3   4   5   6   7   8   9   Z   Y   P   p    out */
{ {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0} /* in  */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1} /* k k */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1} /* u u */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1} /* 0 n */
, {  0,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2} /* 1 w */
, {  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3} /* 2 n */
, {  0,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4} /* 3 n */
, {  0,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5} /* 4 n */
, {  0,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6} /* 5 n */
, {  0,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7} /* 6 n */
, {  0,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8} /* 7 n */
, {  0,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9} /* 8 n */
, {  0, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10} /* 9 n */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1} /* Z n */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1} /* Y n */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1} /* P P */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1} /* p p */
};

static const u_int16_t
/*****************************************************************************************************
 ****  Output word length                                                                         ****
 *****************************************************************************************************
                                                                                                  ****/
interoutwlen[WIDE_L][WIDE_L] =                                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
/*       k   u   0   1   2   3   4   5   6   7   8   9   Z   Y   P   p    out */
{ {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0} /* in  */
, {  0,  1,  1,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10,  1,  1,  1,  1} /* k k */
, {  0,  1,  1,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10,  1,  1,  1,  1} /* u u */
, {  0,  1,  1,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10,  1,  1,  1,  1} /* 0 n */
, {  0,  1,  1,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10,  2,  2,  1,  1} /* 1 w */
, {  0,  1,  1,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10,  3,  3,  1,  1} /* 2 n */
, {  0,  1,  1,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10,  4,  4,  1,  1} /* 3 n */
, {  0,  1,  1,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10,  5,  5,  1,  1} /* 4 n */
, {  0,  1,  1,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10,  6,  6,  1,  1} /* 5 n */
, {  0,  1,  1,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10,  7,  7,  1,  1} /* 6 n */
, {  0,  1,  1,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10,  8,  8,  1,  1} /* 7 n */
, {  0,  1,  1,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10,  9,  9,  1,  1} /* 8 n */
, {  0,  1,  1,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 10, 10,  1,  1} /* 9 n */
, {  0,  1,  1,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10,  1,  1,  1,  1} /* Z n */
, {  0,  1,  1,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10,  1,  1,  1,  1} /* Y n */
, {  0,  1,  1,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10,  1,  1,  1,  1} /* P P */
, {  0,  1,  1,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10,  1,  1,  1,  1} /* p p */
};

static const u_int16_t
/*****************************************************************************************************
 ****  Input min word count                                                                       ****
 *****************************************************************************************************
                                                                                                  ****/
interinwnum[WIDE_L][WIDE_L] =                                                                    /****
                                                                                                  ****
 *****************************************************************************************************/
/*       k   u   0   1   2   3   4   5   6   7   8   9   Z   Y   P   p    out */
{ {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0} /* in  */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1} /* k k */
, {  0,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  1,  1,  1,  1} /* u u */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, PZ, PZ} /* 0 n */
, {  0,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  1, PZ, PZ} /* 1 w */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, PZ, PZ} /* 2 n */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, PZ, PZ} /* 3 n */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, PZ, PZ} /* 4 n */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, PZ, PZ} /* 5 n */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, PZ, PZ} /* 6 n */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, PZ, PZ} /* 7 n */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, PZ, PZ} /* 8 n */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, PZ, PZ} /* 9 n */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1} /* Z n */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1} /* Y n */
, {  0,  1,  1, PZ, PZ, PZ, PZ, PZ, PZ, PZ, PZ, PZ, PZ,  1,  1,  1,  1} /* P P */
, {  0,  1,  1, PZ, PZ, PZ, PZ, PZ, PZ, PZ, PZ, PZ, PZ,  1,  1,  1,  1} /* p p */
};

static const u_int16_t
/*****************************************************************************************************
 ****  Output min word count                                                                      ****
 *****************************************************************************************************
                                                                                                  ****/
interoutwnum[WIDE_L][WIDE_L] =                                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
/*       k   u   0   1   2   3   4   5   6   7   8   9   Z   Y   P   p    out */
{ {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0} /* in  */
, {  0,  1,  7,  1,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1} /* k k */
, {  0,  1,  7,  1,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1} /* u u */
, {  0,  1,  7,  1,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, PZ, PZ} /* 0 n */
, {  0,  1,  7,  1,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, PZ, PZ} /* 1 w */
, {  0,  1,  7,  1,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, PZ, PZ} /* 2 n */
, {  0,  1,  7,  1,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, PZ, PZ} /* 3 n */
, {  0,  1,  7,  1,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, PZ, PZ} /* 4 n */
, {  0,  1,  7,  1,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, PZ, PZ} /* 5 n */
, {  0,  1,  7,  1,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, PZ, PZ} /* 6 n */
, {  0,  1,  7,  1,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, PZ, PZ} /* 7 n */
, {  0,  1,  7,  1,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, PZ, PZ} /* 8 n */
, {  0,  1,  7,  1,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, PZ, PZ} /* 9 n */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1} /* Z n */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1} /* Y n */
, {  0,  1,  1, PZ, PZ, PZ, PZ, PZ, PZ, PZ, PZ, PZ, PZ,  1,  1,  1,  1} /* P P */
, {  0,  1,  1, PZ, PZ, PZ, PZ, PZ, PZ, PZ, PZ, PZ, PZ,  1,  1,  1,  1} /* p p */
};

static int
/*****************************************************************************************************
 ****  Output min word count                                                                      ****
 *****************************************************************************************************
                                                                                                  ****/
param(recobe_chain *chain) {                                                                     /****
                                                                                                  ****
 *****************************************************************************************************/
    chain->convertor = intercode[chain->cnv.encosrc][chain->cnv.encodst];
    chain->inwlen = interinwlen[chain->cnv.encosrc][chain->cnv.encodst];
    chain->outwlen = interoutwlen[chain->cnv.encosrc][chain->cnv.encodst];
    chain->inwnum = interinwnum[chain->cnv.encosrc][chain->cnv.encodst];
    chain->outwnum = interoutwnum[chain->cnv.encosrc][chain->cnv.encodst];
    return(0);
}

const recobe_c_tdm
/*****************************************************************************************************
 *****************************************************************************************************
 ****   WIDE                                                                       ****
 *****************************************************************************************************
                                                                                                  ****/
recobe_wide_dm =                                                                                 /****
                                                                                                  ****
 *****************************************************************************************************
 *****************************************************************************************************/
{ WIDE_L
, 2
#ifdef __amd64__
, 0
#endif
, "WIDE"
, encolist
, codnumbyid
, convbyname
, {.param = param}
};
