/*-
 * Copyright (C)2014..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2014..2024 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: text.c,v 1.28 2024/01/08 00:11:11 babolo Exp $"

#define MIFE_COMPAT     5
#define BLIN_COMPAT     4
#define RECOBE_COMPAT   VMAJOR
#define RECOBE_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <strings.h>
#include <stdlib.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <mife.h>
#include "recobe.h"

#define TEXT_L          11

static const u_char
/*****************************************************************************************************/
ai[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0XB0, 0XB1, 0XB2, 0XB3,  0XB4, 0XB5, 0XB6, 0XB7,  0XB8, 0XB9, 0XBA, 0XBB,  0XBC, 0XBD, 0XBE, 0XBF
,  0XC0, 0XC1, 0XC2, 0XC3,  0XC4, 0XC5, 0XC6, 0XC7,  0XC8, 0XC9, 0XCA, 0XCB,  0XCC, 0XCD, 0XCE, 0XCF
,  0XD0, 0XD1, 0XD2, 0XD3,  0XD4, 0XD5, 0XD6, 0XD7,  0XD8, 0XD9, 0XDA, 0XDB,  0XDC, 0XDD, 0XDE, 0XDF
,  0x9f, 0x87, 0x88, 0x89,  0x8d, 0xa2, 0xa6, 0xf6,  0x86, 0x8e, 0x8f, 0x90,  0x95, 0x8a, 0xa3, 0x91

,  0x92, 0x93, 0x94, 0x97,  0x99, 0x9a, 0xf3, 0xa9,  0x9b, 0x9c, 0x9d, 0x9e,  0xad, 0xfb, 0x96, 0xaa
,  0xac, 0x8b, 0x8c, 0xab,  0xaf, 0xff, 0x83, 0x84,  0xf2, 0xa8, 0xfd, 0xf8,  0xa5, 0xf9, 0xfa, 0xf5
,  0XE0, 0XE1, 0XE2, 0XE3,  0XE4, 0XE5, 0XE6, 0XE7,  0XE8, 0XE9, 0XEA, 0XEB,  0XEC, 0XED, 0XEE, 0XEF
,  0XA1, 0XF1, 0XA4, 0XF4,  0XA7, 0XF7, 0XAE, 0XFE,  0x80, 0xfc, 0x82, 0x98,  0XF0, 0x81, 0x85, 0XA0
};

static const u_char
/*****************************************************************************************************/
ia[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0xf8, 0xfd, 0xfa, 0xd6,  0xd7, 0xfe, 0xb8, 0xb1,  0xb2, 0xb3, 0xbd, 0xd1,  0xd2, 0xb4, 0xb9, 0xba
,  0xbb, 0xbf, 0xc0, 0xc1,  0xc2, 0xbc, 0xce, 0xc3,  0xfb, 0xc4, 0xc5, 0xc8,  0xc9, 0xca, 0xcb, 0xb0
,  0XFF, 0XF0, 0xb5, 0xbe,  0XF2, 0xdc, 0xb6, 0XF4,  0xd9, 0xc7, 0xcf, 0xd3,  0xd0, 0xcc, 0XF6, 0xd4
,  0X80, 0X81, 0X82, 0X83,  0X84, 0X85, 0X86, 0X87,  0X88, 0X89, 0X8A, 0X8B,  0X8C, 0X8D, 0X8E, 0X8F

,  0X90, 0X91, 0X92, 0X93,  0X94, 0X95, 0X96, 0X97,  0X98, 0X99, 0X9A, 0X9B,  0X9C, 0X9D, 0X9E, 0X9F
,  0XA0, 0XA1, 0XA2, 0XA3,  0XA4, 0XA5, 0XA6, 0XA7,  0XA8, 0XA9, 0XAA, 0XAB,  0XAC, 0XAD, 0XAE, 0XAF
,  0XE0, 0XE1, 0XE2, 0XE3,  0XE4, 0XE5, 0XE6, 0XE7,  0XE8, 0XE9, 0XEA, 0XEB,  0XEC, 0XED, 0XEE, 0XEF
,  0XFC, 0XF1, 0xd8, 0xc6,  0XF3, 0xdf, 0xb7, 0XF5,  0xdb, 0xdd, 0xde, 0xcd,  0xf9, 0xda, 0XF7, 0xd5
};

static const u_char
/*****************************************************************************************************/
ik[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0x9c, 0x9b, 0x9e, 0x9d,  0x94, 0xad, 0x97, 0x91,  0x92, 0x81, 0x98, 0x99,  0x9f, 0x87, 0xb5, 0xa1
,  0xa8, 0x83, 0x84, 0x89,  0x88, 0xbd, 0xbf, 0x86,  0x96, 0x80, 0x8a, 0xab,  0xa5, 0xbb, 0xb8, 0x90
,  0X9A,  '', 0xb2, 0xac,  0XB4, 0x8c, 0XB6, 0XB7,  0x85, 0xb0, 0xb9, 0xaa,  0xba, 0xb1, 0XBE, 0xa9
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''

,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,  0x93,  '', 0xbc, 0xaf,  0XA4, 0x8b, 0XA6, 0XA7,  0x8d, 0x8e, 0x8f, 0xa0,  0x95, 0x82, 0XAE, 0xa2
};

static const u_char
/*****************************************************************************************************/
ki[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0x99, 0x89, 0xfd, 0x91,  0x92, 0xa8, 0x97, 0x8d,  0x94, 0x93, 0x9a, 0xf5,  0xa5, 0xf8, 0xf9, 0xfa
,  0x9f, 0x87, 0x88, 0xf0,  0x84, 0xfc, 0x98, 0x86,  0x8a, 0x8b, 0XA0, 0x81,  0x80, 0x83, 0x82, 0x8c
,  0xfb, 0x8f, 0xff, 0XF1,  0XF4, 0x9c, 0XF6, 0XF7,  0x90, 0xaf, 0xab, 0x9b,  0xa3, 0x85, 0XFE, 0xf3
,  0xa9, 0xad, 0xa2, 0XA1,  0XA4, 0x8e, 0XA6, 0XA7,  0x9e, 0xaa, 0xac, 0x9d,  0xf2, 0x95, 0XAE, 0x96

,  0XEE, 0XD0, 0XD1, 0XE6,  0XD4, 0XD5, 0XE4, 0XD3,  0XE5, 0XD8, 0XD9, 0XDA,  0XDB, 0XDC, 0XDD, 0XDE
,  0XDF, 0XEF, 0XE0, 0XE1,  0XE2, 0XE3, 0XD6, 0XD2,  0XEC, 0XEB, 0XD7, 0XE8,  0XED, 0XE9, 0XE7, 0XEA
,  0XCE, 0XB0, 0XB1, 0XC6,  0XB4, 0XB5, 0XC4, 0XB3,  0XC5, 0XB8, 0XB9, 0XBA,  0XBB, 0XBC, 0XBD, 0XBE
,  0XBF, 0XCF, 0XC0, 0XC1,  0XC2, 0XC3, 0XB6, 0XB2,  0XCC, 0XCB, 0XB7, 0XC8,  0XCD, 0XC9, 0XC7, 0XCA
};

static const u_char
/*****************************************************************************************************/
ak[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,  0X90, 0X91, 0X92, 0X81,  0X87, 0XB2, 0xb6, 0xa6,  0x97, 0XB5, 0XA1, 0XA8,  0xbd, 0x98, 0XAC, 0X83

,  0X84, 0X89, 0X88, 0X86,  0X80, 0X8A, 0XAF, 0XB0,  0XAB, 0XA5, 0XBB, 0XB8,  0XB1, 0XA0, 0xbf, 0XB9
,  0XBA, 0x99, 0x9f, 0XAA,  0XA9, 0XA2, 0x9d, 0x94,  0XBC, 0X85, 0X82, 0X8D,  0X8C, 0X8E, 0X8F, 0X8B
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '', 0XB4, 0XA4,  0XB7, 0XA7, 0XBE, 0XAE,  0X9C, 0X95, 0X9E, 0X96,  0x93, 0x9b, 0XAD, 0X9A
};

static const u_char
/*****************************************************************************************************/
ka[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0XC4, 0XB3, 0XDA, 0XBF,  0XC0, 0XD9, 0XC3, 0XB4,  0XC2, 0XC1, 0XC5, 0XDF,  0XDC, 0XDB, 0XDD, 0XDE
,  0XB0, 0XB1, 0XB2, 0xfc,  0XD7, 0XF9, 0XFB, 0xb8,  0xbd, 0xd1, 0XFF, 0xfd,  0XF8, 0xd6, 0XFA, 0xd2
,  0XCD, 0XBA, 0XD5, 0XF1,  0XF3, 0XC9, 0xb7, 0XF5,  0XBB, 0XD4, 0XD3, 0XC8,  0XBE, 0xfe, 0XF7, 0XC6
,  0XC7, 0XCC, 0XB5, 0XF0,  0XF2, 0XB9, 0xb6, 0XF4,  0XCB, 0XCF, 0XD0, 0XCA,  0XD8, 0xbc, 0XF6, 0xce

,  0XEE, 0XA0, 0XA1, 0XE6,  0XA4, 0XA5, 0XE4, 0XA3,  0XE5, 0XA8, 0XA9, 0XAA,  0XAB, 0XAC, 0XAD, 0XAE
,  0XAF, 0XEF, 0XE0, 0XE1,  0XE2, 0XE3, 0XA6, 0XA2,  0XEC, 0XEB, 0XA7, 0XE8,  0XED, 0XE9, 0XE7, 0XEA
,  0X9E, 0X80, 0X81, 0X96,  0X84, 0X85, 0X94, 0X83,  0X95, 0X88, 0X89, 0X8A,  0X8B, 0X8C, 0X8D, 0X8E
,  0X8F, 0X9F, 0X90, 0X91,  0X92, 0X93, 0X86, 0X82,  0X9C, 0X9B, 0X87, 0X98,  0X9D, 0X99, 0X97, 0X9A
};

static const u_char
/*****************************************************************************************************/
aw[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0XC0, 0XC1, 0XC2, 0XC3,  0XC4, 0XC5, 0XC6, 0XC7,  0XC8, 0XC9, 0XCA, 0XCB,  0XCC, 0XCD, 0XCE, 0XCF
,  0XD0, 0XD1, 0XD2, 0XD3,  0XD4, 0XD5, 0XD6, 0XD7,  0XD8, 0XD9, 0XDA, 0XDB,  0XDC, 0XDD, 0XDE, 0XDF
,  0XE0, 0XE1, 0XE2, 0XE3,  0XE4, 0XE5, 0XE6, 0XE7,  0XE8, 0XE9, 0XEA, 0XEB,  0XEC, 0XED, 0XEE, 0XEF
,  0xa6, 0x84, 0x85, 0x86,  0x91, 0x80, 0xb2, 0xb3,  0x82, 0x92, 0x93, 0x94,  0xa5, 0x87, 0x81, 0x95

,  0x96, 0x97, 0x99, 0xab,  0xac, 0xae, 0x83, 0x8a,  0xb1, 0xb5, 0xb6, 0xbb,  0xad, 0x9e, 0xa9, 0x8c
,  0x8d, 0x88, 0x89, 0x8e,  0x8f, 0x9f, 0x8b, 0x9b,  0x90, 0xa3, 0xa7, 0xbc,  0xbd, 0x9a, 0x9c, 0xbe
,  0XF0, 0XF1, 0XF2, 0XF3,  0XF4, 0XF5, 0XF6, 0XF7,  0XF8, 0XF9, 0XFA, 0XFB,  0XFC, 0XFD, 0XFE, 0XFF
,  0XA8, 0XB8, 0XAA, 0XBA,  0XAF, 0XBF, 0XA1, 0XA2,  0XB0, 0x9d, 0XB7, 0x98,  0XB9, 0XA4, 0xb4, 0XA0
};

static const u_char
/*****************************************************************************************************/
wa[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0xb5, 0xbe, 0xb8, 0xc6,  0xb1, 0xb2, 0xb3, 0xbd,  0xd1, 0xd2, 0xc7, 0xd6,  0xcf, 0xd0, 0xd3, 0xd4
,  0xd8, 0xb4, 0xb9, 0xba,  0xbb, 0xbf, 0xc0, 0xc1,  0xfb, 0xc2, 0xdd, 0xd7,  0xde, 0xf9, 0xcd, 0xd5
,  0XFF, 0XF6, 0XF7, 0xd9,  0XFD, 0xbc, 0xb0, 0xda,  0XF0, 0xce, 0XF2, 0xc3,  0xc4, 0xcc, 0xc5, 0XF4
,  0XF8, 0xc8, 0xb6, 0xb7,  0xfe, 0xc9, 0xca, 0XFA,  0XF1, 0XFC, 0XF3, 0xcb,  0xdb, 0xdc, 0xdf, 0XF5

,  0X80, 0X81, 0X82, 0X83,  0X84, 0X85, 0X86, 0X87,  0X88, 0X89, 0X8A, 0X8B,  0X8C, 0X8D, 0X8E, 0X8F
,  0X90, 0X91, 0X92, 0X93,  0X94, 0X95, 0X96, 0X97,  0X98, 0X99, 0X9A, 0X9B,  0X9C, 0X9D, 0X9E, 0X9F
,  0XA0, 0XA1, 0XA2, 0XA3,  0XA4, 0XA5, 0XA6, 0XA7,  0XA8, 0XA9, 0XAA, 0XAB,  0XAC, 0XAD, 0XAE, 0XAF
,  0XE0, 0XE1, 0XE2, 0XE3,  0XE4, 0XE5, 0XE6, 0XE7,  0XE8, 0XE9, 0XEA, 0XEB,  0XEC, 0XED, 0XEE, 0XEF
};

static const u_char
/*****************************************************************************************************/
iw[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0xb0, 0xa4, 0xb7, 0x8b,  0x9b, 0xb4, 0x82, 0x84,  0x85, 0x86, 0x87, 0x88,  0x89, 0x91, 0x92, 0x93
,  0x94, 0x95, 0x96, 0x97,  0x99, 0xa5, 0xa9, 0xab,  0X98, 0xac, 0xae, 0xb1,  0xb5, 0xb6, 0xbb, 0xa6
,  0XA0, 0XA8, 0X80, 0X81,  0XAA, 0XBD, 0XB2, 0XAF,  0XA3, 0X8A, 0X8C, 0X8E,  0X8D, 0XAD, 0XA1, 0X8F
,  0XC0, 0XC1, 0XC2, 0XC3,  0XC4, 0XC5, 0XC6, 0XC7,  0XC8, 0XC9, 0XCA, 0XCB,  0XCC, 0XCD, 0XCE, 0XCF

,  0XD0, 0XD1, 0XD2, 0XD3,  0XD4, 0XD5, 0XD6, 0XD7,  0XD8, 0XD9, 0XDA, 0XDB,  0XDC, 0XDD, 0XDE, 0XDF
,  0XE0, 0XE1, 0XE2, 0XE3,  0XE4, 0XE5, 0XE6, 0XE7,  0XE8, 0XE9, 0XEA, 0XEB,  0XEC, 0XED, 0XEE, 0XEF
,  0XF0, 0XF1, 0XF2, 0XF3,  0XF4, 0XF5, 0XF6, 0XF7,  0XF8, 0XF9, 0XFA, 0XFB,  0XFC, 0XFD, 0XFE, 0XFF
,  0XB9, 0XB8, 0X90, 0X83,  0XBA, 0XBE, 0XB3, 0XBF,  0XBC, 0X9A, 0X9C, 0X9E,  0X9D, 0XA7, 0XA2, 0X9F
};

static const u_char
/*****************************************************************************************************/
wi[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0XA2, 0XA3, 0x86, 0XF3,  0x87, 0x88, 0x89, 0x8a,  0x8b, 0x8c, 0XA9, 0x83,  0XAA, 0XAC, 0XAB, 0XAF
,  0XF2, 0x8d, 0x8e, 0x8f,  0x90, 0x91, 0x92, 0x93,  0X98, 0x94, 0XF9, 0x84,  0XFA, 0XFC, 0XFB, 0XFF
,  0XA0, 0XAE, 0XFE, 0XA8,  0x81, 0x95, 0x9f, 0XFD,  0XA1, 0x96, 0XA4, 0x97,  0x99, 0XAD, 0x9a, 0XA7
,  0x80, 0x9b, 0XA6, 0XF6,  0x85, 0x9c, 0x9d, 0x82,  0XF1, 0XF0, 0XF4, 0x9e,  0XF8, 0XA5, 0XF5, 0XF7

,  0XB0, 0XB1, 0XB2, 0XB3,  0XB4, 0XB5, 0XB6, 0XB7,  0XB8, 0XB9, 0XBA, 0XBB,  0XBC, 0XBD, 0XBE, 0XBF
,  0XC0, 0XC1, 0XC2, 0XC3,  0XC4, 0XC5, 0XC6, 0XC7,  0XC8, 0XC9, 0XCA, 0XCB,  0XCC, 0XCD, 0XCE, 0XCF
,  0XD0, 0XD1, 0XD2, 0XD3,  0XD4, 0XD5, 0XD6, 0XD7,  0XD8, 0XD9, 0XDA, 0XDB,  0XDC, 0XDD, 0XDE, 0XDF
,  0XE0, 0XE1, 0XE2, 0XE3,  0XE4, 0XE5, 0XE6, 0XE7,  0XE8, 0XE9, 0XEA, 0XEB,  0XEC, 0XED, 0XEE, 0XEF
};

static const u_char
/*****************************************************************************************************/
kw[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0xac, 0x86, 0xa7, 0x95,  0x96, 0xa3, 0xab, 0x91,  0x99, 0x97, 0xae, 0xbe,  0xbd, 0xbc, 0x9a, 0x9c
,  0xa6, 0x84, 0x85, 0xb9,  0x9b, 0x9d, 0x98, 0x82,  0x87, 0x88, 0XA0, 0xa4,  0XB0, 0x8b, 0XB7, 0x89
,  0x9e, 0x93, 0x9f, 0XB8,  0XBA, 0xb5, 0XB3, 0XBF,  0x94, 0x8f, 0x8e, 0xb1,  0x81, 0XB4, 0XA2, 0x83
,  0x8a, 0xad, 0x80, 0XA8,  0XAA, 0x92, 0XB2, 0XAF,  0xbb, 0x8c, 0x8d, 0xb6,  0x90, 0XA5, 0XA1, 0XA9

,  0XFE, 0XE0, 0XE1, 0XF6,  0XE4, 0XE5, 0XF4, 0XE3,  0XF5, 0XE8, 0XE9, 0XEA,  0XEB, 0XEC, 0XED, 0XEE
,  0XEF, 0XFF, 0XF0, 0XF1,  0XF2, 0XF3, 0XE6, 0XE2,  0XFC, 0XFB, 0XE7, 0XF8,  0XFD, 0XF9, 0XF7, 0XFA
,  0XDE, 0XC0, 0XC1, 0XD6,  0XC4, 0XC5, 0XD4, 0XC3,  0XD5, 0XC8, 0XC9, 0XCA,  0XCB, 0XCC, 0XCD, 0XCE
,  0XCF, 0XDF, 0XD0, 0XD1,  0XD2, 0XD3, 0XC6, 0XC2,  0XDC, 0XDB, 0XC7, 0XD8,  0XDD, 0XD9, 0XD7, 0XDA
};

static const u_char
/*****************************************************************************************************/
wk[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0xb2, 0xac, 0x97, 0xaf,  0x91, 0x92, 0x81, 0x98,  0x99, 0x9f, 0xb0, 0x9d,  0xb9, 0xba, 0xaa, 0xa9
,  0xbc, 0x87, 0xb5, 0xa1,  0xa8, 0x83, 0x84, 0x89,  0x96, 0x88, 0x8e, 0x94,  0x8f, 0x95, 0xa0, 0xa2
,  0X9A, 0XBE, 0XAE, 0x85,  0x9b, 0XBD, 0x90, 0x82,   '', 0XBF, 0XB4, 0x86,  0x80, 0xb1, 0x8a, 0XB7
,  0X9C, 0xab, 0XB6, 0XA6,  0XAD, 0xa5, 0xbb, 0X9E,   '', 0x93, 0XA4, 0xb8,  0x8d, 0x8c, 0x8b, 0XA7

,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
};

static const u_char
/*****************************************************************************************************/
kz[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0X99, 0X8D, 0X86, 0X92,  0X93, 0X85, 0X98, 0X8E,  0X95, 0X94, 0X9A, 0X89,  0X88, 0X87, 0XA6, 0XCC
,  0X8A, 0X8B, 0X8C, 0XB3,  0XCE, 0XA8, 0XB9, 0XA9,  0XA2, 0XD0, 0XA0, 0XB2,  0XB0, 0XCD, 0XB7, 0XCA
,  0X82, 0X90, 0X84, 0XB1,  0XBE, 0X9C, 0XC0, 0XA7,  0X91, 0XC8, 0XCB, 0X9B,  0XA5, 0X81, 0XB8, 0XE3
,  0XC3, 0X9F, 0XC1, 0XAD,  0X80, 0X8F, 0XC2, 0XB6,  0X9E, 0XA4, 0XF0, 0X9D,  0XCF, 0X96, 0XF7, 0X97

,  0XAF, 0XE1, 0XED, 0XB5,  0XF1, 0XD1, 0XF5, 0XFA,  0XD5, 0XBF, 0XAE, 0XAC,  0XBD, 0XBC, 0XA1, 0XAB
,  0XBB, 0XB4, 0XD3, 0XDF,  0XD4, 0XD2, 0XAA, 0XF3,  0XFD, 0XD9, 0XBA, 0XDE,  0XDD, 0XDA, 0XFE, 0XDB
,  0XD7, 0XC7, 0XFC, 0XFB,  0XE4, 0XE0, 0XF6, 0XE2,  0XF2, 0XEA, 0XEB, 0XE8,  0XEF, 0XEE, 0XEC, 0XC4
,  0XC5, 0X83, 0XC9, 0XE6,  0XC6, 0XF4, 0XE5, 0XE9,  0XA3, 0XF8, 0XE7, 0XFF,  0XD8, 0XD6, 0XF9, 0XDC
};

static const u_char
/*****************************************************************************************************/
zk[] =                                               /* iconv -f cp1252 -t cp850 | iconv -f cp866 ****
 *****************************************************************************************************/
{   128,  255

,  0XB4, 0XAD, 0XA0,  '',  0XA2, 0X85, 0X82, 0X8D,  0X8C, 0X8B, 0X90, 0X91,  0X92, 0X81, 0X87, 0XB5
,  0XA1, 0XA8, 0X83, 0X84,  0X89, 0X88, 0XBD, 0XBF,  0X86, 0X80, 0X8A, 0XAB,  0XA5, 0XBB, 0XB8, 0XB1
,  0X9A,  '', 0X98,  '',  0XB9, 0XAC, 0X8E, 0XA7,  0X95, 0X97,  '',  '',   '',  '',  '',  ''
,  0X9C,  '', 0X9B, 0X93,   '',  '', 0XB7, 0X9E,  0XAE, 0X96,  '',  '',   '',  '', 0XA4,  ''

,  0XA6, 0XB2, 0XB6, 0XB0,   '',  '',  '',  '',  0XA9,  '', 0X9F, 0XAA,  0X8F, 0X9D, 0X94, 0XBC
,  0X99,  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '', 0XAF,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,  0XBA,  '',  '',  '',   '',  '',  '', 0XBE,   '',  '',  '',  '',   '',  '',  '',  ''
};

static const u_char
/*****************************************************************************************************/
za[] =                                                                /* iconv -f cp1252 -t cp850 ****
 *****************************************************************************************************/
{   128,  255

,  0xf2, 0xfe, 0xcd, 0X9F,  0xd5, 0xd9, 0xda, 0xdb,  0xdc, 0xdf, 0xb0, 0xb1,  0xb2, 0xb3, 0xb4, 0xb9
,  0xba, 0xbb, 0xbf, 0xc0,  0xc1, 0xc2, 0xbc, 0xce,  0xc3, 0xc4, 0xc5, 0xc8,  0xc9, 0xca, 0xcb, 0xcc
,  0XFF, 0XAD, 0XBD, 0X9C,  0XCF, 0XBE, 0XDD, 0XF5,  0XF9, 0XB8, 0XA6, 0XAE,  0XAA, 0XF0, 0XA9, 0XEE
,  0XF8, 0XF1, 0XFD, 0XFC,  0XEF, 0XE6, 0XF4, 0XFA,  0XF7, 0XFB, 0XA7, 0XAF,  0XAC, 0XAB, 0XF3, 0XA8

,  0XB7, 0XB5, 0XB6, 0XC7,  0X8E, 0X8F, 0X92, 0X80,  0XD4, 0X90, 0XD2, 0XD3,  0XDE, 0XD6, 0XD7, 0XD8
,  0XD1, 0XA5, 0XE3, 0XE0,  0XE2, 0XE5, 0X99, 0X9E,  0X9D, 0XEB, 0XE9, 0XEA,  0X9A, 0XED, 0XE8, 0XE1
,  0X85, 0XA0, 0X83, 0XC6,  0X84, 0X86, 0X91, 0X87,  0X8A, 0X82, 0X88, 0X89,  0X8D, 0XA1, 0X8C, 0X8B
,  0XD0, 0XA4, 0X95, 0XA2,  0X93, 0XE4, 0X94, 0XF6,  0X9B, 0X97, 0XA3, 0X96,  0X81, 0XEC, 0XE7, 0X98
};

static const u_char
/*****************************************************************************************************/
az[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0XC7, 0XFC, 0XE9, 0XE2,  0XE4, 0XE0, 0XE5, 0XE7,  0XEA, 0XEB, 0XE8, 0XEF,  0XEE, 0XEC, 0XC4, 0XC5
,  0XC9, 0XE6, 0XC6, 0XF4,  0XF6, 0XF2, 0XFB, 0XF9,  0XFF, 0XD6, 0XDC, 0XF8,  0XA3, 0XD8, 0XD7, 0X83
,  0XE1, 0XED, 0XF3, 0XFA,  0XF1, 0XD1, 0XAA, 0XBA,  0XBF, 0XAE, 0XAC, 0XBD,  0XBC, 0XA1, 0XAB, 0XBB
,  0x8a, 0x8b, 0x8c, 0x8d,  0x8e, 0XC1, 0XC2, 0XC0,  0XA9, 0x8f, 0x90, 0x91,  0x96, 0XA2, 0XA5, 0x92

,  0x93, 0x94, 0x95, 0x98,  0x99, 0x9a, 0XE3, 0XC3,  0x9b, 0x9c, 0x9d, 0x9e,  0x9f, 0x82, 0x97, 0XA4
,  0XF0, 0XD0, 0XCA, 0XCB,  0XC8, 0x84, 0XCD, 0XCE,  0XCF, 0x85, 0x86, 0x87,  0x88, 0XA6, 0XCC, 0x89
,  0XD3, 0XDF, 0XD4, 0XD2,  0XF5, 0XD5, 0XB5, 0XFE,  0XDE, 0XDA, 0XDB, 0XD9,  0XFD, 0XDD, 0XAF, 0XB4
,  0XAD, 0XB1, 0x80, 0XBE,  0XB6, 0XA7, 0XF7, 0XB8,  0XB0, 0XA8, 0XB7, 0XB9,  0XB3, 0XB2, 0x81, 0XA0
};

static const u_char
/*****************************************************************************************************/
Kk[] =                                                                                           /****
 *****************************************************************************************************/
{    34,  126
             ,  '',  '#',   '$',  '%',  '?',  '',   '(',  ')',  '*',  '+',   '',  '-',  '',  '|'
,   '0',  '1',  '2',  '3',   '4',  '5',  '6',  '7',   '8',  '9',  '',  '',   '',  '=',  '',  '&'

,   '@',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',  '\\',  '',  '^',  '_'
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '/',  '',  ''

,   163,  163
                   ,  '`'
,   179,  179
                   ,  '~'
,   192,  255

,   '.',  'f',  ',',  'w',   'l',  't',  'a',  'u',   '[',  'b',  'q',  'r',   'k',  'v',  'y',  'j'
,   'g',  'z',  'h',  'c',   'n',  'e',  ';',  'd',   'm',  's',  'p',  'i',  '\'',  'o',  'x',  ']'
,   '>',  'F',  '<',  'W',   'L',  'T',  'A',  'U',   '{',  'B',  'Q',  'R',   'K',  'V',  'Y',  'J'
,   'G',  'Z',  'H',  'C',   'N',  'E',  ':',  'D',   'M',  'S',  'P',  'I',   '"',  'O',  'X',  '}'
};

static const u_char
/*****************************************************************************************************/
kk[] =                                                                                           /****
 *****************************************************************************************************/
{     0,  255
,     0, 0X01, 0X02, 0X03,  0X04, 0X05, 0X06, 0X07,  0X08, 0X09, 0X0A, 0X0B,  0X0C, 0X0D, 0X0E, 0X0F
,  0X10, 0X11, 0X12, 0X13,  0X14, 0X15, 0X16, 0X17,  0X18, 0X19, 0X1A, 0X1B,  0X1C, 0X1D, 0X1E, 0X1F
,   ' ',  '!',  '"',  '#',   '$',  '%',  '&', '\'',   '(',  ')',  '*',  '+',   ',',  '-',  '.',  '/'
,   '0',  '1',  '2',  '3',   '4',  '5',  '6',  '7',   '8',  '9',  ':',  ';',   '<',  '=',  '>',  '?'

,   '@',  'A',  'B',  'C',   'D',  'E',  'F',  'G',   'H',  'I',  'J',  'K',   'L',  'M',  'N',  'O'
,   'P',  'Q',  'R',  'S',   'T',  'U',  'V',  'W',   'X',  'Y',  'Z',  '[',  '\\',  ']',  '^',  '_'
,   '`',  'a',  'b',  'c',   'd',  'e',  'f',  'g',   'h',  'i',  'j',  'k',   'l',  'm',  'n',  'o'
,   'p',  'q',  'r',  's',   't',  'u',  'v',  'w',   'x',  'y',  'z',  '{',   '|',  '}',  '~', 0X7F

,  0X80, 0X81, 0X82, 0X83,  0X84, 0X85, 0X86, 0X87,  0X88, 0X89, 0X8A, 0X8B,  0X8C, 0X8D, 0X8E, 0X8F
,  0X90, 0X91, 0X92, 0X93,  0X94, 0X95, 0X96, 0X97,  0X98, 0X99, 0X9A, 0X9B,  0X9C, 0X9D, 0X9E, 0X9F
,  0XA0, 0XA1, 0XA2,  '',  0XA4, 0XA5, 0XA6, 0XA7,  0XA8, 0XA9, 0XAA, 0XAB,  0XAC, 0XAD, 0XAE, 0XAF
,  0XB0, 0XB1, 0XB2,  '',  0XB4, 0XB5, 0XB6, 0XB7,  0XB8, 0XB9, 0XBA, 0XBB,  0XBC, 0XBD, 0XBE, 0XBF

,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
};

static const u_char
/*****************************************************************************************************/
wz[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0XC1, 0XA5, 0XA9, 0XE3,  0X8B, 0X8C, 0X8D, 0XA2,  0XD0, 0XCA, 0XC3, 0XCD,  0XA4, 0XF0, 0XCB, 0XC8
,  0XCF, 0X8E, 0X8F, 0X90,  0X91, 0X92, 0X93, 0X94,  0XB9, 0X95, 0XA6, 0XCE,  0XCC, 0XA8, 0X82, 0X84
,  0XA0, 0XF7, 0XB8, 0X85,  0XB2, 0X96, 0X8A, 0X86,  0XAD, 0X97, 0X80, 0X98,  0X99, 0X9F, 0X9A, 0XB6
,  0XB0, 0X9B, 0XC2, 0XC0,  0X81, 0X9C, 0X9D, 0XB7,  0XB1, 0XB3, 0XBE, 0X9E,  0X87, 0X88, 0X89, 0XA7

,  0XC7, 0XFC, 0XE9, 0XE2,  0XE4, 0XE0, 0XE5, 0XE7,  0XEA, 0XEB, 0XE8, 0XEF,  0XEE, 0XEC, 0XC4, 0XC5
,  0XC9, 0XE6, 0XC6, 0XF4,  0XF6, 0XF2, 0XFB, 0XF9,  0XFF, 0XD6, 0XDC, 0XF8,  0XA3, 0XD8, 0XD7, 0X83
,  0XE1, 0XED, 0XF3, 0XFA,  0XF1, 0XD1, 0XAA, 0XBA,  0XBF, 0XAE, 0XAC, 0XBD,  0XBC, 0XA1, 0XAB, 0XBB
,  0XD3, 0XDF, 0XD4, 0XD2,  0XF5, 0XD5, 0XB5, 0XFE,  0XDE, 0XDA, 0XDB, 0XD9,  0XFD, 0XDD, 0XAF, 0XB4
};

static const u_char
/*****************************************************************************************************/
wm[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0XAB, 0XAE, 0xc5, 0XAF,  0XD7, 0XC9, 0XA0, 0xb2,  0xb3, 0xd6, 0XBC, 0xc4,  0XBE, 0XCD, 0XCB, 0XDA
,  0XAC, 0XD4, 0XD5, 0XD2,  0XD3, 0XA5, 0XD0, 0XD1,  0xc3, 0XAA, 0XBD, 0xb0,  0XBF, 0XCE, 0XCC, 0XDB
,  0XCA, 0XD8, 0XD9, 0XB7,  0XFF, 0XA2, 0xc6, 0XA4,  0XDD, 0XA9, 0XB8, 0XC7,  0XC2, 0xad, 0XA8, 0XBA
,  0XA1, 0XB1, 0XA7, 0XB4,  0XB6, 0XB5, 0XA6, 0xa3,  0XDE, 0XDC, 0XB9, 0XC8,  0XC0, 0XC1, 0XCF, 0XBB

,  0X80, 0X81, 0X82, 0X83,  0X84, 0X85, 0X86, 0X87,  0X88, 0X89, 0X8A, 0X8B,  0X8C, 0X8D, 0X8E, 0X8F
,  0X90, 0X91, 0X92, 0X93,  0X94, 0X95, 0X96, 0X97,  0X98, 0X99, 0X9A, 0X9B,  0X9C, 0X9D, 0X9E, 0X9F
,  0XE0, 0XE1, 0XE2, 0XE3,  0XE4, 0XE5, 0XE6, 0XE7,  0XE8, 0XE9, 0XEA, 0XEB,  0XEC, 0XED, 0XEE, 0XEF
,  0XF0, 0XF1, 0XF2, 0XF3,  0XF4, 0XF5, 0XF6, 0XF7,  0XF8, 0XF9, 0XFA, 0XFB,  0XFC, 0XFD, 0XFE, 0XDF
};

static const u_char
/*****************************************************************************************************/
am[] =                                                                                           /****
 *****************************************************************************************************/
{   160,  255

,  0XE0, 0XE1, 0XE2, 0XE3,  0XE4, 0XE5, 0XE6, 0XE7,  0XE8, 0XE9, 0XEA, 0XEB,  0XEC, 0XED, 0XEE, 0XEF
,  0xc6, 0xd7, 0xc9, 0xa0,  0xd4, 0xab, 0xa7, 0xb4,  0xc5, 0xd5, 0xd2, 0xd3,  0xa2, 0xb2, 0xae, 0xa5

,  0xd0, 0xd1, 0xaa, 0xc7,  0xc2, 0xa8, 0xaf, 0xbc,  0xb1, 0xb5, 0xa6, 0xc8,  0xad, 0xcc, 0xa9, 0xbe
,  0xcd, 0xb3, 0xd6, 0xcb,  0xda, 0xdb, 0xc4, 0xb0,  0xac, 0xb7, 0xa4, 0xc0,  0xc1, 0xbd, 0xbf, 0xcf
,  0XF0, 0XF1, 0XF2, 0XF3,  0XF4, 0XF5, 0XF6, 0XF7,  0XF8, 0XF9, 0XFA, 0XFB,  0XFC, 0XFD, 0XFE, 0XDF
,  0XDD, 0XDE, 0XB8, 0XB9,  0XBA, 0XBB, 0XD8, 0XD9,  0XA1, 0xce, 0xa3, 0XC3,  0XDC, 0XFF, 0xb6, 0XCA
};

static const u_char
/*****************************************************************************************************/
zw[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0XAA, 0XB4, 0X9E, 0XDF,  0X9F, 0XA3, 0XA7, 0XBC,  0XBD, 0XBE, 0XA6, 0X84,  0X85, 0X86, 0X91, 0X92
,  0X93, 0X94, 0X95, 0X96,  0X97, 0X99, 0XA5, 0XA9,  0XAB, 0XAC, 0XAE, 0XB1,  0XB5, 0XB6, 0XBB, 0XAD
,  0XA0, 0XED, 0X87, 0XDC,  0X8C, 0X81, 0X9A, 0XBF,  0X9D, 0X82, 0XE6, 0XEE,  0XEA, 0XA8, 0XE9, 0XFE
,  0XB0, 0XB8, 0XA4, 0XB9,  0XFF, 0XF6, 0XAF, 0XB7,  0XA2, 0X98, 0XE7, 0XEF,  0XEC, 0XEB, 0XBA, 0XE8

,  0XB3, 0X80, 0XB2, 0X8A,  0XCE, 0XCF, 0XD2, 0XC0,  0X8F, 0XD0, 0X89, 0X8E,  0X9C, 0X8B, 0X9B, 0X90
,  0X88, 0XE5, 0XF3, 0XF0,  0XF2, 0XF5, 0XD9, 0XDE,  0XDD, 0XFB, 0XF9, 0XFA,  0XDA, 0XFD, 0XF8, 0XF1
,  0XC5, 0XE0, 0XC3, 0X83,  0XC4, 0XC6, 0XD1, 0XC7,  0XCA, 0XC2, 0XC8, 0XC9,  0XCD, 0XE1, 0XCC, 0XCB
,  0X8D, 0XE4, 0XD5, 0XE2,  0XD3, 0XF4, 0XD4, 0XA1,  0XDB, 0XD7, 0XE3, 0XD6,  0XC1, 0XFC, 0XF7, 0XD8
};

static const u_char
/*****************************************************************************************************/
zi[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0XA4, 0X85, 0XFB, 0XCF,  0XFF, 0XA8, 0XFD, 0XF8,  0XA5, 0XF5, 0X9F, 0X87,  0X88, 0X89, 0X8D, 0X8E
,  0X8F, 0X90, 0X91, 0X92,  0X93, 0X94, 0X95, 0X96,  0X97, 0X99, 0X9A, 0X9B,  0X9C, 0X9D, 0X9E, 0XAD
,  0XA0, 0XDD, 0X8A, 0XCC,  0XAA, 0XA3, 0XF9, 0XF7,  0XFC, 0X86, 0XD6, 0XDE,  0XDA, 0XA1, 0XD9, 0XEE
,  0X80, 0XF1, 0X81, 0XF0,  0XEF, 0XE6, 0XA7, 0X82,  0XFE, 0X98, 0XD7, 0XDF,  0XDC, 0XDB, 0XF4, 0XD8

,  0XF6, 0XA2, 0XA6, 0XA9,  0XBE, 0XBF, 0XC2, 0XB0,  0XAF, 0XC0, 0X8C, 0XAB,  0XFA, 0X83, 0X84, 0XF2
,  0X8B, 0XD5, 0XE3, 0XE0,  0XE2, 0XE5, 0XC9, 0XCE,  0XCD, 0XEB, 0XE9, 0XEA,  0XCA, 0XED, 0XE8, 0XE1
,  0XB5, 0XD0, 0XB3, 0XF3,  0XB4, 0XB6, 0XC1, 0XB7,  0XBA, 0XB2, 0XB8, 0XB9,  0XBD, 0XD1, 0XBC, 0XBB
,  0XAC, 0XD4, 0XC5, 0XD2,  0XC3, 0XE4, 0XC4, 0XAE,  0XCB, 0XC7, 0XD3, 0XC6,  0XB1, 0XEC, 0XE7, 0XC8
};

static const u_char
/*****************************************************************************************************/
zm[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0XB8, 0XB6, 0XCC, 0X9F,  0XDB, 0XB7, 0XA4, 0XC0,  0XC1, 0XCF, 0XC6, 0XD7,  0XC9, 0XA0, 0XD4, 0XD5
,  0XD2, 0XD3, 0XA5, 0XD0,  0XD1, 0XAA, 0XA2, 0XA9,  0XC7, 0XC2, 0XA8, 0XB1,  0XB5, 0XA6, 0XC8, 0XAD
,  0XCA, 0XED, 0XB2, 0X9C,  0XBE, 0XAE, 0XBD, 0XBB,  0XCE, 0XC5, 0XE6, 0XEE,  0XEA, 0XDD, 0XE9, 0XFE
,  0XA1, 0XDE, 0XFF, 0XDC,  0XDF, 0XF6, 0XBA, 0XA3,  0XD9, 0XC3, 0XE7, 0XEF,  0XEC, 0XEB, 0XB9, 0XE8

,  0XB4, 0XAB, 0XA7, 0XBC,  0X8E, 0X8F, 0X92, 0X80,  0XDA, 0X90, 0XD6, 0XCB,  0XBF, 0XC4, 0XB0, 0XAC
,  0XB3, 0XE5, 0XF3, 0XF0,  0XF2, 0XF5, 0X99, 0X9E,  0X9D, 0XFB, 0XF9, 0XFA,  0X9A, 0XFD, 0XF8, 0XF1
,  0X85, 0XE0, 0X83, 0XAF,  0X84, 0X86, 0X91, 0X87,  0X8A, 0X82, 0X88, 0X89,  0X8D, 0XE1, 0X8C, 0X8B
,  0XCD, 0XE4, 0X95, 0XE2,  0X93, 0XF4, 0X94, 0XD8,  0X9B, 0X97, 0XE3, 0X96,  0X81, 0XFC, 0XF7, 0X98
};

static const u_char
/*****************************************************************************************************/
iz[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0XB0, 0XB2, 0XB7, 0XCD,  0XCE, 0X81, 0XA9, 0X8B,  0X8C, 0X8D, 0XA2, 0XD0,  0XCA, 0X8E, 0X8F, 0X90
,  0X91, 0X92, 0X93, 0X94,  0X95, 0X96, 0X97, 0X98,  0XB9, 0X99, 0X9A, 0X9B,  0X9C, 0X9D, 0X9E, 0X8A
,  0XA0, 0XAD, 0XC1, 0XA5,  0X80, 0X88, 0XC2, 0XB6,  0X85, 0XC3, 0XA4, 0XCB,  0XF0, 0X9F, 0XF7, 0XC8
,  0XC7, 0XFC, 0XE9, 0XE2,  0XE4, 0XE0, 0XE5, 0XE7,  0XEA, 0XEB, 0XE8, 0XEF,  0XEE, 0XEC, 0XC4, 0XC5

,  0XC9, 0XE6, 0XC6, 0XF4,  0XF6, 0XF2, 0XFB, 0XF9,  0XFF, 0XD6, 0XDC, 0XF8,  0XA3, 0XD8, 0XD7, 0X83
,  0XE1, 0XED, 0XF3, 0XFA,  0XF1, 0XD1, 0XAA, 0XBA,  0XBF, 0XAE, 0XAC, 0XBD,  0XBC, 0XA1, 0XAB, 0XBB
,  0XD3, 0XDF, 0XD4, 0XD2,  0XF5, 0XD5, 0XB5, 0XFE,  0XDE, 0XDA, 0XDB, 0XD9,  0XFD, 0XDD, 0XAF, 0XB4
,  0XB3, 0XB1, 0XCF, 0XE3,  0XBE, 0X89, 0XC0, 0XA7,  0X87, 0XA6, 0XCC, 0X82,  0XA8, 0X86, 0XB8, 0X84
};

static const u_char
/*****************************************************************************************************/
im[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0xa1, 0xff, 0xa3, 0xc4,  0xb0, 0xb6, 0xc5, 0xd7,  0xc9, 0xa0, 0xb2, 0xb3,  0xd6, 0xd4, 0xd5, 0xd2
,  0xd3, 0xa5, 0xd0, 0xd1,  0xaa, 0xa2, 0xa9, 0xc7,  0xc3, 0xc2, 0xa8, 0xb1,  0xb5, 0xa6, 0xc8, 0xc6
,  0XCA, 0XDD, 0XAB, 0XAE,  0XB8, 0XC1, 0XA7, 0XBA,  0XB7, 0XBC, 0XBE, 0XCB,  0XCD, 0xad, 0XD8, 0XDA
,  0X80, 0X81, 0X82, 0X83,  0X84, 0X85, 0X86, 0X87,  0X88, 0X89, 0X8A, 0X8B,  0X8C, 0X8D, 0X8E, 0X8F

,  0X90, 0X91, 0X92, 0X93,  0X94, 0X95, 0X96, 0X97,  0X98, 0X99, 0X9A, 0X9B,  0X9C, 0X9D, 0X9E, 0X9F
,  0XE0, 0XE1, 0XE2, 0XE3,  0XE4, 0XE5, 0XE6, 0XE7,  0XE8, 0XE9, 0XEA, 0XEB,  0XEC, 0XED, 0XEE, 0XEF
,  0XF0, 0XF1, 0XF2, 0XF3,  0XF4, 0XF5, 0XF6, 0XF7,  0XF8, 0XF9, 0XFA, 0XFB,  0XFC, 0XFD, 0XFE, 0XDF
,  0XDC, 0XDE, 0XAC, 0XAF,  0XB9, 0XCF, 0XB4, 0XBB,  0XC0, 0XBD, 0XBF, 0XCC,  0XCE, 0XA4, 0XD9, 0XDB
};

static const u_char
/*****************************************************************************************************/
km[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0xc2, 0xa0, 0xa4, 0xa5,  0xd0, 0xb7, 0xc7, 0xd4,  0xaa, 0xd1, 0xa8, 0xcf,  0xc1, 0xc0, 0xbd, 0xbf
,  0xc6, 0xd7, 0xc9, 0xdc,  0xb0, 0xce, 0XC3, 0XC5,  0XB2, 0XB3, 0XCA, 0xff,  0XA1, 0xc4, 0xa3, 0XD6
,  0xcc, 0xd2, 0xdb, 0XDE,  0XB9, 0xb5, 0XB4, 0XBB,  0xd3, 0xda, 0xcb, 0xb1,  0xae, 0XB6, 0XD9, 0xaf
,  0xbc, 0xad, 0xab, 0XDD,  0XB8, 0xd5, 0XA7, 0XBA,  0xc8, 0xbe, 0xcd, 0xa6,  0xac, 0XA2, 0XD8, 0XA9

,  0XFE, 0XE0, 0XE1, 0XF6,  0XE4, 0XE5, 0XF4, 0XE3,  0XF5, 0XE8, 0XE9, 0XEA,  0XEB, 0XEC, 0XED, 0XEE
,  0XEF, 0XDF, 0XF0, 0XF1,  0XF2, 0XF3, 0XE6, 0XE2,  0XFC, 0XFB, 0XE7, 0XF8,  0XFD, 0XF9, 0XF7, 0XFA
,  0X9E, 0X80, 0X81, 0X96,  0X84, 0X85, 0X94, 0X83,  0X95, 0X88, 0X89, 0X8A,  0X8B, 0X8C, 0X8D, 0X8E
,  0X8F, 0X9F, 0X90, 0X91,  0X92, 0X93, 0X86, 0X82,  0X9C, 0X9B, 0X87, 0X98,  0X9D, 0X99, 0X97, 0X9A
};

static const u_char
/*****************************************************************************************************/
mw[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0XC0, 0XC1, 0XC2, 0XC3,  0XC4, 0XC5, 0XC6, 0XC7,  0XC8, 0XC9, 0XCA, 0XCB,  0XCC, 0XCD, 0XCE, 0XCF
,  0XD0, 0XD1, 0XD2, 0XD3,  0XD4, 0XD5, 0XD6, 0XD7,  0XD8, 0XD9, 0XDA, 0XDB,  0XDC, 0XDD, 0XDE, 0XDF
,  0X86, 0XB0, 0XA5, 0xb7,  0XA7, 0X95, 0XB6, 0XB2,  0XAE, 0XA9, 0X99, 0X80,  0X90, 0xad, 0X81, 0X83
,  0x9b, 0XB1, 0x87, 0x88,  0XB3, 0XB5, 0XB4, 0XA3,  0XAA, 0XBA, 0XAF, 0XBF,  0X8A, 0X9A, 0X8C, 0X9C

,  0XBC, 0XBD, 0XAC, 0x98,  0x8b, 0x82, 0xa6, 0XAB,  0XBB, 0X85, 0XA0, 0X8E,  0X9E, 0X8D, 0X9D, 0XBE
,  0X96, 0X97, 0X93, 0X94,  0X91, 0X92, 0x89, 0X84,  0XA1, 0XA2, 0X8F, 0X9F,  0XB9, 0XA8, 0XB8, 0XFF
,  0XE0, 0XE1, 0XE2, 0XE3,  0XE4, 0XE5, 0XE6, 0XE7,  0XE8, 0XE9, 0XEA, 0XEB,  0XEC, 0XED, 0XEE, 0XEF
,  0XF0, 0XF1, 0XF2, 0XF3,  0XF4, 0XF5, 0XF6, 0XF7,  0XF8, 0XF9, 0XFA, 0XFB,  0XFC, 0XFD, 0XFE, 0XA4
};

static const u_char
/*****************************************************************************************************/
ma[] =                                                                                           /****
 *****************************************************************************************************/
{   160,  255

,  0xb3, 0XF8, 0xbc, 0xfa,  0xda, 0xbf, 0xca, 0xb6,  0xc5, 0xce, 0xc2, 0xb5,  0xd8, 0xcc, 0xbe, 0xc6
,  0xd7, 0xc8, 0xbd, 0xd1,  0xb7, 0xc9, 0xfe, 0xd9,  0XF2, 0XF3, 0XF4, 0XF5,  0xc7, 0xdd, 0xcf, 0xde

,  0xdb, 0xdc, 0xc4, 0XFB,  0xd6, 0xb8, 0xb0, 0xc3,  0xcb, 0xb2, 0XFF, 0xd3,  0xcd, 0xd0, 0xf9, 0xdf
,  0xc0, 0xc1, 0xba, 0xbb,  0xb4, 0xb9, 0xd2, 0xb1,  0XF6, 0XF7, 0xd4, 0xd5,  0XFC, 0XF0, 0XF1, 0XEF
,  0XA0, 0XA1, 0XA2, 0XA3,  0XA4, 0XA5, 0XA6, 0XA7,  0XA8, 0XA9, 0XAA, 0XAB,  0XAC, 0XAD, 0XAE, 0XAF
,  0XE0, 0XE1, 0XE2, 0XE3,  0XE4, 0XE5, 0XE6, 0XE7,  0XE8, 0XE9, 0XEA, 0XEB,  0XEC, 0XED, 0XEE, 0XFD
};

static const u_char
/*****************************************************************************************************/
mz[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0XC7, 0XFC, 0XE9, 0XE2,  0XE4, 0XE0, 0XE5, 0XE7,  0XEA, 0XEB, 0XE8, 0XEF,  0XEE, 0XEC, 0XC4, 0XC5
,  0XC9, 0XE6, 0XC6, 0XF4,  0XF6, 0XF2, 0XFB, 0XF9,  0XFF, 0XD6, 0XDC, 0XF8,  0XA3, 0XD8, 0XD7, 0X83
,  0X8D, 0XB0, 0X96, 0XB7,  0X86, 0X92, 0X9D, 0XC2,  0X9A, 0X97, 0X95, 0XC1,  0XCF, 0X9F, 0XA5, 0XE3
,  0XCE, 0X9B, 0XA2, 0XD0,  0XC0, 0X9C, 0X81, 0X85,  0X80, 0XBE, 0XB6, 0XA7,  0XC3, 0XA6, 0XA4, 0XCC

,  0X87, 0X88, 0X99, 0XB9,  0XCD, 0XA9, 0X8A, 0X98,  0X9E, 0X8C, 0XA0, 0XCB,  0X82, 0XF0, 0XA8, 0X89
,  0X93, 0X94, 0X90, 0X91,  0X8E, 0X8F, 0XCA, 0X8B,  0XF7, 0XB8, 0XC8, 0X84,  0XB3, 0XAD, 0XB1, 0XB4
,  0XE1, 0XED, 0XF3, 0XFA,  0XF1, 0XD1, 0XAA, 0XBA,  0XBF, 0XAE, 0XAC, 0XBD,  0XBC, 0XA1, 0XAB, 0XBB
,  0XD3, 0XDF, 0XD4, 0XD2,  0XF5, 0XD5, 0XB5, 0XFE,  0XDE, 0XDA, 0XDB, 0XD9,  0XFD, 0XDD, 0XAF, 0XB2
};

static const u_char
/*****************************************************************************************************/
mi[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,  0XB0, 0XB1, 0XB2, 0XB3,  0XB4, 0XB5, 0XB6, 0XB7,  0XB8, 0XB9, 0XBA, 0XBB,  0XBC, 0XBD, 0XBE, 0XBF
,  0XC0, 0XC1, 0XC2, 0XC3,  0XC4, 0XC5, 0XC6, 0XC7,  0XC8, 0XC9, 0XCA, 0XCB,  0XCC, 0XCD, 0XCE, 0XCF
,  0x89, 0x80, 0x95, 0x82,  0XFD, 0x91, 0x9d, 0XA6,  0x9a, 0x96, 0x94, 0XA2,  0XF2, 0xad, 0XA3, 0XF3
,  0x84, 0x9b, 0x8a, 0x8b,  0XF6, 0x9c, 0x85, 0XA8,  0XA4, 0XF4, 0XA7, 0XF7,  0XA9, 0XF9, 0XAA, 0XFA

,  0XF8, 0XA5, 0x99, 0x98,  0x83, 0x86, 0x9f, 0x97,  0x9e, 0x88, 0XA0, 0XAB,  0XFB, 0XAC, 0XFC, 0XF5
,  0x92, 0x93, 0x8f, 0x90,  0x8d, 0x8e, 0x8c, 0x87,  0XAE, 0XFE, 0XAF, 0XFF,  0XF0, 0XA1, 0XF1, 0XEF
,  0XD0, 0XD1, 0XD2, 0XD3,  0XD4, 0XD5, 0XD6, 0XD7,  0XD8, 0XD9, 0XDA, 0XDB,  0XDC, 0XDD, 0XDE, 0XDF
,  0XE0, 0XE1, 0XE2, 0XE3,  0XE4, 0XE5, 0XE6, 0XE7,  0XE8, 0XE9, 0XEA, 0XEB,  0XEC, 0XED, 0XEE, 0x81
};

static const u_char
/*****************************************************************************************************/
mk[] =                                                                                           /****
 *****************************************************************************************************/
{   128,  255

,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,  0x81, 0X9C, 0XBD, 0x9e,  0x82, 0x83, 0xbb, 0XB6,  0x8a, 0XBF, 0x88, 0xb2,  0xbc, 0xb1, 0xac, 0xaf
,  0x94, 0xab, 0X98, 0X99,  0XA6, 0xa5, 0XAD, 0x85,  0XB4, 0XA4, 0XB7, 0XA7,  0xb0, 0x8e, 0xb9, 0x8f

,  0x8d, 0x8c, 0x80, 0X96,  0x9d, 0X97, 0x90, 0x86,  0xb8, 0x92, 0X9A, 0xaa,  0xa0, 0xba, 0x95, 0x8b
,  0x84, 0x89, 0xa1, 0xa8,  0x87, 0xb5, 0X9F, 0x91,  0XBE, 0XAE, 0xa9, 0xa2,  0x93,  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '', 0x9b
};

static const u_char
/*****************************************************************************************************/
kZ[] =                                                                                           /****
 *****************************************************************************************************/
{     0,  255
,     0, 0X01, 0X02, 0X03,  0X04, 0X05, 0X06, 0X07,  0X08, 0X09, 0X0A, 0X0B,  0X0C, 0X0D, 0X0E, 0X0F
,  0X10, 0X11, 0X12, 0X13,  0X14, 0X15, 0X16, 0X17,  0X18, 0X19, 0X1A, 0X1B,  0X1C, 0X1D, 0X1E, 0X1F
,   ' ',  '!',  '"',  '#',   '$',  '%',  '&', '\'',   '(',  ')',  '*',  '+',   ',',  '-',  '.',  '/'
,   '0',  '1',  '2',  '3',   '4',  '5',  '6',  '7',   '8',  '9',  ':',  ';',   '<',  '=',  '>',  '?'

,   '@',  'a',  'b',  'c',   'd',  'e',  'f',  'g',   'h',  'i',  'j',  'k',   'l',  'm',  'n',  'o'
,   'p',  'q',  'r',  's',   't',  'u',  'v',  'w',   'x',  'y',  'z',  '[',  '\\',  ']',  '^',  '_'
,   '`',  'A',  'B',  'C',   'D',  'E',  'F',  'G',   'H',  'I',  'J',  'K',   'L',  'M',  'N',  'O'
,   'P',  'Q',  'R',  'S',   'T',  'U',  'V',  'W',   'X',  'Y',  'Z',  '{',   '|',  '}',  '~', 0X7F

,  0X80, 0X81, 0X82, 0X83,  0X84, 0X85, 0X86, 0X87,  0X88, 0X89, 0X8A, 0X8B,  0X8C, 0X8D, 0X8E, 0X8F
,  0X90, 0X91, 0X92, 0X93,  0X94, 0X95, 0X96, 0X97,  0X98, 0X99, 0X9A, 0X9B,  0X9C, 0X9D, 0X9E, 0X9F
,  0XA0, 0XA1, 0XA2,  '',  0XA4, 0XA5, 0XA6, 0XA7,  0XA8, 0XA9, 0XAA, 0XAB,  0XAC, 0XAD, 0XAE, 0XAF
,  0XB0, 0XB1, 0XB2,  '',  0XB4, 0XB5, 0XB6, 0XB7,  0XB8, 0XB9, 0XBA, 0XBB,  0XBC, 0XBD, 0XBE, 0XBF

,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
};

static const u_char
/*****************************************************************************************************/
kY[] =                                                                                           /****
 *****************************************************************************************************/
{     0,  255
,     0, 0X01, 0X02, 0X03,  0X04, 0X05, 0X06, 0X07,  0X08, 0X09, 0X0A, 0X0B,  0X0C, 0X0D, 0X0E, 0X0F
,  0X10, 0X11, 0X12, 0X13,  0X14, 0X15, 0X16, 0X17,  0X18, 0X19, 0X1A, 0X1B,  0X1C, 0X1D, 0X1E, 0X1F
,   ' ',  '!',  '"',  '#',   '$',  '%',  '&', '\'',   '(',  ')',  '*',  '+',   ',',  '-',  '.',  '/'
,   '0',  '1',  '2',  '3',   '4',  '5',  '6',  '7',   '8',  '9',  ':',  ';',   '<',  '=',  '>',  '?'

,   '@',  'A',  'B',  'C',   'D',  'E',  'F',  'G',   'H',  'I',  'J',  'K',   'L',  'M',  'N',  'O'
,   'P',  'Q',  'R',  'S',   'T',  'U',  'V',  'W',   'X',  'Y',  'Z',  '[',  '\\',  ']',  '^',  '_'
,   '`',  'A',  'B',  'C',   'D',  'E',  'F',  'G',   'H',  'I',  'J',  'K',   'L',  'M',  'N',  'O'
,   'P',  'Q',  'R',  'S',   'T',  'U',  'V',  'W',   'X',  'Y',  'Z',  '{',   '|',  '}',  '~', 0X7F

,  0X80, 0X81, 0X82, 0X83,  0X84, 0X85, 0X86, 0X87,  0X88, 0X89, 0X8A, 0X8B,  0X8C, 0X8D, 0X8E, 0X8F
,  0X90, 0X91, 0X92, 0X93,  0X94, 0X95, 0X96, 0X97,  0X98, 0X99, 0X9A, 0X9B,  0X9C, 0X9D, 0X9E, 0X9F
,  0XA0, 0XA1, 0XA2,  '',  0XA4, 0XA5, 0XA6, 0XA7,  0XA8, 0XA9, 0XAA, 0XAB,  0XAC, 0XAD, 0XAE, 0XAF
,  0XB0, 0XB1, 0XB2,  '',  0XB4, 0XB5, 0XB6, 0XB7,  0XB8, 0XB9, 0XBA, 0XBB,  0XBC, 0XBD, 0XBE, 0XBF

,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
};

static const u_char
/*****************************************************************************************************/
Yk[] =                                                                                           /****
 *****************************************************************************************************/
{     0,  255
,     0, 0X01, 0X02, 0X03,  0X04, 0X05, 0X06, 0X07,  0X08, 0X09, 0X0A, 0X0B,  0X0C, 0X0D, 0X0E, 0X0F
,  0X10, 0X11, 0X12, 0X13,  0X14, 0X15, 0X16, 0X17,  0X18, 0X19, 0X1A, 0X1B,  0X1C, 0X1D, 0X1E, 0X1F
,   ' ',  '!',  '"',  '#',   '$',  '%',  '&', '\'',   '(',  ')',  '*',  '+',   ',',  '-',  '.',  '/'
,   '0',  '1',  '2',  '3',   '4',  '5',  '6',  '7',   '8',  '9',  ':',  ';',   '<',  '=',  '>',  '?'

,   '@',  'a',  'b',  'c',   'd',  'e',  'f',  'g',   'h',  'i',  'j',  'k',   'l',  'm',  'n',  'o'
,   'p',  'q',  'r',  's',   't',  'u',  'v',  'w',   'x',  'y',  'z',  '[',  '\\',  ']',  '^',  '_'
,   '`',  'a',  'b',  'c',   'd',  'e',  'f',  'g',   'h',  'i',  'j',  'k',   'l',  'm',  'n',  'o'
,   'p',  'q',  'r',  's',   't',  'u',  'v',  'w',   'x',  'y',  'z',  '{',   '|',  '}',  '~', 0X7F

,  0X80, 0X81, 0X82, 0X83,  0X84, 0X85, 0X86, 0X87,  0X88, 0X89, 0X8A, 0X8B,  0X8C, 0X8D, 0X8E, 0X8F
,  0X90, 0X91, 0X92, 0X93,  0X94, 0X95, 0X96, 0X97,  0X98, 0X99, 0X9A, 0X9B,  0X9C, 0X9D, 0X9E, 0X9F
,  0XA0, 0XA1, 0XA2,  '',  0XA4, 0XA5, 0XA6, 0XA7,  0XA8, 0XA9, 0XAA, 0XAB,  0XAC, 0XAD, 0XAE, 0XAF
,  0XB0, 0XB1, 0XB2,  '',  0XB4, 0XB5, 0XB6, 0XB7,  0XB8, 0XB9, 0XBA, 0XBB,  0XBC, 0XBD, 0XBE, 0XBF

,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
};

static const u_char
/*****************************************************************************************************/
ek[] =                                                                                        /****
 *****************************************************************************************************/
{     0,  255
,     0, 0x01, 0x02, 0x03,  0x9C, 0x09, 0x86, 0x7F,  0x97, 0x8D, 0x8E, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x9D, 0x85, 0x08, 0x87,  0x18, 0x19, 0x92, 0x8F,  0x1C, 0x1D, 0x1E, 0x1F
,  0x80, 0x81, 0x82, 0x83,  0x84, 0x0A, 0x17, 0x1B,  0x88, 0x89, 0x8A, 0x8B,  0x8C, 0x05, 0x06, 0x07
,  0x90, 0x91, 0x16, 0x93,  0x94, 0x95, 0x96, 0x04,  0x98, 0x99, 0x9A, 0x9B,  0x14, 0x15, 0x9E, 0x1A

,   ' ', 0xA0, 0xA1, 0xA2,  0xA3, 0xA4, 0xA5, 0xA6,  0xA7, 0xA8,  '[',  '.',   '<',  '(',  '+',  '!'
,   '&', 0xA9, 0xAA, 0xAB,  0xAC, 0xAD, 0xAE, 0xAF,  0xB0, 0xB1,  ']',  '$',   '*',  ')',  ';',  '^'
,   '-',  '/', 0xB2,  '',  0xB4, 0xB5, 0xB6, 0xB7,  0xB8, 0xB9,  '|',  ',',   '%',  '_',  '>',  '?'
,  0xBA, 0xBB, 0xBC, 0xBD,  0xBE, 0xBF,  '',  '',   '',  '`',  ':',  '#',   '@', '\'',  '=',  '"'

,   '',  'a',  'b',  'c',   'd',  'e',  'f',  'g',   'h',  'i',  '',  '',   '',  '',  '',  ''
,   '',  'j',  'k',  'l',   'm',  'n',  'o',  'p',   'q',  'r',  '',  '',   '',  '',  '',  ''
,   '',  '~',  's',  't',   'u',  'v',  'w',  'x',   'y',  'z',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '{',  'A',  'B',  'C',   'D',  'E',  'F',  'G',   'H',  'I',  '',  '',   '',  '',  '',  ''
,   '}',  'J',  'K',  'L',   'M',  'N',  'O',  'P',   'Q',  'R',  '',  '',   '',  '',  '',  ''
,  '\\', 0x9F,  'S',  'T',   'U',  'V',  'W',  'X',   'Y',  'Z',  '',  '',   '',  '',  '',  ''
,   '0',  '1',  '2',  '3',   '4',  '5',  '6',  '7',   '8',  '9',  '',  '',   '',  '',  '',  ''
};

static const u_char *
/*****************************************************************************************************/
intercode[TEXT_L][TEXT_L] =                                                                      /****
 *  0   k   w   a   i   m   z   e   K   Z   Y                                                     ****
 *****************************************************************************************************/
{ { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0} /* 0 */
, { 0, kk, kw, ka, ki, km, kz,  0, Kk, kZ, kY} /* k */
, { 0, wk,  0, wa, wi, wm, wz,  0,  0,  0,  0} /* w */
, { 0, ak, aw,  0, ai, am, az,  0,  0,  0,  0} /* a */
, { 0, ik, iw, ia,  0, im, iz,  0,  0,  0,  0} /* i */
, { 0, mk, mw, ma, mi,  0, mz,  0,  0,  0,  0} /* m */
, { 0, zk, zw, za, zi, zm,  0,  0,  0,  0,  0} /* z */
, { 0, ek,  0,  0,  0,  0,  0,  0,  0,  0,  0} /* e */
, { 0, Kk,  0,  0,  0,  0,  0,  0,  0,  0,  0} /* K */
, { 0, kZ,  0,  0,  0,  0,  0,  0,  0,  0,  0} /* Z */
, { 0, Yk,  0,  0,  0,  0,  0,  0,  0,  0,  0} /* Y */
};

static const char *
code_k[] = {"KOI8"       , NULL};

static const char *
code_w[] = {"WIN"        , "CP1251", NULL};

static const char *
code_a[] = {"ALT"        , "IBM866", NULL};

static const char *
code_i[] = {"ISO"        , "ISO-8859-5", NULL};

static const char *
code_m[] = {"MAC"        , NULL};

static const char *
code_z[] = {"ZIP"        , NULL};

static const char *
code_e[] = {"EBCDIC"     , NULL};

static const char *
code_K[] = {"KBD"        , NULL};

static const char *
code_Z[] = {"SWAPcASE"   , NULL};

static const char *
code_Y[] = {"UPPER/lower", NULL};

static const recobe_c_tnm
/*****************************************************************************************************/
encolist[TEXT_L] =                                                                               /****
 *****************************************************************************************************/
{ { NULL                , NULL   , NULL                }
, { (const u_char *)"k" , &code_k, recobe_koi8printable}
, { (const u_char *)"w" , &code_w, recobe_nullprintable}
, { (const u_char *)"a" , &code_a, recobe_nullprintable}
, { (const u_char *)"i" , &code_i, recobe_nullprintable}
, { (const u_char *)"m" , &code_m, recobe_nullprintable}
, { (const u_char *)"z" , &code_z, recobe_nullprintable}
, { (const u_char *)"e" , &code_e, recobe_nullprintable}
, { (const u_char *)"K" , &code_K, recobe_koi8printable}
, { (const u_char *)"Z" , &code_Z, recobe_koi8printable}
, { (const u_char *)"Y" , &code_Y, recobe_koi8printable}
};

static u_int
/*****************************************************************************************************/
codnumbyid(const u_char *nm) {                                                                   /****
 *****************************************************************************************************/
    u_int   r = 0;
    u_int   i;

    for (i = 1; i < TEXT_L; ++i) {
        if  (nm[0] == encolist[i].encoid[0]) {
            r = i;
            break;
    }   }
    return(r);
}

static u_char *
/*****************************************************************************************************/
reconv(recobe_conv cnv) {                                                                        /****
 *****************************************************************************************************/
    int           midenco ;
    int           inarray ;
    int           interlo = 0;
    int           interhi = 0;
    u_char       *tabout  = NULL;
    const u_char *tabin   ;
    int           indx    ;
    int           outx    ;

    if  (  (RECOBE_TEXT == cnv.domain)
        && (TEXT_L > cnv.encosrc)
        && (TEXT_L > cnv.encodst)
        && (0 < cnv.encosrc)
        && (0 < cnv.encodst)
        && !cnv.nonesrc
        && !cnv.nonedst
        ) {
        if  (!(tabout = malloc(256))) {
            ifBLIN_QW0("malloc(256)");
            goto out;
        }
        if  (!!(tabin = intercode[cnv.encosrc][cnv.encodst])) {
            for (inarray = 0, outx = 0, indx = 0; outx < 256; ++outx) {
                if  (!inarray) {
                    interlo = tabin[indx++];
                    interhi = tabin[indx++];
                    inarray = 1;
                }
                if  (outx < interlo) {
                    tabout[outx] = (u_char)outx;
                } else {
                    tabout[outx] = tabin[indx++];
                }
                if  (outx >= interhi) inarray = 0;
            }
        } else if (!!(tabin = intercode[cnv.encodst][cnv.encosrc])) {
            bzero(tabout, 256);
            for (inarray = 0, outx = 0, indx = 0; outx < 256; ++outx) {
                if  (!inarray) {
                    interlo = tabin[indx++];
                    interhi = tabin[indx++];
                    inarray = 1;
                }
                if  (outx < interlo) {
                    tabout[outx] = (u_char)outx;
                } else {
                    tabout[tabin[indx++]] = (u_char)outx;
                }
                if  (outx >= interhi) inarray = 0;
            }
        } else {
            recobe_conv   conv1 = cnv;
            recobe_conv   conv2 = cnv;
            const u_char *tabi1;
            const u_char *tabi2;
            u_char       *tabo1;
            u_char       *tabo2;

            for (midenco = 1; midenco < TEXT_L; ++midenco) {
                tabo1 = NULL;
                tabo2 = NULL;
                conv1.encodst = conv2.encosrc = (u_int64_t)midenco;
                if  (  !!(tabi1 = intercode[conv1.encosrc][conv1.encodst])
                    || !!(tabi1 = intercode[conv1.encodst][conv1.encosrc])
                    ) {
                    tabo1 = reconv(conv1);
                }
                if  (  !!(tabi2 = intercode[conv2.encosrc][conv2.encodst])
                    || !!(tabi2 = intercode[conv2.encodst][conv2.encosrc])
                    ) {
                    tabo2 = reconv(conv2);
                }
                if  (!!tabo1 && !!tabo2) {
                    for (outx = 0; outx < 256; ++outx) {
                        tabout[outx] = tabo2[tabo1[outx]];
                    }
                    free(tabo1);
                    free(tabo2);
                    goto out;
                }
                free(tabo1);
                free(tabo2);
            }
            free(tabout);
            tabout = NULL;
    }   }
out:
    return(tabout);
}

static recobe_conv
/*****************************************************************************************************/
convbyname(const char *name) {                                                                   /****
 *****************************************************************************************************/
    recobe_conv cnv = {RECOBE_TEXT, 0, 0, 0, 0};

    if  (!name || !name[0]) {
        cnv.nonesrc = cnv.nonedst = 1;
    } else {
        cnv.encosrc = codnumbyid((const u_char *)name);
        if  (!name[1]) {
            cnv.nonedst = 1;
        } else if (!!name[2]) {
            cnv.encodst = 0;
        } else {
            cnv.encodst = codnumbyid((const u_char *)&name[1]);
    }   }
    return(cnv);
}

const recobe_c_tdm
/*****************************************************************************************************
 *****************************************************************************************************/
recobe_text_dm =                                                                                 /****
 *****************************************************************************************************
 *****************************************************************************************************/
{ TEXT_L
, 1
#ifdef __amd64__
, 0
#endif
, "TEXT"
, encolist
, codnumbyid
, convbyname
, {reconv}
};
