/*-
 * Copyright (C)2016..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2016..2024 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: maint.c,v 1.20 2024/01/14 20:15:08 babolo Exp $"

#define MIFE_COMPAT     5
#define BLIN_COMPAT     4
#define Bpars_COMPAT    4
#define RECOBE_COMPAT   VMAJOR
#define RECOBE_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <strings.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <mife.h>
#include "recobe.h"

const u_int16_t
/*****************************************************************************************************
 *****************************************************************************************************
                                                                                                  ****/
recobe_k1[256] =                                                                                 /****
                                                                                                  ****
 *****************************************************************************************************
 *****************************************************************************************************/
{ 0x0000, 0x0001, 0x0002, 0x0003,  0x0004, 0x0005, 0x0006, 0x0007 /* 00 */
, 0x0008, 0x0009, 0x000A, 0x000B,  0x000C, 0x000D, 0x000E, 0x000F
, 0x0010, 0x0011, 0x0012, 0x0013,  0x0014, 0x0015, 0x0016, 0x0017 /* 10 */
, 0x0018, 0x0019, 0x001A, 0x001B,  0x001C, 0x001D, 0x001E, 0x001F

, 0x0020, 0x0021, 0x0022, 0x0023,  0x0024, 0x0025, 0x0026, 0x0027 /* 20 */
, 0x0028, 0x0029, 0x002A, 0x002B,  0x002C, 0x002D, 0x002E, 0x002F
, 0x0030, 0x0031, 0x0032, 0x0033,  0x0034, 0x0035, 0x0036, 0x0037 /* 30 */
, 0x0038, 0x0039, 0x003A, 0x003B,  0x003C, 0x003D, 0x003E, 0x003F

, 0x0040, 0x0041, 0x0042, 0x0043,  0x0044, 0x0045, 0x0046, 0x0047 /* 40 */
, 0x0048, 0x0049, 0x004A, 0x004B,  0x004C, 0x004D, 0x004E, 0x004F
, 0x0050, 0x0051, 0x0052, 0x0053,  0x0054, 0x0055, 0x0056, 0x0057 /* 50 */
, 0x0058, 0x0059, 0x005A, 0x005B,  0x005C, 0x005D, 0x005E, 0x005F

, 0x0060, 0x0061, 0x0062, 0x0063,  0x0064, 0x0065, 0x0066, 0x0067 /* 60 */
, 0x0068, 0x0069, 0x006A, 0x006B,  0x006C, 0x006D, 0x006E, 0x006F
, 0x0070, 0x0071, 0x0072, 0x0073,  0x0074, 0x0075, 0x0076, 0x0077 /* 70 */
, 0x0078, 0x0079, 0x007A, 0x007B,  0x007C, 0x007D, 0x007E, 0x007F

, 0x2500, 0x2502, 0x250C, 0x2510,  0x2514, 0x2518, 0x251C, 0x2524 /* 80 */
, 0x252C, 0x2534, 0x253C, 0x2580,  0x2584, 0x2588, 0x258C, 0x2590
, 0x2591, 0x2592, 0x2593, 0x2320,  0x25A0, 0x2219, 0x221A, 0x2248 /* 90 */
, 0x2264, 0x2265, 0x00A0, 0x2321,  0x00B0, 0x00B2, 0x00B7, 0x00F7

, 0x2550, 0x2551, 0x2552, 0x0451,  0x2553, 0x2554, 0x2555, 0x2556 /* A0 */
, 0x2557, 0x2558, 0x2559, 0x255A,  0x255B, 0x255C, 0x255D, 0x255E
, 0x255F, 0x2560, 0x2561, 0x0401,  0x2562, 0x2563, 0x2564, 0x2565 /* B0 */
, 0x2566, 0x2567, 0x2568, 0x2569,  0x256A, 0x256B, 0x256C, 0x00A9

, 0x044E, 0x0430, 0x0431, 0x0446,  0x0434, 0x0435, 0x0444, 0x0433 /* C0 */
, 0x0445, 0x0438, 0x0439, 0x043A,  0x043B, 0x043C, 0x043D, 0x043E
, 0x043F, 0x044F, 0x0440, 0x0441,  0x0442, 0x0443, 0x0436, 0x0432 /* D0 */
, 0x044C, 0x044B, 0x0437, 0x0448,  0x044D, 0x0449, 0x0447, 0x044A

, 0x042E, 0x0410, 0x0411, 0x0426,  0x0414, 0x0415, 0x0424, 0x0413 /* E0 */
, 0x0425, 0x0418, 0x0419, 0x041A,  0x041B, 0x041C, 0x041D, 0x041E
, 0x041F, 0x042F, 0x0420, 0x0421,  0x0422, 0x0423, 0x0416, 0x0412 /* F0 */
, 0x042C, 0x042B, 0x0417, 0x0428,  0x042D, 0x0429, 0x0427, 0x042A
};

static int
/*****************************************************************************************************
                                                                                                  ****/
prt(FILE *f, const char *s) {                                                                    /****
                                                                                                  ****
 *****************************************************************************************************/
    int ex = 0;

    for (int i = 0; !!s[i]; ++i) {
        switch(s[i] & 0x0FF) {
            case '\n': ex += fprintf(f, "\\n") ; break;
            case '\r': ex += fprintf(f, "\\r") ; break;
            case '\v': ex += fprintf(f, "\\v") ; break;
            case '\f': ex += fprintf(f, "\\f") ; break;
            case '\t': ex += fprintf(f, "\\t") ; break;
            case '\"': ex += fprintf(f, "\\\""); break;
            case '\\': ex += fprintf(f, "\\\\"); break;
            default  : ex += fprintf(f, "%c", s[i]);
    }   }
    return(ex);
}

int
/*****************************************************************************************************
 *****************************************************************************************************
                                                                                                  ****/
recobe_PrintWideStr(const u_char *p) {                                                           /****
                                                                                                  ****
 *****************************************************************************************************
 *****************************************************************************************************/
    int    ex = EX_OK;
    int    no = 0;
    u_char t  [65536];

    switch(p[0]) {
    case 'U':                                                     /*   recobe_ud[] */
        for (int i = 0; i < 256; ++i) {
            if  (i < 0x80) {
                printf("%c {0x80%02X}", i ? ',' : '{', i);
            } else if (i < 0xC0) {
                printf(", {0x40%02X}", i & 0x3F);
            } else if (i == 0xFF) {
                printf(", {0x2000}");
            } else {
                int    mask;
                int    j;

                for (j = 0, mask = 0x80; i & mask; ++j, mask >>= 1) {}
                printf(", {0x8%1X%02X}", j - 1, i & (mask - 1));
            }
            if  (!(~i & 7)) printf(" /* %02X */\n", i & 0x00F8);
        }
        printf("};\n");
        break;
    case 'N':
        no = 1;
        /* FALLTHROUGH */
    case 'K': {                                          /*    recobe_1k[] */
            FILE *nil = fopen("/dev/null", "w");
            int   virtualpos = 0;
            int   realpos    = 0;
            int   shift      ;

            if  (!nil) {
                ifBLIN_QW0("fopen(/dev/null, w)");
                goto out;
            }
            printf("/*-\n"
" * Copyright (C)2018..2024 @BABOLO http://www.babolo.ru/\n"
" * All rights reserved.\n"
" *\n"
" * Redistribution and use in source and binary forms, with or without\n"
" * modification, are permitted provided that the following conditions\n"
" * are met:\n"
" * 1. Redistributions of source code must retain the above copyright\n"
" *    notice, this list of conditions and the following disclaimer.\n"
" * 2. Redistributions in binary form must reproduce the above copyright\n"
" *    notice, this list of conditions and the following disclaimer in the\n"
" *    documentation and/or other materials provided with the distribution.\n"
" *\n"
" * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND\n"
" * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n"
" * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE\n"
" * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE\n"
" * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL\n"
" * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS\n"
" * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)\n"
" * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT\n"
" * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY\n"
" * SUCH DAMAGE.\n"
" */\n"
"\n"
"#ident \"@(#) Copyright (C)2018..2024 @BABOLO http://www.babolo.ru/\"\n"
"#ident \"@(#) $Id: maint.c,v 1.20 2024/01/14 20:15:08 babolo Exp $\"\n"
"\n"
"#include <stdio.h>\n"
"#define NO NULL\n"
"\n\
const char *\n\
/**************************************************************************************************\n\
 **************************************************************************************************/\n\
recobe_1k[65536] =                                                                            /****\n\
 **************************************************************************************************\n\
 **************************************************************************************************/\n\
");
            for (u_int i = 0; i < 65536; ++i) {
                int next = 0;
                int now = 0;

                if  (((i & 15) < 15) && !!recobe_1k[i + 1]) next = prt(nil, recobe_1k[i + 1]);
                if  (!(i & 15)) {
                    virtualpos = 0;
                    realpos = 0;
                }
                now = (!recobe_1k[i]) ? -1 : prt(nil, recobe_1k[i]);
                shift = realpos - virtualpos + ((0 < now) ? now : 0);
                if  (next > 2) ++shift;
                switch(shift) {
                case 0:
                    if  (!!i && ((!!no && !now) || (0 > now))) {
                        realpos += printf(",  NO");
                        goto caseout;
                    } else {
                        realpos += printf("%c  \"", !i ? '{' : ',');
                    }
                    break;
                case 1:
                    if  (!!i && ((!!no && !now) || (0 > now))) {
                        realpos += printf(", NO");
                        goto caseout;
                    } else {
                        realpos += printf("%c \"", !i ? '{' : ',');
                    }
                    break;
                default:
                    if  (!!i && ((!!no && !now) || (0 > now))) {
                        realpos += printf(",NO");
                        goto caseout;
                    } else {
                        realpos += printf("%c\"", !i ? '{' : ',');
                    }
                    break;
                }
                realpos += prt(stdout, recobe_1k[i]);
                realpos += printf("\"");
            caseout:
                virtualpos += 5;
                if  (!(~i & 0x0000000F)) {
                    if  (!(i & 0xFFFFFFF0)) {
                        printf("\n");
                    } else {
                        shift = realpos - virtualpos;
                        switch(shift) {
                        case 0: printf(" /* %03X */\n", i >> 4); break;
                        case 1: printf( "/* %03X */\n", i >> 4); break;
                        default: printf( "/*%03X */\n", i >> 4); break;
        }   }   }   }   }
        printf("};\n");
        break;
    case 'X':
        for (u_int i = 0; i < 65536; ++i) {
            int j;

            if  (!recobe_1k[i]) {
                j = 0;
            } else if (!recobe_1k[i][0]) {
                printf("00");
                j = 1;
            } else {
                for (j = 0; !!recobe_1k[i][j]; ++j) printf("%02X", recobe_1k[i][j] & 0x0FF);
            }
            if  ((i & 15) == 0x07) {
                printf("\n");
            } else {
                if  (j < 4) j = (4 - j) * 2 + 1; else j = 1;
                while(j-- > 0) printf(" ");
                if  (!(~i & 15)) printf(" /* %03X */\n", i >> 4);
        }   }
        break;
    default:                                            /*    recobe_1k[] */
        for (u_int i = 0; i < 65536; ++i) t[i] = 0;
        for (u_int i = 0; i < 256; ++i) t[recobe_k1[i]] = (u_char)i;
        for (u_int i = 0; i < 65536; ++i) {
            if  (  !!t[i]
                && !!recobe_1k[i][0]
                && (!(t[i] == (0x0FF & recobe_1k[i][0])) || !!recobe_1k[i][1])
                ) {
                ifBLIN_QX0("*** %d t(%02X) <> recobe(%02X)", i, t[i], 0x0FF & recobe_1k[i][0]);
            }
            if  (!i) {
                printf("{ \"\"");
            } else if (!t[i]) {
                printf(", \"\"");
            } else switch(t[i]) {
            case '\n': printf(", \"\\n\"") ; break;
            case '\r': printf(", \"\\r\"") ; break;
            case '\v': printf(", \"\\v\"") ; break;
            case '\f': printf(", \"\\f\"") ; break;
            case '\t': printf(", \"\\t\"") ; break;
            case '\"': printf(", \"\\\"\""); break;
            case '\\': printf(", \"\\\\\""); break;
            default  : printf(", \"%c\"", t[i]);
            }
            if  (!(~i & 15)) printf(" /* %03X */\n", i >> 4);
        }
        printf("};\n");
    }
out:
    return(ex);
}

void
/*****************************************************************************************************
 *****************************************************************************************************
 ****  blin_cry4   cnv                                                       ****
 *****************************************************************************************************
                                                                                                  ****/
recobe_cnverr(const char *file, const char *func, int line, const char *mesg, recobe_conv cnv) { /****
                                                                                                  ****
 *****************************************************************************************************
 *****************************************************************************************************/
    const recobe_c_tnm *encolist = recobe_collection.domains[cnv.domain]->encolist;

    blin_cry4( BLIN_DOCRY
             , file
             , func
             , line
             , "%s %s=%c%c(%d: %c%d -> %c%d)"
             , mesg
             , recobe_collection.domains[cnv.domain]
             ? recobe_collection.domains[cnv.domain]->domname
             : "-"
             , cnv.nonesrc ? '.' : encolist[cnv.encosrc].encoid ? encolist[cnv.encosrc].encoid[0] : '-'
             , cnv.nonedst ? '.' : encolist[cnv.encodst].encoid ? encolist[cnv.encodst].encoid[0] : '-'
             , cnv.domain
             , cnv.nonesrc ? '-' : '+'
             , cnv.encosrc
             , cnv.nonedst ? '-' : '+'
             , cnv.encodst
             );
}

void
/*****************************************************************************************************
 *****************************************************************************************************
 ****  chunk                                                                            ****
 *****************************************************************************************************
                                                                                                  ****/
recobe_testtail(int lev, const char *file, const char *func, int line, recobe_chunk *chunk) {    /****
                                                                                                  ****
 *****************************************************************************************************
 *****************************************************************************************************/
    if  (!chunk) {
        blin_cry4(lev | BLIN_DOCRY, file, func, line, "NO chunk");
    } else {
        if  (RECOBE_EOT == chunk->position) {
            blin_cry4( lev | BLIN_DOCRY
                     , file
                     , func
                     , line
                     , "chunk=%"BLIN_X"+%u -[%u]"
                     , BLIN_I(chunk)
                     , chunk->size
                     , chunk->length
                     )
            ;
        } else {
            blin_cry4( lev | BLIN_DOCRY
                     , file
                     , func
                     , line
                     , "chunk=%"BLIN_X"+%u %u[%u]"
                     , BLIN_I(chunk)
                     , chunk->size
                     , chunk->position
                     , chunk->length
                     )
            ;
        }
        fprintf(stderr, "");
        for (u_int32_t i = chunk->position; i < chunk->length; ++i) {
            if  ((chunk->chunk[i] < ' ') || ((chunk->chunk[i] >= 0x7F) && (chunk->chunk[i] < 0xC0))) {
                fprintf(stderr, "\\%02X", chunk->chunk[i]);
            } else {
                fprintf(stderr, "%c", chunk->chunk[i]);
        }   }
        fprintf(stderr, "\n");
}   }

void
/*****************************************************************************************************
 *****************************************************************************************************
 ****  chain                                                                            ****
 *****************************************************************************************************
                                                                                                  ****/
recobe_testchain(const char *file, const char *func, int line, recobe_chain *chain) {            /****
                                                                                                  ****
 *****************************************************************************************************
 *****************************************************************************************************/
    if  (!chain) {
        blin_cry4(3 | BLIN_DOCRY, file, func, line, "NO chain");
    } else {
        const recobe_c_tnm *encolist = recobe_collection.domains[chain->cnv.domain]->encolist;

        if  (!!line) blin_cry4(3 | BLIN_DOCRY, file, func, line, "################");
        blin_cry4( 3 | BLIN_DOCRY
                 , file
                 , func
                 , line
                 , "chain=%"BLIN_X" f%08X cnv %s=%c%c(%d: %c%d=>%c%d) %ux%u=>%ux%u"
                   " ~%s~%s~ ~%s~%s~\n"
                   " next=%"BLIN_X" convertor=%"BLIN_X" converdata=%"BLIN_X" tail=%"BLIN_X"\n"
                 , BLIN_I(chain)
                 , chain->flags
                 , recobe_collection.domains[chain->cnv.domain]->domname
                 , chain->cnv.nonesrc
                 ? '.'
                 : encolist[chain->cnv.encosrc].encoid ? encolist[chain->cnv.encosrc].encoid[0] : '-'
                 , chain->cnv.nonedst
                 ? '.'
                 : encolist[chain->cnv.encodst].encoid ? encolist[chain->cnv.encodst].encoid[0] : '-'
                 , chain->cnv.domain
                 , chain->cnv.nonesrc ? '-' : '+'
                 , chain->cnv.encosrc
                 , chain->cnv.nonedst ? '-' : '+'
                 , chain->cnv.encodst
                 , chain->inwlen
                 , chain->inwnum
                 , chain->outwlen
                 , chain->outwnum
                 , chain->bsubst ? chain->bsubst : ""
                 , chain->esubst ? chain->esubst : ""
                 , chain->bcode ? chain->bcode : ""
                 , chain->ecode ? chain->ecode : ""
                 , BLIN_I(chain->next)
                 , BLIN_I(chain->convertor)
                 , BLIN_I(chain->converdata)
                 , BLIN_I(chain->tail)
                 )
        ;
        if  (chain->tail) recobe_testtail(3, "", "", 0, chain->tail);
        if  (chain->next) recobe_testchain("", "", 0, chain->next);
}   }

/*****************************************************************************************************
 *                              recobe 4 compatibility                                               *
 *****************************************************************************************************/
int
recobe_chainout(recobe_chain *chain, int fd) {
    return(recobe_chainput(chain, fd, mife_writ));
}
 
recobe_chunk *
recobe_chunkeot(recobe_chain *chain) {
    recobe_chunk *eot;

#   define blin_internal_flags (chain->flags)
    if  (!(eot = calloc(1, sizeof(recobe_chunk)))) {
        ifBLIN_QW0("calloc(%"BLIN_D")", sizeof(recobe_chunk));
    } else {
        eot->position = RECOBE_EOT;
    }
    return(eot);
#   undef blin_internal_flags
}

recobe_chain *
recobe__openk(recobe_conf *cf, const char *p, recobe_chain *chain, char *mod) {
    cf->mod = mod;
    return(recobe_openk(cf, p, 0, chain));
};
