/*-
 * Copyright (C)2014..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2014..2024 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: etat.c,v 1.25 2024/01/08 00:11:11 babolo Exp $"

#define MIFE_COMPAT     5
#define BLIN_COMPAT     4
#define RECOBE_COMPAT   VMAJOR
#define RECOBE_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <strings.h>
#include <stdlib.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <mife.h>
#include "recobe.h"

#define ETAT_L 8

static const u_char
/*****************************************************************************************************/
ai[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,  0xB0, 0xB1, 0xB2, 0xB3,  0xB4, 0xB5, 0xB6, 0xB7,  0xB8, 0xB9, 0xBA, 0xBB,  0xBC, 0xBD, 0xBE, 0xBF
,  0xC0, 0xC1, 0xC2, 0xC3,  0xC4, 0xC5, 0xC6, 0xC7,  0xC8, 0xC9, 0xCA, 0xCB,  0xCC, 0xCD, 0xCE, 0xCF
,  0xD0, 0xD1, 0xD2, 0xD3,  0xD4, 0xD5, 0xD6, 0xD7,  0xD8, 0xD9, 0xDA, 0xDB,  0xDC, 0xDD, 0xDE, 0xDF
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0

,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,  0xE0, 0xE1, 0xE2, 0xE3,  0xE4, 0xE5, 0xE6, 0xE7,  0xE8, 0xE9, 0xEA, 0xEB,  0xEC, 0xED, 0xEE, 0xEF
,  0xA1, 0xF1, 0xA4, 0xF4,  0xA7, 0xF7, 0xAE, 0xFE,     0,    0,    0,    0,  0xF0,    0,    0, 0xA0
};

static const u_char
/*****************************************************************************************************/
ia[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,  0xFF, 0xF0,    0,    0,  0xF2,    0,    0, 0xF4,     0,    0,    0,    0,     0,    0, 0xF6,    0
,  0x80, 0x81, 0x82, 0x83,  0x84, 0x85, 0x86, 0x87,  0x88, 0x89, 0x8A, 0x8B,  0x8C, 0x8D, 0x8E, 0x8F

,  0x90, 0x91, 0x92, 0x93,  0x94, 0x95, 0x96, 0x97,  0x98, 0x99, 0x9A, 0x9B,  0x9C, 0x9D, 0x9E, 0x9F
,  0xA0, 0xA1, 0xA2, 0xA3,  0xA4, 0xA5, 0xA6, 0xA7,  0xA8, 0xA9, 0xAA, 0xAB,  0xAC, 0xAD, 0xAE, 0xAF
,  0xE0, 0xE1, 0xE2, 0xE3,  0xE4, 0xE5, 0xE6, 0xE7,  0xE8, 0xE9, 0xEA, 0xEB,  0xEC, 0xED, 0xEE, 0xEF
,  0xFC, 0xF1,    0,    0,  0xF3,    0,    0, 0xF5,     0,    0,    0,    0,     0,    0, 0xF7,    0
};

static const u_char
/*****************************************************************************************************/
ik[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,  0x9A, 0xB3,    0,    0,  0xB4,    0, 0xB6, 0xB7,     0,    0,    0,    0,     0,    0, 0xBE,    0
,  0xE1, 0xE2, 0xF7, 0xE7,  0xE4, 0xE5, 0xF6, 0xFA,  0xE9, 0xEA, 0xEB, 0xEC,  0xED, 0xEE, 0xEF, 0xF0

,  0xF2, 0xF3, 0xF4, 0xF5,  0xE6, 0xE8, 0xE3, 0xFE,  0xFB, 0xFD, 0xFF, 0xF9,  0xF8, 0xFC, 0xE0, 0xF1
,  0xC1, 0xC2, 0xD7, 0xC7,  0xC4, 0xC5, 0xD6, 0xDA,  0xC9, 0xCA, 0xCB, 0xCC,  0xCD, 0xCE, 0xCF, 0xD0
,  0xD2, 0xD3, 0xD4, 0xD5,  0xC6, 0xC8, 0xC3, 0xDE,  0xDB, 0xDD, 0xDF, 0xD9,  0xD8, 0xDC, 0xC0, 0xD1
,     0, 0xA3,    0,    0,  0xA4,    0, 0xA6, 0xA7,     0,    0,    0,    0,     0,    0, 0xAE,    0
};

static const u_char
/*****************************************************************************************************/
ki[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0, 0xA0,    0,     0,    0,    0,    0
,     0,    0,    0, 0xF1,  0xF4,    0, 0xF6, 0xF7,     0,    0,    0,    0,     0,    0, 0xFE,    0
,     0,    0,    0, 0xA1,  0xA4,    0, 0xA6, 0xA7,     0,    0,    0,    0,     0,    0, 0xAE,    0

,  0xEE, 0xD0, 0xD1, 0xE6,  0xD4, 0xD5, 0xE4, 0xD3,  0xE5, 0xD8, 0xD9, 0xDA,  0xDB, 0xDC, 0xDD, 0xDE
,  0xDF, 0xEF, 0xE0, 0xE1,  0xE2, 0xE3, 0xD6, 0xD2,  0xEC, 0xEB, 0xD7, 0xE8,  0xED, 0xE9, 0xE7, 0xEA
,  0xCE, 0xB0, 0xB1, 0xC6,  0xB4, 0xB5, 0xC4, 0xB3,  0xC5, 0xB8, 0xB9, 0xBA,  0xBB, 0xBC, 0xBD, 0xBE
,  0xBF, 0xCF, 0xC0, 0xC1,  0xC2, 0xC3, 0xB6, 0xB2,  0xCC, 0xCB, 0xB7, 0xC8,  0xCD, 0xC9, 0xC7, 0xCA
};

static const u_char
/*****************************************************************************************************/
ak[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,  0xE1, 0xE2, 0xF7, 0xE7,  0xE4, 0xE5, 0xF6, 0xFA,  0xE9, 0xEA, 0xEB, 0xEC,  0xED, 0xEE, 0xEF, 0xF0
,  0xF2, 0xF3, 0xF4, 0xF5,  0xE6, 0xE8, 0xE3, 0xFE,  0xFB, 0xFD, 0xFF, 0xF9,  0xF8, 0xFC, 0xE0, 0xF1
,  0xC1, 0xC2, 0xD7, 0xC7,  0xC4, 0xC5, 0xD6, 0xDA,  0xC9, 0xCA, 0xCB, 0xCC,  0xCD, 0xCE, 0xCF, 0xD0
,  0x90, 0x91, 0x92, 0x81,  0x87, 0xB2,    0,    0,     0, 0xB5, 0xA1, 0xA8,     0,    0, 0xAC, 0x83

,  0x84, 0x89, 0x88, 0x86,  0x80, 0x8A, 0xAF, 0xB0,  0xAB, 0xA5, 0xBB, 0xB8,  0xB1, 0xA0,    0, 0xB9
,  0xBA,    0,    0, 0xAA,  0xA9, 0xA2,    0,    0,  0xBC, 0x85, 0x82, 0x8D,  0x8C, 0x8E, 0x8F, 0x8B
,  0xD2, 0xD3, 0xD4, 0xD5,  0xC6, 0xC8, 0xC3, 0xDE,  0xDB, 0xDD, 0xDF, 0xD9,  0xD8, 0xDC, 0xC0, 0xD1
,  0xB3, 0xA3, 0xB4, 0xA4,  0xB7, 0xA7, 0xBE, 0xAE,  0x9C, 0x95, 0x9E, 0x96,     0,    0, 0x94, 0x9A
};

static const u_char
/*****************************************************************************************************/
ka[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,  0xC4, 0xB3, 0xDA, 0xBF,  0xC0, 0xD9, 0xC3, 0xB4,  0xC2, 0xC1, 0xC5, 0xDF,  0xDC, 0xDB, 0xDD, 0xDE
,  0xB0, 0xB1, 0xB2,    0,  0xFE, 0xF9, 0xFB,    0,     0,    0, 0xFF,    0,  0xF8,    0, 0xFA,    0
,  0xCD, 0xBA, 0xD5, 0xF1,  0xF3, 0xC9,    0, 0xF5,  0xBB, 0xD4, 0xD3, 0xC8,  0xBE,    0, 0xF7, 0xC6
,  0xC7, 0xCC, 0xB5, 0xF0,  0xF2, 0xB9,    0, 0xF4,  0xCB, 0xCF, 0xD0, 0xCA,  0xD8,    0, 0xF6,    0

,  0xEE, 0xA0, 0xA1, 0xE6,  0xA4, 0xA5, 0xE4, 0xA3,  0xE5, 0xA8, 0xA9, 0xAA,  0xAB, 0xAC, 0xAD, 0xAE
,  0xAF, 0xEF, 0xE0, 0xE1,  0xE2, 0xE3, 0xA6, 0xA2,  0xEC, 0xEB, 0xA7, 0xE8,  0xED, 0xE9, 0xE7, 0xEA
,  0x9E, 0x80, 0x81, 0x96,  0x84, 0x85, 0x94, 0x83,  0x95, 0x88, 0x89, 0x8A,  0x8B, 0x8C, 0x8D, 0x8E
,  0x8F, 0x9F, 0x90, 0x91,  0x92, 0x93, 0x86, 0x82,  0x9C, 0x9B, 0x87, 0x98,  0x9D, 0x99, 0x97, 0x9A
};

static const u_char
/*****************************************************************************************************/
aw[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,  0xC0, 0xC1, 0xC2, 0xC3,  0xC4, 0xC5, 0xC6, 0xC7,  0xC8, 0xC9, 0xCA, 0xCB,  0xCC, 0xCD, 0xCE, 0xCF
,  0xD0, 0xD1, 0xD2, 0xD3,  0xD4, 0xD5, 0xD6, 0xD7,  0xD8, 0xD9, 0xDA, 0xDB,  0xDC, 0xDD, 0xDE, 0xDF
,  0xE0, 0xE1, 0xE2, 0xE3,  0xE4, 0xE5, 0xE6, 0xE7,  0xE8, 0xE9, 0xEA, 0xEB,  0xEC, 0xED, 0xEE, 0xEF
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0

,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,  0xF0, 0xF1, 0xF2, 0xF3,  0xF4, 0xF5, 0xF6, 0xF7,  0xF8, 0xF9, 0xFA, 0xFB,  0xFC, 0xFD, 0xFE, 0xFF
,  0xA8, 0xB8, 0xAA, 0xBA,  0xAF, 0xBF, 0xA1, 0xA2,  0xB0,    0, 0xB7,    0,  0xB9, 0xA4,    0, 0xA0
};

static const u_char
/*****************************************************************************************************/
wa[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,  0xFF, 0xF6, 0xF7,    0,  0xFD,    0,    0,    0,  0xF0,    0, 0xF2,    0,     0,    0,    0, 0xF4
,  0xF8,    0,    0,    0,     0,    0,    0, 0xFA,  0xF1, 0xFC, 0xF3,    0,     0,    0,    0, 0xF5

,  0x80, 0x81, 0x82, 0x83,  0x84, 0x85, 0x86, 0x87,  0x88, 0x89, 0x8A, 0x8B,  0x8C, 0x8D, 0x8E, 0x8F
,  0x90, 0x91, 0x92, 0x93,  0x94, 0x95, 0x96, 0x97,  0x98, 0x99, 0x9A, 0x9B,  0x9C, 0x9D, 0x9E, 0x9F
,  0xA0, 0xA1, 0xA2, 0xA3,  0xA4, 0xA5, 0xA6, 0xA7,  0xA8, 0xA9, 0xAA, 0xAB,  0xAC, 0xAD, 0xAE, 0xAF
,  0xE0, 0xE1, 0xE2, 0xE3,  0xE4, 0xE5, 0xE6, 0xE7,  0xE8, 0xE9, 0xEA, 0xEB,  0xEC, 0xED, 0xEE, 0xEF
};

static const u_char
/*****************************************************************************************************/
iw[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,  0x98,    0,    0,    0,     0,    0,    0,    0
,  0xA0, 0xA8, 0x80, 0x81,  0xAA, 0xBD, 0xB2, 0xAF,  0xA3, 0x8A, 0x8C, 0x8E,  0x8D, 0xAD, 0xA1, 0x8F
,  0xC0, 0xC1, 0xC2, 0xC3,  0xC4, 0xC5, 0xC6, 0xC7,  0xC8, 0xC9, 0xCA, 0xCB,  0xCC, 0xCD, 0xCE, 0xCF

,  0xD0, 0xD1, 0xD2, 0xD3,  0xD4, 0xD5, 0xD6, 0xD7,  0xD8, 0xD9, 0xDA, 0xDB,  0xDC, 0xDD, 0xDE, 0xDF
,  0xE0, 0xE1, 0xE2, 0xE3,  0xE4, 0xE5, 0xE6, 0xE7,  0xE8, 0xE9, 0xEA, 0xEB,  0xEC, 0xED, 0xEE, 0xEF
,  0xF0, 0xF1, 0xF2, 0xF3,  0xF4, 0xF5, 0xF6, 0xF7,  0xF8, 0xF9, 0xFA, 0xFB,  0xFC, 0xFD, 0xFE, 0xFF
,  0xB9, 0xB8, 0x90, 0x83,  0xBA, 0xBE, 0xB3, 0xBF,  0xBC, 0x9A, 0x9C, 0x9E,  0x9D, 0xA7, 0xA2, 0x9F
};

static const u_char
/*****************************************************************************************************/
wi[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,  0xA2, 0xA3,    0, 0xF3,     0,    0,    0,    0,     0,    0, 0xA9,    0,  0xAA, 0xAC, 0xAB, 0xAF
,  0xF2,    0,    0,    0,     0,    0,    0,    0,  0x98,    0, 0xF9,    0,  0xFA, 0xFC, 0xFB, 0xFF
,  0xA0, 0xAE, 0xFE, 0xA8,     0,    0,    0, 0xFD,  0xA1,    0, 0xA4,    0,     0, 0xAD,    0, 0xA7
,     0,    0, 0xA6, 0xF6,     0,    0,    0,    0,  0xF1, 0xF0, 0xF4,    0,  0xF8, 0xA5, 0xF5, 0xF7

,  0xB0, 0xB1, 0xB2, 0xB3,  0xB4, 0xB5, 0xB6, 0xB7,  0xB8, 0xB9, 0xBA, 0xBB,  0xBC, 0xBD, 0xBE, 0xBF
,  0xC0, 0xC1, 0xC2, 0xC3,  0xC4, 0xC5, 0xC6, 0xC7,  0xC8, 0xC9, 0xCA, 0xCB,  0xCC, 0xCD, 0xCE, 0xCF
,  0xD0, 0xD1, 0xD2, 0xD3,  0xD4, 0xD5, 0xD6, 0xD7,  0xD8, 0xD9, 0xDA, 0xDB,  0xDC, 0xDD, 0xDE, 0xDF
,  0xE0, 0xE1, 0xE2, 0xE3,  0xE4, 0xE5, 0xE6, 0xE7,  0xE8, 0xE9, 0xEA, 0xEB,  0xEC, 0xED, 0xEE, 0xEF
};

static const u_char
/*****************************************************************************************************/
kw[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0, 0xA0,    0,  0xB0,    0, 0xB7,    0
,     0,    0,    0, 0xB8,  0xBA,    0, 0xB3, 0xBF,     0,    0,    0,    0,     0, 0xB4, 0xA2,    0
,     0,    0,    0, 0xA8,  0xAA,    0, 0xB2, 0xAF,     0,    0,    0,    0,     0, 0xA5, 0xA1, 0xA9

,  0xFE, 0xE0, 0xE1, 0xF6,  0xE4, 0xE5, 0xF4, 0xE3,  0xF5, 0xE8, 0xE9, 0xEA,  0xEB, 0xEC, 0xED, 0xEE
,  0xEF, 0xFF, 0xF0, 0xF1,  0xF2, 0xF3, 0xE6, 0xE2,  0xFC, 0xFB, 0xE7, 0xF8,  0xFD, 0xF9, 0xF7, 0xFA
,  0xDE, 0xC0, 0xC1, 0xD6,  0xC4, 0xC5, 0xD4, 0xC3,  0xD5, 0xC8, 0xC9, 0xCA,  0xCB, 0xCC, 0xCD, 0xCE
,  0xCF, 0xDF, 0xD0, 0xD1,  0xD2, 0xD3, 0xC6, 0xC2,  0xDC, 0xDB, 0xC7, 0xD8,  0xDD, 0xD9, 0xD7, 0xDA
};

static const u_char
/*****************************************************************************************************/
wk[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,  0x9A, 0xBE, 0xAE,    0,     0, 0xBD,    0,    0,  0xB3, 0xBF, 0xB4,    0,     0,    0,    0, 0xB7
,  0x9C,    0, 0xB6, 0xA6,  0xAD,    0,    0, 0x9E,  0xA3,    0, 0xA4,    0,     0,    0,    0, 0xA7

,  0xE1, 0xE2, 0xF7, 0xE7,  0xE4, 0xE5, 0xF6, 0xFA,  0xE9, 0xEA, 0xEB, 0xEC,  0xED, 0xEE, 0xEF, 0xF0
,  0xF2, 0xF3, 0xF4, 0xF5,  0xE6, 0xE8, 0xE3, 0xFE,  0xFB, 0xFD, 0xFF, 0xF9,  0xF8, 0xFC, 0xE0, 0xF1
,  0xC1, 0xC2, 0xD7, 0xC7,  0xC4, 0xC5, 0xD6, 0xDA,  0xC9, 0xCA, 0xCB, 0xCC,  0xCD, 0xCE, 0xCF, 0xD0
,  0xD2, 0xD3, 0xD4, 0xD5,  0xC6, 0xC8, 0xC3, 0xDE,  0xDB, 0xDD, 0xDF, 0xD9,  0xD8, 0xDC, 0xC0, 0xD1
};

static const u_char
/*****************************************************************************************************/
za[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,     0,    0,    0, 0x9F,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,  0xFF, 0xAD, 0xBD, 0x9C,  0xCF, 0xBE, 0xDD, 0xF5,  0xF9, 0xB8, 0xA6, 0xAE,  0xAA, 0xF0, 0xA9, 0xEE
,  0xF8, 0xF1, 0xFD, 0xFC,  0xEF, 0xE6, 0xF4, 0xFA,  0xF7, 0xFB, 0xA7, 0xAF,  0xAC, 0xAB, 0xF3, 0xA8

,  0xB7, 0xB5, 0xB6, 0xC7,  0x8E, 0x8F, 0x92, 0x80,  0xD4, 0x90, 0xD2, 0xD3,  0xDE, 0xD6, 0xD7, 0xD8
,  0xD1, 0xA5, 0xE3, 0xE0,  0xE2, 0xE5, 0x99, 0x9E,  0x9D, 0xEB, 0xE9, 0xEA,  0x9A, 0xED, 0xE8, 0xE1
,  0x85, 0xA0, 0x83, 0xC6,  0x84, 0x86, 0x91, 0x87,  0x8A, 0x82, 0x88, 0x89,  0x8D, 0xA1, 0x8C, 0x8B
,  0xD0, 0xA4, 0x95, 0xA2,  0x93, 0xE4, 0x94, 0xF6,  0x9B, 0x97, 0xA3, 0x96,  0x81, 0xEC, 0xE7, 0x98
};

static const u_char
/*****************************************************************************************************/
az[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,  0xC7, 0xFC, 0xE9, 0xE2,  0xE4, 0xE0, 0xE5, 0xE7,  0xEA, 0xEB, 0xE8, 0xEF,  0xEE, 0xEC, 0xC4, 0xC5
,  0xC9, 0xE6, 0xC6, 0xF4,  0xF6, 0xF2, 0xFB, 0xF9,  0xFF, 0xD6, 0xDC, 0xF8,  0xA3, 0xD8, 0xD7, 0x83
,  0xE1, 0xED, 0xF3, 0xFA,  0xF1, 0xD1, 0xAA, 0xBA,  0xBF, 0xAE, 0xAC, 0xBD,  0xBC, 0xA1, 0xAB, 0xBB
,     0,    0,    0,    0,     0, 0xC1, 0xC2, 0xC0,  0xA9,    0,    0,    0,     0, 0xA2, 0xA5,    0

,     0,    0,    0,    0,     0,    0, 0xE3, 0xC3,     0,    0,    0,    0,     0,    0,    0, 0xA4
,  0xF0, 0xD0, 0xCA, 0xCB,  0xC8,    0, 0xCD, 0xCE,  0xCF,    0,    0,    0,     0, 0xA6, 0xCC,    0
,  0xD3, 0xDF, 0xD4, 0xD2,  0xF5, 0xD5, 0xB5, 0xFE,  0xDE, 0xDA, 0xDB, 0xD9,  0xFD, 0xDD, 0xAF, 0xB4
,  0xAD, 0xB1,    0, 0xBE,  0xB6, 0xA7, 0xF7, 0xB8,  0xB0, 0xA8, 0xB7, 0xB9,  0xB3, 0xB2,    0, 0xA0
};

static const u_char
/*****************************************************************************************************/
km[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0, 0xC3, 0xC5,  0xB2, 0xB3, 0xCA,    0,  0xA1,    0,    0, 0xD6
,     0,    0,    0, 0xDE,  0xB9,    0, 0xB4, 0xBB,     0,    0,    0,    0,     0, 0xB6, 0xD9,    0
,     0,    0,    0, 0xDD,  0xB8,    0, 0xA7, 0xBA,     0,    0,    0,    0,     0, 0xA2, 0xD8, 0xA9

,  0xFE, 0xE0, 0xE1, 0xF6,  0xE4, 0xE5, 0xF4, 0xE3,  0xF5, 0xE8, 0xE9, 0xEA,  0xEB, 0xEC, 0xED, 0xEE
,  0xEF, 0xDF, 0xF0, 0xF1,  0xF2, 0xF3, 0xE6, 0xE2,  0xFC, 0xFB, 0xE7, 0xF8,  0xFD, 0xF9, 0xF7, 0xFA
,  0x9E, 0x80, 0x81, 0x96,  0x84, 0x85, 0x94, 0x83,  0x95, 0x88, 0x89, 0x8A,  0x8B, 0x8C, 0x8D, 0x8E
,  0x8F, 0x9F, 0x90, 0x91,  0x92, 0x93, 0x86, 0x82,  0x9C, 0x9B, 0x87, 0x98,  0x9D, 0x99, 0x97, 0x9A
};

static const u_char
/*****************************************************************************************************/
mk[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,  0xE1, 0xE2, 0xF7, 0xE7,  0xE4, 0xE5, 0xF6, 0xFA,  0xE9, 0xEA, 0xEB, 0xEC,  0xED, 0xEE, 0xEF, 0xF0
,  0xF2, 0xF3, 0xF4, 0xF5,  0xE6, 0xE8, 0xE3, 0xFE,  0xFB, 0xFD, 0xFF, 0xF9,  0xF8, 0xFC, 0xE0, 0xF1
,     0, 0x9C, 0xBD,    0,     0,    0,    0, 0xB6,     0, 0xBF,    0,    0,     0,    0,    0,    0
,     0,    0, 0x98, 0x99,  0xA6,    0, 0xAD,    0,  0xB4, 0xA4, 0xB7, 0xA7,     0,    0,    0,    0

,     0,    0,    0, 0x96,     0, 0x97,    0,    0,     0,    0, 0x9A,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0, 0x9F,    0,  0xBE, 0xAE,    0,    0,     0, 0xB3, 0xA3, 0xD1
,  0xC1, 0xC2, 0xD7, 0xC7,  0xC4, 0xC5, 0xD6, 0xDA,  0xC9, 0xCA, 0xCB, 0xCC,  0xCD, 0xCE, 0xCF, 0xD0
,  0xD2, 0xD3, 0xD4, 0xD5,  0xC6, 0xC8, 0xC3, 0xDE,  0xDB, 0xDD, 0xDF, 0xD9,  0xD8, 0xDC, 0xC0,    0
};

static const u_char
/*****************************************************************************************************/
wm[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,  0xAB, 0xAE,    0, 0xAF,  0xD7, 0xC9, 0xA0,    0,     0,    0, 0xBC,    0,  0xBE, 0xCD, 0xCB, 0xDA
,  0xAC, 0xD4, 0xD5, 0xD2,  0xD3, 0xA5, 0xD0, 0xD1,     0, 0xAA, 0xBD,    0,  0xBF, 0xCE, 0xCC, 0xDB
,  0xCA, 0xD8, 0xD9, 0xB7,  0xFF, 0xA2,    0, 0xA4,  0xDD, 0xA9, 0xB8, 0xC7,  0xC2,    0, 0xA8, 0xBA
,  0xA1, 0xB1, 0xA7, 0xB4,  0xB6, 0xB5, 0xA6,    0,  0xDE, 0xDC, 0xB9, 0xC8,  0xC0, 0xC1, 0xCF, 0xBB

,  0x80, 0x81, 0x82, 0x83,  0x84, 0x85, 0x86, 0x87,  0x88, 0x89, 0x8A, 0x8B,  0x8C, 0x8D, 0x8E, 0x8F
,  0x90, 0x91, 0x92, 0x93,  0x94, 0x95, 0x96, 0x97,  0x98, 0x99, 0x9A, 0x9B,  0x9C, 0x9D, 0x9E, 0x9F
,  0xE0, 0xE1, 0xE2, 0xE3,  0xE4, 0xE5, 0xE6, 0xE7,  0xE8, 0xE9, 0xEA, 0xEB,  0xEC, 0xED, 0xEE, 0xEF
,  0xF0, 0xF1, 0xF2, 0xF3,  0xF4, 0xF5, 0xF6, 0xF7,  0xF8, 0xF9, 0xFA, 0xFB,  0xFC, 0xFD, 0xFE, 0xDF
};

static const u_char
/*****************************************************************************************************/
mw[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,  0xC0, 0xC1, 0xC2, 0xC3,  0xC4, 0xC5, 0xC6, 0xC7,  0xC8, 0xC9, 0xCA, 0xCB,  0xCC, 0xCD, 0xCE, 0xCF
,  0xD0, 0xD1, 0xD2, 0xD3,  0xD4, 0xD5, 0xD6, 0xD7,  0xD8, 0xD9, 0xDA, 0xDB,  0xDC, 0xDD, 0xDE, 0xDF
,  0x86, 0xB0, 0xA5,    0,  0xA7, 0x95, 0xB6, 0xB2,  0xAE, 0xA9, 0x99, 0x80,  0x90,    0, 0x81, 0x83
,     0, 0xB1,    0,    0,  0xB3, 0xB5, 0xB4, 0xA3,  0xAA, 0xBA, 0xAF, 0xBF,  0x8A, 0x9A, 0x8C, 0x9C

,  0xBC, 0xBD, 0xAC,    0,     0,    0,    0, 0xAB,  0xBB, 0x85, 0xA0, 0x8E,  0x9E, 0x8D, 0x9D, 0xBE
,  0x96, 0x97, 0x93, 0x94,  0x91, 0x92,    0, 0x84,  0xA1, 0xA2, 0x8F, 0x9F,  0xB9, 0xA8, 0xB8, 0xFF
,  0xE0, 0xE1, 0xE2, 0xE3,  0xE4, 0xE5, 0xE6, 0xE7,  0xE8, 0xE9, 0xEA, 0xEB,  0xEC, 0xED, 0xEE, 0xEF
,  0xF0, 0xF1, 0xF2, 0xF3,  0xF4, 0xF5, 0xF6, 0xF7,  0xF8, 0xF9, 0xFA, 0xFB,  0xFC, 0xFD, 0xFE, 0xA4
};

static const u_char
/*****************************************************************************************************/
im[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,  0xCA, 0xDD, 0xAB, 0xAE,  0xB8, 0xC1, 0xA7, 0xBA,  0xB7, 0xBC, 0xBE, 0xCB,  0xCD,    0, 0xD8, 0xDA
,  0x80, 0x81, 0x82, 0x83,  0x84, 0x85, 0x86, 0x87,  0x88, 0x89, 0x8A, 0x8B,  0x8C, 0x8D, 0x8E, 0x8F

,  0x90, 0x91, 0x92, 0x93,  0x94, 0x95, 0x96, 0x97,  0x98, 0x99, 0x9A, 0x9B,  0x9C, 0x9D, 0x9E, 0x9F
,  0xE0, 0xE1, 0xE2, 0xE3,  0xE4, 0xE5, 0xE6, 0xE7,  0xE8, 0xE9, 0xEA, 0xEB,  0xEC, 0xED, 0xEE, 0xEF
,  0xF0, 0xF1, 0xF2, 0xF3,  0xF4, 0xF5, 0xF6, 0xF7,  0xF8, 0xF9, 0xFA, 0xFB,  0xFC, 0xFD, 0xFE, 0xDF
,  0xDC, 0xDE, 0xAC, 0xAF,  0xB9, 0xCF, 0xB4, 0xBB,  0xC0, 0xBD, 0xBF, 0xCC,  0xCE, 0xA4, 0xD9, 0xDB
};

static const u_char
/*****************************************************************************************************/
mi[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,  0xB0, 0xB1, 0xB2, 0xB3,  0xB4, 0xB5, 0xB6, 0xB7,  0xB8, 0xB9, 0xBA, 0xBB,  0xBC, 0xBD, 0xBE, 0xBF
,  0xC0, 0xC1, 0xC2, 0xC3,  0xC4, 0xC5, 0xC6, 0xC7,  0xC8, 0xC9, 0xCA, 0xCB,  0xCC, 0xCD, 0xCE, 0xCF
,     0,    0,    0,    0,  0xFD,    0,    0, 0xA6,     0,    0,    0, 0xA2,  0xF2,    0, 0xA3, 0xF3
,     0,    0,    0,    0,  0xF6,    0,    0, 0xA8,  0xA4, 0xF4, 0xA7, 0xF7,  0xA9, 0xF9, 0xAA, 0xFA

,  0xF8, 0xA5,    0,    0,     0,    0,    0,    0,     0,    0, 0xA0, 0xAB,  0xFB, 0xAC, 0xFC, 0xF5
,     0,    0,    0,    0,     0,    0,    0,    0,  0xAE, 0xFE, 0xAF, 0xFF,  0xF0, 0xA1, 0xF1, 0xEF
,  0xD0, 0xD1, 0xD2, 0xD3,  0xD4, 0xD5, 0xD6, 0xD7,  0xD8, 0xD9, 0xDA, 0xDB,  0xDC, 0xDD, 0xDE, 0xDF
,  0xE0, 0xE1, 0xE2, 0xE3,  0xE4, 0xE5, 0xE6, 0xE7,  0xE8, 0xE9, 0xEA, 0xEB,  0xEC, 0xED, 0xEE,    0
};

static const u_char
/*****************************************************************************************************/
am[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,  0x80, 0x81, 0x82, 0x83,  0x84, 0x85, 0x86, 0x87,  0x88, 0x89, 0x8A, 0x8B,  0x8C, 0x8D, 0x8E, 0x8F
,  0x90, 0x91, 0x92, 0x93,  0x94, 0x95, 0x96, 0x97,  0x98, 0x99, 0x9A, 0x9B,  0x9C, 0x9D, 0x9E, 0x9F
,  0xE0, 0xE1, 0xE2, 0xE3,  0xE4, 0xE5, 0xE6, 0xE7,  0xE8, 0xE9, 0xEA, 0xEB,  0xEC, 0xED, 0xEE, 0xEF
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0

,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,  0xF0, 0xF1, 0xF2, 0xF3,  0xF4, 0xF5, 0xF6, 0xF7,  0xF8, 0xF9, 0xFA, 0xFB,  0xFC, 0xFD, 0xFE, 0xDF
,  0xDD, 0xDE, 0xB8, 0xB9,  0xBA, 0xBB, 0xD8, 0xD9,  0xA1,    0,    0, 0xC3,  0xDC, 0xFF,    0, 0xCA
};

static const u_char
/*****************************************************************************************************/
ma[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,  0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x14, 0x15, 0x16, 0x17,  0x18, 0x19, 0x1A, 0x1B,  0x1C, 0x1D, 0x1E, 0x1F
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E, 0x7F

,  0x80, 0x81, 0x82, 0x83,  0x84, 0x85, 0x86, 0x87,  0x88, 0x89, 0x8A, 0x8B,  0x8C, 0x8D, 0x8E, 0x8F
,  0x90, 0x91, 0x92, 0x93,  0x94, 0x95, 0x96, 0x97,  0x98, 0x99, 0x9A, 0x9B,  0x9C, 0x9D, 0x9E, 0x9F
,     0, 0xF8,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,  0xF2, 0xF3, 0xF4, 0xF5,     0,    0,    0,    0

,     0,    0,    0, 0xFB,     0,    0,    0,    0,     0,    0, 0xFF,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,  0xF6, 0xF7,    0,    0,  0xFC, 0xF0, 0xF1, 0xEF
,  0xA0, 0xA1, 0xA2, 0xA3,  0xA4, 0xA5, 0xA6, 0xA7,  0xA8, 0xA9, 0xAA, 0xAB,  0xAC, 0xAD, 0xAE, 0xAF
,  0xE0, 0xE1, 0xE2, 0xE3,  0xE4, 0xE5, 0xE6, 0xE7,  0xE8, 0xE9, 0xEA, 0xEB,  0xEC, 0xED, 0xEE, 0xFD
};

static const u_char
/*****************************************************************************************************/
ek[256] = (const u_char[])                                                                       /****
 *****************************************************************************************************/
{     0, 0x01, 0x02, 0x03,  0x9C, 0x09, 0x86, 0x7F,  0x97, 0x8D, 0x8E, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F
,  0x10, 0x11, 0x12, 0x13,  0x9D, 0x85, 0x08, 0x87,  0x18, 0x19, 0x92, 0x8F,  0x1C, 0x1D, 0x1E, 0x1F
,  0x80, 0x81, 0x82, 0x83,  0x84, 0x0A, 0x17, 0x1B,  0x88, 0x89, 0x8A, 0x8B,  0x8C, 0x05, 0x06, 0x07
,  0x90, 0x91, 0x16, 0x93,  0x94, 0x95, 0x96, 0x04,  0x98, 0x99, 0x9A, 0x9B,  0x14, 0x15, 0x9E, 0x1A

,   ' ', 0xA0, 0xA1, 0xA2,  0xA3, 0xA4, 0xA5, 0xA6,  0xA7, 0xA8,  '[',  '.',   '<',  '(',  '+',  '!'
,   '&', 0xA9, 0xAA, 0xAB,  0xAC, 0xAD, 0xAE, 0xAF,  0xB0, 0xB1,  ']',  '$',   '*',  ')',  ';',  '^'
,   '-',  '/', 0xB2,  '',  0xB4, 0xB5, 0xB6, 0xB7,  0xB8, 0xB9,  '|',  ',',   '%',  '_',  '>',  '?'
,  0xBA, 0xBB, 0xBC, 0xBD,  0xBE, 0xBF,  '',  '',   '',  '`',  ':',  '#',   '@', '\'',  '=',  '"'

,   '',  'a',  'b',  'c',   'd',  'e',  'f',  'g',   'h',  'i',  '',  '',   '',  '',  '',  ''
,   '',  'j',  'k',  'l',   'm',  'n',  'o',  'p',   'q',  'r',  '',  '',   '',  '',  '',  ''
,   '',  '~',  's',  't',   'u',  'v',  'w',  'x',   'y',  'z',  '',  '',   '',  '',  '',  ''
,   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  '',   '',  '',  '',  ''
,   '{',  'A',  'B',  'C',   'D',  'E',  'F',  'G',   'H',  'I',  '',  '',   '',  '',  '',  ''
,   '}',  'J',  'K',  'L',   'M',  'N',  'O',  'P',   'Q',  'R',  '',  '',   '',  '',  '',  ''
,  '\\', 0x9F,  'S',  'T',   'U',  'V',  'W',  'X',   'Y',  'Z',  '',  '',   '',  '',  '',  ''
,   '0',  '1',  '2',  '3',   '4',  '5',  '6',  '7',   '8',  '9',  '',  '',   '',  '',  '',  ''
};

static const u_char *
/*****************************************************************************************************/
intercode[ETAT_L][ETAT_L] =                                                                      /****
 *****************************************************************************************************/
{ { 0,  0,  0,  0,  0,  0,  0,  0}
, { 0,  0, kw, ka, ki, km,  0,  0}
, { 0, wk,  0, wa, wi, wm,  0,  0}
, { 0, ak, aw,  0, ai, am, az,  0}
, { 0, ik, iw, ia,  0, im,  0,  0}
, { 0, mk, mw, ma, mi,  0,  0,  0}
, { 0,  0,  0, za,  0,  0,  0,  0}
, { 0, ek,  0,  0,  0,  0,  0,  0}
};

static const char *
code_k[] = {"KOI8"  , NULL};

static const char *
code_w[] = {"WIN"   , NULL};

static const char *
code_a[] = {"ALT"   , NULL};

static const char *
code_i[] = {"ISO"   , NULL};

static const char *
code_m[] = {"MAC"   , NULL};

static const char *
code_z[] = {"ZIP"   , NULL};

static const char *
code_e[] = {"EBCDIC", NULL};

static const recobe_c_tnm
/*****************************************************************************************************/
encolist[ETAT_L] =                                                                               /****
 *****************************************************************************************************/
{ { NULL,    NULL,                 NULL}
, { (const u_char *)"k" , &code_k, recobe_koi8printable}
, { (const u_char *)"w" , &code_w, recobe_nullprintable}
, { (const u_char *)"a" , &code_a, recobe_nullprintable}
, { (const u_char *)"i" , &code_i, recobe_nullprintable}
, { (const u_char *)"m" , &code_m, recobe_nullprintable}
, { (const u_char *)"z" , &code_z, recobe_nullprintable}
, { (const u_char *)"e" , &code_e, recobe_nullprintable}
};

static u_int
/*****************************************************************************************************/
codnumbyid(const u_char *nm) {                                                                   /****
 *****************************************************************************************************/
    u_int i, r = 0;

    for (i = 1; i < ETAT_L; ++i) {
        if  (nm[0] == encolist[i].encoid[0]) {
            r = i;
            break;
    }   }
    return(r);
}

static u_char *
/*****************************************************************************************************/
reconv(recobe_conv cnv) {                                                                        /****
 *****************************************************************************************************/
    u_char *s = NULL;

    if  (  (RECOBE_ETAT == cnv.domain)
        && (ETAT_L > cnv.encosrc)
        && (ETAT_L > cnv.encodst)
        && (0 < cnv.encosrc)
        && (0 < cnv.encodst)
        && !!intercode[cnv.encosrc][cnv.encodst]
        && (s = malloc(256))
        ) {
        bcopy(intercode[cnv.encosrc][cnv.encodst], s, 256);
    }
    return(s);
}

static recobe_conv
/*****************************************************************************************************/
convbyname(const char *name) {                                                                   /****
 *****************************************************************************************************/
    recobe_conv cnv = {RECOBE_ETAT, 0, 0, 0, 0};

    if  (!name || !name[0]) {
        cnv.nonesrc = cnv.nonedst = 1;
    } else {
        cnv.encosrc = codnumbyid((const u_char *)name);
        if  (!name[1]) {
            cnv.nonedst = 1;
        } else if (!!name[2]) {
            cnv.encodst = 0;
        } else {
            cnv.encodst = codnumbyid((const u_char *)&name[1]);
    }   }
    return(cnv);
}

const recobe_c_tdm
/*****************************************************************************************************
 *****************************************************************************************************/
recobe_etat_dm =                                                                                 /****
 *****************************************************************************************************
 *****************************************************************************************************/
{ ETAT_L
, 1
#ifdef __amd64__
, 0
#endif
, "ETAT"
, encolist
, codnumbyid
, convbyname
, {reconv}
};

