#!/bin/sh -e
# Copyright (C)2014..2021 @BABOLO http://www.babolo.ru/
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: testnn.sh,v 1.16 2021/07/25 18:21:48 babolo Exp $

thislib="./lib/librecobe.so.${1}"

if [ -e "${thislib}" ]; then
   tst1() {
       echo "./recobe $1 | diff -q /dev/stdin $2"
       env LD_PRELOAD="${thislib}" ./recobe $1 | diff -q /dev/stdin $2
   }

   tst2() {
       echo "./recobe $1 | ./recobe $2 | diff -q /dev/stdin $3"
       env LD_PRELOAD="${thislib}" ./recobe $1                                                        \
     | env LD_PRELOAD="${thislib}" ./recobe $2                                                        \
     | diff -q /dev/stdin $3
   }

   tst3() {
       echo "($1)./recobe -Bu+ -m' ' -a ... -kQ1 -k1P | '$2'"
       [ "`env LD_PRELOAD="${thislib}" ./recobe -Bu+ -m' ' -a \"$3\" -kQ1 -k1P`" = "$2" ]
   }

   tst4() {
       echo "($1)./recobe -Bu+ -m' ' -a ... -kQ3 -k3P | '$2'"
       [ "`env LD_PRELOAD="${thislib}" ./recobe -Bu+ -m' ' -a \"$3\" -kQ3 -k3P`" = "$2" ]
   }

   tst5() {
       echo "./recobe -Bu+ -m' ' -a ... -k01 -k1P | '$1'"
       [ "`env LD_PRELOAD="${thislib}" ./recobe -Bu+ -m' ' -a \"$2\" -k01 -k1P`" = "$1" ]
   }

   tst6() {
       echo "./recobe -Bu+ -m' ' -a ... -k03 -k3P | '$1'"
       [ "`env LD_PRELOAD="${thislib}" ./recobe -Bu+ -m' ' -a \"$2\" -k03 -k3P`" = "$1" ]
   }

   tst7() {
       echo "./recobe -B'\u' -m'' -a ... -kQ2 -k2P | '$1'"
       [ "`env LD_PRELOAD="${thislib}" ./recobe -B'\u' -m'' -a \"$2\" -kQ2 -k2P`" = "$1" ]
   }

   tst8() {
       echo "./recobe -B'\u' -a ... -kQ1 -k1k | '$1'"
       [ "`env LD_PRELOAD="${thislib}" ./recobe -B'\u' -a \"$2\" -kQ1 -k1k`" = "$1" ]
   }

   tst9() {
       echo "./recobe -B'\u' -a ... -kQ1 -k1k | '$1'"
       [ "`env LD_PRELOAD="${thislib}" ./recobe -LB'\u' -a \"$2\" -kQ1 -k1k`" = "$1" ]
   }
else
   tst1() {
       echo "./recobe $1 | diff -q /dev/stdin $2"
       ./recobe $1 | diff -q /dev/stdin $2
   }

   tst2() {
       echo "./recobe $1 | ./recobe $2 | diff -q /dev/stdin $3"
       ./recobe $1 | ./recobe $2 | diff -q /dev/stdin $3
   }

   tst3() {
       echo "($1)./recobe -Bu+ -m' ' -a ... -kQ1 -k1P | '$2'"
       [ "`./recobe -Bu+ -m' ' -a \"$3\" -kQ1 -k1P`" = "$2" ]
   }

   tst4() {
       echo "($1)./recobe -Bu+ -m' ' -a ... -kQ3 -k3P | '$2'"
       [ "`./recobe -Bu+ -m' ' -a \"$3\" -kQ3 -k3P`" = "$2" ]
   }

   tst5() {
       echo "./recobe -Bu+ -m' ' -a ... -k01 -k1P | '$1'"
       [ "`./recobe -Bu+ -m' ' -a \"$2\" -k01 -k1P`" = "$1" ]
   }

   tst6() {
       echo "./recobe -Bu+ -m' ' -a ... -k03 -k3P | '$1'"
       [ "`./recobe -Bu+ -m' ' -a \"$2\" -k03 -k3P`" = "$1" ]
   }

   tst7() {
       echo "./recobe -B'\u' -m'' -a ... -kQ2 -k2P | '$1'"
       [ "`./recobe -B'\u' -m'' -a \"$2\" -kQ2 -k2P`" = "$1" ]
   }

   tst8() {
       echo "./recobe -B'\u' -a ... -kQ1 -k1k | '$1'"
       [ "`./recobe -B'\u' -a \"$2\" -kQ1 -k1k`" = "$1" ]
   }

   tst9() {
       echo "./recobe -B'\u' -a ... -kQ1 -k1k | '$1'"
       [ "`./recobe -LB'\u' -a \"$2\" -kQ1 -k1k`" = "$1" ]
   }
fi

tst1 '-cwk -f tools/utst.w' tools/utst.k
tst1 '-cak -f tools/utst.a' tools/utst.k
tst1 '-cik -f tools/utst.i' tools/utst.k
tst1 '-cmk -f tools/utst.m' tools/utst.k
tst1 '-czk -f tools/utst.z' tools/utst.k
tst1 '-cKk -f tools/utst.K' tools/utst.k
tst2 '-ckK -f tools/utst.k'    -ckK tools/utst.k
tst2 '-ckK -f tools/utst.k'    -cKk tools/utst.k
tst2 '-cwk -f tools/ztb'       -ckw tools/ztb
tst2 '-cwa -f tools/ztb'       -caw tools/ztb
tst2 '-cwi -f tools/ztb'       -ciw tools/ztb
tst2 '-cwm -f tools/ztb'       -cmw tools/ztb
tst2 '-cwz -f tools/ztb'       -czw tools/ztb
tst2 '-ku2 -f tools/utst.html' -k2k tools/utst.k
tst2 '-ku3 -f tools/utst.html' -k3k tools/utst.k
tst2 '-ku4 -f tools/utst.html' -k4k tools/utst.k
tst2 '-ku5 -f tools/utst.html' -k5k tools/utst.k
tst2 '-ku6 -f tools/utst.html' -k6k tools/utst.k
tst2 '-ku7 -f tools/utst.html' -k7k tools/utst.k
tst2 '-ku8 -f tools/utst.html' -k8k tools/utst.k
tst2 '-ku9 -f tools/utst.html' -k9k tools/utst.k
tst1 '-ku2 -k2k -f tools/utst.html' tools/utst.k
tst1 '-ku3 -k3k -f tools/utst.html' tools/utst.k
tst1 '-ku4 -k4k -f tools/utst.html' tools/utst.k
tst1 '-ku5 -k5k -f tools/utst.html' tools/utst.k
tst1 '-ku6 -k6k -f tools/utst.html' tools/utst.k
tst1 '-ku7 -k7k -f tools/utst.html' tools/utst.k
tst1 '-ku8 -k8k -f tools/utst.html' tools/utst.k
tst1 '-ku9 -k9k -f tools/utst.html' tools/utst.k
tst1 '-ku2 -k2k -ckw -f tools/utst.html' tools/utst.w
tst1 '-ku2 -k21 -k1k -f tools/utst.html' tools/utst.k
tst1 '-kk1 -k1u -ku2 -k2k -f tools/utst.k' tools/utst.k
tst1 '-ckZ -f tools/utst.k' tools/utst.Z
tst1 '-cYk -f tools/utst.k' tools/utst.y
tst1 '-ckY -f tools/utst.k' tools/utst.Y
tst1 '-m= -kQ0 -ku3 -kH3 -kX3 -kD3 -k3k -f tools/qtst.f' tools/qtst.o
tst1 '-M0x3D -kQ0 -ku3 -kH3 -kX3 -kD3 -k3k -f tools/qtst.f' tools/qtst.o
tst1 '-m= -kQ0 -ku3 -kH3 -k3k -f tools/qtst.f' tools/qtst.n
tst1 '-M0x3D -kQ0 -ku3 -kH3 -k3k -f tools/qtst.f' tools/qtst.n
tst1 '-m= -kQ0 -ku3 -kX3 -kD3 -k3k -f tools/qtst.f' tools/qtst.h
tst1 '-M0x3D -kQ0 -ku3 -kX3 -kD3 -k3k -f tools/qtst.f' tools/qtst.h
tst1 '-ku2 -k2k -f tools/bom' tools/bombom
tst1 '-ku3 -k3k -f tools/bom' tools/bombom
tst1 '-ku4 -k4k -f tools/bom' tools/bombom
tst3 A 'egbpdaj6bu4bxfgehfvwxn' "u+0644 u+064A u+0647 u+0645 u+0627 u+0628 u+062A u+0643 u+0644 u+0645\
                                 u+0648 u+0634 u+0639 u+0631 u+0628 u+064A u+061F                     \
                                "
tst3 B 'ihqwcrb4cv8a8dqg056pqjye' "u+4ED6 u+4EEC u+4E3A u+4EC0 u+4E48 u+4E0D u+8BF4 u+4E2D u+6587"
tst3 C 'ihqwctvzc91f659drss3x8bo0yb' "u+4ED6 u+5011 u+7232 u+4EC0 u+9EBD u+4E0D u+8AAA u+4E2D u+6587"
tst3 D 'Proprostnemluvesky-uyb24dma41a' "u+0050 u+0072 u+006F u+010D u+0070 u+0072 u+006F u+0073\
                                         u+0074 u+011B u+006E u+0065 u+006D u+006C u+0075 u+0076\
                                         u+00ED u+010D u+0065 u+0073 u+006B u+0079              \
                                        "
tst3 E '4dbcagdahymbxekheh6e0a7fei0b' "u+05DC u+05DE u+05D4 u+05D4 u+05DD u+05E4 u+05E9 u+05D5 u+05D8\
                                       u+05DC u+05D0 u+05DE u+05D3 u+05D1 u+05E8 u+05D9 u+05DD u+05E2\
                                       u+05D1 u+05E8 u+05D9 u+05EA                                   \
                                      "
tst3 F 'i1baa7eci9glrd9b2ae1bj0hfcgg6iyaf8o0a1dig0cd' "u+092F u+0939 u+0932 u+094B u+0917 u+0939\
                                                       u+093F u+0928 u+094D u+0926 u+0940 u+0915\
                                                       u+094D u+092F u+094B u+0902 u+0928 u+0939\
                                                       u+0940 u+0902 u+092C u+094B u+0932 u+0938\
                                                       u+0915 u+0924 u+0947 u+0939 u+0948 u+0902\
                                                      "
tst3 G 'n8jok5ay5dzabd5bym9f0cm5685rrjetr6pdxa' "u+306A u+305C u+307F u+3093 u+306A u+65E5 u+672C\
                                                 u+8A9E u+3092 u+8A71 u+3057 u+3066 u+304F u+308C\
                                                 u+306A u+3044 u+306E u+304B                     \
                                                "
tst3 H '989aomsvi5e83db1d2a355cv1e0vak1dwrv93d5xbh15a0dt30a5jpsd879ccm6fea98c' "u+C138 u+ACC4 u+C758\
                                                                                u+BAA8 u+B4E0 u+C0AC\
                                                                                u+B78C u+B4E4 u+C774\
                                                                                u+D55C u+AD6D u+C5B4\
                                                                                u+B97C u+C774 u+D574\
                                                                                u+D55C u+B2E4 u+BA74\
                                                                                u+C5BC u+B9C8 u+B098\
                                                                                u+C88B u+C744 u+AE4C\
                                                                               "
tst3 I 'b1abfaaepdrnnbgefbaDotcwatmq2g4l' "u+041F u+043E u+0447 u+0435 u+043C u+0443 u+0436 u+0435\
                                           u+043E u+043D u+0438 u+043D u+0435 u+0433 u+043E u+0432\
                                           u+043E u+0440 u+044F u+0442 u+043F u+043E u+0440 u+0443\
                                           u+0441 u+0441 u+043A u+0438                            \
                                          "
tst3 J 'PorqunopuedensimplementehablarenEspaol-fmd56a' "u+0050 u+006F u+0072 u+0071 u+0075 u+00E9\
                                                        u+006E u+006F u+0070 u+0075 u+0065 u+0064\
                                                        u+0065 u+006E u+0073 u+0069 u+006D u+0070\
                                                        u+006C u+0065 u+006D u+0065 u+006E u+0074\
                                                        u+0065 u+0068 u+0061 u+0062 u+006C u+0061\
                                                        u+0072 u+0065 u+006E u+0045 u+0073 u+0070\
                                                        u+0061 u+00F1 u+006F u+006C              \
                                                       "
tst3 K 'TisaohkhngthchnitingVit-kjcr8268qyxafd2f1b9g' "u+0054 u+1EA1 u+0069 u+0073 u+0061 u+006F\
                                                       u+0068 u+1ECD u+006B u+0068 u+00F4 u+006E\
                                                       u+0067 u+0074 u+0068 u+1EC3 u+0063 u+0068\
                                                       u+1EC9 u+006E u+00F3 u+0069 u+0074 u+0069\
                                                       u+1EBF u+006E u+0067 u+0056 u+0069 u+1EC7\
                                                       u+0074                                   \
                                                      "
tst3 L '3B-ww4c5e180e575a65lsy2b' "u+0033 u+5E74 u+0042 u+7D44 u+91D1 u+516B u+5148 u+751F"
tst3 M '-with-SUPER-MONKEYS-pc58ag80a8qai00g7n9n' "u+5B89 u+5BA4 u+5948 u+7F8E u+6075 u+002D u+0077\
                                                   u+0069 u+0074 u+0068 u+002D u+0053 u+0055 u+0050\
                                                   u+0045 u+0052 u+002D u+004D u+004F u+004E u+004B\
                                                   u+0045 u+0059 u+0053                            \
                                                  "
tst3 N 'Hello-Another-Way--fc4qua05auwb3674vfr0b' "u+0048 u+0065 u+006C u+006C u+006F u+002D u+0041\
                                                   u+006E u+006F u+0074 u+0068 u+0065 u+0072 u+002D\
                                                   u+0057 u+0061 u+0079 u+002D u+305D u+308C u+305E\
                                                   u+308C u+306E u+5834 u+6240                     \
                                                  "
tst3 O '2-u9tlzr9756bt3uc0v' "u+3072 u+3068 u+3064 u+5C4B u+6839 u+306E u+4E0B u+0032"
tst3 P 'MajiKoi5-783gue6qz075azm5e' "u+004D u+0061 u+006A u+0069 u+3067 u+004B u+006F u+0069 u+3059\
                                     u+308B u+0035 u+79D2 u+524D                                   \
                                    "
tst3 Q 'de-jg4avhby1noc0d' "u+30D1 u+30D5 u+30A3 u+30FC u+0064 u+0065 u+30EB u+30F3 u+30D0"
tst3 R 'd9juau41awczczp' "u+305D u+306E u+30B9 u+30D4 u+30FC u+30C9 u+3067"
tst3 S '-> $1.00 <--' "u+002D u+003E u+0020 u+0024 u+0031 u+002E u+0030 u+0030 u+0020 u+003C u+002D"
tst4 A 'egbpdaj6bu4bxfgehfvwxn' "u+0644 u+064A u+0647 u+0645 u+0627 u+0628 u+062A u+0643 u+0644 u+0645\
                                 u+0648 u+0634 u+0639 u+0631 u+0628 u+064A u+061F                     \
                                "
tst4 B 'ihqwcrb4cv8a8dqg056pqjye' "u+4ED6 u+4EEC u+4E3A u+4EC0 u+4E48 u+4E0D u+8BF4 u+4E2D u+6587"
tst4 C 'ihqwctvzc91f659drss3x8bo0yb' "u+4ED6 u+5011 u+7232 u+4EC0 u+9EBD u+4E0D u+8AAA u+4E2D u+6587"
tst4 D 'Proprostnemluvesky-uyb24dma41a' "u+0050 u+0072 u+006F u+010D u+0070 u+0072 u+006F u+0073\
                                         u+0074 u+011B u+006E u+0065 u+006D u+006C u+0075 u+0076\
                                         u+00ED u+010D u+0065 u+0073 u+006B u+0079              \
                                        "
tst4 E '4dbcagdahymbxekheh6e0a7fei0b' "u+05DC u+05DE u+05D4 u+05D4 u+05DD u+05E4 u+05E9 u+05D5 u+05D8\
                                       u+05DC u+05D0 u+05DE u+05D3 u+05D1 u+05E8 u+05D9 u+05DD u+05E2\
                                       u+05D1 u+05E8 u+05D9 u+05EA                                   \
                                      "
tst4 F 'i1baa7eci9glrd9b2ae1bj0hfcgg6iyaf8o0a1dig0cd' "u+092F u+0939 u+0932 u+094B u+0917 u+0939\
                                                       u+093F u+0928 u+094D u+0926 u+0940 u+0915\
                                                       u+094D u+092F u+094B u+0902 u+0928 u+0939\
                                                       u+0940 u+0902 u+092C u+094B u+0932 u+0938\
                                                       u+0915 u+0924 u+0947 u+0939 u+0948 u+0902\
                                                      "
tst4 G 'n8jok5ay5dzabd5bym9f0cm5685rrjetr6pdxa' "u+306A u+305C u+307F u+3093 u+306A u+65E5 u+672C\
                                                 u+8A9E u+3092 u+8A71 u+3057 u+3066 u+304F u+308C\
                                                 u+306A u+3044 u+306E u+304B                     \
                                                "
tst4 H '989aomsvi5e83db1d2a355cv1e0vak1dwrv93d5xbh15a0dt30a5jpsd879ccm6fea98c' "u+C138 u+ACC4 u+C758\
                                                                                u+BAA8 u+B4E0 u+C0AC\
                                                                                u+B78C u+B4E4 u+C774\
                                                                                u+D55C u+AD6D u+C5B4\
                                                                                u+B97C u+C774 u+D574\
                                                                                u+D55C u+B2E4 u+BA74\
                                                                                u+C5BC u+B9C8 u+B098\
                                                                                u+C88B u+C744 u+AE4C\
                                                                               "
tst4 I 'b1abfaaepdrnnbgefbaDotcwatmq2g4l' "u+041F u+043E u+0447 u+0435 u+043C u+0443 u+0436 u+0435\
                                           u+043E u+043D u+0438 u+043D u+0435 u+0433 u+043E u+0432\
                                           u+043E u+0440 u+044F u+0442 u+043F u+043E u+0440 u+0443\
                                           u+0441 u+0441 u+043A u+0438                            \
                                          "
tst4 J 'PorqunopuedensimplementehablarenEspaol-fmd56a' "u+0050 u+006F u+0072 u+0071 u+0075 u+00E9\
                                                        u+006E u+006F u+0070 u+0075 u+0065 u+0064\
                                                        u+0065 u+006E u+0073 u+0069 u+006D u+0070\
                                                        u+006C u+0065 u+006D u+0065 u+006E u+0074\
                                                        u+0065 u+0068 u+0061 u+0062 u+006C u+0061\
                                                        u+0072 u+0065 u+006E u+0045 u+0073 u+0070\
                                                        u+0061 u+00F1 u+006F u+006C              \
                                                       "
tst4 K 'TisaohkhngthchnitingVit-kjcr8268qyxafd2f1b9g' "u+0054 u+1EA1 u+0069 u+0073 u+0061 u+006F\
                                                       u+0068 u+1ECD u+006B u+0068 u+00F4 u+006E\
                                                       u+0067 u+0074 u+0068 u+1EC3 u+0063 u+0068\
                                                       u+1EC9 u+006E u+00F3 u+0069 u+0074 u+0069\
                                                       u+1EBF u+006E u+0067 u+0056 u+0069 u+1EC7\
                                                       u+0074                                   \
                                                      "
tst4 L '3B-ww4c5e180e575a65lsy2b' "u+0033 u+5E74 u+0042 u+7D44 u+91D1 u+516B u+5148 u+751F"
tst4 M '-with-SUPER-MONKEYS-pc58ag80a8qai00g7n9n' "u+5B89 u+5BA4 u+5948 u+7F8E u+6075 u+002D u+0077\
                                                   u+0069 u+0074 u+0068 u+002D u+0053 u+0055 u+0050\
                                                   u+0045 u+0052 u+002D u+004D u+004F u+004E u+004B\
                                                   u+0045 u+0059 u+0053                            \
                                                  "
tst4 N 'Hello-Another-Way--fc4qua05auwb3674vfr0b' "u+0048 u+0065 u+006C u+006C u+006F u+002D u+0041\
                                                   u+006E u+006F u+0074 u+0068 u+0065 u+0072 u+002D\
                                                   u+0057 u+0061 u+0079 u+002D u+305D u+308C u+305E\
                                                   u+308C u+306E u+5834 u+6240                     \
                                                  "
tst4 O '2-u9tlzr9756bt3uc0v' "u+3072 u+3068 u+3064 u+5C4B u+6839 u+306E u+4E0B u+0032"
tst4 P 'MajiKoi5-783gue6qz075azm5e' "u+004D u+0061 u+006A u+0069 u+3067 u+004B u+006F u+0069 u+3059\
                                     u+308B u+0035 u+79D2 u+524D                                   \
                                    "
tst4 Q 'de-jg4avhby1noc0d' "u+30D1 u+30D5 u+30A3 u+30FC u+0064 u+0065 u+30EB u+30F3 u+30D0"
tst4 R 'd9juau41awczczp' "u+305D u+306E u+30B9 u+30D4 u+30FC u+30C9 u+3067"
tst4 S '-> $1.00 <--' "u+002D u+003E u+0020 u+0024 u+0031 u+002E u+0030 u+0030 u+0020 u+003C u+002D"
tst5 'a-' 'a'
tst5 'A-' 'A'
tst5 '3-' '3'
tst5 '--' '-'
tst5 '---' '--'
tst5 'London-' 'London'
tst5 'Lloyd-Atkinson-' 'Lloyd-Atkinson'
tst5 'This has spaces-' 'This has spaces'
tst5 '-> $1.00 <--' '-> $1.00 <-'
tst5 'tda' ''
tst6 'a-' 'a'
tst6 'A-' 'A'
tst6 '3-' '3'
tst6 '--' '-'
tst6 '---' '--'
tst6 'London-' 'London'
tst6 'Lloyd-Atkinson-' 'Lloyd-Atkinson'
tst6 'This has spaces-' 'This has spaces'
tst6 '-> $1.00 <--' '-> $1.00 <-'
tst6 'tda' ''
tst7 'mxa' '\u03b1'
tst7 'fsq' '\u4f8b'
tst7 'n28h' '\u0001f609'
tst7 'mxacd' '\u03b1\u03b2\u03b3'
tst7 'Mnchen-3ya' 'Mnchen'
tst7 'Mnchen-3ya-' 'Mnchen-3ya'
tst7 'Mnchen-Ost-9db' 'Mnchen-Ost'
tst7 'Bahnhof Mnchen-Ost-u6b' 'Bahnhof Mnchen-Ost'
tst7 'abcdef-qua4k' 'abcdef'
tst7 '80aafi6cg' '\u043f\u0440\u0430\u0432\u0434\u0430'
tst7 '22cdfh1b8fsa' '\u0e22\u0e08\u0e06\u0e1f\u0e04\u0e0f\u0e02'
tst7 'hq1bm8jm9l' '\ub3c4\uba54\uc778'
tst7 'eckwd4c7cu47r2wf' '\u30c9\u30e1\u30a4\u30f3\u540d\u4f8b'
tst7 'MajiKoi5-783gue6qz075azm5e' 'Maji\u3067Koi\u3059\u308b5\u79d2\u524d'
tst7 'bcher-kva8445foa' '\u300cbcher\u300d'
tst8 '?2.' '\u0411\u042202.'
tst9 '02.' '\u0411\u042202.'
