#!/bin/sh -e
# Copyright (C)2014..2021 @BABOLO http://www.babolo.ru/
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: test.sh,v 1.20 2021/03/27 16:30:18 babolo Exp $

thislib="./lib/librecobe.so.${1}"

if [ -e "${thislib}" ]; then
   tstrecobe="env LD_PRELOAD=${thislib} ./recobe"
   tstctest="env LD_PRELOAD=${thislib} ./tools/ctest"
else
   tstrecobe="./recobe"
   tstctest="./tools/ctest"
fi

${tstrecobe} -=51ai
${tstrecobe} -=51ak
${tstrecobe} -=51aw
${tstrecobe} -=51az
${tstrecobe} -=51ia
${tstrecobe} -=51ik
${tstrecobe} -=51iw
${tstrecobe} -=51ka
${tstrecobe} -=51ki
${tstrecobe} -=51kw
${tstrecobe} -=51kz
${tstrecobe} -=51kK
${tstrecobe} -=51wa
${tstrecobe} -=51wi
${tstrecobe} -=51wk
${tstrecobe} -=51zk
${tstrecobe} -=51za
${tstrecobe} -=51Kk
${tstrecobe} -=52Au
${tstrecobe} -=52uA
${tstctest} t  1 0x0000000000000000
${tstctest} t  1 0x000000000000007F
${tstctest} t  2 0x0000000000000080
${tstctest} t  2 0x00000000000007FF
${tstctest} t  3 0x0000000000000800
${tstctest} t  3 0x000000000000FFFF
${tstctest} t  4 0x0000000000010000
${tstctest} t  4 0x00000000001FFFFF
${tstctest} t  5 0x0000000000200000
${tstctest} t  5 0x0000000003FFFFFF
${tstctest} t  6 0x0000000004000000
${tstctest} t  6 0x000000007FFFFFFF
${tstctest} t  7 0x0000000080000000
${tstctest} t  7 0x0000000FFFFFFFFF
${tstctest} t  8 0x0000001000000000
${tstctest} t  8 0x000001FFFFFFFFFF
${tstctest} t  9 0x0000020000000000
${tstctest} t  9 0x00003FFFFFFFFFFF
${tstctest} t 10 0x0000400000000000
${tstctest} t 10 0x0007FFFFFFFFFFFF
${tstctest} t 11 0x0008000000000000
${tstctest} t 11 0x00FFFFFFFFFFFFFF
${tstctest} t 12 0x0100000000000000
${tstctest} t 12 0x1FFFFFFFFFFFFFFF
${tstctest} t 13 0x2000000000000000
${tstctest} t 13 0xFFFFFFFFFFFFFFFF
echo -n  | ${tstrecobe} -k0p
echo
echo -n  | ${tstrecobe} -k0P
echo
echo -n  | ${tstrecobe} -k0P
echo
echo -n  | ${tstrecobe} -k0p
echo
echo -n 1caaa2clnkf | ${tstrecobe} -kP0
echo
echo -n 1caaa2clnkf | ${tstrecobe} -kp0
echo
echo -n 1cAAA2CLNKF | ${tstrecobe} -kp0
echo
echo -n 1cAAA2CLNKF | ${tstrecobe} -kP0
echo
echo -n 4baaa2clnkf | ${tstrecobe} -kP0
echo
echo -n 4baaa2clnkf | ${tstrecobe} -kp0
echo
${tstrecobe} -k0p -a 
echo
${tstrecobe} -k0P -a 
echo
${tstrecobe} -k0P -a 
echo
${tstrecobe} -k0p -a 
echo
${tstrecobe} -kP0 -a 1caaa2clnkf
echo
${tstrecobe} -kp0 -a 1caaa2clnkf
echo
${tstrecobe} -kp0 -a 1cAAA2CLNKF
echo
${tstrecobe} -kP0 -a 1cAAA2CLNKF
echo
${tstrecobe} -kP0 -a 4baaa2clnkf
echo
${tstrecobe} -kp0 -a 4baaa2clnkf
echo
printf '\0\0\0' | ${tstrecobe} -k0B
echo
printf '\0\0\0\0' | ${tstrecobe} -k0B
echo
printf '\0\0\0\0\0' | ${tstrecobe} -k0B
echo
printf '\0\0\0\0\0\0' | ${tstrecobe} -k0B
echo
printf '\0\1\2' | ${tstrecobe} -k0B
echo
printf '\0\1\2\3' | ${tstrecobe} -k0B
echo
printf '\0\1\2\3\5' | ${tstrecobe} -k0B
echo
printf '\0\1\2\3\5\6' | ${tstrecobe} -k0B
echo
echo -n 0MHSwdTBzdM= | ${tstrecobe} -kB0
echo
echo -n 8OHy4fTh7fM= | ${tstrecobe} -kB0
echo
echo -n 0MHSwdTBzQ== | ${tstrecobe} -kB0
echo
echo -n 8OHy4fTh7Q== | ${tstrecobe} -kB0
echo
echo -n 0MHSwdTB | ${tstrecobe} -kB0
echo
echo -n 8OHy4fTh | ${tstrecobe} -kB0
echo
${tstrecobe} -kB0 -a 0MHSwdTBzdM=
echo
${tstrecobe} -kB0 -a 8OHy4fTh7fM=
echo
${tstrecobe} -kB0 -a 0MHSwdTBzQ==
echo
${tstrecobe} -kB0 -a 8OHy4fTh7Q==
echo
${tstrecobe} -kB0 -a 0MHSwdTB
echo
${tstrecobe} -kB0 -a 8OHy4fTh
echo
${tstctest} o 3 0x0122034405660788
${tstctest} o -3 0x0122034405660788
${tstctest} o 9 0xFFE0DDC0BBA09980
${tstctest} o -9 0xFFE0DDC0BBA09980
${tstctest} 3412 0 0x0122034405660788
${tstctest} 7968 0 0x0122034405660788
${tstctest} u 0 0x000000003BA09980
${tstctest} u 0 0x00000000BBA09980
${tstctest} u 0 0x000000000047FD67
${tstctest} u 0 0x000000000007FD67
${tstctest} u 0 0x000000000000FD67
${tstctest} u 0 0x0000000000000D67
${tstctest} u 0 0x0000000000000067
${tstctest} c 0 0xFFE0DDC0BBA09980
${tstctest} c 0 0x0001FFE0DDC0BBA0
${tstctest} c 0 0x0000001FFE0DDC0B
${tstctest} c 0 0x00000003FE0DDC0B
${tstctest} s 1 1 32dfb15f232cf970fffc32128f795374155743d44295fad9fda38a66f0461608d8e5
${tstctest} s -1 1 32dfb15f232cf970fffc32128f795374155743d44295fad9fda38a66f0461608d8e5
${tstctest} s 1 2 32dfb15f232cf970fffc32128f795374155743d44295fad9fda38a66f0461608d8e5
${tstctest} s -1 2 32dfb15f232cf970fffc32128f795374155743d44295fad9fda38a66f0461608d8e5
${tstctest} s 1 3 32dfb15f232cf970fffc32128f795374155743d44295fad9fda38a66f0461608d8e5
${tstctest} s -1 3 32dfb15f232cf970fffc32128f795374155743d44295fad9fda38a66f0461608d8e5
${tstctest} s 1 1 eb5d30
${tstctest} s -1 1 eb5d30
${tstctest} s 1 2 eb5d30
${tstctest} s -1 2 eb5d30
${tstctest} s 1 3 eb5d30
${tstctest} s -1 3 eb5d30
${tstctest} s 1 1 e0
${tstctest} s -1 1 e0
${tstctest} s 1 2 e0
${tstctest} s -1 2 e0
${tstctest} s 1 3 e0
${tstctest} s -1 3 e0
${tstrecobe} -kQ0 -ob -scsum1 -Ck0Q -a 32dfb15f232cf970fffc32128f795374155743d44295fad9fda38a66f0461608d8e5
echo
${tstrecobe} -kQ0 -ob -scrc24 -Ck0Q -a 32dfb15f232cf970fffc32128f795374155743d44295fad9fda38a66f0461608d8e5
echo
${tstrecobe} -kQ0 -ob -scrc32 -Ck0Q -a 32dfb15f232cf970fffc32128f795374155743d44295fad9fda38a66f0461608d8e5
echo
${tstrecobe} -kQ0 -ob -scsum1 -Ck0Q -a eb5d30
echo
${tstrecobe} -kQ0 -ob -scrc24 -Ck0Q -a eb5d30
echo
${tstrecobe} -kQ0 -ob -scrc32 -Ck0Q -a eb5d30
echo
${tstrecobe} -kQ0 -ob -scsum1 -Ck0Q -a e0
echo
${tstrecobe} -kQ0 -ob -scrc24 -Ck0Q -a e0
echo
${tstrecobe} -kQ0 -ob -scrc32 -Ck0Q -a e0
echo
