/*-
 * Copyright (C)2014..2021 @BABOLO http://www.babolo.ru/
 * PKG = recobe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: recobe.h,v 1.77 2021/07/31 08:47:54 babolo Exp $
 */

#ifndef  _BABOLO_RECOBE_H_
# define _BABOLO_RECOBE_H_

# ifndef _BABOLO_BLINflag_H_
#  warning this file needs babolo/BLINflag.h as a prerequisite
#  include <babolo/BLINflag.h>
# endif
# ifndef RECOBE_COMPAT
#  warning RECOBE_COMPAT not defined
# endif

__BEGIN_DECLS

# define RECOBE_IN         0
# define RECOBE_TEXT       1
# define RECOBE_G711       2
# define RECOBE_ETAT       3
# define RECOBE_CRC        4
# define RECOBE_WIDE       5
# define RECOBE_CODE       6
# define RECOBE_DOMAX      7

# define RECOBE_PREFLEN    256
# define RECOBE_PUNYMAX    1024
# define RECOBE_MAXKOIS    9
# define RECOBE_EOT        0xFFFFFFFF                       /* for recobe_chunk.position             */

# define RECOBE_HCONV      0x000020           /* Decode HTML mnemonic                                */
# define RECOBE_DCONV      0x000040           /* Decode HTML DEC numeric codes                       */
# define RECOBE_XCONV      0x000080           /* Decode HTML HEX numeric codes                       */

# define RECOBE_CASE_a do {                                                                           \
    const char       *o;                                                                              \
    if  (!(o = babolo_getoptsarg(RECOBE_CASE_OPTS->bos))) {                                           \
        ifBLIN_QW0("No -%c arg", RECOBE_CASE_OPTS->bos->c);                                           \
        RECOBE_CASE_EX = -EX_USAGE;                                                                   \
        goto RECOBE_CASE_OUT;                                                                         \
    }                                                                                                 \
    if  (!!RECOBE_CASE_OPTS->filin) {                                                                 \
        ifBLIN_QX1("Input text in file redefined from %s to %s", RECOBE_CASE_OPTS->filin, o);         \
        free(RECOBE_CASE_OPTS->filin);                                                                \
        RECOBE_CASE_OPTS->filin = NULL;                                                               \
    }                                                                                                 \
    if  (!!RECOBE_CASE_OPTS->argin) {                                                                 \
        ifBLIN_QX1("Input text in argument redefined from %s to %s", RECOBE_CASE_OPTS->argin, o);     \
        free(RECOBE_CASE_OPTS->argin);                                                                \
    }                                                                                                 \
    RECOBE_CASE_OPTS->argin = strdup(o);                                                              \
} while(0)

# define RECOBE_CASE_b do {                                                                           \
    const char       *o;                                                                              \
    if  (!(o = babolo_getoptsarg(RECOBE_CASE_OPTS->bos))) {                                           \
        ifBLIN_QW0("No -%c arg", RECOBE_CASE_OPTS->bos->c);                                           \
        RECOBE_CASE_EX = -EX_USAGE;                                                                   \
        goto RECOBE_CASE_OUT;                                                                         \
    }                                                                                                 \
    if  (!!RECOBE_CASE_OPTS->cf.bsubst) {                                                             \
        ifBLIN_QX1("Before error mark redefined from %s to %s", RECOBE_CASE_OPTS->cf.bsubst, o);      \
        free(RECOBE_CASE_OPTS->cf.bsubst);                                                            \
    }                                                                                                 \
    RECOBE_CASE_OPTS->cf.bsubst = strdup(o);                                                          \
} while(0)

# define RECOBE_CASE_B do {                                                                           \
    const char       *o;                                                                              \
    if  (!(o = babolo_getoptsarg(RECOBE_CASE_OPTS->bos))) {                                           \
        ifBLIN_QW0("No -%c arg", RECOBE_CASE_OPTS->bos->c);                                           \
        RECOBE_CASE_EX = -EX_USAGE;                                                                   \
        goto RECOBE_CASE_OUT;                                                                         \
    }                                                                                                 \
    if  (!!RECOBE_CASE_OPTS->cf.bcode) {                                                              \
        ifBLIN_QX1("Code begin mark redefined from %s to %s", RECOBE_CASE_OPTS->cf.bcode, o);         \
        free(RECOBE_CASE_OPTS->cf.bcode);                                                             \
    }                                                                                                 \
    RECOBE_CASE_OPTS->cf.bcode = strdup(o);                                                           \
} while(0)

# define RECOBE_CASE_c do {                                                                           \
    const char       *o;                                                                              \
    if  (!(o = babolo_getoptsarg(RECOBE_CASE_OPTS->bos))) {                                           \
        ifBLIN_QW0("No -%c arg", RECOBE_CASE_OPTS->bos->c);                                           \
        RECOBE_CASE_EX = -EX_USAGE;                                                                   \
        goto RECOBE_CASE_OUT;                                                                         \
    }                                                                                                 \
    if  (!(RECOBE_CASE_OPTS->chain = recobe_openc( &RECOBE_CASE_OPTS->cf                              \
                                                 , o                                                  \
                                                 , 0                                                  \
                                                 , RECOBE_CASE_OPTS->chain                            \
        ) )                                      ) {                                                  \
        ifBLIN_QW0("recobe_openc=%s~", o);                                                            \
        RECOBE_CASE_EX = -EX_UNAVAILABLE;                                                             \
        goto RECOBE_CASE_OUT;                                                                         \
    }                                                                                                 \
    if  (!RECOBE_CASE_OPTS->chain0) RECOBE_CASE_OPTS->chain0 = RECOBE_CASE_OPTS->chain;               \
    RECOBE_CASE_OPTS->cf.flags &= ~RECOBE_CLEAR;                                                      \
} while(0)

# define RECOBE_CASE_C do {RECOBE_CASE_OPTS->cf.flags ^= RECOBE_CLEAR;} while(0)

# define RECOBE_CASE_e do {                                                                           \
    const char       *o;                                                                              \
    if  (!(o = babolo_getoptsarg(RECOBE_CASE_OPTS->bos))) {                                           \
        ifBLIN_QW0("No -%c arg", RECOBE_CASE_OPTS->bos->c);                                           \
        RECOBE_CASE_EX = -EX_USAGE;                                                                   \
        goto RECOBE_CASE_OUT;                                                                         \
    }                                                                                                 \
    if  (!!RECOBE_CASE_OPTS->cf.esubst) {                                                             \
        ifBLIN_QX1("After error mark redefined from %s to %s", RECOBE_CASE_OPTS->cf.esubst, o);       \
        free(RECOBE_CASE_OPTS->cf.esubst);                                                            \
    }                                                                                                 \
    RECOBE_CASE_OPTS->cf.esubst = strdup(o);                                                          \
} while(0)

# define RECOBE_CASE_E do {                                                                           \
    const char       *o;                                                                              \
    if  (!(o = babolo_getoptsarg(RECOBE_CASE_OPTS->bos))) {                                           \
        ifBLIN_QW0("No -%c arg", RECOBE_CASE_OPTS->bos->c);                                           \
        RECOBE_CASE_EX = -EX_USAGE;                                                                   \
        goto RECOBE_CASE_OUT;                                                                         \
    }                                                                                                 \
    if  (!!RECOBE_CASE_OPTS->cf.ecode) {                                                              \
        ifBLIN_QX1("Code end mark redefined from %s to %s", RECOBE_CASE_OPTS->cf.ecode, o);           \
        free(RECOBE_CASE_OPTS->cf.ecode);                                                             \
    }                                                                                                 \
    RECOBE_CASE_OPTS->cf.ecode = strdup(o);                                                           \
} while(0)

# define RECOBE_CASE_f do {                                                                           \
    const char       *o;                                                                              \
    if  (!(o = babolo_getoptsarg(RECOBE_CASE_OPTS->bos))) {                                           \
        ifBLIN_QW0("No -%c arg", RECOBE_CASE_OPTS->bos->c);                                           \
        RECOBE_CASE_EX = -EX_USAGE;                                                                   \
        goto RECOBE_CASE_OUT;                                                                         \
    }                                                                                                 \
    if  (!!RECOBE_CASE_OPTS->argin) {                                                                 \
        ifBLIN_QX1("Input text in argument redefined from %s to %s", RECOBE_CASE_OPTS->argin, o);     \
        free(RECOBE_CASE_OPTS->argin);                                                                \
        RECOBE_CASE_OPTS->argin = NULL;                                                               \
    }                                                                                                 \
    if  (!!RECOBE_CASE_OPTS->filin) {                                                                 \
        ifBLIN_QX1("Input text in file redefined from %s to %s", RECOBE_CASE_OPTS->filin, o);         \
        free(RECOBE_CASE_OPTS->filin);                                                                \
    }                                                                                                 \
    if  (!(RECOBE_CASE_OPTS->filin = strdup(o))) {                                                    \
        ifBLIN_QW0("No mem");                                                                         \
        RECOBE_CASE_EX = -EX_OSERR;                                                                   \
    }                                                                                                 \
} while(0)

# define RECOBE_CASE_H do {RECOBE_CASE_OPTS->cf.flags |= RECOBE_ERHEXPRT;} while(0)

# define RECOBE_CASE_k do {                                                                           \
    const char       *o;                                                                              \
    if  (!(o = babolo_getoptsarg(RECOBE_CASE_OPTS->bos))) {                                           \
        ifBLIN_QW0("No -%c arg", RECOBE_CASE_OPTS->bos->c);                                           \
        RECOBE_CASE_EX = -EX_USAGE;                                                                   \
        goto RECOBE_CASE_OUT;                                                                         \
    }                                                                                                 \
    if  (!(RECOBE_CASE_OPTS->chain = recobe_openk(&RECOBE_CASE_OPTS->cf                               \
                                                 , o                                                  \
                                                 , 0                                                  \
                                                 , RECOBE_CASE_OPTS->chain                            \
        ) )                                      ) {                                                  \
        ifBLIN_QW0("recobe_openk=%s~", o);                                                            \
        RECOBE_CASE_EX = -EX_UNAVAILABLE;                                                             \
        goto RECOBE_CASE_OUT;                                                                         \
    }                                                                                                 \
    if  (!RECOBE_CASE_OPTS->chain0) RECOBE_CASE_OPTS->chain0 = RECOBE_CASE_OPTS->chain;               \
    RECOBE_CASE_OPTS->cf.mod = NULL;                                                                  \
    RECOBE_CASE_OPTS->cf.flags &= ~RECOBE_CLEAR;                                                      \
} while(0)

# define RECOBE_CASE_L do {RECOBE_CASE_OPTS->cf.flags ^= RECOBE_LSTRICT;} while(0)

# define RECOBE_CASE_m do {                                                                           \
    const char       *o;                                                                              \
    if  (!(o = babolo_getoptsarg(RECOBE_CASE_OPTS->bos))) {                                           \
        ifBLIN_QW0("No -%c arg", RECOBE_CASE_OPTS->bos->c);                                           \
        RECOBE_CASE_EX = -EX_USAGE;                                                                   \
        goto RECOBE_CASE_OUT;                                                                         \
    }                                                                                                 \
    if  (!!RECOBE_CASE_OPTS->cf.mod) {                                                                \
        ifBLIN_QX1( "Redefine mod from (%02X)%s to %s"                                                \
                  , *(RECOBE_CASE_OPTS->cf.mod) & 0x00FF                                              \
                  , RECOBE_CASE_OPTS->cf.mod, o                                                       \
                  );                                                                                  \
        free(RECOBE_CASE_OPTS->cf.mod);                                                               \
        RECOBE_CASE_OPTS->cf.mod = NULL;                                                              \
    }                                                                                                 \
    if  (!(RECOBE_CASE_OPTS->cf.mod = strdup(o))) {                                                   \
        ifBLIN_QW0("No mem");                                                                         \
        RECOBE_CASE_EX = -EX_OSERR;                                                                   \
    }                                                                                                 \
} while(0)

# define RECOBE_CASE_M do {                                                                           \
    int               i;                                                                              \
    i = babolo_getoptunum(RECOBE_CASE_OPTS->bos, 0) & 0x00FF;                                         \
    if  (!!errno) {                                                                                   \
        ifBLIN_QW0("Illegal -%c arg", RECOBE_CASE_OPTS->bos->c);                                      \
        RECOBE_CASE_EX = -EX_USAGE;                                                                   \
        goto RECOBE_CASE_OUT;                                                                         \
    }                                                                                                 \
    if  (!!RECOBE_CASE_OPTS->cf.mod) {                                                                \
        ifBLIN_QX1( "Redefine mod from (%02X)%s to %02X"                                              \
                  , *(RECOBE_CASE_OPTS->cf.mod) & 0x00FF                                              \
                  , RECOBE_CASE_OPTS->cf.mod                                                          \
                  , i                                                                                 \
                  );                                                                                  \
        free(RECOBE_CASE_OPTS->cf.mod);                                                               \
        RECOBE_CASE_OPTS->cf.mod = NULL;                                                              \
    }                                                                                                 \
    if  (!(RECOBE_CASE_OPTS->cf.mod = calloc(2, 1))) {                                                \
        ifBLIN_QW0("No mem");                                                                         \
        RECOBE_CASE_EX = -EX_OSERR;                                                                   \
    }                                                                                                 \
    *(RECOBE_CASE_OPTS->cf.mod) = i;                                                                  \
} while(0)

# define RECOBE_CASE_o do {                                                                           \
    const char       *o;                                                                              \
    if  (!(o = babolo_getoptsarg(RECOBE_CASE_OPTS->bos))) {                                           \
        ifBLIN_QW0("No -%c arg", RECOBE_CASE_OPTS->bos->c);                                           \
        RECOBE_CASE_EX = -EX_USAGE;                                                                   \
        goto RECOBE_CASE_OUT;                                                                         \
    }                                                                                                 \
    switch(o[0]) {                                                                                    \
    case 'b': case 'l':                                                                               \
    case 'B': case 'L':                                                                               \
        RECOBE_CASE_OPTS->cf.flags = (RECOBE_CASE_OPTS->cf.flags & ~RECOBE_ORDER)                     \
                                   | (o[0] & RECOBE_ORDER)                                            \
        ;                                                                                             \
        break;                                                                                        \
    default:                                                                                          \
        ifBLIN_QX0("Illegal argument %s of -o option", o);                                            \
    }                                                                                                 \
} while(0)

# define RECOBE_CASE_s do {                                                                           \
    const char       *o;                                                                              \
    if  (!(o = babolo_getoptsarg(RECOBE_CASE_OPTS->bos))) {                                           \
        ifBLIN_QW0("No -%c arg", RECOBE_CASE_OPTS->bos->c);                                           \
        RECOBE_CASE_EX = -EX_USAGE;                                                                   \
        goto RECOBE_CASE_OUT;                                                                         \
    }                                                                                                 \
    if  (!(RECOBE_CASE_OPTS->chain = recobe_opens( &RECOBE_CASE_OPTS->cf                              \
                                                 , o                                                  \
                                                 , RECOBE_CASE_OPTS->chain                            \
        ) )                                      ) {                                                  \
        ifBLIN_QW0("recobe_opens=%s~", o);                                                            \
        RECOBE_CASE_EX = -EX_UNAVAILABLE;                                                             \
        goto RECOBE_CASE_OUT;                                                                         \
    }                                                                                                 \
    if  (!RECOBE_CASE_OPTS->chain0) RECOBE_CASE_OPTS->chain0 = RECOBE_CASE_OPTS->chain;               \
    RECOBE_CASE_OPTS->cf.flags &= ~RECOBE_CLEAR;                                                      \
} while(0)

# define RECOBE_CASE_T do {RECOBE_CASE_OPTS->cf.flags |= RECOBE_TRACE;} while(0)

typedef struct recobe_conv {                                /*    */
    u_int64_t domain  : 16                                  /*                            */
            , encosrc : 23                                  /*  src , 0 -    */
            , nonesrc : 1                                   /* Src                  */
            , encodst : 23                                  /*  dst , 0 -    */
            , nonedst : 1                                   /* Dst                  */
    ;
} recobe_conv;

typedef struct recobe_chunk {
    u_int32_t           size;       /*                              */
    u_int32_t           length;     /*                   */
    u_int32_t           position;   /*        */
    u_int32_t           dummy;
    u_char              chunk[0];   /* Byte array    */
} recobe_chunk;

typedef struct recobe_conf  recobe_conf;
typedef struct recobe_chain recobe_chain;
typedef int               (*recobe_chunker)(recobe_chain *chain, recobe_chunk *chunk);
typedef recobe_chunk     *(*recobe_chainer)(recobe_chain *chain);
typedef int               (*recobe_paramer)(recobe_chain *chain);

struct recobe_chain {
    BLIN_flag           flags;
#  define      RECOBE_USED       0x000001     /*                              */
#  define      RECOBE_ORDER      0x000002     /* Big endian (l = 4C, b = 42) !!! ATTENTION 0x02 !!!  */
#  define      RECOBE_TRACE      0x000004     /* Every conversion stage output                       */
#  define      RECOBE_CHAINER    0x000008     /* 0 - convertor(chain, newchunk), 1 - puller(chain)   */
#  define      RECOBE_DOEND      0x000010     /*                                */
#  define      RECOBE_CLEAR      0x001000     /*   HEX    HEX                         */
#  define      RECOBE_CNVDFREE   0x002000     /* free(->converdata)                                  */
#  define      RECOBE_LSTRICT    0x004000     /*     Qn                      */
#  define      RECOBE_ERHEXPRT   0x080000
    union {
        u_int32_t           inblock;
        struct {
            u_int16_t           inwlen;
            u_int16_t           inwnum;
    };  };
    recobe_conv         cnv;
    recobe_conf        *cf;
    recobe_chain       *next;
    union {
        recobe_chunker      convertor;
        recobe_chainer      puller;
    };
    recobe_chunk       *tail;
    void               *converdata;
    const char         *bsubst;
    const char         *esubst;
    const char         *bcode;
    const char         *ecode;
    union {
        u_int32_t           outblock;
        struct {
            u_int16_t           outwlen;
            u_int16_t           outwnum;
};  };  };

typedef struct recobe_c_tnm {                               /*                    */
    const char         *encoid;                             /*                 */
    const char       *(*enconamess)[];                      /*                      */
    const char         *printable;                          /*                      */
} recobe_c_tnm;

typedef struct recobe_c_tdm {                               /*          */
    const u_int16_t     recountad;                          /*                    */
    const u_int16_t     family;                             /*                        */
#  define      RECOBE_C          0x0001
#  define      RECOBE_K          0x0002
#  define      RECOBE_S          0x0004
    const char         *domname;                            /*                              */
    const recobe_c_tnm *encolist;                           /*                      */
    int               (*codnumbyid)(const char *encoid);    /*     -1     */
    recobe_conv       (*convbyname)(const char *reconm);    /*    reconm    */
    union {
        u_char           *(*reconv)(recobe_conv cnv);       /*    conv         */
        recobe_paramer      param;                          /*         */
    };
} recobe_c_tdm;

typedef struct recobe_collection_t {                        /*         */
    const u_int16_t     domcount;                           /*                      */
    recobe_conv       (*conv)(const char *nm, int domain, u_int16_t family);
                                                            /*         */
    u_char           *(*reconv)(recobe_conv cnv);           /*    conv         */
    const recobe_c_tdm *domains[];                          /*    ,        */
                                                            /*   NULL                          */
} recobe_collection_t;

struct recobe_conf {
    BLIN_flag     flags;
#  define      RECOBE_ORDER      0x000002     /* Big endian (l = 4C, b = 42) !!! ATTENTION 0x02 !!!  */
#  define      RECOBE_TRACE      0x000004     /* Every conversion stage output                       */
#  define      RECOBE_PRINTABLE  0x000100
#  define      RECOBE_PRINTATLE  0x000200
#  define      RECOBE_FULLCHECK  0x000400
#  define      RECOBE_PRELINERA  0x000800
#  define      RECOBE_CLEAR      0x001000     /*   HEX    HEX                         */
#  define      RECOBE_LSTRICT    0x004000     /*     Qn                      */
#  define      RECOBE_REVERTIZE  0x010000
#  define      RECOBE_INTERTIZE  0x020000
#  define      RECOBE_ERHEXPRT   0x080000
    u_int32_t     dummy;
    char         *mod;
    char         *bsubst;
    char         *esubst;
    char         *bcode;
    char         *ecode;
};

/*****************************************************************************************************/
/*****************************************************************************************************/
/**** recobe_collection                                                              ****/
/*****************************************************************************************************/
/*****************************************************************************************************/
# ifdef _MIFE_H_                                                                                   /**/
typedef mife_descriptor recobe_mife_p;                                                             /**/
# else                                                                                             /**/
typedef void recobe_mife_p;                                                                        /**/
# endif                                                                                            /**/
extern const char                   *recobe_1k[65536];                                             /**/
extern const u_int16_t               recobe_k1[256];                                               /**/
extern const recobe_collection_t     recobe_collection;                                            /**/
u_int32_t     recobe_chunkempty __P((recobe_chunk *chunk));                                        /**/
u_int32_t     recobe_chunksize  __P((recobe_chunk *chunk));                                        /**/
const u_char *recobe_chunktext  __P((recobe_chunk *chunk));                                        /**/
int           recobe_close      __P((recobe_chain *chain));                                        /**/
recobe_chunk *recobe_chunkopy   __P((recobe_chain *chain));                                        /**/
recobe_chunk *recobe_chainbuf   __P((recobe_chain *chain));                                        /**/
recobe_chunk *recobe_chainarr   __P((recobe_chain *chain, size_t inlen, void *in));                /**/
int           recobe_chunksum   __P((recobe_chain *chain, recobe_chunk *source));                  /**/
recobe_chunk *recobe_chunkat    __P((recobe_chain *chain, recobe_chunk *in0, recobe_chunk *in1));  /**/
recobe_chain *recobe_openmd     __P((recobe_conf *cf, recobe_mife_p *md, u_int32_t chunksize));    /**/
recobe_chain *recobe_openfile   __P((recobe_conf *cf, const char *filename, u_int32_t chunksize)); /**/
recobe_chain *recobe_openc      __P((recobe_conf *cf, const char *p, int domain, recobe_chain *chain));
recobe_chain *recobe_opens      __P((recobe_conf *cf, const char *p, recobe_chain *chain));        /**/
recobe_chunk *recobe_chunknew   __P(( recobe_chain *chain                                          /**/
                                    , u_int32_t     sz                                             /**/
                                    , u_int32_t     ln                                             /**/
                                    , const u_char *in                                             /**/
                                   ));                                                             /**/
int           recobe_chainput   __P(( recobe_chain *chain                                          /**/
                                    , int           fd                                             /**/
                                    , ssize_t     (*wrt)(int fd, const void *buf, size_t size)     /**/
                                   ));                                                             /**/
          /*******************************************************************************************/

/*****************************************************************************************************/
/*****************************************************************************************************/
/****                                     G.711                                                   ****/
/*****************************************************************************************************/
/*****************************************************************************************************/
extern const int16_t             recobe_deG711A[256];    /*   G.711 A-law   */
extern const int16_t             recobe_deG711u[256];    /*   G.711 u-law   */
u_char    recobe_G711A        __P((int16_t sample));     /*     G.711 A-law     */
u_char    recobe_G711u        __P((int16_t sample));     /*     G.711 u-law     */
int       recobe_G711Atest    __P((int fi, u_char *buf, size_t l)); /*  buf  l       */
                                                                    /*  1KHz c  fi (0..7)*/
                                                                    /*   G.711 A-law            */
int       recobe_G711utest    __P((int fi, u_char *buf, size_t l)); /*  buf  l       */
                                                                    /*  1KHz c  fi (0..7)*/
                                                                    /*   G.711 u-law            */
          /*******************************************************************************************/

/*****************************************************************************************************/
/*****************************************************************************************************/
/****                                    Unicode                                                  ****/
/*****************************************************************************************************/
/*****************************************************************************************************/
int         recobe_puny_encase  __P((recobe_chain *chain, recobe_chunk *chunk));                   /**/
int         recobe_puny_encode  __P((recobe_chain *chain, recobe_chunk *chunk));                   /**/
int         recobe_puny_decase  __P((recobe_chain *chain, recobe_chunk *chunk));                   /**/
int         recobe_puny_decode  __P((recobe_chain *chain, recobe_chunk *chunk));                   /**/
u_int64_t   recobe_unicodeupper __P((u_int64_t d));                                                /**/
u_int64_t   recobe_unicodelower __P((u_int64_t d));                                                /**/

typedef struct recobe_ucdclass {
    u_int16_t GeneralCategory : 6
#               define recobe_GC_Uppercase_Letter        001 /* Letter */
#               define recobe_GC_Lowercase_Letter        002
#               define recobe_GC_Titlecase_Letter        003
#               define recobe_GC_Modifier_Letter         004
#               define recobe_GC_Other_Letter            007

#               define recobe_GC_Nonspacing_Mark         011 /* Mark */
#               define recobe_GC_Spacing_Mark            012
#               define recobe_GC_Enclosing_Mark          013

#               define recobe_GC_Decimal_Number          021 /* Number */
#               define recobe_GC_Letter_Number           022
#               define recobe_GC_Other_Number            027

#               define recobe_GC_Connector_Punctuation   031 /* Punctuation */
#               define recobe_GC_Dash_Punctuation        032
#               define recobe_GC_Open_Punctuation        033
#               define recobe_GC_Close_Punctuation       034
#               define recobe_GC_Initial_Punctuation     035
#               define recobe_GC_Final_Punctuation       036
#               define recobe_GC_Other_Punctuation       037 

#               define recobe_GC_Math_Symbol             041 /* Symbol */
#               define recobe_GC_Currency_Symbol         042
#               define recobe_GC_Modifier_Symbol         043
#               define recobe_GC_Other_Symbol            047

#               define recobe_GC_Space_Separator         051 /* Separator */
#               define recobe_GC_Line_Separator          052
#               define recobe_GC_Paragraph_Separator     053

#               define recobe_GC_Control                 061 /* Other */
#               define recobe_GC_Format                  062
#               define recobe_GC_Surrogate               063
#               define recobe_GC_Private_Use             064
#               define recobe_GC_Unassigned              067
            , Bidi_Class : 5
#               define recobe_BD_Left_To_Right           001 /* Strong Types */
#               define recobe_BD_Right_To_Left           002
#               define recobe_BD_Arabic_Letter           003

#               define recobe_BD_European_Number         011 /* Weak Types */
#               define recobe_BD_European_Separator      012
#               define recobe_BD_European_Terminator     013
#               define recobe_BD_Arabic_Number           014
#               define recobe_BD_Common_Separator        015
#               define recobe_BD_Nonspacing_Mark         016
#               define recobe_BD_Boundary_Neutral        017

#               define recobe_BD_Paragraph_Separator     004 /* Neutral Types */
#               define recobe_BD_Segment_Separator       005
#               define recobe_BD_White_Space             006
#               define recobe_BD_Other_Neutral           007

#               define recobe_BD_Left_To_Right_Embedding 021 /* Explicit Formatting Types */
#               define recobe_BD_Left_To_Right_Override  022
#               define recobe_BD_Right_To_Left_Embedding 023
#               define recobe_BD_Right_To_Left_Override  024
#               define recobe_BD_Pop_Directional_Format  025
#               define recobe_BD_Left_To_Right_Isolate   026
#               define recobe_BD_Right_To_Left_Isolate   027
#               define recobe_BD_First_Strong_Isolate    030
#               define recobe_BD_Pop_Directional_Isolate 031
            , DecompositionType : 5
#               define recobe_DT_font     001
#               define recobe_DT_noBreak  002
#               define recobe_DT_initial  003
#               define recobe_DT_medial   004
#               define recobe_DT_final    005
#               define recobe_DT_isolated 006
#               define recobe_DT_circle   007
#               define recobe_DT_super    010
#               define recobe_DT_sub      011
#               define recobe_DT_vertical 012
#               define recobe_DT_wide     013
#               define recobe_DT_narrow   014
#               define recobe_DT_small    015
#               define recobe_DT_square   016
#               define recobe_DT_fraction 017
#               define recobe_DT_compat   020
    ;
} recobe_ucdclass;
          /*******************************************************************************************/

/*****************************************************************************************************/
/*****************************************************************************************************/
/*   octets      .                                        */
/* 0 > len                                                       */
/*****************************************************************************************************/
/*****************************************************************************************************/
extern const u_char              recobe_most1[256];                    /*        */
extern const u_int8_t            recobe_cnt1[256];                     /*      */
extern const u_char              recobe_bysh[7][256][2];               /*                 */
u_int32_t recobe_crc32     __P((const u_char *octets, ssize_t len));   /*  crc32 (IEEE 802.3) */
u_int32_t recobe_crc24     __P((const u_char *octets, ssize_t len));   /*  crc24 (RFC-2440)   */
u_int16_t recobe_crccitt   __P((const u_char *octets, ssize_t len));   /*  crc16 CCITT        */
u_int8_t  recobe_csum      __P((const u_char *octets, ssize_t len));   /*   + */
u_int8_t  recobe_csum1     __P((const u_char *octets, ssize_t len));   /*     */
u_int64_t recobe_load      __P((const u_char *octets, ssize_t len));   /*        */
                                                                       /*  octets  |len|*/
                                                                       /*      */
void      recobe_store     __P((u_char *octets, ssize_t len, u_int64_t c));/*  c      */
                                                                       /*    octets     */
                                                                       /*  |len|     */
u_int64_t recobe_loadM     __P((const u_char *octets, const char *mask));/*  octets  */
                                                                       /*   mask              */
int       recobe_storeM    __P((u_char *octets, const char *mask, u_int64_t c));/*  c */
                                                                       /*    octets     */
                                                                       /*   mask              */
u_int64_t recobe_uload     __P((const u_char *octets, ssize_t *len));  /* Load from UTF-8            */
int       recobe_ustore    __P((u_char *octets, u_int64_t c));         /* Store  UTF-8              */
int       recobe_utest     __P((u_int64_t c));                         /* Estimate UTF-8 byte size   */
int       recobe_ulen      __P((u_char octet));                        /* Stored UTF-8 byte size     */
u_int64_t recobe_cload     __P((const u_char *octets, ssize_t *len));  /* Load from CLEN             */
int       recobe_cstore    __P((u_char *octets, u_int64_t c));         /* Store  CLEN               */
int       recobe_clen      __P((u_char octet));                        /* Stored CLEN byte size      */
u_int64_t recobe_swap      __P((u_int64_t c, u_int8_t m));             /*     c    */
                                                                       /*   m           */
int       recobe_count     __P((u_int64_t c));                         /*     */
                                                                       /*                  */
int       recobe_wide      __P((u_int64_t c));                         /* c width                    */
          /*******************************************************************************************/

/****#############################################################################################****
 #####################################################################################################
 ####                                                                                             ####
 ####                           recobe 4 compatibility                                            ####
 ####                                                                                             ####
 *****************************************************************************************************/
# if defined(RECOBE_COMPAT) && (RECOBE_COMPAT <= 4)
int           recobe_chainout   __P((recobe_chain *chain, int fd));                                /**/
recobe_chunk *recobe_chunkeot   __P((recobe_chain *chain));                                        /**/
#  define     cnvby(nm, domain) conv((nm), (domain), 0)
#  define     recobe_openk      recobe__openk
recobe_chain *recobe__openk     __P((recobe_conf *cf, const char *p, recobe_chain *chain, char *mod));
# else
recobe_chain *recobe_openk      __P((recobe_conf *cf, const char *p, int domain, recobe_chain *chain));
# endif
                                                                                                   /**/
/****#############################################################################################****
 #####################################################################################################
 ####                                                                                             ####
 ####                                 Private                                                     #### 
 ####                                                                                             ####
 *****************************************************************************************************/
# ifdef RECOBE_INTERNAL                                                           /* RECOBE_INTERNAL */
#  define RECOBE_CHUNK(A)                                                                             \
          do {ifBLIN_QO3 recobe_testtail(3, __FILE__, __func__, __LINE__, (A));} while(0)          /**/
#  define RECOBE_CHAIN(A) do {ifBLIN_QO3 recobe_testchain(__FILE__, __func__, __LINE__, (A));} while(0)

typedef struct recobe_opts {
    recobe_conf       cf;
    recobe_chain     *chain0;
    recobe_chain     *chain;
    char             *argin;
    char             *filin;
#  ifndef  _BABOLO_PARSER_H_
    void             *bos;
#  else
    babolo_opts      *bos;
#  endif
} recobe_opts;

extern const char      recobe_nullprintable[256];                                                  /**/
extern const char      recobe_koi8printable[256];                                                  /**/
void recobe_testchain    __P((const char *file, const char *func, int line, recobe_chain *chain)); /**/
void recobe_testtail     __P(( int lev                                                             /**/
                             , const char *file                                                    /**/
                             , const char *func                                                    /**/
                             , int line                                                            /**/
                             , recobe_chunk *tail                                                  /**/
                             ));                                                                   /**/
void recobe_cnverr       __P(( const char *file                                                    /**/
                             , const char *func                                                    /**/
                             , int line                                                            /**/
                             , const char *mesg                                                    /**/
                             , recobe_conv cnv                                                     /**/
                            ));                                                                    /**/
int  recobe_inword       __P((recobe_chain *chain, recobe_chunk *chunk, u_int64_t *wchr));         /**/
int  recobe_outword      __P((recobe_chain *chain, recobe_chunk *chunk, u_int64_t wchr));          /**/
                                                                                                  /* */
int  recobe_TestOrRevert __P((const char *p));                                                   /*  */
int  recobe_PrintAndMake __P((const char *p));                                                  /*   */
int  recobe_PrintNoRecod __P((const char *p));                                                 /*    */
int  recobe_WriteAndMake __P((const char *p));                                                /*     */
int  recobe_G711DiffConv __P((const char *p));                                               /*      */
int  recobe_PrintFilling __P((const char *p));                                              /*       */
int  recobe_InterMediaTo __P((const char *p));                                             /*        */
int  recobe_EtalonCompar __P((const char *p));                                            /*         */
int  recobe_ReCalculator __P((const char *p));                                           /*          */
int  recobe_ReCoordinate __P((const char *p));                                          /*           */
int  recobe_PrintWideStr __P((const char *p));                                         /*            */
int  recobe_TramplesDown __P((const char *p));                                        /*             */
void recobe_p256         __P(( const char *from                                      /*              */
                             , const char *to                                       /*               */
                             , u_int16_t domain                                    /*                */
                             , const u_char array[256]                            /*                 */
                            ));                                                  /*                  */
                                                                                /*                   */
# endif                                                                        /*    RECOBE_INTERNAL */
/*****************************************************************************************************/

__END_DECLS

#endif /* _BABOLO_RECOBE_H_ */
