/*-
 * Copyright (C)2014..2021 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2014..2021 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: collect.c,v 1.40 2021/12/05 17:53:10 babolo Exp $"

#define MIFE_COMPAT     5
#define BLIN_COMPAT     4
#define RECOBE_COMPAT   VMAJOR
#define RECOBE_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <mife.h>
#include "recobe.h"

extern const recobe_c_tdm recobe_text_dm;
extern const recobe_c_tdm recobe_G711_dm;
extern const recobe_c_tdm recobe_etat_dm;
extern const recobe_c_tdm recobe_crc_dm;
extern const recobe_c_tdm recobe_wide_dm;
extern const recobe_c_tdm recobe_code_dm;

const char
/*****************************************************************************************************
                                                                                                  ****/
recobe_nullprintable[256] =                                                                      /****
                                                                                                  ****
 *****************************************************************************************************/
{     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0

,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0

,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0

,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
};

const char
/*****************************************************************************************************
                                                                                                  ****/
recobe_koi8printable[256] =                                                                      /****
                                                                                                  ****
 *****************************************************************************************************/
{     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,  0x20, 0x21, 0x22, 0x23,  0x24, 0x25, 0x26, 0x27,  0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x2D, 0x2E, 0x2F
,  0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,  0x38, 0x39, 0x3A, 0x3B,  0x3C, 0x3D, 0x3E, 0x3F

,  0x40, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,  0x48, 0x49, 0x4A, 0x4B,  0x4C, 0x4D, 0x4E, 0x4F
,  0x50, 0x51, 0x52, 0x53,  0x54, 0x55, 0x56, 0x57,  0x58, 0x59, 0x5A, 0x5B,  0x5C, 0x5D, 0x5E, 0x5F
,  0x60, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,  0x68, 0x69, 0x6A, 0x6B,  0x6C, 0x6D, 0x6E, 0x6F
,  0x70, 0x71, 0x72, 0x73,  0x74, 0x75, 0x76, 0x77,  0x78, 0x79, 0x7A, 0x7B,  0x7C, 0x7D, 0x7E,    0

,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0, 0xA3,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0
,     0,    0,    0, 0xB3,     0,    0,    0,    0,     0,    0,    0,    0,     0,    0,    0,    0

,  0xC0, 0xC1, 0xC2, 0xC3,  0xC4, 0xC5, 0xC6, 0xC7,  0xC8, 0xC9, 0xCA, 0xCB,  0xCC, 0xCD, 0xCE, 0xCF
,  0xD0, 0xD1, 0xD2, 0xD3,  0xD4, 0xD5, 0xD6, 0xD7,  0xD8, 0xD9, 0xDA, 0xDB,  0xDC, 0xDD, 0xDE, 0xDF
,  0xE0, 0xE1, 0xE2, 0xE3,  0xE4, 0xE5, 0xE6, 0xE7,  0xE8, 0xE9, 0xEA, 0xEB,  0xEC, 0xED, 0xEE, 0xEF
,  0xF0, 0xF1, 0xF2, 0xF3,  0xF4, 0xF5, 0xF6, 0xF7,  0xF8, 0xF9, 0xFA, 0xFB,  0xFC, 0xFD, 0xFE, 0xFF
};

static recobe_conv
/*****************************************************************************************************
 *****************************************************************************************************
 ****   .                                                                ****
 ****  domain 0,   name   ,                            ****
 *****************************************************************************************************
                                                                                                  ****/
conv(const char *name, int domain, u_int16_t family) {                                           /****
                                                                                                  ****
 *****************************************************************************************************
 *****************************************************************************************************/
    recobe_conv cnv = {0, 0, 0, 0, 0};
    recobe_conv ctonv;
    int g;

    for (g = (!domain ? 1 : domain); g < (!domain ? recobe_collection.domcount : domain + 1); ++g) {
        if  (family & recobe_collection.domains[g]->family) {
            ctonv = recobe_collection.domains[g]->convbyname(name);
            if  (!!ctonv.encosrc && !!ctonv.encodst) {
                cnv = ctonv;
                break;
    }   }   }
    return(cnv);
}

static u_char *
/*****************************************************************************************************
 *****************************************************************************************************
 ****  cnv                                                       ****
 *****************************************************************************************************
                                                                                                  ****/
reconv(recobe_conv cnv) {                                                                        /****
                                                                                                  ****
 *****************************************************************************************************
 *****************************************************************************************************/
    u_char *t = NULL;

    if  ((0 < cnv.domain) && (recobe_collection.domcount > cnv.domain)) {
        t = recobe_collection.domains[cnv.domain]->reconv(cnv);
    }
    return(t);
}

static const recobe_c_tnm
/*****************************************************************************************************
                                                                                                  ****/
encolist[1] =                                                                                    /****
                                                                                                  ****
 *****************************************************************************************************/
{ { NULL, NULL,      NULL}
};

static const recobe_c_tdm
/*****************************************************************************************************
 *****************************************************************************************************
 ****   IN                                                                         ****
 *****************************************************************************************************
                                                                                                  ****/
recobe_in_dm =                                                                                   /****
                                                                                                  ****
 *****************************************************************************************************
 *****************************************************************************************************/
{1, 0, "IN", encolist, NULL, NULL, {NULL}};

const recobe_collection_t
/*****************************************************************************************************
 *****************************************************************************************************
 ****                                                            ****
 *****************************************************************************************************
                                                                                                  ****/
recobe_collection =                                                                              /****
                                                                                                  ****
 *****************************************************************************************************
 *****************************************************************************************************/
{ RECOBE_DOMAX
, conv
, reconv
, { &recobe_in_dm
  , &recobe_text_dm
  , &recobe_G711_dm
  , &recobe_etat_dm
  , &recobe_crc_dm
  , &recobe_wide_dm
  , &recobe_code_dm
  , NULL
} };
