/*-
 * Copyright (C)2016..2021 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2016..2021 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: code.c,v 1.17 2021/12/05 17:53:10 babolo Exp $"

#define MIFE_COMPAT     5
#define BLIN_COMPAT     4
#define Bpars_COMPAT    4
#define RECOBE_COMPAT   VMAJOR
#define RECOBE_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <strings.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <mife.h>
#include "recobe.h"
#include "htref.h"
#include "htext.h"

#define CODE_L        14
#define RECOBE_DECMAX 30

/*****************************************************************************************************
 *****************************************************************************************************/
static const char *                                                                              /****/
kode_0[] = {"8bit"            , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_1[] = {"UCS2"            , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_2[] = {"UCS3"            , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_3[] = {"UCS4"            , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_4[] = {"UCS5"            , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_5[] = {"UCS6"            , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_6[] = {"UCS7"            , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_7[] = {"UCS8"            , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_B[] = {"base64"          , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_Q[] = {"quoted-printable", NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_X[] = {"HEX"             , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_D[] = {"DEC"             , NULL};                                                           /****/
                                                                                                 /****/
static const char *                                                                              /****/
kode_H[] = {"HTML"            , NULL};                                                           /****/

/*****************************************************************************************************
 *****************************************************************************************************/

static const recobe_c_tnm
/*****************************************************************************************************
                                                                                                  ****/
encolist[CODE_L] =                                                                               /****
                                                                                                  ****
 *****************************************************************************************************/
{ { NULL, NULL,     NULL}
#define CODE0  1
, { "0" , &kode_0,  NULL}
#define CODE1  2
, { "1" , &kode_1,  NULL}
#define CODE2  3
, { "2" , &kode_2,  NULL}
#define CODE3  4
, { "3" , &kode_3,  NULL}
#define CODE4  5
, { "4" , &kode_4,  NULL}
#define CODE5  6
, { "5" , &kode_5,  NULL}
#define CODE6  7
, { "6" , &kode_6,  NULL}
#define CODE7  8
, { "7" , &kode_7,  NULL}
#define CODEB  9
, { "B" , &kode_B,  NULL}
#define CODEQ 10
, { "Q" , &kode_Q,  NULL}
#define CODEX 11
, { "X" , &kode_X,  NULL}
#define CODED 12
, { "D" , &kode_D,  NULL}
#define CODEH 13
, { "H" , &kode_H,  NULL}
};

static int
/*****************************************************************************************************
                                                                                                  ****/
codnumbyid(const char *nm) {                                                                     /****
                                                                                                  ****
 *****************************************************************************************************/
    int   r = 0;
    int   i;

    for (i = 1; i < CODE_L; ++i) {
        if  (nm[0] == encolist[i].encoid[0]) {
            r = i;
            break;
    }   }
    return(r);
}

static recobe_conv
/*****************************************************************************************************
                                                                                                  ****/
convbyname(const char *name) {                                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
    recobe_conv cnv = {RECOBE_CODE, 0, 0, 0, 0};

    if  (!name || !name[0]) {
        cnv.nonesrc = cnv.nonedst = 1;
    } else {
        cnv.encosrc = codnumbyid(name);
        if  (!name[1]) {
            cnv.nonedst = 1;
        } else if (!!name[2]) {
            cnv.encodst = 0;
        } else {
            cnv.encodst = codnumbyid(&name[1]);
    }   }
    return(cnv);
}

static int
/*****************************************************************************************************
                                                                                                  ****/
toch(recobe_chain *chain, recobe_chunk *chunk, int64_t ln, u_int64_t word) {                     /****
                                                                                                  ****
 *****************************************************************************************************/
#   define blin_internal_flags (chain->flags)
    int     ex = EX_OK;

    ifBLIN_QX3( "+ %08X %"BLIN_X" %"BLIN_X" %u+%u %u"
              , chain->flags
              , BLIN_I(chain)
              , BLIN_I(chunk)
              , chunk->position
              , chunk->length
              , chunk->size
              );
    if  (chunk->size < chunk->length + ln) {
        ifBLIN_QX0("size=%u < length=%u + outwlen=%u", chunk->size, chunk->length, ln);
        errno = ENOSPC;
        ex = -EX_CANTCREAT;
    } else {
        recobe_store(&chunk->chunk[chunk->length], -ln, word);
        chunk->length += (ex = ln);
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
                                                                                                  ****/
nxt(recobe_chain *chain, recobe_chunk *chunk, u_int32_t pos) {                                   /****
                                                                                                  ****
 *****************************************************************************************************/
#   define blin_internal_flags (chain->flags)
    u_int64_t     word;
    int           ex = EX_OK;

    ifBLIN_QX3("+ %u %u", chain->tail->position, pos);
    chain->tail->position = pos;
    if  (recobe_chunksize(chain->tail) < chain->inwlen) {
        chain->tail->position = chain->tail->length;
        ex = -1;
    } else if (chain->flags & RECOBE_CLEAR) {
        chain->tail->position += chain->inwlen;
        ex = -1;
    } else if (0 > (ex = recobe_inword(chain, chain->tail, &word))) {
        ifBLIN_QW1("recobe_inword");
    } else if (!ex) {
    } else if (0 > (ex = recobe_outword(chain, chunk, word))) {
        ifBLIN_QW1("recobe_outword");
        ex = 0;
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
                                                                                                  ****/
Hn(recobe_chain *chain, recobe_chunk *chunk) {                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
#   define blin_internal_flags (chain->flags)
    u_int32_t     maxcy = (htref.szt + htref.szp + 2) / (htref.szp + 1);           /* Max cycle size */
    u_int32_t     state;
    u_int32_t     curcy;
    u_int64_t     word;
    u_int32_t     ochr;
    u_int32_t     pos;
    BLIN_flag     fl = (BLIN_flag)chain->converdata;
    int           ex = EX_OK;
    const char   *pw;

    ifBLIN_QX3("+ %08X %"BLIN_X, chain->flags, BLIN_I(chain));
    RECOBE_CHAIN(chain);
    for ( recobe_chain *next = chain
        ;  !!next
        && (chain->flags & ~RECOBE_USED)
        && (RECOBE_CODE == next->cnv.domain)
        && (!next->cnv.nonesrc)
        && (!next->cnv.nonedst)
        && (  (CODEX == next->cnv.encosrc)
           || (CODED == next->cnv.encosrc)
           || (CODEH == next->cnv.encosrc)
           )
        && (chain->cnv.encodst == next->cnv.encodst)
        && (chain->inwlen == next->inwlen)
        && (chain->outwlen == next->outwlen)
        ; next = chain->next
        ) {
        ifBLIN_QX4("%u", next->cnv.encosrc);
        switch(next->cnv.encosrc) {
        case CODEX: fl |= RECOBE_XCONV; break;
        case CODED: fl |= RECOBE_DCONV; break;
        case CODEH: fl |= RECOBE_HCONV; break;
        }
        chain->converdata = (void *)(u_int64_t)fl;
        if  (next != chain) {
            recobe_chain *t = next->next;

            free(next);
            chain->next = t;
            ifBLIN_QX4("%08X %"BLIN_X, fl, t);
    }   }
    pos = chain->tail->position;
    for (state = 0, curcy = maxcy; state < htref.szt; --curcy) {
        ifBLIN_QX4("%08X %u", state, curcy);
        if  (recobe_chunksize(chain->tail) < chain->inwlen) {
            ifBLIN_QX1("");
            ex = nxt(chain, chunk, pos);
            goto out;
        }
        if  (!curcy) {
            state = ~0;
            ifBLIN_QX0("infinite loop %u", maxcy);
            ex = -EX_SOFTWARE;
            errno = EDOOFUS;
            goto out;
        }
        if  (0 > (ex = recobe_inword(chain, chain->tail, &word))) {
            ifBLIN_QW1("recobe_inword");
            goto out;
        }
        if  (!ex) break;
        if  (0xFFFFFFFFFFFFFF00 & word) {
            ifBLIN_QX1("");
            ex = nxt(chain, chunk, pos);
            goto out;
        }
        ifBLIN_QX4("%02X(%c)", word, word);
        pw = (char *)&word;
        state = babolo_testchar(&htref, state, &pw);
    }
    ifBLIN_QX4("%08X %u %08X", state, curcy, fl);
    if  (!(ochr = ~state)) {
        ex = nxt(chain, chunk, pos);
        goto out;
    }
    ifBLIN_QX4("%08X %u", ochr, ochr);
    if  (RECOBE_DECOHEX > ochr) {
        if  (RECOBE_DCONV & ~fl) {
            if  (0 > (ex = nxt(chain, chunk, pos))) ifBLIN_QX1("");
            goto out;
        }
        for (ochr -= 1; ;) {
            if  (0 > (ex = recobe_inword(chain, chain->tail, &word))) {
                ifBLIN_QW1("recobe_inword");
                goto out;
            }
            if  ((!ex) || (0xFFFFFFFFFFFFFF00 & word)) {
                ifBLIN_QX1("");
                ex = nxt(chain, chunk, pos);
                goto out;
            }
            if  (';' == word) break;
            if  (('0' > word) || (word > '9')) {
                ifBLIN_QX1("");
                ex = nxt(chain, chunk, pos);
                goto out;
            }
            ochr = (ochr * 10) + (word - '0');
        }
    } else if (RECOBE_DECOHEX == ochr) {
        if  (RECOBE_XCONV & ~fl) {
            if  (0 > (ex = nxt(chain, chunk, pos))) ifBLIN_QX1("");
            goto out;
        }
        for (ochr = 0; ;) {
            if  (0 > (ex = recobe_inword(chain, chain->tail, &word))) {
                ifBLIN_QW1("recobe_inword");
                goto out;
            }
            if  ((!ex) || (0xFFFFFFFFFFFFFF00 & word)) {
                ifBLIN_QX1("");
                ex = nxt(chain, chunk, pos);
                goto out;
            }
            if  (';' == word) break;
            if  (('0' <= word) && (word <= '9')) {
                ochr = (ochr << 4) | (word - '0');
            } else if (('A' <= word) && (word <= 'F')) {
                ochr = (ochr << 4) | (word - 'A' + 10);
            } else if (('a' <= word) && (word <= 'f')) {
                ochr = (ochr << 4) | (word - 'a' + 10);
            } else {
                ifBLIN_QX1("");
                ex = nxt(chain, chunk, pos);
                goto out;
        }   }
    } else if (RECOBE_HCONV & ~fl) {
        if  (0 > (ex = nxt(chain, chunk, pos))) ifBLIN_QX1("");
        goto out;
    }
    ifBLIN_QX4("%08X %u", ochr, ochr);
    if  (0 > (ex = recobe_outword(chain, chunk, ochr))) ifBLIN_QW1("recobe_outword");
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static u_char b64d[] =
{ 0x80, 0x80, 0x80, 0x80 , 0x80, 0x80, 0x80, 0x80 , 0x80, 0x80, 0x80, 0x80 , 0x80, 0x80, 0x80, 0x80
, 0x80, 0x80, 0x80, 0x80 , 0x80, 0x80, 0x80, 0x80 , 0x80, 0x80, 0x80, 0x80 , 0x80, 0x80, 0x80, 0x80
, 0x80, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0x3E , 0xC0, 0xC0, 0xC0, 0x3F
, 0x34, 0x35, 0x36, 0x37 , 0x38, 0x39, 0x3A, 0x3B , 0x3C, 0x3D, 0xC0, 0xC0 , 0xC0, 0x40, 0xC0, 0xC0

, 0xC0, 0x00, 0x01, 0x02 , 0x03, 0x04, 0x05, 0x06 , 0x07, 0x08, 0x09, 0x0A , 0x0B, 0x0C, 0x0D, 0x0E
, 0x0F, 0x10, 0x11, 0x12 , 0x13, 0x14, 0x15, 0x16 , 0x17, 0x18, 0x19, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0
, 0xC0, 0x1A, 0x1B, 0x1C , 0x1D, 0x1E, 0x1F, 0x20 , 0x21, 0x22, 0x23, 0x24 , 0x25, 0x26, 0x27, 0x28
, 0x29, 0x2A, 0x2B, 0x2C , 0x2D, 0x2E, 0x2F, 0x30 , 0x31, 0x32, 0x33, 0xC0 , 0xC0, 0xC0, 0xC0, 0x80

, 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0
, 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0
, 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0
, 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0

, 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0
, 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0
, 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0
, 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0 , 0xC0, 0xC0, 0xC0, 0xC0
};

enum states
{ b0 /* 0       */
, b1 /* 1       */
, b2 /* 2       */
, b3 /* 3       */
, ba /* S=V==   */
, bb /* S==V=   */
, bz /* skip == */
, bs /* skip =  */
, bx
};

static const char statenames[][3] =
{ "b0", "b1", "b2", "b3", "ba", "bb", "bz", "bs", "bx"};

static const char clasnames[][3] =
{ "LS", "LS", "LS", "LS", "LS", "LS", "LS", "LS", "LS", "LS", "LS", "LS", "LS", "LS", "LS", "LS"
, "LS", "LS", "LS", "LS", "LS", "LS", "LS", "LS", "LS", "LS", "Ls", "Ls", "Ls", "Ls", "Ls", "Ls"
, "Ls", "Ls", "Ls", "Ls", "Ls", "Ls", "Ls", "Ls", "Ls", "Ls", "Ls", "Ls", "Ls", "Ls", "Ls", "Ls"
, "Ls", "Ls", "Ls", "Ls", "Ld", "Ld", "Ld", "Ld", "Ld", "Ld", "Ld", "Ld", "Ld", "Ld", "Ly", "Ly"

, "L=", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L."
, "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L."
, "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L."
, "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L."

, "L-", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,"
, "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,"
, "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,"
, "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,"

, "L+", "L#", "L#", "L#", "L#", "L#", "L#", "L#", "L#", "L#", "L#", "L#", "L#", "L#", "L#", "L#"
};

static const char pn[][3] = 
{ "- ", "- ", "- ", "- ", "- ", "- ", "- ", "- "
, "- ", "- ", "- ", "- ", "C0", "C1", "C2", "C3"
, "Ca", "Cb", "Cc", "Cd", "- ", "- ", "- ", "Cx"
};

#define C0 0x00080000 /* 1                 */
#define C1 0x00040000 /* 2                 */
#define C2 0x00020000 /* 3                 */
#define C3 0x00010000 /* 4                 */
#define Ca 0x00008000 /* ===                 */
#define Cb 0x00004000 /* ==                  */
#define Cc 0x00002000 /* =                   */
#define Cd 0x00001000 /*                     */
#define Cx 0x00000100 /* error               */
#define C_state  0xFF /*   */

static u_int32_t automa[bx][5] =
/*       0      4      8         C      nl  */
{{    C0|b1, Cx|bx,    b0,    Cx|bx,    bx}/* b0 */
,{    C1|b2, Ca|bx,    b1, Ca|Cx|bx, Ca|bx}/* b1 */
,{    C2|b3, Cb|bs,    b2, Cb|Cx|bx, Cb|bx}/* b2 */
,{ Cd|C3|bx, Cc|bx,    bx, Cc|Cx|bx, Cc|bx}/* b3 */
,{    Cx|bx,    bb,    bx,    Cx|bx,    bx}/* ba */
,{    Cx|bx,    bx,    bx,    Cx|bx,    bx}/* bb */
,{    Cx|bx,    bs, Cx|bx,    Cx|bx, Cx|bx}/* bz */
,{    Cx|bx,    bx, Cx|bx,    Cx|bx, Cx|bx}/* bs */
};

static int
/*****************************************************************************************************
                                                                                                  ****/
BT(recobe_chain *chain, recobe_chunk *chunk) {                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
#   define blin_internal_flags (chain->flags)
    u_int32_t     control;
    int           state;
    int           ex = 0;
    ssize_t       intail;
    u_int32_t     ochr;
    const u_char *ichr;

    ifBLIN_QX3("+ %08X %"BLIN_X, chain->flags, BLIN_I(chain));
    intail = recobe_chunksize(chain->tail);
    if  (intail < 1) {
        ex = -1;
        goto out;
    }
    ichr = recobe_chunktext(chain->tail);
    blin_stateheader(BLIN_2STA24G, pn);
    for (ochr = 0, state = b0; state < bx; ++ichr, --intail, chain->tail->position++) {
        control = automa[state][(0 < intail) ? (b64d[*ichr] >> 6) : 4];
        blin_statebody( BLIN_2STA24G
                      , pn
                      , statenames
                      , clasnames[b64d[*ichr] & 0xFF]
                      , (char*)ichr
                      , intail
                      , control
                      , state
                      , ochr
                      , b64d[*ichr]
                      );
        if  (control & C0) ochr = b64d[*ichr] << 18;
        if  (control & C1) ochr |= b64d[*ichr] << 12;
        if  (control & C2) ochr |= b64d[*ichr] << 6;
        if  (control & C3) ochr |= b64d[*ichr];
        if  (control & Ca) {
            ifBLIN_QX1("Trunc 1");
            ex = recobe_outword(chain, chunk, ochr >> 16);
            if  (0 > ex) {
                ifBLIN_QW0("@Trunc 1");
            } else {
                ex = -1;
        }   }
        if  (control & Cb) {
            if  (ochr & 0x0000FFFF) {
                ifBLIN_QX1("Trunc 2");
                ex = toch(chain, chunk, 2, ochr >> 8);
                if  (0 < ex) ex = -1;
            } else {
                ex = recobe_outword(chain, chunk, ochr >> 16);
        }   }
        if  (control & Cc) {
            if  (ochr & 0x000000FF) {
                ifBLIN_QX1("Trunc 3");
                ex = toch(chain, chunk, 3, ochr);
                if  (0 > ex) {
                    ifBLIN_QW0("@Trunc 3");
                } else {
                    ex = -1;
                }
            } else {
                ex = toch(chain, chunk, 2, ochr >> 8);
        }   }
        if  (control & Cd) {
            ex = toch(chain, chunk, 3, ochr);
            ex = 3;
        }
        if  (control & Cx) {
            ifBLIN_QX0("B64 syntax");
        }
        state = control & C_state;
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static const char b64e[64] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

static int
/*****************************************************************************************************
                                                                                                  ****/
TB(recobe_chain *chain, recobe_chunk *chunk) {                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
    int           ex = 0;
    ssize_t       intail;
    u_int32_t     ochr;
    const u_char *ichr;
    int           blen;
    struct {
        int   max;
        int   cur;
        char  in[];
    }            *parm;

#   define blin_internal_flags (chain->flags)
    ifBLIN_QX3("+ %08X %"BLIN_X" %"BLIN_X, chain->flags, BLIN_I(chain), BLIN_I(chain->converdata));
    intail = recobe_chunksize(chain->tail);
    if  (intail < 1) {
        ex = -EX_DATAERR;
        errno = EINVAL;
        goto out;
    }
    if  (!(chain->flags & RECOBE_USED))  {
        chain->flags |= RECOBE_USED;
        parm = calloc(1, sizeof(*parm) + 1 + (!chain->converdata ? 0 : strlen(chain->converdata)));
        if  (!parm) {
            ifBLIN_QW0("No mem %d", sizeof(*parm));
            ex = -EX_OSERR;
            goto out;
        }
        if  (!!chain->converdata) {
            strcpy(parm->in, chain->converdata);
            /* !!! last byte 0 because of calloc parm !!! */
            free(chain->converdata);
            chain->converdata = NULL;
        }
        chain->converdata = parm;
        chain->flags |= RECOBE_CNVDFREE;
        parm->cur = 0;
        parm->max = 0;
        if  (!!*(parm->in)) {
            parm->max = strtoul(parm->in, NULL, 0);
    }   }
    ichr = recobe_chunktext(chain->tail);
    switch(intail) {
    case 1:
        ochr = recobe_load(ichr, -1) << 16;
        chain->tail->position += 1;
        blen = 2;
        break;
    case 2:
        ochr = recobe_load(ichr, -2) << 8;
        chain->tail->position += 2;
        blen = 3;
        break;
    default:
        ochr = recobe_load(ichr, -3);
        chain->tail->position += 3;
        blen = 4;
    }
    parm = chain->converdata;
    for (int i = 0; i < 4; ++i) {
        if  (i < blen) {
            ex = recobe_outword(chain, chunk, b64e[(ochr >> (6 * (3 - i))) & 0x3F]);
        } else {
            ex = recobe_outword(chain, chunk, '=');
        }
        if  (!!parm->max && (parm->max <= ++parm->cur)) {
            ex = recobe_outword(chain, chunk, '\n');
            parm->cur = 0;
    }   }
out:
    if  (0 < ex) ex = blen;
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

enum states1
{ aa /* ..      */
, aq /* =       */
, ad /* =X      */
, an /* =nl     */
, as /* #       */
, ap /* #X      */
, ax
};

static const char statenames1[][3] = { "aa", "aq", "ad", "an", "as", "ap", "ax"};

static const char clasnames1[][3] =
{ "Ld", "Ld", "Ld", "Ld", "Ld", "Ld", "Ld", "Ld", "Ld", "Ld", "LS", "LS", "LS", "LS", "LS", "LS"
, "L?", "L?", "L?", "L?", "L?", "L?", "L?", "L?", "L?", "L?", "Ls", "Ls", "Ls", "Ls", "Ls", "Ls"
, "L=", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L.", "L."
, "L#", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,", "L,"
};

/*****************************************************************************************************/
/*   b16 -   automa1[][]                                                           */
/* 0 -  [0-9]                                                                                   */
/* 1 -  [a-fA-F]                                                                                */
/* 2 -                                                                               */
/* 3 -                                                                                    */
/* 4 -    ( )                                                         */
/* 5 -   ( )                                                                 */
/*   b16 -   ()                                                         */
static u_char b16[] =
{ 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x30, 0x30, 0x30 , 0x30, 0x30, 0x20, 0x20
, 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20
, 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20
, 0x00, 0x01, 0x02, 0x03 , 0x04, 0x05, 0x06, 0x07 , 0x08, 0x09, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20

, 0x20, 0x0A, 0x0B, 0x0C , 0x0D, 0x0E, 0x0F, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20
, 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20
, 0x20, 0x1A, 0x1B, 0x1C , 0x1D, 0x1E, 0x1F, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20
, 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20

, 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20
, 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20
, 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20
, 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20

, 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20
, 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20
, 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20
, 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20 , 0x20, 0x20, 0x20, 0x20
};

static const char pn1[][3] = 
{ "- ", "- ", "- ", "- ", "- ", "- ", "- ", "- "
, "- ", "- ", "- ", "- ", "D0", "D1", "D2", "D3"
, "Ds", "Dd", "- ", "- ", "- ", "- ", "- ", "Dx"
};

/*****************************************************************************************************/
#define D0 0x00080000 /*  1                                                               */
#define D1 0x00040000 /*  2                                                               */
#define D2 0x00020000 /*  1                                                               */
#define D3 0x00010000 /*  2                                                               */
#define Ds 0x00008000 /*                                                    */
#define Dd 0x00004000 /*                                                           */
#define Dx 0x00000100 /* error                                                                       */

static u_int32_t automa1[ax][6] =
/*                         */
/*       0         1            2            3            q         nl  */
{{    Dd|ax,    Dd|ax,    Dd|   ax,    Dd|   ax,          aq,       ax}/* aa */
,{    D0|ad,    D2|ad,       Dx|ax,          ax,    Dd|   ax,    Dx|ax}/* aq */
,{ Ds|D1|ax, Ds|D3|ax, Ds|Dd|Dx|ax, Ds|Dd|Dx|ax, Ds|Dd|Dx|ax, Ds|Dx|ax}/* ad */
,{    Dd|ax,    Dd|ax,    Dd|   ax,          ax,          aq,       ax}/* an */
,{    D0|ap,    D2|ap,          ax,          ax,          ax,       ax}/* as */
,{ Ds|D1|ax, Ds|D3|ax,    Ds|   ax,    Ds|   ax,    Ds|   ax, Ds|   ax}/* ap */
};

static int
/*****************************************************************************************************
                                                                                                  ****/
QT(recobe_chain *chain, recobe_chunk *chunk) {                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
    u_int32_t     control;
    int           state;
    int           ex = 0;
    ssize_t       intail;
    u_int32_t     ochr;
    const u_char *ichr;
    struct {
        u_char  Q;
        char    in[];
    }            *parm;

#   define blin_internal_flags (chain->flags)
    ifBLIN_QX3("+ %08X %"BLIN_X" %"BLIN_X, chain->flags, BLIN_I(chain), BLIN_I(chain->converdata));
    intail = recobe_chunksize(chain->tail);
    if  (intail < 1) {
        ex = -1;
        goto out;
    }
    if  (!(chain->flags & RECOBE_USED))  {
        chain->flags |= RECOBE_USED;
        parm = calloc(1, sizeof(*parm) + 1 + (!chain->converdata ? 0 : strlen(chain->converdata)));
        if  (!parm) {
            ifBLIN_QW0("No mem %d", sizeof(*parm));
            ex = -1;
            goto out;
        }
        if  (!!chain->converdata) {
            strcpy(parm->in, chain->converdata);
            /* !!! last byte 0 because of calloc parm !!! */
            free(chain->converdata);
            chain->converdata = NULL;
        }
        chain->converdata = parm;
        chain->flags |= RECOBE_CNVDFREE;
        parm->Q = *(parm->in);
    }
    parm = chain->converdata;
    ichr = recobe_chunktext(chain->tail);
    blin_stateheader(BLIN_2STA24G, pn1);
    for ( ochr = 0, state = !!parm->Q ? aa : as
        ; state < ax
        ; ++ichr, --intail, chain->tail->position++
        ) {
        control = automa1[state]
                         [(!!parm->Q && (*ichr == parm->Q)) ? 4 : (0 < intail) ? (b16[*ichr] >> 4) : 5]
        ;
        blin_statebody( BLIN_2STA24G
                      , pn1
                      , statenames1
                      , clasnames1[b16[*ichr] & 0x3F]
                      , (char*)ichr
                      , intail
                      , control
                      , state
                      , ochr
                      , b16[*ichr]
                      );
        if  (control & (D0 | D2)) ochr = (b16[*ichr] & 0x0F) << 4;
        if  (control & (D1 | D3)) ochr |= b16[*ichr] & 0x0F;
        if  ((control & Ds) && (0 > (ex = recobe_outword(chain, chunk, ochr)))) {
            ifBLIN_QW1("Ds");
            goto out;
        }
        if  (  (control & Dd)
            && !(RECOBE_CLEAR & chain->flags)
            && (0 > (ex = recobe_outword(chain, chunk, *ichr)))
            ) {
            ifBLIN_QW1("Dd");
            goto out;
        }
        if  (control & Dx) ifBLIN_QX1("HEX syntax");
        state = control & C_state;
        ex = 1;
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

#define Esym   0x00FF
#define Ei 0x00000100 /* copy as is   */
#define Eh 0x00000200 /* copy hex     */
#define Es 0x00000400 /* substitute   */
#define Er 0x00010000 /* ready        */
#define El 0x00020000 /* end of line  */
#define Et 0x00080000 /* test for EOL */

static u_int16_t q16[] =
{ 0x0200, 0x0200, 0x0200, 0x0200 , 0x0200, 0x0200, 0x0200, 0x0200
, 0x0200, 0x0200, 0x0200, 0x0200 , 0x0200, 0x0200, 0x0200, 0x0200
, 0x0200, 0x0200, 0x0200, 0x0200 , 0x0200, 0x0200, 0x0200, 0x0200
, 0x0200, 0x0200, 0x0200, 0x0200 , 0x0200, 0x0200, 0x0200, 0x0200
, 0x0100, 0x0100, 0x0100, 0x0100 , 0x0100, 0x0100, 0x0100, 0x0100
, 0x0100, 0x0100, 0x0100, 0x0100 , 0x0100, 0x0100, 0x0100, 0x0100
, 0x0100, 0x0100, 0x0100, 0x0100 , 0x0100, 0x0100, 0x0100, 0x0100
, 0x0100, 0x0100, 0x0100, 0x0100 , 0x0100, 0x0100, 0x0100, 0x0100

, 0x0100, 0x0100, 0x0100, 0x0100 , 0x0100, 0x0100, 0x0100, 0x0100
, 0x0100, 0x0100, 0x0100, 0x0100 , 0x0100, 0x0100, 0x0100, 0x0100
, 0x0100, 0x0100, 0x0100, 0x0100 , 0x0100, 0x0100, 0x0100, 0x0100
, 0x0100, 0x0100, 0x0100, 0x0100 , 0x0100, 0x0100, 0x0100, 0x0100
, 0x0100, 0x0100, 0x0100, 0x0100 , 0x0100, 0x0100, 0x0100, 0x0100
, 0x0100, 0x0100, 0x0100, 0x0100 , 0x0100, 0x0100, 0x0100, 0x0100
, 0x0100, 0x0100, 0x0100, 0x0100 , 0x0100, 0x0100, 0x0100, 0x0100
, 0x0100, 0x0100, 0x0100, 0x0100 , 0x0100, 0x0100, 0x0100, 0x0200

, 0x0200, 0x0200, 0x0200, 0x0200 , 0x0200, 0x0200, 0x0200, 0x0200
, 0x0200, 0x0200, 0x0200, 0x0200 , 0x0200, 0x0200, 0x0200, 0x0200
, 0x0200, 0x0200, 0x0200, 0x0200 , 0x0200, 0x0200, 0x0200, 0x0200
, 0x0200, 0x0200, 0x0200, 0x0200 , 0x0200, 0x0200, 0x0200, 0x0200
, 0x0200, 0x0200, 0x0200, 0x0200 , 0x0200, 0x0200, 0x0200, 0x0200
, 0x0200, 0x0200, 0x0200, 0x0200 , 0x0200, 0x0200, 0x0200, 0x0200
, 0x0200, 0x0200, 0x0200, 0x0200 , 0x0200, 0x0200, 0x0200, 0x0200
, 0x0200, 0x0200, 0x0200, 0x0200 , 0x0200, 0x0200, 0x0200, 0x0200

, 0x0200, 0x0200, 0x0200, 0x0200 , 0x0200, 0x0200, 0x0200, 0x0200
, 0x0200, 0x0200, 0x0200, 0x0200 , 0x0200, 0x0200, 0x0200, 0x0200
, 0x0200, 0x0200, 0x0200, 0x0200 , 0x0200, 0x0200, 0x0200, 0x0200
, 0x0200, 0x0200, 0x0200, 0x0200 , 0x0200, 0x0200, 0x0200, 0x0200
, 0x0200, 0x0200, 0x0200, 0x0200 , 0x0200, 0x0200, 0x0200, 0x0200
, 0x0200, 0x0200, 0x0200, 0x0200 , 0x0200, 0x0200, 0x0200, 0x0200
, 0x0200, 0x0200, 0x0200, 0x0200 , 0x0200, 0x0200, 0x0200, 0x0200
, 0x0200, 0x0200, 0x0200, 0x0200 , 0x0200, 0x0200, 0x0200, 0x0200
};

static u_char h16[] = "0123456789ABCDEF";

static int
/*****************************************************************************************************
                                                                                                  ****/
TQ(recobe_chain *chain, recobe_chunk *chunk) {                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
    u_int32_t     control;
    int           ex = 0;
    ssize_t       intail;
    u_int32_t     ochr;
    const u_char *ichr;
    struct {
        int         max;                         /*                          */
        int         cur;                         /*                             */
        int         bord;                        /*        */
        u_char      Q;                           /*   HEX                                */
        u_int16_t   tb[256];
        char        in[];                        /*                      */
    }            *parm;

#   define blin_internal_flags (chain->flags)
    ifBLIN_QX3("+ %08X %"BLIN_X" %"BLIN_X, chain->flags, BLIN_I(chain), BLIN_I(chain->converdata));
    intail = recobe_chunksize(chain->tail);
    if  (intail < chain->inwlen) {
        ex = -1;
        goto out;
    }
    if  (!(chain->flags & RECOBE_USED))  {
        chain->flags |= RECOBE_USED;
        parm = calloc(1, sizeof(*parm) + 1 + (!chain->converdata ? 0 : strlen(chain->converdata)));
        if  (!parm) {
            ifBLIN_QW0("No mem %d", sizeof(*parm));
            ex = -1;
            goto out;
        }
        if  (!!chain->converdata) {
            strcpy(parm->in, chain->converdata);
            /* !!! last byte 0 because of calloc parm !!! */
            free(chain->converdata);
            chain->converdata = NULL;
        }
        parm->Q = *(parm->in);
        chain->converdata = parm;
        chain->flags |= RECOBE_CNVDFREE;
        bcopy(q16, parm->tb, sizeof(parm->tb));
        parm->tb[parm->Q] = Eh;
        if  (!!*(parm->in)) {
            u_char *p = (u_char*)parm->in;
            u_char  q, r;

            if  (!(b16[*p] & 0x0F)) {
                for (q = *p; q == *(p++); ) {
                    r = *(p++);
                    parm->tb[r] = *(p++) | Es;
            }   }
            if  (!!*p) {
                parm->max = strtoul((char*)p, (char**)&p, 0);
            }
            if  (!!*(p++)) {
                parm->bord = strtoul((char*)p, (char**)&p, 0);
    }   }   }
    parm = chain->converdata;
    ichr = recobe_chunktext(chain->tail);
    ochr = *(ichr++);
    --intail;
    chain->tail->position++;
    control = (RECOBE_CLEAR & chain->flags) ? Eh : parm->tb[ochr];
    ex = Er | control;
    if  (control & Ei) {
        if  (' ' == ochr) control |= Et;
        if  (0 > (ex = recobe_outword(chain, chunk, ochr))) {
            ifBLIN_QW1("Sp");
            goto out;
        }
        parm->cur++;
    }
    if  (control & Eh) {
        if  (!!parm->Q &&(0 > (ex = recobe_outword(chain, chunk, parm->Q)))) {
            ifBLIN_QW0("Q");
            goto out;
        }
        if  (0 > (ex = recobe_outword(chain, chunk, h16[ochr >> 4]))) {
            ifBLIN_QW0("h16 hi");
            goto out;
        }
        if  (0 > (ex = recobe_outword(chain, chunk, h16[ochr & 0x0F]))) {
            ifBLIN_QW0("h16 lo");
            goto out;
        }
        parm->cur += 3;
    }
    if  (control & Es) {
        if  (' ' == (control & Esym)) control |= Et;
        if  (0 > (ex = recobe_outword(chain, chunk, control & Esym))) {
            ifBLIN_QW0("Esym");
            goto out;
        }
        parm->cur++;
    }
    if  (!!parm->max && (parm->max <= parm->cur)) {
        control |= El;
    } else if ((control & Et) && !!parm->bord && (parm->bord <= parm->cur)) {
        u_char c;

        for (int i = parm->cur, j = 0; ; ++i) {
            c = chain->tail->chunk[chain->tail->position + i - parm->cur];
            if  (parm->tb[c] & Eh) j += 2;
            if  ((i + j) >= parm->max) {
                control |= El;
                break;
            }
            if  (' ' == c) break;
    }   }
    if  (control & El) {
        if  (!!parm->Q &&(0 > (ex = recobe_outword(chain, chunk, parm->Q)))) {
            ifBLIN_QW0("Esym");
            goto out;
        }
        if  (0 > (ex = recobe_outword(chain, chunk, '\n'))) {
            ifBLIN_QW0("Esym");
            goto out;
        }
        parm->cur = 0;
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
                                                                                                  ****/
nX(recobe_chain *chain, recobe_chunk *chunk) {                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
    u_int32_t     control;
    int           ex = 0;
    ssize_t       intail;
    u_int32_t     ochr;
    const u_char *ichr;
    struct {
        int         max;                         /*                          */
        int         cur;                         /*                             */
        int         bord;                        /*        */
        u_char      Q;                           /*   HEX                                */
        u_int16_t   tb[256];
        char        in[];                        /*                      */
    }            *parm;

#   define blin_internal_flags (chain->flags)
    ifBLIN_QX3("+ %08X %"BLIN_X" %"BLIN_X, chain->flags, BLIN_I(chain), BLIN_I(chain->converdata));
    intail = recobe_chunksize(chain->tail);
    if  (intail < chain->inwlen) {
        ex = -1;
        goto out;
    }
    if  (!(chain->flags & RECOBE_USED))  {
        chain->flags |= RECOBE_USED;
        parm = calloc(1, sizeof(*parm) + 1 + (!chain->converdata ? 0 : strlen(chain->converdata)));
        if  (!parm) {
            ifBLIN_QW0("No mem %d", sizeof(*parm));
            ex = -1;
            goto out;
        }
        if  (!!chain->converdata) {
            strcpy(parm->in, chain->converdata);
            /* !!! last byte 0 because of calloc parm !!! */
            free(chain->converdata);
            chain->converdata = NULL;
        }
        parm->Q = *(parm->in);
        chain->converdata = parm;
        chain->flags |= RECOBE_CNVDFREE;
        bcopy(q16, parm->tb, sizeof(parm->tb));
        parm->tb[parm->Q] = Eh;
        if  (!!*(parm->in)) {
            u_char *p = (u_char*)parm->in;
            u_char  q, r;

            if  (!(b16[*p] & 0x0F)) {
                for (q = *p; q == *(p++); ) {
                    r = *(p++);
                    parm->tb[r] = *(p++) | Es;
            }   }
            if  (!!*p) {
                parm->max = strtoul((char*)p, (char**)&p, 0);
            }
            if  (!!*(p++)) {
                parm->bord = strtoul((char*)p, (char**)&p, 0);
    }   }   }
    parm = chain->converdata;
    ichr = recobe_chunktext(chain->tail);
    ochr = *(ichr++);
    --intail;
    chain->tail->position++;
    control = (RECOBE_CLEAR & chain->flags) ? Eh : parm->tb[ochr];
    ex = Er | control;
    if  (control & Ei) {
        if  (' ' == ochr) control |= Et;
        if  (0 > (ex = recobe_outword(chain, chunk, ochr))) {
            ifBLIN_QW1("Sp");
            goto out;
        }
        parm->cur++;
    }
    if  (control & Eh) {
        if  (0 > (ex = recobe_outword(chain, chunk, parm->Q))) {
            ifBLIN_QW0("Q");
            goto out;
        }
        if  (0 > (ex = recobe_outword(chain, chunk, h16[ochr >> 4]))) {
            ifBLIN_QW0("h16 hi");
            goto out;
        }
        if  (0 > (ex = recobe_outword(chain, chunk, h16[ochr & 0x0F]))) {
            ifBLIN_QW0("h16 lo");
            goto out;
        }
        parm->cur += 3;
    }
    if  (control & Es) {
        if  (' ' == (control & Esym)) control |= Et;
        if  (0 > (ex = recobe_outword(chain, chunk, control & Esym))) {
            ifBLIN_QW0("Esym");
            goto out;
        }
        parm->cur++;
    }
    if  (!!parm->max && (parm->max <= parm->cur)) {
        control |= El;
    } else if ((control & Et) && !!parm->bord && (parm->bord <= parm->cur)) {
        u_char c;

        for (int i = parm->cur, j = 0; ; ++i) {
            c = chain->tail->chunk[chain->tail->position + i - parm->cur];
            if  (parm->tb[c] & Eh) j += 2;
            if  ((i + j) >= parm->max) {
                control |= El;
                break;
            }
            if  (' ' == c) break;
    }   }
    if  (control & El) {
        if  (0 > (ex = recobe_outword(chain, chunk, parm->Q))) {
            ifBLIN_QW0("Esym");
            goto out;
        }
        if  (0 > (ex = recobe_outword(chain, chunk, '\n'))) {
            ifBLIN_QW0("Esym");
            goto out;
        }
        parm->cur = 0;
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
                                                                                                  ****/
nH(recobe_chain *chain, recobe_chunk *chunk) {                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
    u_int64_t     wchr;
    u_int32_t     pos;
    int           ex;

#   define blin_internal_flags (chain->flags)
    ifBLIN_QX3("+ %08X %"BLIN_X, chain->flags, BLIN_I(chain));
    pos = chain->tail->position;
    if  (0 > (ex = recobe_inword(chain, chain->tail, &wchr))) {
        ifBLIN_QW1("inword");
        goto out;
    }
    if  ((wchr <= RECOBE_DECOHEX) || (wchr >= RECOBE_DECOMAX) || !htext[wchr]) {
        if  (0 > (ex = recobe_outword(chain, chunk, wchr))) {
            ex = 0;
            ifBLIN_QW2("outword");
            chain->tail->position = pos;
            goto out;
        }
    } else {
        if  (0 > (ex = recobe_outword(chain, chunk, '&'))) {
            ex = 0;
            ifBLIN_QW2("outword");
            chain->tail->position = pos;
            goto out;
        }
        for (int i = 0; !!htext[wchr][i]; ++i) {
            if  (0 > (ex = recobe_outword(chain, chunk, htext[wchr][i]))) {
                ex = 0;
                ifBLIN_QW2("outword");
                chain->tail->position = pos;
                goto out;
        }   }
        if  (0 > (ex = recobe_outword(chain, chunk, ';'))) {
            ex = 0;
            ifBLIN_QW2("outword");
            chain->tail->position = pos;
            goto out;
    }   }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
                                                                                                  ****/
nD(recobe_chain *chain, recobe_chunk *chunk) {                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
    char         *format;
    u_int64_t     wchr;
    char          buf[RECOBE_DECMAX];
    u_int32_t     pos;
    int           ex;
    char          f[15];

#   define blin_internal_flags (chain->flags)
    ifBLIN_QX3("+ %08X %"BLIN_X, chain->flags, BLIN_I(chain));
    pos = chain->tail->position;
    if  (0 > (ex = recobe_inword(chain, chain->tail, &wchr))) {
        ifBLIN_QW1("inword");
        goto out;
    }
    if  (*encolist[chain->cnv.encodst].encoid == 'D') {
        format = "&#%llu;";
    } else if (0 > snprintf(f, 15, "&#x%%ll0%uX;", chain->inwlen * 2)) {
        ifBLIN_QW2("snprintf");
        ex = -1;
        goto out;
    } else {
        format = f;
    }
    if  (0 > snprintf(buf, RECOBE_DECMAX, format, (unsigned long long)wchr)) {
        ifBLIN_QW2("snprintf");
        ex = -1;
        goto out;
    }
    if  (!!chain->converdata && (wchr <= (*(u_char*)chain->converdata & 0x0FF))) {
        if  (0 > (ex = recobe_outword(chain, chunk, wchr))) {
            ex = 0;
            chain->tail->position = pos;
            ifBLIN_QW2("outword");
            goto out;
        }
    } else {
        for (int i = 0; !!buf[i]; ++i) {
            if  (0 > (ex = recobe_outword(chain, chunk, buf[i]))) {
                ex = 0;
                chain->tail->position = pos;
                ifBLIN_QW2("outword");
                goto out;
    }   }   }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
                                                                                                  ****/
Qn(recobe_chain *chain, recobe_chunk *chunk) {                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
    u_int32_t   inlen;                    /*                                    */
    u_int32_t   blen;                     /*  -                        */
    u_int32_t   elen;                     /*  -                         */
    u_int64_t   wchr;                     /*                                   */
    int         ex = 0;                   /* 0<=    , 0>   */
    const char *b = chain->bcode;         /* -                                */
    const char *e = chain->ecode;         /* -                                 */
    char       *p;                        /*             */
    int         i;                        /*                            */

#   define blin_internal_flags (chain->flags)
    ifBLIN_QX3("+ %08X %"BLIN_X, chain->flags, BLIN_I(chain));
    blen = !b ? 0 : strlen(b);
    elen = !e ? 0 : strlen(e);
    inlen = recobe_chunksize(chain->tail);
    p = (char *)&chain->tail->chunk[chain->tail->position];
    if  (!blen || (p == strnstr(p, b, inlen))) {
        ex += blen;
        p += blen;
        i = 2 * chain->outwlen;
        for (wchr = 0; 0 < i; ex++, ++p) {
            if  ((*p >= '0') && (*p <= '9')) {
                wchr <<= 4;
                wchr += *p - '0';
            } else if ((*p >= 'A') && (*p <= 'F')) {
                wchr <<= 4;
                wchr += *p - 'A' + 10;
            } else if ((*p >= 'a') && (*p <= 'f')) {
                wchr <<= 4;
                wchr += *p - 'a' + 10;
            } else {
                break;
            }
            if  (!!wchr || (RECOBE_LSTRICT & chain->flags)) --i;
        }
        inlen = recobe_chunksize(chain->tail);
        if  (!e || (p == strnstr(p, e, inlen))) {
            ex += elen;
            chain->tail->position += ex;
            if  (0 > recobe_outword(chain, chunk, wchr)) {
                ex = -EX_SOFTWARE;
                ifBLIN_QW2("outword");
            }
        } else if (0 > recobe_outword(chain, chunk, chain->tail->chunk[chain->tail->position])) {
            chain->tail->position += 1;
            ex = -EX_SOFTWARE;
            ifBLIN_QW2("outword");
        } else {
            chain->tail->position += 1;
            ex = 1;
        }
    } else if (!!chain->converdata && !!strchr(chain->converdata, *p & 0x0FF)) {
        /*    -m */
        chain->tail->position++;
        ex = 1;
    } else if (0 > recobe_outword(chain, chunk, *p & 0x0FF)) {
        chain->tail->position++;
        ex = -EX_SOFTWARE;
        ifBLIN_QW2("outword");
    } else {
        chain->tail->position++;
        ex = 1;
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

#define NO     NULL
#define d0     6
#define d1     8
#define d2     11
#define d3     13
#define d4     16
#define d5     18
#define d6     20
#define d7     23
#define H      RECOBE_DECOLEN
#define X      20

static const recobe_chunker
/*****************************************************************************************************
                                                                                                  ****/
intercode[CODE_L][CODE_L] =                                                                      /****
                                                                                                  ****
 *****************************************************************************************************/
/*       0   1   2   3   4   5   6   7   B   Q   X   D   H    out */
{ { NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO} /* in  */
, { NO, NO, NO, NO, NO, NO, NO, NO, NO, TB, TQ, nX, nD, nH} /* 0 n */
, { NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, nD, nD, nH} /* 1 n */
, { NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, nD, nD, nH} /* 2 n */
, { NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, nD, nD, nH} /* 3 n */
, { NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, nD, nD, nH} /* 4 n */
, { NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, nD, nD, nH} /* 5 n */
, { NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, nD, nD, nH} /* 6 n */
, { NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, nD, nD, nH} /* 7 n */
, { NO, BT, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO} /* B 0 */
, { NO, QT, Qn, Qn, Qn, Qn, Qn, Qn, Qn, NO, NO, NO, NO, NO} /* Q 0 */
, { NO, Hn, Hn, Hn, Hn, Hn, Hn, Hn, Hn, NO, NO, NO, NO, NO} /* X n */
, { NO, Hn, Hn, Hn, Hn, Hn, Hn, Hn, Hn, NO, NO, NO, NO, NO} /* D n */
, { NO, Hn, Hn, Hn, Hn, Hn, Hn, Hn, Hn, NO, NO, NO, NO, NO} /* H n */
};

static const u_int16_t
/*****************************************************************************************************
 ****  Input word length                                                                          ****
 *****************************************************************************************************
                                                                                                  ****/
interinwlen[CODE_L][CODE_L] =                                                                    /****
                                                                                                  ****
 *****************************************************************************************************/
/*       0   1   2   3   4   5   6   7   B   Q   X   D   H    out */
{ {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0} /* in  */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,  1} /* 0 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  2,  2} /* 1 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  3,  3} /* 2 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  4,  4} /* 3 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  5,  5,  5} /* 4 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  6,  6,  6} /* 5 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  7,  7,  7} /* 6 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  8,  8,  8} /* 7 n */
, {  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0} /* B 0 */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0} /* Q 0 */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0} /* X n */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0} /* D n */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0} /* H n */
};

static const u_int16_t
/*****************************************************************************************************
 ****  Output word length                                                                         ****
 *****************************************************************************************************
                                                                                                  ****/
interoutwlen[CODE_L][CODE_L] =                                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
/*       0   1   2   3   4   5   6   7   B   Q   X   D   H    out */
{ {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0} /* in  */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,  1} /* 0 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  2} /* 1 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  3} /* 2 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  4} /* 3 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  5} /* 4 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  6} /* 5 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  7} /* 6 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  8} /* 7 n */
, {  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0} /* B 0 */
, {  0,  1,  2,  3,  4,  5,  6,  7,  8,  0,  0,  0,  0,  0} /* Q 0 */
, {  0,  1,  2,  3,  4,  5,  6,  7,  8,  0,  0,  0,  0,  0} /* X n */
, {  0,  1,  2,  3,  4,  5,  6,  7,  8,  0,  0,  0,  0,  0} /* D n */
, {  0,  1,  2,  3,  4,  5,  6,  7,  8,  0,  0,  0,  0,  0} /* H n */
};

static const u_int16_t
/*****************************************************************************************************
 ****  Input min word count                                                                       ****
 *****************************************************************************************************
                                                                                                  ****/
interinwnum[CODE_L][CODE_L] =                                                                    /****
                                                                                                  ****
 *****************************************************************************************************/
/*       0   1   2   3   4   5   6   7   B   Q   X   D   H    out */
{ {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0} /* in  */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  1,  1,  1,  1} /* 0 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1} /* 1 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1} /* 2 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1} /* 3 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1} /* 4 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1} /* 5 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1} /* 6 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1} /* 7 n */
, {  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0} /* B 0 */
, {  0,  2,  4,  6,  8, 10, 12, 14, 16,  0,  0,  0,  0,  0} /* Q 0 */
, {  0,  X,  X,  X,  X,  X,  X,  X,  X,  0,  0,  0,  0,  0} /* X n */
, {  0, d0, d1, d2, d3, d4, d5, d6, d7,  0,  0,  0,  0,  0} /* D n */
, {  0,  H,  H,  H,  H,  H,  H,  H,  H,  0,  0,  0,  0,  0} /* H n */
};

static const u_int16_t
/*****************************************************************************************************
 ****  Output min word count                                                                      ****
 *****************************************************************************************************
                                                                                                  ****/
interoutwnum[CODE_L][CODE_L] =                                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
/*       0   1   2   3   4   5   6   7   B   Q   X   D   H    out */
{ {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0} /* in  */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  2,  2, d0,  H} /* 0 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  X, d1,  H} /* 1 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  X, d2,  H} /* 2 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  X, d3,  H} /* 3 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  X, d4,  H} /* 4 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  X, d5,  H} /* 5 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  X, d6,  H} /* 6 n */
, {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  X, d7,  H} /* 7 n */
, {  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0} /* B 0 */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0} /* Q 0 */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0} /* X n */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0} /* D n */
, {  0,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0} /* H n */
};

static int
/*****************************************************************************************************
 ****  Output min word count                                                                      ****
 *****************************************************************************************************
                                                                                                  ****/
param(recobe_chain *chain) {                                                                     /****
                                                                                                  ****
 *****************************************************************************************************/
    BLIN_flag     fl;

    chain->convertor = intercode[chain->cnv.encosrc][chain->cnv.encodst];
    chain->inwlen = interinwlen[chain->cnv.encosrc][chain->cnv.encodst];
    chain->outwlen = interoutwlen[chain->cnv.encosrc][chain->cnv.encodst];
    chain->inwnum = interinwnum[chain->cnv.encosrc][chain->cnv.encodst];
    chain->outwnum = interoutwnum[chain->cnv.encosrc][chain->cnv.encodst];
    if  ((chain->convertor == TQ) && !!chain->converdata) chain->outwnum++;
    if  ((chain->convertor == nX) && !!chain->converdata) chain->outwnum++;
    if  ((chain->convertor == QT) && !!chain->converdata) chain->inwnum++;
    if  (chain->convertor == Qn) {
        chain->inwnum += (!chain->bcode ? 0 : strlen(chain->bcode))
                       + (!chain->ecode ? 0 : strlen(chain->ecode))
        ;
    }
    if  (chain->convertor == Hn) {
        switch(chain->cnv.encosrc) {
        case CODEX: fl = RECOBE_XCONV; break;
        case CODED: fl = RECOBE_DCONV; break;
        case CODEH: fl = RECOBE_HCONV; break;
        }
        if  (!!chain->next) {
            if  (  !(chain->flags & RECOBE_USED)
                && (RECOBE_CODE == chain->next->cnv.domain)
                && (!chain->next->cnv.nonesrc)
                && (!chain->next->cnv.nonedst)
                && (  (CODEX == chain->next->cnv.encosrc)
                   || (CODED == chain->next->cnv.encosrc)
                   || (CODEH == chain->next->cnv.encosrc)
                   )
                && (chain->cnv.encodst == chain->next->cnv.encodst)
                && (chain->outwlen == chain->next->outwlen)
                ) {
                recobe_chain *t = chain->next->next;

                fl |= (BLIN_flag)chain->next->converdata;
                chain->inwlen = chain->next->inwlen;
                free(chain->next);
                chain->next = t;
                ifBLIN_QX4("%08X %"BLIN_X, fl, t);
            } else {
                chain->inwlen = chain->next->outwlen;
        }   }
        chain->converdata = (void *)(u_int64_t)fl;
    }
    return(0);
}

const recobe_c_tdm
/*****************************************************************************************************
 *****************************************************************************************************
 ****   CODE                                                                       ****
 *****************************************************************************************************
                                                                                                  ****/
recobe_code_dm =                                                                                 /****
                                                                                                  ****
 *****************************************************************************************************
 *****************************************************************************************************/
{CODE_L, 2, "CODE", encolist, codnumbyid, convbyname, {.param = param}};
