/*-
 * Copyright (C)2014..2021 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2014..2021 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: G711.c,v 1.27 2021/12/05 17:53:10 babolo Exp $"

#define MIFE_COMPAT     5
#define RECOBE_COMPAT   VMAJOR
#define BLIN_COMPAT     4

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <strings.h>
#include <stdlib.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <mife.h>
#include "recobe.h"

#define G711_L   3
#define testL    8

const int16_t
/*****************************************************************************************************
 *****************************************************************************************************/
recobe_deG711A[256] =                                                                            /****
 *****************************************************************************************************
 *****************************************************************************************************/
{  -5504, -5248, -6016, -5760,   -4480, -4224, -4992, -4736
,  -7552, -7296, -8064, -7808,   -6528, -6272, -7040, -6784
,  -2752, -2624, -3008, -2880,   -2240, -2112, -2496, -2368
,  -3776, -3648, -4032, -3904,   -3264, -3136, -3520, -3392

, -22016,-20992,-24064,-23040,  -17920,-16896,-19968,-18944
, -30208,-29184,-32256,-31232,  -26112,-25088,-28160,-27136
, -11008,-10496,-12032,-11520,   -8960, -8448, -9984, -9472
, -15104,-14592,-16128,-15616,  -13056,-12544,-14080,-13568

,   -344,  -328,  -376,  -360,    -280,  -264,  -312,  -296
,   -472,  -456,  -504,  -488,    -408,  -392,  -440,  -424
,    -88,   -72,  -120,  -104,     -24,    -8,   -56,   -40
,   -216,  -200,  -248,  -232,    -152,  -136,  -184,  -168

,  -1376, -1312, -1504, -1440,   -1120, -1056, -1248, -1184
,  -1888, -1824, -2016, -1952,   -1632, -1568, -1760, -1696
,   -688,  -656,  -752,  -720,    -560,  -528,  -624,  -592
,   -944,  -912, -1008,  -976,    -816,  -784,  -880,  -848

,   5504,  5248,  6016,  5760,    4480,  4224,  4992,  4736
,   7552,  7296,  8064,  7808,    6528,  6272,  7040,  6784
,   2752,  2624,  3008,  2880,    2240,  2112,  2496,  2368
,   3776,  3648,  4032,  3904,    3264,  3136,  3520,  3392

,  22016, 20992, 24064, 23040,   17920, 16896, 19968, 18944
,  30208, 29184, 32256, 31232,   26112, 25088, 28160, 27136
,  11008, 10496, 12032, 11520,    8960,  8448,  9984,  9472
,  15104, 14592, 16128, 15616,   13056, 12544, 14080, 13568

,    344,   328,   376,   360,     280,   264,   312,   296
,    472,   456,   504,   488,     408,   392,   440,   424
,     88,    72,   120,   104,      24,     8,    56,    40
,    216,   200,   248,   232,     152,   136,   184,   168

,   1376,  1312,  1504,  1440,    1120,  1056,  1248,  1184
,   1888,  1824,  2016,  1952,    1632,  1568,  1760,  1696
,    688,   656,   752,   720,     560,   528,   624,   592
,    944,   912,  1008,   976,     816,   784,   880,   848
};

const int16_t
/*****************************************************************************************************
 *****************************************************************************************************/
recobe_deG711u[256] =                                                                            /****
 *****************************************************************************************************
 *****************************************************************************************************/
{ -32124,-31100,-30076,-29052,  -28028,-27004,-25980,-24956
, -23932,-22908,-21884,-20860,  -19836,-18812,-17788,-16764
, -15996,-15484,-14972,-14460,  -13948,-13436,-12924,-12412
, -11900,-11388,-10876,-10364,   -9852, -9340, -8828, -8316

,  -7932, -7676, -7420, -7164,   -6908, -6652, -6396, -6140
,  -5884, -5628, -5372, -5116,   -4860, -4604, -4348, -4092
,  -3900, -3772, -3644, -3516,   -3388, -3260, -3132, -3004
,  -2876, -2748, -2620, -2492,   -2364, -2236, -2108, -1980

,  -1884, -1820, -1756, -1692,   -1628, -1564, -1500, -1436
,  -1372, -1308, -1244, -1180,   -1116, -1052,  -988,  -924
,   -876,  -844,  -812,  -780,    -748,  -716,  -684,  -652
,   -620,  -588,  -556,  -524,    -492,  -460,  -428,  -396

,   -372,  -356,  -340,  -324,    -308,  -292,  -276,  -260
,   -244,  -228,  -212,  -196,    -180,  -164,  -148,  -132
,   -120,  -112,  -104,   -96,     -88,   -80,   -72,   -64
,    -56,   -48,   -40,   -32,     -24,   -16,    -8,     0

,  32124, 31100, 30076, 29052,   28028, 27004, 25980, 24956
,  23932, 22908, 21884, 20860,   19836, 18812, 17788, 16764
,  15996, 15484, 14972, 14460,   13948, 13436, 12924, 12412
,  11900, 11388, 10876, 10364,    9852,  9340,  8828,  8316

,   7932,  7676,  7420,  7164,    6908,  6652,  6396,  6140
,   5884,  5628,  5372,  5116,    4860,  4604,  4348,  4092
,   3900,  3772,  3644,  3516,    3388,  3260,  3132,  3004
,   2876,  2748,  2620,  2492,    2364,  2236,  2108,  1980

,   1884,  1820,  1756,  1692,    1628,  1564,  1500,  1436
,   1372,  1308,  1244,  1180,    1116,  1052,   988,   924
,    876,   844,   812,   780,     748,   716,   684,   652
,    620,   588,   556,   524,     492,   460,   428,   396

,    372,   356,   340,   324,     308,   292,   276,   260
,    244,   228,   212,   196,     180,   164,   148,   132
,    120,   112,   104,    96,      88,    80,    72,    64
,     56,    48,    40,    32,      24,    16,     8,     0
};

static const u_char
/*****************************************************************************************************/
Au[256] =                                                                                        /****
 *****************************************************************************************************/
{  0x2A, 0x2B, 0x28, 0x29,  0x2E, 0x2F, 0x2C, 0x2D,  0x22, 0x23, 0x20, 0x21,  0x26, 0x27, 0x24, 0x25
,  0x39, 0x3A, 0x37, 0x38,  0x3D, 0x3E, 0x3B, 0x3C,  0x31, 0x32, 0x30, 0x30,  0x35, 0x36, 0x33, 0x34
,  0x0A, 0x0B, 0x08, 0x09,  0x0E, 0x0F, 0x0C, 0x0D,  0x02, 0x03, 0x00, 0x01,  0x06, 0x07, 0x04, 0x05
,  0x1A, 0x1B, 0x18, 0x19,  0x1E, 0x1F, 0x1C, 0x1D,  0x12, 0x13, 0x10, 0x11,  0x16, 0x17, 0x14, 0x15

,  0x62, 0x63, 0x60, 0x61,  0x66, 0x67, 0x64, 0x65,  0x5D, 0x5D, 0x5C, 0x5C,  0x5F, 0x5F, 0x5E, 0x5E
,  0x74, 0x76, 0x70, 0x72,  0x7C, 0x7E, 0x78, 0x7A,  0x6A, 0x6B, 0x68, 0x69,  0x6E, 0x6F, 0x6C, 0x6D
,  0x48, 0x49, 0x46, 0x47,  0x4C, 0x4D, 0x4A, 0x4B,  0x40, 0x41, 0x3F, 0x3F,  0x44, 0x45, 0x42, 0x43
,  0x56, 0x57, 0x54, 0x55,  0x5A, 0x5B, 0x58, 0x59,  0x4F, 0x4F, 0x4E, 0x4E,  0x52, 0x53, 0x50, 0x51

,  0xAA, 0xAB, 0xA8, 0xA9,  0xAE, 0xAF, 0xAC, 0xAD,  0xA2, 0xA3, 0xA0, 0xA1,  0xA6, 0xA7, 0xA4, 0xA5
,  0xB9, 0xBA, 0xB7, 0xB8,  0xBD, 0xBE, 0xBB, 0xBC,  0xB1, 0xB2, 0xB0, 0xB0,  0xB5, 0xB6, 0xB3, 0xB4
,  0x8A, 0x8B, 0x88, 0x89,  0x8E, 0x8F, 0x8C, 0x8D,  0x82, 0x83, 0x80, 0x81,  0x86, 0x87, 0x84, 0x85
,  0x9A, 0x9B, 0x98, 0x99,  0x9E, 0x9F, 0x9C, 0x9D,  0x92, 0x93, 0x90, 0x91,  0x96, 0x97, 0x94, 0x95

,  0xE2, 0xE3, 0xE0, 0xE1,  0xE6, 0xE7, 0xE4, 0xE5,  0xDD, 0xDD, 0xDC, 0xDC,  0xDF, 0xDF, 0xDE, 0xDE
,  0xF4, 0xF6, 0xF0, 0xF2,  0xFC, 0xFE, 0xF8, 0xFA,  0xEA, 0xEB, 0xE8, 0xE9,  0xEE, 0xEF, 0xEC, 0xED
,  0xC8, 0xC9, 0xC6, 0xC7,  0xCC, 0xCD, 0xCA, 0xCB,  0xC0, 0xC1, 0xBF, 0xBF,  0xC4, 0xC5, 0xC2, 0xC3
,  0xD6, 0xD7, 0xD4, 0xD5,  0xDA, 0xDB, 0xD8, 0xD9,  0xCF, 0xCF, 0xCE, 0xCE,  0xD2, 0xD3, 0xD0, 0xD1
};

static const u_char
/*****************************************************************************************************/
uA[256] =                                                                                        /****
 *****************************************************************************************************/
{  0x2A, 0x2B, 0x28, 0x29,  0x2E, 0x2F, 0x2C, 0x2D,  0x22, 0x23, 0x20, 0x21,  0x26, 0x27, 0x24, 0x25
,  0x3A, 0x3B, 0x38, 0x39,  0x3E, 0x3F, 0x3C, 0x3D,  0x32, 0x33, 0x30, 0x31,  0x36, 0x37, 0x34, 0x35
,  0x0A, 0x0B, 0x08, 0x09,  0x0E, 0x0F, 0x0C, 0x0D,  0x02, 0x03, 0x00, 0x01,  0x06, 0x07, 0x04, 0x05
,  0x1B, 0x18, 0x19, 0x1E,  0x1F, 0x1C, 0x1D, 0x12,  0x13, 0x10, 0x11, 0x16,  0x17, 0x14, 0x15, 0x6A

,  0x68, 0x69, 0x6E, 0x6F,  0x6C, 0x6D, 0x62, 0x63,  0x60, 0x61, 0x66, 0x67,  0x64, 0x65, 0x7A, 0x78
,  0x7E, 0x7F, 0x7C, 0x7D,  0x72, 0x73, 0x70, 0x71,  0x76, 0x77, 0x74, 0x75,  0x4B, 0x49, 0x4F, 0x4D
,  0x42, 0x43, 0x40, 0x41,  0x46, 0x47, 0x44, 0x45,  0x5A, 0x5B, 0x58, 0x59,  0x5E, 0x5F, 0x5C, 0x5D
,  0x52, 0x52, 0x53, 0x53,  0x50, 0x50, 0x51, 0x51,  0x56, 0x56, 0x57, 0x57,  0x54, 0x54, 0x55, 0x55

,  0xAA, 0xAB, 0xA8, 0xA9,  0xAE, 0xAF, 0xAC, 0xAD,  0xA2, 0xA3, 0xA0, 0xA1,  0xA6, 0xA7, 0xA4, 0xA5
,  0xBA, 0xBB, 0xB8, 0xB9,  0xBE, 0xBF, 0xBC, 0xBD,  0xB2, 0xB3, 0xB0, 0xB1,  0xB6, 0xB7, 0xB4, 0xB5
,  0x8A, 0x8B, 0x88, 0x89,  0x8E, 0x8F, 0x8C, 0x8D,  0x82, 0x83, 0x80, 0x81,  0x86, 0x87, 0x84, 0x85
,  0x9B, 0x98, 0x99, 0x9E,  0x9F, 0x9C, 0x9D, 0x92,  0x93, 0x90, 0x91, 0x96,  0x97, 0x94, 0x95, 0xEA

,  0xE8, 0xE9, 0xEE, 0xEF,  0xEC, 0xED, 0xE2, 0xE3,  0xE0, 0xE1, 0xE6, 0xE7,  0xE4, 0xE5, 0xFA, 0xF8
,  0xFE, 0xFF, 0xFC, 0xFD,  0xF2, 0xF3, 0xF0, 0xF1,  0xF6, 0xF7, 0xF4, 0xF5,  0xCB, 0xC9, 0xCF, 0xCD
,  0xC2, 0xC3, 0xC0, 0xC1,  0xC6, 0xC7, 0xC4, 0xC5,  0xDA, 0xDB, 0xD8, 0xD9,  0xDE, 0xDF, 0xDC, 0xDD
,  0xD2, 0xD2, 0xD3, 0xD3,  0xD0, 0xD0, 0xD1, 0xD1,  0xD6, 0xD6, 0xD7, 0xD7,  0xD4, 0xD4, 0xD5, 0xD5
};

static const u_char
/*****************************************************************************************************/
A_T[128] =                                                                                       /****
 *****************************************************************************************************/
{  0x04, 0x14, 0x25, 0x25,  0x36, 0x36, 0x36, 0x36,  0x47, 0x47, 0x47, 0x47,  0x47, 0x47, 0x47, 0x47
,  0x58, 0x58, 0x58, 0x58,  0x58, 0x58, 0x58, 0x58,  0x58, 0x58, 0x58, 0x58,  0x58, 0x58, 0x58, 0x58
,  0x69, 0x69, 0x69, 0x69,  0x69, 0x69, 0x69, 0x69,  0x69, 0x69, 0x69, 0x69,  0x69, 0x69, 0x69, 0x69
,  0x69, 0x69, 0x69, 0x69,  0x69, 0x69, 0x69, 0x69,  0x69, 0x69, 0x69, 0x69,  0x69, 0x69, 0x69, 0x69

,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A
,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A
,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A
,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A
};

static const u_char
/*****************************************************************************************************/
u_T[129] =                                                                                       /****
 *****************************************************************************************************/
{  0x03, 0x14, 0x25, 0x25,  0x36, 0x36, 0x36, 0x36,  0x47, 0x47, 0x47, 0x47,  0x47, 0x47, 0x47, 0x47
,  0x58, 0x58, 0x58, 0x58,  0x58, 0x58, 0x58, 0x58,  0x58, 0x58, 0x58, 0x58,  0x58, 0x58, 0x58, 0x58
,  0x69, 0x69, 0x69, 0x69,  0x69, 0x69, 0x69, 0x69,  0x69, 0x69, 0x69, 0x69,  0x69, 0x69, 0x69, 0x69
,  0x69, 0x69, 0x69, 0x69,  0x69, 0x69, 0x69, 0x69,  0x69, 0x69, 0x69, 0x69,  0x69, 0x69, 0x69, 0x69

,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A
,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A
,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A
,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A,  0x7A, 0x7A, 0x7A, 0x7A

,  0xFA
};

static const u_char
/*****************************************************************************************************/
Atest_T[testL] = {0x34, 0x21, 0x21, 0x34, 0xB4, 0xA1, 0xA1, 0xB4};                               /****
 *****************************************************************************************************/

static const u_char
/*****************************************************************************************************/
utest_T[testL] = {0x1E, 0x0B, 0x0B, 0x1E, 0x9E, 0x8B, 0x8B, 0x9E};                               /****
 *****************************************************************************************************/

u_char
/*****************************************************************************************************
 *****************************************************************************************************/
recobe_G711A(int16_t sample) {                                                                   /****
 *****************************************************************************************************
 *****************************************************************************************************/
    u_char exp, sign = (~sample >> 8) & 0x80;

    if  (!sign) sample = -sample;
    exp = A_T[(sample >> 8) & 0x7F];
    return((sign | (exp & 0x70) | ((sample >> (exp & 0x0F)) & 0x0F)) ^ 0x55);
}

u_char
/*****************************************************************************************************
 *****************************************************************************************************/
recobe_G711u(int16_t sample) {                                                                   /****
 *****************************************************************************************************
 *****************************************************************************************************/
    u_char exp, sign = (sample >> 8) & 0x80;
    int32_t v = sample;

    if  (sign) v = 3 - v;
    v += 132;
    exp = u_T[v >> 8];
    return(~(sign | (exp & 0x70) | ((v >> (exp & 0x0F)) & 0x0F) | ((exp & 0x80) ? 0x0F : 0)));
}

int
/*****************************************************************************************************
 *****************************************************************************************************/
recobe_G711Atest(int fi, u_char *buf, size_t l) {                                                /****
 *****************************************************************************************************
 *****************************************************************************************************/
    size_t i;

    fi = fi % testL;
    for (i = 0; i < l; ++i) {
        buf[i] = Atest_T[(fi + i) % testL];
    }
    return(testL);
}

int
/*****************************************************************************************************
 *****************************************************************************************************/
recobe_G711utest(int fi, u_char *buf, size_t l) {                                                /****
 *****************************************************************************************************
 *****************************************************************************************************/
    size_t i;

    fi = fi % testL;
    for (i = 0; i < l; ++i) {
        buf[i] = utest_T[(fi + i) % testL];
    }
    return(testL);
}

static const u_char *
/*****************************************************************************************************
                                                                                                  ****/
intercode[G711_L][G711_L] =                                                                      /****
                                                                                                  ****
 *****************************************************************************************************/
{ { 0,  0,  0}
, { 0,  0, Au}
, { 0, uA,  0}
};

/*****************************************************************************************************
 *****************************************************************************************************/
static const char *                                                                              /****/
code_A[] = {"G.711A", NULL};                                                                     /****/
                                                                                                 /****/
static const char *                                                                              /****/
code_u[] = {"G.711u", NULL};                                                                     /****/
/*****************************************************************************************************
 *****************************************************************************************************/

static const recobe_c_tnm
/*****************************************************************************************************
                                                                                                  ****/
encolist[G711_L] =                                                                               /****
                                                                                                  ****
 *****************************************************************************************************/
{ { NULL,    NULL, NULL}
, { "A" , &code_A, NULL}
, { "u" , &code_u, NULL}
};

static int
/*****************************************************************************************************
                                                                                                  ****/
codnumbyid(const char *nm) {                                                                     /****
                                                                                                  ****
 *****************************************************************************************************/
    int i, r = 0;

    for (i = 1; i < G711_L; ++i) {
        if  (nm[0] == encolist[i].encoid[0]) {
            r = i;
            break;
    }   }
    return(r);
}

static u_char *
/*****************************************************************************************************
                                                                                                  ****/
reconv(recobe_conv cnv) {                                                                        /****
                                                                                                  ****
 *****************************************************************************************************/
    u_char *s = NULL;

    if  (  (RECOBE_G711 == cnv.domain)
        && (G711_L > cnv.encosrc)
        && (G711_L > cnv.encodst)
        && (0 < cnv.encosrc)
        && (0 < cnv.encodst)
        && !!intercode[cnv.encosrc][cnv.encodst]
        && (s = malloc(256))
        ) {
        bcopy(intercode[cnv.encosrc][cnv.encodst], s, 256);
    }
    return(s);
}

static recobe_conv
/*****************************************************************************************************
                                                                                                  ****/
convbyname(const char *name) {                                                                   /****
                                                                                                  ****
 *****************************************************************************************************/
    recobe_conv cnv = {RECOBE_G711, 0, 0, 0, 0};

    if  (!name || !name[0]) {
        cnv.nonesrc = cnv.nonedst = 1;
    } else {
        cnv.encosrc = codnumbyid(name);
        if  (!name[1]) {
            cnv.nonedst = 1;
        } else if (!!name[2]) {
            cnv.encodst = 0;
        } else {
            cnv.encodst = codnumbyid(&name[1]);
    }   }
    return(cnv);
}

const recobe_c_tdm
/*****************************************************************************************************
 *****************************************************************************************************/
recobe_G711_dm =                                                                                 /****
 *****************************************************************************************************
 *****************************************************************************************************/
{G711_L, 1, "G711", encolist, codnumbyid, convbyname, {reconv}};
