#!/usr/bin/awk -f

BEGIN{
    print "/*-\
 * Copyright (C)2021 @BABOLO http://www.babolo.ru/\
 * All rights reserved.\
 *\
 * Redistribution and use in source and binary forms, with or without\
 * modification, are permitted provided that the following conditions\
 * are met:\
 * 1. Redistributions of source code must retain the above copyright\
 *    notice, this list of conditions and the following disclaimer.\
 * 2. Redistributions in binary form must reproduce the above copyright\
 *    notice, this list of conditions and the following disclaimer in the\
 *    documentation and/or other materials provided with the distribution.\
 *\
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND\
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE\
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE\
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL\
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS\
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)\
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT\
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY\
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF\
 * SUCH DAMAGE.\
 *\
 * $Id: htref.awk,v 1.1 2021/04/11 13:10:50 babolo Exp $\
 */"
    c = 0;
    dm = 0;
}

/^ / && (c == 3) && ($1 > dh){
    t = $1 + 0;
    if  (dm < t) dm = t;
    sub("^&", "", $2);
    sub(";$", "", $2);
    a[t] = $2;
}

/# +LEXOR +BEGIN/{
    c = 3;
}

(c == 1) || (c == 2){
    if  ((c == 1) || ($0 !~ /^ *$/)) print $0;
    if  ($1 == "#define") {
        c = 2;
        if  ($2 == "RECOBE_DECOHEX") dh = $3 + 0;
        if  ($2 == "RECOBE_DECOLEN") dl = $3 + 0;
}   }

/# +LEXOR +INCLUDE/{
    c = 1;
}

END{
    ++dm;
    print "#define RECOBE_DECOMAX   " dm;
    printf "\nconst char *htext[%d] =", dm;
    c = "{";
    for (i = 0; i < dm; ++i) {
        if  (i % 8 == 0) print "";
        if  (length(a[i]) > 0) {
            printf "%c \"%s\"%s", c, a[i], substr("         ", 1, dl - 2 - length(a[i]));
        } else {
            printf "%c       NULL", c;
        }
        c = ",";
    }
    if  (i % 8 != 0) print "";
    print "};"
}
