/*-
 * Copyright (C)2014..2021 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2014..2021 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: control.c,v 1.36 2021/12/05 17:53:09 babolo Exp $"

#define BLIN_COMPAT     4
#define MIFE_COMPAT     5
#define Bpars_COMPAT    4
#define MULAR_COMPAT    0
#define RECOBE_COMPAT   VMAJOR

#include <sys/types.h>
#include <sys/event.h>
#include <sys/stat.h>
#include <sysexits.h>
#include <strings.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "recobe.h"

#define SFANCYE 0x00800
#define SETALON 0x00400
#define SCANPRI 0x00200
#define SDOPRI  0x00100
#define SMASK   (SFANCYE | SETALON | SCANPRI | SDOPRI)
#define SISETA  0x00008
#define SISNIL  0x00004
#define SREAPRI 0x00002
#define SRAESC  0x00001
#define SSWITCH (((SFANCYE | SETALON | SCANPRI | SDOPRI) >> 4) | SISETA | SISNIL | SREAPRI | SRAESC)

static const u_char
toswitch[256] =
{  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
,  0, 0, 4, 3,  2, 2, 2, 2,  0, 0, 4, 3,  2, 2, 2, 2

,  1, 1, 1, 1,  1, 1, 1, 1,  0, 0, 0, 0,  0, 0, 0, 0
,  1, 1, 1, 1,  1, 1, 1, 1,  0, 0, 0, 0,  0, 0, 0, 0
,  1, 1, 1, 1,  1, 1, 1, 1,  0, 0, 0, 0,  0, 0, 0, 0
,  1, 1, 4, 3,  2, 2, 2, 2,  0, 0, 4, 3,  2, 2, 2, 2

,  5, 5, 5, 5,  2, 2, 2, 2,  5, 5, 5, 5,  2, 2, 2, 2
,  5, 5, 5, 5,  2, 2, 2, 2,  5, 5, 5, 5,  2, 2, 2, 2
,  5, 5, 5, 5,  2, 2, 2, 2,  5, 5, 5, 5,  2, 2, 2, 2
,  5, 5, 5, 5,  2, 2, 2, 2,  5, 5, 5, 5,  2, 2, 2, 2

,  5, 5, 5, 5,  2, 2, 2, 2,  5, 5, 5, 5,  2, 2, 2, 2
,  5, 5, 5, 5,  2, 2, 2, 2,  5, 5, 5, 5,  2, 2, 2, 2
,  5, 5, 5, 5,  2, 2, 2, 2,  5, 5, 5, 5,  2, 2, 2, 2
,  5, 5, 5, 5,  2, 2, 2, 2,  5, 5, 5, 5,  2, 2, 2, 2
};

void
/*****************************************************************************************************
 *****************************************************************************************************/
recobe_p256( const char  *from                                                                   /****/
           , const char  *to                                                                     /****/
           , u_int16_t    domain                                                                 /****/
           , const u_char array[256]                                                             /****/
           ) {                                                                                   /****
 *****************************************************************************************************
 *****************************************************************************************************/
    u_char re, ra = 0, *e = NULL;
    recobe_conv cnv = {0, 0, 0, 0, 0};
    int i, j = -1, k;
    u_int32_t state;

    printf("static const u_char %s%s[] =\n{  ", from, to);
    state = 0;
    i = recobe_collection.domains[domain]->codnumbyid(to);
    if  (blin_internal_flags & RECOBE_PRINTATLE) {
        state = SFANCYE;
    } else if (0 < i) {
        if  (!!recobe_collection.domains[domain]->encolist[i].printable) state |= SCANPRI;
        j = recobe_collection.domains[domain]->codnumbyid(from);
        cnv.encosrc = j;
        cnv.encodst = i;
        cnv.domain = RECOBE_ETAT;
        if  (  (0 < j)
            && (RECOBE_TEXT == domain)
            && (e = recobe_collection.domains[RECOBE_ETAT]->reconv(cnv))
            ) {
            state |= SETALON;
    }   }
    if  (blin_internal_flags & RECOBE_PRINTABLE) state |= SDOPRI;
    for (k = 0; k < 256; ++k) {
        state &= SMASK;
        state = state | (state >> 4);
        re = array[k];
        if  ((state & SETALON) && !!e && (!!e[k] || !k)) state |= SISETA;
        if  (!re) state |= SISNIL;
        if  (  (state & SCANPRI)
            && !!(ra = recobe_collection.domains[domain]->encolist[i].printable[re])
            ) {
            state |= SREAPRI;
            if  (('\\' == ra) || ('\'' == ra)) state |= SRAESC;
        }
        if  (k) {
            if  (!(k & 15)) printf("\n");
            if  (!(k & 63)) printf("\n");
            printf(", ");
            if  (!(k & 3)) printf(" ");
        }
        switch(toswitch[state & SSWITCH]) {
        case 0:
            printf("0X%02X", re);
            break;
        case 1:
            printf("0x%02x", re);
            break;
        case 2:
            printf("   0");
            break;
        case 3:
            printf("'\\%c'", ra);
            break;
        case 4:
            printf(" '%c'", re);
            break;
        case 5:
            printf("0x%02X", re);
            break;
    }   }
    printf("\n};\n");
}

static void
/*****************************************************************************************************/
recobe_w256( const char  *from                                                                   /****/
           , const char  *to                                                                     /****/
           , u_int16_t    domain                                                                 /****/
           , const u_char array[256]                                                             /****/
           ) {                                                                                   /****
 *****************************************************************************************************/
    (void)from;
    (void)to;
    (void)domain;
    write(fileno(stdout), array, 256);
}

static int
/*****************************************************************************************************/
revertest(int g, int i, int j, u_char *s, u_char *r) {                                           /****
 *****************************************************************************************************/
    int k, z = 0;

    for (k = 0; k < 256; ++k) {
        if  (  (r[s[k]] != k)
            && (  (blin_internal_flags & RECOBE_FULLCHECK)
               || !!s[k]
               || ((g != RECOBE_TEXT) && (g != RECOBE_ETAT))
            )  ) {
            printf( "%s%s[0x%02X]=0x%02X, %s%s[0x%02X]=0x%02X\n"
                  , recobe_collection.domains[g]->encolist[i].encoid
                  , recobe_collection.domains[g]->encolist[j].encoid
                  , k
                  , s[k]
                  , recobe_collection.domains[g]->encolist[j].encoid
                  , recobe_collection.domains[g]->encolist[i].encoid
                  , s[k]
                  , r[s[k]]
                  )
            ;
        }
        if  ((blin_internal_flags & RECOBE_REVERTIZE) && !!s[k] && !r[s[k]]) {
            r[s[k]] = k;
            ++z;
    }   }
    return(z);
}

static int
/*****************************************************************************************************/
intertest(int g, int i, int j, int q, u_char *s, u_char *f, u_char *t) {                         /****
 *****************************************************************************************************/
    int k, n, z = 0;

    for (k = 0; k < 256; ++k) {
        if  (  (s[k] != t[f[k]])
            && (  (blin_internal_flags & RECOBE_FULLCHECK)
               || !!f[k]
            )  ) {
            printf( "%s 0x%02X: %s%s=0x%02X <> %s%s%s=(0x%02X)0x%02X"
                  , recobe_collection.domains[g]->domname
                  , k
                  , recobe_collection.domains[g]->encolist[i].encoid
                  , recobe_collection.domains[g]->encolist[j].encoid
                  , s[k]
                  , recobe_collection.domains[g]->encolist[i].encoid
                  , recobe_collection.domains[g]->encolist[q].encoid
                  , recobe_collection.domains[g]->encolist[j].encoid
                  , f[k]
                  , t[f[k]]
                  )
            ;
            for (n = 0; n < 256; ++n) {
                if  (f[n] == s[k]) {
                    printf( " %s%s[0x%02X]=0x%02X"
                          , recobe_collection.domains[g]->encolist[q].encoid
                          , recobe_collection.domains[g]->encolist[j].encoid
                          , n
                          , f[n]
                          )
                    ;
                    break;
            }   }
            printf("\n");
        }
        if  ((blin_internal_flags & RECOBE_INTERTIZE) && (s[k] != t[f[k]]) && !t[f[k]]) {
            if  (!!f[k]) {
                t[f[k]] = s[k];
                ++z;
            } else {
                for (n = 0; n < 256; ++n) {
                    if  (f[n] == s[k]) {
                        f[k] = n;
                        ++z;
    }   }   }   }   }
    return(z);
}

int
/*****************************************************************************************************
 *****************************************************************************************************/
recobe_TestOrRevert(const char *p) {                                                             /****
 *****************************************************************************************************
 *****************************************************************************************************/
    recobe_conv cnv = {0, 0, 0, 0, 0};
    int g, i, j, k, domain, src, dst;
    u_char *s, *r;
    const char *sp, *dp;

    domain = (!*p) ? 0 : (*p - '0');
    p++;
    sp = (!*p) ? NULL : p;
    src = (!domain || !sp) ? 0 : recobe_collection.domains[domain]->codnumbyid(sp);
    p++;
    dp = (!*p) ? NULL : p;
    dst = (!domain || !dp) ? 0 : recobe_collection.domains[domain]->codnumbyid(dp);
    if  (recobe_collection.domcount <= domain) domain = 0;
    for (g = (!domain ? 1 : domain); g < (!domain ? recobe_collection.domcount : domain + 1); ++g) {
        for ( i = (!src ? 1 : src)
            ; i < (!src ? recobe_collection.domains[g]->recountad : src + 1)
            ; ++i
            ) {
            for ( j = (!dst ? 1 : dst)
                ; j < (!dst ? recobe_collection.domains[g]->recountad : dst + 1)
                ; ++j
                ) {
                cnv.encosrc = i;
                cnv.encodst = j;
                cnv.domain = g;
                if  (!!(s = recobe_collection.domains[g]->reconv(cnv))) {
                    cnv.encosrc = j;
                    cnv.encodst = i;
                    if  (!!(r = recobe_collection.domains[g]->reconv(cnv))) {
                        revertest(g, i, j, s, r);
                        free(r);
                        r = NULL;
                    } else {
                        u_char o[256];

                        bzero(o, 256);
                        for (k = 0; k < 256; ++k) o[s[k]] = k;
                        recobe_p256( recobe_collection.domains[g]->encolist[j].encoid
                                   , recobe_collection.domains[g]->encolist[i].encoid
                                   , g
                                   , o
                                   )
                        ;
                    }
                    free(s);
                    s = NULL;
    }   }   }   }
    exit(EX_OK);
}

static int
/*****************************************************************************************************/
makeup( const char *p                                                                            /****/
      , void      (*toto)( const char  *from                                                     /****/
                         , const char  *to                                                       /****/
                         , u_int16_t    domain                                                   /****/
                         , const u_char array[256]                                               /****/
      )                  ) {                                                                     /****
 *****************************************************************************************************/
    recobe_conv cnv = {0, 0, 0, 0, 0};
    u_char *t, *f, o[256];
    int k, i, j, g, q, domain;

    domain = (!*p) ? 0 : (*p - '0');
    ++p;
    if  (recobe_collection.domcount <= domain) domain = 0;
    for (g = (!domain ? 1 : domain); g < (!domain ? recobe_collection.domcount : domain + 1); ++g) {
        for (i = 1; i < recobe_collection.domains[g]->recountad; ++i) {
            for (j = 1; j < recobe_collection.domains[g]->recountad; ++j) {
                cnv = recobe_collection.domains[g]->convbyname(p);
                if  ((!!cnv.nonesrc || (cnv.encosrc == i)) && (!!cnv.nonedst || (cnv.encodst == j))) {
                    cnv.encosrc = i;
                    cnv.encodst = j;
                    if  (!!(t = recobe_collection.domains[g]->reconv(cnv))) {
                        toto( recobe_collection.domains[g]->encolist[i].encoid
                            , recobe_collection.domains[g]->encolist[j].encoid
                            , g
                            , t
                            )
                        ;
                        free(t);
                        t = NULL;
                    } else {
                        f = recobe_collection.domains[g]->reconv((recobe_conv){ cnv.domain
                                                                              , cnv.encodst
                                                                              , 0
                                                                              , cnv.encosrc
                                                                              , 0
                                                                              }
                                                        );
                        if  (!!f) {
                            for (k = 0; k < 256; ++k) o[k] = 0;
                            for (k = 0; k < 256; ++k) o[f[k]] = k;
                            toto( recobe_collection.domains[g]->encolist[i].encoid
                                , recobe_collection.domains[g]->encolist[j].encoid
                                , g
                                , o
                                )
                            ;
                            free(f);
                            f = NULL;
                        } else if (!!cnv.encosrc && !!cnv.encodst && (i != j)) {
                            for (q = 1; q < recobe_collection.domains[g]->recountad; ++q) {
                                if  ((i != q) && (q != j)) {
                                    cnv.encosrc = i;
                                    cnv.encodst = q;
                                    cnv.domain = g;
                                    if  (!!(f = recobe_collection.domains[g]->reconv(cnv))) {
                                        cnv.encosrc = q;
                                        cnv.encodst = j;
                                        if  (!!(t = recobe_collection.domains[g]->reconv(cnv))) {
                                            const recobe_c_tdm *d = recobe_collection.domains[g];

                                            for (k = 0; k < 256; ++k) o[k] = t[f[k]];
                                            if  (toto == recobe_p256) {
                                                printf( "/* %s=>%s=>%s */\n"
                                                      , d->encolist[i].encoid
                                                      , d->encolist[q].encoid
                                                      , d->encolist[j].encoid
                                                      )
                                                ;
                                            }
                                            toto( d->encolist[i].encoid
                                                , d->encolist[j].encoid
                                                , g
                                                , o
                                                )
                                            ;
                                            free(t);
                                            t = NULL;
                                        }
                                        free(f);
                                        f = NULL;
    }   }   }   }   }   }   }   }   }
    exit(EX_OK);
}

int
/*****************************************************************************************************
 *****************************************************************************************************/
recobe_PrintAndMake(const char *p) {                                                             /****
 *****************************************************************************************************
 *****************************************************************************************************/
    return(makeup(p, recobe_p256));
}

int
/*****************************************************************************************************
 *****************************************************************************************************/
recobe_WriteAndMake(const char *p) {                                                             /****
 *****************************************************************************************************
 *****************************************************************************************************/
    return(makeup(p, recobe_w256));
}

int
/*****************************************************************************************************
 *****************************************************************************************************/
recobe_PrintNoRecod(const char *p) {                                                             /****
 *****************************************************************************************************
 *****************************************************************************************************/
    char f[2] = "0", t[2] = "0";
    u_char o[256];
    int k;

    for (k = 0; k < 256; ++k) o[k] = k;
    if  (!p[0]) {
        write(fileno(stdout), o, 256);
    } else {
        f[0] = p[0] ? p[0] : 'x';
        t[0] = (p[0] && p[1]) ? p[1] : 'x';
        recobe_p256(f, t, RECOBE_TEXT, o);
    }
    exit(EX_OK);
}

int
/*****************************************************************************************************
 *****************************************************************************************************/
recobe_G711DiffConv(const char *p) {                                                             /****
 *****************************************************************************************************
 *****************************************************************************************************/
    u_char *s;
    int i;

    if  (!*p || !strcmp(p, "A")) {
        for (i = 0; i < 256; ++i) {
            if  (recobe_G711A(recobe_deG711A[i]) != i) {
                printf( "A %02X %04X %02X\n"
                      , i, recobe_deG711A[i] & 0xFFFF, recobe_G711A(recobe_deG711A[i])
                      )
                ;
    }   }   }
    if  (!*p || !strcmp(p, "u")) {
        for (i = 0; i < 256; ++i) {
            if  (recobe_G711u(recobe_deG711u[i]) != i) {
                printf( "u %02X %04X %02X\n"
                      , i, recobe_deG711u[i] & 0xFFFF, recobe_G711u(recobe_deG711u[i])
                      )
                ;
    }   }   }
    if  (!*p || !strncmp(p, "Au", 2)) {
        s = recobe_collection.reconv(recobe_collection.conv("Au", RECOBE_G711, 0xFFFF));
        for (i = 0; i < 256; ++i) {
            if  (s[i] != recobe_G711u(recobe_deG711A[i])) {
                printf( "u[A[%02X]=%04X]=%02X <> A2u[%02X]=%02X\n"
                      , i
                      , recobe_deG711A[i] & 0xFFFF
                      , recobe_G711u(recobe_deG711A[i])
                      , i
                      , s[i]
                      )
                ;
        }   }
        free(s);
        s = NULL;
    }
    if  (!*p || !strncmp(p, "uA", 2)) {
        s = recobe_collection.reconv(recobe_collection.conv("uA", RECOBE_G711, 0xFFFF));
        for (i = 0; i < 256; ++i) {
            if  (s[i] != recobe_G711A(recobe_deG711u[i])) {
                printf( "A[u[%02X]=%04X]=%02X <> u2A[%02X]=%02X\n"
                      , i
                      , recobe_deG711u[i] & 0xFFFF
                      , recobe_G711A(recobe_deG711u[i])
                      , i
                      , s[i]
                      )
                ;
        }   }
        free(s);
        s = NULL;
    }
    exit(EX_OK);
}

int
/*****************************************************************************************************
 *****************************************************************************************************/
recobe_PrintFilling(const char *p) {                                                             /****
 *****************************************************************************************************
 *****************************************************************************************************/
    recobe_conv cnv = {0, 0, 0, 0, 0};
    int g, i, j, k, domain;
    u_char  *s, o[256];

    domain = (!*p) ? 0 : (*p - '0');
    if  (recobe_collection.domcount <= domain) domain = 0;
    for (g = (!domain ? 1 : domain); g < (!domain ? recobe_collection.domcount : domain + 1); ++g) {
        for (i = 1; i < recobe_collection.domains[g]->recountad; ++i) {
            for (j = 1; j < recobe_collection.domains[g]->recountad; ++j) {
                cnv.encosrc = i;
                cnv.encodst = j;
                cnv.domain = g;
                if  (!!(s = recobe_collection.domains[g]->reconv(cnv))) {
                    for (k = 0; k < 256; ++k) o[k] = 0;
                    for (k = 0; k < 256; ++k) o[s[k]]++;
                    free(s);
                    s = NULL;
                    for (k = 0; k < 256; ++k) {
                        if  (  (1 != o[k])
                            && ((blin_internal_flags & RECOBE_FULLCHECK) || (!!k && !!o[k]))
                            ) {
                            printf("%s %s%s[0x%02X]=%d\n"
                                  , recobe_collection.domains[g]->domname
                                  , recobe_collection.domains[g]->encolist[i].encoid
                                  , recobe_collection.domains[g]->encolist[j].encoid
                                  , k
                                  , o[k]
                                  )
                            ;
    }   }   }   }   }   }
    exit(EX_OK);
}

int
/*****************************************************************************************************
 *****************************************************************************************************/
recobe_InterMediaTo(const char *p) {                                                             /****
 *****************************************************************************************************
 *****************************************************************************************************/
    recobe_conv cnv = {0, 0, 0, 0, 0};
    u_char *s, *t, *f;
    int i, j, g, q;

    for (g = 1; g < recobe_collection.domcount; ++g) {
        for (i = 1; i < recobe_collection.domains[g]->recountad; ++i) {
            for (j = 1; j < recobe_collection.domains[g]->recountad; ++j) {
                cnv = recobe_collection.domains[g]->convbyname(p);
                if  ((!!cnv.nonesrc || (cnv.encosrc == i)) && (!!cnv.nonedst || (cnv.encodst == j))) {
                    cnv.encosrc = i;
                    cnv.encodst = j;
                    cnv.domain = g;
                    if  (!!(s = recobe_collection.domains[g]->reconv(cnv))) {
                        for (q = 0; q < recobe_collection.domains[g]->recountad; ++q) {
                            if  ((i != q) && (q != j)) {
                                cnv.encosrc = i;
                                cnv.encodst = q;
                                if  (!!(f = recobe_collection.domains[g]->reconv(cnv))) {
                                    cnv.encosrc = q;
                                    cnv.encodst = j;
                                    if  (!!(t = recobe_collection.domains[g]->reconv(cnv))) {
                                        intertest(g, i, j, q, s, f, t);
                                        free(t);
                                        t = NULL;
                                    }
                                    free(f);
                                    f = NULL;
                        }   }   }
                        free(s);
                        s = NULL;
    }   }   }   }   }
    exit(EX_OK);
}

int
/*****************************************************************************************************
 *****************************************************************************************************/
recobe_EtalonCompar(const char *p) {                                                             /****
 *****************************************************************************************************
 *****************************************************************************************************/
    recobe_conv cnv = {0, 0, 0, 0, 0};
    int k, i, j, g;
    u_char *t, *f;

    g = RECOBE_TEXT;
    for (i = 1; i < recobe_collection.domains[g]->recountad; ++i) {
        for (j = 1; j < recobe_collection.domains[g]->recountad; ++j) {
            cnv = recobe_collection.domains[g]->convbyname(p);
            if  ((!!cnv.nonesrc || (cnv.encosrc == i)) && (!!cnv.nonedst || (cnv.encodst == j))) {
                cnv.encosrc = i;
                cnv.encodst = j;
                cnv.nonesrc = 0;
                cnv.nonedst = 0;
                cnv.domain = RECOBE_ETAT;
                if  (!!(t = recobe_collection.domains[RECOBE_ETAT]->reconv(cnv))) {
                    cnv.domain = g;
                    if  (!(f = recobe_collection.domains[g]->reconv(cnv))) {
                        printf( "Absent %d %s%s\n"
                              , g
                              , recobe_collection.domains[g]->encolist[i].encoid
                              , recobe_collection.domains[g]->encolist[j].encoid
                              )
                        ;
                    } else {
                        for (k = 0; k < 256; ++k) {
                            if  (!!t[k] && (f[k] != t[k])) {
                                printf( "%d %s%s[0x%02X]=0x%02X<>0x%02X\n"
                                      , g
                                      , recobe_collection.domains[g]->encolist[i].encoid
                                      , recobe_collection.domains[g]->encolist[j].encoid
                                      , k
                                      , t[k]
                                      , f[k]
                                      )
                                ;
                        }   }
                        free(f);
                        f = NULL;
                    }
                    free(t);
                    t = NULL;
    }   }   }   }
    exit(EX_OK);
}

#define POWER  7
#define DOMAIN RECOBE_ETAT

int
/*****************************************************************************************************
 *****************************************************************************************************/
recobe_ReCalculator(const char *p) {                                                             /****
 *****************************************************************************************************
 *****************************************************************************************************/
    u_char o[256], *ccc[POWER][POWER], ddd[POWER][POWER][256];
    int c, i, j, k, m, n, z, cc[POWER];
    recobe_conv cnv = {DOMAIN, 0, 0, 0, 0};
    const u_char *q;
    int ex = EX_OK;

    q = (const u_char*)p;
    for (c = 0; q[c] && (c < POWER); ++c) {
        cc[c] = recobe_collection.domains[DOMAIN]->codnumbyid((const char *)&q[c]);
        if  (1 > cc[c]) {
            ex = -1;
            goto out;
        }
        printf("code %c(%d)\n", q[c], cc[c]);
    }
    for (i = 0; i < c; ++i) {
        for (j = 0; j < c; ++j) {
            cnv.encosrc = cc[i];
            cnv.encodst = cc[j];
            ccc[i][j] = recobe_collection.domains[DOMAIN]->reconv(cnv);
            if  (blin_internal_flags & RECOBE_PRELINERA) {
            ;   if  (  (  ('w' == recobe_collection.domains[DOMAIN]->encolist[cc[i]].encoid[0])
                       && ('k' == recobe_collection.domains[DOMAIN]->encolist[cc[j]].encoid[0])
                       )
                    || (  ('k' == recobe_collection.domains[DOMAIN]->encolist[cc[i]].encoid[0])
                       && ('w' == recobe_collection.domains[DOMAIN]->encolist[cc[j]].encoid[0])
                    )  ) {
            ;       for (k = 0x80; k <= 0x99; ++k) {
            ;           if  (ccc[i][j][k]) {
            ;               printf( "E1 %c%c[%d]=0x%02X\n"
                                  , recobe_collection.domains[DOMAIN]->encolist[cc[i]].encoid[0]
                                  , recobe_collection.domains[DOMAIN]->encolist[cc[j]].encoid[0]
                                  , k
                                  , ccc[i][j][k]
                                  )
            ;               ;
            ;           }
            ;           ccc[i][j][k] = k;
            ;   }   }
            ;   if  (  (  ('i' == recobe_collection.domains[DOMAIN]->encolist[cc[i]].encoid[0])
                       && ('k' == recobe_collection.domains[DOMAIN]->encolist[cc[j]].encoid[0])
                       )
                    || (  ('k' == recobe_collection.domains[DOMAIN]->encolist[cc[i]].encoid[0])
                       && ('i' == recobe_collection.domains[DOMAIN]->encolist[cc[j]].encoid[0])
                    )  ) {
            ;       for (k = 0x80; k <= 0x99; ++k) {
            ;           if  (ccc[i][j][k]) {
            ;               printf( "E1 %c%c[%d]=0x%02X\n"
                                  , recobe_collection.domains[DOMAIN]->encolist[cc[i]].encoid[0]
                                  , recobe_collection.domains[DOMAIN]->encolist[cc[j]].encoid[0]
                                  , k
                                  , ccc[i][j][k]
                                  )
            ;               ;
            ;           }
            ;           ccc[i][j][k] = k;
            ;   }   }
            ;   if  (  (  ('w' == recobe_collection.domains[DOMAIN]->encolist[cc[i]].encoid[0])
                       && ('a' == recobe_collection.domains[DOMAIN]->encolist[cc[j]].encoid[0])
                       )
                    || (  ('i' == recobe_collection.domains[DOMAIN]->encolist[cc[i]].encoid[0])
                       && ('a' == recobe_collection.domains[DOMAIN]->encolist[cc[j]].encoid[0])
                    )  ) {
            ;       for (k = 0x80; k <= 0x9F; ++k) {
            ;           if  (ccc[i][j][k]) {
            ;               printf( "E1 %c%c[%d]=0x%02X\n"
                                  , recobe_collection.domains[DOMAIN]->encolist[cc[i]].encoid[0]
                                  , recobe_collection.domains[DOMAIN]->encolist[cc[j]].encoid[0]
                                  , k
                                  , ccc[i][j][k]
                                  )
            ;               ;
            ;           }
            ;           ccc[i][j][k] = k + 0x30;
            ;   }   }
            ;   if  (  (  ('a' == recobe_collection.domains[DOMAIN]->encolist[cc[i]].encoid[0])
                       && ('w' == recobe_collection.domains[DOMAIN]->encolist[cc[j]].encoid[0])
                       )
                    || (  ('a' == recobe_collection.domains[DOMAIN]->encolist[cc[i]].encoid[0])
                       && ('i' == recobe_collection.domains[DOMAIN]->encolist[cc[j]].encoid[0])
                    )  ) {
            ;       for (k = 0xB0; k <= 0xCF; ++k) {
            ;           if  (ccc[i][j][k]) {
            ;               printf( "E1 %c%c[%d]=0x%02X\n"
                                  , recobe_collection.domains[DOMAIN]->encolist[cc[i]].encoid[0]
                                  , recobe_collection.domains[DOMAIN]->encolist[cc[j]].encoid[0]
                                  , k
                                  , ccc[i][j][k]
                                  )
            ;               ;
            ;           }
            ;           ccc[i][j][k] = k - 0x30;
            }   }   }
            if  (!!ccc[i][j]) {
                for (k = 0; k < 256; ++k) o[k] = 0;
                for (k = 0; k < 256; ++k) ++o[ccc[i][j][k]];
                for (k = 0, m = 0; k < 256; ++k) if (!o[k]) ddd[i][j][m++] = k;
                ddd[i][j][m++] = 0;
    }   }   }
    for (i = 0; i < c; ++i) {
        for (j = 0; j < c; ++j) {
            if  (!!ccc[i][j]) {
                printf( "%c%c"
                      , recobe_collection.domains[DOMAIN]->encolist[cc[i]].encoid[0]
                      , recobe_collection.domains[DOMAIN]->encolist[cc[j]].encoid[0]
                      )
                ;
                for (m = 0; ddd[i][j][m]; ++m) printf(" %02X", ddd[i][j][m]);
                printf("\n");
    }   }   }
    blin_internal_flags |= RECOBE_REVERTIZE | RECOBE_INTERTIZE;
    for (z = 1; !!z;) {
        printf("######## %d ########\n", z);
        z = 0;
        for (i = 0; i < c; ++i) {
            for (j = 0; j < c; ++j) {
                if  (!!ccc[i][j] && (i != j)) {
                    if  (!!ccc[j][i]) {
                        z += revertest(RECOBE_TEXT, cc[i], cc[j], ccc[i][j], ccc[j][i]);
        }   }   }   }
        for (i = 0; i < c; ++i) {
            for (j = 0; j < c; ++j) {
                if  (!!ccc[i][j] && (i != j)) {
                    for (n = 0; n < c; ++n) {
                        if  (!!ccc[i][n] && !!ccc[n][j] && (i != n) && (n != j)) {
                            z += intertest( RECOBE_TEXT
                                          , cc[i]
                                          , cc[j]
                                          , cc[n]
                                          , ccc[i][j]
                                          , ccc[i][n]
                                          , ccc[n][j]
                                          )
                            ;
    }   }   }   }   }   }
out:
    exit(ex);
}

#   define POWERED 128 /* 2 ** POWER */
#   define SETSIZE 1024

typedef struct {
    u_int32_t unit :  8
            , plus : 12
            , minus: 12
    ;
} summo;

static const u_char
/*****************************************************************************************************/
numberones[] =                                                                                   /****
 *****************************************************************************************************/
{  0, 1, 1, 2,  1, 2, 2, 3,  1, 2, 2, 3,  2, 3, 3, 4
,  1, 2, 2, 3,  2, 3, 3, 4,  2, 3, 3, 4,  3, 4, 4, 5
,  1, 2, 2, 3,  2, 3, 3, 4,  2, 3, 3, 4,  3, 4, 4, 5
,  2, 3, 3, 4,  3, 4, 4, 5,  3, 4, 4, 5,  4, 5, 5, 6
};

static int
/*****************************************************************************************************/
stepa( int c                                                                                     /****/
     , int d                                                                                     /****/
     , mular_descriptor *md                                                                      /****/
     , u_char sets[POWER][SETSIZE]                                                               /****/
     , u_int16_t z[POWERED][SETSIZE]                                                             /****/
     , u_int16_t Z[POWERED][SETSIZE]                                                             /****/
     , u_int16_t y[POWERED]                                                                      /****/
     , u_int16_t Y[POWERED]                                                                      /****/
     ) {                                                                                         /****
 *****************************************************************************************************/
    int i, j, k, n, m, ex;
    u_int u;

    for (n = 128, m = 128; m < d; ++m) {
        for (j = 0, i = 0; i < c; ++i) if (!!sets[i][m]) ++j;
        if  (!!j) {
            ++n;
            if  (blin_internal_flags & RECOBE_FULLCHECK) {
                printf("%4d:", m);
                for (i = 0; i < c; ++i) printf("  %02X", sets[i][m]);
                printf("\n");
    }   }   }
    printf("** %d **\n", n);
    ex = n;
    for (i = 0; i < POWERED; ++i) y[i] = 0;
    for (n = 1; n < 256; ++n) {
        for (i = 0, j = 0; j < c; ++j) {
            if  (!sets[j][n]) i |= (1 << j);
        }
        if  (!!i) z[i][y[i]++] = n;
    }
    for (i = 0; i < POWERED; ++i) Y[i] = 0;
    for (n = 256; n < d; ++n) {
        for (i = 0, j = 0; j < c; ++j) {
            if  (!!sets[j][n]) i |= (1 << j);
        }
        if  (!!i) Z[i][Y[i]++] = n;
    }
    for (i = 0; i < POWERED; ++i) {
        if  (!!y[i] || !!Y[i]) {
            for (u = 0; u < MULAR_NEXT(md); ++u) {
                if  (numberones[((summo*)mular_getix(md, u))->unit] < numberones[i]) break;
            }
            ((summo*)mular_insert(md, u))->unit = i;
            ((summo*)mular_getix(md, u))->plus = y[i];
            ((summo*)mular_getix(md, u))->minus = Y[i];
    }   }
    for (j = 0; j < c; ++j) printf(" ");
    printf("      fr bs\n");
    for (u = 0; u < MULAR_NEXT(md); ++u) {
        for (j = 0; j < c; ++j) {
            printf("%u", ((((summo*)mular_getix(md, u))->unit) & (1 << j)) ? 1 : 0);
        }
        printf( "(%2d): %2u %2u %+3d\n"
              , ((summo*)mular_getix(md, u))->unit
              , ((summo*)mular_getix(md, u))->plus
              , ((summo*)mular_getix(md, u))->minus
              , ((summo*)mular_getix(md, u))->plus - ((summo*)mular_getix(md, u))->minus
              )
        ;
    }
    for (j = 0; j < c; ++j) {
        for (k = 0, i = 0; i < POWERED; ++i) {
            if  (i & (1 << j)) k += y[i] - Y[i];
        }
        printf(" %+3d", k);
    }
    printf("\n");
    return(ex);
}

static int
/*****************************************************************************************************/
moviline( int       c                                                                            /****/
        , u_int     v                                                                            /****/
        , u_char    sets[POWER][SETSIZE]                                                         /****/
        , u_int16_t z                                                                            /****/
        , u_int16_t Z                                                                            /****/
        ) {                                                                                      /****
 *****************************************************************************************************/
    int j, ex = EX_OK;

    for (j = 0; j < c; ++j) {
        if  (v & (1 << j)) {
            if  (!!sets[j][z]) {
                printf( "Errz%u j%d %02X\n"
                      , z, j, sets[j][z]
                      )
                ;
                ex = -EX_DATAERR;
                goto out;
            }
            if  (!sets[j][Z]) {
                printf( "ErrZ%u j%d %02X\n"
                      , Z, j, sets[j][Z]
                      )
                ;
                ex = -EX_DATAERR;
                goto out;
            }
            sets[j][z] = sets[j][Z];
            sets[j][Z] = 0;
    }   }
out:
    return(ex);
}

static int
/*****************************************************************************************************/
trequ( int       c                                                                               /****/
     , int       d                                                                               /****/
     , u_char    sets[POWER][SETSIZE]                                                            /****/
     , u_int16_t z[POWERED][SETSIZE]                                                             /****/
     , u_int16_t Z[POWERED][SETSIZE]                                                             /****/
     , u_int16_t y[POWERED]                                                                      /****/
     , u_int16_t Y[POWERED]                                                                      /****/
     ) {                                                                                         /****
 *****************************************************************************************************/
    size_t sz[] = {1024, 512};
    mular_descriptor *md;
    int i, ex = EX_OK;
    u_int u, v;

    md = mular_create(0, 2, sizeof(summo), sz);
    ex = stepa(c, d, md, sets, z, Z, y, Y);
    for (u = 0; u < MULAR_NEXT(md); ++u) {
        v = ((summo*)mular_getix(md, u))->unit;
        for (i = 0; (i < y[v]) && (i < Y[v]); ++i) {
            if  (blin_internal_flags & RECOBE_PRINTABLE) {
                printf("u%u v%02X i%d y%u Y%u z%u Z%u\n", u, v, i, y[v], Y[v], z[v][i], Z[v][i]);
            }
            if  (!!moviline(c, v, sets, z[v][i], Z[v][i])) {
                ex = -EX_DATAERR;
                printf( "Err u%u d%d\n", u, d);
                goto out;
    }   }   }
    mular_destroy(md);
out:
    return(ex);
}

static int
/*****************************************************************************************************/
trneq( int c                                                                                     /****/
     , int d                                                                                     /****/
     , u_char sets[POWER][SETSIZE]                                                               /****/
     , u_int16_t z[POWERED][SETSIZE]                                                             /****/
     , u_int16_t Z[POWERED][SETSIZE]                                                             /****/
     , u_int16_t y[POWERED]                                                                      /****/
     , u_int16_t Y[POWERED]                                                                      /****/
     ) {                                                                                         /****
 *****************************************************************************************************/
    size_t sz[] = {1024, 512};
    int i, j, ex = EX_OK;
    u_int16_t X[POWERED];
    mular_descriptor *md;
    u_int u, v, w, r;

    md = mular_create(0, 2, sizeof(summo), sz);
    ex = stepa(c, d, md, sets, z, Z, y, Y);
    for (u = 0; u < POWERED; ++u) X[u] = 0;
    for (u = 0; u < MULAR_NEXT(md); ++u) {
        v = ((summo*)mular_getix(md, u))->unit;
        for (i = 0; i < y[v]; ++i) {
            for (r = u + 1; r < MULAR_NEXT(md); ++r) {
                w = ((summo*)mular_getix(md, r))->unit;
                if  (!(w & ~v)) {
                    for (j = X[w]++; j < Y[w]; ++j) {
                        if  (blin_internal_flags & RECOBE_PRINTABLE) {
                            printf( "u%u v%02X r%u w%02X i%d j%d y%u Y%u z%u Z%u\n"
                                  , u, v, r, w, i, j, y[v], Y[w], z[v][i], Z[w][j]
                                  )
                            ;
                        }
                        if  (!!moviline(c, w, sets, z[v][i], Z[w][j])) {
                            ex = -EX_DATAERR;
                            printf( "Err u%u d%d\n", u, d);
                            goto out;
                        }
                        goto o1;
            }   }   }
        o1:;
    }   }
    mular_destroy(md);
out:
    return(ex);
}

int
/*****************************************************************************************************
 *****************************************************************************************************/
recobe_ReCoordinate(const char *p) {                                                             /****
 *****************************************************************************************************
 *****************************************************************************************************/
    u_int16_t z[POWERED][SETSIZE], Z[POWERED][SETSIZE], y[POWERED], Y[POWERED];
    u_char *ccc[POWER][POWER], sets[POWER][SETSIZE], o[256];
    int c, i, j, k, m, n, d, cc[POWER];
    recobe_conv cnv = {DOMAIN, 0, 0, 0, 0};
    const u_char *q;
    int ex = EX_OK;

    q = (const u_char*)p;
    for (c = 0; q[c] && (c < POWER); ++c) {
        cc[c] = recobe_collection.domains[DOMAIN]->codnumbyid((const char *)&q[c]);
        if  (1 > cc[c]) {
            ex = EX_USAGE;
            goto out;
        }
        printf("code %c(%d)\n", q[c], cc[c]);
    }
    for (i = 0; i < c; ++i) {
        for (j = 0; j < c; ++j) {
            cnv.encosrc = cc[i];
            cnv.encodst = cc[j];
            ccc[i][j] = recobe_collection.domains[DOMAIN]->reconv(cnv);
    }   }
    for (i = 0; i < c; ++i) {
        for (m = 0; m < SETSIZE; ++m) {
            sets[i][m] = 0;
    }   }
    for (d = 1, i = 0; i < c; ++i) {
        for (k = 1; k < 256; ++k) {
            for (n = 0, m = 0; m < d; ++m) {
                if  (sets[i][m] == k) n = m;
            }
            if  (!n) n = d++;
            for (j = 0; j < c; ++j) {
                if  (i == j) {
                    if  (!!sets[j][n] && (sets[j][n] != k)) {
                        printf( "Conflict d%d i%d k%02X n%d j%d %02X<>%02X\n"
                              , d, i, k, n, j, sets[j][n], ccc[i][j][k]
                              )
                        ;
                        ex = EX_DATAERR;
                        goto out;
                    }
                    sets[j][n] = k;
                } else if (!!ccc[i][j] /* && !!ccc[i][j][k] */) {
                    if  (!!sets[j][n] && (sets[j][n] != ccc[i][j][k])) {
                        printf( "Conflict d%d i%d k%02X n%d j%d %02X<>%02X\n"
                              , d, i, k, n, j, sets[j][n], ccc[i][j][k]
                              )
                        ;
                        ex = EX_DATAERR;
                        goto out;
                    }
                    sets[j][n] = ccc[i][j][k];
    }   }   }   }
    printf("** %d **\n", d);
    for (i = SETSIZE, j = SETSIZE + 1; j > i;) {
        j = i;
        if  (0 > (i = trequ(c, d, sets, z, Z, y, Y))) {
            ex = EX_DATAERR;
            printf("Err trequ1\n");
            goto out;
        }
        if  (0 > (i = trneq(c, d, sets, z, Z, y, Y))) {
            ex = EX_DATAERR;
            printf("Err trneq1\n");
            goto out;
    }   }
    for (i = 0; i < c; ++i) {
        for (m = 256; m < d; ++m) {
            if  (!!sets[i][m]) {
                for (n = 1; n < 256; ++n) {
                    if  (!sets[i][n]) {
                        sets[i][n] = sets[i][m];
                        sets[i][m] = 0;
                        break;
                }   }
                if  (!!sets[i][m]) {
                    ex = EX_DATAERR;
                    printf("No room for i%d m%d %02X\n", i, m, sets[i][m]);
                    goto out;
    }   }   }   }
    for (i = 0; i < c; ++i) {
        for (j = 0; j < c; ++j) {
            if  (i != j) {
                for (k = 0; k < 256; ++k) o[k] = 0;
                for (m = 1; m < 256; ++m) {
                    if  (!!sets[j][m] && !!sets[i][m]) {
                        if  (!!o[sets[i][m]]) {
                            ex = EX_DATAERR;
                            printf( "Out conflict i%d j%d m%d %02X[%02X]<=%02X\n"
                                  , i, j, m, o[sets[i][m]], sets[i][m], sets[j][m]
                                  )
                            ;
                            goto out;
                        }
                        o[sets[i][m]] = sets[j][m];
                }   }
                recobe_p256(&p[i], &p[j], RECOBE_TEXT, o);
    }   }   }
out:
    exit(ex);
}

int
/*****************************************************************************************************
 *****************************************************************************************************/
recobe_TramplesDown(const char *p) {                                                             /****
 *****************************************************************************************************
 *****************************************************************************************************/
#define USIZE 0x110000
    int         ex = EX_OK;
    u_int16_t  *unitable;
    u_int32_t   margin;
    u_int64_t (*func)(u_int64_t);
    char       *nm;
    int         y;

    if  (!(unitable = malloc(sizeof(u_int16_t) * USIZE))) {
        ex = EX_OSERR;
        ifBLIN_QW0("No mem #1");
        goto out;
    }
    switch(*(p++)) {
    case 'L':
        func = recobe_unicodelower;
        nm = "low";
        break;
    case 'U':
        func = recobe_unicodeupper;
        nm = "upp";
        break;
    default:
        ex = EX_USAGE;
        ifBLIN_QX0("U or L");
        goto out;
    }
    for (u_int32_t i = 0; i < USIZE; ++i) unitable[i] = func(i);
    errno = EX_OK;
    if  (!*p) {
        u_int32_t *ml;
        u_int32_t  msup;

        for (int i = 16; i > 3; --i) {
            u_int32_t msize;

            msize = USIZE >> i;
            if  (0xFFFF0000 & msize) ifBLIN_QX0("msize out of limits");
            if  (!(ml = malloc(sizeof(u_int32_t) * msize))) {
                ex = EX_OSERR;
                ifBLIN_QW0("No mem #2 %lu x %u", sizeof(u_int32_t), msize);
                goto out;
            }
            ml[0] = 0;
            y = 1;
            for (u_int32_t m = 1; m < msize; ++m) {
                msup = m << i;
                if  (0xFFFF0000 & msup) ifBLIN_QX0("msup out of limits for %X", m);
                for (int k = 0; k < y; ++k) {
                    if  (0xFFFF0000 & k) ifBLIN_QX0("k out of limits");
                    if  (!bcmp(&unitable[msup], &unitable[ml[k]], sizeof(u_int16_t) * msup)) {
                        ml[m] = ml[k];
                        goto br;
                }   }
                ml[m] = m;
                ++y;
                if  (0xFFFF0000 & y) ifBLIN_QX0("y out of limits");
            br:;
            }
            printf("%2d:%6u +%4u *%6u =%8u\n", i, msize, y, msup, y * msup + msize);
            free(ml);
        }
    } else if ('x' == *p) {
        printf( "#include <sys/types.h>\n"
                "\n"
                "static const u_int16_t\n"
                "/*********************************************************************************/\n"
                "unicode%sertable[%u] =                                                 /****\n"
                " *********************************************************************************/\n"
              , nm
              , USIZE
              );
        for (int m = 0, c = '{'; m < USIZE; ++m) {
            printf("%c %s0x%04X", c, (m & 3) ? "" : " ", unitable[m]);
            if  ((m & 15) == 7) printf(" /* %06X */", m >> 4);
            if  (!(~m & 7)) printf("\n");
            c = ',';
        }
        printf("};\n");
    } else {
        int        i = strtol(p, NULL, 0);
        u_int16_t *shortable;
        u_int16_t *ms;
        u_int32_t  msize = USIZE >> i;
        u_int32_t  mstep = 1 << i;
        u_int32_t  mask = mstep - 1;

        if  (!!errno || (16 < i) || (5 > i)) {
            ex = EX_USAGE;
            ifBLIN_QX0("use -=O[U|D]<int from 5 up to 16> not %s", p);
            goto out;
        }
        if  (0xFFFF0000 & msize) ifBLIN_QX0("msize out of limits");
        if  (0xFFFF0000 & mstep) ifBLIN_QX0("mstep out of limits");
        if  (!(ms = malloc(sizeof(u_int32_t) * msize))) {
            ex = EX_OSERR;
            ifBLIN_QW0("No mem #2 %lu x %u", sizeof(u_int32_t), msize);
            goto out;
        }
        if  (!(shortable = malloc(sizeof(u_int16_t) * USIZE))) {
            ex = EX_OSERR;
            ifBLIN_QW0("No mem #3 %lu x %u", sizeof(u_int16_t), msize);
            goto out;
        }
        y = 0;
        margin = 0;
        for (u_int32_t m = 0; m < msize; ++m) {
            u_int32_t msup;

            msup = m << i;
            for (int k = 0; k < y; ++k) {
                if  (0xFFFF0000 & k) ifBLIN_QX0("k out of limits");
                if  (0xFFFF0000 & (ms[k] << i)) ifBLIN_QX0("(ms[k] << i) out of limits for %X", k);
                if  (!bcmp(&unitable[msup], &unitable[ms[k] << i], sizeof(u_int16_t) * mstep)) {
                    ms[m] = ms[ms[k]];
                    goto bs;
            }   }
            ms[m] = y++;
            if  (0xFFFF0000 & y) ifBLIN_QX0("y out of limits");
            if  (0xFFFF0000 & (ms[m] << i)) ifBLIN_QX0("(ms[m] << i) out of limits for %X", m);
            bcopy(&unitable[msup], &shortable[ms[m] << i], sizeof(u_int16_t) * mstep);
        bs:;
            if  (!!ms[m]) margin = m;
        }
        for (int t = 0; t < USIZE; ++t) {
            u_int32_t mst;

            mst = ms[t >> i] << i;
            if  (unitable[t] != shortable[mst + (t & mask)]) {
                fprintf( stderr
                       , "[%06X] %04X <> %04X\n"
                       , t
                       , unitable[t]
                       , shortable[mst + (t & mask)]
                       );
        }   }
        printf( "#include <sys/types.h>\n"
                "\n"
                "static const u_int16_t\n"
                "/*********************************************************************************/\n"
                "unicode%sertablerm[%u] =                                                  /****\n"
                " *********************************************************************************/\n"
              , nm
              , y << i
              );
        for (int m = 0, c = '{'; m < (y << i); ++m) {
            printf("%c %s0x%04X", c, (m & 3) ? "" : " ", shortable[m]);
            if  ((m & 15) == 7) printf(" /* %04X */", m >> 4);
            if  (!(~m & 7)) printf("\n");
            c = ',';
        }
        printf( "};\n"
                "\n"
                "static const u_int16_t\n"
                "/*********************************************************************************/\n"
                "unicode%sertablerw[%u] =                                                  /****\n"
                " *********************************************************************************/\n"
              , nm
              , margin + 1
              );
        for (u_int32_t m = 0, c = '{'; m <= margin; ++m) {
            printf("%c %s0x%04X", c, (m & 3) ? "" : " ", ms[m]);
            if  ((m & 15) == 7) printf(" /* %04X */", m >> 4);
            if  (!(~m & 7)) printf("\n");
            c = ',';
        }
        printf( "};\n"
                "\n"
                "u_int64_t\n"
                "/*********************************************************************************\n"
                " *********************************************************************************/\n"
                "recobe_unicode%ser(u_int64_t d) {                                           /****\n"
                " *********************************************************************************\n"
                " *********************************************************************************/\n"
                "    return( (0x%X <= d)\n"
                "          ? 0\n"
                "          : unicode%sertablerm[ (d & ((1 << %u) - 1))\n"
                "                               + (unicode%sertablerw[d >> %u] << %u)\n"
                "                               ]\n"
                "          );\n"
                "}\n"
              , nm
              , (margin + 1) << i
              , nm
              , i
              , nm
              , i
              , i
              );
    }
    free(unitable);
out:
    return(ex);
}
