/*-
 * Copyright (C)2005..2019 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2005..2019 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: syntan.c,v 1.17 2019/09/02 17:12:24 babolo Exp $\n"

#define BLIN_COMPAT  2
#define MIFE_COMPAT  3
#define Bpars_COMPAT 4
#define MULAR_COMPAT 0

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <strings.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "popushd.h"
#include "event.h"
#include "sepa.h"

static int
cnfin1(popush_main *r, popush_cnf *e) {
    int ex = EX_OK;
    size_t u4[] = {1024, 512, 512, 512};
    size_t *u8 = &(u4[1]);;

    if  (!(e->rawobj = mular_create(MULAR_ZERO, 3, 0, u4))) {
        mesg(r->flags, DE("create rawobj"));
        ex = EX_SOFTWARE;
        goto out;
    }
    e->rawobj->tofree = (babolo_tofree)babolo_freeparm;
    if  (!(e->reaction = mular_create(MULAR_ZERO, 3, 0, u4))) {
        mesg(r->flags, DE("create reaction"));
        ex = EX_SOFTWARE;
        goto out;
    }
    e->reaction->tofree = (babolo_tofree)babolo_freeparm;
    if  (!(e->cluster = mular_create(MULAR_ZERO, 3, sizeof(babolo_clust), u8))) {
        mesg(r->flags, DE("create cluster"));
        ex = EX_SOFTWARE;
        goto out;
    }
out:
    return(ex);
}

#define Ce  0x00800000 /*                */
#define Cw  0x00400000 /*   - */
#define Ca  0x00200000 /* &                 */
#define Cn  0x00100000 /*            */
#define Cf  0x00010000 /*               */
#define Cs  0x00008000 /*  SELF               */
#define Cb  0x00004000 /*               */
#define Co  0x00002000 /*                       */
#define Cp  0x00001000 /*                */
#define Cr  0x00000400 /*                      */
#define C_state  0xFF /*           */

#if 0
static const u_char *pn[] = 
{ "- ", "- ", "- ", "- ", "- ", "- ", "- ", "- "
, "e ", "w ", "a ", "n ", "- ", "- ", "- ", "f "
, "s ", "b ", "o ", "p ", "z ", "r ", "- ", "- "
};
#endif

enum states {Sb, Sz, So, Sr, Sn, Sx};
/* Sb -   
   Sz -   
   So -  ()
   Sr -  ()
   Sn - 
   Sx -   ( :-)
 */
#if 0
static const u_char *statenames[] = {"Sb", "Sz", "So", "Sr", "Sn", "Sx"};
#endif

const u_int32_t popush_tin[P_MAXP][Sx] =
/*             Sb,               Sz,            So,         Sr,     Sn  */
{ { Ce|        Sb, Ce|           Sn, Ce|        Sn, Ce|     Sn, Cn| Sn} /* P_EROR */
, { Ce|        Sb, Ce|           Sz,            Sz,         Sz,     Sz} /* P_ZERO */
, { Ce|        Sb, Ce|           Sz, Ca|        So, Ca|     Sr, Cn| Sn} /* P_ASYN */
, {        Co| So,        Cb|Co| So,        Co| So, Ce|     Sn, Cn| Sn} /* P_STRT */
, {        Co| So,        Cb|Co| So,        Co| So, Ce|     Sn, Cn| Sn} /* P_STOP */
, {        Co| So,        Cb|Co| So,        Co| So, Ce|     Sn, Cn| Sn} /* P_SIGN */
, {     Cs|Co| So,     Cs|Cb|Co| So,     Cs|Co| So, Ce|     Sn, Cn| Sn} /* P_SELF */
, { Cf|    Cf| Sb, Cf|    Cf|    Sz, Cf|    Cf| So, Ce|     Sn, Cn| Sn} /* P_FILE */
, {            Sb,               Sz,     Cp|    Sz,         Sz,     Sz} /* P_NULL */
, { Ce|        Sb, Ce|           Sz,     Cp|Cr| Sr,     Cr| Sr, Cn| Sn} /* P_ZERO|P_FULL */
, { Ce|        Sb, Ce|           Sz,     Cp|Cr| Sr,     Cr| Sr, Cn| Sn} /* P_ASYN|P_FULL */
, { Cw|    Co| Sb, Cw|    Cb|Co| Sz, Cw|    Co| So, Ce|     Sn, Cn| Sn} /* P_STRT|P_FULL */
, { Cw|    Co| Sb, Cw|    Cb|Co| Sz, Cw|    Co| So, Ce|     Sn, Cn| Sn} /* P_STOP|P_FULL */
, { Cw|    Co| Sb, Cw|    Cb|Co| Sz, Cw|    Co| So, Ce|     Sn, Cn| Sn} /* P_SIGN|P_FULL */
, { Cw| Cs|Co| Sb, Cw| Cs|Cb|Co| Sz, Cw| Cs|Co| So, Ce|     Sn, Cn| Sn} /* P_SELF|P_FULL */
, {        Co| So,        Cb|Co| So,        Co| So, Ce|     Sn, Cn| Sn} /* P_FILE|P_FULL */
};
/* Cp  [P_NULL][So]      .
 *       ,
 *        ask   .
 * XXXX
 */

static int
run1(popush_main *r, popush_cnf *e) {
    int ex = EX_OK;
    babolo_parm *s, **t;
    int line;
    u_int32_t state, nextat, control;
    off_t off;
    u_char *nextrc;
    ssize_t rcsize;
    babolo_clust *p;

    ifBLIN_QV2(r->flags) fprintf(stderr, "+run1\n");
    if  (r->cnf) {
        e->konfik.evnt.ident = r->cnf->konfik.evnt.ident;
        lseek(e->konfik.evnt.ident, 0, SEEK_SET);
    } else if ((e->konfik.evnt.ident = open(r->cnfname, O_RDONLY)) < 0) {
        mesg(r->flags, DE("config file open %s failed"), r->cnfname);
        ex = EX_NOINPUT;
        goto out;
    }
    if  ((r->cnfile = mife_opef(MIFE_FULL, e->konfik.evnt.ident)) == NULL) {
        mesg(r->flags, DE("config file mife_opef %s failed"), r->cnfname);
        ex = EX_NOINPUT;
        goto out;
    }
    if  (mife_eolinit(r->cnfile, "\n") < 0) {
        mesg(r->flags, DE("mife_eolinit"));
        ex = EX_SOFTWARE;
        goto out;
    }
    for ( line = 1, state = 0, nextrc = NULL
        ; state < Sx
        ; state = control & C_state
        ) {

        if  (nextrc) {
            off = r->cnfile->offset + (nextrc - (u_char*)r->cnfile->buffer);
        } else {
            off = 0;
        }
        if  ((rcsize = mife_read(r->cnfile, 0, off)) < 0) {
            mesg(r->flags, DE("config file read failed"));
            ex = EX_IOERR;
            goto out;
        } else if (rcsize == 0) {
            break;
        }
        if  (!(nextrc = mife_get(r->cnfile, off))) {
            mesg(r->flags, DE("mife_get"));
            ex = EX_SOFTWARE;
            goto out;
        }
        nextat = 0;
        ifBLIN_QV3(r->flags) {
            if (nextrc) {
                size_t i;
                fprintf(stderr, "~");
                for (i = 0; nextrc[i] && nextrc[i] != '\n'; i++) fprintf(stderr, "%c", nextrc[i]);
                fprintf(stderr, "~\n");
            } else fprintf(stderr, "NULL\n");
        }
        if  (!(s = babolo_getparm(Bpars_FIXB | Bpars_XXLN, (char **)&nextrc, "#", r->absq))) {
            mesg(r->flags, DE("babolo_getparm error in line %d"), line);
            ex = EX_SOFTWARE;
            goto out;
        } else if (s->argc == 0) {
            nextat = P_NULL;
        } else {
            nextat = babolo_testword(&sepa, (s->argv)[0]);
        }
        line += s->cntr;
        if  ((nextat != P_EROR) && (s->argc > 1)) nextat |= P_FULL;
        control = popush_tin[nextat][state];
        ifBLIN_QV3(r->flags)
            fprintf(stderr, "%02X->(%02X)%08X line=%d\n", state, nextat, control, line);
        if  (control & Ce) {
            mesg(r->flags | POPUSH_ERX, DE("Config error in line %d"), line - 1);
        }
        if  (control & Cf) {
            mesg(r->flags | POPUSH_ERX, DE("File without events in line %d"), line);
            babolo_freeparm(s);
        }
        if  (control & Ca) {
            mesg(r->flags | POPUSH_ERX, DE("Lonely & in line %d"), line);
        }
        if  (control & Cn) {
            mesg(r->flags | POPUSH_ERX, DE("Skip line %d for previous error(s)"), line);
        }
        if  (control & Cf) {
            mesg(r->flags | POPUSH_ERX, DE("File without events in line %d"), line);
            babolo_freeparm(s);
        }
        if  (control & Cs) {
            ifBLIN_QV4(r->flags) fprintf(stderr, "SELF %d\n", line);
            e->self = 3;
        }
        if  (control & Cb) {
            ifBLIN_QV4(r->flags)
                fprintf( stderr, "New obj=%s~ rawobj[%"BLIN_U"]=NULL\n"
                       , (s->argv)[0]
                       , MULAR_NEXT(e->rawobj)
                       );
            if  (!(t = mular_add(e->rawobj))) {
                ifBLIN_QV1(r->flags) warn("mular_add rawobj");
                ex = EX_SOFTWARE;
                goto out;
            }
            *t = NULL;
        }
        if  (control & Co) {
            ifBLIN_QV4(r->flags)
                fprintf( stderr, "Obj=%s~ rawobj[%"BLIN_U"]=%"BLIN_X"\n"
                       , s->argv[0]
                       , MULAR_NEXT(e->rawobj)
                       , BLIN_I(s)
                       );
            if  (!(t = mular_add(e->rawobj))) {
                mesg(r->flags, DE("mular_add rawobj"));
                ex = EX_SOFTWARE;
                goto out;
            }
            *t = s;
        }
        if  (control & Cp) {
            ifBLIN_QV4(r->flags)
                fprintf( stderr, "cluster[%"BLIN_U"]=%"BLIN_U"\n"
                       , MULAR_NEXT(e->cluster)
                       , MULAR_NEXT(e->reaction)
                       );
            if  (!(p = mular_add(e->cluster))) {
                mesg(r->flags, DE("mular_add cluster"));
                ex = EX_SOFTWARE;
                goto out;
            }
            p->clust = MULAR_NEXT(e->reaction);
        }
        if  (control & Cr) {
            ifBLIN_QV4(r->flags)
                fprintf( stderr, "React=%s~ reaction[%"BLIN_U"]=%"BLIN_X"\n"
                       , s->argv[1]
                       , MULAR_NEXT(e->reaction)
                       , BLIN_I(s)
                       );
            if  (!(t = mular_add(e->reaction))) {
                mesg(r->flags, DE("mular_add reaction"));
                ex = EX_SOFTWARE;
                goto out;
            }
            *t = s;
    }   }
out:
    if  (mife_close(r->cnfile)) {
        ifBLIN_QV1(r->flags) warn("config not closed");
    }
    r->cnfile = 0;
    ifBLIN_QV2(r->flags) fprintf(stderr, "-run1 %d\n", ex);
    return(ex);
}

static int
run2(popush_main *r, popush_cnf *e) {
    int ex = EX_OK;
    size_t l = MULAR_NEXT(e->cluster);
    size_t ll = (l + 7) / 8;
    size_t ux[] = {0, 512, 512};
    size_t objn, objp;
    u_char *a;

    ifBLIN_QV2(r->flags) fprintf(stderr, "+run2 %"BLIN_U" %"BLIN_U"\n", l, ll);
    if  (ll == 0) {
        mesg(r->flags, DE("empty input file"));
        ex = EX_DATAERR;
        goto out;
    }
    ux[0] = 4096 / ll;
    if  (ux[0] < 12) ux[0] = 12;
    ifBLIN_QV4(r->flags) fprintf(stderr, "ask=%"BLIN_U"\n", ux[0]);
    if  (!(e->ask = mular_create(MULAR_ZERO, 3, ll, ux))) {
        mesg(r->flags, DE("create ask %u(%u)"), ll, l);
        ex = EX_SOFTWARE;
        goto out;
    }
    e->strt = 0;
    if  (e->strt != MULAR_NEXT(e->ask)) {
        mesg(r->flags | POPUSH_ERX, DE("strt %u <> %u"), e->strt, MULAR_NEXT(e->ask));
        ex = EX_SOFTWARE;
        goto out;
    }
    if  (!(a = mular_add(e->ask))) {
        mesg(r->flags, DE("mular_add ask strt"));
        ex = EX_SOFTWARE;
        goto out;
    }
    e->stop = 1;
    if  (e->stop != MULAR_NEXT(e->ask)) {
        mesg(r->flags | POPUSH_ERX, DE("stop %u <> %u"), e->stop, MULAR_NEXT(e->ask));
        ex = EX_SOFTWARE;
        goto out;
    }
    if  (!(a = mular_add(e->ask))) {
        mesg(r->flags, DE("mular_add ask stop"));
        ex = EX_SOFTWARE;
        goto out;
    }
    e->sign = 2;
    if  (e->sign != MULAR_NEXT(e->ask)) {
        mesg(r->flags | POPUSH_ERX, DE("sign %u <> %u"), e->sign, MULAR_NEXT(e->ask));
        ex = EX_SOFTWARE;
        goto out;
    }
    if  (!(a = mular_add(e->ask))) {
        mesg(r->flags, DE("mular_add ask sign"));
        ex = EX_SOFTWARE;
        goto out;
    }
    if  (e->self) {
        if  (e->self != MULAR_NEXT(e->ask)) {
            mesg(r->flags | POPUSH_ERX, DE("self %u <> %u"), e->self, MULAR_NEXT(e->ask));
            ex = EX_SOFTWARE;
            goto out;
        }
        if  (!(a = mular_add(e->ask))) {
            mesg(r->flags, DE("mular_add ask self"));
            ex = EX_SOFTWARE;
            goto out;
    }   }
    ux[0] = 8192 / sizeof(babolo_obj);
    ifBLIN_QV4(r->flags) fprintf(stderr, "object=%"BLIN_U"\n", ux[0]);
    if  (!(e->object = mular_create(MULAR_ZERO, 3, sizeof(babolo_obj), ux))) {
        mesg(r->flags, DE("create object"));
        ex = EX_SOFTWARE;
        goto out;
    }
    ifBLIN_QV4(r->flags) fprintf( stderr, "rawobj max %"BLIN_U", cluster max %"BLIN_U"\n"
                                , MULAR_NEXT(e->rawobj), MULAR_NEXT(e->cluster)
                                );
    for (objn = 0, objp = 0; !ex && objp < MULAR_NEXT(e->rawobj); objp++) {
        babolo_parm *p;
        babolo_obj  *o;
        size_t n, *v;
        int i;
        u_int32_t j, t;
        size_t c0 = 0, c1 = 0, *g0, *g1;

        p = *(babolo_parm**)(mular_getix(e->rawobj, objp));
        t = 0;
        if  (objn < MULAR_NEXT(e->cluster)) {
            t |= 2;
            g0 = mular_getix(e->cluster, objn);
            if  (!g0) {
                /* XXXX error */
            }
            c0 = *g0;
            if  (c0 == MULAR_NEXT(e->object)) t |= 8;
        }
        if  ((objn + 1) < MULAR_NEXT(e->cluster)) {
            t |= 1;
            g1 = mular_getix(e->cluster, objn + 1);
            if  (!g1) {
                /* XXXX error */
            }
            c1 = *g1;
            if  (c0 == c1) t |= 16;
        } else if ((objn + 1) == MULAR_NEXT(e->cluster)) t |= 4;
/****************
   16 8 4 2 1
    0 0 0 0 0 ERROR
    0 0 0 1 1
    0 0 1 1 0
    0 1 0 1 1
    0 1 1 1 0
    1 0 0 1 1 NEXT
    1 1 0 1 1 NEXT
 ****************/
        ifBLIN_QV4(r->flags) {
            if  (t & 1) {
                fprintf(stderr, "%02X: clu[%"BLIN_U"]=%"BLIN_U" <=> clu[%"BLIN_U"]=%"BLIN_U", raw[%"BLIN_U"]",t , objn, c0, objn + 1, c1, objp);
            } else if (t & 2) {
                fprintf(stderr, "%02X: clu[%"BLIN_U"]=%"BLIN_U" <=> clu[%"BLIN_U"] NO, raw[%"BLIN_U"]",t , objn, c0, objn + 1, objp);
            } else {
                fprintf(stderr, "%02X: clu[%"BLIN_U"] NO <=> clu[%"BLIN_U"] NO, raw[%"BLIN_U"]",t , objn, objn + 1, objp);
        }   }
        if  (!t) { /* ERROR */
            ex = EX_SOFTWARE;
            mesg(r->flags | POPUSH_ERX, DE("Internal parser error"));
            break;
        } else if (!p) {
            objn++;
            ifBLIN_QV4(r->flags) fprintf(stderr, " NO\n");
        } else if (t & 16) { /* NEXT */
            ifBLIN_QV4(r->flags) fprintf(stderr, " ==\n");
        } else {
        ;   v = NULL;
        ;   t = babolo_testword(&sepa, p->argv[0]);
        ;   ifBLIN_QV4(r->flags) fprintf(stderr, "=%02X %s~...\n", t, p->argv[0]);
        ;   switch (t) {
            case P_STRT: ifBLIN_QV4(r->flags) fprintf(stderr, "STRT"); v = &(e->strt); break;
        ;   case P_STOP: ifBLIN_QV4(r->flags) fprintf(stderr, "STOP"); v = &(e->stop); break;
        ;   case P_SIGN: ifBLIN_QV4(r->flags) fprintf(stderr, "SIGN"); v = &(e->sign); break;
        ;   case P_SELF:
        ;       ifBLIN_QV4(r->flags) fprintf(stderr, "SELF");
        ;       if  (e->self) v = &(e->self);
        ;       break;
        ;   case P_FILE:
        ;       ifBLIN_QV4(r->flags) fprintf(stderr, "FILE");
        ;       for (n = 0, o = NULL; n < MULAR_NEXT(e->object); n++) {
        ;           if  (!(o = mular_getix(e->object, n))) {
        ;               ifBLIN_QV1(r->flags) warn("mular_getix object %"BLIN_U, n);
        ;           } else if (strcmp((char *)p->argv[0], o->fname) == 0) break;
        ;           o = NULL;
        ;       }
        ;       if  (!o) {
        ;           /*      ,    ,
        ;            *       
        ;            *  diffmerge().  XXXX
        ;            */
        ;           ifBLIN_QV4(r->flags)
                       fprintf(stderr, " %"BLIN_U" %s\n", MULAR_NEXT(e->object), p->argv[0]);
        ;           if  (!(o = mular_add(e->object))) {
        ;               mesg(r->flags, DE("add object"));
        ;               ex = EX_SOFTWARE;
        ;               goto out;
        ;           }
        ;           o->fname = (char *)p->argv[0];
        ;           o->evnt.filter = EVFILT_VNODE;
        ;           o->evnt.flags = 0;
        ;       }
        ;       for (i = 1; i < p->argc; i++) {
        ;           switch ((j = babolo_testword(&event, p->argv[i]))) {
                    case NOTE_DELETE:
        ;               ifBLIN_QV4(r->flags) fprintf(stderr, "DELETE");
        ;               v = &(o->fdel);
        ;               break;
        ;           case NOTE_WRITE :
        ;               ifBLIN_QV4(r->flags) fprintf(stderr, "WRITE");
        ;               v = &(o->fwrt);
        ;               break;
        ;           case NOTE_EXTEND:
        ;               ifBLIN_QV4(r->flags) fprintf(stderr, "EXTEND\n");
        ;               v = &(o->fext);
        ;               break;
        ;           case NOTE_ATTRIB:
        ;               ifBLIN_QV4(r->flags) fprintf(stderr, "ATTRIB");
        ;               v = &(o->fatr);
        ;               break;
        ;           case NOTE_LINK  :
        ;               ifBLIN_QV4(r->flags) fprintf(stderr, "LINK");
        ;               v = &(o->flnk);
        ;               break;
        ;           case NOTE_RENAME:
        ;               ifBLIN_QV4(r->flags) fprintf(stderr, "RENAME");
        ;               v = &(o->fren);
        ;               break;
        ;           case NOTE_REVOKE:
        ;               ifBLIN_QV4(r->flags) fprintf(stderr, "REVOKE");
        ;               v = &(o->frev);
        ;               break;
        ;           default:
        ;               mesg(r->flags | POPUSH_ERX, DE("rawobj #2"));
        ;               v = NULL;
        ;           }
        ;           if  (v) {
        ;               ifBLIN_QV4(r->flags) fprintf(stderr, " %"BLIN_U" %08X\n", MULAR_NEXT(e->ask), j);
        ;               o->evnt.fflags |= j;
        ;               *v = MULAR_NEXT(e->ask);
        ;               if  (!mular_add(e->ask)) {
        ;                   mesg(r->flags, DE("add ask"));
        ;               }
        ;               set(/* XXXX */mular_getix(e->ask, *v), objn);
        ;               v = NULL;
        ;       }   }
        ;       break;
        ;   default:
        ;       mesg(r->flags | POPUSH_ERX, DE("rawobj #1"));
        ;       ex = EX_SOFTWARE;
        ;       goto out;
        ;   }
        ;   if  (v) {
        ;       ifBLIN_QV4(r->flags) fprintf(stderr, " %"BLIN_U"\n", MULAR_NEXT(e->ask));
        ;       set(/* XXXX */mular_getix(e->ask, *v), objn);
        ;   }
    }   }
out:
    ifBLIN_QV2(r->flags) fprintf(stderr, "-run2 %d\n", ex);
    return(ex);
}

static void
dumpr1(popush_cnf *e) {
    babolo_parm **t;
    babolo_clust *c;
    size_t n, i;

    fprintf(stderr, "+################################ run1 dump\n## rawobj\n");
    for (n = 0; n < MULAR_NEXT(e->rawobj); n++) {
        t = mular_getix(e->rawobj, n);
        if  (!t) {
            fprintf(stderr, "## raw[%"BLIN_D"] NO\n", n);
        } else if (!*t) {
            fprintf(stderr, "## raw[%"BLIN_D"] NULL\n", n);
        } else {
            fprintf( stderr, "## raw[%"BLIN_D"] %08X %"BLIN_D" %d\n"
                   , n, (*t)->flags, (*t)->cntr, (*t)->argc
                   );
            for (i = 0; i < (*t)->argc; i++) {
                if  ((*t)->argv[i]) {
                    fprintf(stderr, " [%"BLIN_D"]=%s~\n", i, (*t)->argv[i]);
                } else {
                    fprintf(stderr, " [%"BLIN_D"] NULL\n", i);
    }   }   }   }
    fprintf(stderr, "## reaction\n");
    for (n = 0; n < MULAR_NEXT(e->reaction); n++) {
        t = mular_getix(e->reaction, n);
        if  (!t) {
            fprintf(stderr, "## rea[%"BLIN_D"] NO\n", n);
        } else if (!*t) {
            fprintf(stderr, "## rea[%"BLIN_D"] NULL\n", n);
        } else {
            fprintf( stderr, "## rea[%"BLIN_D"] %08X %"BLIN_D" %d\n"
                   , n, (*t)->flags, (*t)->cntr, (*t)->argc
                   );
            for (i = 0; i < (*t)->argc; i++) {
                if  ((*t)->argv[i]) {
                    fprintf(stderr, " [%"BLIN_D"]=%s~\n", i, (*t)->argv[i]);
                } else {
                    fprintf(stderr, " [%"BLIN_D"] NULL\n", i);
    }   }   }   }
    fprintf(stderr, "## cluster\n");
    for (n = 0; n < MULAR_NEXT(e->cluster); n++) {
        c = mular_getix(e->cluster, n);
        if  (c) {
            fprintf(stderr, "clu[%"BLIN_D"]=%"BLIN_D"(rea)\n", n, c->clust);
        } else {
            fprintf(stderr, "clu[%"BLIN_D"] NULL\n", n);
    }   }
    fprintf(stderr, "-################################ run1 dump\n");
}

static void
dubit(u_char *b, size_t l, char *c) {
    size_t n, k = 0;
    for (n = 0; n < l; n++) {
        size_t i = n >> 3;
        u_char j = 1 << (n & 7);
        if  (!k) {
            fprintf(stderr, "%s", c);
            k++;
        }
        if  (b[i] & j) fprintf(stderr, ",%"BLIN_U"", n);
    }
    if  (k) fprintf(stderr, "\n");
}

static void
dumpcf(popush_cnf *e) {
    babolo_parm **p;
    babolo_obj  *o;
    size_t n, m, i;

    fprintf(stderr, "+################################ config dump\n");
    dubit(mular_getix(e->ask, e->strt), MULAR_NEXT(e->cluster), "strt");
    dubit(mular_getix(e->ask, e->stop), MULAR_NEXT(e->cluster), "stop");
    dubit(mular_getix(e->ask, e->sign), MULAR_NEXT(e->cluster), "sign");
    if  (e->self) dubit(mular_getix(e->ask, e->self), MULAR_NEXT(e->cluster), "self");
    for (n = 0; n < MULAR_NEXT(e->object); n++) {
        if  (!(o = mular_getix(e->object, n))) {
            fprintf(stderr, "NULL object %"BLIN_U"\n", n);
            continue;
        }
        fprintf(stderr, "%s\n", o->fname);
        if  (o->fdel) dubit(mular_getix(e->ask, o->fdel), MULAR_NEXT(e->cluster), " fdel");
        if  (o->fwrt) dubit(mular_getix(e->ask, o->fwrt), MULAR_NEXT(e->cluster), " fwrt");
        if  (o->fext) dubit(mular_getix(e->ask, o->fext), MULAR_NEXT(e->cluster), " fext");
        if  (o->fatr) dubit(mular_getix(e->ask, o->fatr), MULAR_NEXT(e->cluster), " fatr");
        if  (o->flnk) dubit(mular_getix(e->ask, o->flnk), MULAR_NEXT(e->cluster), " flnk");
        if  (o->fren) dubit(mular_getix(e->ask, o->fren), MULAR_NEXT(e->cluster), " fren");
        if  (o->frev) dubit(mular_getix(e->ask, o->frev), MULAR_NEXT(e->cluster), " frev");
    }
    for (m = n = 0; n < MULAR_NEXT(e->reaction); n++) {
        int k;
        p = mular_getix(e->reaction, n);
        k = 0;
        while ((m < MULAR_NEXT(e->cluster)) && (n == (*((size_t*)mular_getix(e->cluster, m))))) {
            k = 1;
            m++;
        }
        if  (k) fprintf(stderr, "## rea[%"BLIN_U"] for clu[%"BLIN_U"]\n", n, m - 1);
        if  (*p) {
            for (i = 0; i < (*p)->argc; i++) {
                fprintf(stderr, " %s", (*p)->argv[i]);
            }
        } else fprintf(stderr, "NULL");
        fprintf(stderr, "\n");
    }
    fprintf(stderr, "-################################ config dump\n");
}

popush_cnf *
syntan(popush_main *r) {
    int ex = EX_OK;
    popush_cnf *e;

    ifBLIN_QV2(r->flags) fprintf(stderr, "+syntan\n");
    if  (!(e = malloc(sizeof(popush_cnf)))) {
        mesg(r->flags | POPUSH_ERX, DE("No mem syntan.e"));
        ex = EX_TEMPFAIL;
        goto out;
    }
    bzero(e, sizeof(popush_cnf));
    if  ((ex = cnfin1(r, e))) goto out;
    if  ((ex = run1(r, e))) goto out;
    if  (r->flags & (BLIN_VER1 | POPUSH_ANA)) dumpr1(e);
    if  ((ex = run2(r, e))) goto out;
    if  (r->flags & (BLIN_VER1 | POPUSH_ANA)) dumpcf(e);
out:if  (ex) {
        cnfree(e);
        e = NULL;
    }
    ifBLIN_QV2(r->flags) fprintf(stderr, "-syntan %d %"BLIN_X"\n", ex, BLIN_I(e));
    return(e);
}
