/*-
 * Copyright (C)2005..2019 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: popushd.h,v 1.14 2019/09/02 17:12:24 babolo Exp $
 */

#define POPUSH_DMN   0x000001
#define POPUSH_ERX   0x000002
#define POPUSH_CRI   0x000004
#define POPUSH_ANA   0x000008

#define DE(A) A, A ": %m"

/*   P_*      */
/*               */
#define P_EROR   0x00
#define P_NULL   0x08
#define P_FULL   0x08
#define P_ZERO   0x01
#define P_ASYN   0x02
#define P_STRT   0x03
#define P_STOP   0x04
#define P_SIGN   0x05
#define P_SELF   0x06
#define P_FILE   0x07
#define P_MAXP   0x10

#define F_STRT   0x01
#define F_STOP   0x02
#define F_SIGN   0x04
#define F_SELF   0x08

#define E_ZERO   1
#define E_ASYN   2
#define E_FILE   3
#define E_WAIT   4
#define E_SIGN   5

typedef struct babolo_obj {
    struct kevent evnt;
    char       *fname;
    size_t      fdel;
    size_t      fwrt;
    size_t      fext;
    size_t      fatr;
    size_t      flnk;
    size_t      fren;
    size_t      frev;
} babolo_obj;

typedef struct babolo_clust {
    size_t      clust;
    pid_t       pid;
} babolo_clust;

typedef struct popush_cnf {
    mular_descriptor *rawobj;   /* *babolo_parm  */
    mular_descriptor *reaction; /* *babolo_parm  */
    mular_descriptor *cluster;  /* babolo_clust  */
    mular_descriptor *object;   /* babolo_obj    */
    mular_descriptor *ask;      /* u_char bit[]  */
    size_t      strt;
    size_t      stop;
    size_t      sign;
    size_t      self;
    babolo_obj  konfik;
} popush_cnf;

typedef struct popush_main {
    mife_descriptor *cnfile;
    u_int32_t   flags;
    char       *cnfname;     /*      */
    char       *pidname;     /*    PID  */
    char       *wdpath;      /* cwd    */
    popush_cnf *cnf;         /*   */
    u_char     *actionbit;
    int         kq;          /*   kqueue */
    u_char      absq;        /*   */
} popush_main;

/*

      2 multilar:
 - rawobj,    babolo_parm     ,
        ,    
      babolo_parm;
 - reaction,    babolo_parm     ,
        .    
     mular_descriptor cluster.
        
      babolo_parm    
 .
   .
         
   .     rawobj,   
 :
 - ,   babolo_obj  mular_descriptor object   
   ;
 -  ,  ,  ,    
     babolo_obj;
 -  babolo_obj    (fdel .. frev)  mular_descriptor ask
       ;
 -      babolo_parm  rawobj 
   ask   mular_descriptor      
   fdel .. frev babolo_obj,     ;
 -    ask,    .
   rawobj ,    babolo_obj  
   .      
       rawobj.
 ask 0 .. 3    START, STOP, SIGNAL, SELF
,  0  babolo_obj.fdel .. babolo_obj.frev 
, 1 .. 3  .
 START, STOP, SIGNAL ask  ,   
 popush_cnf.strt .. popush_cnf.sign,   SELF    
  .  ask  SELF ,   
  popush_cnf.self,   0 ().
 ask  SELF  ,  popushd     .

*/

popush_cnf *syntan    __P((popush_main *r));
void        execevent __P((popush_main *r));
int         setevent  __P((popush_main *r));
int         setkact   __P((popush_main *r, struct kevent *ev));
int         diffmerge __P((popush_main *r, popush_cnf *cnf));
void        setaction __P((popush_main *r, size_t a));
void        setact    __P((popush_main *r, size_t a));
void        cnfree    __P((popush_cnf *e));
void        bitset    __P((u_char *b, u_char *c, size_t n));
void        set       __P((u_char *b, size_t n));
u_char     *createbit __P((size_t n));
void        mesg      __P((u_int32_t flags, const char *fmt, const char *fmt1, ...));
