/*-
 * Copyright (C)2007..2019 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2007..2019 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: events.c,v 1.10 2019/09/02 17:12:24 babolo Exp $\n"

#define BLIN_COMPAT  2
#define MIFE_COMPAT  3
#define Bpars_COMPAT 4
#define MULAR_COMPAT 0

#include <sys/types.h>
#include <sys/event.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sysexits.h>
#include <strings.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "popushd.h"
#include "react.h"

extern char **environ;
extern u_int32_t state;

void
cnfree(popush_cnf *e) {
    if  (e) {
        if  (e->rawobj)   mular_destroy(e->rawobj);
        if  (e->reaction) mular_destroy(e->reaction);
        if  (e->cluster)  mular_destroy(e->cluster);
        if  (e->object)   mular_destroy(e->object);
        if  (e->ask)      mular_destroy(e->ask);
        free(e);
        e = NULL;
}   }

int
diffmerge(popush_main *r, popush_cnf *e) {
    int ex = EX_OK;
    struct stat ost, nst;
    size_t opo, npo;
    babolo_obj *ooo, *noo;
    struct timespec noll;

    ifBLIN_QV2(r->flags) fprintf(stderr, "+diffmerge\n");
    bzero(&noll, sizeof(noll));
    e->konfik.evnt.fflags = NOTE_LINK|NOTE_DELETE|NOTE_WRITE|NOTE_EXTEND;
    e->konfik.evnt.fflags |= NOTE_RENAME|NOTE_REVOKE|NOTE_ATTRIB;
    e->konfik.evnt.filter = EVFILT_VNODE;
    if  (r->cnf) {
        /*       ,
         *        
         *    
         */
        if  (r->cnf->self) e->konfik.evnt.flags = EV_ADD | EV_CLEAR;
        for (opo = 0; opo < MULAR_NEXT(r->cnf->object); opo++) {
            int found, f;

        ;   if  (!(ooo = mular_getix(r->cnf->object, opo))) {
        ;       mesg(r->flags, DE("mular_getix old object %u"), opo);
        ;       continue;
        ;   }
        ;   if  (!(ooo->evnt.flags)) continue;
        ;   for (found = 0, npo = 0; npo < MULAR_NEXT(e->object); npo++) {
        ;       if  (!(noo = mular_getix(e->object, npo))) {
        ;           mesg(r->flags, DE("mular_getix new object"));
        ;           continue;
        ;       }
        ;       if  (strcmp(noo->fname, ooo->fname) == 0) {
        ;           found = 1;
        ;           if  (fstat(ooo->evnt.ident, &ost) < 0) {
        ;               mesg(r->flags, DE("fstat old %s"), ooo->fname);
        ;               break;
        ;           }
        ;           if  ((f = open(noo->fname, O_RDONLY)) < 0) {
        ;               mesg(r->flags, DE("open #1 %s"), noo->fname);
        ;               break;
        ;           }
        ;           if  (fstat(f, &nst) < 0) {
        ;               mesg(r->flags, DE("fstat new %s"), noo->fname);
        ;               close(f);
        ;               break;
        ;           }
        ;           if  ((ost.st_dev == nst.st_dev) && (ost.st_ino == nst.st_ino)) {
        ;               close(f);
        ;               noo->evnt.ident = ooo->evnt.ident;
        ;               ooo->evnt.fflags &= ~noo->evnt.fflags;
        ;               ooo->evnt.flags = EV_DELETE;
        ;               if  (ooo->evnt.fflags && (kevent(r->kq, &(ooo->evnt), 1, NULL, 0, &noll) < 0)) {
        ;                   mesg(r->flags, DE("kevent #1 for %s"), ooo->fname);
        ;               }
        ;               ooo->evnt.flags = 0;
        ;           } else {
        ;               fcntl(f, F_SETFD, FD_CLOEXEC);
        ;               close(ooo->evnt.ident);
        ;               ooo->evnt.flags = 0;
        ;               noo->evnt.ident = f;
        ;           }
        ;           noo->evnt.flags = EV_ADD | EV_CLEAR;
        ;           if  (kevent(r->kq, &(noo->evnt), 1, NULL, 0, &noll) < 0) {
        ;               mesg(r->flags, DE("kevent #2 for %s"), noo->fname);
        ;               noo->evnt.flags = 0;
        ;   }   }   }
        ;   if  (!found) {
        ;       close(ooo->evnt.ident);
        ;       ooo->evnt.flags = 0;
    }   }   }
    if  (e->self && !e->konfik.evnt.flags) {
        e->konfik.evnt.flags = EV_ADD | EV_CLEAR;
        if  (kevent(r->kq, &(e->konfik.evnt), 1, NULL, 0, &noll) < 0) {
            mesg(r->flags, DE("kevent #3 for %s"), r->cnfname);
            e->konfik.evnt.flags = 0;
    }   }
    for (npo = 0; npo < MULAR_NEXT(e->object); npo++) {
        if  (!(noo = mular_getix(e->object, npo))) {
            mesg(r->flags, DE("mular_getix new object %u"), npo);
            continue;
        }
        if  (noo->evnt.flags) continue;
        noo->evnt.flags = EV_ADD | EV_CLEAR;
        if  ((int)(noo->evnt.ident = open(noo->fname, O_RDONLY)) < 0) {
            mesg(r->flags, DE("open #2 %s"), noo->fname);
            noo->evnt.flags = 0;
            continue;
        }
        if  (kevent(r->kq, &(noo->evnt), 1, NULL, 0, &noll) < 0) {
            mesg(r->flags, DE("kevent #3 for %s"), noo->fname);
            noo->evnt.flags = 0;
            continue;
    }   }
    ifBLIN_QV2(r->flags) fprintf(stderr, "-diffmerge %d\n", ex);
    return(ex);
}

int
setkact(popush_main *r, struct kevent *ev) {
    int ex = EX_OK;

    ifBLIN_QV2(r->flags) fprintf(stderr, "+setkact\n");
    if  (ev->flags & EV_ERROR) {
        ifBLIN_QV3(r->flags) fprintf(stderr, "EV_ERROR %"BLIN_U"\n", ev->data);
        switch (ev->data) {
        case EINTR: setaction(r, r->cnf->sign); break;
        case EFAULT:
        case ENOMEM: ex = EX_TEMPFAIL;
        }
    } else if (ev->filter == EVFILT_SIGNAL) {
        ifBLIN_QV3(r->flags) fprintf(stderr, "EVFILT_SIGNAL %"BLIN_U"\n", ev->data);
        setaction(r, r->cnf->sign);
    } else if (ev->filter == EVFILT_VNODE) {
        size_t n;
        int found;
        babolo_obj *o;

        ifBLIN_QV3(r->flags) fprintf(stderr, "EVFILT_VNODE %"BLIN_U" %04X\n", ev->data, ev->fflags);
        if  (r->cnf->konfik.evnt.ident == ev->ident) {
            state |= F_SELF;
            found = 1;
        } else found = 0;
        for (n = 0; !found && n < MULAR_NEXT(r->cnf->object); n++) {
            /*    ,
             *      
             * XXXX
             */
            if  (!(o = mular_getix(r->cnf->object, n))) {
                ifBLIN_QV1(r->flags) warn("NULL object %"BLIN_U"\n", n);
                continue;
            }
            if  (o->evnt.ident == ev->ident) {
                if  (ev->fflags & NOTE_DELETE) setaction(r, o->fdel);
                if  (ev->fflags & NOTE_WRITE ) setaction(r, o->fwrt);
                if  (ev->fflags & NOTE_EXTEND) setaction(r, o->fext);
                if  (ev->fflags & NOTE_ATTRIB) setaction(r, o->fatr);
                if  (ev->fflags & NOTE_LINK  ) setaction(r, o->flnk);
                if  (ev->fflags & NOTE_RENAME) setaction(r, o->fren);
                if  (ev->fflags & NOTE_REVOKE) setaction(r, o->frev);
                found = 1;
        }   }
        if  (!found) ifBLIN_QV1(r->flags) fprintf(stderr, "Not found fd %"BLIN_D"\n", ev->ident);
    } else {
        ifBLIN_QV1(r->flags)
            fprintf( stderr, "Not expectative event { %"BLIN_U" %d %04X %08X %"BLIN_U" %"BLIN_X" }\n"
                   , ev->ident, ev->filter, ev->flags, ev->fflags, ev->data, BLIN_I(ev->udata)
                   );
    }
    ifBLIN_QV2(r->flags) fprintf(stderr, "-setkact %d\n", ex);
    return(ex);
}

int
setevent(popush_main *r) {
    int ex = EX_OK;
    struct kevent evnt;
    struct timespec noll;
    int e;

    ifBLIN_QV2(r->flags) fprintf(stderr, "+setevent\n");
    bzero(&noll, sizeof(noll));
    bzero(&evnt, sizeof(evnt));
    while (!ex && ((e = kevent(r->kq, NULL, 0, &evnt, 1, &noll)) > 0)) {
        ifBLIN_QV3(r->flags)
            fprintf( stderr, "kevent{ %"BLIN_U" %d %04X %08X %"BLIN_U" %"BLIN_X" }\n"
                   , evnt.ident, evnt.filter, evnt.flags, evnt.fflags, evnt.data,  BLIN_I(evnt.udata)
                   );
        ex = setkact(r, &evnt);
    }
    ifBLIN_QV2(r->flags) fprintf(stderr, "-setevent\n");
    return(ex);
}

static int
vforkexec(char **argv) {
    int pid;

    pid = vfork();
    if  (!pid) execve(*argv, argv, environ);
    return(pid);
}

void
execevent(popush_main *r) {
    size_t n;
    pid_t  pid;
    babolo_clust *c;
    babolo_parm **p;
    int status;

    ifBLIN_QV2(r->flags) fprintf(stderr, "+execevent\n");
    for (n = 0; n < MULAR_NEXT(r->cnf->cluster); n++) {
        size_t i = n >> 3;
        u_char j = 1 << (n & 7);

        if  (r->actionbit[i] & j) {
            if  (!(c = mular_getix(r->cnf->cluster, n))) {
                mesg(r->flags, DE("mular_getix cluster #1 %u"), n);
                break;
            }
            switch ((pid = fork())) {
            case -1:
                mesg(r->flags, DE("fork %u"), n);
                break;
            case 0: {
                size_t q, d, i;
                int k;
            ;   q = c->clust;
            ;   d = MULAR_NEXT(r->cnf->cluster);
            ;   if  (n + 1 < d) {
            ;       if  (!(c = mular_getix(r->cnf->cluster, n + 1))) {
            ;           mesg(r->flags, DE("mular_getix cluster #2 %u"), n);
            ;           break;
            ;       }
            ;       d = c->clust;
            ;   }
            ;   ifBLIN_QV3(r->flags) fprintf(stderr, "%"BLIN_U"E %"BLIN_U" %"BLIN_U"\n", n, q, d);
            ;   for (; q < d; q++) {
            ;       if  (!(p = mular_getix(r->cnf->reaction, q))) {
            ;           mesg(r->flags, DE("mular_getix reaction #1 %u"), q);
            ;           break;
            ;       }
            ;       ifBLIN_QV4(r->flags) {
            ;           for (i = 0; i < (*p)->argc; i++)
                            fprintf(stderr, "%"BLIN_U"[%"BLIN_D"]%s~\n", n, i, (*p)->argv[i]);
            ;       }
            ;       if  (babolo_testword(&react, (*p)->argv[1]) == E_FILE) {
            ;           if  ((pid = vforkexec(&((*p)->argv[1]))) < 0) {
                            ifBLIN_QV1(r->flags) warn("vfork %"BLIN_U" %"BLIN_U"\n", n, q);
            ;           } else if (babolo_testword(&react, (*p)->argv[0]) == E_ZERO) {
            ;               ifBLIN_QV4(r->flags)
                                fprintf(stderr, "exit v %d %d\n", pid, waitpid(pid, &status, 0));
            ;           }
            ;       } else if (babolo_testword(&react, (*p)->argv[1]) == E_WAIT) {
            ;           for (k = 1; k;) {
            ;               pid = wait(&status);
            ;               ifBLIN_QV3(r->flags) fprintf(stderr, "exit v %d %08X\n", pid, status);
            ;               if  ((pid < 0) && (errno != EINTR)) k = 0;
            ;           }
            ;       } else {
            ;           mesg(r->flags | POPUSH_ERX, DE("unknown %s~"), (*p)->argv[1]);
            ;   }   }
            ;   _exit(0);
            }
            default:
                c->pid = pid;
                ifBLIN_QV3(r->flags) fprintf(stderr, "fork %d\n", pid);
    }   }   }
    for (n = 0; n < MULAR_NEXT(r->cnf->cluster); n++) {
        if  (!(c = mular_getix(r->cnf->cluster, n))) {
            mesg(r->flags, DE("mular_getix cluster #3 %u"), n);
        } else if (c->pid) {
            pid = waitpid(c->pid, &status, 0);
            ifBLIN_QV3(r->flags) fprintf(stderr, "exit %d %d\n", c->pid, pid);
            c->pid = 0;
    }   }
    bzero(r->actionbit, (n + 7) >> 3);
    ifBLIN_QV2(r->flags) fprintf(stderr, "-execevent\n");
}
