/*-
 * Copyright (C)2007..2019 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2007..2019 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: bits.c,v 1.7 2019/09/02 17:12:24 babolo Exp $\n"

#define MIFE_COMPAT  3
#define MIFE_COMPAT  3
#define Bpars_COMPAT 4
#define MULAR_COMPAT 0

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "popushd.h"

u_char *
createbit(size_t n) {
    return(calloc((n + 7) >> 3, 1));
}

void
set(u_char *b, size_t n) {
    size_t i = n >> 3;
    u_char j = 1 << (n & 7);
    b[i] |= j;
}

void
bitset(u_char *b, u_char *c, size_t n) {
    size_t i, l = (n + 7) >> 3;
    for (i = 0; i < l; i++) b[i] |= c[i];
}

void
setact(popush_main *r, size_t a) {
    u_char *clusterbit;

    if  (!(clusterbit = mular_getix(r->cnf->ask, a))) {
        mesg(r->flags, DE("mular_getix setaction %u"), a);
    } else {
        bitset(r->actionbit, clusterbit, MULAR_NEXT(r->cnf->cluster));
}   }

void
setaction(popush_main *r, size_t a) {
    if  (a) setact(r, a);
}
