/*-
 * Copyright (C)2021 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2021 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: pgoblin5json.c,v 1.4 2021/06/20 15:21:46 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define RECOBE_COMPAT    5
#define PGOBLIN_COMPAT   3
#define PGOBLIN_INTERNAL 1
#define PGOBLIN_MODULE   pgoblin_module

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <babolo/recobe.h>
#include <multilar.h>
#include <mife.h>
#include <pgoblin.h>
#include "pgoblin5json.h"

static int
/*****************************************************************************************************
 **                                                                                                 **/
clear(pgoblin_styreg *reg_style) {                                                                 /**
 **                                                                                                 **
 *****************************************************************************************************/
#   define blin_internal_flags ((reg_style ? reg_style->flags : pgoblin_default) & BLIN_MASK)
    int                ex = EX_OK;
    style_json_style  *st;
    style_json_clause *ct;

    ifBLIN_QX3("+ %"BLIN_X, BLIN_I(reg_style));
    if  (!!reg_style) {
        if  ((st = reg_style->style)) {
            if  (!!strncmp(st->id, PGOBLIN_STYLE_ID, strlen(PGOBLIN_STYLE_ID))) {
                ifBLIN_QX0("Illegal style %s", st->id);
                ERROUT(EX_DATAERR, EINVAL);
            }
            if  ((st->flags & PGOBLIN_NTBSZMK) != PGOBLIN_NTBSIZE) {
                ifBLIN_QX0("Illegal style size %d", st->flags & PGOBLIN_NTBSZMK);
                ERROUT(EX_DATAERR, EINVAL);
            }
            if  (st->clause) {
                for (size_t i = 0; i < MULAR_NEXT(st->clause); ++i) {
                    ct = mular_getix(st->clause, i);
                    if  (STYLE_JSON_SVALL & ct->flause) free(ct->vtext);
                }
                mular_destroy(st->clause);
            }
            if  (st->chain) recobe_close(st->chain);
            free(st);
            st = NULL;
            reg_style->flags &= ~PGOBLIN_STYLE_TYPE;
    }   }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
 **                                                                                                 **/
init(u_int32_t flags) {                                                                            /**
 **                                                                                                 **
 *****************************************************************************************************/
    return(0);
}

static int
/*****************************************************************************************************
 **                                                                                                 **/
fini() {                                                                                           /**
 **                                                                                                 **
 *****************************************************************************************************/
    return(0);
}

pgoblin_styles PGOBLIN_MODULE =
{ 0
, "5pGoblin-" VERS
, "json\0" VERS
, 0
, init
, fini
, style_json_parser
, style_json_dump
, clear
, NULL //get
, style_json_tbl
, NULL
, NULL
, NULL
, NULL
};
