/*-
 * Copyright (C)2021 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2021 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: parser.c,v 1.11 2021/07/25 02:02:21 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define RECOBE_COMPAT    5
#define PGOBLIN_COMPAT   3
#define PGOBLIN_INTERNAL 1
#define PGOBLIN_MODULE   pgoblin_module

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <babolo/recobe.h>
#include <multilar.h>
#include <mife.h>
#include <pgoblin.h>
#include "pgoblin5json.h"
#include "value.h"

typedef struct cxtunit {
    u_int32_t         flags;
#   define            STYLE_JSON_SQOND    0x000100  /*                          */
#   define            STYLE_JSON_CNTAR    0x002000  /*  A  S                            */
    u_int32_t         line;
} cxtunit;

static size_t sz[3] = {256, 512, 512};
static size_t sx[3] = {512, 512, 512};

static int
/*****************************************************************************************************
 **                                                                                                 **/
deid(BLIN_flag flags, char *text) {                                                                /**
 **                                                                                                 **
 *****************************************************************************************************/
#   define blin_internal_flags flags
    u_int              literal;         /*              */
    int                code;
    u_int              tlen    = strlen(text);
    int                ex      = EX_OK; /*                                                */

    
    ifBLIN_QX3("+ %08X %"BLIN_X"[%u]=%s~", flags, BLIN_I(text), tlen, text);
    literal = 0;
    code = 0;
    for ( u_int i = ((STYLE_JSON_QUOT & flags) ? 1 : 0)
        ; i < (tlen - ((STYLE_JSON_QUOT & flags) ? 1 : 0))
        ; ++i
        ) {
        if  (!!code) {
            switch(text[i]) {
            case '\\': text[literal++] = '\\'   ; break;
            case '"':  text[literal++] = '"'    ; break;
            case 'b':  text[literal++] = '\b'   ; break;
            case 'f':  text[literal++] = '\f'   ; break;
            case 'n':  text[literal++] = '\n'   ; break;
            case 'r':  text[literal++] = '\r'   ; break;
            case 't':  text[literal++] = '\t'   ; break;
        /*  case 'v':  text[literal++] = '\v'   ; break; */
            case 'u':  text[literal++] = '\\'   ; /* FALLTHROUGH */
            default :  text[literal++] = text[i];
            }
            code = 0;
        } else if ('\\' == text[i]) {
            ++code;
        } else if (literal != i) {
             text[literal++] = text[i];
        } else {
             ++literal;
    }   }
    text[literal++] = '\0';
    if  (!!code) {
        ifBLIN_QX1("Escape at end");
        ex = EX_DATAERR;
    }
    ifBLIN_QX3("- %d=%s~", ex, text);
    return(ex);
#   undef blin_internal_flags
}

int
/*****************************************************************************************************
 *****************************************************************************************************
 ****                                                                                             ****/
style_json_parser(pgoblin_styreg *reg_style, u_char *in) {                                       /****
 ****                                                                                             ****
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags ((reg_style ? reg_style->flags : pgoblin_default) & BLIN_MASK)
#   define             ST     ((style_json_style *)(reg_style->style))
    int                lfcount;         /*                                               */
    mular_descriptor  *cxtclet;         /*                                        */
    cxtunit           *cxtnow;          /*                                            */
    int                level;           /*                                             */
    char              *inn;             /* char   u_char in                                */
    int                ex      = EX_OK; /*                                                */
    int                e;

    if  (!in) {
        ifBLIN_QX0("No pgoblin style");
        ERROUT(EX_DATAERR, EINVAL);
    }
    ifBLIN_QX3("+ %"BLIN_X, BLIN_I(in));
    inn = (char *)in;
    if  (!ST) {
        if  (!(reg_style->style = calloc(1, sizeof(style_json_style)))) {
            ifBLIN_QX0("No memory #1");
            ERROUT(EX_OSERR, ENOMEM);
        }
        strncpy(ST->id, PGOBLIN_STYLE_ID, strlen(PGOBLIN_STYLE_ID));
        ST->flags |= blin_internal_flags | PGOBLIN_NTBSIZE;
        ST->loop = 0xFFFFFFFF;
    } else {
        if  (!!strncmp(ST->id, PGOBLIN_STYLE_ID, strlen(PGOBLIN_STYLE_ID))) {
            ifBLIN_QX0("Illegal style %s", ST->id);
            ERROUT(EX_DATAERR, EINVAL);
        }
        if  ((ST->flags & PGOBLIN_NTBSZMK) != PGOBLIN_NTBSIZE) {
            ifBLIN_QX0("Illegal style size %d", ST->flags & PGOBLIN_NTBSZMK);
            ERROUT(EX_DATAERR, EINVAL);
    }   }
    if  (!ST->clause) {
        ST->clause = mular_create( MULAR_HEXU | MULAR_ZERO | MULAR_OBJ
                                 , 3
                                 , sizeof(style_json_clause)
                                 , sz
                                 );
        if  (!ST->clause) {
            ifBLIN_QX0("mular_create");
            ex = EX_OSERR;
            goto out;
    }   }
    if  (0 > (lfcount = style_json_flags(ST, &inn))) {
        ifBLIN_QW0("style_json_parser");
        goto out;
    }
    level = ST->lemax = ST->level;
    if  (!(cxtclet = mular_create( MULAR_HEXU | MULAR_OBJ, 3, sizeof(cxtunit), sx))) {
        ifBLIN_QX0("mular_create");
        ex = EX_OSERR;
        goto out;
    }
    for (int i = 0; (int)MULAR_NEXT(cxtclet) <= level; ++i) {
        if  (!(cxtnow = mular_add(cxtclet))) {
            ifBLIN_QX0("mular_add %d", i);
            ex = EX_CANTCREAT;
            goto out;
    }   }
    cxtnow->flags = ST->flags & STYLE_JSON_CNTAR;
    cxtnow->line = 0;
    for (int line = 1; !!*inn; ++line) {
        style_json_term t[4];

        ifBLIN_QX5("%"BLIN_X, BLIN_I(inn));
        bzero(t, 4 * sizeof(style_json_term));
        for (int i = 0; i < 4; ++i) {
            t[i].flterm |= blin_internal_flags;
        ;   ifBLIN_QX6("%"BLIN_X, BLIN_I(inn));
        ;   inn += strspn(inn, "\r\t,: ");
        ;   ifBLIN_QX6("%02X %"BLIN_X, *inn, BLIN_I(inn));
        ;   if  (*inn == '\n') {
        ;       ++inn;
        ;       lfcount++;
        ;       break;
        ;   }
        ;   in = (u_char *)inn;
        ;   if  (!(inn = style_json_geterm(&t[i], in))) {
        ;       ifBLIN_QX0("Ill term %d @%d", i, lfcount);
        ;       ex = EX_DATAERR;
        ;       goto out;
        ;   }
        ;   ifBLIN_QX4( "%d %d %08X %u [%u]%.*s~"
                      , line
                      , i
                      , t[i].flterm
                      , t[i].nuterm
                      , t[i].nutext
                      , t[i].txterm ? t[i].nutext : 1
                      , t[i].txterm ? (char *)t[i].txterm : "~"
                      );
            if  (STYLE_JSON_DONE & ~t[i].flterm) break;
        }
        if  (STYLE_JSON_DONE & t[0].flterm) {
            style_json_clause *clau;
        ;   int                i       = 0;

        ;   if  (!(clau = mular_add(ST->clause))) {
        ;       ifBLIN_QX0("mular_add");
        ;       ex = EX_OSERR;
        ;       goto out;
        ;   }
        ;   if  ((STYLE_JSON_OBJC & t[i].flterm) && !(STYLE_JSON_OPEN & t[i].flterm)) {
        ;       /*      */
        ;       if  (!!i) {
        ;           ifBLIN_QX1("Line %d: Obj close not first", line);
        ;           ex = EX_DATAERR;
        ;           errno = EINVAL;
        ;       }
        ;       clau->flause |= (STYLE_JSON_STRU & t[i].flterm) ? STYLE_JSON_CSTR : STYLE_JSON_CARR;
        ;       if  (!(cxtnow = mular_getix(cxtclet, --level))) {
        ;           ifBLIN_QX0("mular_getix");
        ;           ex = EX_SOFTWARE;
        ;           goto out;
        ;       }
        ;       ifBLIN_QX4("[{}] %d %d %08X %d", line, i, clau->flause, level);
        ;       goto ctl;
        ;   } else if (STYLE_JSON_COND & t[i].flterm) {
        ;       /*  */
        ;       clau->flause |= STYLE_JSON_SQOND;
        ;       if  (STYLE_JSON_NUMR & t[i].flterm) {
        ;           clau->qnum = t[i].nuterm;
        ;           clau->flause |= STYLE_JSON_SQNUM;
        ;       } else if (STYLE_JSON_WORD & t[i].flterm) {
        ;           clau->flause |= STYLE_JSON_SQEXT;
        ;           clau->qname = t[i].txterm;
        ;           t[i].txterm[t[i].nutext] = '\0';
        ;       } else if (STYLE_JSON_QUOT & t[i].flterm) {
        ;           clau->flause |= STYLE_JSON_SQEXT | STYLE_JSON_SQQUO;
        ;           clau->qname = t[i].txterm;
        ;           t[i].txterm[t[i].nutext] = '\0';
        ;       } else if ( (STYLE_JSON_REFR | STYLE_JSON_TYPE | STYLE_JSON_OBJM | STYLE_JSON_MODE)
                          & t[i].flterm
                          ) {
        ;           ifBLIN_QX1("Line %d: This not allowed for ?", line);
        ;           ex = EX_DATAERR;
        ;           errno = EINVAL;
        ;       }
        ;       if  (STYLE_JSON_SQNUM & clau->flause) {
        ;           ifBLIN_QX4("Q %d %d %08X %u", line, i, clau->flause, clau->qnum);
        ;       } else if (STYLE_JSON_SQEXT & clau->flause) {
        ;           ifBLIN_QX4("Q %d %d %08X =%s~", line, i, clau->flause, clau->qname);
        ;       } else {
        ;           ifBLIN_QX4("Q %d %d %08X", line, i, clau->flause);
        ;       }
        ;       ++i;
        ;   }
        ;   if  (!(STYLE_JSON_DONE & t[i].flterm)) goto ctl;
        ;   if  (  !(STYLE_JSON_CNTAR & cxtnow->flags)
                && ( (STYLE_JSON_NUMR | STYLE_JSON_WORD | STYLE_JSON_REFR | STYLE_JSON_QUOT)
                   & t[i].flterm
                )  ) {
        ;       /*  ,   A   */
        ;       if  (STYLE_JSON_REFR & t[i].flterm) clau->flause |= STYLE_JSON_SRREF;
        ;       if  (STYLE_JSON_NUMR & t[i].flterm) {
        ;           clau->rnum = t[i].nuterm;
        ;           clau->flause |= STYLE_JSON_SRNUM;
        ;       } else if ((STYLE_JSON_WORD | STYLE_JSON_QUOT) & t[i].flterm) {
        ;           clau->flause |= STYLE_JSON_SREXT;
        ;           if  (STYLE_JSON_QUOT & t[i].flterm) clau->flause |= STYLE_JSON_SRQUO;
        ;           clau->rname = t[i].txterm;
        ;           t[i].txterm[t[i].nutext] = '\0';
        ;       } else {
        ;           ifBLIN_QX1("Line %d: This not allowed for name", line);
        ;           ex = EX_DATAERR;
        ;           errno = EINVAL;
        ;       }
        ;       if  (STYLE_JSON_SRNUM & clau->flause) {
        ;           ifBLIN_QX4("R %d %d %08X %u", line, i, clau->flause, clau->rnum);
        ;       } else if (STYLE_JSON_SREXT & clau->flause) {
        ;           ifBLIN_QX4("R %d %d %08X =%s~", line, i, clau->flause, clau->rname);
        ;       } else {
        ;           ifBLIN_QX4("R %d %d %08X", line, i, clau->flause);
        ;       }
        ;       ++i;
        ;   }
        ;   if  (!(STYLE_JSON_DONE & t[i].flterm)) goto ctl;
        ;   if  ((STYLE_JSON_OBJC & t[i].flterm) && (STYLE_JSON_OPEN & t[i].flterm)) {
        ;       /*   */
        ;       clau->flause |= (STYLE_JSON_STRU & t[i].flterm) ? STYLE_JSON_MSTR : STYLE_JSON_MARR;
        ;       ifBLIN_QX4("[{}] %d %08X %d", i, clau->flause, level);
        ;       if  (  !(STYLE_JSON_CNTAR & cxtnow->flags)
                    && !(STYLE_JSON_SRMSK & clau->flause)
                    && (0 < level)
                    ) {
        ;           ifBLIN_QX1( "Line %d: Object without name not allowed at struct level %d"
                              , line
                              , level - 1
                              );
        ;           ex = EX_DATAERR;
        ;           errno = EINVAL;
        ;       }
        ;       ++level;
        ;       if  (ST->lemax < level) ST->lemax = level;
        ;       if  (  !(cxtnow = mular_getix(cxtclet, level))
                    && !(cxtnow = mular_insert(cxtclet, level))
                    ) {
        ;           ifBLIN_QX0("mular_insert");
        ;           ex = EX_SOFTWARE;
        ;           goto out;
        ;       }
        ;       cxtnow->line = line;
        ;       cxtnow->flags = (STYLE_JSON_MARR & clau->flause) ? STYLE_JSON_CNTAR : 0;
        ;       if  (!((STYLE_JSON_SQEXT | STYLE_JSON_SQNUM) & clau->flause)) {
        ;           cxtnow->flags |= (STYLE_JSON_SQOND & clau->flause);
        ;       }
        ;       ++i;
        ;   } else if (STYLE_JSON_MODE & t[i].flterm) {
        ;       if  (STYLE_JSON_REFR & t[i].flterm) {
        ;           clau->flause |= STYLE_JSON_SVREF;
        ;           if  (STYLE_JSON_NUMR & t[i].flterm) {
        ;               clau->vnum = t[i].nuterm;
        ;               clau->flause |= STYLE_JSON_SVNUM;
        ;           } else if ((STYLE_JSON_WORD | STYLE_JSON_QUOT) & t[i].flterm) {
        ;               clau->flause |= STYLE_JSON_SVEXT;
        ;               if  (STYLE_JSON_QUOT & t[i].flterm) clau->flause |= STYLE_JSON_SQUOT;
        ;               clau->vname = t[i].txterm;
        ;               t[i].txterm[t[i].nutext] = '\0';
        ;           } else {
        ;               ifBLIN_QX1("Line %d: This not allowed for name", line);
        ;               ex = EX_DATAERR;
        ;               errno = EINVAL;
        ;           }
        ;       } else if ((STYLE_JSON_NUMR | STYLE_JSON_MISC) & t[i].flterm) {
        ;           clau->flause |= STYLE_JSON_SVVAL;
        ;           if  (STYLE_JSON_QUOT & t[i].flterm) clau->flause |= STYLE_JSON_SQUOT;
        ;           clau->vname = t[i].txterm;
        ;           t[i].txterm[t[i].nutext] = '\0';
        ;       } else if ((STYLE_JSON_WORD & t[i].flterm) && !(STYLE_JSON_QUOT & t[i].flterm)) {
        ;           t[i].txterm[t[i].nutext] = '\0';
        ;           if  (!!babolo_testword(&value, (char *)t[i].txterm)) {
        ;               clau->flause |= STYLE_JSON_SVVAL;
        ;               clau->vname = t[i].txterm;
        ;           } else {
        ;               ifBLIN_QX1("Line %d: No value text", line);
        ;               ex = EX_DATAERR;
        ;               errno = EINVAL;
        ;           }
        ;       } else {
        ;           ifBLIN_QX1("Line %d: No value text", line);
        ;           ex = EX_DATAERR;
        ;           errno = EINVAL;
        ;       }
        ;       if  (STYLE_JSON_SVNUM & clau->flause) {
        ;           ifBLIN_QX4("V %d %d %08X %u", line, i, clau->flause, clau->vnum);
        ;       } else if ((STYLE_JSON_SVEXT | STYLE_JSON_SVVAL) & clau->flause) {
        ;           ifBLIN_QX4("V %d %d %08X =%s~", line, i, clau->flause, clau->vname);
        ;       } else {
        ;           ifBLIN_QX4("V %d %d %08X", line, i, clau->flause);
        ;       }
        ;       ++i;
        ;   }
        ;   if  (!(STYLE_JSON_DONE & t[i].flterm)) goto ctl;
        ;   if  (STYLE_JSON_TYPE & t[i].flterm) {
        ;       clau->flause |= (STYLE_JSON_TYPE & t[i].flterm);
        ;       ifBLIN_QX4("# %d %d %08X", line, i, clau->flause);
        ;   }
        ;   if  (STYLE_JSON_LOOP & t[i].flterm) {
        ;       if  (0xFFFFFFFF == ST->loop) {
        ;           ST->loop = MULAR_NEXT(ST->clause) - 1;
        ;       } else {
        ;           ifBLIN_QX1("Line %d: Loop symbol repete, previous at line %u", line, ST->loop);
            }   }
        ctl:
            ifBLIN_QX4( "%08X %d %"BLIN_X"=%s~ %d %"BLIN_X"=%s~ %d %"BLIN_X"=%s~"
                      , clau->flause
                      , clau->qnum
                      , clau->qtext
                      , (STYLE_JSON_SQEXT & clau->flause) ? clau->qtext : ""
                      , clau->rnum
                      , clau->rtext
                      , (STYLE_JSON_SREXT & clau->flause) ? clau->rtext : ""
                      , clau->vnum
                      , clau->vtext
                      , (STYLE_JSON_SVEXT & clau->flause) ? clau->vtext : ""
                      );
        ;   if  (  (STYLE_JSON_SQOND & clau->flause)
                && (STYLE_JSON_SQEXT & clau->flause)
                ) {
        ;       /* ?Q     */
        ;       if  (!!(e = deid( (blin_internal_flags & BLIN_MASK)
                                | ((STYLE_JSON_SQQUO & clau->flause) ? STYLE_JSON_QUOT : 0)
                                , clau->qtext
                    )  )        ) {
        ;           ifBLIN_QX1("Line %d: Ill column name=%s~ in condition", line, clau->qtext);
        ;           ex = e;
        ;       }
        ;       clau->flause &= ~STYLE_JSON_SQQUO;
        ;       ifBLIN_QX3("%08X %s~", clau->flause, clau->qtext);
        ;   }
        ;   if  ((STYLE_JSON_SREXT & clau->flause) && (STYLE_JSON_SRREF & clau->flause)) {
        ;       /*                               ****/
        ;       if  (!!(e = deid( (blin_internal_flags & BLIN_MASK)
                                | ((STYLE_JSON_SRQUO & clau->flause) ? STYLE_JSON_QUOT : 0)
                                , clau->rtext
                    )  )        ) {
        ;           ifBLIN_QX1("Line %d: Ill column name=%s~ in name", line, clau->rtext);
        ;           ex = e;
        ;       }
        ;       clau->flause &= ~STYLE_JSON_SRQUO;
        ;       ifBLIN_QX3("%08X %s~", clau->flause, clau->rtext);
        ;   }
        ;   if  (  !(STYLE_JSON_CNTAR & cxtnow->flags)
                && !(STYLE_JSON_SRREF & clau->flause)
                && !((STYLE_JSON_SVMSK | STYLE_JSON_MMSK) & clau->flause)
                && ((STYLE_JSON_SREXT | STYLE_JSON_SRNUM) & clau->flause)
                ) {
        ;       if  (STYLE_JSON_SREXT & clau->flause) {
        ;           /*                                        ****/
        ;           if  (!(clau->vtext = strdup(clau->rtext))) {
        ;               ifBLIN_QW0("strdup");
        ;               ex = EX_OSERR;
        ;               goto out;
        ;           }
        ;           clau->flause |= ((clau->flause << 4) & STYLE_JSON_SQUOT);
        ;                                                                 /*    R  V */
        ;           clau->flause |= STYLE_JSON_SVEXT | STYLE_JSON_SVALL | STYLE_JSON_SVREF;
        ;       }
        ;       if  (STYLE_JSON_SRNUM & clau->flause) {
        ;           clau->vnum = clau->rnum;
        ;           clau->flause |= STYLE_JSON_SVREF | STYLE_JSON_SVNUM;
        ;       }
        ;       ifBLIN_QX3("%08X %s~ %d", clau->flause, clau->vtext, clau->vnum);
        ;   }
        ;   if  (  (STYLE_JSON_SVREF & clau->flause)
                && (STYLE_JSON_SVEXT & clau->flause)
                ) {
        ;       /*                               ****/
        ;       if  (!!(e = deid( (blin_internal_flags & BLIN_MASK)
                                | ((STYLE_JSON_SQUOT & clau->flause) ? STYLE_JSON_QUOT : 0)
                                , clau->vtext
                    )  )        ) {
        ;           ifBLIN_QX1("Line %d: Ill column name=%s~ in value", line, clau->vtext);
        ;           ex = e;
        ;       }
        ;       clau->flause &= ~STYLE_JSON_SQUOT;
        ;       ifBLIN_QX3("%08X %s~", clau->flause, clau->vtext);
        ;   }
        ;   if  ((STYLE_JSON_MCLO & clau->flause) && (STYLE_JSON_TYPE & clau->flause)) {
        ;       ifBLIN_QX1("Line %d: No type allowed with structure or array close", line);
        ;       ex = EX_DATAERR;
        ;       errno = EINVAL;
        ;   }
        ;   if  (  !(STYLE_JSON_CNTAR & cxtnow->flags)
                && !(STYLE_JSON_SRMSK & clau->flause)
                && (STYLE_JSON_SVMSK & clau->flause)
                && (0 < level)
                ) {
        ;       ifBLIN_QX1("Line %d: Value without name not allowed at struct level %d", line, level);
        ;       ex = EX_DATAERR;
                errno = EINVAL;
    }   }   }
out:
    ifBLIN_QO2 style_json_dump(reg_style);
    if  (!!ex) {
        if  (!!ST->clause) mular_destroy(ST->clause);
        free(reg_style->style);
        reg_style->style = NULL;
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
#   undef  ST
}
