/*-
 * Copyright (C)2021 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2021 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: out.c,v 1.19 2021/07/31 08:59:34 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define RECOBE_COMPAT    5
#define PGOBLIN_COMPAT   3
#define PGOBLIN_INTERNAL 1
#define PGOBLIN_MODULE   pgoblin_module

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <babolo/recobe.h>
#include <multilar.h>
#include <mife.h>
#include <pgoblin.h>
#include "pgoblin5json.h"

#define Nq  0x01             /*  NULL  Q                                 */
#define Nr  0x02             /*  NULL  R                                 */
#define Nv  0x04             /*  NULL  V                                 */
#define No  0x08             /*                                           */
#define Ob  0x10             /*                                */
#define Oa  (1 * Ob)         /* 0x10 ,                       */
#define Oc  (2 * Ob)         /* 0x20 ,                           */
#define Or  (4 * Ob)         /* 0x40                                       */
#define Oos (0 * Ob)         /* 0x00                              */
#define Ooa (Oa)             /* 0x10                                */
#define Ocs (Oc)             /* 0x20                               */
#define Oca (Oc | Oa)        /* 0x30                                 */

#define Cc 0x000100   /*                         */
#define Cs 0x000200   /*  ,           */
#define Cz 0x000400   /*  ,                            */
#define Cn 0x000800   /*                               */
#define Co 0x001000   /*                         */
#define Ct 0x002000   /*                                    */
#define C0 0x004000   /*  {                                          */
#define C1 0x008000   /*  [                                          */
#define C2 0x010000   /*  }                                          */
#define C3 0x020000   /*  ]                                          */
#define C4 0x040000   /*                                      */

static const char spaces[] = "                                                                ";

typedef struct stapair {
    u_int32_t   cxtflg;
#   define            STYLE_JSON_BOOL     0x000010  /*   bool                              */
#   define            STYLE_JSON_TINT     0x000020  /*                                */
#   define            STYLE_JSON_TEXT     0x000030  /*   text                              */
#   define            STYLE_JSON_TYPE   ( STYLE_JSON_BOOL | STYLE_JSON_TINT | STYLE_JSON_TEXT )
#   define            STYLE_JSON_SQOND    0x000100  /*                          */
#   define            STYLE_JSON_SRREF    0x001000  /* @                                             */
#   define            STYLE_JSON_CNTAR    0x002000  /*  A  S                            */
#   define            STYLE_JSON_SRQUO    0x008000  /*                                      */
#   define            STYLE_JSON_NONEN    0x400000  /*                                        */
#   define            STYLE_JSON_CNTOM    0x800000  /*     level > 0              */
    u_int32_t   oln;                                /*                           */
    const char *onm;                                /*                                  */
} stapair;

static const u_int32_t automa[5 * Ob] =
{    Cs|Cn|Co|   C0  /* 00 Oos */
,          Co        /* 01 */
,    Cs|Cn|Co|   C0  /* 02 */
,          Co        /* 03 */
,    Cs|Cn|Co|   C0  /* 04 */
,          Co        /* 05 */
,    Cs|Cn|Co|   C0  /* 06 */
,          Co        /* 07 */
,          Co        /* 08 */
,          Co        /* 09 */
,          Co        /* 0A */
,          Co        /* 0B */
,          Co        /* 0C */
,          Co        /* 0D */
,          Co        /* 0E */
,          Co        /* 0F */
,    Cs|Cn|Co|   C1  /* 10 Ooa */
,          Co        /* 11 */
,    Cs|Cn|Co|   C1  /* 12 */
,          Co        /* 13 */
,    Cs|Cn|Co|   C1  /* 14 */
,          Co        /* 15 */
,    Cs|Cn|Co|   C1  /* 16 */
,          Co        /* 17 */
,          Co        /* 18 */
,          Co        /* 19 */
,          Co        /* 1A */
,          Co        /* 1B */
,          Co        /* 1C */
,          Co        /* 1D */
,          Co        /* 1E */
,          Co        /* 1F */
, Cc|Cz|         C2  /* 20 Ocs */
, Cc                 /* 21 */
, Cc|Cz|         C2  /* 22 */
, Cc                 /* 23 */
, Cc|Cz|         C2  /* 24 */
, Cc                 /* 25 */
, Cc|Cz|         C2  /* 26 */
, Cc                 /* 27 */
, Cc                 /* 28 */
, Cc                 /* 29 */
, Cc                 /* 2A */
, Cc                 /* 2B */
, Cc                 /* 2C */
, Cc                 /* 2D */
, Cc                 /* 2E */
, Cc                 /* 2F */
, Cc|Cz|         C3  /* 30 Oca */
, Cc                 /* 31 */
, Cc|Cz|         C3  /* 32 */
, Cc                 /* 33 */
, Cc|Cz|         C3  /* 34 */
, Cc                 /* 35 */
, Cc|Cz|         C3  /* 36 */
, Cc                 /* 37 */
, Cc                 /* 38 */
, Cc                 /* 39 */
, Cc                 /* 3A */
, Cc                 /* 3B */
, Cc                 /* 3C */
, Cc                 /* 3D */
, Cc                 /* 3E */
, Cc                 /* 3F */
,    Cs|Cn|   Ct|C4  /* 40 Or */
,                 0  /* 41 */
,    Cs|Cn|   Ct|C4  /* 42 */
,                 0  /* 43 */
,    Cs|Cn|   Ct|C4  /* 44 */
,                 0  /* 45 */
,    Cs|Cn|   Ct|C4  /* 46 */
,                 0  /* 47 */
,                 0  /* 48 */
,                 0  /* 49 */
,                 0  /* 4A */
,                 0  /* 4B */
,                 0  /* 4C */
,                 0  /* 4D */
,                 0  /* 4E */
,                 0  /* 4F */
};

static void
/*****************************************************************************************************
 ****                                                                      ****
 *****************************************************************************************************
 ****                                                                                             ****/
wr(style_json_style *st, pgoblin_io *reg_out, void *what, size_t howmach) {                      /****
 ****                                                                                             ****
 *****************************************************************************************************/
#   define blin_internal_flags ((reg_style ? reg_style->flags : pgoblin_default) & BLIN_MASK)
    if  (!!st->shift) {
        reg_out->wri(reg_out->onu, what, howmach);
    } else if (1 < howmach) {
        reg_out->wri(reg_out->onu, what, howmach - 1);
    }
#   undef blin_internal_flags
}

static u_int32_t
/*****************************************************************************************************
 ****                                                                             ****
 *****************************************************************************************************
 ****                                                                                             ****/
nametonum(char *text, pgoblin_mode *pq, int coded) {                                             /****
 ****                                                                                             ****
 *****************************************************************************************************/
#   define blin_internal_flags (*((BLIN_flag*)pq) & BLIN_MASK)
    u_int32_t  ex = 0xFFFFFFFF;
    char      *t;
    int        n;

    ifBLIN_QX3("+ %d %"BLIN_X"=%s~", coded, text, text);
    if  (!coded) {
        t = text;
    } else if (!(t = strdup(text))) {
        ifBLIN_QW0("strdup");
        goto out;
    } else {
        for (int i = 0, j = 0; !!t[i]; ) {
            switch(t[i]) {
            case 0   :
                t[j++] = 0;
                break;
            case '\\':
                switch(t[++i]) {
                case '"' : t[j++] = '"' ; break;
                case '\\': t[j++] = '\\'; break;
                case 'b' : t[j++] = '\b'; break;
                case 'f' : t[j++] = '\f'; break;
                case 'n' : t[j++] = '\n'; break;
                case 'r' : t[j++] = '\r'; break;
                case 't' : t[j++] = '\t'; break;
                default  : t[j++] = '\\';
                           t[j++] = t[i]; break;
                }
                ++i;
                break;
            default  :
                t[j++] = t[i++];
    }   }   }
    n = pgoblin_db_resinfo(PGOBLIN_Nfields, pq);
    for (int k = 0; k < n; ++k) {
        const char *reanm = pgoblin_db_subinfo(PGOBLIN_ColName, pq, k);

        if  (!!reanm && !strcmp(t, reanm)) {
            ex = k;
            goto out;
    }   }
out:
    if  (!!coded) free(t);
    ifBLIN_QX3("- %u", ex);
    return(ex);
#   undef blin_internal_flags
}

static void
/*****************************************************************************************************
 ****                                        ****
 *****************************************************************************************************
 ****                                                                                             ****/
doshift(pgoblin_io *reg_out, int level, u_int8_t shift, int comma) {                             /****
 ****                                                                                             ****
 *****************************************************************************************************/
    if  (!comma) {
        if  (!!shift) for (int i = 0; i < level; ++i) reg_out->wri(reg_out->onu, spaces, shift);
    } else {
        if  ((1 < level) && !!shift) {
            for (int i = 1; i < level; ++i) reg_out->wri(reg_out->onu, spaces, shift);
        }
        if  (!!level) {
            if  (1 < shift) {
                reg_out->wri(reg_out->onu, ",", 1);
                reg_out->wri(reg_out->onu, spaces, shift - 1);
            } else {
                reg_out->wri(reg_out->onu, ", ", 2);
}   }   }   }

static int
/*****************************************************************************************************
 ****                                                                 ****
 *****************************************************************************************************
 ****                                                                                             ****/
recout(pgoblin_io *reg_out, style_json_style *st, const char *text, size_t length) {             /****
 ****                                                                                             ****
 *****************************************************************************************************/
#   define blin_internal_flags (st->flags & BLIN_MASK)
    recobe_chunk *tout;
    int           ex   = 0;

    ifBLIN_QX3("+ %08X %08X |%.*s~", reg_out->flags, st->flags, (int)length, text);
    if  (!!st->chain0) {
        /* const char *text   recobe_chainarr(..., void *) *
         *  mife_ctlbuff(..., void *, ...),                              *
         *   mife_descriptor-> void *buffer               *
         *    mife  .                         *
         * recobe      ,                    *
         *      .                                    *
         * ,   ,  .              XXXX */
        if  (!(tout = recobe_chainarr(st->chain, length, (void *)text))) {
            ifBLIN_QW0("recobe_chainarr |%.*s~", (int)length, text);
            ex = -EX_SOFTWARE;
            goto out;
        }
        text = (const char *)recobe_chunktext(tout);
        length = recobe_chunksize(tout);
    }
    if  (0 > (ex = reg_out->wri(reg_out->onu, text, length))) {
        ifBLIN_QW0("reg_out->wri |%.*s~", (int)length, text);
        ex = -EX_IOERR;
        goto out;
    } else if (ex != (int)length) {
        ifBLIN_QW0("reg_out->wri %d <> %d", ex, (int)length);
        ex = -EX_PROTOCOL;
        goto out;
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
 ****                                                                  ****
 *****************************************************************************************************
 ****                                                                                             ****/
dolit(pgoblin_io *reg_out, style_json_style *st, const char *text, size_t length, int q) {       /****
 ****                                                                                             ****
 *****************************************************************************************************/
    int     ex = 0;

    if  (!q) reg_out->wri(reg_out->onu, "\"", 1);
    ex = recout(reg_out, st, text, length);
    if  (!q) reg_out->wri(reg_out->onu, "\"", 1);
    if  ((!q) && (0 >= 0)) ex += 2;
    return(ex);
}

static int
/*****************************************************************************************************
 ****                                                                   ****
 *****************************************************************************************************
 ****                                                                                             ****/
doid(pgoblin_io *reg_out, style_json_style *st, const char *text, size_t length) {               /****
 ****                                                                                             ****
 *****************************************************************************************************/
    char   *totx;
    int     p  = 0;

    if  (!(totx = malloc(length * 2 + 3))) {
        ifBLIN_QW0("totx");
        p = -EX_OSERR;
        goto out;
    }
    totx[p++] = '\"';
    for (size_t i = 0; i < length; ++i) {
        switch(text[i]) {
        case '"' : totx[p++] = '\\'; totx[p++] = '\"'; break;
        case '\\': totx[p++] = '\\'; totx[p++] = '\\'; break;
        case '\b': totx[p++] = '\\'; totx[p++] = 'b';  break;
        case '\f': totx[p++] = '\\'; totx[p++] = 'f';  break;
        case '\n': totx[p++] = '\\'; totx[p++] = 'n';  break;
        case '\r': totx[p++] = '\\'; totx[p++] = 'r';  break;
        case '\t': totx[p++] = '\\'; totx[p++] = 't';  break;
        default  : totx[p++] = text[i];                break;
    }   }
    totx[p++] = '\"';
    totx[p] = '\0';
    p = recout(reg_out, st, totx, p);
out:
    return(p);
}

static void
/*****************************************************************************************************
 ****                                      ****
 *****************************************************************************************************
 ****                                                                                             ****/
recond(pgoblin_io *reg_out, style_json_style *st, stapair *cxt, int level) {                     /****
 ****                                                                                             ****
 *****************************************************************************************************/
#   define blin_internal_flags (st->flags & BLIN_MASK)
    int i;

    ifBLIN_QX3("+ %08X %d=%.*s~", cxt[level].cxtflg, level, cxt[level].oln, cxt[level].onm);
    for (i = level; (i >= 0) && (STYLE_JSON_SQOND & cxt[i].cxtflg); --i) {
        ifBLIN_QX3(" %08X %d", cxt[i].cxtflg, i);
    }
    ++i;
    for (; i <= level; ++i) {
        cxt[i].cxtflg &= ~STYLE_JSON_SQOND;
        doshift(reg_out, i - 1, st->shift, STYLE_JSON_CNTOM & cxt[i - 1].cxtflg);
        if  (1 < i) {
            if  (!(STYLE_JSON_CNTAR & cxt[i - 1].cxtflg)) {
                if  (STYLE_JSON_SRREF & cxt[i].cxtflg) {
                    doid(reg_out, st, cxt[i].onm, cxt[i].oln);
                } else {
                    dolit(reg_out, st, cxt[i].onm, cxt[i].oln, STYLE_JSON_SRQUO & cxt[i].cxtflg);
                }
                reg_out->wri(reg_out->onu, " : ", 3);
            }
            if  (STYLE_JSON_CNTAR & cxt[i].cxtflg) {
                wr(st, reg_out, "[\n", 2);
            } else {
                wr(st, reg_out, "{\n", 2);
            }
            if  (0 < level) cxt[level - 1].cxtflg |= STYLE_JSON_CNTOM;
        } else if (STYLE_JSON_CNTAR & cxt[i].cxtflg) {
            wr(st, reg_out, "[\n", 2);
        } else {
            wr(st, reg_out, "{\n", 2);
        }
        ifBLIN_QX3(" %08X %d", cxt[i].cxtflg, i);
    }
    ifBLIN_QX3("-");
#   undef blin_internal_flags
}

int
/*****************************************************************************************************
 *****************************************************************************************************
 ****                                                                                             ****/
style_json_tbl( pgoblin_io     *reg_out                                                          /****/
              , pgoblin_styreg *reg_style                                                        /****/
              , pgoblin_io     *reg_in                                                           /****/
              , ssize_t         low                                                              /****/
              , ssize_t         hig                                                              /****/
              ) {                                                                                /****
 ****                                                                                             ****
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags ((reg_style ? reg_style->flags : pgoblin_default) & BLIN_MASK)
    ssize_t            textlength = 0; /*                                    */
    u_int32_t          control;
    style_json_clause *hlause;
    int                level;           /*                                             */
    int                ntyp;
    u_int32_t          cond;
    int                row;             /*     pq                          */
    stapair           *cxt;             /*                                        */
    pgoblin_mode      *pq         = reg_in->pq;
    int                ex         = 0;
    style_json_style  *st;

    ifBLIN_QX3( "+ %"BLIN_X" %"BLIN_X" %"BLIN_X" [%"BLIN_D",%"BLIN_D"]"
              , reg_out
              , reg_style
              , reg_in
              , low
              , hig
              );
    if  (!reg_style) {
        ifBLIN_QX0("No style");
        ERROUT(EX_DATAERR, EFAULT);
    }
    st = reg_style->style;
    if  (!!strncmp(st->id, PGOBLIN_STYLE_ID, strlen(PGOBLIN_STYLE_ID))) {
        ifBLIN_QX0("Illegal style %s", st->id);
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (0 >= (ntyp = pgoblin_db_resinfo(PGOBLIN_Ntuples, pq))) goto out;
    if  (!(hlause = malloc(MULAR_NEXT(st->clause) * sizeof(style_json_clause)))) {
        ifBLIN_QW0("hlause");
        ex = EX_OSERR;
        goto out;
    }
    level = st->level;
    for (size_t i = 0; i < MULAR_NEXT(st->clause); ++i) {
        bcopy(mular_getix(st->clause, i), &hlause[i], sizeof(style_json_clause));
        switch(STYLE_JSON_MMSK & hlause[i].flause) {
        case STYLE_JSON_MARR:
            ++level;
            if  (i == st->loop) st->loovel = level;
            break;
        case STYLE_JSON_MSTR:
            ++level;
            break;
        case STYLE_JSON_CARR:
            if  ((st->loovel == level) && !st->looe) st->looe = i;
            /* FALLTHROUGH */
        case STYLE_JSON_CSTR:
            --level;
            break;
    }   }
    if  ((st->flags & PGOBLIN_NTBSZMK) != PGOBLIN_NTBSIZE) {
        ifBLIN_QX0("Illegal style size %d", st->flags & PGOBLIN_NTBSZMK);
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (!(cxt = calloc(st->lemax + 1, sizeof(stapair)))) {
        ifBLIN_QW0("cxtflg");
        ex = EX_OSERR;
        goto out;
    }
    row = 0;
    level = st->level;
    cxt[level].cxtflg = (STYLE_JSON_CNTAR | STYLE_JSON_CNTOM) & st->flags;
    ifBLIN_QX2("%d %d %d %d %d", level, st->lemax, st->loop, st->looe, st->loovel);
    for (u_int i = 0; i < MULAR_NEXT(st->clause); ) {
        ifBLIN_QX4(". %08X %d=%.*s~", cxt[level].cxtflg, level, cxt[level].oln, cxt[level].onm);
        if  (!(STYLE_JSON_DONE & hlause[i].flause)) {
            /*      Q, R, V */
        ;   if  (STYLE_JSON_SQEXT & hlause[i].flause) {
        ;       hlause[i].qnum = nametonum(hlause[i].qtext, pq, STYLE_JSON_SQQUO & hlause[i].flause);
        ;       hlause[i].flause |= STYLE_JSON_SQNUM;
        ;   }
        ;   if  (!(STYLE_JSON_MMSK & hlause[i].flause) || (STYLE_JSON_SREXT & hlause[i].flause)) {
        ;       if  (STYLE_JSON_SRNUM & hlause[i].flause) {
        ;           hlause[i].flause &= ~STYLE_JSON_SREXT;
        ;           if  (!(STYLE_JSON_SRREF & hlause[i].flause)) {
        ;               hlause[i].rname = (const u_char *)pgoblin_db_subinfo( PGOBLIN_ColName
                                                                            , pq
                                                                            , hlause[i].rnum
                                                                            );
        ;              if  (!!hlause[i].rname) hlause[i].flause |= STYLE_JSON_SREXT;
        ;           } else if (!pgoblin_db_valinfo(PGOBLIN_IsNull, pq, row, hlause[i].rnum)) {
        ;               hlause[i].rname = (const u_char *)pgoblin_db_getvalue(pq, row, hlause[i].rnum);
        ;               if  (!!hlause[i].rname) hlause[i].flause |= STYLE_JSON_SREXT;
        ;           }
        ;       } else if (STYLE_JSON_SREXT & hlause[i].flause) {
        ;           hlause[i].rnum = nametonum(hlause[i].rtext, pq, STYLE_JSON_SRQUO & hlause[i].flause);
        ;           hlause[i].flause |= STYLE_JSON_SRNUM;
        ;   }   }
        ;   if  ((STYLE_JSON_SVREF & hlause[i].flause) && (STYLE_JSON_SVEXT & hlause[i].flause)) {
        ;       hlause[i].vnum = nametonum(hlause[i].vtext, pq, STYLE_JSON_SQUOT & hlause[i].flause);
        ;       hlause[i].flause |= STYLE_JSON_SVNUM;
        ;   }
            hlause[i].flause |= STYLE_JSON_DONE;
        }
        /*     */
        switch(STYLE_JSON_MMSK & hlause[i].flause) {
        case 0              : cond = Or ; break;
        case STYLE_JSON_MARR: cond = Ooa; break;
        case STYLE_JSON_MSTR: cond = Oos; break;
        case STYLE_JSON_CARR: cond = Oca; break;
        case STYLE_JSON_CSTR: cond = Ocs; break;
        default             :
            ifBLIN_QX0("Illegal mode %u", STYLE_JSON_MMSK & hlause[i].flause);
            ERROUT(EX_DATAERR, EINVAL);
        }
        /*   NULL  Q, R, V  */
        if  (  (!(STYLE_JSON_MMSK & hlause[i].flause)
               || (STYLE_JSON_SREXT & hlause[i].flause)
               )
            && (  !(STYLE_JSON_SRNUM & hlause[i].flause)
               || (0xFFFFFFFF == hlause[i].rnum)
               || !!pgoblin_db_valinfo(PGOBLIN_IsNull, pq, row, hlause[i].rnum)
            )  ) cond |= Nr;
        if  (  (STYLE_JSON_SVREF & hlause[i].flause)
            && (  !(STYLE_JSON_SVNUM & hlause[i].flause)
               || (0xFFFFFFFF == hlause[i].vnum)
               || !!pgoblin_db_valinfo(PGOBLIN_IsNull, pq, row, hlause[i].vnum)
            )  ) cond |= Nv;
        if  (STYLE_JSON_SQOND & hlause[i].flause) {
            if  ((STYLE_JSON_SQEXT | STYLE_JSON_SQNUM) & hlause[i].flause) {
        ;       if  (  !(STYLE_JSON_SQNUM & hlause[i].flause)
                    || (0xFFFFFFFF == hlause[i].qnum)
                    || !!pgoblin_db_valinfo(PGOBLIN_IsNull, pq, row, hlause[i].qnum)
                    ) cond |= Nq;
        ;   } else if (((STYLE_JSON_MSTR | STYLE_JSON_MARR) & hlause[i].flause) || (Nv & cond)) {
                cond |= Nq;
        }   }
        if  ((STYLE_JSON_MCLO & hlause[i].flause) && (STYLE_JSON_SQOND & cxt[level].cxtflg)) cond |= Nq;
        if  (STYLE_JSON_NONEN & cxt[level].cxtflg) cond |= No;
        control = automa[cond];
        ifBLIN_QX2( "%u %02X %08X %08X %d %"BLIN_X"q%s~ %d %"BLIN_X"r%s~ %d %"BLIN_X"v%s~ %08X[%d]%08X=%.*s~"
                  , (u_int32_t)i
                  , cond
                  , control
                  , hlause[i].flause
                  , hlause[i].qnum
                  , hlause[i].qtext
                  , (STYLE_JSON_SQEXT & hlause[i].flause) ? hlause[i].qtext : ""
                  , hlause[i].rnum
                  , hlause[i].rtext
                  , (STYLE_JSON_SREXT & hlause[i].flause) ? hlause[i].rtext : ""
                  , hlause[i].vnum
                  , hlause[i].vtext
                  , (STYLE_JSON_SVEXT & hlause[i].flause) ? hlause[i].vtext : ""
                  , (0 < level) ? cxt[level - 1].cxtflg : 0
                  , level
                  , cxt[level].cxtflg
                  , cxt[level].oln
                  , cxt[level].onm
                  );
        if  (Cc & control) {
            if  (i == st->looe) {
        ;       if  (-1 == hig) break;
        ;       if  ((ntyp + low > row + 1) || ((0 < hig) && (row + 1 < hig))) {
        ;           ++row;
        ;           i = st->loop + 1;
        ;           continue;
        ;   }   }
            --level;
        }
        if  (Cs & control) {
            recond(reg_out, st, cxt, level);
        ;   doshift(reg_out, level, st->shift, STYLE_JSON_CNTOM & cxt[level].cxtflg);
            cxt[level].cxtflg |= STYLE_JSON_CNTOM;
        }
        if  (Cz & control) doshift(reg_out, level, st->shift, 0);
        if  ((Cn & control) && !!level && !(STYLE_JSON_CNTAR & cxt[level].cxtflg)) {
            if  (STYLE_JSON_SRREF & hlause[i].flause) {
        ;       if  (!(Nr & cond)) {
        ;           doid( reg_out
                        , st
                        , pgoblin_db_getvalue(pq, row, hlause[i].rnum)
                        , pgoblin_db_valinfo(PGOBLIN_Length, pq, row, hlause[i].rnum)
                        );
        ;           reg_out->wri(reg_out->onu, " : ", 3);
        ;       } else {
        ;           reg_out->wri(reg_out->onu, "\"\" : ", 5);
        ;       }
        ;   } else if (STYLE_JSON_SREXT & hlause[i].flause) {
        ;       dolit( reg_out
                     , st
                     , hlause[i].rtext
                     , strlen(hlause[i].rtext)
                     , STYLE_JSON_SRQUO & hlause[i].flause
                     );
        ;       reg_out->wri(reg_out->onu, " : ", 3);
        ;   } else {
                reg_out->wri(reg_out->onu, "\"\" : ", 5);
        }   }
        if  (Co & control) {
            cxt[level + 1].cxtflg = (STYLE_JSON_SQOND | STYLE_JSON_TYPE) & cxt[level].cxtflg;
        ;   ifBLIN_QX4(", %08X %d=%.*s~", cxt[level].cxtflg, level, cxt[level].oln, cxt[level].onm);
        ;   ++level;
        ;   cxt[level].oln = 0;
        ;   cxt[level].onm = NULL;
        ;   if  (!(STYLE_JSON_CNTAR & cxt[level].cxtflg)) {
        ;       if  (!(STYLE_JSON_SRREF & hlause[i].flause)) {
        ;           cxt[level].onm = hlause[i].rtext;
        ;           cxt[level].cxtflg |= STYLE_JSON_SRQUO & hlause[i].flause;
        ;           if  (!!cxt[level].onm) cxt[level].oln = strlen(cxt[level].onm);
        ;       } else if (!(Nr & cond)) {
        ;           cxt[level].onm = pgoblin_db_getvalue(pq, row, hlause[i].rnum);
        ;           cxt[level].cxtflg |= STYLE_JSON_SRREF;
        ;           cxt[level].oln = pgoblin_db_valinfo(PGOBLIN_Length, pq, row, hlause[i].rnum);
        ;   }   }
        ;   if  (STYLE_JSON_TYPE & hlause[i].flause) {
        ;       cxt[level].cxtflg &= ~STYLE_JSON_TYPE;
        ;       cxt[level].cxtflg |= STYLE_JSON_TYPE & hlause[i].flause;
        ;   }
        ;   if  (Oa & cond) cxt[level].cxtflg |= STYLE_JSON_CNTAR;
        ;   if  (!(STYLE_JSON_SQOND & hlause[i].flause)) {
        ;   } else if (!(STYLE_JSON_SQNUM & hlause[i].flause)) {
        ;       cxt[level].cxtflg |= STYLE_JSON_SQOND;
        ;   } else if (Nq & cond) {
        ;       cxt[level].cxtflg |= STYLE_JSON_NONEN;
        ;   }
            ifBLIN_QX4(": %08X %d=%.*s~", cxt[level].cxtflg, level, cxt[level].oln, cxt[level].onm);
        }
        if  ((Ct & control) && !(STYLE_JSON_TYPE & hlause[i].flause)) {
            const char *ct = pgoblin_db_subinfo(PGOBLIN_TypeNm, pq, hlause[i].vnum);

        ;   if  (!!ct) {
        ;       if  (!strncasecmp(ct, "bool", 4)) {
        ;           hlause[i].flause |= STYLE_JSON_BOOL << STYLE_JSON_VTSH;
        ;       } else if (!strncasecmp(ct, "int", 3)) {
        ;           hlause[i].flause |= STYLE_JSON_TINT << STYLE_JSON_VTSH;
        ;       } else if (!strncasecmp(ct, "num", 3)) {
        ;           hlause[i].flause |= STYLE_JSON_TINT << STYLE_JSON_VTSH;
        ;       } else if (!strncasecmp(ct, "float", 5)) {
        ;           hlause[i].flause |= STYLE_JSON_TINT << STYLE_JSON_VTSH;
        ;       } else if (!strncasecmp(ct, "double", 6)) {
        ;           hlause[i].flause |= STYLE_JSON_TINT << STYLE_JSON_VTSH;
        ;       } else {
        ;           hlause[i].flause |= STYLE_JSON_TEXT << STYLE_JSON_VTSH;
        ;       }
        ;   } else {
                hlause[i].flause |= STYLE_JSON_TEXT << STYLE_JSON_VTSH;
        }   }
        if  (C0 & control) {
            wr(st, reg_out, "{\n", 2);
            if  (0 < level) cxt[level - 1].cxtflg |= STYLE_JSON_CNTOM;
        }
        if  (C1 & control) {
            wr(st, reg_out, "[\n", 2);
            if  (0 < level) cxt[level - 1].cxtflg |= STYLE_JSON_CNTOM;
        }
        if  (C2 & control) wr(st, reg_out, "}\n", 2);
        if  (C3 & control) wr(st, reg_out, "]\n", 2);
        if  (C4 & control) {
            int         type = 0;
        ;   int         ln   = 0;
        ;   char       *cv   = NULL;

        ;   if  (!(Nv & cond)) {
        ;       type = STYLE_JSON_TYPE & hlause[i].flause;                          /*   */
        ;       if  (!type) type = STYLE_JSON_TYPE & cxt[level].cxtflg;            /*   */
        ;       if  (!type) type =  ((STYLE_JSON_BTYPE & st->flags) >> STYLE_JSON_BTYSH);  /*  */
        ;       if  (!type) type = (STYLE_JSON_VTYP & hlause[i].flause) >> STYLE_JSON_VTSH;  /*  */
        ;       if  (!(STYLE_JSON_SVREF & hlause[i].flause)) {
        ;           cv = hlause[i].vtext;
        ;           ln = strlen(cv);
        ;           if  (!!cv) {
        ;               if  (STYLE_JSON_TEXT == type) {
        ;                   doid(reg_out, st, cv, ln);
        ;               } else {
        ;                   recout(reg_out, st, cv, ln);
        ;               }
        ;               wr(st, reg_out, "\n", 1);
        ;           }
        ;       } else if (!pgoblin_db_valinfo(PGOBLIN_IsNull, pq, row, hlause[i].vnum)) {
        ;           cv = pgoblin_db_getvalue(pq, row, hlause[i].vnum);
        ;           ln = pgoblin_db_valinfo(PGOBLIN_Length, pq, row, hlause[i].vnum);
        ;           switch(type) {
                    case STYLE_JSON_BOOL:
        ;               if  (('F' == (0xDF & cv[0])) || ((1 == ln) && ('0' == cv[0]))) {
        ;                   wr(st, reg_out, "false\n", 6);
        ;               } else {
        ;                   wr(st, reg_out, "true\n", 5);
        ;               }
        ;               break;
                    case STYLE_JSON_TINT:
        ;               recout(reg_out, st, cv, ln);
        ;               wr(st, reg_out, "\n", 1);
        ;               break;
                    default             :
        ;               doid(reg_out, st, cv, ln);
        ;               wr(st, reg_out, "\n", 1);
        ;               break;
        ;   }   }   }
            if  (!cv) wr(st, reg_out, "null\n", 5);
        }
        ++i;
    }
out:
    ifBLIN_QX3("- %d %"BLIN_D, ex, textlength);
    return((ex < 0) ? ex : textlength);
#   undef blin_internal_flags
}
