/*-
 * Copyright (C)2021 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2021 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: geterm.c,v 1.5 2021/07/24 21:24:43 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define RECOBE_COMPAT    5
#define PGOBLIN_COMPAT   3
#define PGOBLIN_INTERNAL 1
#define PGOBLIN_MODULE   pgoblin_module

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <babolo/recobe.h>
#include <multilar.h>
#include <mife.h>
#include <pgoblin.h>
#include "pgoblin5json.h"

typedef enum style_json_char
{   L0 =                                      0  /* \0            */
,   Lu = (                                    1) /* =             */
,   Lp = (                  STYLE_JSON_BOOL | 1) /* .             */
,   La = (                  STYLE_JSON_TEXT | 1) /* *             */
,   Lh = (                  STYLE_JSON_TINT | 1) /* #             */
,   LR = (                  STYLE_JSON_OPEN | 2) /* [             */
,   LS = (STYLE_JSON_OPEN | STYLE_JSON_STRU | 2) /* {             */
,   Lr = (                                    3) /* ]             */
,   Ls = (                  STYLE_JSON_STRU | 3) /* }             */
,   Lb =                                      4  /* \t  , : */
,   Lq =                                      5  /* "             */
,   Lz =                                      6  /* +-            */
,   Lw = (0x00 |                              7) /* ?             */
,   Lm = (0x10 |                              7) /* @             */
,   Le = (0x10 |                              8) /* e E           */
,   Ll =                                      8  /*    */
,   Ld =                                      9  /*          */
,   Ly =                                     10  /* \             */
,   Lo =                                     11  /*         */
,   Lx =                                     12
} style_json_char;

static const char *cn[] =
{  "L0", "ph", "RS", "rs",  "Lb", "Lq", "Lz", "wm"
,  "el", "Ld", "Ly", "Lo",  "Lx"
};

static const u_char class[256] =
{  L0, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  L0, Lb, L0, Lo,  L0, L0, Lo, Lo
,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
,  Lb, Lo, Lq, Lh,  Lo, Lo, Lo, Lo,  Lo, Lo, La, Lz,  Lb, Lz, Lp, Lo
,  Ld, Ld, Ld, Ld,  Ld, Ld, Ld, Ld,  Ld, Ld, Lb, Lo,  Lo, Lu, Lo, Lw

,  Lm, Ll, Ll, Ll,  Ll, Le, Ll, Ll,  Ll, Ll, Ll, Ll,  Ll, Ll, Ll, Ll
,  Ll, Ll, Ll, Ll,  Ll, Ll, Ll, Ll,  Ll, Ll, Ll, LR,  Ly, Lr, Lo, Ll
,  Lo, Ll, Ll, Ll,  Ll, Le, Ll, Ll,  Ll, Ll, Ll, Ll,  Ll, Ll, Ll, Ll
,  Ll, Ll, Ll, Ll,  Ll, Ll, Ll, Ll,  Ll, Ll, Ll, LS,  Lo, Ls, Lo, Lo

,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo

,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
};

enum states
{ bg /*             */
, bb /*    */
, bi /*            */
, bn /*                    */
, bp /*                */
, bd /*             */
, be /*    */
, bz /*          */
, bj /*               */
, bq /*                */
, by /*                   */
, bx
};

static const char statenames[][3] =
{  "bg", "bb", "bi", "bn",  "bp", "bd", "be", "bz"
,  "bj", "bq", "by", "bx"
};

static const char pn[][3] = 
{ "- ", "- ", "- ", "- ", "- ", "- ", "- ", "- "
, "Cw", "Cb", "Ce", "Cy", "Ct", "Co", "Cv", "Cn"
, "Cj", "Cp", "Cd", "Cq", "Ck", "Cz", "- ", "Cx"
};
#define Cw  0x800000  /* / */
#define Cb  0x400000  /*    */
#define Ce  0x200000  /*     */
#define Cy  0x100000  /*   \         */
#define Ct  0x080000  /*             */
#define Co  0x040000  /*          */
#define Cv  0x020000  /*             */
#define Cn  0x010000  /*             */
#define Cj  0x008000  /*              */
#define Cp  0x004000  /*     */
#define Cd  0x002000  /*           */
#define Cq  0x001000  /*         */
#define Ck  0x000800  /*      */
#define Cz  0x000400  /*   offset   */
#define Cx  0x000100  /*                  */
#define C_state 0xFF  /*      */

static u_int32_t automa[bx][Lx] =
/*         L0   Lpah      LRS    Lrs       Lb     Lq     Lz    Lwm    Lel       Ld     Ly     Lo */
{{      Cz|bx, Ct|bx,   Co|bx, Co|bx,      bx, Cb|bq, Cb|bj, Cw|bb, Cb|bi,Cb|Cn|bn, Cx|bx, Cx|bx}//bg
,{      Cz|bx,    bx,      bx, Cx|bx,      bx, Cb|bq, Cx|bx, Cx|bx, Cb|bi,   Cn|bp, Cx|bx, Cx|bx}//bb
,{   Ce|Cz|bx, Ce|bx,   Ce|bx, Cx|bx,   Ce|bx, Cx|bx, Cx|bx, Cx|bx,    bi,      bi, Cx|bx, Cx|bx}//bi
,{Cj|Ce|Cz|bx, Cd|bd,Cj|Ce|bx, Cx|bx,Cj|Ce|bx, Cx|bx, Cx|bx, Cx|bx, Cp|be,   Cn|bn, Cx|bx, Cx|bx}//bn
,{Cj|   Cz|bx, Cj|bx,Cj|   bx, Cx|bx,Cj|   bx, Cx|bx, Cx|bx, Cx|bx, Cx|bx,   Cn|bp, Cx|bx, Cx|bx}//bp
,{   Cv|Cz|bx, Cv|bx,   Cx|bx, Cx|bx,   Cv|bx, Cx|bx, Cx|bx, Cx|bx, Cp|be,      bd, Cx|bx, Cx|bx}//bd
,{   Cv|Cz|bx, Cx|bx,   Cx|bx, Cx|bx,   Cx|bx, Cx|bx,    bz, Cx|bx, Cx|bx,      bz, Cx|bx, Cx|bx}//be
,{   Cv|Cz|bx, Cx|bx,   Cx|bx, Cx|bx,Cv|Cz|bx, Cx|bx, Cx|bx, Cx|bx, Cx|bx,      bz, Cx|bx, Cx|bx}//bz
,{   Cv|Cz|bx, Cd|bd,   Cx|bx, Cx|bx,   Cx|bx, Cx|bx, Cx|bx, Cx|bx, Cp|be,      bj, Cx|bx, Cx|bx}//bj
,{   Cx|Cz|bx, Cq|bq,   Cq|bq, Cq|bq,   Cq|bq, Ck|bx, Cq|bq, Cq|bq, Cq|bq,   Cq|bq, Cq|by, Cq|bq}//bq
,{      Cy|bx, Cq|bq,   Cq|bq, Cq|bq,   Cq|bq, Cq|bq, Cq|bq, Cq|bq, Cq|bq,   Cq|bq, Cq|bq, Cq|bq}//by
};

char *
/*****************************************************************************************************
 *****************************************************************************************************
 ****                                                                                             ****/
style_json_geterm(style_json_term *term, u_char *in) {                                           /****
 ****                                                                                             ****
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags ((term ? term->flterm : pgoblin_default) & BLIN_MASK)
    u_int32_t         control;        /*                   */
    size_t            offset;         /*                         */
    enum states       state;          /*                            */
    u_int32_t         s_num   = 0;    /*                                                   */

    ifBLIN_QX3("+ %"BLIN_X, BLIN_I(in));
    ifBLIN_QX5( "%08X %u |%.*s~"
              , term->flterm
              , term->nuterm
              , 3
              , term->txterm ? (char *)term->txterm : "~"
              );
    blin_stateheader(BLIN_4STA24G, pn);
    for (state = bg, offset = 0, control = 0; state < bx; state = control & C_state) {
        control = automa[state][class[in[offset]] & 0x0F];
        blin_statebody( BLIN_4STO24G
                      , pn
                      , statenames
                      , cn[class[in[offset]] & 0x0F]
                      , (char*)in
                      , offset
                      , control
                      , state
                      , s_num
                      , class[in[offset]]
                      );
        if  (control & Cw) {
            term->flterm |= ((class[in[offset]] & 0x10) ? STYLE_JSON_REFR : STYLE_JSON_COND);
            term->flterm |= STYLE_JSON_DONE;
        }
        if  (control & Cb) term->txterm = &in[offset];
        if  (control & (Ce | Cv | Ck)) term->nutext = (u_int32_t)(&in[offset] - term->txterm);
        if  (control & Ce) term->flterm |= STYLE_JSON_DONE | STYLE_JSON_WORD;
        if  (control & Cv) term->flterm |= STYLE_JSON_DONE | STYLE_JSON_MISC;
        if  (control & Ck) {
            term->nutext++;
            term->flterm |= STYLE_JSON_DONE | STYLE_JSON_MISC | STYLE_JSON_QUOT;
        }
        if  (control & Ct) {
            for (int i = 0; i < 2; ++i) {
                if  (Lu != (class[in[offset + i]] & 0x0F)) break;
                if  (!!i) ++offset;
                if  (Lu == class[in[offset]]) {
                    term->flterm |= STYLE_JSON_DONE | STYLE_JSON_LOOP;
                } else {
                    term->flterm |= STYLE_JSON_DONE | (class[in[offset]] & STYLE_JSON_TYPE);
        }   }   }
        if  (control & Co) {
            term->flterm |= STYLE_JSON_DONE | STYLE_JSON_OBJC | (class[in[offset]] & STYLE_JSON_OBJM);
        }
        if  (control & Cn) s_num = s_num * 10 + in[offset] - '0';
        if  (control & Cj) {
            term->nuterm = s_num;
            term->flterm |= STYLE_JSON_DONE | STYLE_JSON_NUMR;
        }
        if  ((control & Cp) && !(class[in[offset]] & 0x10)) control = Cx | bx;
        if  ((control & Cd) && ('.' != in[offset])) control = Cx | bx;
        if  ((control & Cy) && ('\n' != in[offset])) control = Cx | bx;
        if  (~control & Cz) ++offset;
        if  (control & Cx) {
            ifBLIN_QX0("term error=%.*s", (u_int32_t)offset, in);
            in = NULL;
            errno = EILSEQ;
            goto out;
        }
    }
    in += offset;
out:
    ifBLIN_QX4( "%08X %u [%u]%.*s~"
              , term->flterm
              , term->nuterm
              , term->nutext
              , term->txterm ? term->nutext : 1
              , term->txterm ? (char *)term->txterm : "~"
              );
    ifBLIN_QX3("- %d %"BLIN_X, errno, BLIN_I(in));
    return((char *)in);
#   undef blin_internal_flags
}
