/*-
 * Copyright (C)2021 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2021 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: flags.c,v 1.5 2021/07/31 16:20:35 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define RECOBE_COMPAT    6
#define PGOBLIN_COMPAT   3
#define PGOBLIN_INTERNAL 1
#define PGOBLIN_MODULE   pgoblin_module

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <babolo/recobe.h>
#include <multilar.h>
#include <mife.h>
#include <pgoblin.h>
#include "pgoblin5json.h"

#define RECOBE_CASE_OPTS st
#define RECOBE_CASE_OUT  out
#define RECOBE_CASE_EX   ex

int
/*****************************************************************************************************
 *****************************************************************************************************
 ****                                                                                             ****/
style_json_flags(style_json_style *st, char **iin) {                                             /****
 ****                                                                                             ****
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (st->flags & BLIN_MASK)
    const char       *flar   = "b:B:c:Ce:E:Hk:Lm:M:o:s:T,{[>:|:";
    babolo_parm      *bp     = NULL;
    int               ex     = 0;          /*     < 0  */
    int               c;

    ifBLIN_QX3("+ %08X %"BLIN_X"=%.*s~", blin_internal_flags, BLIN_I(*iin), 2, iin);
    if  (!(bp = babolo_getparm(Bpars_NOAL | Bpars_LFLN | Bpars_NOEN | Bpars_FAST, iin, NULL, 0))) {
        ifBLIN_QX0("getparm");
        ex = -EX_SOFTWARE;
        goto out;
    }
    ex = bp->cntr;
    ifBLIN_QX5("%d %"BLIN_X, bp->argc, BLIN_I(*iin));
    if  (!(st->bos = babolo_openopts(Bpars_ESYM | 'Y', 'Z'))) {
        ifBLIN_QW0("openopts");
        ex = -EX_SOFTWARE;
        goto out;
    }
    if  (!!babolo_setparm(st->bos, (blin_internal_flags >> 1) & BLIN_MASK, bp, flar)) {
        ifBLIN_QW0("setopts");
        ex = -EX_SOFTWARE;
        goto out;
    }
    for (; !!(c = babolo_getopts(st->bos));) {
        if  (0 > c) {
            ifBLIN_QW0("babolo_getopts");
            ex = -EX_USAGE;
            goto out;
        }
        switch (c) {
        case 'b': RECOBE_CASE_b;
                ; break;
        case 'B': RECOBE_CASE_B;
                ; break;
        case 'c': RECOBE_CASE_c;
                ; break;
        case 'C': RECOBE_CASE_C;
                ; break;
        case 'e': RECOBE_CASE_e;
                ; break;
        case 'E': RECOBE_CASE_E;
                ; break;
        case 'H': RECOBE_CASE_H;
                ; break;
        case 'k': RECOBE_CASE_k;
                ; break;
        case 'L': RECOBE_CASE_L;
                ; break;
        case 'm': RECOBE_CASE_m;
                ; break;
        case 'M': RECOBE_CASE_M;
                ; break;
        case 'o': RECOBE_CASE_o;
                ; break;
        case 's': RECOBE_CASE_s;
                ; break;
        case 'T': RECOBE_CASE_T;
                ; break;
        case ',': st->flags |= STYLE_JSON_CNTOM;
                ; break;
        case '{': st->flags &= ~STYLE_JSON_CNTAR;
                ; break;
        case '[': st->flags |= STYLE_JSON_CNTAR;
                ; break;
        case '>': st->shift = babolo_getoptunum(st->bos, 0) & 0x00FF;
                  if  (!!errno) {
                      ifBLIN_QW0("Illegal -%c arg", st->bos->c);
                      ex = -EX_USAGE;
                      goto out;
                  }
                  if  (st->shift > 64) {
                      ifBLIN_QX1("Too big shift %u", st->shift);
                      st->shift = 64;
                  }
                ; break;
        case '|': st->level = babolo_getoptunum(st->bos, 0) & 0x00FF;
                  if  (!!errno) {
                      ifBLIN_QW0("Illegal -%c arg", st->bos->c);
                      ex = -EX_USAGE;
                      goto out;
                  }
                ; break;
        default : ifBLIN_QX0("Illegal flag -%c", st->bos->c);
                ; ex = -EX_USAGE;
                ; errno = EINVAL;
                ; goto out;
    }   }
out:
    if  (!!st->bos) babolo_closeopts(st->bos);
    st->bos = NULL;
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}
