/*-
 * Copyright (C)2021 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2021 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: dump.c,v 1.5 2021/07/17 21:28:44 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define RECOBE_COMPAT    5
#define PGOBLIN_COMPAT   3
#define PGOBLIN_INTERNAL 1
#define PGOBLIN_MODULE   pgoblin_module

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <babolo/recobe.h>
#include <multilar.h>
#include <mife.h>
#include <pgoblin.h>
#include "pgoblin5json.h"

static const char spaces[] = "                                                                ";
static const char style_json_typemarks[] = "-.*#";

static void
/*****************************************************************************************************
 **                                                                                                 **/
qpr(style_json_style *st, style_json_clause *ct, int level) {                                      /**
 **                                                                                                 **
 *****************************************************************************************************/
    int          n = 0;

    if  (STYLE_JSON_SQOND & ct->flause) n += printf("?");
    if  (STYLE_JSON_SQNUM & ct->flause) n += printf("%u", ct->qnum);
    if  (STYLE_JSON_SQQUO & ct->flause) {
        n += printf("\"%s\"", ct->qname);
    } else if (STYLE_JSON_SQEXT & ct->flause) {
        n += printf("'%s'", ct->qname);
    }
    if  (!level) {
        if  (st->shift > n) printf("%.*s", st->shift - n, spaces); else printf(" ");
    } else if ((level * st->shift) > n) {
        printf("%.*s", (level * st->shift) - n, spaces);
        if  (st->shift > 1) {
            if  (STYLE_JSON_MCLO & ct->flause) {
                printf("%.*s", st->shift, spaces);
            } else {
                printf(",%.*s", st->shift - 1, spaces);
        }   }
    } else {
        n -= level * st->shift;
        if  (st->shift > (n + 1)) printf(",%.*s", st->shift - n - 1, spaces); else printf(",");
}   }

void
/*****************************************************************************************************
 *****************************************************************************************************
 ****                                                                                             ****/
style_json_dump(pgoblin_styreg *reg_style) {                                                     /****
 ****                                                                                             ****
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags ((reg_style ? reg_style->flags : pgoblin_default) & BLIN_MASK)
    int                level;
    style_json_clause *ct;
    style_json_style  *st;
    int                n;

    if  (!reg_style || !(st = reg_style->style)) {
        printf("Dump json: no style\n");
        errno = EINVAL;
        goto out;
    }
    if  ((st->flags & PGOBLIN_NTBSZMK) != PGOBLIN_NTBSIZE) {
        printf("Illegal pgoblin json style size %d\n", st->flags & PGOBLIN_NTBSZMK);
        errno = EINVAL;
        goto out;
    }
    level = st->level;
    printf("+######################################\n");
    printf("%08X %08X ^%u >%u", st->flags, st->rc.flags, st->level, st->shift);
    if  (0xFFFFFFFF != st->loop) printf(" loop=%u", st->loop);
    if  (!!st->rc.mod) printf(" mod=%s~", st->rc.mod);
    if  (!!st->rc.bsubst) printf(" b=%s~", st->rc.bsubst);
    if  (!!st->rc.esubst) printf(" e=%s~\n", st->rc.esubst);
    printf("\n");
    for (size_t i = 0; i < MULAR_NEXT(st->clause); ++i) {
        n = 0;
        ct = mular_getix(st->clause, i);
        if  (10 >= MULAR_NEXT(st->clause)) {
            if  ((i == st->loop) && (STYLE_JSON_TYPE & ct->flause)) {
                printf( "[%c]%08X "
                      , style_json_typemarks[(STYLE_JSON_TYPE & ct->flause) >> 4]
                      , ct->flause
                      );
            } else {
                printf("[%u]%08X ", (u_int)i, ct->flause);
            }
        } else if (100 >= MULAR_NEXT(st->clause)) {
            if  (i == st->loop) {
                printf( "[ %c]%08X "
                      , style_json_typemarks[(STYLE_JSON_TYPE & ct->flause) >> 4]
                      , ct->flause
                      );
            } else {
                printf("[%2u]%08X ", (u_int)i, ct->flause);
            }
        } else if (1000 >= MULAR_NEXT(st->clause)) {
            if  (i == st->loop) {
                printf( "[  %c]%08X "
                      , style_json_typemarks[(STYLE_JSON_TYPE & ct->flause) >> 4]
                      , ct->flause
                      );
            } else {
                printf("[%3u]%08X ", (u_int)i, ct->flause);
            }
        } else {
            if  (i == st->loop) {
                printf( "[   %c]%08X "
                      , style_json_typemarks[(STYLE_JSON_TYPE & ct->flause) >> 4]
                      , ct->flause
                      );
            } else {
                printf("[%4u]%08X ", (u_int)i, ct->flause);
        }   }
        switch(STYLE_JSON_MMSK & ct->flause) {
        case 0:
            qpr(st, ct, level);
            if  (STYLE_JSON_SRREF & ct->flause) printf("@");
            if  (STYLE_JSON_SRNUM & ct->flause) {
                printf("%u", ct->rnum);
            } else if (STYLE_JSON_SREXT & ct->flause) {
                printf("\"%s\"", ct->rname);
            }
            printf(" ");
            if  (STYLE_JSON_SVREF & ct->flause) {
                printf("@");
                if  (STYLE_JSON_SVNUM & ct->flause) {
                    printf("%u", ct->vnum);
                } else if (STYLE_JSON_SVEXT & ct->flause) {
                    printf("\"%s\"", ct->vname);
                }
            } else if (STYLE_JSON_SVVAL & ct->flause) {
                printf("%s", ct->vname);
            }
            if  (STYLE_JSON_TYPE & ct->flause) {
                printf(" %c", style_json_typemarks[(STYLE_JSON_TYPE & ct->flause) >> 4]);
            }
            break;
        case STYLE_JSON_MARR:
            qpr(st, ct, level);
            n = 0;
            if  (STYLE_JSON_SRREF & ct->flause) n += printf("@");
            if  (STYLE_JSON_SRNUM & ct->flause) {
                n += printf("%u", ct->rnum);
            } else if (STYLE_JSON_SREXT & ct->flause) {
                n += printf("\"%s\"", ct->rname);
            }
            if  (!!n) printf(" ");
            printf("[");
            if  (i == st->loop) {
                printf(" %c", style_json_typemarks[(STYLE_JSON_TYPE & ct->flause) >> 4]);
            }
            ++level;
            break;
        case STYLE_JSON_MSTR:
            qpr(st, ct, level);
            n = 0;
            if  (STYLE_JSON_SRREF & ct->flause) n += printf("@");
            if  (STYLE_JSON_SRNUM & ct->flause) {
                n += printf("%u", ct->rnum);
            } else if (STYLE_JSON_SREXT & ct->flause) {
                n += printf("\"%s\"", ct->rname);
            }
            if  (!!n) printf(" ");
            printf("{");
            ++level;
            break;
        case STYLE_JSON_CARR:
            --level;
            qpr(st, ct, level);
            printf("]");
            break;
        case STYLE_JSON_CSTR:
            --level;
            qpr(st, ct, level);
            printf("}");
            break;
        default:
            printf("!!!! %08X", ct->flause);
        }
        printf("\n");
    }
    if  (st->level != level) {
        printf(" Not balansed %d\n", level - st->level);
        level = 1;
    }
    printf("-######################################\n");
    fflush(stdout);
out:
    return;
#   undef blin_internal_flags
}
