/*-
 * Copyright (C)2008..2022 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: pgoblin3sqlite3.h,v 1.9 2022/11/13 20:49:25 babolo Exp $
 */

#ifndef BLIN_4STX24G
# define BLIN_4STX24G  ((blin_statectl){{4, 1, 8, 24, ' ', 5, 1, 0, 1}})
#endif

#define SQLITE_E       0x000001 /*  E    */
#define SQLITE_SL      0x000002 /*  \                       */
#define SQLITE_SQ      0x000004 /*  '                       */
#define SQLITE_DQ      0x000008 /*  "                       */
#define SQLITE_SF      0x000010 /*  ,          */
#define SQLITE_EE      0x000020 /*   E             */
#define SQLITE_US      0x000040 /*                    */
#define SQLITE_KY      0x000080 /*             */
#define SQLITE_NL      0x000100 /*  \0                     */
#define SQLITE_SS      0x000200 /* \X                          */
#define SQLITE_GLOB        0400
#define SQLITE_BUZYWAIT    7500
// #define SQLITE_BUZYREPEAT 10

/*      0x01..0x0F */
/*   ASCII    */
#define Lx         0x00
#define Lz         0x10
#define Lb ('\b' | 0x20)
#define Lf ('\f' | 0x20)
#define Ln ('\n' | 0x20)
#define Lr ('\r' | 0x20)
#define Lt ('\t' | 0x20)
#define Lv ('\v' | 0x20)
#define L0 ('0') /*0x30*/
#define L1 ('1') /*0x31*/
#define L2 ('2') /*0x32*/
#define L3 ('3') /*0x33*/
#define L4 ('4') /*0x34*/
#define L5 ('5') /*0x35*/
#define L6 ('6') /*0x36*/
#define L7 ('7') /*0x37*/
#define Lc         0x40  /* \t */
#define Ls ('\\')/*0x5C*/
#define Lw         0x60  /* \n */
#define Le         0x70  /*  * */
#define Lu         0x80  /* \N */
#define Ld         0x90  /* \. */
#define LX         0xA0

#define Co 0x00800000 /*              */
#define Cb 0x00400000 /*             */
#define Cr 0x00200000 /*           */
#define Cq 0x00100000 /*                 */
#define Cg 0x00080000 /*   */
#define Cp 0x00040000 /*          */
#define Cn 0x00020000 /* NULL        */
#define Cc 0x00010000 /*             */
#define Cl 0x00008000 /*              */
#define Cs 0x00004000 /* COPY                 */          
#define Cx 0x00002000 /*                     */
#define Ck 0x00001000 /*             */
#define Cu 0x00000800 /*        */
#define C_state  0xFF /*         */

typedef enum states
{ bg /*        */
, bq /* \      */
, bz /*  \0            */
, be /*  \             */
, b1 /*  \[0..7]       */
, b2 /*  \[0..7][0..7] */
, bb /*       */
, bd /* \     */
, bc /*             */
, bt /*        */
, bn /*  \N            */
, bx
} states;

typedef struct pgoblin_db_conn {
    BLIN_flag         flags;
/*                PGOBLIN_DB_TYPE                                                                    */
#   define        PGOBLIN_STREAMI 0x010000
#   define        PGOBLIN_STREAMT 0x020000
#   define        PGOBLIN_STREAME 0x040000
#   define        PGOBLIN_ALLOUT  (PGOBLIN_STREAMI | PGOBLIN_STREAMT | PGOBLIN_STREAME)
#   define        PGOBLIN_COPYIN  0x100000
#   define        PGOBLIN_COPYST  0x200000
#   define        PGOBLIN_COPYEN  0x400000
#   define        PGOBLIN_ALLIN   (PGOBLIN_COPYIN | PGOBLIN_COPYST | PGOBLIN_COPYEN)
    int               ncol;
    sqlite3_stmt     *vm;
    sqlite3          *odf;
    const char       *query;
    u_char           *semi;                     /*  ,      */
    int               coln;
    u_char            reg;
    enum states       state;
} pgoblin_db_conn;

struct pgoblin_realpq {
    BLIN_flag         flags;                                                        /* Must be first */
/*                    PGOBLIN_DB_TYPE                                                                */
#   define            PGOBLIN_TINIT   0x010000
#   define            PGOBLIN_MULAR   0x020000
#   define            PGOBLIN_VM      0x040000
    int               ncol;
    union {
        mular_descriptor *md;
        sqlite3_stmt     *vm;
    };
    pgoblin_rdb      *db;
    char            **serv;
    u_char           *typs;
    int               nrow;
};

void  pgoblin_sqlite3_gettimeofday __P((sqlite3_context *ctx, int argc, sqlite3_value **argv));
void  pgoblin_sqlite3_quote_html   __P((sqlite3_context *ctx, int argc, sqlite3_value **argv));
void  pgoblin_sqlite3_regexrepl    __P((sqlite3_context *ctx, int argc, sqlite3_value **argv));
void  pgoblin_sqlite3_upandown     __P((sqlite3_context *ctx, int argc, sqlite3_value **argv));
void  pgoblin_sqlite3_regexp       __P((sqlite3_context *ctx, int argc, sqlite3_value **argv));
void  pgoblin_sqlite3_quote        __P((sqlite3_context *ctx, int argc, sqlite3_value **argv));
char *pgoblin_sqlite3_rerr         __P((int ex, regex_t *preg));
