/*-
 * Copyright (C)2008..2022 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2008..2022 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: ex_sqlite3.c,v 1.88 2022/11/13 20:49:25 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define PGOBLIN_COMPAT   4
#define PGOBLIN_INTERNAL 1
#define PGOBLIN_MODULE   pgoblin_module

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sysexits.h>
#include <sys/time.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <regex.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <sqlite3.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"
#include "pgoblin3sqlite3.h"

/* expansions to SQLite 3 */

void
/*********************************************************************************
 *********************************************************************************
 **                                                                             **/
_pgoblin_sqlite3_quote(sqlite3_context *ctx, int argc, sqlite3_value **argv) { /**
 **                                                                             **
 *********************************************************************************
 *********************************************************************************/
    int         nquotes;
    int         keyword;
    u_int32_t   flags;
    ssize_t     len;
    char       *res;
    const char *cp;
    int         i;
    int         j;

    flags = ~(SQLITE_EE | SQLITE_US) & (u_int32_t)BLIN_I(sqlite3_user_data(ctx));
#   define blin_internal_flags (flags & BLIN_MASK)
    cp = (char*)sqlite3_value_text(argv[0]);
    if  (!cp) {
        sqlite3_result_null(ctx);
    } else {
        len = strlen(cp);
        for (i = 0, nquotes = 0; i < len; i++) {
            if  (cp[i] == '\\') {
                flags |= SQLITE_EE | SQLITE_US;
                if  (flags & SQLITE_SL) nquotes++;
            } else if (cp[i] == '\'') {
                flags |= SQLITE_US;
                if  (flags & SQLITE_SQ) nquotes++;
            } else if (cp[i] == '\"') {
                flags |= SQLITE_US;
                if  (flags & SQLITE_DQ) nquotes++;
            } else if (((cp[i] >= 'a') && (cp[i] <= 'z')) || (cp[i] == '_')) {
            } else if ((cp[i] >= '0') && (cp[i] <= '9')) {
                if  (i == 0) flags |= SQLITE_US;
            } else if (cp[i] == 0) {
                flags |= SQLITE_US | SQLITE_NL;
                if  (flags & SQLITE_SS) nquotes += 3;
            } else if ((cp[i] >= 0x08) && (cp[i] <= 0x0D)) {
                flags |= SQLITE_US;
                if  (flags & SQLITE_SS) nquotes++;
            } else {
                flags |= SQLITE_US;
        }   }
        if  (!(~flags & (SQLITE_E | SQLITE_EE))) nquotes++;
        keyword = 0;
        if  (flags & SQLITE_KY) {
            keyword = babolo_testword(pgoblin.sqlkeywords, cp);
            if  (keyword == UNRESERVED_KEYWORD) keyword = 0;
        }
        if  (nquotes || keyword || !(flags & SQLITE_SF) || (flags & SQLITE_US)) {
            if  (!(res = malloc(len + nquotes + 3))) {
                ifBLIN_QX0("No mem");
                sqlite3_result_error_nomem(ctx);
            } else {
                j = 0;
                if  (!(~flags & (SQLITE_E | SQLITE_EE))) res[j++] = 'E';
                if  (flags & SQLITE_SQ) res[j++] = '\'';
                if  (flags & SQLITE_DQ) res[j++] = '\"';
                for (i = 0; i < len; i++) {
                    if  ((cp[i] == '\\') && (flags & SQLITE_SL)) res[j++] = '\\';
                    if  ((cp[i] == '\'') && (flags & SQLITE_SQ)) res[j++] = '\'';
                    if  ((cp[i] == '\"') && (flags & SQLITE_DQ)) res[j++] = '\"';
                    res[j++] = cp[i];
                }
                if  (flags & SQLITE_DQ) res[j++] = '\"';
                if  (flags & SQLITE_SQ) res[j++] = '\'';
                res[j] = '\0';
                sqlite3_result_text(ctx, res, j, free);
            }
        } else {
            sqlite3_result_text(ctx, cp, -1, SQLITE_TRANSIENT);
    }   }
#   undef blin_internal_flags
}

static const u_char subst_in[]    = {
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,5,0, 0,0,4,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 3,0,3,0,

 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,

 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 5,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,

 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0};

static const char *subst_out[] = {
 "\000"  ,"\001"  ,"\002"  ,"\003"  , "\004"  ,"\005"  ,"\006"  ,"\007",
 "\010"  ,"\011"  ,"\012"  ,"\013"  , "\014"  ,"\015"  ,"\016"  ,"\017",
 "\020"  ,"\021"  ,"\022"  ,"\023"  , "\024"  ,"\025"  ,"\026"  ,"\027",
 "\030"  ,"\031"  ,"\032"  ,"\033"  , "\034"  ,"\035"  ,"\036"  ,"\037",
 "\040"  ,"\041"  ,"&quot;","\043"  , "\044"  ,"\045"  ,"&amp;" ,"\047",
 "\050"  ,"\051"  ,"\052"  ,"\053"  , "\054"  ,"\055"  ,"\056"  ,"\057",
 "\060"  ,"\061"  ,"\062"  ,"\063"  , "\064"  ,"\065"  ,"\066"  ,"\067",
 "\070"  ,"\071"  ,"\072"  ,"\073"  , "&lt;"  ,"\075"  ,"&gt;"  ,"\077",

 "\100"  ,"\101"  ,"\102"  ,"\103"  , "\104"  ,"\105"  ,"\106"  ,"\107",
 "\110"  ,"\111"  ,"\112"  ,"\113"  , "\114"  ,"\115"  ,"\116"  ,"\117",
 "\120"  ,"\121"  ,"\122"  ,"\123"  , "\124"  ,"\125"  ,"\126"  ,"\127",
 "\130"  ,"\131"  ,"\132"  ,"\133"  , "\134"  ,"\135"  ,"\136"  ,"\137",
 "\140"  ,"\141"  ,"\142"  ,"\143"  , "\144"  ,"\145"  ,"\146"  ,"\147",
 "\150"  ,"\151"  ,"\152"  ,"\153"  , "\154"  ,"\155"  ,"\156"  ,"\157",
 "\160"  ,"\161"  ,"\162"  ,"\163"  , "\164"  ,"\165"  ,"\166"  ,"\167",
 "\170"  ,"\171"  ,"\172"  ,"\173"  , "\174"  ,"\175"  ,"\176"  ,"\177",

 "\200"  ,"\201"  ,"\202"  ,"\203"  , "\204"  ,"\205"  ,"\206"  ,"\207",
 "\210"  ,"\211"  ,"\212"  ,"\213"  , "\214"  ,"\215"  ,"\216"  ,"\217",
 "\220"  ,"\221"  ,"\222"  ,"\223"  , "\224"  ,"\225"  ,"\226"  ,"\227",
 "&nbsp;","\231"  ,"\232"  ,"\233"  , "\234"  ,"\235"  ,"\236"  ,"\237",
 "\240"  ,"\241"  ,"\242"  ,"\243"  , "\244"  ,"\245"  ,"\246"  ,"\247",
 "\250"  ,"\251"  ,"\252"  ,"\253"  , "\254"  ,"\255"  ,"\256"  ,"\257",
 "\260"  ,"\261"  ,"\262"  ,"\263"  , "\264"  ,"\265"  ,"\266"  ,"\267",
 "\270"  ,"\271"  ,"\272"  ,"\273"  , "\274"  ,"\275"  ,"\276"  ,"\277",

 "\300"  ,"\301"  ,"\302"  ,"\303"  , "\304"  ,"\305"  ,"\306"  ,"\307",
 "\310"  ,"\311"  ,"\312"  ,"\313"  , "\314"  ,"\315"  ,"\316"  ,"\317",
 "\320"  ,"\321"  ,"\322"  ,"\323"  , "\324"  ,"\325"  ,"\326"  ,"\327",
 "\330"  ,"\331"  ,"\332"  ,"\333"  , "\334"  ,"\335"  ,"\336"  ,"\337",
 "\340"  ,"\341"  ,"\342"  ,"\343"  , "\344"  ,"\345"  ,"\346"  ,"\347",
 "\350"  ,"\351"  ,"\352"  ,"\353"  , "\354"  ,"\355"  ,"\356"  ,"\357",
 "\360"  ,"\361"  ,"\362"  ,"\363"  , "\364"  ,"\365"  ,"\366"  ,"\367",
 "\370"  ,"\371"  ,"\372"  ,"\373"  , "\374"  ,"\375"  ,"\376"  ,"\377"};

void
/**************************************************************************************
 **************************************************************************************
 **                                                                                  **/
_pgoblin_sqlite3_quote_html(sqlite3_context *ctx, int argc, sqlite3_value **argv) { /**
 **                                                                                  **
 **************************************************************************************
 **************************************************************************************/
    int         nquotes;
    u_int32_t   flags;
    ssize_t     len;
    char       *res;
    const char *cp;
    const char *q;
    int         i;
    int         j;

    flags = (u_int32_t)BLIN_I(sqlite3_user_data(ctx));
#   define blin_internal_flags (flags & BLIN_MASK)
    cp = (char*)sqlite3_value_text(argv[0]);
    if  (!cp) {
        sqlite3_result_null(ctx);
    } else {
        len = strlen(cp);
        for (i = 0, nquotes = 0; i < len; i++) nquotes += (int)subst_in[((u_char*)cp)[i]];
        if  (nquotes) {
            if  (!(res = malloc(len + nquotes + 3))) {
                ifBLIN_QX0("No mem");
                sqlite3_result_error_nomem(ctx);
            } else {
                for (j = 0, i = 0; i < len; i++) {
                    q = subst_out[((u_char*)cp)[i]];
                    do  {res[j++] = *q++;} while (*q);
                }
                res[j] = '\0';
                sqlite3_result_text(ctx, res, j, free);
            }
        } else {
            sqlite3_result_text(ctx, cp, -1, SQLITE_TRANSIENT);
    }   }
#   undef blin_internal_flags
}

void
/***********************************************************************************
 ***********************************************************************************
 **                                                                               **/
__pgoblin_sqlite3_regexp(sqlite3_context *ctx, int argc, sqlite3_value **argv) { /**
 **                                                                               **
 ***********************************************************************************
 ***********************************************************************************/
    regex_t    *preg;
    const char *str;
    char       *err;
    int         ex   = 0;
    const char *re;

#   define blin_internal_flags ((u_int32_t)BLIN_I(sqlite3_user_data(ctx)) & BLIN_MASK)
    re = (char*)sqlite3_value_text(argv[0]);
    str = (char*)sqlite3_value_text(argv[1]);
    if  (!re || !str) {
        sqlite3_result_null(ctx);
    } else if (!(preg = malloc(sizeof(regex_t)))) {
        ifBLIN_QX0("regexp: No mem");
        sqlite3_result_error_nomem(ctx);
    } else if (!!(ex = regcomp(preg, re, REG_EXTENDED | REG_NOSUB))) {
        if  (!(err = pgoblin_sqlite3_rerr(ex, preg))) {
            ifBLIN_QX0("regexp: regcomp: No mem");
            sqlite3_result_error_nomem(ctx);
        } else {
            ifBLIN_QX0("regexp: regcomp: %s", err);
            sqlite3_result_error(ctx, err, -1);
        }
        free(err);
    } else if (!(ex = regexec(preg, str, 0, NULL, 0))) {
        sqlite3_result_int(ctx, 1);
    } else if (REG_NOMATCH == ex) {
        sqlite3_result_int(ctx, 0);
    } else {
        if  (!(err = pgoblin_sqlite3_rerr(ex, preg))) {
            ifBLIN_QX0("regexp: rerr: No mem");
            sqlite3_result_error_nomem(ctx);
        } else {
            ifBLIN_QX0("regexp: regexec: %s", err);
            sqlite3_result_error(ctx, err, -1);
        }
        free(err);
    }
#   undef blin_internal_flags
}

void
/****************************************************************************************
 ****************************************************************************************
 **                                                                                    **/
_pgoblin_sqlite3_gettimeofday(sqlite3_context *ctx, int argc, sqlite3_value **argv) { /**
 **                                                                                    **
 ****************************************************************************************
 ****************************************************************************************/
    u_int32_t      flags;
    struct timeval tp;

    flags = (u_int32_t)BLIN_I(sqlite3_user_data(ctx));
#   define blin_internal_flags (flags & BLIN_MASK)
    if  (gettimeofday(&tp, NULL)) {
        ifBLIN_QW0("gettimeofday");
        sqlite3_result_error(ctx, strerror(errno), -1);
    } else {
        sqlite3_result_double(ctx, 0.000001 * tp.tv_usec + tp.tv_sec);
    }
#   undef blin_internal_flags
}

__weak_reference(_pgoblin_sqlite3_gettimeofday, pgoblin_sqlite3_gettimeofday);
__weak_reference(__pgoblin_sqlite3_regexp, _pgoblin_sqlite3_regexp);
__weak_reference(__pgoblin_sqlite3_regexp, pgoblin_sqlite3_regexp);
__weak_reference(_pgoblin_sqlite3_quote_html, pgoblin_sqlite3_quote_html);
__weak_reference(_pgoblin_sqlite3_quote, pgoblin_sqlite3_quote);
