/*-
 * Copyright (C)2008..2018 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2008..2018 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: db_sqlite3.c,v 1.71 2018/09/10 00:47:01 babolo Exp $"

#define BLIN_COMPAT      3
#define Bpars_COMPAT     3
#define MULAR_COMPAT     0
#define MIFE_COMPAT      4
#define PGOBLIN_COMPAT   2
#define PGOBLIN_INTERNAL 1
#define PGOBLIN_MODULE   pgoblin_module

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sysexits.h>
#include <sys/time.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <sqlite3.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <getCGIparm.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

/* expansions to SQLite 3 */

#include <regex.h>

void pgoblin_sqlite3_regexp       __P((sqlite3_context *ctx, int argc, sqlite3_value **argv));
void pgoblin_sqlite3_quote        __P((sqlite3_context *ctx, int argc, sqlite3_value **argv));
void pgoblin_sqlite3_quote_html   __P((sqlite3_context *ctx, int argc, sqlite3_value **argv));
void pgoblin_sqlite3_gettimeofday __P((sqlite3_context *ctx, int argc, sqlite3_value **argv));

#define SQLITE_E  0x000001 /*  E    */
#define SQLITE_SL 0x000002 /*  \                       */
#define SQLITE_SQ 0x000004 /*  '                       */
#define SQLITE_DQ 0x000008 /*  "                       */
#define SQLITE_SF 0x000010 /*  ,          */
#define SQLITE_EE 0x000020 /*   E             */
#define SQLITE_US 0x000040 /*                    */
#define SQLITE_KY 0x000080 /*             */
#define SQLITE_NL 0x000100 /*  \0                     */
#define SQLITE_SS 0x000200 /* \X                          */

void
/*********************************************************************************
 *********************************************************************************
 **                                                                             **/
_pgoblin_sqlite3_quote(sqlite3_context *ctx, int argc, sqlite3_value **argv) { /**
 **                                                                             **
 *********************************************************************************
 *********************************************************************************/
    int         nquotes;
    int         keyword;
    u_int32_t   flags;
    ssize_t     len;
    char       *res;
    const char *cp;
    int         i;
    int         j;

    flags = ~(SQLITE_EE | SQLITE_US) & (u_int32_t)BLIN_I(sqlite3_user_data(ctx));
#   define blin_internal_flags (flags & BLIN_MASK)
    cp = (char*)sqlite3_value_text(argv[0]);
    if  (!cp) {
        sqlite3_result_null(ctx);
    } else {
        len = strlen(cp);
        for (i = 0, nquotes = 0; i < len; i++) {
            if  (cp[i] == '\\') {
                flags |= SQLITE_EE | SQLITE_US;
                if  (flags & SQLITE_SL) nquotes++;
            } else if (cp[i] == '\'') {
                flags |= SQLITE_US;
                if  (flags & SQLITE_SQ) nquotes++;
            } else if (cp[i] == '\"') {
                flags |= SQLITE_US;
                if  (flags & SQLITE_DQ) nquotes++;
            } else if (((cp[i] >= 'a') && (cp[i] <= 'z')) || (cp[i] == '_')) {
            } else if ((cp[i] >= '0') && (cp[i] <= '9')) {
                if  (i == 0) flags |= SQLITE_US;
            } else if (cp[i] == 0) {
                flags |= SQLITE_US | SQLITE_NL;
                if  (flags & SQLITE_SS) nquotes += 3;
            } else if ((cp[i] >= 0x08) && (cp[i] <= 0x0D)) {
                flags |= SQLITE_US;
                if  (flags & SQLITE_SS) nquotes++;
            } else {
                flags |= SQLITE_US;
        }   }
        if  (!(~flags & (SQLITE_E | SQLITE_EE))) nquotes++;
        keyword = 0;
        if  (flags & SQLITE_KY) {
            keyword = babolo_testword(pgoblin.sqlkeywords, cp);
            if  (keyword == UNRESERVED_KEYWORD) keyword = 0;
        }
        if  (nquotes || keyword || !(flags & SQLITE_SF) || (flags & SQLITE_US)) {
            if  (!(res = malloc(len + nquotes + 3))) {
                ifBLIN_QX0("No mem");
                sqlite3_result_error_nomem(ctx);
            } else {
                j = 0;
                if  (!(~flags & (SQLITE_E | SQLITE_EE))) res[j++] = 'E';
                if  (flags & SQLITE_SQ) res[j++] = '\'';
                if  (flags & SQLITE_DQ) res[j++] = '\"';
                for (i = 0; i < len; i++) {
                    if  ((cp[i] == '\\') && (flags & SQLITE_SL)) res[j++] = '\\';
                    if  ((cp[i] == '\'') && (flags & SQLITE_SQ)) res[j++] = '\'';
                    if  ((cp[i] == '\"') && (flags & SQLITE_DQ)) res[j++] = '\"';
                    res[j++] = cp[i];
                }
                if  (flags & SQLITE_DQ) res[j++] = '\"';
                if  (flags & SQLITE_SQ) res[j++] = '\'';
                res[j] = '\0';
                sqlite3_result_text(ctx, res, j, free);
            }
        } else {
            sqlite3_result_text(ctx, cp, -1, SQLITE_TRANSIENT);
    }   }
#   undef blin_internal_flags
}

static const u_char subst_in[]    = {
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,5,0, 0,0,4,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 3,0,3,0,

 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,

 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 5,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,

 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0};

static const char *subst_out[] = {
 "\000"  ,"\001"  ,"\002"  ,"\003"  , "\004"  ,"\005"  ,"\006"  ,"\007",
 "\010"  ,"\011"  ,"\012"  ,"\013"  , "\014"  ,"\015"  ,"\016"  ,"\017",
 "\020"  ,"\021"  ,"\022"  ,"\023"  , "\024"  ,"\025"  ,"\026"  ,"\027",
 "\030"  ,"\031"  ,"\032"  ,"\033"  , "\034"  ,"\035"  ,"\036"  ,"\037",
 "\040"  ,"\041"  ,"&quot;","\043"  , "\044"  ,"\045"  ,"&amp;" ,"\047",
 "\050"  ,"\051"  ,"\052"  ,"\053"  , "\054"  ,"\055"  ,"\056"  ,"\057",
 "\060"  ,"\061"  ,"\062"  ,"\063"  , "\064"  ,"\065"  ,"\066"  ,"\067",
 "\070"  ,"\071"  ,"\072"  ,"\073"  , "&lt;"  ,"\075"  ,"&gt;"  ,"\077",

 "\100"  ,"\101"  ,"\102"  ,"\103"  , "\104"  ,"\105"  ,"\106"  ,"\107",
 "\110"  ,"\111"  ,"\112"  ,"\113"  , "\114"  ,"\115"  ,"\116"  ,"\117",
 "\120"  ,"\121"  ,"\122"  ,"\123"  , "\124"  ,"\125"  ,"\126"  ,"\127",
 "\130"  ,"\131"  ,"\132"  ,"\133"  , "\134"  ,"\135"  ,"\136"  ,"\137",
 "\140"  ,"\141"  ,"\142"  ,"\143"  , "\144"  ,"\145"  ,"\146"  ,"\147",
 "\150"  ,"\151"  ,"\152"  ,"\153"  , "\154"  ,"\155"  ,"\156"  ,"\157",
 "\160"  ,"\161"  ,"\162"  ,"\163"  , "\164"  ,"\165"  ,"\166"  ,"\167",
 "\170"  ,"\171"  ,"\172"  ,"\173"  , "\174"  ,"\175"  ,"\176"  ,"\177",

 "\200"  ,"\201"  ,"\202"  ,"\203"  , "\204"  ,"\205"  ,"\206"  ,"\207",
 "\210"  ,"\211"  ,"\212"  ,"\213"  , "\214"  ,"\215"  ,"\216"  ,"\217",
 "\220"  ,"\221"  ,"\222"  ,"\223"  , "\224"  ,"\225"  ,"\226"  ,"\227",
 "&nbsp;","\231"  ,"\232"  ,"\233"  , "\234"  ,"\235"  ,"\236"  ,"\237",
 "\240"  ,"\241"  ,"\242"  ,"\243"  , "\244"  ,"\245"  ,"\246"  ,"\247",
 "\250"  ,"\251"  ,"\252"  ,"\253"  , "\254"  ,"\255"  ,"\256"  ,"\257",
 "\260"  ,"\261"  ,"\262"  ,"\263"  , "\264"  ,"\265"  ,"\266"  ,"\267",
 "\270"  ,"\271"  ,"\272"  ,"\273"  , "\274"  ,"\275"  ,"\276"  ,"\277",

 "\300"  ,"\301"  ,"\302"  ,"\303"  , "\304"  ,"\305"  ,"\306"  ,"\307",
 "\310"  ,"\311"  ,"\312"  ,"\313"  , "\314"  ,"\315"  ,"\316"  ,"\317",
 "\320"  ,"\321"  ,"\322"  ,"\323"  , "\324"  ,"\325"  ,"\326"  ,"\327",
 "\330"  ,"\331"  ,"\332"  ,"\333"  , "\334"  ,"\335"  ,"\336"  ,"\337",
 "\340"  ,"\341"  ,"\342"  ,"\343"  , "\344"  ,"\345"  ,"\346"  ,"\347",
 "\350"  ,"\351"  ,"\352"  ,"\353"  , "\354"  ,"\355"  ,"\356"  ,"\357",
 "\360"  ,"\361"  ,"\362"  ,"\363"  , "\364"  ,"\365"  ,"\366"  ,"\367",
 "\370"  ,"\371"  ,"\372"  ,"\373"  , "\374"  ,"\375"  ,"\376"  ,"\377"};

void
/**************************************************************************************
 **************************************************************************************
 **                                                                                  **/
_pgoblin_sqlite3_quote_html(sqlite3_context *ctx, int argc, sqlite3_value **argv) { /**
 **                                                                                  **
 **************************************************************************************
 **************************************************************************************/
    int         nquotes;
    u_int32_t   flags;
    ssize_t     len;
    char       *res;
    const char *cp;
    const char *q;
    int         i;
    int         j;

    flags = (u_int32_t)BLIN_I(sqlite3_user_data(ctx));
#   define blin_internal_flags (flags & BLIN_MASK)
    cp = (char*)sqlite3_value_text(argv[0]);
    if  (!cp) {
        sqlite3_result_null(ctx);
    } else {
        len = strlen(cp);
        for (i = 0, nquotes = 0; i < len; i++) nquotes += (int)subst_in[((u_char*)cp)[i]];
        if  (nquotes) {
            if  (!(res = malloc(len + nquotes + 3))) {
                ifBLIN_QX0("No mem");
                sqlite3_result_error_nomem(ctx);
            } else {
                for (j = 0, i = 0; i < len; i++) {
                    q = subst_out[((u_char*)cp)[i]];
                    do  {res[j++] = *q++;} while (*q);
                }
                res[j] = '\0';
                sqlite3_result_text(ctx, res, j, free);
            }
        } else {
            sqlite3_result_text(ctx, cp, -1, SQLITE_TRANSIENT);
    }   }
#   undef blin_internal_flags
}

void
/***********************************************************************************
 ***********************************************************************************
 **                                                                               **/
__pgoblin_sqlite3_regexp(sqlite3_context *ctx, int argc, sqlite3_value **argv) { /**
 **                                                                               **
 ***********************************************************************************
 ***********************************************************************************/
    regex_t    *preg;
    size_t      elen;
    const char *str;
    char       *err;
    int         exx  = 0;
    int         ex   = 0;
    const char *re;

#   define blin_internal_flags ((u_int32_t)BLIN_I(sqlite3_user_data(ctx)) & BLIN_MASK)
    re = (char*)sqlite3_value_text(argv[0]);
    str = (char*)sqlite3_value_text(argv[1]);
    if  (!re || !str) {
        sqlite3_result_null(ctx);
    } else {
        if  (!(preg = sqlite3_get_auxdata(ctx, 0))) {
            if  (!(preg = malloc(sizeof(regex_t)))) {
                sqlite3_result_error_nomem(ctx);
                exx = -2147203043;
            } else if ((ex = regcomp(preg, re, REG_EXTENDED | REG_NOSUB))) {
                exx = -2146484339;
            } else {
                sqlite3_set_auxdata(ctx, 0, preg, (void (*)(void*))regfree);
        }   }
        if  (!exx) {
            ex = regexec(preg, str, 0, NULL, 0);
        }
        switch (exx ? exx : ex) {
        case 0          : sqlite3_result_int(ctx, 1);    break;
        case REG_NOMATCH: sqlite3_result_int(ctx, 0);    break;
        case -2147203043:                                break;
        default         : if  (!(err = malloc((elen = regerror(ex, preg, NULL, 0))))) {
                        ;     sqlite3_result_error_nomem(ctx);
                        ; } else {
                        ;     regerror(ex, preg, err, elen);
                        ;     ifBLIN_QX0("regex %s", err);
                        ;     sqlite3_result_error(ctx, err, -1);
                        ;     free(err);
    }   }               ; }
#   undef blin_internal_flags
}

void
/****************************************************************************************
 ****************************************************************************************
 **                                                                                    **/
_pgoblin_sqlite3_gettimeofday(sqlite3_context *ctx, int argc, sqlite3_value **argv) { /**
 **                                                                                    **
 ****************************************************************************************
 ****************************************************************************************/
    u_int32_t      flags;
    struct timeval tp;

    flags = (u_int32_t)BLIN_I(sqlite3_user_data(ctx));
#   define blin_internal_flags (flags & BLIN_MASK)
    if  (gettimeofday(&tp, NULL)) {
        ifBLIN_QW0("gettimeofday");
        sqlite3_result_error(ctx, strerror(errno), -1);
    } else {
        sqlite3_result_double(ctx, 0.000001 * tp.tv_usec + tp.tv_sec);
    }
#   undef blin_internal_flags
}

__weak_reference(_pgoblin_sqlite3_gettimeofday, pgoblin_sqlite3_gettimeofday);
__weak_reference(__pgoblin_sqlite3_regexp, _pgoblin_sqlite3_regexp);
__weak_reference(__pgoblin_sqlite3_regexp, pgoblin_sqlite3_regexp);
__weak_reference(_pgoblin_sqlite3_quote_html, pgoblin_sqlite3_quote_html);
__weak_reference(_pgoblin_sqlite3_quote, pgoblin_sqlite3_quote);

/* SQLite 3 interface to pgoblin */

#define INDX(R, C) (R * rsv->ncol + C)

#define ERRMSG(W, X) {                                                                                \
    if  ((ex != SQLITE_OK) && (ex != SQLITE_ROW) && (ex != SQLITE_DONE)) {                            \
        ifBLIN_QX0(W " %d: %s", ex, sqlite3_errmsg(conn->odf));                                       \
        ERROUT((X), oxdecode(ex));                                                                    \
}   }

enum states
{ bg /*        */
, bq /* \      */
, bz /*  \0            */
, be /*  \             */
, b1 /*  \[0..7]       */
, b2 /*  \[0..7][0..7] */
, bb /*       */
, bd /* \     */
, bc /*             */
, bt /*        */
, bn /*  \N            */
, bx
};

static const char statenames[][3] =
{ "bg", "bq", "bz", "be", "b1", "b2", "bb", "bd", "bc", "bt", "bn", "bx"
};

typedef struct pgoblin_db_conn {
    BLIN_flag     flags;
/*                PGOBLIN_DB_TYPE                                                                    */
#   define        PGOBLIN_STREAMI 0x010000
#   define        PGOBLIN_STREAMT 0x020000
#   define        PGOBLIN_STREAME 0x040000
#   define        PGOBLIN_ALLOUT  (PGOBLIN_STREAMI | PGOBLIN_STREAMT | PGOBLIN_STREAME)
#   define        PGOBLIN_COPYIN  0x100000
#   define        PGOBLIN_COPYST  0x200000
#   define        PGOBLIN_COPYEN  0x400000
#   define        PGOBLIN_ALLIN   (PGOBLIN_COPYIN | PGOBLIN_COPYST | PGOBLIN_COPYEN)
    int           ncol;
    sqlite3_stmt *vm;
    sqlite3      *odf;
    const char   *query;
    u_char       *semi;                         /*  ,      */
    int           coln;
    u_char        reg;
    enum states   state;
} pgoblin_db_conn;

struct pgoblin_mode {
    BLIN_flag         flags;                                                        /* Must be first */
/*                    PGOBLIN_DB_TYPE                                                                */
#   define            PGOBLIN_TINIT   0x010000
#   define            PGOBLIN_MULAR   0x020000
#   define            PGOBLIN_VM      0x040000
    int               ncol;
    union {
        mular_descriptor *m;
        sqlite3_stmt     *vm;
    };
    char            **serv;
    int               nrow;
};

static size_t mdp[] = {1024, 512, 512};
pgoblin_dbases PGOBLIN_MODULE;

static u_char sqle[] =
{ 0            /* SQLITE_OK         Successful result                          */
, ENOTSUP      /* SQLITE_ERROR      SQL error or missing database              */
, ENOEXEC      /* SQLITE_INTERNAL   An internal logic error in SQLite          */
, EPERM        /* SQLITE_PERM       Access permission denied                   */
, ECANCELED    /* SQLITE_ABORT      Callback routine requested an abort        */
, ETXTBSY      /* SQLITE_BUSY       The database file is locked                */
, EDEADLK      /* SQLITE_LOCKED     A table in the database is locked          */
, ENOMEM       /* SQLITE_NOMEM      A malloc() failed                          */
, EROFS        /* SQLITE_READONLY   Attempt to write a readonly database       */
, EINTR        /* SQLITE_INTERRUPT  Operation terminated by sqlite3_interrupt()*/
, EIO          /* SQLITE_IOERR      Some kind of disk I/O error occurred       */
, EILSEQ       /* SQLITE_CORRUPT    The database disk image is malformed       */
, EFAULT       /* SQLITE_NOTFOUND   (Internal Only) Table or record not found  */
, EOVERFLOW    /* SQLITE_FULL       Insertion failed because database is full  */
, ENOATTR      /* SQLITE_CANTOPEN   Unable to open the database file           */
, ENOLCK       /* SQLITE_PROTOCOL   Database lock protocol error               */
, ENOENT       /* SQLITE_EMPTY      (Internal Only) Database table is empty    */
, EIDRM        /* SQLITE_SCHEMA     The database schema changed                */
, EMSGSIZE     /* SQLITE_TOOBIG     Too much data for one row of a table       */
, EEXIST       /* SQLITE_CONSTRAINT Abort due to contraint violation           */
, EPROCUNAVAIL /* SQLITE_MISMATCH   Data type mismatch                         */
, EINVAL       /* SQLITE_MISUSE     Library used incorrectly                   */
, ENOSYS       /* SQLITE_NOLFS      Uses OS features not supported on host     */
, EAUTH        /* SQLITE_AUTH       Authorization denied                       */
, EFTYPE       /* SQLITE_FORMAT     Auxiliary database format error            */
, EDOM         /* SQLITE_RANGE      2nd parameter to sqlite3_bind out of range */
, EBADF        /* SQLITE_NOTADB     File opened that is not a database file    */
#ifdef SQLITE_NOTICE
, 0            /* SQLITE_NOTICE     Notifications from sqlite3_log()           */
#endif
#ifdef SQLITE_WARNING
, 0            /* SQLITE_WARNING     Warnings from sqlite3_log()               */
#endif
};

static int
/**********************************************************************
 **                                                                  **/
oxdecode(u_int i) {                                                 /**
 **                                                                  **
 **********************************************************************/
    int e;
    if      (i == SQLITE_ROW)                e = EAGAIN;
/*  else if (i == SQLITE_DONE) */
    else if ((i > sizeof(sqle)))             e = ENOMSG;
    else                                     e = sqle[i];
    return(e);
}

static const char *
/**********************************************************************
 **                                                                  **/
exdecode(int ex) {                                                  /**
 **                                                                  **
 **********************************************************************/
    const char *c;
    switch (ex) {
    case SQLITE_OK                     : c = "SQLITE_OK";                      break;
    case SQLITE_ERROR                  : c = "SQLITE_ERROR";                   break;
    case SQLITE_INTERNAL               : c = "SQLITE_INTERNAL";                break;
    case SQLITE_PERM                   : c = "SQLITE_PERM";                    break;
    case SQLITE_ABORT                  : c = "SQLITE_ABORT";                   break;
    case SQLITE_BUSY                   : c = "SQLITE_BUSY";                    break;
    case SQLITE_LOCKED                 : c = "SQLITE_LOCKED";                  break;
    case SQLITE_NOMEM                  : c = "SQLITE_NOMEM";                   break;
    case SQLITE_READONLY               : c = "SQLITE_READONLY";                break;
    case SQLITE_INTERRUPT              : c = "SQLITE_INTERRUPT";               break;
    case SQLITE_IOERR                  : c = "SQLITE_IOERR";                   break;
    case SQLITE_CORRUPT                : c = "SQLITE_CORRUPT";                 break;
    case SQLITE_NOTFOUND               : c = "SQLITE_NOTFOUND";                break;
    case SQLITE_FULL                   : c = "SQLITE_FULL";                    break;
    case SQLITE_CANTOPEN               : c = "SQLITE_CANTOPEN";                break;
    case SQLITE_PROTOCOL               : c = "SQLITE_PROTOCOL";                break;
    case SQLITE_EMPTY                  : c = "SQLITE_EMPTY";                   break;
    case SQLITE_SCHEMA                 : c = "SQLITE_SCHEMA";                  break;
    case SQLITE_TOOBIG                 : c = "SQLITE_TOOBIG";                  break;
    case SQLITE_CONSTRAINT             : c = "SQLITE_CONSTRAINT";              break;
    case SQLITE_MISMATCH               : c = "SQLITE_MISMATCH";                break;
    case SQLITE_MISUSE                 : c = "SQLITE_MISUSE";                  break;
    case SQLITE_NOLFS                  : c = "SQLITE_NOLFS";                   break;
    case SQLITE_AUTH                   : c = "SQLITE_AUTH";                    break;
    case SQLITE_FORMAT                 : c = "SQLITE_FORMAT";                  break;
    case SQLITE_RANGE                  : c = "SQLITE_RANGE";                   break;
    case SQLITE_NOTADB                 : c = "SQLITE_NOTADB";                  break;
#ifdef SQLITE_NOTICE
    case SQLITE_NOTICE                 : c = "SQLITE_NOTICE";                  break;
#endif
#ifdef SQLITE_WARNING
    case SQLITE_WARNING                : c = "SQLITE_WARNING";                 break;
#endif
    case SQLITE_ROW                    : c = "SQLITE_ROW";                     break;
    case SQLITE_DONE                   : c = "SQLITE_DONE";                    break;
#ifdef SQLITE_ERROR_MISSING_COLLSEQ
    case SQLITE_ERROR_MISSING_COLLSEQ  : c = "SQLITE_ERROR_MISSING_COLLSEQ";   break;
#endif
#ifdef SQLITE_ERROR_RETRY
    case SQLITE_ERROR_RETRY            : c = "SQLITE_ERROR_RETRY";             break;
#endif
    case SQLITE_IOERR_READ             : c = "SQLITE_IOERR_READ";              break;
    case SQLITE_IOERR_SHORT_READ       : c = "SQLITE_IOERR_SHORT_READ";        break;
    case SQLITE_IOERR_WRITE            : c = "SQLITE_IOERR_WRITE";             break;
    case SQLITE_IOERR_FSYNC            : c = "SQLITE_IOERR_FSYNC";             break;
    case SQLITE_IOERR_DIR_FSYNC        : c = "SQLITE_IOERR_DIR_FSYNC";         break;
    case SQLITE_IOERR_TRUNCATE         : c = "SQLITE_IOERR_TRUNCATE";          break;
    case SQLITE_IOERR_FSTAT            : c = "SQLITE_IOERR_FSTAT";             break;
    case SQLITE_IOERR_UNLOCK           : c = "SQLITE_IOERR_UNLOCK";            break;
    case SQLITE_IOERR_RDLOCK           : c = "SQLITE_IOERR_RDLOCK";            break;
    case SQLITE_IOERR_DELETE           : c = "SQLITE_IOERR_DELETE";            break;
    case SQLITE_IOERR_BLOCKED          : c = "SQLITE_IOERR_BLOCKED";           break;
    case SQLITE_IOERR_NOMEM            : c = "SQLITE_IOERR_NOMEM";             break;
#ifdef SQLITE_IOERR_ACCESS  /* SQLite 3.6.0 and up */
    case SQLITE_IOERR_ACCESS           : c = "SQLITE_IOERR_ACCESS";            break;
    case SQLITE_IOERR_CHECKRESERVEDLOCK: c = "SQLITE_IOERR_CHECKRESERVEDLOCK"; break;
    case SQLITE_IOERR_LOCK             : c = "SQLITE_IOERR_LOCK";              break;
    case SQLITE_IOERR_CLOSE            : c = "SQLITE_IOERR_CLOSE";             break;
    case SQLITE_IOERR_DIR_CLOSE        : c = "SQLITE_IOERR_DIR_CLOSE";         break;
#endif
#ifdef SQLITE_IOERR_SHMOPEN
    case SQLITE_IOERR_SHMOPEN          : c = "SQLITE_IOERR_SHMOPEN";           break;
#endif
#ifdef SQLITE_IOERR_SHMSIZE
    case SQLITE_IOERR_SHMSIZE          : c = "SQLITE_IOERR_SHMSIZE";           break;
#endif
#ifdef SQLITE_IOERR_SHMLOCK
    case SQLITE_IOERR_SHMLOCK          : c = "SQLITE_IOERR_SHMLOCK";           break;
#endif
#ifdef SQLITE_IOERR_SHMMAP
    case SQLITE_IOERR_SHMMAP           : c = "SQLITE_IOERR_SHMMAP";            break;
#endif
#ifdef SQLITE_IOERR_SEEK
    case SQLITE_IOERR_SEEK             : c = "SQLITE_IOERR_SEEK";              break;
#endif
#ifdef SQLITE_IOERR_DELETE_NOENT
    case SQLITE_IOERR_DELETE_NOENT     : c = "SQLITE_IOERR_DELETE_NOENT";      break;
#endif
#ifdef SQLITE_IOERR_MMAP
    case SQLITE_IOERR_MMAP             : c = "SQLITE_IOERR_MMAP";              break;
#endif
#ifdef SQLITE_IOERR_GETTEMPPATH
    case SQLITE_IOERR_GETTEMPPATH      : c = "SQLITE_IOERR_GETTEMPPATH";       break;
#endif
#ifdef SQLITE_IOERR_CONVPATH
    case SQLITE_IOERR_CONVPATH         : c = "SQLITE_IOERR_CONVPATH";          break;
#endif
#ifdef SQLITE_IOERR_VNODE
    case SQLITE_IOERR_VNODE            : c = "SQLITE_IOERR_VNODE";             break;
#endif
#ifdef SQLITE_IOERR_AUTH
    case SQLITE_IOERR_AUTH             : c = "SQLITE_IOERR_AUTH";              break;
#endif
#ifdef SQLITE_IOERR_BEGIN_ATOMIC
    case SQLITE_IOERR_BEGIN_ATOMIC     : c = "SQLITE_IOERR_BEGIN_ATOMIC";      break;
#endif
#ifdef SQLITE_IOERR_COMMIT_ATOMIC
    case SQLITE_IOERR_COMMIT_ATOMIC    : c = "SQLITE_IOERR_COMMIT_ATOMIC";     break;
#endif
#ifdef SQLITE_IOERR_ROLLBACK_ATOMIC
    case SQLITE_IOERR_ROLLBACK_ATOMIC  : c = "SQLITE_IOERR_ROLLBACK_ATOMIC";   break;
#endif
#ifdef SQLITE_LOCKED_SHAREDCACHE
    case SQLITE_LOCKED_SHAREDCACHE     : c = "SQLITE_LOCKED_SHAREDCACHE";      break;
#endif
#ifdef SQLITE_BUSY_RECOVERY
    case SQLITE_BUSY_RECOVERY          : c = "SQLITE_BUSY_RECOVERY";           break;
#endif
#ifdef SQLITE_BUSY_SNAPSHOT
    case SQLITE_BUSY_SNAPSHOT          : c = "SQLITE_BUSY_SNAPSHOT";           break;
#endif
#ifdef SQLITE_CANTOPEN_NOTEMPDIR
    case SQLITE_CANTOPEN_NOTEMPDIR     : c = "SQLITE_CANTOPEN_NOTEMPDIR";      break;
#endif
#ifdef SQLITE_CANTOPEN_ISDIR
    case SQLITE_CANTOPEN_ISDIR         : c = "SQLITE_CANTOPEN_ISDIR";          break;
#endif
#ifdef SQLITE_CANTOPEN_FULLPATH
    case SQLITE_CANTOPEN_FULLPATH      : c = "SQLITE_CANTOPEN_FULLPATH";       break;
#endif
#ifdef SQLITE_CANTOPEN_CONVPATH
    case SQLITE_CANTOPEN_CONVPATH      : c = "SQLITE_CANTOPEN_CONVPATH";       break;
#endif
#ifdef SQLITE_CORRUPT_VTAB
    case SQLITE_CORRUPT_VTAB           : c = "SQLITE_CORRUPT_VTAB";            break;
#endif
#ifdef SQLITE_READONLY_RECOVERY
    case SQLITE_READONLY_RECOVERY      : c = "SQLITE_READONLY_RECOVERY";       break;
#endif
#ifdef SQLITE_READONLY_CANTLOCK
    case SQLITE_READONLY_CANTLOCK      : c = "SQLITE_READONLY_CANTLOCK";       break;
#endif
#ifdef SQLITE_READONLY_ROLLBACK
    case SQLITE_READONLY_ROLLBACK      : c = "SQLITE_READONLY_ROLLBACK";       break;
#endif
#ifdef SQLITE_READONLY_DBMOVED
    case SQLITE_READONLY_DBMOVED       : c = "SQLITE_READONLY_DBMOVED";        break;
#endif
#ifdef SQLITE_READONLY_CANTINIT
    case SQLITE_READONLY_CANTINIT      : c = "SQLITE_READONLY_CANTINIT";       break;
#endif
#ifdef SQLITE_READONLY_DIRECTORY
    case SQLITE_READONLY_DIRECTORY     : c = "SQLITE_READONLY_DIRECTORY";      break;
#endif
#ifdef SQLITE_ABORT_ROLLBACK
    case SQLITE_ABORT_ROLLBACK         : c = "SQLITE_ABORT_ROLLBACK";          break;
#endif
#ifdef SQLITE_CONSTRAINT_CHECK
    case SQLITE_CONSTRAINT_CHECK       : c = "SQLITE_CONSTRAINT_CHECK";        break;
#endif
#ifdef SQLITE_CONSTRAINT_COMMITHOOK
    case SQLITE_CONSTRAINT_COMMITHOOK  : c = "SQLITE_CONSTRAINT_COMMITHOOK";   break;
#endif
#ifdef SQLITE_CONSTRAINT_FOREIGNKEY
    case SQLITE_CONSTRAINT_FOREIGNKEY  : c = "SQLITE_CONSTRAINT_FOREIGNKEY";   break;
#endif
#ifdef SQLITE_CONSTRAINT_FUNCTION
    case SQLITE_CONSTRAINT_FUNCTION    : c = "SQLITE_CONSTRAINT_FUNCTION";     break;
#endif
#ifdef SQLITE_CONSTRAINT_NOTNULL
    case SQLITE_CONSTRAINT_NOTNULL     : c = "SQLITE_CONSTRAINT_NOTNULL";      break;
#endif
#ifdef SQLITE_CONSTRAINT_PRIMARYKEY
    case SQLITE_CONSTRAINT_PRIMARYKEY  : c = "SQLITE_CONSTRAINT_PRIMARYKEY";   break;
#endif
#ifdef SQLITE_CONSTRAINT_TRIGGER
    case SQLITE_CONSTRAINT_TRIGGER     : c = "SQLITE_CONSTRAINT_TRIGGER";      break;
#endif
#ifdef SQLITE_CONSTRAINT_UNIQUE
    case SQLITE_CONSTRAINT_UNIQUE      : c = "SQLITE_CONSTRAINT_UNIQUE";       break;
#endif
#ifdef SQLITE_CONSTRAINT_VTAB
    case SQLITE_CONSTRAINT_VTAB        : c = "SQLITE_CONSTRAINT_VTAB";         break;
#endif
#ifdef SQLITE_CONSTRAINT_ROWID
    case SQLITE_CONSTRAINT_ROWID       : c = "SQLITE_CONSTRAINT_ROWID";        break;
#endif
#ifdef SQLITE_NOTICE_RECOVER_WAL
    case SQLITE_NOTICE_RECOVER_WAL     : c = "SQLITE_NOTICE_RECOVER_WAL";      break;
#endif
#ifdef SQLITE_NOTICE_RECOVER_ROLLBACK
    case SQLITE_NOTICE_RECOVER_ROLLBACK: c = "SQLITE_NOTICE_RECOVER_ROLLBACK"; break;
#endif
#ifdef SQLITE_WARNING_AUTOINDEX
    case SQLITE_WARNING_AUTOINDEX      : c = "SQLITE_WARNING_AUTOINDEX";       break;
#endif
#ifdef SQLITE_AUTH_USER
    case SQLITE_AUTH_USER              : c = "SQLITE_AUTH_USER";               break;
#endif
#ifdef SQLITE_OK_LOAD_PERMANENTLY
    case SQLITE_OK_LOAD_PERMANENTLY    : c = "SQLITE_OK_LOAD_PERMANENTLY";     break;
#endif
    default                            :
        if  (ex & ~0xFF) c = exdecode(ex & 0xFF); else c = "UNKNOWN";
    }
    return(c);
}

static pgoblin_mode *
/**********************************************************************
 **                                                                  **/
resv(pgoblin_conn *db) {                                            /**
 **                                                                  **
 **********************************************************************/
    pgoblin_mode *rsv = NULL;

    if  (!(rsv = calloc(1, sizeof(pgoblin_mode)))) {
        ifBLIN_QW0("No mem");
    } else {
        rsv->flags = db->flags & (BLIN_MASK | PGOBLIN_DB_TYPE);
    }
    return(rsv);
}

static char *types[] = {NULL, "integer", "float", "text", "blob", "null"};

static int
/**********************************************************************
 **                                                                  **/
collect(sqlite3_stmt *vm, pgoblin_mode *res) {                      /**
 **                                                                  **
 **********************************************************************/
    int ex = EX_OK;

    if  (!!res) {
#       define blin_internal_flags (res->flags & BLIN_MASK)
        if  (!(res->flags & PGOBLIN_TINIT)) {
            res->ncol = sqlite3_column_count(vm);
            res->nrow = 0;
            res->serv = NULL;
            res->flags |= PGOBLIN_TINIT;
            if  (0 < res->ncol) {
                const char *column_name;
                ssize_t     l = 0;
                char       *p;

                for (int y = 0; y < res->ncol; ++y) l += strlen(sqlite3_column_name(vm, y)) + 1;
            /*  for (int y = 0; y < res->ncol; ++y) l += strlen(types[sqlite3_column_type(vm, y)]) + 1;
             *      XXXX */
                ++l;
                if  (!(res->serv = malloc(res->ncol * sizeof(char *) + l))) {
                    ifBLIN_QX0("No mem %"BLIN_D, res->ncol * sizeof(char *) + l);
                    ERROUT(-EX_SOFTWARE, EINVAL);
                }
                p = (char *)&res->serv[res->ncol];
                for (int y = 0; y < res->ncol; ++y) {
                    if  (0 >= l) {
                        ifBLIN_QX0("strings %"BLIN_X" overlow on %d of %d", l, y, res->ncol);
                        break;
                    }
                    column_name = sqlite3_column_name(vm, y);
                    if  (!!column_name) {
                        ifBLIN_QX5("%d[%"BLIN_D"]=%s", y, l, column_name);
                        res->serv[y] = p;
                        p = memccpy(p, column_name, 0, l);
                        l -= p - res->serv[y];
                    } else {
                        res->serv[y] = NULL;
    }   }   }   }   }
out:;
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
init(BLIN_flag flags) {                                             /**
 **                                                                  **
 **********************************************************************/
    int ex = EX_OK;

#   define blin_internal_flags (flags & BLIN_MASK)
#ifdef SQLITE_CONFIG_SINGLETHREAD
    if  (sqlite3_threadsafe()) {
        ex = sqlite3_config(SQLITE_CONFIG_SINGLETHREAD);
        if  (ex != SQLITE_OK) {
            ifBLIN_QX0("sqlite3_config SINGLETHREAD %d: %s", ex, exdecode(ex));
            ERROUT(EX_UNAVAILABLE, oxdecode(ex));
    }   }
#endif
#ifdef SQLITE_CONFIG_MEMSTATUS
    ex = sqlite3_config(SQLITE_CONFIG_MEMSTATUS, 0);
    if  (ex != SQLITE_OK) {
        ifBLIN_QX0("sqlite3_config MEMSTATUS %d: %s", ex, exdecode(ex));
        ERROUT(EX_UNAVAILABLE, oxdecode(ex));
    }
#endif
#if defined(SQLITE_VERSION_NUMBER) && (SQLITE_VERSION_NUMBER >= 3006000)
    ex = sqlite3_initialize();
    if  (ex != SQLITE_OK) {
        ifBLIN_QX0("sqlite3_initialize %d: %s", ex, exdecode(ex));
        ERROUT(EX_UNAVAILABLE, oxdecode(ex));
    }
#endif
#if defined(SQLITE_CONFIG_SINGLETHREAD) || defined(SQLITE_CONFIG_MEMSTATUS) || (defined(SQLITE_VERSION_NUMBER) && (SQLITE_VERSION_NUMBER >= 3006000))
out:
#endif
    if  (!ex) {
        PGOBLIN_MODULE.flags = (PGOBLIN_MODULE.flags & ~(BLIN_MASK | PGOBLIN_DB_TYPE))
                                 | (flags & (BLIN_MASK | PGOBLIN_DB_TYPE))
        ;
    }
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
fini() {                                                            /**
 **                                                                  **
 **********************************************************************/
    int ex = EX_OK;

#   define blin_internal_flags (PGOBLIN_MODULE.flags & BLIN_MASK)
#if defined(SQLITE_VERSION_NUMBER) && (SQLITE_VERSION_NUMBER >= 3006000)
    sqlite3_shutdown();
    if  (ex != SQLITE_OK) {
        ifBLIN_QX0("sqlite3_shutdown %d: %s", ex, exdecode(ex));
        ERROUT(EX_UNAVAILABLE, oxdecode(ex));
    }
out:
#endif
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
shurecon(pgoblin_conn *db) {                                        /**
 **                                                                  **
 **********************************************************************/
    pgoblin_db_conn *conn;
    int              ex     = EX_OK;

#   define blin_internal_flags (db->flags & BLIN_MASK)
    if  (db->conn != NULL) return(0);
    ifBLIN_QX4("lib version=%s", sqlite3_version);
    if  (!(conn = calloc(1, sizeof(pgoblin_db_conn)))) {
        ifBLIN_QX0("no MEM");
        ERROUT(EX_OSERR, ENOMEM);
    }
    conn->flags = db->flags & (BLIN_MASK | PGOBLIN_DB_TYPE);
    ex = sqlite3_open_v2( db->dbname ? db->dbname : ":memory:"
                        , &conn->odf
                        , SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE
                        , NULL
                        );
    if  (!conn->odf) {
        ifBLIN_QX0("aborted");
        ERROUT(EX_UNAVAILABLE, ENODEV);
    }
    ERRMSG("sqlite3_open", EX_UNAVAILABLE);
    MARK_R_CONN_GO(db);;
    ;;  db->conn = conn;
    ;;  db->flags = PGOBLIN_CLOSECONN
 /* ;; */         | (db->flags & ~(BLIN_MASK | PGOBLIN_DB_TYPE))
 /* ;; */         | (PGOBLIN_MODULE.flags & (BLIN_MASK | PGOBLIN_DB_TYPE))
    ;;  ;
    MARK_R_CONN_WENT(db);;
    ex = sqlite3_extended_result_codes(conn->odf, 1);
    ERRMSG("sqlite3_extended_result_codes", EX_UNAVAILABLE);
    ex = sqlite3_create_function( conn->odf
                                , "regexp"
                                , 2
                                , SQLITE_ANY
                                , (void*)(long int)db->flags
                                , pgoblin_sqlite3_regexp
                                , NULL
                                , NULL
                                );
    ERRMSG("regexp creation", EX_DATAERR);
    ex = sqlite3_create_function( conn->odf
                                , "quote_literal"
                                , 1
                                , SQLITE_ANY
                                , (void*)(long int)((db->flags & BLIN_MASK) | SQLITE_SQ)
                                , pgoblin_sqlite3_quote
                                , NULL
                                , NULL
                                );
    ERRMSG("quote_literal creation", EX_DATAERR);
    ex = sqlite3_create_function( conn->odf
                                , "quote_ident"
                                , 1
                                , SQLITE_ANY
                                , (void*)(long int)
                                         ( (db->flags & BLIN_MASK)
                                         | SQLITE_DQ | SQLITE_SF | SQLITE_KY
                                         )
                                , pgoblin_sqlite3_quote
                                , NULL
                                , NULL
                                );
    ERRMSG("quote_ident creation", EX_DATAERR);
    ex = sqlite3_create_function( conn->odf
                                , "quote_ident_always"
                                , 1
                                , SQLITE_ANY
                                , (void*)(long int)((db->flags & BLIN_MASK) | SQLITE_DQ)
                                , pgoblin_sqlite3_quote
                                , NULL
                                , NULL
                                );
    ERRMSG("quote_ident_always creation", EX_DATAERR);
    ex = sqlite3_create_function( conn->odf
                                , "quote_html"
                                , 1
                                , SQLITE_ANY
                                , (void*)(long int)(db->flags & BLIN_MASK)
                                , pgoblin_sqlite3_quote_html
                                , NULL
                                , NULL
                                );
    ERRMSG("quote_html creation", EX_DATAERR);
    ex = sqlite3_create_function( conn->odf
                                , "gettimeofday"
                                , 0
                                , SQLITE_ANY
                                , (void*)(long int)(db->flags & BLIN_MASK)
                                , pgoblin_sqlite3_gettimeofday
                                , NULL
                                , NULL
                                );
    ERRMSG("gettimeofday creation", EX_DATAERR);
    ifBLIN_QO4 {

    }
out:
    return(ex);
#   undef blin_internal_flags
}

/*      0x01..0x0F */
/*   ASCII    */
#define Lx         0x00
#define Lz         0x10
#define Lb ('\b' | 0x20)
#define Lf ('\f' | 0x20)
#define Ln ('\n' | 0x20)
#define Lr ('\r' | 0x20)
#define Lt ('\t' | 0x20)
#define Lv ('\v' | 0x20)
#define L0 ('0') /*0x30*/
#define L1 ('1') /*0x31*/
#define L2 ('2') /*0x32*/
#define L3 ('3') /*0x33*/
#define L4 ('4') /*0x34*/
#define L5 ('5') /*0x35*/
#define L6 ('6') /*0x36*/
#define L7 ('7') /*0x37*/
#define Lc         0x40  /* \t */
#define Ls ('\\')/*0x5C*/
#define Lw         0x60  /* \n */
#define Le         0x70  /*  * */
#define Lu         0x80  /* \N */
#define Ld         0x90  /* \. */
#define LX         0xA0

static const char clasnames[][3] =
{ "Lx", "LX", "LX", "LX",  "LX", "LX", "LX", "LX",  "LX", "LX", "LX", "LX",  "LX", "LX", "LX", "LX"
, "Lz", "LZ", "LZ", "LZ",  "Lz", "LZ", "LZ", "LZ",  "Lz", "LZ", "LZ", "LZ",  "Lz", "LZ", "LZ", "LZ"
, "LL", "LL", "LL", "LL",  "LL", "LL", "LL", "LL",  "Lb", "Lt", "Ln", "Lv",  "Lf", "Lr", "LL", "LL"
, "L0", "L1", "L2", "L3",  "L4", "L5", "L6", "L7",  "LN", "LN", "LN", "LN",  "LN", "LN", "LN", "LN"
, "Lc", "LC", "LC", "LC",  "Lc", "LC", "LC", "LC",  "Lc", "LC", "LC", "LC",  "Lc", "LC", "LC", "LC"
, "LS", "LS", "LS", "LS",  "LS", "LS", "LS", "LS",  "LS", "LS", "LS", "LS",  "Ls", "LS", "LS", "LS"
, "Lw", "LW", "LW", "LW",  "LW", "LW", "LW", "LW",  "LW", "LW", "LW", "LW",  "LW", "LW", "LW", "LW"
, "Le", "LE", "LE", "LE",  "LE", "LE", "LE", "LE",  "LE", "LE", "LE", "LE",  "LE", "LE", "LE", "LE"
, "Lu", "LU", "LU", "LU",  "LU", "LU", "LU", "LU",  "LU", "LU", "LU", "LU",  "LU", "LU", "LU", "LU"
, "Ld", "LD", "LD", "LD",  "LD", "LD", "LD", "LD",  "LD", "LD", "LD", "LD",  "LD", "LD", "LD", "LD"
};

static const u_char class[256] =
{ Lz, Le, Le, Le,  Le, Le, Le, Le,  Le, Lc, Lw, Le,  Le, Le, Le, Le
, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le
, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Ld, Le
, L0, L1, L2, L3,  L4, L5, L6, L7,  Le, Le, Le, Le,  Le, Le, Le, Le

, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Lu, Le
, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Ls, Le, Le, Le
, Le, Le, Lb, Le,  Le, Le, Lf, Le,  Le, Le, Le, Le,  Le, Le, Ln, Le
, Le, Le, Lr, Le,  Lt, Le, Lv, Le,  Le, Le, Le, Le,  Le, Le, Le, Le

, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le
, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le
, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le
, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le

, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le
, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le
, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le
, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le
};

static const char pn[][3] = 
{ "- ", "- ", "- ", "- ", "- ", "- ", "- ", "- "
, "Co", "Cb", "Cr", "Cq", "Cg", "Cp", "Cn", "Cc"
, "Cl", "Cs", "Cx", "Ck", "Cu", "- ", "- ", "- "
};

#define Co 0x00800000 /*              */
#define Cb 0x00400000 /*             */
#define Cr 0x00200000 /*           */
#define Cq 0x00100000 /*                 */
#define Cg 0x00080000 /*   */
#define Cp 0x00040000 /*          */
#define Cn 0x00020000 /* NULL        */
#define Cc 0x00010000 /*             */
#define Cl 0x00008000 /*              */
#define Cs 0x00004000 /* COPY                 */          
#define Cx 0x00002000 /*                     */
#define Ck 0x00001000 /*             */
#define Cu 0x00000800 /*        */
#define C_state  0xFF /*         */

static u_int32_t automa[bx][LX >> 4] =
/* 0 Lx  1 \0 Lz     2 LL     3 LN  4 \t Lc 5  \ Ls     6 \n Lw  7  * Le  8  N Lu  9  . Ld  */
{{Cu|bg,Co|Cc|bz,Co|Cp|bc,Co|Cp|bc,Co|Cc|bb,Co|  bq,Co|Cc|Cl|bg,Co|Cp|bc,Co|Cp|bc,Co|Cp|bc}/* bg */
,{Cu|bq,      bz,   Cg|bc,Cb|   b1,   Cc|bb,     bb,   Cc|Cl|bg,   Cp|bc,   Cn|bt,      bx}/* bq */
,{Cu|bz,      bz,      bz,      bz,   Cc|bb,     bz,   Cc|Cl|bg,      bz,      bz,      bz}/* bz */
,{Ck|be,      bz,   Cg|bc,Cb|   b1,   Cc|bb,  Cp|bc,   Cc|Cl|bg,   Cp|bc,   Cp|bc,   Cp|bc}/* be */
,{Ck|b1,Cq|   bz,Cq|Cp|bc,Cr|   b2,Cq|Cc|bb,Cq|  be,Cq|Cc|Cl|bg,Cq|Cp|bc,Cq|Cp|bc,Cq|Cp|bc}/* b1 */
,{Ck|b2,Cq|   bz,Cq|Cp|bc,Cr|Cq|bc,Cq|Cc|bb,Cq|  be,Cq|Cc|Cl|bg,Cq|Cp|bc,Cq|Cp|bc,Cq|Cp|bc}/* b2 */
,{Cu|bb,Co|Cc|bz,Co|Cp|bc,Co|Cp|bc,Co|Cc|bb,Co|  bd,Co|Cc|Cl|bg,Co|Cp|bc,Co|Cp|bc,Co|Cp|bc}/* bb */
,{Cu|bb,      bz,   Cg|bc,Cb|   b1,   Cc|bb,  Cp|bc,   Cc|Cl|bg,   Cp|bc,   Cn|bn,   Cp|bc}/* bd */
,{Ck|bc,      bz,   Cp|bc,   Cp|bc,   Cc|bb,     be,   Cc|Cl|bg,   Cp|bc,   Cp|bc,   Cp|bc}/* bc */
,{Cu|bt,      bz,   Cx|bx,   Cx|bx,      bb,  Cx|bx,      Cl|bg,   Cx|bx,   Cx|bx,   Cx|bx}/* bt */
,{Cu|bt,      bz,   Cx|bx,   Cx|bx,      bb,  Cx|bx,      Cl|bg,   Cx|bx,   Cx|bx,   Cx|bx}/* bn */
};

static int
/**********************************************************************
 **                                                                  **/
putcopy(pgoblin_conn *db, const void *buf, int nby) {               /**
 **                                                                  **
 **********************************************************************/
    /* sqlite3_bind_text() should not be used for any XXXX */
    u_int32_t        control;
    pgoblin_db_conn *conn = db->conn;
    int              ex   = 0;
    int              i;
    u_char          *c;
    u_char          *p;
    u_char          *q;
    u_char          *b;

#   define blin_internal_flags (db->flags & BLIN_MASK)
    if  (!(conn->flags & (PGOBLIN_COPYIN | PGOBLIN_COPYEN))) { /* XXXX COPYEN   */
        ifBLIN_QX0("not COPYin state");
        ERROUT(-EX_DATAERR, ENODEV);
    }
    if  (!(b = malloc(nby))) {
        ifBLIN_QX0("no mem #0");
        ERROUT(-EX_OSERR, ENOMEM);
    }
    bcopy(buf, b, nby);
    c = p = q = b;
    blin_stateheader(BLIN_4STA24G, pn);
    for (; conn->state < bx; q++) {
        control = automa[conn->state][(q < (b + nby)) ? (class[*q] >> 4) : (Lx >> 4)];
        blin_statebody( BLIN_4STA24G
                      , pn
                      , statenames
                      , clasnames[class[*q]]
                      , (char*)q
                      , p - c
                      , control
                      , conn->state
                      , BLIN_I(q)
                      , conn->reg
                      );
        if  (control & Co) c = p = q;
        if  (control & Cb) conn->reg = class[*q] & 0x07;
        if  (control & Cr) conn->reg = (conn->reg << 3) | (class[*q] & 0x07);
        if  (control & Cq) *(p++) = conn->reg & 0xFF;
        if  (control & Cg) *(p++) = class[*q] & 0x0F;
        if  (control & Cp) {
            if  (p == q) p++; else *(p++) = *q;
        }
        if  ((control & (Cn | Cc | Cl)) && (conn->flags & PGOBLIN_COPYST)) {
            if  (!conn->vm) {
                ifBLIN_QX0("no VM");
                ERROUT(-EX_SOFTWARE, ENOEXEC);
            }
            ex = sqlite3_reset(conn->vm);
            ERRMSG("sqlite3_reset", -EX_SOFTWARE);
            conn->flags &= ~PGOBLIN_COPYST;
        }
        if  (control & Cn) {
            free(conn->semi);
            conn->semi = NULL;
            ifBLIN_QX4("sqlite3_bind_text#1 [%d]NULL", conn->ncol);
            ex = sqlite3_bind_text(conn->vm, ++(conn->ncol), NULL, 0, NULL);
            ERRMSG("sqlite3_bind_text#1", -EX_SOFTWARE);
        }
        if  (control & Cc) { /*   */
            *p = '\0';
            if  (conn->semi) {
                if  (!(p = malloc(strlen((char*)conn->semi) + strlen((char*)c) + 1))) {
                    ifBLIN_QX0("no mem #1");
                    ERROUT(-EX_OSERR, ENOMEM);
                }
                strcpy((char*)p, (char*)conn->semi);
                strcat((char*)p, (char*)c);
                ifBLIN_QX4("sqlite3_bind_text#2 [%d]%d=%s~", conn->ncol, -1, p);
                /* SQLITE_STATIC should be used in most cases instead SQLITE_TRANSIENT XXXX */
                ex = sqlite3_bind_text(conn->vm, ++(conn->ncol), (char*)p, -1, SQLITE_TRANSIENT);
                ERRMSG("sqlite3_bind_text#2", -EX_SOFTWARE);
                free(p);
                free(conn->semi);
                conn->semi = NULL;
            } else {
                ifBLIN_QX4("sqlite3_bind_text#3 [%d]%d=%s~", conn->ncol, -1, c);
                /* SQLITE_STATIC should be used in most cases instead SQLITE_TRANSIENT XXXX */
                ex = sqlite3_bind_text(conn->vm, ++(conn->ncol), (char*)c, -1, SQLITE_TRANSIENT);
                ERRMSG("sqlite3_bind_text#3", -EX_SOFTWARE);
        }   }
        if  (control & Cl) { /*   */
            conn->flags |= PGOBLIN_COPYST;
            ex = sqlite3_step(conn->vm);
            ERRMSG("sqlite3_step#1", -EX_SOFTWARE);
            conn->ncol = 0;
        }
        if  (control & Cs) {
            conn->flags |= PGOBLIN_COPYEN;
            conn->ncol = 0;
        }
        if  (control & Ck) {
            i = p - c;
            if  (!i) break;
            if  (conn->semi) {
                if  (!(p = malloc(strlen((char*)conn->semi) + i + 1))) {
                    ifBLIN_QX0("no mem #2");
                    ERROUT(-EX_OSERR, ENOMEM);
                }
                strcpy((char*)p, (char*)conn->semi);
                bcopy(c, index((char*)p, '\0'), i);
                p[strlen((char*)conn->semi) + i] = '\0';
                free(conn->semi);
                conn->semi = p;
            } else {
                if  (!(conn->semi = malloc(i + 1))) {
                    ifBLIN_QX0("no mem #3");
                    ERROUT(-EX_OSERR, ENOMEM);
                }
                bcopy(c, conn->semi, i);
                conn->semi[i] = '\0';
        }   }
        if  (control & (Ck | Cu)) break;
        conn->state = control & C_state;
    }
    free(b);
out:
    return(ex ? ex : 1);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
clean(pgoblin_mode *rsv) {                                          /**
 **                                                                  **
 **********************************************************************/
    int ex = EX_OK;

#   define blin_internal_flags (rsv->flags & BLIN_MASK)
    if  (!!rsv) {
        if  ((rsv->flags & PGOBLIN_MULAR) && rsv->m) mular_destroy(rsv->m);
        if  ((rsv->flags & PGOBLIN_VM) && rsv->vm) {
            ex = sqlite3_finalize(rsv->vm);
            ifBLIN_QX4("sqlite3_finalize %d %s", ex, exdecode(ex));
            if  ((ex != SQLITE_OK) && (ex != SQLITE_ROW) && (ex != SQLITE_DONE)) {
                ifBLIN_QX0("sqlite3_finalize %d: %s", ex, exdecode(ex));
                errno = oxdecode(ex);
                ex = EX_SOFTWARE;
            }
            rsv->vm = NULL;
        /*  rsv->md = NULL; */
    }   }
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
clear(pgoblin_mode **rsv) {                                         /**
 **                                                                  **
 **********************************************************************/
    int ex = EX_OK;

#   define blin_internal_flags ((*rsv)->flags & BLIN_MASK)
    if  (!!rsv) {
        ex = clean(*rsv);
        if  (!!(*rsv)->serv) free((*rsv)->serv);
        free(*rsv);
        *rsv = NULL;
    }
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
finish(u_int32_t flags, int kind, void **entity) {                  /**
 **                                                                  **
 **********************************************************************/
    int ex = EX_OK;

#   define blin_internal_flags (flags & BLIN_MASK)
    switch (kind) {
    case PGOBLIN_Connect: {
            pgoblin_db_conn **conn = (pgoblin_db_conn **)entity;

            if  (conn && *conn) {
                if  (!!(*conn)->odf) {
                    sqlite3_close_v2((*conn)->odf);
                    (*conn)->odf = NULL;
                }
                free(*conn);
                *conn = NULL;
        }   }
        break;
    case PGOBLIN_FrCOPY:
        if  (entity && *entity) {
            free(*entity);
            *entity = NULL;
        }
        break;
    case PGOBLIN_FrNote:
        break;
    default:
        ex = EX_UNAVAILABLE;
        errno = ENOTSUP;
    }
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
query(pgoblin_conn *db, pgoblin_mode **rsv, char *qry) {            /**
 **                                                                  **
 **********************************************************************/
    BLIN_flag        cond = db->flags & PGOBLIN_CR_MASK;
    pgoblin_db_conn *conn = db->conn;
    int              ncol;
    int              idx;
    pgoblin_mode    *res;
    int              ex   = 0;
    const char      *q;
    char            *p;
    char            *c;
    int              i;
    static const babolo_lexor copy = {(u_char*)
    "\000..." "...."    "  | "    "  .."    "...."    "...."    "...."    "...."
    " .."    "..."    "...."    ".-.."    "IIII"    "IIII"    "II.."    "...."
    ".EEC"    "EEEE"    "EEEE"    "EEEO"    "PEEE"    "EEEE"    "EYE."    "...E"
    ".EEC"    "EEEE"    "EEEE"    "EEEO"    "PEEE"    "EEEE"    "EYE."    "...."
    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"
    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"
    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"
    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"
    , NULL, Bpars_AABS | Bpars_CEND, 0x1C, 0x1C, 1
    ,{/*00*/ 3, ' ', 0x00, '|', 0x00, '-', 0x05, 'C', 0x09, 0xFF
     ,/*05*/ 0, '-', 0x07, 0xFF
     ,/*07*/ 0, '|', 0x00, 0x07
     ,/*09*/ 0, 'O', 0x0B, 0xFF
     ,/*0B*/ 0, 'P', 0x0D, 0xFF
     ,/*0D*/ 0, 'Y', 0x0F, 0xFF
     ,/*0F*/ 8, '', 0xFE, ' ', 0x0F, '|', 0x0F, '-', 0x19, 'C', 0xFD
              , 'O', 0xFD, 'P', 0xFD, 'Y', 0xFD, 'E', 0xFD, 0xFF
     ,/*19*/ 0, '-', 0x1A, 0xFF
     ,/*1A*/ 0, '|', 0x0F, 0x1A
    }};
    /*****************
        * 0 ...
        *   ' --\n'...
        * 1 'COPY "'
        * 1 'COPY --\n "'
        * 1 "COPY '"
        * 1 'COPY\n"'
        * 2 'COPY x'
        * 2 'COPY --\n x'
    *****************/

#   define blin_internal_flags (db->flags & BLIN_MASK)
    ifBLIN_QX4("+ %d=%s~", cond, qry);
    if  (conn->flags & (PGOBLIN_ALLOUT | PGOBLIN_ALLIN)) {
        ifBLIN_QX0("COPY state");
        ERROUT(EX_DATAERR, ENODEV);
    }
    res = NULL;
    if  (qry && *qry) conn->query = qry; else goto out;
    q = conn->query;
    switch (cond) {
    case PGOBLIN_CR_IN:
        conn->coln = 0;
        conn->state = bg;
        conn->semi = NULL;
        switch (babolo_goword(&copy, &q)) {
        case 0:
            ifBLIN_QX4("sqlite3_prepare_v2#1 %d=%s~", cond, conn->query);
            ex = sqlite3_prepare_v2(conn->odf, conn->query, -1, &conn->vm, &conn->query);
            ERRMSG("sqlite3_prepare_v2#1", EX_SOFTWARE);
            conn->flags |= PGOBLIN_COPYIN;
            break;
        case 1:
            if  (!*q) ERROUT(EX_DATAERR, EINVAL);
            q--;
            if  (*q == '\'') {
                for (idx = 1; ;) {
                    if (q[idx++] == '\'' && q[idx] != '\'') break;
                    if (!q[idx]) ERROUT(EX_DATAERR, EINVAL);
                }
            } else if (*q == '\"') {
                for (idx = 1; ;) {
                    if (q[idx++] == '\"' && q[idx] != '\"') break;
                    if (!q[idx]) ERROUT(EX_DATAERR, EINVAL);
                }
            } else ERROUT(EX_DATAERR, EINVAL);
            idx++;
            ifBLIN_QX4("goword quoted %d", idx);
            goto p2;
        case 2:
            q--;
            for (idx = 1; ;) if ((copy.retable[q[idx++] & 0xFF] & 0xC0) != 0x40) break;
            ifBLIN_QX4("goword direct %d", idx);
        p2: if  (!(p = strndup(q, --idx))) {
                ifBLIN_QX0("no mem #0");
                ERROUT(EX_OSERR, ENOMEM);
            }
            conn->query = p;
            if  (asprintf(&c, "SELECT * FROM %s", conn->query) < 0) {
                ifBLIN_QX0("no mem #1");
                ERROUT(EX_OSERR, ENOMEM);
            }
            ifBLIN_QX4("sqlite3_prepare_v2#2 %d=%s~", cond, c);
            ex = sqlite3_prepare_v2(conn->odf, c, -1, &conn->vm, NULL);
            free(c);
            ERRMSG("sqlite3_prepare_v2#2", EX_SOFTWARE);
            if  (!conn->vm) {
                ifBLIN_QX0("no VM #0");
                ERROUT(EX_SOFTWARE, ENOEXEC);
            }
            ex = sqlite3_step(conn->vm);
            ifBLIN_QX4("sqlite3_step %d %s", ex, exdecode(ex));
            if  (ex == SQLITE_ROW || ex == SQLITE_DONE) ex = 0;
            if  (ex) {
                ifBLIN_QX0("sqlite3_step: %d: %s", ex, sqlite3_errmsg(conn->odf));
                if  (conn->vm) {
                    ex = sqlite3_finalize(conn->vm);
                    ERRMSG("sqlite3_finalize", EX_SOFTWARE);
                }
                ERROUT(EX_SOFTWARE, oxdecode(ex));
            }
            ncol = sqlite3_column_count(conn->vm);
            ex = sqlite3_finalize(conn->vm);
            ERRMSG("sqlite3_finalize", EX_SOFTWARE);
            conn->coln = ncol;
            if  (!(p = malloc(2 * ncol * sizeof(char)))) {
                ifBLIN_QX0("no mem #2");
                ERROUT(EX_OSERR, ENOMEM);
            }
            for (i = 0; i < ncol; i++) {
                p[2 * i] = '?';
                p[2 * i + 1] = ',';
            }
            p[2 * ncol - 1] = '\0';
            if  (asprintf(&c, "INSERT INTO %s VALUES(%s)", conn->query, p) < 0) {
                ifBLIN_QX0("no mem #3");
                ERROUT(EX_OSERR, ENOMEM);
            }
            free(p);
            ifBLIN_QX4("sqlite3_prepare_v2#3 %d=%s~", cond, c);
            ex = sqlite3_prepare_v2(conn->odf, c, -1, &conn->vm, NULL);
            free(c);
            ERRMSG("sqlite3_prepare_v2#3", EX_SOFTWARE);
            if  (!conn->vm) {
                ifBLIN_QX0("no VM #1");
                ERROUT(EX_SOFTWARE, ENOEXEC);
        }   }
        conn->ncol = 0;
        conn->flags |= PGOBLIN_COPYIN;
        break;
    case PGOBLIN_CR_OUT:
        switch (babolo_goword(&copy, &q)) {
        case 1:
            if  (!*q) ERROUT(EX_DATAERR, EINVAL);
            q--;
            if  (*q == '\'') {
                for (idx = 1; ;) {
                    if (q[idx++] == '\'' && q[idx] != '\'') break;
                    if (!q[idx]) ERROUT(EX_DATAERR, EINVAL);
                }
            } else if (*q == '\"') {
                for (idx = 1; ;) {
                    if (q[idx++] == '\"' && q[idx] != '\"') break;
                    if (!q[idx]) ERROUT(EX_DATAERR, EINVAL);
                }
            } else ERROUT(EX_DATAERR, EINVAL);
            idx++;
            ifBLIN_QX4("goword quoted %d", idx);
            goto p3;
        case 2:
            q--;
            for (idx = 1; ;) if ((copy.retable[q[idx++] & 0xFF] & 0xC0) != 0x40) break;
            ifBLIN_QX4("goword direct %d", idx);
        p3: if  (!(p = strndup(q, --idx))) {
                ifBLIN_QX0("no mem #5");
                ERROUT(EX_OSERR, ENOMEM);
            }
            conn->query = p;
            if  (asprintf(&c, "SELECT * FROM %s", conn->query) < 0) {
                ifBLIN_QX0("no mem #6");
                ERROUT(EX_OSERR, ENOMEM);
            }
            ifBLIN_QX4("sqlite3_prepare_v2#8 %d=%s~", cond, c);
            ex = sqlite3_prepare_v2(conn->odf, c, -1, &conn->vm, NULL);
            free(c);
            ERRMSG("sqlite3_prepare_v2#8", EX_SOFTWARE);
            if  (!conn->vm) {
                ifBLIN_QX0("no VM #2");
                ERROUT(EX_SOFTWARE, ENOEXEC);
            }
            conn->flags |= PGOBLIN_STREAMI;
            goto out;
        case 0:
            ;
        }   /* FALLTHRU */
    case PGOBLIN_CR_SSEL:
        /*    */
        ifBLIN_QX4("sqlite3_prepare_v2#6 %d=%s~", cond, conn->query);
        ex = sqlite3_prepare_v2(conn->odf, conn->query, -1, &conn->vm, &conn->query);
        ERRMSG("sqlite3_prepare_v2#6", EX_SOFTWARE);
        if  (!conn->vm) {
            ifBLIN_QX0("no VM #3");
            ERROUT(EX_SOFTWARE, ENOEXEC);
        }
        conn->flags |= PGOBLIN_STREAMI;
        break;
    case PGOBLIN_CR_OK:
        while (!ex && conn->query && *conn->query) {
            ifBLIN_QX4("sqlite3_prepare_v2#4 %d=%s~", cond, conn->query);
            ex = sqlite3_prepare_v2(conn->odf, conn->query, -1, &conn->vm, &conn->query);
            ERRMSG("sqlite3_prepare_v2#4", EX_SOFTWARE);
            if  (!conn->vm) {
                ifBLIN_QX4("sqlite3_prepare_v2#4 no VM");
                break;
            }
            ncol = sqlite3_column_count(conn->vm);
            if  (ncol) {
                ifBLIN_QX1("wait for PGOBLIN_CR_OK but received %d cols", ncol);
            }
            for (; ;) {
                ex = sqlite3_step(conn->vm);
                if  (ex == SQLITE_ROW) continue;
                if  (ex == SQLITE_DONE) ex = 0;
                ERRMSG("sqlite3_step#2", EX_SOFTWARE);
                break;
            }
            if  (ex) {
                ifBLIN_QX0("sqlite3_step: %d: %s", ex, sqlite3_errmsg(conn->odf));
                if  (conn->vm) {
                    ex = sqlite3_finalize(conn->vm);
                    ERRMSG("sqlite3_finalize", EX_SOFTWARE);
                }
                ERROUT(EX_SOFTWARE, oxdecode(ex));
            }
            ex = sqlite3_finalize(conn->vm);
            ERRMSG("sqlite3_finalize", EX_SOFTWARE);
        }
        break;
    case PGOBLIN_CR_TUPL:
        /*    */
        if  (!(res = resv(db))) {
            ifBLIN_QX0("no RAM");
            ERROUT(EX_OSERR, ENOMEM);
        }
        while (!ex && conn->query && *conn->query) {
            ifBLIN_QX4("sqlite3_prepare_v2#5 %d=%s~", cond, conn->query);
            ex = sqlite3_prepare_v2(conn->odf, conn->query, -1, &conn->vm, &conn->query);
            ERRMSG("sqlite3_prepare_v2#5", EX_SOFTWARE);
            if  (!conn->vm) {
                ifBLIN_QX4("sqlite3_prepare_v2#5 no VM");
                break;
            }
            collect(conn->vm, res);
            for (; ;) {
                ex = sqlite3_step(conn->vm);
                ERRMSG("sqlite3_step#3", EX_SOFTWARE);
                ifBLIN_QX4("sqlite3_step %d %s", ex, exdecode(ex));
                if  (!(res->flags & PGOBLIN_TINIT)) {
                    res->nrow = 0;
                    res->flags |= PGOBLIN_TINIT;
                }
                if  (ex == SQLITE_ROW) {
                    ex = 0;
                    if  (!(res->flags & PGOBLIN_MULAR)) {
                        res->m = mular_create( MULAR_CHAR | MULAR_ZERO
                                             | MULAR_PFRE | MULAR_STRI | MULAR_UPPE
                                             , 3, sizeof(char*), mdp
                                             );
                        res->m->tofree = free;
                        res->flags |= PGOBLIN_MULAR;
                    }
                    for (ncol = 0; ncol < res->ncol; ncol++) {
                        const u_char *t;
                        char *tt;

                        if  (sqlite3_column_type(conn->vm, ncol) == SQLITE_NULL) {
                            *(char**)(mular_add(res->m)) = NULL;
                        } else if (  (t = sqlite3_column_text(conn->vm, ncol))
                                  && (tt = strdup((char*)t))
                                  ) {
                            *(char**)(mular_add(res->m)) = tt;
                        } else {
                            ifBLIN_QX0("no mem #7");
                            ERROUT(EX_OSERR, ENOMEM);
                    }   }
                    res->nrow++;
                    continue;
                }
                if  (ex == SQLITE_DONE) ex = 0;
                break;
            }
            if  (ex) {
                ifBLIN_QX0("sqlite3_step: %d: %s", ex, sqlite3_errmsg(conn->odf));
                if  (conn->vm) {
                    ex = sqlite3_finalize(conn->vm);
                    ERRMSG("sqlite3_finalize", EX_SOFTWARE);
                }
                ERROUT(EX_SOFTWARE, oxdecode(ex));
            }
            ex = sqlite3_finalize(conn->vm);
            ERRMSG("sqlite3_finalize", EX_SOFTWARE);
        }
        if  (!res->ncol) {
            ifBLIN_QX0("sqlite3_get_table waits for PGOBLIN_CR_TUPL but received no tuples");
            ERROUT(EX_SOFTWARE, ENODEV);
        }
        break;
    case PGOBLIN_CR_BSEL:
    case PGOBLIN_CR_BTUPL:
    default:
        ifBLIN_QX0("illegal cond=%d", cond);
        ex = EX_UNAVAILABLE;
        errno = ENOTSUP;
    }
out:
    if  (rsv) *rsv = res; else if (res) clear(&res);
    ifBLIN_QX4("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
prepare(pgoblin_conn *db, pgoblin_mode **rsv, char *qry) {          /**
 **                                                                  **
 **********************************************************************/
    pgoblin_db_conn *conn = db->conn;
    int              ex   = 0;

#   define blin_internal_flags (db->flags & BLIN_MASK)
    ifBLIN_QX4("+ =%s~", qry);
    if  (!(*rsv = resv(db))) {
        ifBLIN_QX0("no RAM");
        ERROUT(EX_OSERR, ENOMEM);
    }
    if  (conn->flags & (PGOBLIN_ALLOUT | PGOBLIN_ALLIN)) {
        ifBLIN_QX0("COPY state");
        ERROUT(EX_DATAERR, ENODEV);
    }
    if  (!qry || !*qry) goto out;
    ifBLIN_QX4("sqlite3_prepare_v2#4 =%s~", qry);
    ex = sqlite3_prepare_v2(conn->odf, qry, -1, &(*rsv)->vm, NULL);
    ERRMSG("sqlite3_prepare_v2#4", EX_SOFTWARE);
out:
    ifBLIN_QX4("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*************************************************************************************
 **                                                                                 **/
execute(pgoblin_conn *db, pgoblin_mode **rsv, const void *qp, pgoblin_mode *qin) { /**
 **                                                                                 **
 *************************************************************************************/
    BLIN_flag        cond = db->flags & PGOBLIN_ACR_MASK;
    pgoblin_db_conn *conn = db->conn;
    int              ncol;
    pgoblin_mode    *res;
    const char      *qry;
    int              col;
    int              row;
    int              ex   = 0;
    sqlite3_stmt    *vm;

#   define blin_internal_flags (db->flags & BLIN_MASK)
    if  (conn->flags & (PGOBLIN_ALLOUT | PGOBLIN_ALLIN)) {
        ifBLIN_QX0("COPY state");
        ERROUT(EX_DATAERR, ENODEV);
    }
    if  (  (PGOBLIN_CR_OK != (cond & ~PGOBLIN_ALTERQ))
        && (PGOBLIN_CR_TUPL != (cond & ~PGOBLIN_ALTERQ))
        ) {
        ifBLIN_QX0("illegal cond=%d", cond);
        ERROUT(EX_UNAVAILABLE, ENOTSUP);
    }
    if  (cond & PGOBLIN_ALTERQ) {
        ifBLIN_QX4(" %d", cond);
        vm = ((pgoblin_mode *)qp)->vm;
    } else {
        qry = (char *)qp;
        if  (!qry || !*qry) goto out;
        ifBLIN_QX4("sqlite3_prepare_v2#4 %d=%s~", cond, qry);
        ex = sqlite3_prepare_v2(conn->odf, qry, -1, &vm, NULL);
        ERRMSG("sqlite3_prepare_v2#4", EX_SOFTWARE);
    }
    if  (!vm) goto out;
    col = pgoblin_db_resinfo(PGOBLIN_Nfields, qin);
    row = pgoblin_db_resinfo(PGOBLIN_Ntuples, qin);
    for (int i = 0; i < row; i++) {
        for (int j = 0; j < col; j++) {
            ifBLIN_QX4( "sqlite3_bind_text#3 [%d]%d=%s~"
                      , j
                      , pgoblin_db_valinfo(PGOBLIN_Length, qin, i, j)
                      , pgoblin_db_getvalue(qin, i, j)
                      );
            /* SQLITE_STATIC should be used in most cases instead SQLITE_TRANSIENT XXXX */
            ex = sqlite3_bind_text( vm
                                  , j + 1
                                  , pgoblin_db_getvalue(qin, i, j)
                                  , pgoblin_db_valinfo(PGOBLIN_Length, qin, i, j)
                                  , SQLITE_TRANSIENT
                                  );
            ERRMSG("sqlite3_bind_text#3", EX_SOFTWARE);
        }
        res = NULL;
        if  (PGOBLIN_CR_OK == (cond & ~PGOBLIN_ALTERQ)) {
            ncol = sqlite3_column_count(vm);
            if  (ncol) {
                ifBLIN_QX1("wait for PGOBLIN_CR_OK but received %d cols", ncol);
            }
        } else if (i + 1 >= row) {
            if  (!(res = resv(db))) {
                ifBLIN_QX0("no RAM");
                ERROUT(EX_OSERR, ENOMEM);
            }
            collect(vm, res);
        }
        for (; ;) {
            ex = sqlite3_step(vm);
            ERRMSG("sqlite3_step#3", EX_SOFTWARE);
            if  (!!res && !(res->flags & PGOBLIN_TINIT)) {
                res->nrow = 0;
                res->flags |= PGOBLIN_TINIT;
            }
            if  (ex == SQLITE_ROW) {
                if  (!!res) {
                    ex = 0;
                    if  (!(res->flags & PGOBLIN_MULAR)) {
                        res->m = mular_create( MULAR_CHAR | MULAR_ZERO
                                             | MULAR_PFRE | MULAR_STRI | MULAR_UPPE
                                             , 3, sizeof(char*), mdp
                                             );
                        res->m->tofree = free;
                        res->flags |= PGOBLIN_MULAR;
                    }
                    for (int j = 0; j < res->ncol; j++) {
                        const u_char *t;
                        char *tt;

                        if  (sqlite3_column_type(vm, j) == SQLITE_NULL) {
                            *(char**)(mular_add(res->m)) = NULL;
                        } else if ((t = sqlite3_column_text(vm, j)) && (tt = strdup((char*)t))) {
                            *(char**)(mular_add(res->m)) = tt;
                        } else {
                            ifBLIN_QX0("no mem #7");
                            ERROUT(EX_OSERR, ENOMEM);
                    }   }
                    res->nrow++;
                }
                continue;
            }
            if  (ex == SQLITE_DONE) ex = 0;
            break;
        }
        if  (ex) {
            ifBLIN_QX0("sqlite3_step: %d: %s", ex, sqlite3_errmsg(conn->odf));
            if  (vm) {
                ex = sqlite3_finalize(vm);
                ERRMSG("sqlite3_finalize", EX_SOFTWARE);
            }
            ERROUT(EX_SOFTWARE, oxdecode(ex));
        }
        if  (cond & PGOBLIN_ALTERQ) {
            ex = sqlite3_reset(vm);
            ERRMSG("sqlite3_reset", EX_SOFTWARE);
        } else {
            ex = sqlite3_finalize(vm);
            ERRMSG("sqlite3_finalize", EX_SOFTWARE);
        }
        if  (!!res && !res->ncol) {
            ifBLIN_QX0("sqlite3_get_table waits for PGOBLIN_CR_TUPL but received no tuples");
            ERROUT(EX_SOFTWARE, ENODEV);
    }   }
out:
    if  (rsv) *rsv = res; else if (res) clear(&res);
    ifBLIN_QX4("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
get(pgoblin_conn *db, char ***row, pgoblin_mode *rsv) {             /**
 **                                                                  **
 **********************************************************************/
    pgoblin_db_conn *conn = db->conn;
    int              ex   = 0;
    int              i;

#   define blin_internal_flags (db->flags & BLIN_MASK)
    if  (!(conn->flags & PGOBLIN_STREAMI)) {
        ifBLIN_QX0("not COPYout state");
        ERROUT(-EX_DATAERR, ENODEV);
    }
    for (rsv->ncol = 0; !rsv->ncol;) {
        if  (!conn->vm) {
            conn->flags |= PGOBLIN_STREAME;
            break;
        }
        while (!rsv->ncol) {
            collect(conn->vm, rsv);
            ex = sqlite3_step(conn->vm);
            ERRMSG("sqlite3_step#4", -EX_SOFTWARE);
            if  (rsv->ncol) conn->flags |= PGOBLIN_STREAMT;
            if  (ex == SQLITE_ROW) {
                ex = 0;
                if  (!(*row = malloc(sizeof(char**) * rsv->ncol))) {
                    ifBLIN_QX0("no mem #1");
                    ERROUT(EX_OSERR, ENOMEM);
                }
                for (i = 0; i < rsv->ncol; i++) {
                    const u_char *t;

                    if  (sqlite3_column_type(conn->vm, i) == SQLITE_NULL) {
                        (*row)[i] = NULL;
                    } else if (  !(t = sqlite3_column_text(conn->vm, i))
                              || !((*row)[i] = strdup((char*)t))
                              ) {
                        ifBLIN_QX0("no mem #2");
                        ERROUT(EX_OSERR, ENOMEM);
                }   }
                continue;
            }
            if  (ex == SQLITE_DONE) {
                if  (conn->flags & PGOBLIN_STREAMT) conn->flags |= PGOBLIN_STREAME;
                ex = 0;
            }
            break;
        }
        if  (conn->flags & PGOBLIN_STREAME) break;
        if  (ex) {
            ifBLIN_QX0("sqlite3_step: %d: %s", ex, sqlite3_errmsg(conn->odf));
            if  (conn->vm) {
                ex = sqlite3_finalize(conn->vm);
                ERRMSG("sqlite3_finalize", -EX_SOFTWARE);
            }
            ERROUT(-EX_SOFTWARE, oxdecode(ex));
        }
        if  (!rsv->ncol && conn->query && *(conn->query)) {
            ex = sqlite3_finalize(conn->vm);
            ERRMSG("sqlite3_finalize", -EX_SOFTWARE);
            ifBLIN_QX4("sqlite3_prepare_v2#7 =%s~", conn->query);
            ex = sqlite3_prepare_v2(conn->odf, conn->query, -1, &conn->vm, &conn->query);
            ERRMSG("sqlite3_prepare_v2#7", -EX_SOFTWARE);
    }   }
    if  (!row) conn->flags |= PGOBLIN_STREAME;
out:
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
getstream(pgoblin_conn *db, pgoblin_mode **rsv, int quant) {        /**
 **                                                                  **
 **********************************************************************/
    pgoblin_db_conn *conn = db->conn;
    char           **row;
    int              ex   = EX_OK;
    int              i;

#   define blin_internal_flags (db->flags & BLIN_MASK)
    if  (!rsv) {
        ifBLIN_QX0("no res");
        ERROUT(EX_USAGE, EINVAL);
    }
    if  (!!*rsv) clear(rsv);
    if  (!(*rsv = resv(db))) {
        ifBLIN_QX0("no RAM");
        ERROUT(EX_OSERR, ENOMEM);
    }
    if  (!!(ex = get(db, &row, *rsv))) goto out;
    (*rsv)->nrow = 0;
    if  (conn->flags & PGOBLIN_STREAME) {
        ex = 0;
    } else {
        (*rsv)->m = mular_create( MULAR_CHAR | MULAR_ZERO | MULAR_PFRE | MULAR_STRI | MULAR_UPPE
                                , 3, sizeof(u_char*), mdp
                                );
        (*rsv)->m->tofree = free;
        (*rsv)->flags |= PGOBLIN_MULAR;
        for (i = 0; i < (*rsv)->ncol; ++i) {
            if (!row[i]) {
               *(char**)(mular_add((*rsv)->m)) = NULL;
            } else if (!(*(char**)(mular_add((*rsv)->m)) = row[i])) {
                ifBLIN_QX0("no mem");
                ERROUT(EX_OSERR, ENOMEM);
        }   }
        (*rsv)->nrow = 1;
        free(row);
        row = NULL;
    }
out:
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
getcopy(pgoblin_conn *db, void **buf) {                             /**
 **                                                                  **
 **********************************************************************/
    pgoblin_db_conn *conn = db->conn;
    pgoblin_mode    *res  = resv(db);
    int              ex   = 0;
    char           **row;

#   define blin_internal_flags (db->flags & BLIN_MASK)
    if  ((ex = get(db, &row, res))) goto out;
    /* XXXX         */
    if  (conn->flags & PGOBLIN_STREAME) {
        *buf = NULL;
        ex = 0;
    } else {
        int i, l;
        char *c;

        for (i = 0, l = 2; i < res->ncol; i++) {
            if (row[i]) l += strlen(row[i]) * 2 + 1; else l += 3;
        }
        *buf = malloc(l);
        for (i = 0; i < res->ncol; i++) {
            if  ((c = row[i])) {
                if  (getCGIparmpass3(0, (u_char*)"copy", (u_char**)&c)) {
                    ifBLIN_QX0("getCGIparmpass3");
                    ex = -EX_SOFTWARE;
                    goto out;
                }
            } else {
                c = "\\N";
            }
            if  (i) strcat(*buf, c); else strcpy(*buf, c);
            if  (row[i] && (c != row[i])) free(c);
            free(row[i]);
            if  (i < (res->ncol - 1)) strcat(*buf, "\t"); else strcat(*buf, "\n");
        }
        free(row);
        ex = strlen(*buf);
    }
out:
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
endstream(pgoblin_conn *db) {                                       /**
 **                                                                  **
 **********************************************************************/
    BLIN_flag        cond = db->flags & PGOBLIN_CR_MASK;
    pgoblin_db_conn *conn = db->conn;
    int              ex   = 0;

#   define blin_internal_flags (db->flags & BLIN_MASK)
    switch (cond) {
    case PGOBLIN_CR_SSEL:
    case PGOBLIN_CR_OUT:
        if  (!(conn->flags & PGOBLIN_STREAMI)) {
            ifBLIN_QX0("not stream state");
            ERROUT(-EX_DATAERR, ENODEV);
        }
        ex = sqlite3_finalize(conn->vm);
        conn->flags &= ~PGOBLIN_ALLOUT;
        ERRMSG("sqlite3_finalize", EX_SOFTWARE);
        break;
    case PGOBLIN_CR_IN:
        if  (!(conn->flags & PGOBLIN_COPYIN)) {
            ifBLIN_QX0("not COPYin state");
            ERROUT(-EX_DATAERR, ENODEV);
        }
        ex = sqlite3_finalize(conn->vm);
        conn->flags &= ~PGOBLIN_ALLIN;
        ERRMSG("sqlite3_finalize", EX_SOFTWARE);
        break;
    default:
        ifBLIN_QX0("- %d", cond);
        ex = -EX_UNAVAILABLE;
        errno = ENOTSUP;
    }
out:
    conn->flags = 0;
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
resinfo(int kind, pgoblin_mode *rsv) {                              /**
 **                                                                  **
 **********************************************************************/
    int ex;

    switch (kind) {
    case PGOBLIN_Ntuples: ex = rsv ? rsv->nrow : 0; break;
    case PGOBLIN_Nfields: ex = rsv ? rsv->ncol : 0; break;
    default             :
        ex = -EX_UNAVAILABLE;
        errno = ENOTSUP;
    }
    return(ex);
}

static const char *
/**********************************************************************
 **                                                                  **/
subinfo(int kind, pgoblin_mode *rsv, int sub) {                     /**
 **                                                                  **
 **********************************************************************/
    const char *cx = NULL;

    switch (kind) {
    case PGOBLIN_ColName:
        if  (!!rsv->serv && (rsv->ncol > sub)) cx = rsv->serv[sub];
        break;
    default:;
    }
    return(cx);
}

static char *
/**********************************************************************
 **                                                                  **/
erinfo(pgoblin_mode *rsv) {                                         /**
 **                                                                  **
 **********************************************************************/
    char *cx = NULL;

    return(cx);
}

static int
/**********************************************************************
 **                                                                  **/
valinfo(int kind, pgoblin_mode *rsv, int row, int col) {            /**
 **                                                                  **
 **********************************************************************/
    int ex;

#   define blin_internal_flags (rsv->flags & BLIN_MASK)
    switch (kind) {
    case PGOBLIN_IsNull:
        if  (rsv) {
            if  (rsv->flags & PGOBLIN_VM) {
                ifBLIN_QX1("VM instead of MULAR");
                ex = -EX_SOFTWARE;
                errno = EDOOFUS;
            } else if (!(rsv->flags & PGOBLIN_MULAR)) {
                ifBLIN_QX0("NOTHING instead of MULAR");
                ex = -EX_SOFTWARE;
                errno = EDOOFUS;
            } else if ((row >= 0) && (row < rsv->nrow) && (col >= 0) && (col < rsv->ncol)) {
                ex = !*(char**)mular_getix(rsv->m, INDX(row, col));
            } else {
                ifBLIN_QX1( "+ row %d %s in [0..%d], col %d %s in [0..%d]"
                          , row, (row >= 0 && row < rsv->nrow) ? "" : "NOT", rsv->nrow
                          , col, (col >= 0 && col < rsv->ncol) ? "" : "NOT", rsv->ncol
                          );
                ex = -EX_SOFTWARE;
                errno = EDOOFUS;
            }
        } else if (row == 0 && col == 0) {
            ex = 1;
        } else {
            ifBLIN_QX1("row %d col %d in emty", row, col);
            ex = -EX_SOFTWARE;
            errno = EDOOFUS;
        }
        break;
    case PGOBLIN_Length:
        switch (valinfo(PGOBLIN_IsNull, rsv, row, col)) {
        case  1:
            ex = 0;
            break;
        case  0:
            if  (rsv->flags & PGOBLIN_MULAR) {
                ex = strlen(*(char**)mular_getix(rsv->m, INDX(row, col)));
            } else if (rsv->flags & PGOBLIN_VM) {
                ifBLIN_QX0("VM instead of MULAR");
                ex = -EX_SOFTWARE;
                errno = EDOOFUS;
            } else {
                ifBLIN_QX0("NOTHING instead of MULAR");
                ex = -EX_SOFTWARE;
                errno = EDOOFUS;
            }
            break;
        default:
            ex = -EX_SOFTWARE;
            errno = EDOOFUS;
        }
        break;
    default:
        ex = -EX_UNAVAILABLE;
        errno = ENOTSUP;
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static char *
/**********************************************************************
 **                                                                  **/
getvalue(pgoblin_mode *rsv, int row, int col) {                     /**
 **                                                                  **
 **********************************************************************/
    char *c = NULL;

    if  (!valinfo(PGOBLIN_IsNull, rsv, row, col)) {
        if  (rsv->flags & PGOBLIN_VM) {
            ifBLIN_QX0("VM instead of MULAR");
            errno = EDOOFUS;
        } else if (rsv->flags & PGOBLIN_MULAR) {
            c = *(char**)mular_getix(rsv->m, INDX(row, col));
            ifBLIN_QX4("mular=%s~", c);
        } else {
            ifBLIN_QX0("NOTHING instead of MULAR");
            errno = EDOOFUS;
    }   }
    return(c);
}

pgoblin_dbases PGOBLIN_MODULE =
{ (PGOBLIN_DB_PREPARE | PGOBLIN_DB_COPYIN | PGOBLIN_DB_COPYOUT)
, "3pGoblin-" VERS
, "sqlite3\0" VERS
, 0
, init
, fini
, shurecon
, query
, prepare
, execute
, resinfo
, subinfo
, erinfo
, valinfo
, getvalue
, getstream
, getcopy
, putcopy
, endstream
, NULL /* tarry    */
, NULL /* notifies */
, finish
, clear
, NULL
, NULL
};
