/*-
 * Copyright (C)2008..2020 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: pgoblin3sqlite2.h,v 1.2 2020/09/09 19:09:20 babolo Exp $
 */

#ifndef BLIN_4STX24G
# define BLIN_4STX24G    ((blin_statectl){{4, 1, 8, 24, ' ', 5, 1, 0, 1}})
#endif

#define SQLITE_E  0x000001 /*  E    */
#define SQLITE_SL 0x000002 /*  \                       */
#define SQLITE_SQ 0x000004 /*  '                       */
#define SQLITE_DQ 0x000008 /*  "                       */
#define SQLITE_SF 0x000010 /*  ,          */
#define SQLITE_EE 0x000020 /*   E             */
#define SQLITE_US 0x000040 /*                    */
#define SQLITE_KY 0x000080 /*             */
#define SQLITE_NL 0x000100 /*  \0                     */
#define SQLITE_SS 0x000200 /* \X                          */

typedef enum states
{ bg /*        */
, bq /* \      */
, bz /*  \0            */
, be /*  \             */
, b1 /*  \[0..7]       */
, b2 /*  \[0..7][0..7] */
, bb /*       */
, bd /* \     */
, bc /*             */
, bt /*        */
, bn /*  \N            */
, bx
} states;

typedef struct pgoblin_db_conn {
    BLIN_flag     flags;
/*                PGOBLIN_DB_TYPE                                                                    */
#   define        PGOBLIN_STREAMI 0x010000
#   define        PGOBLIN_STREAMT 0x020000
#   define        PGOBLIN_STREAME 0x040000
#   define        PGOBLIN_ALLOUT  (PGOBLIN_STREAMI | PGOBLIN_STREAMT | PGOBLIN_STREAME)
#   define        PGOBLIN_COPYIN  0x100000
#   define        PGOBLIN_COPYST  0x200000
#   define        PGOBLIN_COPYEN  0x400000
#   define        PGOBLIN_ALLIN   (PGOBLIN_COPYIN | PGOBLIN_COPYST | PGOBLIN_COPYEN)
    int           ncol;
    sqlite_vm    *vm;
    sqlite       *odf;
    char         *query;
    u_char       *semi;                         /*  ,      */
    int           coln;
    u_char        reg;
    enum states   state;
} pgoblin_db_conn;

void pgoblin_sqlite2_regexp       __P((sqlite_func *ctx, int argc, const char **argv));
void pgoblin_sqlite2_quote        __P((sqlite_func *ctx, int argc, const char **argv));
void pgoblin_sqlite2_quote_html   __P((sqlite_func *ctx, int argc, const char **argv));
void pgoblin_sqlite2_gettimeofday __P((sqlite_func *ctx, int argc, const char **argv));
void pgoblin_sqlite2_instr        __P((sqlite_func *ctx, int argc, const char **argv));
