/*-
 * Copyright (C)2008..2020 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2008..2020 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: ex_sqlite2.c,v 1.101 2020/09/09 19:09:20 babolo Exp $"

#define BLIN_COMPAT      3
#define Bpars_COMPAT     3
#define MULAR_COMPAT     0
#define MIFE_COMPAT      4
#define PGOBLIN_COMPAT   2
#define PGOBLIN_INTERNAL 1
#define PGOBLIN_MODULE   pgoblin_module

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sysexits.h>
#include <sys/time.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <regex.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <sqlite.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <mife.h>
#include "pgoblin.h"
#include "pgoblin3sqlite2.h"

/* expansions to SQLite 2 */

void
/**************************************************************************
 **************************************************************************
 **                                                                      **/
_pgoblin_sqlite2_quote(sqlite_func *ctx, int argc, const char **argv) { /**
 **                                                                      **
 **************************************************************************
 **************************************************************************/
    int         nquotes;
    int         keyword;
    u_int32_t   flags;
    ssize_t     len;
    char       *res;
    const char *cp;
    int         i;
    int         j;

    flags = ~(SQLITE_EE | SQLITE_US) & (u_int32_t)BLIN_I(sqlite_user_data(ctx));
#   define blin_internal_flags (flags & BLIN_MASK)
    cp = argv[0];
    if  (!cp) {
        /* NULL */
    } else {
        len = strlen(cp);
        for (i = 0, nquotes = 0; i < len; i++) {
            if  (cp[i] == '\\') {
                flags |= SQLITE_EE | SQLITE_US;
                if  (flags & SQLITE_SL) nquotes++;
            } else if (cp[i] == '\'') {
                flags |= SQLITE_US;
                if  (flags & SQLITE_SQ) nquotes++;
            } else if (cp[i] == '\"') {
                flags |= SQLITE_US;
                if  (flags & SQLITE_DQ) nquotes++;
            } else if (((cp[i] >= 'a') && (cp[i] <= 'z')) || (cp[i] == '_')) {
            } else if ((cp[i] >= '0') && (cp[i] <= '9')) {
                if  (i == 0) flags |= SQLITE_US;
            } else if (cp[i] == 0) {
                flags |= SQLITE_US | SQLITE_NL;
                if  (flags & SQLITE_SS) nquotes += 3;
            } else if ((cp[i] >= 0x08) && (cp[i] <= 0x0D)) {
                flags |= SQLITE_US;
                if  (flags & SQLITE_SS) nquotes++;
            } else {
                flags |= SQLITE_US;
        }   }
        if  (!(~flags & (SQLITE_E | SQLITE_EE))) nquotes++;
        keyword = 0;
        if  (flags & SQLITE_KY) {
            keyword = babolo_testword(pgoblin.sqlkeywords, cp);
            if  (keyword == UNRESERVED_KEYWORD) keyword = 0;
        }
        if  (nquotes || keyword || !(flags & SQLITE_SF) || (flags & SQLITE_US)) {
            if  (!(res = malloc(len + nquotes + 3))) {
                ifBLIN_QX0("No mem");
                sqlite_set_result_error(ctx, "No mem", -1);
            } else {
                j = 0;
                if  (!(~flags & (SQLITE_E | SQLITE_EE))) res[j++] = 'E';
                if  (flags & SQLITE_SQ) res[j++] = '\'';
                if  (flags & SQLITE_DQ) res[j++] = '\"';
                for (i = 0; i < len; i++) {
                    if  ((cp[i] == '\\') && (flags & SQLITE_SL)) res[j++] = '\\';
                    if  ((cp[i] == '\'') && (flags & SQLITE_SQ)) res[j++] = '\'';
                    if  ((cp[i] == '\"') && (flags & SQLITE_DQ)) res[j++] = '\"';
                    res[j++] = cp[i];
                }
                if  (flags & SQLITE_DQ) res[j++] = '\"';
                if  (flags & SQLITE_SQ) res[j++] = '\'';
                res[j] = '\0';
                sqlite_set_result_string(ctx, res, j);
            }
        } else {
            sqlite_set_result_string(ctx, cp, -1);
    }   }
#   undef blin_internal_flags
}

static const u_char subst_in[]    = {
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,5,0, 0,0,4,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 3,0,3,0,

 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,

 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 5,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,

 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0};

static const char *subst_out[] = {
 "\000"  ,"\001"  ,"\002"  ,"\003"  , "\004"  ,"\005"  ,"\006"  ,"\007",
 "\010"  ,"\011"  ,"\012"  ,"\013"  , "\014"  ,"\015"  ,"\016"  ,"\017",
 "\020"  ,"\021"  ,"\022"  ,"\023"  , "\024"  ,"\025"  ,"\026"  ,"\027",
 "\030"  ,"\031"  ,"\032"  ,"\033"  , "\034"  ,"\035"  ,"\036"  ,"\037",
 "\040"  ,"\041"  ,"&quot;","\043"  , "\044"  ,"\045"  ,"&amp;" ,"\047",
 "\050"  ,"\051"  ,"\052"  ,"\053"  , "\054"  ,"\055"  ,"\056"  ,"\057",
 "\060"  ,"\061"  ,"\062"  ,"\063"  , "\064"  ,"\065"  ,"\066"  ,"\067",
 "\070"  ,"\071"  ,"\072"  ,"\073"  , "&lt;"  ,"\075"  ,"&gt;"  ,"\077",

 "\100"  ,"\101"  ,"\102"  ,"\103"  , "\104"  ,"\105"  ,"\106"  ,"\107",
 "\110"  ,"\111"  ,"\112"  ,"\113"  , "\114"  ,"\115"  ,"\116"  ,"\117",
 "\120"  ,"\121"  ,"\122"  ,"\123"  , "\124"  ,"\125"  ,"\126"  ,"\127",
 "\130"  ,"\131"  ,"\132"  ,"\133"  , "\134"  ,"\135"  ,"\136"  ,"\137",
 "\140"  ,"\141"  ,"\142"  ,"\143"  , "\144"  ,"\145"  ,"\146"  ,"\147",
 "\150"  ,"\151"  ,"\152"  ,"\153"  , "\154"  ,"\155"  ,"\156"  ,"\157",
 "\160"  ,"\161"  ,"\162"  ,"\163"  , "\164"  ,"\165"  ,"\166"  ,"\167",
 "\170"  ,"\171"  ,"\172"  ,"\173"  , "\174"  ,"\175"  ,"\176"  ,"\177",

 "\200"  ,"\201"  ,"\202"  ,"\203"  , "\204"  ,"\205"  ,"\206"  ,"\207",
 "\210"  ,"\211"  ,"\212"  ,"\213"  , "\214"  ,"\215"  ,"\216"  ,"\217",
 "\220"  ,"\221"  ,"\222"  ,"\223"  , "\224"  ,"\225"  ,"\226"  ,"\227",
 "&nbsp;","\231"  ,"\232"  ,"\233"  , "\234"  ,"\235"  ,"\236"  ,"\237",
 "\240"  ,"\241"  ,"\242"  ,"\243"  , "\244"  ,"\245"  ,"\246"  ,"\247",
 "\250"  ,"\251"  ,"\252"  ,"\253"  , "\254"  ,"\255"  ,"\256"  ,"\257",
 "\260"  ,"\261"  ,"\262"  ,"\263"  , "\264"  ,"\265"  ,"\266"  ,"\267",
 "\270"  ,"\271"  ,"\272"  ,"\273"  , "\274"  ,"\275"  ,"\276"  ,"\277",

 "\300"  ,"\301"  ,"\302"  ,"\303"  , "\304"  ,"\305"  ,"\306"  ,"\307",
 "\310"  ,"\311"  ,"\312"  ,"\313"  , "\314"  ,"\315"  ,"\316"  ,"\317",
 "\320"  ,"\321"  ,"\322"  ,"\323"  , "\324"  ,"\325"  ,"\326"  ,"\327",
 "\330"  ,"\331"  ,"\332"  ,"\333"  , "\334"  ,"\335"  ,"\336"  ,"\337",
 "\340"  ,"\341"  ,"\342"  ,"\343"  , "\344"  ,"\345"  ,"\346"  ,"\347",
 "\350"  ,"\351"  ,"\352"  ,"\353"  , "\354"  ,"\355"  ,"\356"  ,"\357",
 "\360"  ,"\361"  ,"\362"  ,"\363"  , "\364"  ,"\365"  ,"\366"  ,"\367",
 "\370"  ,"\371"  ,"\372"  ,"\373"  , "\374"  ,"\375"  ,"\376"  ,"\377"};

void
/*******************************************************************************
 *******************************************************************************
 **                                                                           **/
_pgoblin_sqlite2_quote_html(sqlite_func *ctx, int argc, const char **argv) { /**
 **                                                                           **
 *******************************************************************************
 *******************************************************************************/
    int         nquotes;
    u_int32_t   flags;
    ssize_t     len;
    char       *res;
    const char *cp;
    const char *q;
    int         i;
    int         j;

    flags = (u_int32_t)BLIN_I(sqlite_user_data(ctx));
#   define blin_internal_flags (flags & BLIN_MASK)
    cp = argv[0];
    if  (!cp) {
        /* NULL */
    } else {
        len = strlen(cp);
        for (i = 0, nquotes = 0; i < len; i++) nquotes += (int)subst_in[((u_char*)cp)[i]];
        if  (nquotes) {
            if  (!(res = malloc(len + nquotes + 3))) {
                ifBLIN_QX0("No mem");
                sqlite_set_result_error(ctx, "No mem", -1);
            } else {
                for (j = 0, i = 0; i < len; i++) {
                    q = subst_out[((u_char*)cp)[i]];
                    do  {res[j++] = *q++;} while (*q);
                }
                res[j] = '\0';
                sqlite_set_result_string(ctx, res, j);
            }
        } else {
            sqlite_set_result_string(ctx, cp, -1);
    }   }
#   undef blin_internal_flags
}

void
/****************************************************************************
 ****************************************************************************
 **                                                                        **/
__pgoblin_sqlite2_regexp(sqlite_func *ctx, int argc, const char **argv) { /**
 **                                                                        **
 ****************************************************************************
 ****************************************************************************/
    regex_t    *preg;
    size_t      elen;
    char       *err;
    int         exx  = 0;
    int         ex   = 0;

#   define blin_internal_flags ((u_int32_t)BLIN_I(sqlite_user_data(ctx)) & BLIN_MASK)
    if  (!argv[0] || !argv[1]) {
        /* NULL */
    } else {
        if  (!(preg = malloc(sizeof(regex_t)))) {
            sqlite_set_result_error(ctx, "No mem", -1);
            exx = -2147203043;
        } else if ((ex = regcomp(preg, argv[0], REG_EXTENDED | REG_NOSUB))) {
            exx = -2146484339;
        }
        if  (!exx) {
            ex = regexec(preg, argv[1], 0, NULL, 0);
        }
        switch (exx ? exx : ex) {
        case 0          : sqlite_set_result_int(ctx, 1); break;
        case REG_NOMATCH: sqlite_set_result_int(ctx, 0); break;
        case -2147203043:                                break;
        default         : if  (!(err = malloc((elen = regerror(ex, preg, NULL, 0))))) {
                        ;     sqlite_set_result_error(ctx, "No mem", -1);
                        ; } else {
                        ;     regerror(ex, preg, err, elen);
                        ;     ifBLIN_QX0("regex %s", err);
                        ;     sqlite_set_result_error(ctx, err, -1);
                        ;     free(err);
    }   }               ; }
#   undef blin_internal_flags
}

void
/*********************************************************************************
 *********************************************************************************
 **                                                                             **/
_pgoblin_sqlite2_gettimeofday(sqlite_func *ctx, int argc, const char **argv) { /**
 **                                                                             **
 *********************************************************************************
 *********************************************************************************/
    u_int32_t      flags;
    struct timeval tp;

    flags = (u_int32_t)BLIN_I(sqlite_user_data(ctx));
#   define blin_internal_flags (flags & BLIN_MASK)
    if  (gettimeofday(&tp, NULL)) {
        ifBLIN_QW0("gettimeofday");
        sqlite_set_result_error(ctx, strerror(errno), -1);
    } else {
        sqlite_set_result_double(ctx, 0.000001 * tp.tv_usec + tp.tv_sec);
    }
#   undef blin_internal_flags
}

void
/*********************************************************************************
 *********************************************************************************
 **                                                                             **/
_pgoblin_sqlite2_instr(sqlite_func *ctx, int argc, const char **argv) { /**
 **                                                                             **
 *********************************************************************************
 *********************************************************************************/
    u_int32_t      flags;
    int            ret = 0;
    char          *found;

    flags = (u_int32_t)BLIN_I(sqlite_user_data(ctx));
#   define blin_internal_flags (flags & BLIN_MASK)
    if  (!!argv[0] && !!argv[1] && !!(found = strstr(argv[0], argv[1]))) {
        ret = (int)(found - argv[0]) + 1;
    }
    sqlite_set_result_int(ctx, ret);
}

__weak_reference(_pgoblin_sqlite2_gettimeofday, pgoblin_sqlite2_gettimeofday);
__weak_reference(__pgoblin_sqlite2_regexp, _pgoblin_sqlite2_regexp);
__weak_reference(__pgoblin_sqlite2_regexp, pgoblin_sqlite2_regexp);
__weak_reference(_pgoblin_sqlite2_quote_html, pgoblin_sqlite2_quote_html);
__weak_reference(_pgoblin_sqlite2_quote, pgoblin_sqlite2_quote);
__weak_reference(_pgoblin_sqlite2_instr, pgoblin_sqlite2_instr);
