/*-
 * Copyright (C)2017..2025 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2017..2025 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: trace.c,v 1.32 2025/01/25 00:12:13 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define RECOBE_COMPAT    6
#define PGOBLIN_COMPAT   5
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sysexits.h>
#include <strings.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <babolo/recobe.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

/******************************************************************************************************
* 
* c 0xFF = -1 ,    1       , :
*   0x00 = 0
*   0x05 = 5
*   0x80 80 = 128
*   0x82 01 = 513
* t 2 ,  -    c,  -     . -1 - NULL
*******************************************************************************************************
* R 
*  1B   0x01..0x80 -- ftmqocjs ( 1  )  0x1F  ... ()
*      0, ...
*  1B  ,   1  0,    ,  
*  3B PID
*  2B   
*    line
*       
*  1B 0  ,       (NULL)
*******************************************************************************************************
* C 
*  2B 0xEXXX,  XXX -   (0x000 .. 0x1FF)
*  3B PID
*  4B   (binreg)
*  2B stat 
*  2B dyn 
*  4B  
*      IO    symreg      ch[binreg]
*       ftq (Pm  Po ) 
*      Pf  Pt    t
*      Pq
*       c  
*       c     
*           -1,   
*    t     ,     ,
*     .
*******************************************************************************************************
* E 
*  2B 0xCXXX,  XXX -   (0x000 .. 0x1FF)
*  3B PID
*  4B   (binreg)
*  2B stat 
*  2B dyn 
*  4B  
*******************************************************************************************************
* M 
*  1B 0xA0
*  1B     ,    
*  t      
*  t    
*  t    
*******************************************************************************************************
* N 
*  2B 0x60 00
*  3B PID
*  2B   
*  t   
******************************************************************************************************/

pgoblin_main            *pgoblin_options;
static const size_t      msz[] = {1024, 512, 512};
static mular_descriptor *filenm = NULL;

static ssize_t
/************************************************************************
 **                                                                    **/
pgoblin_xwrt(pgoblin_main *options, const void *buf, size_t len) {    /**
 **                                                                    **
 ************************************************************************/
    ssize_t wrt;

    errno = 0;
    if  ((ssize_t)len == (wrt = mife_writ(options->xtrace, buf, len))) {
        wrt = 0;
    }
    return(wrt);
}

void
/************************************************************************************************
 ************************************************************************************************
 ****                                                                             ****
 ************************************************************************************************
 ****                                                                                        ****/
pgoblin_toexe(pgoblin_command cmd, pgoblin_exenv *exenv, pgoblin_nr rn[pgoblin.symparam]) { /****
 ****                                                                                        ****
 ************************************************************************************************
 ************************************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    if  (!!exenv->options->ftrace) {
        u_char         buf   [PGOBLIN_GOEXECU];
        pgoblin_nr     binreg;
        pgoblin_nr     symreg;
        pgoblin_exenv *c     ;
        int16_t        d     ;
        int16_t        s     ;
        int            y     ;

        for (s = 0, c = exenv; c; c = c->stat) s++;
        for (d = 0, c = exenv; c; c = c->dyna) d++;
        bzero(buf, PGOBLIN_GOEXECU);
        buf[0] = (u_char)((cmd >> 8) | 0x0C0);
        buf[1] = (u_char)(cmd & 0x0FF);
        recobe_store(&buf[PGOBLIN_HEDLN], PGOBLIN_PIDLN, (u_int64_t)getpid());
        for (symreg = 0; symreg < pgoblin.symparam; symreg++) {
            y = pgoblin_breg(cmd, symreg);
            if  (0 <= y) {
                binreg = (pgoblin_nr)y;
                buf[PGOBLIN_GOSHORT + binreg] = rn[symreg];
        }   }
        recobe_store(&buf[PGOBLIN_GOCMD], sizeof(int16_t), (u_int64_t)s);
        recobe_store(&buf[sizeof(int16_t) + PGOBLIN_GOCMD], sizeof(int16_t), (u_int64_t)d);
        recobe_store(&buf[sizeof(int16_t) * 2 + PGOBLIN_GOCMD], sizeof(int32_t), exenv->ppoint);
        if  (0 > (exenv->options->xtrace = open( exenv->options->ftrace
                                               , O_WRONLY | O_APPEND | O_EXLOCK
            )     )                            ) {
            ifBLIN_QW0("open(%s, WRONLY|APPEND|EXLOCK)", exenv->options->ftrace);
        } else {
            ssize_t     wrt;
            struct stat sb;

            fstat(exenv->options->xtrace, &sb);
            ifBLIN_QX2("off %"BLIN_O"d(%"BLIN_O"X)", sb.st_size, sb.st_size);
            if  (!!(wrt = pgoblin_xwrt(exenv->options, buf, PGOBLIN_GOEXECU))) {
                ifBLIN_QW0("pgoblin_xwrt %zd <> %zu", wrt, PGOBLIN_GOEXECU);
            }
            close(exenv->options->xtrace);
}   }   }
#   undef blin_internal_flags

static int
/**********************************************************************
 **                                                                  **/
putnum(pgoblin_main *options, u_int64_t num) {                      /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    u_char  buff[10];
    ssize_t wrt = -2;
    int     ex  = EX_OK;
    int     l   ;

    l = recobe_cstore(buff, num);
    if  ((0 > l) || !!(wrt = pgoblin_xwrt(options, buff, (size_t)l))) {
        ifBLIN_QW0("pgoblin_xwrt %zd", wrt);
        ex = EX_IOERR;
    }
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************
 **                                                                         **/
putext(pgoblin_main *options, const char *text, ssize_t length, int bin) { /**
 **                                                                         **
 *****************************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    char    null = (char)0xFF;
    ssize_t strl;
    ssize_t wrt;
    int     ex   = EX_OK;

    if  (!text) {
        if  (!!(wrt = pgoblin_xwrt(options, &null, 1))) {
            ifBLIN_QW0("mife_writ %zd <> 1", wrt);
        }
    } else {
        if (!!bin || !!length) {
           strl = length;
        } else {
           strl = (ssize_t)strlen(text);
        }
        if  (strl > 0x000000007FFFFFFFLL) {
            ifBLIN_QX0("string too big %"BLIN_X, strl);
        } else if (!!(ex = putnum(options, (u_int64_t)strl))) {
            ifBLIN_QW0("putnum");
            goto out;
        } else if (!!(wrt = pgoblin_xwrt(options, text, (size_t)strl))) {
            ifBLIN_QW0("mife_writ %"BLIN_D" <> %"BLIN_D, wrt, strl);
    }   }
out:
    return(ex);
#   undef blin_internal_flags
}

int
/**************************************************************************
 **************************************************************************
 ****                                                                  ****/
pgoblin_wident(pgoblin_main *options, u_int slot, char *entry) {      /****
 ****                                                                  ****
 **************************************************************************
 **************************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    int            ex = EX_OK;
    u_char         buf[PGOBLIN_GOSHORT];
    size_t         len;

    if  (0 <= options->xtrace) {
        buf[0] = 0xA0;
        buf[1] = (u_char)slot;
        recobe_store(&buf[PGOBLIN_HEDLN], PGOBLIN_PIDLN, (u_int64_t)getpid());
        len = strnlen(entry, PGOBLIN_STRING_ID_LEN);
        if  (0 > (options->xtrace = open(options->ftrace, O_WRONLY | O_APPEND | O_EXLOCK))) {
            ifBLIN_QW0("open(%s, WRONLY|APPEND|EXLOCK)", options->ftrace);
        } else {
            ssize_t     wrt;
            struct stat sb;

            fstat(options->xtrace, &sb);
            ifBLIN_QX2("off %"BLIN_O"d(%"BLIN_O"X)", sb.st_size, sb.st_size);
            if  (!!(wrt = pgoblin_xwrt(options, buf, PGOBLIN_GOSHORT))) {
                ifBLIN_QW0("pgoblin_xwrt %zd <> %d", wrt, PGOBLIN_GOSHORT);
            }
            putext(options, entry, (ssize_t)len, 1);
            entry += PGOBLIN_STRING_ID_LEN;
            len = strnlen(entry, PGOBLIN_STRING_ID_LEN);
            if  (len < PGOBLIN_STRING_ID_LEN) {
                putext( options
                      , entry + len + 1
                      , (ssize_t)strnlen(entry + len + 1, PGOBLIN_STRING_ID_LEN - len - 1)
                      , 1
                      );
            } else {
                putext(options, NULL, 0, 0);
            }
            putext(options, entry, (ssize_t)len, 1);
            close(options->xtrace);
        }
        ifBLIN_QX3( "- %d", ex);
    }
    return(ex);
#   undef blin_internal_flags
}

int
/********************************************************************************
 ********************************************************************************
 **                                                                            **/
pgoblin_cmdexe(pgoblin_command cmd, pgoblin_exenv *exenv, pgoblin_nr *rn) {   /**
 **                                                                            **
 ********************************************************************************
 ********************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    u_char         buf[PGOBLIN_GOEXECU];
    pgoblin_nr     binreg;
    pgoblin_nr     symreg;
    char           null  = (char)0xFF;
    ssize_t        wrt   ;
    int            ex    ;
    int            y     ;

    if  (PGOBLIN_max <= cmd) {
        ifBLIN_QX0("cmd = %03X", cmd);
        ex = EX_DATAERR;
        goto out;
    }
    ifBLIN_QX3( "+#%s %c%c%c%c%c%c %08X"
              , pgoblin.a[cmd].str
              , pgoblin_regn[rn[0]]
              , pgoblin_regn[rn[1]]
              , pgoblin_regn[rn[2]]
              , pgoblin_regn[rn[3]]
              , pgoblin_regn[rn[4]]
              , pgoblin_regn[rn[5]]
              , pgoblin.a[cmd].flags
              );
    if  (!!exenv->options->ftrace) {
        {   pgoblin_exenv *c;
            int16_t        d;
            int16_t        s;

        ;   for (s = 0, c = exenv; c; c = c->stat) s++;
        ;   for (d = 0, c = exenv; c; c = c->dyna) d++;
        ;   bzero(PGOBLIN_GOSHORT + buf, pgoblin.binparam);
        ;   buf[0] = (u_char)((cmd >> 8) | 0x0E0);
        ;   buf[1] = (u_char)(cmd & 0x0FF);
        ;   recobe_store(&buf[PGOBLIN_HEDLN], PGOBLIN_PIDLN, (u_int64_t)getpid());
        ;   for (symreg = 0; symreg < pgoblin.symparam; symreg++) {
        ;       y = pgoblin_breg(cmd, symreg);
        ;       if  (0 <= y) {
        ;           binreg = (pgoblin_nr)y;
        ;           buf[PGOBLIN_GOSHORT + binreg] = rn[symreg];
        ;   }   }
        ;   recobe_store(&buf[PGOBLIN_GOCMD], sizeof(int16_t), (u_int64_t)s);
        ;   recobe_store(&buf[sizeof(int16_t) + PGOBLIN_GOCMD], sizeof(int16_t), (u_int64_t)d);
            recobe_store(&buf[sizeof(int16_t) * 2 + PGOBLIN_GOCMD], sizeof(int32_t), exenv->ppoint);
        }
        if  (0 > (exenv->options->xtrace = open( exenv->options->ftrace
                                               , O_WRONLY | O_APPEND | O_EXLOCK
            )     )                            ) {
            ifBLIN_QW0("open(%s, WRONLY|APPEND|EXLOCK)", exenv->options->ftrace);
        } else {
            struct stat sb;

            fstat(exenv->options->xtrace, &sb);
            ifBLIN_QX2("off %"BLIN_O"d(%"BLIN_O"X)", sb.st_size, sb.st_size);
            if  (!!(wrt = pgoblin_xwrt(exenv->options, buf, PGOBLIN_GOEXECU))) {
        ;       ifBLIN_QW0("mife_writ %zd <> %zu", wrt, PGOBLIN_GOEXECU);
        ;   }
        ;   for (symreg = PGO_COUT; symreg <= PGO_CIN; symreg++) {
        ;       y = pgoblin_breg(cmd, symreg);
        ;       if  (0 <= y) {
                    pgoblin_nr   nio;
                    pgoblin_rio *rio;
        ;
        ;           binreg = (pgoblin_nr)y;
                    nio = buf[PGOBLIN_GOSHORT + binreg] & 0x03F;
        ;           rio = pgoblin_meio(exenv->options, nio);
        ;           ifBLIN_QX4( "%d io%"BLIN_X" ch%02X"
                              , symreg
                              , BLIN_I(rio)
                              , pgoblin.a[cmd].ch[binreg]
                              );
#ifndef NOTRACE_PATHPARM
        ;           if  (PGOBLIN_PATHPARM & pgoblin.a[cmd].ch[binreg]) {
        ;               ifBLIN_QX4("[%d]PATHPARM", binreg);
        ;               putext(exenv->options, !rio ? NULL : rio->path, 0, 0);
        ;           }
#endif
#ifndef NOTRACE_TEXTPARM
        ;           if  (PGOBLIN_TEXTPARM & pgoblin.a[cmd].ch[binreg]) {
        ;               ifBLIN_QX4("[%d]TEXTPARM", binreg);
        ;               putext( exenv->options
                              , !rio ? NULL : rio->text
                              , !rio ? 0 : (ssize_t)rio->length
                              , !rio ? 0 : rio->binparm
                              );
        ;           }
#endif
#ifndef NOTRACE_MIFEDES
        ;           if  (PGOBLIN_MIFEDES & pgoblin.a[cmd].ch[binreg]) {
        ;               ifBLIN_QX4("[%d]MIFEDES", binreg);
        ;           }
#endif
#ifndef NO_PQRESULT
        ;           if  (PGOBLIN_PQRESULT & pgoblin.a[cmd].ch[binreg]) {
                        ssize_t row;
                        ssize_t col;
                        ssize_t v  ;

        ;           ;   ifBLIN_QX4("[%d]PQRESULT", binreg);
        ;           ;   if  (!rio || !rio->pq) {
        ;           ;       if  (!!(wrt = pgoblin_xwrt(exenv->options, &null, 1))) {
        ;           ;           ifBLIN_QW0("mife_writ %zd <> 1", wrt);
        ;           ;       }
        ;           ;   } else {
        ;           ;       if  (0 > (v = (ssize_t)pgoblin_db_resinfo(rio, PGOBLIN_Ntuples))) {
        ;           ;           ifBLIN_QW0("resinfo Ntuples");
        ;           ;           ex = EX_SOFTWARE;
        ;           ;           goto out;
        ;           ;       } else if (!!(ex = putnum(exenv->options, (u_int64_t)v))) {
        ;           ;           ifBLIN_QW0("putnum");
        ;           ;           ex = EX_SOFTWARE;
        ;           ;           goto out;
        ;           ;       }
        ;           ;       if  (0 > (v = (ssize_t)pgoblin_db_resinfo(rio, PGOBLIN_Nfields))) {
        ;           ;           ifBLIN_QW0("resinfo Nfields");
        ;           ;           ex = EX_SOFTWARE;
        ;           ;           goto out;
        ;           ;       } else if (!!(ex = putnum(exenv->options, (u_int64_t)v))) {
        ;           ;           ifBLIN_QW0("putnum");
        ;           ;           goto out;
        ;           ;       }
        ;           ;       if  (0 > rio->cortege) {
        ;           ;           if  (!!(wrt = pgoblin_xwrt(exenv->options, &null, 1))) {
        ;           ;               ifBLIN_QW0("pgoblin_xwrt %zd <> 1", wrt);
        ;           ;               ex = EX_IOERR;
        ;           ;               goto out;
        ;           ;           }
        ;           ;       } else if (!!(ex = putnum(exenv->options, (u_int64_t)rio->cortege))) {
        ;           ;           ifBLIN_QW0("putnum");
        ;           ;           goto out;
        ;           ;       }
        ;           ;       for ( row = 0
                                ; row < pgoblin_db_resinfo(rio, PGOBLIN_Ntuples)
                                ; ++row
                                ) {
        ;           ;           for (col = 0; col < v; ++col) {
        ;           ;               if  (!!pgoblin_db_valinfo(rio, PGOBLIN_IsNull, row, col)) {
        ;           ;                   putext(exenv->options, NULL, 0, 0);
        ;           ;               } else {
        ;           ;                   putext( exenv->options
                                              , pgoblin_db_getvalue(rio, row, col)
                                              , pgoblin_db_valinfo(rio, PGOBLIN_Length, row, col)
                                              , 0
                                              );
        ;   }   }   }   }   }   }   }
#endif
#ifndef NOTRACE_CONNECT
        ;   symreg = PGO_CCON;
        ;   y = pgoblin_breg(cmd, symreg);
        ;   if  (0 <= y) {
        ;       binreg = (pgoblin_nr)y;
        ;       if  (PGOBLIN_CONNECT & pgoblin.a[cmd].ch[binreg]) {
        ;       ;   ifBLIN_QX4("[%d]CONNECT", binreg);
        ;   }   }
#endif
#ifndef NOTRACE_JOB
        ;   symreg = PGO_CJOB;
        ;   y = pgoblin_breg(cmd, symreg);
        ;   if  (0 <= y) {
        ;       binreg = (pgoblin_nr)y;
        ;       if  (PGOBLIN_JOB & pgoblin.a[cmd].ch[binreg]) {
        ;       ;   ifBLIN_QX4("[%d]JOB", binreg);
        ;   }   }
#endif
#ifndef NOTRACE_STYLE
        ;   symreg = PGO_CSTY;
        ;   y = pgoblin_breg(cmd, symreg);
        ;   if  (0 <= y) {
        ;       binreg = (pgoblin_nr)y;
        ;       if  (PGOBLIN_STYLE & pgoblin.a[cmd].ch[binreg]) {
        ;       ;   ifBLIN_QX4("[%d]STYLE", binreg);
        ;   }   }
#endif
        }
        close(exenv->options->xtrace);
        exenv->options->xtrace = -1;
    }
    ex = (*(pgoblin.a[cmd].car))(exenv, rn);
out:
    ifBLIN_QX3( "- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static ssize_t
/************************************************************************
 **                                                                    **/
putfilenm(pgoblin_main *options, const char *nm) {                    /**
 **                                                                    **
 ************************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    u_char       buf[PGOBLIN_GOSHORT + sizeof(int16_t)];
    ssize_t      nmnum = -1;
    int          cmp   = -1;
    const char **c;

    if  (!filenm) filenm = mular_create(MULAR_ZERO | MULAR_CHAR, 3, sizeof(char*), msz);
    if  (!filenm) {
        ifBLIN_QW0("mular_create");
        nmnum = -EX_OSERR;
        goto out;
    }
    for (size_t i = 0; i < MULAR_NEXT(filenm); ++i) {
        if  (!(cmp = strcmp(nm, *(const char **)mular_getix(filenm, i)))) {
            nmnum = (ssize_t)i;
            break;
    }   }
    if  (!!cmp) {
        nmnum = (ssize_t)MULAR_NEXT(filenm);
        if  (!(c = mular_add(filenm))) {
            ifBLIN_QW0("mular_add");
            nmnum = -EX_OSERR;
            goto out;
        }
        *c = nm;
        buf[0] = 0x60;
        buf[1] = 0;
        recobe_store(&buf[PGOBLIN_HEDLN], PGOBLIN_PIDLN, (u_int64_t)getpid());
        recobe_store(&buf[PGOBLIN_GOSHORT], sizeof(int16_t), (u_int64_t)nmnum);
        if  (0 > (options->xtrace = open(options->ftrace, O_WRONLY | O_APPEND | O_EXLOCK))) {
            ifBLIN_QW0("open(%s, WRONLY|APPEND|EXLOCK)", options->ftrace);
        } else {
            ssize_t     wrt;
            struct stat sb;

            fstat(options->xtrace, &sb);
            ifBLIN_QX2("off %"BLIN_O"d(%"BLIN_O"X)", sb.st_size, sb.st_size);
            if  (!!(wrt = pgoblin_xwrt(options, buf, PGOBLIN_GOSHORT + sizeof(int16_t)))) {
                ifBLIN_QW0("pgoblin_xwrt %zd <> %zu", wrt, PGOBLIN_GOSHORT + sizeof(int16_t));
            }
            putext(options, nm, 0, 0);
            close(options->xtrace);
    }   }
out:
    ifBLIN_QX5(" [%zd] %s", nmnum, nm);
    return(nmnum);
#   undef blin_internal_flags
}

void
/********************************************************************************
 ********************************************************************************
 **                                                                            **/
pgoblin_go( pgoblin_rall *rall  /*                                      **/
/**/      , int           f     /*    pgoblin_syntax.ch[]  *-1 **/
/**/      , const char   *file  /*                            **/
/**/      , const char   *func  /*                                   **/
/**/      , int           line  /*                        **/
/**/      ) {                                                                 /**
 **                                                                            **
 ********************************************************************************
 ********************************************************************************/
#   define blin_internal_flags (pgoblin_options->flags & BLIN_MASK)
    if  (!!pgoblin_options && !!pgoblin_options->ftrace) {
        int        nfile;
        u_char     buf  [PGOBLIN_GOSHORT + sizeof(u_int16_t)];
        ssize_t    i    ;
        pgoblin_nr r    = rall->nall;

        nfile = (int)putfilenm(pgoblin_options, file);
        switch(f) {
        case PGOBLIN_STYLE                    :
        case PGOBLIN_JOB                      :
        case PGOBLIN_CONNECT                  :
        case PGOBLIN_OUTSET                   :
        case PGOBLIN_PQRESULT                 :
        case PGOBLIN_MIFEDES                  :
        case PGOBLIN_TEXTPARM                 :
        case PGOBLIN_PATHPARM                 :
        case (PGOBLIN_ANYIVL | PGOBLIN_OUTSET):
            buf[0] = (u_char)f;
            buf[1] = r;
            break;
        default              :
            buf[0] = 0;
            buf[1] = (u_char)f;
        }
        recobe_store(&buf[PGOBLIN_HEDLN], PGOBLIN_PIDLN, (u_int64_t)getpid());
        recobe_store(&buf[PGOBLIN_GOSHORT], sizeof(u_int16_t), (u_int64_t)nfile);
        if  (0 > (pgoblin_options->xtrace = open( pgoblin_options->ftrace
                                                , O_WRONLY | O_APPEND | O_EXLOCK
            )     )                             ) {
            ifBLIN_QW0("open(%s, WRONLY|APPEND|EXLOCK)", pgoblin_options->ftrace);
        } else {
            struct stat sb;

            fstat(pgoblin_options->xtrace, &sb);
            ifBLIN_QX2("off %"BLIN_O"d(%"BLIN_O"X)", sb.st_size, sb.st_size);
            if  (!!(i = pgoblin_xwrt(pgoblin_options, buf, PGOBLIN_GOSHORT + sizeof(u_int16_t)))) {
                ifBLIN_QW0("mife_writ %zd <> %zu", i, PGOBLIN_GOSHORT + sizeof(u_int16_t));
            }
            putnum(pgoblin_options, (u_int64_t)line);
            for (pgoblin_rall *reg = rall; ; reg = reg->prev) {
                putnum(pgoblin_options, (u_int64_t)reg);
                if  (!reg) break;
                if  (reg->nall != r) {
                    ifBLIN_QX0( "Stack err ini %02X(%c) <> %02X(%c)"
                              , r
                              , pgoblin_regn[r]
                              , reg->nall
                              , pgoblin_regn[reg->nall]
                              );
            }   }
            close(pgoblin_options->xtrace);
    }   }
#   undef blin_internal_flags
}

void
/********************************************************************************
 ********************************************************************************
 **                                                                            **/
pgoblin_og( pgoblin_nr    r     /*                                **/
/**/      , int           f     /*    pgoblin_syntax.ch[]  *-1 **/
/**/      , const char   *file  /*                            **/
/**/      , const char   *func  /*                                   **/
/**/      , int           line  /*                        **/
/**/      ) {                                                                 /**
 **                                                                            **
 ********************************************************************************
 ********************************************************************************/
#   define blin_internal_flags (pgoblin_options->flags & BLIN_MASK)
    if  (!!pgoblin_options && !!pgoblin_options->ftrace) {
        u_char        buf[PGOBLIN_GOSHORT + sizeof(u_int16_t)];
        int           nfile;
        ssize_t       i;

        nfile = (int)putfilenm(pgoblin_options, file);
        switch(f) {
        case PGOBLIN_STYLE                    :
        case PGOBLIN_JOB                      :
        case PGOBLIN_CONNECT                  :
        case PGOBLIN_OUTSET                   :
        case PGOBLIN_PQRESULT                 :
        case PGOBLIN_MIFEDES                  :
        case PGOBLIN_TEXTPARM                 :
        case PGOBLIN_PATHPARM                 :
        case (PGOBLIN_ANYIVL | PGOBLIN_OUTSET):
            buf[0] = (u_char)f;
            buf[1] = r;
            break;
        default              :
            buf[0] = 0;
            buf[1] = (u_char)f;
        }
        recobe_store(&buf[PGOBLIN_HEDLN], PGOBLIN_PIDLN, (u_int64_t)getpid());
        recobe_store(&buf[PGOBLIN_GOSHORT], sizeof(u_int16_t), (u_int64_t)nfile);
        if  (0 > (pgoblin_options->xtrace = open( pgoblin_options->ftrace
                                                , O_WRONLY | O_APPEND | O_EXLOCK
            )     )                             ) {
            ifBLIN_QW0("open(%s, WRONLY|APPEND|EXLOCK)", pgoblin_options->ftrace);
        } else {
            struct stat sb;

            fstat(pgoblin_options->xtrace, &sb);
            ifBLIN_QX2("off %"BLIN_O"d(%"BLIN_O"X)", sb.st_size, sb.st_size);
            if  (!!(i = pgoblin_xwrt(pgoblin_options, buf, PGOBLIN_GOSHORT + sizeof(u_int16_t)))) {
                ifBLIN_QW0("mife_writ %zd <> %zd", i, PGOBLIN_GOSHORT + sizeof(u_int16_t));
            }
            putnum(pgoblin_options, (u_int64_t)line);
            putnum(pgoblin_options, 0);
            close(pgoblin_options->xtrace);
    }   }
#   undef blin_internal_flags
}

static const u_char *
/************************************************************************
 **                                                                    **/
winpoint(mife_descriptor *md, off_t offset, ssize_t trd) {            /**
 **                                                                    **
 ************************************************************************/
    const u_char    *p = NULL;
    ssize_t          rdr;

    errno = 0;
    if  (trd > (rdr = mife_read(md, trd, offset))) {
        if  (!!mife_ctlsize(md)) {
            ifBLIN_QW0("mife_read %"BLIN_D" < %"BLIN_D, rdr, trd);
            if  (rdr >= 0) errno = EFTYPE;
        }
    } else if (!(p = mife_pointer(md))) {
        ifBLIN_QW0("mife_pointer");
    }
    return(p);
}

static u_char    P   [] = "Xftmqocjs";
static u_int16_t nums[65536];

static int
/**************************************************************************************
 **                                                                                  **/
qdasprint(pgoblin_main *options, u_int32_t f, u_int32_t n, int lvstat, int lvdyn) { /**
 **                                                                                  **
 **************************************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    u_int32_t       l1 = options->flags & f;
    u_int32_t       l2 = nums[(n >> 4) & 0x0FFFF] & (1 << (n & 0x0F));
    pgoblin_lvldia *lvl;

    ifBLIN_QX2("+ %08X %u (%ds %dd)", f, n, lvstat, lvdyn);
    if  (options->flags & PGOBLIN_T_ONLY) l1 = !!l1 && !!l2;
    if  (!l1 || !options->lvldumps || (!lvstat && !lvdyn)) goto out;
    for (u_int i = 0; i < MULAR_NEXT(options->lvldumps); i++) {
        lvl = mular_getix(options->lvldumps, i);
        if  (!lvl) {
            ifBLIN_QX0("At %u NULL lvl, max %zu", i, MULAR_NEXT(options->lvldumps));
            goto out;
        }
        if  (  (  !lvstat
               || (  (!lvl->statmin || (lvstat >= lvl->statmin))
                  && (!lvl->statmax || (lvstat <= lvl->statmin))
               )  )
            && (  !lvdyn
               || (  (!lvl->dynmin || (lvdyn >= lvl->dynmin))
                  && (!lvl->dynmax || (lvdyn <= lvl->dynmax))
            )  )  ) {
            goto out;
    }   }
    l1 = 0;
out:
    ifBLIN_QX2("- %u", l1);
    return(!!l1);
#   undef blin_internal_flags
}

static ssize_t
/*****************************************************************************
 **                                                                         **/
cload(pgoblin_main *options, mife_descriptor *md, off_t *offset) {         /**
 **                                                                         **
 *****************************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    ssize_t          rdr;
    ssize_t          trd;
    const u_char    *p;

    if  (!(p = winpoint(md, *offset, 1))) {
        ifBLIN_QW0("trace");
        trd = (errno == EFTYPE) ? -EX_DATAERR : -EX_IOERR;
        goto out;
    }
    if  (*p == 0x0FF) {
        ++*offset;
        trd = -1;
        goto out;
    }
    rdr = recobe_clen(*p);
    if  (!(p = winpoint(md, *offset, rdr))) {
        ifBLIN_QW0("trace");
        trd = (errno == EFTYPE) ? -EX_DATAERR : -EX_IOERR;
        goto out;
    }
    trd = (ssize_t)recobe_cload(p, &rdr);
    if  (recobe_clen(*p) != rdr) {
        ifBLIN_QX0("recobe_cload <> recobe_clen");
    }
    *offset += rdr;
out:;
    return(trd);
#   undef blin_internal_flags
}

static char *
/***********************************************************************************************
 **                                                                                           **/
txtdup(pgoblin_main *options, mife_descriptor *md, off_t *offset)                         {  /**
 **                                                                                           **
 ***********************************************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    char          *ret = NULL;
    ssize_t        trd;
    const u_char  *p = NULL;

    if  (-1 > (trd = cload(options, md, offset))) {
        ifBLIN_QW0("trace @ 0x%"BLIN_O"X", *offset);
    } else {
        if  (!(p = winpoint(md, *offset, trd))) {
            ifBLIN_QW0("trace @ 0x%"BLIN_O"X", *offset);
            goto out;
        }
        ret = strndup((const char *)p, (size_t)trd);
        *offset += trd;
    }
out:;
    return(ret);
#   undef blin_internal_flags
}

static int
/***********************************************************************************************
 **                                                                                           **/
txtprt(pgoblin_main *options, int dasprint, mife_descriptor *md, off_t *offset, char end) {  /**
 **                                                                                           **
 ***********************************************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    int              ex = EX_OK;
    ssize_t          trd;
    const u_char    *p;

    if  (-1 > (trd = cload(options, md, offset))) {
        ifBLIN_QW0("trace @ 0x%"BLIN_O"X", *offset);
        ex = (int)-trd;
    } else if (0 > trd) {
        if  (dasprint && ('|' == end)) printf("|");
    } else {
        if  (!(p = winpoint(md, *offset, trd))) {
            ifBLIN_QW0("trace @ 0x%"BLIN_O"X", *offset);
            ex = (errno == EFTYPE) ? EX_DATAERR : EX_IOERR;
            goto out;
        }
        if  (dasprint) {
            if  (' ' == end) {
                printf(" %.*s", (int)trd, p);
            } else {
                printf("=%.*s%c", (int)trd, p, end);
        }   }
        *offset += trd;
    }
out:;
    return(ex);
#   undef blin_internal_flags
}

int
/**************************************************************************************
 **************************************************************************************
 **                                                                                  **/
pgoblin_traceat(pgoblin_main *options, const char *tracefile, const char *Tflag) {  /**
 **                                                                                  **
 **************************************************************************************
 **************************************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    int              seqnum;
    off_t            offset;
    pgoblin_nr       binreg;
    pgoblin_nr       symreg;
    pid_t            tpid  ;
    u_int16_t        cmd   ;
    int              ex    = EX_OK;
    mife_descriptor *md    ;
    u_char           t     [pgoblin.binparam];
    u_char           s     [pgoblin.symparam];
    const u_char    *p     ;
    u_int32_t        n     ;
    int              y     ;

    if  (!(md = mife_init(PGOBLIN_MIFEFLAGS))) {
        ifBLIN_QW0("mife_init");
        ex = EX_NOINPUT;
        goto out;
    }
    if  (0 > mife_ctlfile(md, tracefile)) {
        ifBLIN_QW0("mife_ctlfile=%s~", tracefile);
        ex = EX_NOINPUT;
        goto out;
    }
    if  (!Tflag) {
        ifBLIN_QX0("no trace task");
        ERROUT(EX_USAGE, EINVAL);
    }
    if  (!!filenm) {
        ifBLIN_QX0("filenm not NULL");
        ERROUT(EX_SOFTWARE, EDOOFUS);
    }
    if  (!(filenm = mular_create(MULAR_ZERO | MULAR_CHAR, 3, sizeof(char*), msz))) {
        ifBLIN_QW0("mular_create");
        ex = EX_OSERR;
        goto out;
    }
    bzero(nums, sizeof(nums));
    n = 0;
    for (char c = 0; ' ' < *(Tflag++);) {
        u_int32_t i;

        ifBLIN_QX4("%c @ %"BLIN_X, *Tflag, BLIN_I(Tflag));
        switch(*Tflag) {
        case '\0':
        case ',':                                      break;
        case 'C': options->flags |= PGOBLIN_T_COMAND;  break;
        case 'E': options->flags |= PGOBLIN_T_EXECUTE; break;
        case 'M': options->flags |= PGOBLIN_T_MODULES; break;
        case 'N': options->flags |= PGOBLIN_T_NAMES;   break;
        case 'R': options->flags |= PGOBLIN_T_REGO;    break;
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
            options->flags |= PGOBLIN_T_ONLY;
            i = n;
            n = (u_int32_t)babolo_strtoul(Tflag, &Tflag, 0);
            ifBLIN_QX4("N%u-%u %c", i, n, c);
            if  ('-' != c) i = n;
            c = *Tflag;
            ifBLIN_QX4("N%u-%u %c", i, n, c);
            for (; i <= n; ++i) nums[(i >> 4) & 0x0000FFFF] |= (1 << (i & 0x0000000F));
            ifBLIN_QX4("N%u %c", n, c);
            break;
        default :
            ifBLIN_QX0("Ill sym=%c(%02X)", *Tflag, *Tflag & 0x00FF);
            ex = EX_USAGE;
            goto out;
    }   }
    offset = 0;
    for (seqnum = 0; ; ++seqnum) {
        fflush(stdout);
        if  (!(p = winpoint(md, offset, PGOBLIN_GOSHORT))) {
            if  (!mife_ctlsize(md)) break;
            ifBLIN_QW0("trace file");
            ex = (errno == EFTYPE) ? EX_DATAERR : EX_IOERR;
            goto out;
        }
        ifBLIN_QX3("offset %012"BLIN_O"X = %02X %02X", offset, p[0], p[1]);
        switch(*p) {
        case PGOBLIN_STYLE                    : t[0] = P[8]; break;
        case PGOBLIN_JOB                      : t[0] = P[7]; break;
        case PGOBLIN_CONNECT                  : t[0] = P[6]; break;
        case PGOBLIN_OUTSET                   : t[0] = P[5]; break;
        case PGOBLIN_PQRESULT                 : t[0] = P[4]; break;
        case PGOBLIN_MIFEDES                  : t[0] = P[3]; break;
        case PGOBLIN_TEXTPARM                 : t[0] = P[2]; break;
        case PGOBLIN_PATHPARM                 : t[0] = P[1]; break;
        case 0                                : t[0] = P[0]; break;
        case (PGOBLIN_ANYIVL | PGOBLIN_OUTSET): t[0] = 'I' ; break;
        default                               : t[0] = 0   ;
        }
        tpid = (pid_t)recobe_load(PGOBLIN_HEDLN + p, PGOBLIN_PIDLN);
        if  (!!t[0]) {                                                               /* R --  */
            int         dasprint = qdasprint(options, PGOBLIN_T_REGO, (u_int32_t)seqnum, 0, 0);
            u_int64_t   areg;
            u_int16_t   line;
            u_int16_t   idx;
            char      **c;

            if  (!(p = winpoint(md, offset, PGOBLIN_GOSHORT + sizeof(u_int16_t)))) {
                ifBLIN_QW0("trace file @ 0x%012"BLIN_O"X", offset);
                ex = (errno == EFTYPE) ? EX_DATAERR : EX_IOERR;
                goto out;
            }
            if  (!!dasprint) {
                if  ('I' == t[0]) {
                    printf("R%6d.%u IO %c", seqnum, tpid, pgoblin_regn[p[1] & 0x03F]);
                } else {
                    printf("R%6d.%u P%c %c", seqnum, tpid, t[0], pgoblin_regn[p[1] & 0x03F]);
            }   }
            idx = (u_int16_t)recobe_load(PGOBLIN_GOSHORT + p, sizeof(u_int16_t));
            offset += PGOBLIN_GOSHORT + sizeof(u_int16_t);
            line = (u_int16_t)cload(options, md, &offset);
            if  (!(c = mular_getix(filenm, idx))) {
                ifBLIN_QW0("trace file @ 0x%012"BLIN_O"X idx=%u", offset, idx);
            } else if (!!dasprint) {
                printf(" %s:%u", *c, line);
            }
            for ( areg = (u_int64_t)cload(options, md, &offset)
                ; !!areg
                ; areg = (u_int64_t)cload(options, md, &offset)
                ) {
                if  (!!dasprint) printf(" %"BLIN_X, BLIN_I(areg));
            }
            if  (!!dasprint) printf("\n");
            continue;
        }
        switch(*p & 0x0E0) {
        case 0xE0: {                                                                 /* C --  */
                int dasprint;
                int lvstat;
                int lvdyn;

        ;       lvstat = (int)recobe_load(PGOBLIN_GOCMD + p, sizeof(int16_t));
        ;       lvdyn = (int)recobe_load(sizeof(int16_t) + PGOBLIN_GOCMD + p, sizeof(int16_t));
        ;       dasprint = qdasprint(options, PGOBLIN_T_COMAND, (u_int32_t)seqnum, lvstat, lvdyn);
        ;       if  (!(p = winpoint(md, offset, PGOBLIN_GOEXECU))) {
        ;           ifBLIN_QW0("trace file");
        ;           ex = (errno == EFTYPE) ? EX_DATAERR : EX_IOERR;
        ;           goto out;
        ;       }
        ;       cmd = (*(p) << 8) & 0x0100;
        ;       cmd |= *(p + 1);
        ;       if  (PGOBLIN_max <= cmd) {
        ;           ifBLIN_QX0("cmd = %03X", cmd);
        ;           ex = EX_DATAERR;
        ;           goto out;
        ;       }
        ;       bzero(t, pgoblin.binparam);
        ;       bzero(s, pgoblin.symparam);
        ;       for (symreg = 0; symreg < pgoblin.symparam; symreg++) {
        ;           y = pgoblin_breg(cmd, symreg);
        ;           if  (0 <= y) {
        ;               binreg = (pgoblin_nr)y;
        ;               s[symreg] = t[binreg] = p[PGOBLIN_GOSHORT + binreg] & 0x03F;
        ;       }   }
        ;       if  (dasprint) {
        ;           printf( "C%6d.%u (%ds %dd) N%d #%s %c%c%c%c%c%c\n"
                          , seqnum
                          , tpid
                          , lvstat
                          , lvdyn
                          , (int)recobe_load(sizeof(int16_t) * 2 + PGOBLIN_GOCMD + p, sizeof(int32_t))
                          , pgoblin.a[cmd].str
                          , pgoblin_regn[s[0]]
                          , pgoblin_regn[s[1]]
                          , pgoblin_regn[s[2]]
                          , pgoblin_regn[s[3]]
                          , pgoblin_regn[s[4]]
                          , pgoblin_regn[s[5]]
                          );
        ;       }
        ;       offset += PGOBLIN_GOEXECU;
        ;       for (symreg = 0; symreg < pgoblin.symparam; symreg++) {
        ;           y = pgoblin_breg(cmd, symreg);
        ;           if  (0 <= y) {
                        u_char ch;

        ;               binreg = (pgoblin_nr)y;
        ;               ch = pgoblin.a[cmd].ch[binreg];
#ifndef NOTRACE_PATHPARM
        ;               if  (PGOBLIN_PATHPARM & ch) {
        ;                   ifBLIN_QX4("[%d]PATHPARM", binreg);
        ;                   if  (dasprint) {
        ;                       printf( "        %d %d [%c]%sPf"
                                      , binreg
                                      , symreg
                                      , pgoblin_regn[t[binreg] & 0x03F]
                                      , (ch & PGOBLIN_OUTSET) ? "Po|" : "   "
                                      );
        ;                   }
        ;                   if  (!!(ex = txtprt(options, dasprint, md, &offset, '~'))) {
        ;                       ifBLIN_QW0("trace Pf");
        ;                       goto out;
        ;                   }
        ;                   if  (dasprint) printf("\n");
        ;               }
#endif
#ifndef NOTRACE_TEXTPARM
        ;               if  (PGOBLIN_TEXTPARM & ch) {
        ;                   ifBLIN_QX4("[%d]TEXTPARM", binreg);
        ;                   if  (dasprint) {
        ;                       printf( "        %d %d [%c]%sPt"
                                      , binreg
                                      , symreg
                                      , pgoblin_regn[t[binreg] & 0x03F]
                                      , (ch & PGOBLIN_OUTSET) ? "Po|" : "   "
                                      );
        ;                   }
        ;                   if  (!!(ex = txtprt(options, dasprint, md, &offset, '~'))) {
        ;                       ifBLIN_QW0("trace Pt");
        ;                       goto out;
        ;                   }
        ;                   if  (dasprint) printf("\n");
        ;               }
#endif
#ifndef NOTRACE_MIFEDES
        ;               if  (PGOBLIN_MIFEDES  & ch) {
        ;                   ifBLIN_QX4("[%d]MIFEDES", binreg);
        ;               }
#endif
#ifndef NOTRACE_PQRESULT
        ;               if  (PGOBLIN_PQRESULT & ch) {
        ;                   ifBLIN_QX4("[%d]PQRESULT", binreg);
        ;                   if  (dasprint) {
        ;                       printf( "        %d %d [%c]%sPq"
                                      , binreg
                                      , symreg
                                      , pgoblin_regn[t[binreg] & 0x03F]
                                      , (ch & PGOBLIN_OUTSET) ? "Po|" : "   "
                                      );
        ;                   }
        ;                   if  (!(p = winpoint(md, offset, 1))) {
        ;                        ifBLIN_QW0("trace q");
        ;                        ex = (errno == EFTYPE) ? EX_DATAERR : EX_IOERR;
        ;                        goto out;
        ;                   }
        ;                   if  (*p == 0x0FF) {
        ;                       if  (dasprint) printf("\n");
        ;                       ++offset;
        ;                   } else {
                                ssize_t row;
                                ssize_t col;
                                ssize_t ctg;

        ;                       row = cload(options, md, &offset); /* 0 > ? XXXX*/
        ;                       col = cload(options, md, &offset); /* 0 > ? XXXX*/
        ;                       ctg = cload(options, md, &offset); /* 0 > ? XXXX*/
        ;                       if  (dasprint) {
        ;                           if  (0 > ctg) {
        ;                               printf(" %zd rows x %zd cols\n", row, col);
        ;                           } else {
        ;                               printf(" %zd(%zd rows) x %zd cols\n", ctg, row, col);
        ;                       }   }
        ;                       for ( ssize_t r = (0 > ctg) ? 0 : ctg
                                    ; (0 > ctg) ? (r < row) : (r == ctg)
                                    ; ++r
                                    ) {
        ;                           for (int c = 0; c < col; ++c) {
        ;                               if  (!!(ex = txtprt(options, dasprint, md, &offset, '|'))) {
        ;                                   ifBLIN_QW0("trace Pq");
        ;                                   goto out;
        ;                           }   }
        ;                           if  (dasprint) printf("\n");
        ;               }   }   }
#endif
#ifndef NOTRACE_OUTSET
        ;               if  (PGOBLIN_OUTSET   & ch) {
        ;                   ifBLIN_QX4("[%d]OUTSET", binreg);
        ;               }
#endif
#ifndef NOTRACE_CONNECT
        ;               if  (PGOBLIN_CONNECT  & ch) {
        ;                   ifBLIN_QX4("[%d]CONNECT", binreg);
        ;               }
#endif
#ifndef NOTRACE_JOB
        ;               if  (PGOBLIN_JOB      & ch) {
        ;                   ifBLIN_QX4("[%d]JOB", binreg);
        ;               }
#endif
        ;               if  (PGOBLIN_STYLE    & ch) {
#ifndef NOTRACE_STYLE
        ;                   ifBLIN_QX4("[%d]STYLE", binreg);
#endif
        ;   }   }   }   }
        ;   continue;
        case 0xC0: {                                                              /* E --  */
                int lvstat;
                int lvdyn;

        ;       if  (!(p = winpoint(md, offset, PGOBLIN_GOEXECU))) {
        ;           ifBLIN_QW0("trace file");
        ;           ex = (errno == EFTYPE) ? EX_DATAERR : EX_IOERR;
        ;           goto out;
        ;       }
        ;       cmd = (*(p) << 8) & 0x0100;
        ;       cmd |= *(p + 1);
        ;       bzero(t, pgoblin.binparam);
        ;       bzero(s, pgoblin.symparam);
        ;       for (symreg = 0; symreg < pgoblin.symparam; symreg++) {
        ;           y = pgoblin_breg(cmd, symreg);
        ;           if  (0 <= y) {
        ;               binreg = (pgoblin_nr)y;
        ;               s[symreg] = t[binreg] = p[PGOBLIN_GOSHORT + binreg];
        ;       }   }
        ;       lvstat = (int)recobe_load(p + PGOBLIN_GOCMD, sizeof(int16_t));
        ;       lvdyn = (int)recobe_load(sizeof(int16_t) + p + PGOBLIN_GOCMD, sizeof(int16_t));
        ;       if  (qdasprint(options, PGOBLIN_T_EXECUTE, (u_int32_t)seqnum, lvstat, lvdyn)) {
        ;           printf( "E%6d.%u (%ds %dd) N%d #%s %c%c%c%c%c%c\n"
                          , seqnum
                          , tpid
                          , lvstat
                          , lvdyn
                          , (int)recobe_load(sizeof(int16_t) * 2 + p + PGOBLIN_GOCMD, sizeof(int32_t))
                          , pgoblin.a[cmd].str
                          , pgoblin_regn[s[0] & 0x03F]
                          , pgoblin_regn[s[1] & 0x03F]
                          , pgoblin_regn[s[2] & 0x03F]
                          , pgoblin_regn[s[3] & 0x03F]
                          , pgoblin_regn[s[4] & 0x03F]
                          , pgoblin_regn[s[5] & 0x03F]
                          );
        ;       }
        ;       offset += PGOBLIN_GOEXECU;
        ;   }
        ;   continue;
        case 0xA0: {                                                         /* M --   */
                int dasprint = qdasprint(options, PGOBLIN_T_MODULES, (u_int32_t)seqnum, 0, 0);

        ;       if  (!(p = winpoint(md, offset, PGOBLIN_GOSHORT))) {
        ;           ifBLIN_QW0("trace file");
        ;           ex = (errno == EFTYPE) ? EX_DATAERR : EX_IOERR;
        ;           goto out;
        ;       }
        ;       if  (dasprint) printf("M%6d.%u[%u]", seqnum, tpid, *(p + 1));
        ;       offset += PGOBLIN_GOSHORT;
        ;       for (int i = 0; i < 3; ++i) {
        ;           if  (!!(ex = txtprt(options, dasprint, md, &offset, ' '))) {
        ;               ifBLIN_QW0("trace mod");
        ;               goto out;
        ;       }   }
        ;       if  (dasprint) printf("\n");
        ;   }
        ;   continue;
        case 0x60: break;
        default: {
        ;       ifBLIN_QX0("illegal trace file 0x%02X @ 0x%012"BLIN_O"X", *p, offset);
        ;       ERROUT(EX_DATAERR, EILSEQ);
        }   }
        switch(p[1]) {
        case 0x00: {                                                      /* N --   pgoblin */
                u_int16_t idx;

        ;       if  (!(p = winpoint(md, offset, PGOBLIN_GOSHORT + sizeof(int16_t)))) {
        ;           ifBLIN_QW0("trace file");
        ;           ex = (errno == EFTYPE) ? EX_DATAERR : EX_IOERR;
        ;           goto out;
        ;       }
        ;       idx = (u_int16_t)recobe_load(PGOBLIN_GOSHORT + p, sizeof(int16_t));
        ;       if  (MULAR_NEXT(filenm) < idx) {
        ;           ifBLIN_QX0("Gap in seq: %zu < [%u]", MULAR_NEXT(filenm), idx);
        ;           ERROUT(EX_DATAERR, EILSEQ);
        ;       }
        ;       offset += PGOBLIN_GOSHORT + sizeof(int16_t);
        ;       if  (MULAR_NEXT(filenm) > idx) {
        ;           ifBLIN_QX0( "Overwrite [%u]=%s~: [%zu]"
                              , idx
                              , *(char **)mular_getix(filenm, idx)
                              , MULAR_NEXT(filenm)
                              );
        ;           printf("N%6d.%u [%u]", seqnum, tpid, idx);
        ;           if  (!!(ex = txtprt(options, 1, md, &offset, '~'))) {
        ;               ifBLIN_QW0("trace N");
        ;               goto out;
        ;           }
        ;           printf("\n");
        ;       } else {
        ;           *(char **)mular_add(filenm) = txtdup(options, md, &offset);
        ;           if  (qdasprint(options, PGOBLIN_T_NAMES, (u_int32_t)seqnum, 0, 0)) {
        ;               printf( "N%6d.%u [%u]=%s~\n"
                              , seqnum
                              , tpid
                              , idx
                              , *(char **)mular_getix(filenm, MULAR_NEXT(filenm) - 1)
                              );
        ;   }   }   }
        ;   continue;
        default: {
        ;       ifBLIN_QX0("illegal trace file 0x60X 0x%02X @ 0x%012"BLIN_O"X", p[1], offset);
        ;       ERROUT(EX_DATAERR, EILSEQ);
    }   }   }
out:;
    return(ex);
#   undef blin_internal_flags
}
