/*-
 * Copyright (C)2008..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2008..2024 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: style_0.c,v 1.83 2024/07/14 00:00:02 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define PGOBLIN_COMPAT   5
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

static int
/**********************************************************************
 **                                                                  **/
init(pgoblin_exenv *exenv, u_int slot) {                            /**
 **                                                                  **
 **********************************************************************/
    (void)exenv;
    (void)slot;
    return(EX_OK);
}

static int
/**********************************************************************
 **                                                                  **/
fini(pgoblin_exenv *exenv) {                                        /**
 **                                                                  **
 **********************************************************************/
    (void)exenv;
    return(EX_OK);
}

static int
/**********************************************************************
 **                                                                  **/
parser(pgoblin_rst *rst, char *tin) {                               /**
 **                                                                  **
 **********************************************************************/
    (void)rst;
    (void)tin;
    return(EX_OK);
}

static void
/**********************************************************************
 **                                                                  **/
dump(pgoblin_rst *rst, FILE *ouf) {                                 /**
 **                                                                  **
 **********************************************************************/
    (void)rst;
    (void)ouf;
    return;
}

static int
/**********************************************************************
 **                                                                  **/
clear(pgoblin_rst *rst) {                                           /**
 **                                                                  **
 **********************************************************************/
    (void)rst;
    return(EX_OK);
}

static char *
/**********************************************************************
 **                                                                  **/
get(pgoblin_exenv *exenv, pgoblin_nr *rn) {                         /**
 **                                                                  **
 **********************************************************************/
    (void)exenv;
    (void)rn;
    return(NULL);
}

static int
/********************************************************************************
 **                                                                            **/
sout(pgoblin_exenv *exenv, pgoblin_nr nou, char *c, ssize_t l, size_t lbuf) { /**
 **                                                                            **
 ********************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rio *rou;
    int          ex = -EX_SOFTWARE;

    GET_RIO(rou, exenv->options, nou);
    if  (c) {
        ifBLIN_QX5("%zd<%zu=%.*s~", l, lbuf, (int)l, c);
        if  (0 > l) {
            ifBLIN_QX0("len=%zd", l);
            ERROUT(-EX_DATAERR, EDOM);
        }
        if  (rou->iod) {
            ex = (int)pgoblin_io_write(rou, c, (size_t)l);
            ifBLIN_QX5("%d", ex);
        } else if (rou->length + (size_t)l > lbuf) {
            ifBLIN_QX0("out buf len err");
            ERROUT(-EX_SOFTWARE, EDOOFUS);
        } else {
            ex = 0;
            MARK_IO_TEXT_GO(rou);;
            ;;  bcopy(c, &((char*)(rou->text))[rou->length], (size_t)l);
            ;;  rou->length += (size_t)l;
            ;;  ((char*)(rou->text))[rou->length] = '\0';
            MARK_IO_TEXT_WENT(rou);;
            ifBLIN_QX5("%zd<%zu", l, lbuf);
    }   }
out:
    return(ex);
#   undef blin_internal_flags
}

static ssize_t
/*************************************************************************************
 **                                                                                 **/
table(pgoblin_exenv *exenv, pgoblin_nr *rn, ssize_t low, ssize_t hig) {            /**
 **                                                                                 **
 *************************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    int             isnull;
    ssize_t         minc  ;
    ssize_t         maxc  ;
    size_t          lbuf  = 0;
    pgoblin_rio    *rou   ;
    pgoblin_rio    *rin   ;
    ssize_t         ex    = -EX_SOFTWARE;
    ssize_t         ll    = 0;
    ssize_t         i     = 0;
    ssize_t         m     ;
    ssize_t         w     ;
    ssize_t         j     ;

    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    GET_RIO(rin, exenv->options, rn[PGO_CIN]);
    ex = EX_OK;
    if  (0 > (m = (ssize_t)pgoblin_db_resinfo(rin, PGOBLIN_Ntuples))) {
        ifBLIN_QW0("Ntuples");
        ex = -EX_DATAERR;
        goto out;
    }
    if  (0 > (w = (ssize_t)pgoblin_db_resinfo(rin, PGOBLIN_Nfields))) {
        ifBLIN_QW0("Nfields");
        ex = -EX_DATAERR;
        goto out;
    }
    isnull = ((m == 0) || (w == 0)) ? 1 : 0;
    if  (hig == -3) {
        minc = low;
        maxc = (low < m) ? low + 1 : m;
    } else {
        minc = 0;
        maxc = m;
    }
    ifBLIN_QX3("+ %08X %zd x %zd %zd..%zd", !(rin->pq) ? 0 : *(rin->pq), m, w, minc, maxc);
    if  (!rou->iod) {
        char *s;

        /*      */
        for (i = minc, isnull = 1, lbuf = 0; i < maxc; i++) {
            for (j = 0; j < w; j++) {
                if  (!pgoblin_db_valinfo(rin, PGOBLIN_IsNull, i, j)) {
                    isnull = 0;
                    ex = pgoblin_db_valinfo(rin, PGOBLIN_Length, i, j);
                    ifBLIN_QX5("%zu+%zd", lbuf, ex);
                    if  (ex < 0) {
                        ifBLIN_QW0("table in 0 STYLE");
                        ex = -EX_IOERR;
                        goto out;
                    }
                    lbuf += (size_t)ex;
        }   }   }
        if  (isnull) {
            s = NULL;
        } else if (!(s = malloc(lbuf + 1))) {
            ifBLIN_QX0("table in 0 STYLE: No mem");
            ERROUT(-EX_OSERR, ENOMEM);
        }
        ifBLIN_QX5("%zu+%zu", BLIN_I(s), lbuf);
        /*       */
        MARK_IO_TEXT_GO(rou);;
        ;;  if  (!!rou->text && !!rou->freetext) free(rou->text);
        ;;  rou->text = s;
        ;;  rou->length = 0;
        ;;  if  (s) {
        ;;      rou->binparm = 1;
        ;;      rou->freetext = 1;
        ;;      ((char*)(rou->text))[rou->length] = '\0';
        ;;  } else {
        ;;      rou->parmask &= ~PGOBLIN_TEXTPARM;
        ;;      rou->binparm = 0;
        ;;      rou->freetext = 0;
        ;;  }
        MARK_IO_TEXT_WENT(rou);;
    }
    for (i = minc, ll = 0; i < maxc; i++) {
        for (j = 0; j < w; j++) {
            if  (!pgoblin_db_valinfo(rin, PGOBLIN_IsNull, i, j)) {
                ex = sout( exenv
                         , rn[PGO_COUT]
                         , pgoblin_db_getvalue(rin, i, j)
                         , pgoblin_db_valinfo(rin, PGOBLIN_Length, i, j)
                         , lbuf
                         );
                if  (ex < 0) {
                    ifBLIN_QW0("table in 0 STYLE");
                    ex = -EX_IOERR;
                    goto out;
                }
                ll += ex;
    }   }   }
out:
    ifBLIN_QX3("- %zd %zd", ex, ll);
    return((ex < 0) ? ex : ll);
#   undef blin_internal_flags
}

ssize_t
/*************************************************************************************
 **                                                                                 **/
pgoblin_st0_tbl(pgoblin_exenv *exenv, pgoblin_nr r, ssize_t low, ssize_t hig) {    /**
 **                                                                                 **
 *************************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_nr rrnn[] = {0, 0, 0, 0, 0, 0};
    ssize_t    ex;

    ifBLIN_QX3("+ %c %zd %zd", pgoblin_regn[r], low, hig);
    rrnn[PGO_CIN] = r;
    rrnn[PGO_COUT] = r;
    ex = table(exenv, rrnn, low, hig);
    ifBLIN_QX3("- %zd", ex);
    return(ex);
#   undef blin_internal_flags
}

pgoblin_styles pgoblin_style_0 =
{ 0
, "5pGoblin-" VERS
, "0\0" VERS
, 0
, init
, fini
, parser
, dump
, clear
, get
, table
, NULL /* load   */
, NULL /* store  */
, NULL /* dummy0 */
, NULL /* dummy1 */
};
