/*-
 * Copyright (C)2023..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2023..2024 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: style.c,v 1.7 2024/03/17 18:47:42 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define PGOBLIN_COMPAT   5
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <errno.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

int
/****************************************************************************
 ****************************************************************************
 **                                                                        **/
pgoblin_st_init(pgoblin_exenv *exenv, u_int slot) {                       /**
 **                                                                        **
 ****************************************************************************
 ****************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    int          ex = EX_OK;

    ifBLIN_QX3("+ [%d]", slot);
    if  (!STYLS(slot)->init) {
        errno = ENOSYS;
        ex = EX_UNAVAILABLE;
    } else {
        ex = STYLS(slot)->init(exenv, slot);
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/****************************************************************************
 ****************************************************************************
 **                                                                        **/
pgoblin_st_parser(pgoblin_rst *rst, char *srcstyle) {                     /**
 **                                                                        **
 ****************************************************************************
 ****************************************************************************/
#   define blin_internal_flags (rst->flags & BLIN_MASK)
    int          ex = EX_OK;

    ifBLIN_QX3("+ [%d]", rst->flags & PGOBLIN_STYLE_TYPE);
    if  (!STYLS(rst->flags) || !STYLS(rst->flags)->parser) {
        errno = ENOSYS;
        ex = -EX_UNAVAILABLE;
    } else {
        ex = STYLS(rst->flags)->parser(rst, srcstyle);
    }
    ifBLIN_QX3("- %08X %d", rst->flags, ex);
    return(ex);
#   undef blin_internal_flags
}

void
/****************************************************************************
 ****************************************************************************
 **                                                                        **/
pgoblin_st_dump(pgoblin_rst *rst, FILE *ouf) {                            /**
 **                                                                        **
 ****************************************************************************
 ****************************************************************************/
#   define blin_internal_flags (rst->flags & BLIN_MASK)

    ifBLIN_QX3("+ [%d]", rst->flags & PGOBLIN_STYLE_TYPE);
    if  (!STYLS(rst->flags) || !STYLS(rst->flags)->dump) {
        errno = ENOSYS;
    } else {
        STYLS(rst->flags)->dump(rst, ouf);
    }
    ifBLIN_QX3("- %08X", rst->flags);
    return;
#   undef blin_internal_flags
}

int
/****************************************************************************
 ****************************************************************************
 **                                                                        **/
pgoblin_st_clear(pgoblin_rst *rst) {                                      /**
 **                                                                        **
 ****************************************************************************
 ****************************************************************************/
#   define blin_internal_flags (rst->flags & BLIN_MASK)
    int          ex = EX_OK;

    ifBLIN_QX3("+ [%d]", rst->flags & PGOBLIN_STYLE_TYPE);
    if  (!STYLS(rst->flags) || !STYLS(rst->flags)->clear) {
        errno = ENOSYS;
        ex = -EX_UNAVAILABLE;
    } else {
        ex = STYLS(rst->flags)->clear(rst);
    }
    ifBLIN_QX3("- %08X %d", rst->flags, ex);
    return(ex);
#   undef blin_internal_flags
}

char *
/****************************************************************************
 ****************************************************************************
 **                                                                        **/
pgoblin_st_get(pgoblin_exenv *exenv, pgoblin_nr *rn) {                    /**
 **                                                                        **
 ****************************************************************************
 ****************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    char        *found = NULL;
    pgoblin_rst *rst;

    GET_STY(rst, exenv->options, rn[PGO_CSTY]);
    ifBLIN_QX3("+ [%d]", rst->flags & PGOBLIN_STYLE_TYPE);
    if  (!STYLS(rst->flags) || !STYLS(rst->flags)->get) {
        errno = ENOSYS;
    } else {
        found = STYLS(rst->flags)->get(exenv, rn);
    }
    ifBLIN_QX3("- %08X %s", rst->flags, found);
out:
    return(found);
#   undef blin_internal_flags
}

ssize_t
/*************************************************************************************
 *************************************************************************************
 **                                                                                 **/
pgoblin_st_table(pgoblin_exenv *exenv, pgoblin_nr *rn, ssize_t low, ssize_t hig) { /**
 **                                                                                 **
 *************************************************************************************
 *************************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ssize_t      textlength = 0;
    pgoblin_rst *rst;
    ssize_t      ex         = -EX_SOFTWARE;

    GET_STY(rst, exenv->options, rn[PGO_CSTY]);
    ifBLIN_QX3("+ [%d]", rst->flags & PGOBLIN_STYLE_TYPE);
    if  (!STYLS(rst->flags) || !STYLS(rst->flags)->table) {
        errno = ENOSYS;
        ex = -EX_UNAVAILABLE;
    } else {
        ex = STYLS(rst->flags)->table(exenv, rn, low, hig);
    }
out:
    ifBLIN_QX3("- %08X %"BLIN_D, rst->flags, textlength);
    return((ex < 0) ? ex : textlength);
#   undef blin_internal_flags
}

int
/****************************************************************************
 ****************************************************************************
 **                                                                        **/
pgoblin_st_load(pgoblin_exenv *exenv, pgoblin_nr *rn) {                   /**
 **                                                                        **
 ****************************************************************************
 ****************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rst *rst;
    int          ex = -EX_SOFTWARE;

    GET_STY(rst, exenv->options, rn[PGO_CSTY]);
    ifBLIN_QX3("+ [%d]", rst->flags & PGOBLIN_STYLE_TYPE);
    if  (!STYLS(rst->flags) || !STYLS(rst->flags)->load) {
        errno = ENOSYS;
        ex = -EX_UNAVAILABLE;
    } else {
        ex = STYLS(rst->flags)->load(exenv, rn);
    }
out:
    ifBLIN_QX3("- %08X %d", rst->flags, ex);
    return(ex);
#   undef blin_internal_flags
}

int
/****************************************************************************
 ****************************************************************************
 **                                                                        **/
pgoblin_st_store(pgoblin_exenv *exenv, pgoblin_nr *rn) {                  /**
 **                                                                        **
 ****************************************************************************
 ****************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rst *rst;
    int          ex = -EX_SOFTWARE;

    GET_STY(rst, exenv->options, rn[PGO_CSTY]);
    ifBLIN_QX3("+ [%d]", rst->flags & PGOBLIN_STYLE_TYPE);
    if  (!STYLS(rst->flags) || !STYLS(rst->flags)->store) {
        errno = ENOSYS;
        ex = -EX_UNAVAILABLE;
    } else {
        ex = STYLS(rst->flags)->store(exenv, rn);
    }
out:
    ifBLIN_QX3("- %08X %d", rst->flags, ex);
    return(ex);
#   undef blin_internal_flags
}
