/*-
 * Copyright (C)2002..2025 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2002..2025 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: job_local.c,v 1.76 2025/01/18 23:06:13 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define PGOBLIN_COMPAT   5
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <fts.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

static int
/**********************************************************************
 **                                                                  **/
init(pgoblin_exenv *exenv, u_int slot) {                            /**
 **                                                                  **
 **********************************************************************/
    (void)exenv;
    (void)slot;
    return(EX_OK);
}

static int
/**********************************************************************
 **                                                                  **/
fini(pgoblin_exenv *exenv) {                                        /**
 **                                                                  **
 **********************************************************************/
    (void)exenv;
    return(EX_OK);
}

static int
/**********************************************************************
 **                                                                  **/
none(pgoblin_exenv *exenv, pgoblin_nr *rn) {                        /**
 **                                                                  **
 **********************************************************************/
    (void)exenv;
    (void)rn;
    return(EX_OK);
}
 
static int
/**********************************************************************
 **                                                                  **/
jpen(pgoblin_exenv *exenv, pgoblin_nr *rn, void *opt) {             /**
 **                                                                  **
 **********************************************************************/
    (void)exenv;
    (void)rn;
    (void)opt;
    return(EX_OK);
}

static u_int32_t
/**********************************************************************
 **                                                                  **/
jest(pgoblin_exenv *exenv, pgoblin_command cmd) {                   /**
 **                                                                  **
 **********************************************************************/
    u_int32_t e;

    (void)exenv;
    if  (cmd == PGOBLIN_fork) e = PGOBLIN_TVFORK; else e = PGOBLIN_TOFORK | PGOBLIN_TOEXIT;
    return(e);
}

static int
/**********************************************************************
 **                                                                  **/
jxec(pgoblin_exenv *exenv, pgoblin_nr *rn, char **argv) {           /**
 **                                                                  **
 **********************************************************************/
    pgoblin_rio *rou;
    pgoblin_rio *rio;
    pgoblin_rio *rin;
    int          ex = EX_SOFTWARE;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX4( "+ o[%c] i[%c] j[%c] %08X argv %s"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CJOB]]
              , exenv->flags
              , argv ? "OK" : "NULL"
              );
    ifBLIN_QO5 {
        int z;
        for (z = 0; argv[z]; z++) ifBLIN_QX5("[%d]=%s~", z, argv[z]);
    }
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    GET_RIO(rin, exenv->options, rn[PGO_CIN]);
    ex = EX_OK;
    if  (argv && !ex) {
        mife_descriptor *mife = rin->mife;
        int              g;

    ;   /**************************************************
    ;    * pgoblin_exec  ,    *
    ;    **************************************************/
    ;   if  (  ((0 != rn[PGO_CIN]) || !mife || (0 != (g = mife->f.fd)))
            && (0 > (g = mife_ctlpipe(rin->mife)))
            ) {
    ;       ifBLIN_QW0("mife_ctlpipe");
    ;       ex = -EX_IOERR;
    ;       exit(ex);
    ;   }
    ;   if  (0 > dup2(g, fileno(stdin))) {
    ;       ifBLIN_QW0("dup2 #4");
    ;       ex = -EX_OSERR;
    ;       exit(ex);
    ;   }
    ;   if  (0 > (g = pgoblin_io_fdout(rou))) {
    ;       ifBLIN_QW0("fdout");
    ;       ex = g;
    ;       exit(ex);
    ;   }
    ;   if  (0 > dup2(g, fileno(stdout))) {
    ;       ifBLIN_QW0("dup2 #3");
    ;       ex = -EX_OSERR;
    ;       exit(ex);
    ;   }
    ;   for (u_int8_t m = 0; m < pgoblin.regsize; m++) {
    ;       if  (!!(rio = pgoblin_meio(exenv->options, m))) {
    ;           if  (  rio->mife
                    && (rio->mife->f.fd != fileno(stdin))
                    && (rio->mife->f.fd != fileno(stdout))
                    ) {
    ;               if  (!!rio->freemife && !!(ex = mife_fini(rio->mife))) {
    ;                   ifBLIN_QW0("mife_fini in exec");
    ;           }   }
    ;           if  (  (m != rn[PGO_COUT])
                    && (PGOBLIN_MODSHIFT < rio->type)
                    && !!rio->freeouts
                    && !!(ex = pgoblin_io_closew(rio))
                    ) {
    ;               ifBLIN_QW0("close in exec");
    ;   }   }   }
    ;   execve(argv[0], argv, exenv->options->envp);
    ;   ex = EX_OSERR;
        ifBLIN_QW0("execve %s", argv[0]);
    }
out:
    ifBLIN_QX4("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
jait(pgoblin_exenv *exenv, pgoblin_rjb *rjb) {                      /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    struct kevent *setlist;
    int            setlong;
    struct kevent  getone;
    int            getlng;
    int            stat;
    pid_t          pid;
    int            exx   = EX_OK;
    int            ex    = EX_OK;
    int            kq;
    pgoblin_jobl  *j;
    size_t         i;

    if  (rjb) {
        ifBLIN_QX4("+");
        if  (!(setlist = calloc(MULAR_NEXT(rjb->pids), sizeof(struct kevent)))) {
            ifBLIN_QW0("No mem %u x %u", (u_int)MULAR_NEXT(rjb->pids), (u_int)sizeof(struct kevent));
            ex = EX_OSERR;
            goto out;
        }
        if  (0 > (kq = kqueue())) {
            ifBLIN_QW0("No kqueue");
            ex = EX_OSERR;
            goto out;
        }
        for (setlong = 0, i = 0; i <  MULAR_NEXT(rjb->pids); i++) {
            j = mular_getix(rjb->pids, i);
            if  (!(j->pid)) {
                ifBLIN_QX0("No pid in %d", (int)j->cmdn);
                errno = EINVAL;
                ex = EX_SOFTWARE;
                goto out;
            } else if ((j->cmdn >= 0) && (j->status == PGOBLIN_NOSTATUS)) {
                EV_SET( &setlist[setlong]
                      , j->pid
                      , EVFILT_PROC
                      , EV_ADD | EV_ONESHOT
                      , NOTE_EXIT
                      , 0
                      , (void*)i
                      );
                ++setlong;
        }   }
        if  (0 > (getlng = kevent(kq, setlist, setlong, NULL, 0, NULL))) {
            ifBLIN_QW0("kevent set");
            ex = EX_OSERR;
            goto out;
        }
        for (; setlong > 0; --setlong) {
            if  (0 > (getlng = kevent(kq, NULL, 0, &getone, 1, NULL))) {
                ifBLIN_QW0("kevent get");
                ex = EX_OSERR;
                goto out;
            } else {
                j = mular_getix(rjb->pids, (size_t)getone.udata);
                if  ((pid_t)getone.ident == j->pid) {
                    j->status = (int)getone.data;
                    if  (0 > (pid = waitpid(j->pid, &stat, WNOHANG))) {
                        ifBLIN_QW0("waitpid %d", j->pid);
                        ex = EX_OSERR;
                        goto out;
                    } else if (!pid) {
                        ifBLIN_QX1("waitpid: %d not found", j->pid);
                    }
                    ifBLIN_QX3( " st=%08X fl=%08X ex=%d exx=%d IFEX=%d EXST=%d EXSIG=%d SIGST=%d"
                              , j->status
                              , rjb->flags
                              , ex
                              , exx
                              , WIFEXITED(j->status)
                              , WEXITSTATUS(j->status)
                              , WIFSIGNALED(j->status)
                              , WTERMSIG(j->status)
                              );
                    if  (rjb->flags & PGOBLIN_ERROR_SENSOR) {
                        if  (  WIFEXITED(j->status)
                            && WEXITSTATUS(j->status)
                            ) {
                            exx = WEXITSTATUS(j->status);
                        } else if (WIFSIGNALED(j->status)) {
                            exx = WTERMSIG(j->status) + 256;
                    }   }
                    if  ((rjb->flags & PGOBLIN_ERROR_SENSIB) && exx) break;
                    ex = EX_OK;
                } else {
                    ifBLIN_QW0("Pid %ld<>%d in %d", (long)getone.ident, j->pid, (int)j->cmdn);
                    ex = EX_OSERR;
        }   }   }
        ifBLIN_QX4("- %d", ex);
    }
out:
    return(ex ? ex : exx);
#   undef blin_internal_flags
}

static pgoblin_dir*
/**********************************************************************
 **                                                                  **/
jdir(pgoblin_exenv *exenv, pgoblin_dir *dir, char *path) {          /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_dir *d  = NULL;
    int          ex = EX_OK;
    FTSENT      *ent;

    if  (!dir == !path) {
        ifBLIN_QX0("local: exactly one of dir and path should be");
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (path) {
        char *p[2] = {NULL, NULL};

        if  (!(d = calloc(1, sizeof(pgoblin_dir)))) {
            ifBLIN_QX0("local dir: no mem");
            ERROUT(EX_OSERR, ENOMEM);
        }
        d->i = 0;
        d->f = 1;
        d->g = 1;
        p[0] = path;
        if  (!(d->dirp = fts_open(p, FTS_PHYSICAL | FTS_NOCHDIR | FTS_SEEDOT, NULL))) {
            ifBLIN_QX0("local dir: no fts");
            ERROUT(EX_OSERR, EIO);
        }
    } else {
        d = dir;
        d->i += d->g;
        d->g = 1;
    }
    for (; ;) {
        if  (!(ent = fts_read(d->dirp))) {
            if  (d->dirp) fts_close(d->dirp);
            free(d);
            d = NULL;
            break;
        }
        switch(ent->fts_info) {
        case FTS_SLNONE:
        case FTS_DP:
            continue;
        case FTS_SL:
            fts_set(d->dirp, ent, FTS_FOLLOW);
            d->g = 0;
            break;
        case FTS_DOT:
        case FTS_DC:
        case FTS_D:
            if  (d->f) {
                d->f = 0;
                continue;
            } else fts_set(d->dirp, ent, FTS_SKIP);
            BLIN_FALLTHROUGH;
        case FTS_DEFAULT:
        case FTS_F:
            break;
        case FTS_DNR:
            errno = ent->fts_errno;
            ifBLIN_QW1("fts_read DNR");
            break;
        case FTS_NS:
            errno = ent->fts_errno;
            ifBLIN_QW1("fts_read NS");
            BLIN_FALLTHROUGH;
        case FTS_NSOK:
            ent->fts_statp = NULL;
            break;
        case FTS_ERR:
            errno = ent->fts_errno;
            ifBLIN_QW0("fts_read");
            ex = EX_OSERR;
            goto out;
        default:
            ifBLIN_QW0("unknown fts_read");
            ERROUT(EX_OSERR, EIO);
        }
        d->sb = ent->fts_statp;
        d->ent = ent->fts_name;
        break;
    }
out:
    if  (ex) {
        if  (d) {
            if  (d->dirp) fts_close(d->dirp);
            free(d);
            d = NULL;
    }   }
    return(d);
#   undef blin_internal_flags
}

pgoblin_jobs pgoblin_job_local =
{ 0
, "4pGoblin-" VERS
, "local\0" VERS
, 0
, init
, fini
, jpen
, jest
, none /* jork */
, jxec
, jait
, none /* jose */
, jdir
, NULL
, NULL
};
