/*-
 * Copyright (C)2023..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2023..2024 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: job.c,v 1.2 2024/03/17 18:47:42 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define PGOBLIN_COMPAT   5
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <errno.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

int
/****************************************************************************
 ****************************************************************************
 **                                                                        **/
pgoblin_jb_init(pgoblin_exenv *exenv, u_int slot) {                       /**
 **                                                                        **
 ****************************************************************************
 ****************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    int          ex = EX_OK;

    ifBLIN_QX3("+ [%d]", slot);
    if  (!JOBE(slot)->init) {
        errno = ENOSYS;
        ex = EX_UNAVAILABLE;
    } else {
        ex = JOBE(slot)->init(exenv, slot);
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_jb_jpen(pgoblin_exenv *exenv, pgoblin_nr *rn, void *opt) {  /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rjb *rjb;
    int          ex = EX_SOFTWARE;

    GET_JOB(rjb, exenv->options, rn[PGO_CJOB]);
#   undef blin_internal_flags
#   define blin_internal_flags (rjb->flags & BLIN_MASK)
    ifBLIN_QX3("+ [%d]", rjb->flags & PGOBLIN_JOB_TYPE);
    if  (!JOBE(rjb->flags) || !JOBE(rjb->flags)->jpen) {
        errno = ENOSYS;
        ex = EX_UNAVAILABLE;
    } else {
        ex = JOBE(rjb->flags)->jpen(exenv, rn, opt);
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/***********************************************************************
 ***********************************************************************
 **                                                                   **/
pgoblin_jb_jxec(pgoblin_exenv *exenv, pgoblin_nr *rn, char **argv) { /**
 **                                                                   **
 ***********************************************************************
 ***********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rjb   *rjb;
    int            ex = EX_SOFTWARE;

    GET_JOB(rjb, exenv->options, rn[PGO_CJOB]);
#   undef blin_internal_flags
#   define blin_internal_flags (rjb->flags & BLIN_MASK)
    ifBLIN_QX3("+ [%d]", rjb->flags & PGOBLIN_JOB_TYPE);
    if  (!JOBE(rjb->flags) || !JOBE(rjb->flags)->jxec) {
        errno = ENOSYS;
        ex = EX_UNAVAILABLE;
    } else {
        ex = JOBE(rjb->flags)->jxec(exenv, rn, argv);
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_jb_jait(pgoblin_exenv *exenv, pgoblin_rjb *rjb) {           /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (rjb->flags & BLIN_MASK)
    int            ex;

    ifBLIN_QX3("+ [%d]", rjb->flags & PGOBLIN_JOB_TYPE);
    if  (!JOBE(rjb->flags) || !JOBE(rjb->flags)->jait) {
        errno = ENOSYS;
        ex = EX_UNAVAILABLE;
    } else {
        ex = JOBE(rjb->flags)->jait(exenv, rjb);
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}
