/*-
 * Copyright (C)2008..2025 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2008..2025 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: io_0.c,v 1.23 2025/02/23 04:13:05 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define PGOBLIN_MODULE   2
#define PGOBLIN_COMPAT   5
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <stdlib.h>
#include <unistd.h>
#include <limits.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

struct pgoblin_realiod {
          FILE *funout;
          int   onu;
          int   dummy;
};

static int
/*****************************************************************************************************
 **                                                                                                 **/
init(pgoblin_exenv *exenv, u_int slot) {                                                           /**
 **                                                                                                 **
 *****************************************************************************************************/
    (void)exenv;
    (void)slot;
    return(0);
}

static int
/*****************************************************************************************************
 **                                                                                                 **/
fini(pgoblin_exenv *exenv) {                                                                       /**
 **                                                                                                 **
 *****************************************************************************************************/
    (void)exenv;
    return(0);
}

static int
/**********************************************************************
 **                                                                  **/
closew(pgoblin_rio *rio) {                                          /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (rio->flags & BLIN_MASK)
    int   ex = EX_OK;

    ifBLIN_QX3("+ [%d] r[%c]", rio->flags & PGOBLIN_STYLE_TYPE, pgoblin_regn[rio->nio]);
    if  (!!rio && !!rio->iod) {
        MARK_IO_OUT_GO(rio);;
        ;;  if  (!!rio->iod->funout && !!(ex = fclose(rio->iod->funout))) {
        ;;      ifBLIN_QW0("fclose funout");
        ;;  }
        ;;  if  (!!rio->freeouts && !!(ex = close(rio->iod->onu))) {
        ;;      ifBLIN_QW0("clo in cleareg");
        ;;  }
        ;;  free(rio->iod);
        ;;  rio->iod = NULL;
        ;;  rio->parmask &= ~PGOBLIN_OUTSET;
        ;;  rio->freeouts = 0;
        ;;  rio->eof = 0;
        ;;  rio->ioerr = 0;
        ;;  rio->trapdef = 0;
        MARK_IO_OUT_WENT(rio);;
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
oprep(pgoblin_exenv *exenv, pgoblin_nr *rn) {                       /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rio *rou;
    int          ex = EX_SOFTWARE;
    int          i;

    ifBLIN_QX3("+ r[%c]", pgoblin_regn[rn[PGO_COUT]]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    if  (!rou->path || !*rou->path) {
        i = fileno(stdout);
    } else { /*  ݣ XXXX           */
        errno = 0;
        i = (int)strtol(rou->path, NULL, 0);
        if  (!!errno) {
            ifBLIN_QW0("Illegal chan num");
            goto out;
    }   }
    if  (!!(ex = pgoblin_out0_open(rou, i))) {
        ifBLIN_QW0("openr");
        goto out;
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static ssize_t
/**********************************************************************
 **                                                                  **/
writer(pgoblin_rio *rio, const void *buf, size_t size) {            /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (rio->flags & BLIN_MASK)
    ssize_t e;

    ifBLIN_QX4( "+ flags %08X r[%c] e%d t%d %"BLIN_X" %"BLIN_X"=%.*s~"
              , rio->flags
              , pgoblin_regn[rio->nio]
              , rio->eof
              , rio->trapdef
              , BLIN_I(rio)
              , BLIN_I(rio->iod)
              , (int)size, buf
              );
    if  (!!rio && !!rio->iod && !rio->eof) {
        ifBLIN_QX5("%"BLIN_X" %d", BLIN_I(mife_writ), rio->iod->onu);
        if  (0 > (e = mife_writ(rio->iod->onu, buf, size))) {
            ifBLIN_QX6("%"BLIN_D, e);
            if  (!rio->trapdef) {
                ifBLIN_QW0("IO out");
            } else {
                ifBLIN_QW0("IO out %s", rio->ioerr ? "ignore" : "error");
                e = 0;
            }
            if  (!rio->ioerr) {
                rio->ioerr = 1;
            } else {
                rio->eof = 1;
            }
        } else {
            rio->eof = 0;
        }
    } else if (!rio->trapdef) {
        ifBLIN_QX5("");
        e = -1;
    } else {
        ifBLIN_QX5("");
        e = (ssize_t)size;
    }
    ifBLIN_QX4("- %zd", e);
    return(e);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
fuclose(pgoblin_rio *rio) {                                         /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (rio->flags & BLIN_MASK)
    int   ex = EX_UNAVAILABLE;

    ifBLIN_QX3("+ [%d] r[%c]", rio->flags & PGOBLIN_STYLE_TYPE, pgoblin_regn[rio->nio]);
    if  (!!rio && !!rio->iod && !!rio->iod->funout) {
        ex = fflush(rio->iod->funout);
        if  (!!ex) ifBLIN_QW0("fflush funout");
        ex = fdclose(rio->iod->funout, NULL);
        if  (!!ex && (EFDABSENT != errno)) {
            ifBLIN_QW0("fdclose funout");
        } else {
            ex = EX_OK;
        }
        rio->iod->funout = NULL;
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static FILE *
/**********************************************************************
 **                                                                  **/
fuopen(pgoblin_rio *rio) {                                          /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (rio->flags & BLIN_MASK)

    ifBLIN_QX3("+ [%d] r[%c]", rio->flags & PGOBLIN_STYLE_TYPE, pgoblin_regn[rio->nio]);
    if  (!!rio && !!rio->iod) {
        if  (!!rio->iod->funout && !!fuclose(rio)) ifBLIN_QW1("close at funopen");
        rio->iod->funout = funopen( (void*)(size_t)rio
                                  , NULL
                                  , (int(*)(void *, const char *, int))pgoblin_io_write
                                  , NULL
                                  , NULL
                                  );
        if  (!rio->iod->funout) ifBLIN_QW0("funopen on %c(%d)", pgoblin_regn[rio->nio], rio->nio);
    }
    ifBLIN_QX3("- %"BLIN_X, BLIN_I(rio->iod->funout));
    return(rio->iod->funout);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
fdout(pgoblin_rio *rio) {                                           /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (rio->flags & BLIN_MASK)
    int   ex = -1;

    ifBLIN_QX3("+ [%d] r[%c]", rio->flags & PGOBLIN_STYLE_TYPE, pgoblin_regn[rio->nio]);
    if  (!!rio && !!rio->iod) ex = rio->iod->onu;
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static ssize_t
/**********************************************************************
 **                                                                  **/
reader(pgoblin_rio *rio, ssize_t ordlen, off_t offset) {            /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (rio->flags & BLIN_MASK)
    ssize_t   e;

    ifBLIN_QX3("+ [%d] r[%c]", rio->flags & PGOBLIN_STYLE_TYPE, pgoblin_regn[rio->nio]);
    if  (!rio || !rio->mife) {
        ifBLIN_QX5("");
        e = -1;
    } else {
        e = mife_read(rio->mife, ordlen, offset);
    }
    ifBLIN_QX3("- %"BLIN_D, e);
    return(e);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_out0_open(pgoblin_rio *rio, int fd) {                       /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (rio->flags & BLIN_MASK)
    int   ex = EX_OK;

    ifBLIN_QX3("+ [%d] r[%c]", rio->flags & PGOBLIN_STYLE_TYPE, pgoblin_regn[rio->nio]);
    if  (0 > fd) {
        if  (!!(ex = closew(rio))) ifBLIN_QW0("\"0\"->close");
    } else {
        MARK_IO_OUT_GO(rio);;
        ;;  if  (!(rio->iod = calloc(1, sizeof(pgoblin_realiod)))) {
        ;;      ifBLIN_QW0("No mem");
        ;;      ex = EX_OSERR;
        ;;      goto out;
        ;;  }
        ;;  rio->iod->onu = fd;
        ;;  rio->parmask |= PGOBLIN_OUTSET;
        ;;  rio->freeouts = 1;
        ;;  rio->trapdef = 0;
        ;;  rio->ioerr = 0;
        ;;  rio->eof = 0;
        MARK_IO_OUT_WENT(rio);;
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

pgoblin_ios pgoblin_io_0 =
{ 0                /* flags */
, "1pGoblin-" VERS /* id    */
, "0\0" VERS       /* name  */
, 0                /* dummy */
, init
, fini
, NULL             /* iprep */
, oprep
, reader           /* read  */
, writer           /* write */
, NULL             /* seek  */
, fuopen
, fuclose
, NULL             /* fdin  */
, fdout
, closew
};
