/*-
 * Copyright (C)2023..2025 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2023..2025 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: io.c,v 1.17 2025/02/14 01:17:12 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define PGOBLIN_COMPAT   5
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <unistd.h>
#include <errno.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_io_oprep(pgoblin_exenv *exenv, pgoblin_nr *rn) {            /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rio *rou;
    int          ex = -EX_SOFTWARE;

    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    ifBLIN_QX3("+ [%d]", rou->type);
    if  (!SLIO(rou->type) || !SLIO(rou->type)->oprep) {
        errno = ENOSYS;
        ex = -EX_UNAVAILABLE;
    } else {
        ex = SLIO(rou->type)->oprep(exenv, rn);
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

ssize_t
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_io_write(pgoblin_rio *rio, const void *buf, size_t size) {  /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (rio->flags & BLIN_MASK)
    ssize_t e;

    ifBLIN_QX4("+ flags %08X %"BLIN_X"=%.*s~", rio->flags, BLIN_I(rio), (int)size, buf);
    if  (!SLIO(rio->type) || !SLIO(rio->type)->write) {
        errno = ENOSYS;
        e = -EX_UNAVAILABLE;
    } else {
        e = SLIO(rio->type)->write(rio, buf, size);
    }
    ifBLIN_QX4("- %"BLIN_D, e);
    return(e);
#   undef blin_internal_flags
}

FILE *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_io_funopen(pgoblin_rio *rio) {                              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (rio->flags & BLIN_MASK)
    FILE *f = NULL;

    ifBLIN_QX3("+ [%d]", rio->flags & PGOBLIN_STYLE_TYPE);
    if  (!SLIO(rio->type) || !SLIO(rio->type)->funopen) {
        errno = ENOSYS;
    } else {
        f = SLIO(rio->type)->funopen(rio);
    }
    ifBLIN_QX3("- %"BLIN_X, BLIN_I(f));
    return(f);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_io_funclose(pgoblin_rio *rio) {                             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (rio->flags & BLIN_MASK)
    int   ex = EX_OK;

    ifBLIN_QX3("+ [%d]", rio->flags & PGOBLIN_STYLE_TYPE);
    if  (!SLIO(rio->type) || !SLIO(rio->type)->funclose) {
        errno = ENOSYS;
    } else {
        ex = SLIO(rio->type)->funclose(rio);
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_io_fdin(pgoblin_rio *rio) {                                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (rio->flags & BLIN_MASK)
    int   ex = -EX_UNAVAILABLE;

    ifBLIN_QX0("+-[%d]", rio->flags & PGOBLIN_STYLE_TYPE);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_io_fdout(pgoblin_rio *rio) {                                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (rio->flags & BLIN_MASK)
    int   ex = EX_OK;

    ifBLIN_QX3("+ [%d]", rio->flags & PGOBLIN_STYLE_TYPE);
    if  (!SLIO(rio->type) || !SLIO(rio->type)->fdout) {
        errno = ENOSYS;
        ex = -EX_UNAVAILABLE;
    } else {
        ex = SLIO(rio->type)->fdout(rio);
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_io_closew(pgoblin_rio *rio) {                               /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (rio->flags & BLIN_MASK)
    int   ex = EX_OK;

    ifBLIN_QX3("+ [%d]", rio->flags & PGOBLIN_STYLE_TYPE);
    if  (!SLIO(rio->type) || !SLIO(rio->type)->closew) {
        errno = ENOSYS;
        ex = -EX_UNAVAILABLE;
    } else {
        ex = SLIO(rio->type)->closew(rio);
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

ssize_t
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_io_read(pgoblin_rio *rio, ssize_t ordlen, off_t offset) {   /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (rio->flags & BLIN_MASK)
    ssize_t   e;

    ifBLIN_QX3("+ [%d] r[%c]", rio->flags & PGOBLIN_STYLE_TYPE, pgoblin_regn[rio->nio]);
    if  (!rio || !SLIO(rio->type) || !SLIO(rio->type)->closew || !rio->mife) {
        errno = ENOSYS;
        e = -EX_UNAVAILABLE;
    } else {
        e = mife_read(rio->mife, ordlen, offset);
    }
    ifBLIN_QX3("- %"BLIN_D, e);
    return(e);
#   undef blin_internal_flags
}
