/*-
 * Copyright (C)2002..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2002..2024 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: ini.c,v 1.41 2024/03/17 18:47:42 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define RECOBE_COMPAT    6
#define PGOBLIN_COMPAT   5
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <dlfcn.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <babolo/recobe.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

#define PREPLUGIN 3

BLIN_flag pgoblin_default;
static size_t u12[] = {341, 512, 512};

static struct {
    char const *nm ;
    void       *mod;
} mods[PGOBLIN_SYMREGS][PREPLUGIN] =
{ { {     NULL, NULL}
  , {     NULL, NULL}
  , {     NULL, NULL}
  }
 ,{ {"0"      , &pgoblin_io_0}
  , {     NULL, NULL}
  , {     NULL, NULL}
  }
 ,{ {     NULL, NULL}
  , {     NULL, NULL}
  , {     NULL, NULL}
  }
 ,{ {"0"      , &pgoblin_db_0}
  , {     NULL, NULL}
  , {     NULL, NULL}
  }
 ,{ {"local"  , &pgoblin_job_local}
  , {     NULL, NULL}
  , {     NULL, NULL}
  }
 ,{ {"0"      , &pgoblin_style_0}
  , {     NULL, NULL}
  , {     NULL, NULL}
} };

static void *
/*****************************************************************************
 *****************************************************************************
 **                                                                         **/
dload(pgoblin_main *options, int domain, size_t rs, const char *nm){       /**
 **                                                                         **
 *****************************************************************************
 *****************************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    char *libname = NULL;
    void *module  = NULL;
    void *handle  = NULL;

    for (int i = 0; !!options->libexec[i] && (PGOBLIN_SOSIZE > i); ++i) {
        asprintf(&libname, "%s/libpgoblin%d%.*s.so", options->libexec[i], domain, (int)rs, nm);
        if  (!libname) {
            ifBLIN_QW0("No mem");
            goto out;
        }
        if  (!(handle = dlopen(libname, RTLD_LAZY | RTLD_LOCAL))) {
            ifBLIN_QX1("[%d]dlopen %s: %s", i, libname, dlerror());
        }
        free(libname);
        libname = NULL;
        if  (!!handle) break;
    }
    if  (!handle) {
        asprintf( &libname, PGOBLIN_LIBDIR"/pgoblin%u/libpgoblin%d%.*s.so"
                , VMAJOR
                , domain
                , (int)rs, nm
                );
        if  (!libname) {
            ifBLIN_QW0("No mem");
            goto out;
        }
        if  (!(handle = dlopen(libname, RTLD_LAZY | RTLD_LOCAL))) {
            ifBLIN_QX0("dlopen %s: %s", libname, dlerror());
            goto out;
    }   }
    if  ((!!handle) && !(module = dlsym(handle, "pgoblin_module"))) {
        ifBLIN_QX0("dlsym pgoblin_module: %s", dlerror());
        goto out;
    }
out:
    if  (libname) free(libname);
    return(module);
#   undef blin_internal_flags
}

int
/**************************************************************************
 **************************************************************************
 **                                                                      **/
pgoblin_load(pgoblin_exenv *exenv, int mode, const char *nm, int ns) {  /**
 **                                                                      **
 **************************************************************************
 **************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    int           loaded = -1;
    u_int         slot   ;
    int           wrt    ;
    size_t        rs     ;
    int           ex     ;

    if  (0 > ns) rs = strlen(nm); else rs = (size_t)ns;
    ifBLIN_QX4("Load %d [%zu]=%.*s", mode, rs, (int)rs, nm);
    /* PGOBLIN_MODSHIFT    , default 0 */
    switch(mode) {
    case 0:
        /*    ,      */
        for (slot = PGOBLIN_MODSHIFT; (slot < pgoblin.outablesz) && !!SLOUT(slot); ++slot) {
            ifBLIN_QX7("[%d]=%.*s", slot, (int)rs, SLOUT(slot)->name);
            if  (!strncmp(SLOUT(slot)->name, nm, rs) && !SLOUT(slot)->name[rs]) {
                loaded = (int)slot;
                goto out;
        }   }
        if  (slot >= pgoblin.outablesz) {
            ifBLIN_QX0("No free slots for OUT %s", nm);
            goto out;
        }
        if  (PGOBLIN_MODSHIFT == slot) { /*    ,    */
            pgoblin_rio *rou;

            SLOUT(slot) = mods[mode][0].mod;
            if  (!!(wrt = pgoblin_wident(exenv->options, slot, SLOUT(slot)->id))) {
                ifBLIN_QW0("pgoblin_wident %d", wrt);
            }
            if  (!!(ex = SLOUT(slot)->init(exenv, slot))) {
                ifBLIN_QW0("OUT %s init failed", SLOUT(slot)->name);
                SLOUT(slot) = NULL;
                loaded = (0 > ex) ? ex : -ex;
                goto out;
            }
            if  (!(rou = pgoblin_upio(exenv, 0))) {
                ifBLIN_QX0("No OUT reg 0");
                loaded = -1;
                goto out;
            }
            MARK_IO_OUT_GO(rou);;
            ;;  rou->type = slot;
            ;;  if  (!!pgoblin_out0_open(rou, fileno(stdout))) {
            ;;      ifBLIN_QW0("[%u]open OUT %c(%u) stdio", slot, rou->nio, pgoblin_regn[rou->nio]);
            ;;      loaded = -EX_IOERR;
            ;;      goto out;
            ;;  }
            ;;  rou->freeouts = 0;
            MARK_IO_OUT_WENT(rou);;
            ++slot;
        }
        /*      */
        if  (!strncmp(mods[mode][0].nm, nm, rs) && !mods[mode][0].nm[rs]) {
            loaded = PGOBLIN_MODSHIFT;
            goto out;
        }
        /*      */
        for (int k = 1; !!mods[mode][k].nm && (k < PREPLUGIN); ++k) {
            if  (!strncmp(mods[mode][k].nm, nm, rs) && !mods[mode][k].nm[rs]) {
                SLOUT(slot) = mods[mode][k].mod;
                if  (!!(wrt = pgoblin_wident(exenv->options, slot, SLOUT(slot)->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  (!!(ex = SLOUT(slot)->init(exenv, slot))) {
                    ifBLIN_QW0("OUT %s init failed", SLOUT(slot)->name);
                    SLOUT(slot) = NULL;
                } else {
                    loaded = (int)slot;
        }   }   }
        if  (0 > loaded) { /*      */
            if  (!!(SLOUT(slot) = dload(exenv->options, 0, rs, nm))) {
                if  (!!(wrt = pgoblin_wident(exenv->options, slot, SLOUT(slot)->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  (!!(ex = SLOUT(slot)->init(exenv, slot))) {
                    ifBLIN_QW0("OUT %s init failed", SLOUT(slot)->name);
                    SLOUT(slot) = NULL;
                } else {
                    loaded = (int)slot;
        }   }   }
        break;
    case 1:
        /*    ,      */
        for (slot = PGOBLIN_MODSHIFT; (slot < pgoblin.iotablesz) && !!SLIO(slot); ++slot) {
            ifBLIN_QX7("[%d]=%.*s", slot, (int)rs, SLIO(slot)->name);
            if  (!strncmp(SLIO(slot)->name, nm, rs) && !SLIO(slot)->name[rs]) {
                loaded = (int)slot;
                goto out;
        }   }
        if  (slot >= pgoblin.iotablesz) {
            ifBLIN_QX0("No free slots for IO %s", nm);
            goto out;
        }
        if  (PGOBLIN_MODSHIFT == slot) { /*    ,    */
            pgoblin_rio *rio;

            SLIO(slot) = mods[mode][0].mod;
            if  (!!(wrt = pgoblin_wident(exenv->options, slot, SLIO(slot)->id))) {
                ifBLIN_QW0("pgoblin_wident %d", wrt);
            }
            if  (!!(ex = SLIO(slot)->init(exenv, slot))) {
                ifBLIN_QW0("IO %s init failed", SLIO(slot)->name);
                SLIO(slot) = NULL;
                loaded = (0 > ex) ? ex : -ex;
                goto out;
            }
            if  (!(rio = pgoblin_upio(exenv, 0))) {
                ifBLIN_QX0("No IO reg 0");
                loaded = -1;
                goto out;
            }
            MARK_IO_OUT_GO(rio);;
            ;;  rio->type = slot;
            ;;  if  (!!pgoblin_out0_open(rio, fileno(stdout))) {
            ;;      ifBLIN_QW0("[%u]open IO %c(%u) stdio", slot, rio->nio, pgoblin_regn[rio->nio]);
            ;;      ex = -EX_IOERR;
            ;;      goto out;
            ;;  }
            ;;  rio->freeouts = 0;
            MARK_IO_OUT_WENT(rio);;
            ++slot;
        }
        /*      */
        if  (!strncmp(mods[mode][0].nm, nm, rs) && !mods[mode][0].nm[rs]) {
            loaded = PGOBLIN_MODSHIFT;
            goto out;
        }
        /*      */
        for (int k = 1; !!mods[mode][k].nm && (k < PREPLUGIN); ++k) {
            if  (!strncmp(mods[mode][k].nm, nm, rs) && !mods[mode][k].nm[rs]) {
                SLIO(slot) = mods[mode][k].mod;
                if  (!!(wrt = pgoblin_wident(exenv->options, slot, SLIO(slot)->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  (!!(ex = SLIO(slot)->init(exenv, slot))) {
                    ifBLIN_QW0("IO %s init failed", SLIO(slot)->name);
                    SLIO(slot) = NULL;
                } else {
                    loaded = (int)slot;
        }   }   }
        if  (0 > loaded) { /*      */
            if  (!!(SLIO(slot) = dload(exenv->options, 0, rs, nm))) {
                if  (!!(wrt = pgoblin_wident(exenv->options, slot, SLIO(slot)->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  (!!(ex = SLIO(slot)->init(exenv, slot))) {
                    ifBLIN_QW0("IO %s init failed", SLIO(slot)->name);
                    SLIO(slot) = NULL;
                } else {
                    loaded = (int)slot;
        }   }   }
        break;
    case 3:
        for (slot = PGOBLIN_MODSHIFT; (slot < pgoblin.dbtablesz) && !!DBASE(slot); ++slot) {
            if  (!strncmp(DBASE(slot)->name, nm, rs) && !DBASE(slot)->name[rs]) {
                loaded = (int)slot;
                goto out;
        }   }
        if  (slot >= pgoblin.dbtablesz) {
            ifBLIN_QX0("No free slots for DB %s", nm);
            goto out;
        }
        if  (PGOBLIN_MODSHIFT == slot) {
            DBASE(slot) = mods[mode][0].mod;
            if  (!!(wrt = pgoblin_wident(exenv->options, slot, DBASE(slot)->id))) {
                ifBLIN_QW0("pgoblin_wident %d", wrt);
            }
            if  (!!(ex = DBASE(slot)->init(exenv, slot))) {
                ifBLIN_QW0("DB %s init failed", DBASE(slot)->name);
                DBASE(slot) = NULL;
                loaded = (0 > ex) ? ex : -ex;
                goto out;
            }
            ++slot;
        }
        if  (!strncmp(mods[mode][0].nm, nm, rs) && !mods[mode][0].nm[rs]) {
            loaded = PGOBLIN_MODSHIFT;
            goto out;
        }
        for (int k = 1; !!mods[mode][k].nm && (k < PREPLUGIN); ++k) {
            if  (!strncmp(mods[mode][k].nm, nm, rs) && !mods[mode][k].nm[rs]) {
                DBASE(slot) = mods[mode][k].mod;
                if  (!!(wrt = pgoblin_wident(exenv->options, slot, DBASE(slot)->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  (!!(ex = DBASE(slot)->init(exenv, slot))) {
                    ifBLIN_QW0("DB %s init failed", DBASE(slot)->name);
                    DBASE(slot) = NULL;
                } else {
                    loaded = (int)slot;
        }   }   }
        if  (0 > loaded) {
            if  (!!(DBASE(slot) = dload(exenv->options, 3, rs, nm))) {
                if  (!!(wrt = pgoblin_wident(exenv->options, slot, DBASE(slot)->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  (!!(ex = DBASE(slot)->init(exenv, slot))) {
                    ifBLIN_QW0("DB %s init failed", DBASE(slot)->name);
                    DBASE(slot) = NULL;
                } else {
                    loaded = (int)slot;
        }   }   }
        break;
    case 4:
        for (slot = PGOBLIN_MODSHIFT; (slot < pgoblin.jobtabsiz) && !!JOBE(slot); ++slot) {
            if  (!strncmp(JOBE(slot)->name, nm, rs) && !JOBE(slot)->name[rs]) {
                loaded = (int)slot;
                goto out;
        }   }
        if  (slot >= pgoblin.jobtabsiz) {
            ifBLIN_QX0("No free slots for JOB %s", nm);
            goto out;
        }
        if  (PGOBLIN_MODSHIFT == slot) {
            pgoblin_rjb  *rjb;
            pgoblin_jobl *j;

            JOBE(slot) = mods[mode][0].mod;
            if  (!!(wrt = pgoblin_wident(exenv->options, slot, JOBE(slot)->id))) {
                ifBLIN_QW0("pgoblin_wident %d", wrt);
            }
            if  (!!(ex = pgoblin_jb_init(exenv, slot))) {
                ifBLIN_QW0("JOB %s init failed", JOBE(slot)->name);
                JOBE(slot) = NULL;
                loaded = (0 > ex) ? ex : -ex;
                goto out;
            }
            if  (!(rjb = pgoblin_upjob(exenv, 0))) {
                ifBLIN_QX0("No JOB reg 0");
                loaded = -1;
                goto out;
            }
            MARK_R_JOB_GO(rjb);;
            ;;  rjb->pids = mular_create(MULAR_ZERO, 3, sizeof(pgoblin_jobl), u12);
            ;;  j = mular_add(rjb->pids);
            ;;  j->cmdn = -1;
            ;;  j->pid = getppid();
            ;;  j->status = PGOBLIN_NOSTATUS;
            ;;  j = mular_add(rjb->pids);
            ;;  j->cmdn = -1;
            ;;  j->pid = getpid();
            ;;  j->status = PGOBLIN_NOSTATUS;
            MARK_R_JOB_WENT(rjb);;
            ++slot;
        }
        if  (!strncmp(mods[mode][0].nm, nm, rs) && !mods[mode][0].nm[rs]) {
            loaded = PGOBLIN_MODSHIFT;
            goto out;
        }
        for (int k = 1; !!mods[mode][k].nm && (k < PREPLUGIN); ++k) {
            if  (!strncmp(mods[mode][k].nm, nm, rs) && !mods[mode][k].nm[rs]) {
                JOBE(slot) = mods[mode][k].mod;
                if  (!!(wrt = pgoblin_wident(exenv->options, slot, JOBE(slot)->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  (!!(ex = pgoblin_jb_init(exenv, slot))) {
                    ifBLIN_QW0("JOB %s init failed", JOBE(slot)->name);
                    JOBE(slot) = NULL;
                } else {
                    loaded = (int)slot;
        }   }   }
        if  (0 > loaded) {
            if  (!!(JOBE(slot) = dload(exenv->options, 4, rs, nm))) {
                if  (!!(wrt = pgoblin_wident(exenv->options, slot, JOBE(slot)->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  (!!(ex = pgoblin_jb_init(exenv, slot))) {
                    ifBLIN_QW0("DB %s init failed", JOBE(slot)->name);
                    JOBE(slot) = NULL;
                } else {
                    loaded = (int)slot;
        }   }   }
        break;
    case 5:
        for (slot = PGOBLIN_MODSHIFT; (slot < pgoblin.styletbsz) && !!STYLS(slot); ++slot) {
            if  (!strncmp(STYLS(slot)->name, nm, rs) && !STYLS(slot)->name[rs]) {
                loaded = (int)slot;
                goto out;
        }   }
        if  (slot >= pgoblin.styletbsz) {
            ifBLIN_QX0("No free slots for DB %s", nm);
            goto out;
        }
        if  (PGOBLIN_MODSHIFT == slot) {
            STYLS(slot) = mods[mode][0].mod;
            if  (!!(wrt = pgoblin_wident(exenv->options, slot, STYLS(slot)->id))) {
                ifBLIN_QW0("pgoblin_wident %d", wrt);
            }
            if  (!!(ex = pgoblin_st_init(exenv, slot))) {
                ifBLIN_QW0("STYLE %s init failed", STYLS(slot)->name);
                STYLS(slot) = NULL;
                loaded = (0 > ex) ? ex : -ex;
                goto out;
            }
            ++slot;
        }
        if  (!strncmp(mods[mode][0].nm, nm, rs) && !mods[mode][0].nm[rs]) {
            loaded = PGOBLIN_MODSHIFT;
            goto out;
        }
        for (int k = 1; !!mods[mode][k].nm && (k < PREPLUGIN); ++k) {
            if  (!strncmp(mods[mode][k].nm, nm, rs) && !mods[mode][k].nm[rs]) {
                STYLS(slot) = mods[mode][k].mod;
                if  (!!(wrt = pgoblin_wident(exenv->options, slot, STYLS(slot)->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  (!!(ex = pgoblin_st_init(exenv, slot))) {
                    ifBLIN_QW0("STYLE %s init failed", STYLS(slot)->name);
                    STYLS(slot) = NULL;
                } else {
                    loaded = (int)slot;
        }   }   }
        if  (0 > loaded) {
            if  (!!(STYLS(slot) = dload(exenv->options, 5, rs, nm))) {
                if  (!!(wrt = pgoblin_wident(exenv->options, slot, STYLS(slot)->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  (!!(ex = pgoblin_st_init(exenv, slot))) {
                    ifBLIN_QW0("DB %s init failed", STYLS(slot)->name);
                    STYLS(slot) = NULL;
                } else {
                    loaded = (int)slot;
        }   }   }
        break;
    default:;
    }
out:;
    return(loaded);
#   undef blin_internal_flags
}
 
pgoblin_exenv *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_init(BLIN_flag flags) {                                     /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (flags & BLIN_MASK)
    pgoblin_exenv *exenv = NULL;
    pgoblin_rio   *rio;

    blin_ctl(BLIN_CTL_FLAG | BLIN_CTL_FSET, flags);
    ifBLIN_QX2("+ flags=%08X", flags);
    if  (!(exenv = calloc(1, sizeof(pgoblin_exenv)))) {
        ifBLIN_QW0("no mem for exenv");
        goto out;
    }
    exenv->flags = flags & BLIN_MASK;
    if  (!(exenv->options = calloc(1, sizeof(pgoblin_main)))) {
        ifBLIN_QW0("no mem for options");
        free(exenv);
        exenv = NULL;
        goto out;
    }
    pgoblin_options = exenv->options;
    exenv->options->xtrace = -1;
    exenv->options->flags = flags;
    pgoblin_default = flags;
    strncpy(exenv->options->vers, VERS, 4);
    exenv->options->maxtmout = 3600000;
    strncpy((char*)exenv->options->delim, "#", 3);
    if  (!(rio = pgoblin_upio(exenv, 0))) {
        ifBLIN_QW0("No IO reg 0");
        free(exenv->options);
        exenv->options = NULL;
        free(exenv);
        exenv = NULL;
        goto out;
    }
out:;
    ifBLIN_QX2("- %s", exenv ? "OK" : "FAIL");
    return(exenv);
#   undef blin_internal_flags
}

void
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_fini(pgoblin_exenv *exenv) {                                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    u_int i;

    ifBLIN_QX2("+");
    i = pgoblin.dbtablesz;
    if  (i < pgoblin.jobtabsiz) i = pgoblin.jobtabsiz;
    if  (i < pgoblin.styletbsz) i = pgoblin.styletbsz;
    for (; ; --i) {
        if  ((i < pgoblin.styletbsz) && !!pgoblin.styletable[i]) {
            pgoblin.styletable[i]->fini(exenv);
        }
        if  ((i < pgoblin.dbtablesz) && !!DBASE(i)) {
            DBASE(i)->fini(exenv);
        }
        if  ((i < pgoblin.jobtabsiz) && !!pgoblin.jobtable[i]) {
            pgoblin.jobtable[i]->fini(exenv);
        }
        if  (!i) break;
    }
    free(exenv->options);
    ifBLIN_QX2("-");
#   undef blin_internal_flags
}
