/*-
 * Copyright (C)2017..2025 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2017..2025 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: func.c,v 1.93 2025/01/25 00:12:13 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define RECOBE_COMPAT    6
#define PGOBLIN_COMPAT   5
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sysexits.h>
#include <strings.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <babolo/recobe.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

static int16_t onecopy[16] = {-1, 0, 0, 0,  0, 0, 0, 0,  'b', 't', 'n', 'v',  'f', 'r', 0, 0};

int
pgoblin_onecsym(char in) {
    if  (16 > (in & 0x00FF)) return(onecopy[in & 0x00FF]);
    if  ('\\' == in) return('\\');
    return(0);
}

ssize_t
/*************************************************************************
 **    COPY  in,                                    **
 **  end NULL  ( end > 0)  -end - 1 ,             **
 **  end < 0, ,  end < 0,  \t,  end >= 0,           **
 **    .                                            **
 **  len < 0,  in   \0,                                **
 **   len   in.                                   **
 *************************************************************************
 **                                                                     **/
pgoblin_onecopy(char *escaped, const char *in, ssize_t len, int end) { /**
 **                                                                     **
 *************************************************************************/
    ssize_t ex = 0;
    int     c;

    if  (!in) {
        escaped[ex++]  = '\\';
        escaped[ex++]  = 'N';
    } else {
        for (int j = 0; (0 > len) ? in[j] : (0 < len--); ++j) {
            switch((c = pgoblin_onecsym(in[j]))) {
            case -1:
                errno = EINVAL;
                ex = -EX_USAGE;
                goto out;
            case 0:
                escaped[ex++] = in[j];
                break;
            default:
                escaped[ex++] = '\\';
                escaped[ex++] = (char)c;
    }   }   }
    for (c = (0 > end) ? ~end : end; c > 0; --c) {
        escaped[ex++] = '\t';
        escaped[ex++] = '\\';
        escaped[ex++] = 'N';
    }
    escaped[ex++] = (0 > end) ? '\t' : '\n';
out:
    return(ex);
}

int
/************************************************************************
 ************************************************************************
 **                                                                    **/
pgoblin_breg(pgoblin_command cmd, pgoblin_nr r) {                     /**
 **                                                                    **
 ************************************************************************
 **      cmd   r.      **
 **    cmd  r  ,   -1.  **
 **   job   -2.                             **
 ************************************************************************
 ************************************************************************/
    int j;

    j = -1;
    if  (pgoblin.a[cmd].flags & pgoblin.p[r].sym) {
        /*  a[cmd].flags    [r] */
        j = (pgoblin.p[r].bin < 0)
            /*      */
          ? (pgoblin.a[cmd].flags >> ~pgoblin.p[r].bin) & pgoblin.p[r].mask
            /*      */
          : pgoblin.p[r].bin
        ;
        if  ((PGO_CJOB == r) && !(pgoblin.a[cmd].ch[j] & pgoblin.p[r].val) && !!pgoblin.a[cmd].ch[j]) {
            /*                            *
             *     ,  -     . *
             *    0 j ,   j  ,      *
             *        j                    *
             */
            j = -2;
    }   }
    return(j);
}

pgoblin_rio *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_upio(pgoblin_exenv *exenv, pgoblin_nr nio) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    u_int16_t    deep = (u_int16_t)-1;
    pgoblin_rio *prev = NULL;
    pgoblin_rio *rio  = NULL;


    if  (pgoblin.regsize <= nio) {
        ifBLIN_QX0("Ill IO reg num %u", nio);
        errno = EDOM;
        goto out;
    }
    if  (!((1ULL << nio) & exenv->options->useio)) {
        ifBLIN_QX6("IO reg %u masked+", pgoblin_regn[nio]);
        prev = exenv->options->io[nio];
        exenv->options->io[nio] = NULL;
        if  (!!prev) deep = prev->deep;
    }
    if  (!(rio = exenv->options->io[nio])) {
        MARK_IO_GO(nio);;
        ;;  if  (!(exenv->options->io[nio] = rio = calloc(1, sizeof(pgoblin_rio)))) {
        ;;      ifBLIN_QW0("No mem IO %c", pgoblin_regn[nio]);
        ;;      goto out;
        ;;  }
        ;;  rio->prev = prev;
        ;;  rio->deep = ++deep;
        ;;  rio->nio = nio;
        ;;  rio->flags = exenv->options->flags & BLIN_MASK;
        MARK_IO_WENT(nio);;
        exenv->options->useio |= (1ULL << nio);
    }
out:
    return(rio);
#   undef blin_internal_flags
}

pgoblin_rdb *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_upcon(pgoblin_exenv *exenv, pgoblin_nr ndb) {               /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    u_int16_t    deep = (u_int16_t)-1;
    pgoblin_rdb *prev = NULL;
    pgoblin_rdb *rdb  = NULL;

    if  (pgoblin.regsize <= ndb) {
        ifBLIN_QX0("Ill CONN reg num %u", ndb);
        errno = EDOM;
        goto out;
    }
    if  (!((1ULL << ndb) & exenv->options->usecon)) {
        ifBLIN_QX6("CONN %c masked+", pgoblin_regn[ndb]);
        prev = exenv->options->conn[ndb];
        exenv->options->conn[ndb] = NULL;
        if  (!!prev) deep = prev->deep;
    }
    if  (!(rdb = exenv->options->conn[ndb])) {
        MARK_CONN_GO(ndb);;
        ;;  if  (!(exenv->options->conn[ndb] = rdb = calloc(1, sizeof(pgoblin_rdb)))) {
        ;;      ifBLIN_QW0("No mem CONN %c", pgoblin_regn[ndb]);
        ;;      goto out;
        ;;  }
        ;;  rdb->prev = prev;
        ;;  rdb->deep = ++deep;
        ;;  rdb->ndb = ndb;
        ;;  rdb->flags = exenv->options->flags & BLIN_MASK;
        MARK_CONN_WENT(ndb);;
        exenv->options->usecon |= (1ULL << ndb);
    }
out:
    return(rdb);
#   undef blin_internal_flags
}

pgoblin_rjb *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_upjob(pgoblin_exenv *exenv, pgoblin_nr njb) {               /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    u_int16_t    deep = (u_int16_t)-1;
    pgoblin_rjb *prev = NULL;
    pgoblin_rjb *rjb  = NULL;

    if  (pgoblin.regsize <= njb) {
        ifBLIN_QX0("Ill JOB reg num %u", njb);
        errno = EDOM;
        goto out;
    }
    if  (!((1ULL << njb) & exenv->options->usejob)) {
        ifBLIN_QX6("JOB %c masked+", pgoblin_regn[njb]);
        prev = exenv->options->job[njb];
        exenv->options->job[njb] = NULL;
        if  (!!prev) deep = prev->deep;
    }
    if  (!(rjb = exenv->options->job[njb])) {
        MARK_JOB_GO(njb);;
        ;;  if  (!(exenv->options->job[njb] = rjb = calloc(1, sizeof(pgoblin_rjb)))) {
        ;;      ifBLIN_QW0("No mem for JOB %c", pgoblin_regn[njb]);
        ;;      goto out;
        ;;  }
        ;;  rjb->prev = prev;
        ;;  rjb->deep = ++deep;
        ;;  rjb->njb = njb;
        ;;  rjb->flags = exenv->options->flags & BLIN_MASK;
        MARK_JOB_WENT(njb);;
        exenv->options->usejob |= (1ULL << njb);
    }
out:
    return(rjb);
#   undef blin_internal_flags
}

pgoblin_rst *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_upsty(pgoblin_exenv *exenv, pgoblin_nr nst) {               /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    u_int16_t    deep = (u_int16_t)-1;
    pgoblin_rst *prev = NULL;
    pgoblin_rst *rst  = NULL;

    if  (pgoblin.regsize <= nst) {
        ifBLIN_QX0("Ill STY reg num %u", nst);
        errno = EDOM;
        goto out;
    }
    if  (!((1ULL << nst) & exenv->options->usesty)) {
        ifBLIN_QX6("STY %c masked+", pgoblin_regn[nst]);
        prev = exenv->options->style[nst];
        exenv->options->style[nst] = NULL;
        if  (!!prev) deep = prev->deep;
    }
    if  (!(rst = exenv->options->style[nst])) {
        MARK_STYLE_GO(nst);;
        ;;  if  (!(exenv->options->style[nst] = rst = calloc(1, sizeof(pgoblin_rst)))) {
        ;;      ifBLIN_QW0("No mem for STY %c", pgoblin_regn[nst]);
        ;;      goto out;
        ;;  }
        ;;  rst->prev = prev;
        ;;  rst->deep = ++deep;
        ;;  rst->nst = nst;
        ;;  rst->flags = exenv->options->flags & BLIN_MASK;
        MARK_STYLE_WENT(nst);;
        exenv->options->usesty |= (1ULL << nst);
    }
out:
    return(rst);
#   undef blin_internal_flags
}

pgoblin_rio *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_meio(pgoblin_main *options, pgoblin_nr nio) {               /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    pgoblin_rio *rio  = NULL;


    if  (pgoblin.regsize <= nio) {
        ifBLIN_QX0("Ill IO reg num %u", nio);
        errno = EDOM;
        goto out;
    }
    if  (!((1ULL << nio) & options->useio)) {
        ifBLIN_QX6("IO %c masked", pgoblin_regn[nio]);
        errno = ENOENT;
        goto out;
    }
    if  (!(rio = options->io[nio])) {
        errno = ENOENT;
        goto out;
    }
out:
    return(rio);
#   undef blin_internal_flags
}

pgoblin_rdb *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_mecon(pgoblin_main *options, pgoblin_nr ndb) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    pgoblin_rdb *rdb  = NULL;

    if  (pgoblin.regsize <= ndb) {
        ifBLIN_QX0("Ill CONN reg num %u", ndb);
        errno = EDOM;
        goto out;
    }
    if  (!((1ULL << ndb) & options->usecon)) {
        ifBLIN_QX6("CONN %c masked", pgoblin_regn[ndb]);
        errno = ENOENT;
        goto out;
    }
    if  (!(rdb = options->conn[ndb])) {
        errno = ENOENT;
        goto out;
    }
out:
    return(rdb);
#   undef blin_internal_flags
}

pgoblin_rjb *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_mejob(pgoblin_main *options, pgoblin_nr njb) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    pgoblin_rjb *rjb = NULL;

    if  (pgoblin.regsize <= njb) {
        ifBLIN_QX0("Ill JOB reg num %u", njb);
        errno = EDOM;
        goto out;
    }
    if  (!((1ULL << njb) & options->usejob)) {
        ifBLIN_QX6("JOB %c masked", pgoblin_regn[njb]);
        errno = ENOENT;
        goto out;
    }
    if  (!(rjb = options->job[njb])) {
        errno = ENOENT;
        goto out;
    }
out:
    return(rjb);
#   undef blin_internal_flags
}

pgoblin_rst *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_mesty(pgoblin_main *options, pgoblin_nr nst) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    pgoblin_rst *rst  = NULL;

    if  (pgoblin.regsize <= nst) {
        ifBLIN_QX0("Ill STY reg num %u", nst);
        errno = EDOM;
        goto out;
    }
    if  (!((1ULL << nst) & options->usesty)) {
        ifBLIN_QX6("STY %c masked", pgoblin_regn[nst]);
        errno = ENOENT;
        goto out;
    }
    if  (!(rst = options->style[nst])) {
        errno = ENOENT;
        goto out;
    }
out:
    return(rst);
#   undef blin_internal_flags
}

pgoblin_rio *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_pushio(pgoblin_exenv *exenv, pgoblin_nr nio) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    u_int16_t    deep = 0;
    pgoblin_rio *prev = NULL;
    pgoblin_rio *rio  = NULL;

    if  (pgoblin.regsize <= nio) {
        ifBLIN_QX0("Ill IO reg num %u", nio);
        errno = EDOM;
        goto out;
    }
    prev = exenv->options->io[nio];
    ifBLIN_QX6("IO   %u(%c) ->%"BLIN_X, nio, pgoblin_regn[nio], BLIN_I(prev));
    if  (!!prev) deep = prev->deep;
    MARK_IO_GO(nio);;
    ;;  if  (!(exenv->options->io[nio] = rio = calloc(1, sizeof(pgoblin_rio)))) {
    ;;      ifBLIN_QW0("No mem for IO %c", pgoblin_regn[nio]);
    ;;      goto out;
    ;;  }
    ;;  rio->prev = prev;
    ;;  rio->deep = ++deep;
    ;;  rio->nio = nio;
    ;;  rio->flags = exenv->options->flags & BLIN_MASK;
    MARK_IO_WENT(nio);;
    exenv->options->useio |= (1ULL << nio);
    ifBLIN_QX6("IO   %08X N%u (%u)", rio->flags, rio->nio, rio->deep);
out:
    ifBLIN_QX6( "IO   %"BLIN_X"->%"BLIN_X
              , BLIN_I(rio)
              , BLIN_I(prev)
              );
    return(rio);
#   undef blin_internal_flags
}

pgoblin_rdb *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_pushcon(pgoblin_exenv *exenv, pgoblin_nr ndb) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    u_int16_t    deep = 0;
    pgoblin_rdb *prev = NULL;
    pgoblin_rdb *rdb  = NULL;

    if  (pgoblin.regsize <= ndb) {
        ifBLIN_QX0("Ill CONN reg num %u", ndb);
        errno = EDOM;
        goto out;
    }
    prev = exenv->options->conn[ndb];
    if  (!!prev) deep = prev->deep;
    MARK_CONN_GO(ndb);;
    ;;  if  (!(exenv->options->conn[ndb] = rdb = calloc(1, sizeof(pgoblin_rdb)))) {
    ;;      ifBLIN_QW0("No mem for CONN %c", pgoblin_regn[ndb]);
    ;;      goto out;
    ;;  }
    ;;  rdb->prev = prev;
    ;;  rdb->deep = ++deep;
    ;;  rdb->ndb = ndb;
    ;;  rdb->flags = exenv->options->flags & BLIN_MASK;
    MARK_CONN_WENT(ndb);;
    exenv->options->usecon |= (1ULL << ndb);
out:
    ifBLIN_QX6("CONN %"BLIN_X"->%"BLIN_X, BLIN_I(rdb), BLIN_I(prev));
    return(rdb);
#   undef blin_internal_flags
}

pgoblin_rjb *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_pushjob(pgoblin_exenv *exenv, pgoblin_nr njb) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    u_int16_t    deep = 0;
    pgoblin_rjb *prev = NULL;
    pgoblin_rjb *rjb = NULL;

    if  (pgoblin.regsize <= njb) {
        ifBLIN_QX0("Ill JOB reg num %u", njb);
        errno = EDOM;
        goto out;
    }
    prev = exenv->options->job[njb];
    if  (!!prev) deep = prev->deep;
    MARK_JOB_GO(njb);;
    ;;  if  (!(exenv->options->job[njb] = rjb = calloc(1, sizeof(pgoblin_rjb)))) {
    ;;      ifBLIN_QW0("No mem for JOB %c", pgoblin_regn[njb]);
    ;;      goto out;
    ;;  }
    ;;  rjb->prev = prev;
    ;;  rjb->deep = ++deep;
    ;;  rjb->njb = njb;
    ;;  rjb->flags = exenv->options->flags & BLIN_MASK;
    MARK_JOB_WENT(njb);;
    exenv->options->usejob |= (1ULL << njb);
out:
    ifBLIN_QX6("JOB  %"BLIN_X"->%"BLIN_X, BLIN_I(rjb), BLIN_I(prev));
    return(rjb);
#   undef blin_internal_flags
}

pgoblin_rst *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_pushsty(pgoblin_exenv *exenv, pgoblin_nr nst) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    u_int16_t    deep = 0;
    pgoblin_rst *prev = NULL;
    pgoblin_rst *rst  = NULL;

    if  (pgoblin.regsize <= nst) {
        ifBLIN_QX0("Ill STY reg num %u", nst);
        errno = EDOM;
        goto out;
    }
    prev = exenv->options->style[nst];
    if  (!!prev) deep = prev->deep;
    MARK_STYLE_GO(nst);;
    ;;  if  (!(exenv->options->style[nst] = rst = calloc(1, sizeof(pgoblin_rst)))) {
    ;;      ifBLIN_QW0("No mem for STY %c", pgoblin_regn[nst]);
    ;;      goto out;
    ;;  }
    ;;  rst->prev = prev;
    ;;  rst->deep = ++deep;
    ;;  rst->nst = nst;
    ;;  rst->flags = exenv->options->flags & BLIN_MASK;
    MARK_STYLE_WENT(nst);;
    exenv->options->usesty |= (1ULL << nst);
out:
    ifBLIN_QX6("STY  %"BLIN_X"->%"BLIN_X, BLIN_I(rst), BLIN_I(prev));
    return(rst);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_popio(pgoblin_main *options, pgoblin_nr nio) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    int          ex   = EX_OK;
    pgoblin_rio *prev = NULL;

    if  (pgoblin.regsize <= nio) {
        ifBLIN_QX0("Ill IO reg num %u", nio);
        ex = EX_CANTCREAT;
        errno = EDOM;
        goto out;
    }
    if  (!!options->io[nio]) {
        prev = options->io[nio]->prev;
        MARK_IO_ALL_GO(options->io[nio]);;
        ;;  free(options->io[nio]); /* XXXX   XXXX */
        ;;  options->io[nio] = prev;
        MARK_IO_ALL_WENT(nio);;
    }
    if  (!prev) options->useio &= ~(1ULL << nio);
out:
    ifBLIN_QX6("IO   %"BLIN_X" %u", BLIN_I(prev), ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_popcon(pgoblin_main *options, pgoblin_nr ndb) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    int          ex   = EX_OK;
    pgoblin_rdb *prev = NULL;

    if  (pgoblin.regsize <= ndb) {
        ifBLIN_QX0("Ill CONN reg num %u", ndb);
        ex = EX_CANTCREAT;
        errno = EDOM;
        goto out;
    }
    if  (!!options->conn[ndb]) {
        prev = options->conn[ndb]->prev;
        MARK_R_CONN_GO(options->conn[ndb]);;
        ;;  free(options->conn[ndb]); /* XXXX   XXXX */
        ;;  options->conn[ndb] = prev;
        MARK_CONN_WENT(ndb);;
    }
    if  (!prev) options->usecon &= ~(1ULL << ndb);
out:
    ifBLIN_QX6("CONN %"BLIN_X" %u", BLIN_I(prev), ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_popjob(pgoblin_main *options, pgoblin_nr njb) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    int          ex   = EX_OK;
    pgoblin_rjb *prev = NULL;

    if  (pgoblin.regsize <= njb) {
        ifBLIN_QX0("Ill JOB reg num %u", njb);
        ex = EX_CANTCREAT;
        errno = EDOM;
        goto out;
    }
    if  (!!options->job[njb]) {
        prev = options->job[njb]->prev;
        MARK_R_JOB_GO(options->job[njb]);;
        ;;  free(options->job[njb]); /* XXXX      XXXX */
        ;;  options->job[njb] = prev;
        MARK_JOB_WENT(njb);;
    }
    if  (!prev) options->usejob &= ~(1ULL << njb);
out:
    ifBLIN_QX6("JOB  %"BLIN_X" %u", BLIN_I(prev), ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_popsty(pgoblin_main *options, pgoblin_nr nst) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    int          ex   = EX_OK;
    pgoblin_rst *prev = NULL;

    if  (pgoblin.regsize <= nst) {
        ifBLIN_QX0("Ill STY reg num %u", nst);
        ex = EX_CANTCREAT;
        errno = EDOM;
        goto out;
    }
    if  (!!options->style[nst]) {
        prev = options->style[nst]->prev;
        MARK_R_STYLE_GO(options->style[nst]);;
        ;;  free(options->style[nst]); /* XXXX   XXXX */
        ;;  options->style[nst] = prev;
        MARK_STYLE_WENT(nst);;
    }
    if  (!prev) options->usesty &= ~(1ULL << nst);
out:
    ifBLIN_QX6("STY  %"BLIN_X" %u", BLIN_I(prev), ex);
    return(ex);
#   undef blin_internal_flags
}
