/*-
 * Copyright (C)2002..2025 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2002..2025 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: execute.c,v 1.276 2025/02/14 22:59:41 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define RECOBE_COMPAT    6
#define PGOBLIN_COMPAT   5
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <dlfcn.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <babolo/recobe.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

#define SNPTEST  do {                                 \
    if  (0 > n) {                                     \
        ifBLIN_QX0("snprintf failed");                \
        free(buf);                                    \
        buf = NULL;                                   \
        goto out;                                     \
    } else if ((size_t)n < buflen) {                  \
        buflen -= (size_t)n;                          \
        buf += n;                                     \
    } else {                                          \
        ifBLIN_QX1("snprintf overflow");              \
        buflen = 0;                                   \
}   } while(0)

extern BLIN_flag pgoblin_default;
static size_t const u12[] = {341, 512, 512};
static char const *sigids[128] =
{    NULL, "HUP"  , "INT"   , "QUIT" , "ILL"  , "TRAP" , "ABR"  , "EMT"   /*  0 */
, "FPE"  , "KILL" , "BUS"   , "SEGV" , "SYS"  , "PIPE" , "ALRM" , "TERM"  /*  8 */
, "URG"  , "STOP" , "TSTP"  , "CONT" , "CHLD" , "TTIN" , "TTOU" , "IO"    /* 16 */
, "XCPU" , "XFSZ" , "VTALRM", "PROF" , "WINCH", "INFO" , "USR1" , "USR2"  /* 24 */
, "THR"  , "LIBRT",     NULL,    NULL,    NULL,    NULL,    NULL,    NULL /* 32 */
,    NULL,    NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL /* 40 */
,    NULL,    NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL /* 48 */
,    NULL,    NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL /* 56 */
,    NULL, "RTMIN", "RT066" , "RT067", "RT068", "RT069", "RT070", "RT071" /* 64 */
, "RT72" , "RT73" , "RT74"  , "RT75" , "RT76" , "RT77" , "RT78" , "RT79"  /* 72 */
, "RT80" , "RT81" , "RT82"  , "RT83" , "RT84" , "RT85" , "RT86" , "RT87"  /* 80 */
, "RT88" , "RT89" , "RT90"  , "RT91" , "RT92" , "RT93" , "RT94" , "RT95"  /* 88 */
, "RT96" , "RT97" , "RT98"  , "RT99" , "RT100", "RT101", "RT102", "RT103" /* 96 */
, "RT104", "RT105", "RT106" , "RT107", "RT108", "RT109", "RT110", "RT111" /* 104 */
, "RT112", "RT113", "RT114" , "RT115", "RT116", "RT117", "RT118", "RT119" /* 112 */
, "RT120", "RT121", "RT122" , "RT123", "RT124", "RT125", "RTMAX",    NULL /* 120 */
};

static void
/**********************************************************************
 **                                                                  **/
dump_ioreg(pgoblin_main *options, pgoblin_nr r) {                   /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    size_t       buflen = 1000;
    char        *ret    = NULL;
    char        *buf    = NULL;
    pgoblin_rio *rio;
    int          n;

    if  (!(rio = pgoblin_meio(options, r))) goto out;
    if  ((rio->parmask & PGOBLIN_TEXTPARM) && !!rio->text) {
        if  (!rio->binparm) {
            buflen += strlen(rio->text);
        } else {
            buflen += 4 * rio->length;
    }   }
    if  (!(ret = buf = malloc(buflen))) {
        ifBLIN_QX0("Malloc failed");
        goto out;
    }
    n = snprintf(buf, buflen, "[%c]", pgoblin_regn[r]);
    SNPTEST;
    if  (rio->parmask || rio->mife || rio->pq || rio->iod || rio->path || rio->text) {
        n = snprintf( buf
                    , buflen
                    , "(%06X%s%s%s%s%s%s%s%s%s%s%s%s):"
                    , rio->parmask
                    , (rio->parmask & PGOBLIN_PATHPARM) ? " path"  : ""
                    , (!!rio->freepath)               ? " path*" : ""
                    , (!!rio->fileover)               ? " over"  : ""
                    , (rio->parmask & PGOBLIN_TEXTPARM) ? " text"  : ""
                    , (!!rio->freetext)               ? " text*" : ""
                    , (!!rio->binparm )               ? " bin"   : ""
                    , (rio->parmask & PGOBLIN_MIFEDES ) ? " mife"  : ""
                    , (!!rio->freemife)               ? " mife*" : ""
                    , (rio->parmask & PGOBLIN_PQRESULT) ? " pq"    : ""
                    , (!!rio->freepqre)               ? " pq*"   : ""
                    , (rio->parmask & PGOBLIN_OUTSET  ) ? " out"   : ""
                    , (!!rio->freeouts)               ? " out*"  : ""
                    );
        SNPTEST;
        if  (!!rio->mife) {
            n = snprintf(buf, buflen, " mife=%"BLIN_X" pid=%d", BLIN_I(rio->mife), rio->mpid);
            SNPTEST;
        }
        if  (!!rio->pq) {
            n = snprintf(buf, buflen, " pq=%"BLIN_X" flags=%08X", BLIN_I(rio->pq), *rio->pq);
            SNPTEST;
        }
        if  ((rio->parmask & PGOBLIN_PATHPARM) && !!rio->path) {
            n = snprintf(buf, buflen, " path=%s~", rio->path);
            SNPTEST;
        }
        if  ((rio->parmask & PGOBLIN_TEXTPARM) && !!rio->text) {
            if  (!rio->binparm) {
                n = snprintf(buf, buflen, " text=%s~", (char*)rio->text);
                SNPTEST;
            } else ifBLIN_QO4 {
                u_int i;

                n = snprintf(buf, buflen, " bin=");
                SNPTEST;
                for (i = 0; i < rio->length; i++) {
                    if  (  ((((u_char*)rio->text)[i] >= 0177) && (((u_char*)rio->text)[i] < 0300))
                        || (((u_char*)rio->text)[i] < ' ')
                        ) {
                        n = snprintf(buf, buflen, "\\%03o", ((u_char*)rio->text)[i]);
                        SNPTEST;
                    } else if (((char*)rio->text)[i] == '\\') {
                        n = snprintf(buf, buflen, "\\\\");
                        SNPTEST;
                    } else {
                        n = snprintf(buf, buflen, "%c", ((char*)rio->text)[i]);
                        SNPTEST;
                }   }
                n = snprintf(buf, buflen, "~");
                SNPTEST;
            } else {
                n = snprintf( buf
                            , buflen
                            , " bin %" BLIN_X " length %d\n"
                            , BLIN_I(rio->text)
                            , (int)rio->length
                            );
                SNPTEST;
    }   }   }
    ifBLIN_QX3("%s", ret);
    free(ret);
out:
    return;
#   undef blin_internal_flags
}

static void
/***********************************************************************************************
 **                                                                                           **/
iorassert(pgoblin_exenv *exenv, pgoblin_command cmd, u_int32_t lfcount, const char *finam) { /**
 **                                                                                           **
 ***********************************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
#   define W "%s:%u cmd[%u]=%03X(%s) fl[%c]=%08X "
#   define WW(A) do {ifBLIN_QX1(W A, finam, lfcount, exenv->ppoint, cmd, s, n, rio->parmask);} while(0)
    pgoblin_rio *rio;
    u_char       rr[pgoblin.regsize + 1];
    u_char       rp[pgoblin.regsize + 1];

    bzero(rr, pgoblin.regsize + 1);
    for (pgoblin_nr r = 0; r < pgoblin.regsize; r++) {
        const char *s = pgoblin.a[cmd].str;
        char        n = pgoblin_regn[r];
        u_int8_t    e;

        if  (!(rio = pgoblin_meio(exenv->options, r))) continue;
        e = 0; /*  ,    */
        if  (rio->path) {
            e |= PGOBLIN_PATHPARM;
        } else if (rio->parmask & PGOBLIN_PATHPARM) {
            WW("  path");
        } else if (!!rio->freepath) {
            WW("  path");
        }
        if  (rio->text) {
            e |= PGOBLIN_TEXTPARM;
        } else if (rio->parmask & PGOBLIN_TEXTPARM) {
            WW("  text");
        } else if (!!rio->freetext) {
            WW("  text");
        }
        if  (rio->mife) {
            e |= PGOBLIN_MIFEDES;
        } else if (rio->parmask & PGOBLIN_MIFEDES) {
            WW("  mife");
        } else if (!!rio->freemife) {
            WW("  mife");
        }
        if  (rio->pq) {
            e |= PGOBLIN_PQRESULT;
        } else if (rio->parmask & PGOBLIN_PQRESULT) {
            WW("  pq");
        } else if (!!rio->freepqre) {
            WW("  pq");
        }
        if  (!(rio->parmask & PGOBLIN_ANYIVL) && e) {
            ifBLIN_QX1( W "  %02X(%s%s%s%s)"
                      , finam
                      , lfcount
                      , exenv->ppoint
                      , cmd
                      , s
                      , n
                      , rio->parmask
                      , e
                      , (e & PGOBLIN_PATHPARM) ? "f" : ""
                      , (e & PGOBLIN_TEXTPARM) ? "t" : ""
                      , (e & PGOBLIN_MIFEDES)  ? "m" : ""
                      , (e & PGOBLIN_PQRESULT) ? "q" : ""
                      );
        }
        rr[r] = e;
    }
    ifBLIN_QO2 {
        /*    - ,     ,
         *     .
         */
        for (pgoblin_nr r = 0; r < pgoblin.regsize; r++) {
            rp[r] = (u_char)pgoblin_regn[rr[r]];
            if  (!(rio = exenv->options->io[r])) {
                rr[r] = '.';
            } else if (rr[r] == (rio->parmask & (PGOBLIN_ANYIVL | PGOBLIN_OUTSET))) {
                rr[r] = '=';
            } else {
                rr[r] = (u_char)pgoblin_regn[rio->parmask & (PGOBLIN_ANYIVL | PGOBLIN_OUTSET)];
        }   }
        rr[pgoblin.regsize] = rp[pgoblin.regsize] = '\0';
        ifBLIN_QX2("     %.*s", 64, pgoblin_regn);
        ifBLIN_QX2("regs %s", rp);
        ifBLIN_QX2("flag %s", rr);
    }
    ifBLIN_QX4( "\n    00 0   08 8   10 G   18 O   20 W   28 e   30 m   38 u"
                "\n    01 1   09 9   11 H   19 P   21 X   29 f   31 n   39 v"
                "\n    02 2   0A A   12 I   1A Q   22 Y   2A g   32 o   3A w"
                "\n    03 3   0B B   13 J   1B R   23 Z   2B h   33 p   3B x"
                "\n    04 4   0C C   14 K   1C S   24 a   2C i   34 q   3C y"
                "\n    05 5   0D D   15 L   1D T   25 b   2D j   35 r   3D z"
                "\n    06 6   0E E   16 M   1E U   26 c   2E k   36 s   3E _"
                "\n    07 7   0F F   17 N   1F V   27 d   2F l   37 t   3F -"
              );
#   undef WW
#   undef W
#   undef blin_internal_flags
}

/*
 *   IO      . score[][] 
 *  -     r ()   ch ()   
 *  .     procomp(options, r, ch).  
 *   propush(exenv, r, ch)  ,     
 *  ,  ,  Co   propush(), 
 *    Cf, Ct, Cm, Cq  Cw  cleareg(options, r, m),  m
 *   ,   procomp() -     .
 *       exenv->flags,      (
 * Ce == PGOBLIN_FORKOUT)   ( Cs, Cp, Cu  PGOBLIN_FREE*) 
 *  .
 */

static int
/**********************************************************************
 **                                                                  **/
cleareg(pgoblin_exenv *exenv, pgoblin_nr r, u_int32_t m) {          /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rio      *rio;
    int               ex     = EX_OK;
    int               cl     = 0;        /*     , *
                                          *    ,    . */

    if  (!(rio = pgoblin_meio(exenv->options, r))) goto out;
    ifBLIN_QX4("+ r[%c] %"BLIN_X" %s[%02X]", pgoblin_regn[r], BLIN_I(rio), pgoblin_parmask(0, m), m);
    if  (m & PGOBLIN_PATHPARM) {
        ++cl;
        MARK_IO_PATH_GO(rio);;
        ;;  if  (!!rio->path && !!rio->freepath) free(rio->path);
        ;;  rio->path = NULL;
        ;;  rio->parmask &= ~PGOBLIN_PATHPARM;
        ;;  rio->fileover = 0;
        ;;  rio->freepath = 0;
        MARK_IO_PATH_WENT(rio);;
    }
    if  (m & PGOBLIN_TEXTPARM) {
        ++cl;
        MARK_IO_TEXT_GO(rio);;
        ;;  if  (!!rio->stymd) {
        ;;      mular_destroy(rio->stymd);
        ;;      rio->stymd = NULL;
        ;;  }
        ;;  pgoblin_dexenv(&rio->oxenv);
        ;;  if  (!!rio->text && !!rio->freetext) {
        ;;      free(rio->text);
        ;;  }
        ;;  rio->text = NULL;
        ;;  rio->length = 0;
        ;;  rio->parmask &= ~PGOBLIN_TEXTPARM;
        ;;  rio->binparm = 0;
        ;;  rio->freetext = 0;
        MARK_IO_TEXT_WENT(rio);;
    }
    if  (m & PGOBLIN_PQRESULT) {
        ++cl;
        MARK_IO_PQ_GO(rio);;
        ;;  if  (!!rio->pq && !!rio->freepqre && !!DBASE(*(BLIN_flag*)(rio->pq))) {
        ;;      pgoblin_db_clear(rio);
        ;;  }
        ;;  rio->pq = NULL;
        ;;  rio->parmask &= ~PGOBLIN_PQRESULT;
        ;;  rio->freepqre = 0;
        ;;  rio->purge = 0;
        ;;  rio->cortege = -1;
        MARK_IO_PQ_WENT(rio);;
    }
    if  (m & PGOBLIN_MIFEDES) {
        ++cl;
        MARK_IO_MIFE_GO(rio);;
        ;;  if  (!!rio->mife && !!rio->freemife && !!(ex = mife_fini(rio->mife))) {
        ;;      ifBLIN_QW0("mife_fini");
        ;;  }
        ;;  rio->mife = NULL;
        ;;  rio->mpid = 0;
        ;;  rio->parmask &= ~PGOBLIN_MIFEDES;
        ;;  rio->freemife = 0;
        MARK_IO_MIFE_WENT(rio);;
    }
    if  (m & PGOBLIN_OUTSET) {
        ++cl;
        MARK_IO_OUT_GO(rio);;
        ;;  if  (!!rio->freeouts && (ex = pgoblin_io_closew(rio))) {
        ;;      ifBLIN_QW0("pgoblin_io_closew");
        ;;  }
        MARK_IO_OUT_WENT(rio);;
    }
    if  (!!cl) {                                     /*    -,   ӣ */
        if  (!!rio->path && !(rio->parmask & PGOBLIN_PATHPARM)) {
            MARK_IO_PATH_GO(rio);;
            ;;  if  (!!rio->freepath) free(rio->path);
            ;;  rio->path = NULL;
            ;;  rio->parmask &= ~PGOBLIN_PATHPARM;
            ;;  rio->fileover = 0;
            ;;  rio->freepath = 0;
            MARK_IO_PATH_WENT(rio);;
        }
        if  (!!rio->text && !(rio->parmask & PGOBLIN_TEXTPARM)) {
            MARK_IO_TEXT_GO(rio);;
            ;;  if  (!!rio->stymd) {
            ;;      mular_destroy(rio->stymd);
            ;;      rio->stymd = NULL;
            ;;  }
            ;;  pgoblin_dexenv(&rio->oxenv);
            ;;  if  (rio->freetext) free(rio->text);
            ;;  rio->text = NULL;
            ;;  rio->length = 0;
            ;;  rio->parmask &= ~PGOBLIN_TEXTPARM;
            ;;  rio->binparm = 0;
            ;;  rio->freetext = 0;
            MARK_IO_TEXT_WENT(rio);;
        }
        if  (!!rio->pq && !(rio->parmask & PGOBLIN_PQRESULT)) {
            MARK_IO_PQ_GO(rio);;
            ;;  if  (!!rio->freepqre && !!DBASE(*(BLIN_flag*)(rio->pq))) {
            ;;      pgoblin_db_clear(rio);
            ;;  }
            ;;  rio->pq = NULL;
            ;;  rio->parmask &= ~PGOBLIN_PQRESULT;
            ;;  rio->freepqre = 1;
            ;;  rio->cortege = -1;
            MARK_IO_PQ_WENT(rio);;
        }
        if  (!!rio->mife && !(rio->parmask & PGOBLIN_MIFEDES)) {
            MARK_IO_MIFE_GO(rio);;
            ;;  if  (!!rio->freemife && (ex = mife_fini(rio->mife))) {
            ;;      ifBLIN_QW0("mife_fini");
            ;;  }
            ;;  rio->mife = NULL;
            ;;  rio->mpid = 0;
            ;;  rio->parmask &= ~PGOBLIN_MIFEDES;
            ;;  rio->freemife = 0;
            MARK_IO_MIFE_WENT(rio);;
    }   }
    if  (!rio->text) {                        /*  text        */
        if  (!!rio->stymd) {                                              /*    */
            ifBLIN_QX1("rio->stymd without TEXT");
            MARK_IO_TEXT_GO(rio);;
            ;;  mular_destroy(rio->stymd);
            ;;  rio->stymd = NULL;
            MARK_IO_TEXT_WENT(rio);;
        }
        if  (!!rio->oxenv) {                                              /*    */
            ifBLIN_QX1("rio->exenv without TEXT");
            MARK_IO_TEXT_GO(rio);;
            ;;  pgoblin_dexenv(&rio->oxenv);
            MARK_IO_TEXT_WENT(rio);;
    }   }
out:
    ifBLIN_QX4("- %d[%c]%c", ex, pgoblin_regn[r], cl ? '+' : '-');
    return(ex);
#   undef blin_internal_flags
}

#define Cx PGOBLIN_IGNORE   /* impossible         0x800000 */
#define Co PGOBLIN_OPEN     /* open               0x200000 */
#define Cf PGOBLIN_PATHPARM /* free path          0x000001 */
#define Ct PGOBLIN_TEXTPARM /* free text          0x000002 */
#define Cm PGOBLIN_MIFEDES  /* free mife          0x000004 */
#define Cq PGOBLIN_PQRESULT /* free pq            0x000008 */
#define Cw PGOBLIN_OUTSET   /* free wri           0x000010 */
#define Ce PGOBLIN_FORKOUT  /* fork               0x000020 */
#define Cs PGOBLIN_FREEPATH /* stream file out    0x010000 */
#define Cp PGOBLIN_FREETEXT /* copy text out      0x020000 */
#define Cu PGOBLIN_FREEPQRE /* unstore pq out     0x080000 */

static const u_int32_t score[32][4] =
 /*ftmqo          Pf           Pt           Pm           Pq   Wish*/
{/*00000*/{0              ,0           ,          Ce,0           }
,/*10000*/{ Co|Cf|      Cs, Co|      Cp, Co         , Co|      Cu}
,/*01000*/{       Ct      ,    Ct      ,    Ct|   Ce,    Ct      }
,/*11000*/{ Co|Cf|Ct|   Cs, Co|Ct|   Cp, Co|Ct      , Co|Ct|   Cu}
,/*00100*/{ Cm            , Cm         ,          Ce, Cm         }
,/*10100*/{ Co|Cf|      Cs, Co|      Cp, Co         , Co|      Cu}
,/*01100*/{ Cm|   Ct      , Cm|Ct      ,    Ct|   Ce, Cm|Ct      }
,/*11100*/{ Co|Cf|Ct|   Cs, Co|Ct|   Cp, Co|Ct      , Co|Ct|   Cu}
,/*00010*/{          Cq   ,       Cq   ,       Cq|Ce,       Cq   }
,/*10010*/{ Co|Cf|   Cq|Cs, Co|   Cq|Cp, Co|   Cq   , Co|   Cq|Cu}
,/*01010*/{       Ct|Cq   ,    Ct|Cq   ,    Ct|Cq|Ce,    Ct|Cq   }
,/*11010*/{ Co|Cf|Ct|Cq|Cs, Co|Ct|Cq|Cp, Co|Ct|Cq   , Co|Ct|Cq|Cu}
,/*00110*/{ Cm|      Cq   , Cm|   Cq   ,       Cq|Ce, Cm|   Cq   }
,/*10110*/{ Co|Cf|   Cq|Cs, Co|   Cq|Cp, Co|   Cq   , Co|   Cq|Cu}
,/*01110*/{ Cm|   Ct|Cq   , Cm|Ct|Cq   ,    Ct|Cq|Ce, Cm|Ct|Cq   }
,/*11110*/{ Co|Cf|Ct|Cq|Cs, Co|Ct|Cq|Cp, Co|Ct|Cq   , Co|Ct|Cq|Cu}
,/*00001*/{             Cs,          Cp,0           ,          Cu}
,/*10001*/{    Cf|      Cs,          Cp,0           ,          Cu}
,/*01001*/{       Ct|   Cs,    Ct|   Cp,    Ct      ,    Ct|   Cu}
,/*11001*/{    Cf|Ct|   Cs,    Ct|   Cp,    Ct      ,    Ct|   Cu}
,/*00101*/{             Cs,          Cp,0           ,          Cu} /* IO_RG0 */
,/*10101*/{    Cf|      Cs,          Cp,0           ,          Cu}
,/*01101*/{       Ct|   Cs,    Ct|   Cp,    Ct      ,    Ct|   Cu}
,/*11101*/{    Cf|Ct|   Cs,    Ct|   Cp,    Ct      ,    Ct|   Cu}
,/*00011*/{          Cq|Cs,       Cq|Cp,       Cq   ,       Cq|Cu}
,/*10011*/{    Cf|   Cq|Cs,       Cq|Cp,       Cq   ,       Cq|Cu}
,/*01011*/{       Ct|Cq|Cs,    Ct|Cq|Cp,    Ct|Cq   ,    Ct|Cq|Cu}
,/*11011*/{    Cf|Ct|Cq|Cs,    Ct|Cq|Cp,    Ct|Cq   ,    Ct|Cq|Cu}
,/*00111*/{          Cq|Cs,       Cq|Cp,       Cq   ,       Cq|Cu}
,/*10111*/{    Cf|   Cq|Cs,       Cq|Cp,       Cq   ,       Cq|Cu}
,/*01111*/{       Ct|Cq|Cs,    Ct|Cq|Cp,    Ct|Cq   ,    Ct|Cq|Cu}
,/*11111*/{    Cf|Ct|Cq|Cs,    Ct|Cq|Cp,    Ct|Cq   ,    Ct|Cq|Cu}
}/* Reg */;

static u_int32_t
/**********************************************************************
 **                                                                  **/
procomp(pgoblin_main *options, pgoblin_rio *rio, u_int32_t ch) {    /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    u_int32_t price;
    u_int32_t abil;
    int       i;

    ifBLIN_QX3("+ r[%c] %s[%02X]", pgoblin_regn[rio->nio], pgoblin_parmask(0, ch), ch);
    abil = 0;
    if  (rio->path) abil |= PGOBLIN_PATHPARM; /* From */
    if  (rio->text) abil |= PGOBLIN_TEXTPARM;
    if  (rio->mife) abil |= PGOBLIN_MIFEDES;
    if  (rio->pq  ) abil |= PGOBLIN_PQRESULT;
    if  (rio->iod ) abil |= PGOBLIN_OUTSET;
    price = 0;
    for (i = 0; i < 4; i++) { /* To */
        if  (  ((i == 0) && (ch & PGOBLIN_PATHPARM))
            || ((i == 1) && (ch & PGOBLIN_TEXTPARM))
            || ((i == 2) && (ch & PGOBLIN_MIFEDES ))
            || ((i == 3) && (ch & PGOBLIN_PQRESULT))
            ) {
            ifBLIN_QX3("%d abil=%02X %06X", i, abil, score[abil][i]);
            price |= score[abil][i];
    }   }
    ifBLIN_QX3("- abil=%s[%02X] %06X", pgoblin_parmask(0, abil), abil, price);
    return(price);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
propush(pgoblin_exenv *exenv, pgoblin_nr r, u_int32_t ch) {         /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    u_int32_t    price;
    pgoblin_rio *rio;
    int          ex = EX_OK;

    if  (!(rio = pgoblin_meio(exenv->options, r))) {
        ifBLIN_QX4("+ r[%c] ch=%s[%02X]", pgoblin_regn[r], pgoblin_parmask(0, ch), ch);
        goto out;
    }
    ifBLIN_QX4( "+ r[%c] ch=%s[%02X] io=%s[%02X]%s%s%s%s%s"
              , pgoblin_regn[r]
              , pgoblin_parmask(0, ch)
              , ch
              , pgoblin_parmask(1, rio->parmask)
              , rio->parmask
              , rio->iod  ? "o" : ""
              , rio->pq   ? "q" : ""
              , rio->mife ? "m" : ""
              , rio->text ? "t" : ""
              , rio->path ? "f" : ""
              );
    if  (!(ch & PGOBLIN_OUTSET)) {
        ifBLIN_QX0("No output in propush");
        ERROUT(EX_DATAERR, EINVAL);
    } else {
        int e = 0;

        if  ((rio->parmask & PGOBLIN_PATHPARM) && !rio->path) {
            ifBLIN_QX0("rio %u no PATH f=%08X %08X", r, rio->parmask, rio->parmask & PGOBLIN_PATHPARM);
            e++;
        }
        if  ((rio->parmask & PGOBLIN_TEXTPARM) && !rio->text) {
            ifBLIN_QX0("rio %u no TEXT f=%08X %08X", r, rio->parmask, rio->parmask & PGOBLIN_TEXTPARM);
            e++;
        }
        if  ((rio->parmask & PGOBLIN_MIFEDES  ) && !rio->mife) {
            ifBLIN_QX0("rio %u no MIFE f=%08X %08X", r, rio->parmask, rio->parmask & PGOBLIN_MIFEDES);
            e++;
        }
        if  ((rio->parmask & PGOBLIN_PQRESULT) && !rio->pq  ) {
            ifBLIN_QX0("rio %u no PQ   f=%08X %08X", r, rio->parmask, rio->parmask & PGOBLIN_PQRESULT);
            e++;
        }
        if  (!!e) ERROUT(EX_DATAERR, EINVAL);
    }
    price = procomp(exenv->options, rio, ch);
    if  (price & Cx) {
        ifBLIN_QX0("No way @%u f=%08X", exenv->ppoint, rio->parmask);
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (price & Co) {
        int o;

        if  (rio->path) {
            o = open(rio->path, O_WRONLY | O_CREAT | (!!rio->fileover ? O_TRUNC : O_APPEND), 0666);
            if  (o < 0) {
                ifBLIN_QW0("Open=%s~%s", rio->path, !!rio->fileover ? " over" : "");
                ex = EX_IOERR;
                goto out;
            }
        } else {
            ifBLIN_QW1("Open NULL %s", !!rio->fileover ? " over" : "");
            o = -1;
        }
        MARK_IO_OUT_GO(rio);;
        ;;  pgoblin_out0_open(rio, o);
        MARK_IO_OUT_WENT(rio);;
    }
    if  (!ex) {
        cleareg(exenv, r, price);
    } else {
        ex = cleareg(exenv, r, price);
    }
    if  (!ex) exenv->flags |= price;
out:
    ifBLIN_QX4("- %d[%c]", ex, pgoblin_regn[r]);
    return(ex);
#   undef blin_internal_flags
}

/*
 *   IO    . dcore[][]   
 *      .       
 *    ( )     .  
 *      D*. coercion(exenv, rio, ch)  
 * coercomp(options, rio, ch)    ,     
 *     D*.       
 *      rio      ch   
 * ,    . ,   rio  ,
 *   ch,   0     .
 */

#define DC 0x000FU /* price              */
#define Dx 0x8000U /* impossible         */
#define Dq 0x4000U /* read to text       */
#define Do 0x2000U /* open file name     */
#define Dr 0x1000U /* read file          */
#define Dl 0x0800U /* db_0 from text     */
#define Dn 0x0400U /* temp file name     XXXX */
#define Dw 0x0200U /* write file         XXXX */
#define Dm 0x0100U /* do mife from text  */
#define Da 0x0080U /* throw pq to file   XXXX */
#define Db 0x0040U /* throw mife to file XXXX */

static const u_int16_t dcore[4][4] =
      /*              Pf          Pt          Pm          Pq   Reg */
{/* Pf */{             0, Dx|Dn|Dw|7, Dx|Dn|Db|9, Dx|Dn|Da|8}
,/* Pt */{    Do|Dr   |4,          0,    Dr   |3,    Dq   |5}
,/* Pm */{    Do      |1,       Dm|2,          0,    Dq|Dm|6}
,/* Pq */{    Do|Dr|Dl|5,       Dl|1,    Dr|Dl|4,          0}
}/*Wish*/;

static u_int32_t
/**********************************************************************
 **        rio      **
 **    ch                                       **
 **********************************************************************
 **                                                                  **/
coercomp(pgoblin_main *options, pgoblin_rio *rio, u_int32_t ch) {   /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    int       surprise;
    u_int32_t price;
    int       i;
    int       j;

    ifBLIN_QX3( "r[%c]: %s[%02X] -> %s[%02X]"
              , pgoblin_regn[rio->nio]
              , pgoblin_parmask(0, rio->parmask)
              , rio->parmask
              , pgoblin_parmask(1, ch)
              , ch
              );
    price = Dx | 15;
    surprise = 1;
    for (i = 0; i < 4; i++) { /* To */
        if  (  ((i == 0) && (ch & PGOBLIN_PATHPARM))
            || ((i == 1) && (ch & PGOBLIN_TEXTPARM))
            || ((i == 2) && (ch & PGOBLIN_MIFEDES ))
            || ((i == 3) && (ch & PGOBLIN_PQRESULT))
            ) {
            surprise = 0;
            for (j = 0; j < 4; j++) { /* From */
                if  (  (  ((j == 0) && (rio->path))
                       || ((j == 1) && (rio->text))
                       || ((j == 2) && (rio->mife))
                       || ((j == 3) && (rio->pq  ))
                       )
                    && (dcore[i][j] & DC) < (price & DC)
                    ) {
                    price = dcore[i][j];
                    ifBLIN_QX3("i=%d j=%d %04X", i, j, dcore[i][j]);
    }   }   }   }
    return(!!surprise ? 0 : price);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **     rio     ch   **
 **********************************************************************
 **                                                                  **/
coercion(pgoblin_exenv *exenv, pgoblin_nr r, u_int32_t ch) {        /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    u_int32_t    price;
    pgoblin_rio *rio;
    int          ex = EX_OK;

    if  (!(rio = pgoblin_meio(exenv->options, r))) {
        ifBLIN_QX4("+ ruo %u ch=%02X", r, ch);
        goto out;
    }
    ifBLIN_QX4( "+ ch=%02X io=%08X%s%s%s%s"
              , ch
              , rio->parmask
              , rio->path ? " path" : ""
              , rio->text ? " text" : ""
              , rio->mife ? " mife" : ""
              , rio->pq   ? " pq"   : ""
              );
    if  (ch & PGOBLIN_OUTSET) {
        ifBLIN_QX0("Output in coercion");
        ERROUT(EX_DATAERR, EINVAL);
    } else if (  ((rio->parmask & PGOBLIN_PATHPARM) && !rio->path)
              || ((rio->parmask & PGOBLIN_TEXTPARM) && !rio->text)
              || ((rio->parmask & PGOBLIN_MIFEDES ) && !rio->mife)
              || ((rio->parmask & PGOBLIN_PQRESULT) && !rio->pq  )
              ) {
        ifBLIN_QX0( "No info for IO=%c f=%08X%s%s%s%s"
                  , pgoblin_regn[r]
                  , rio->parmask
                  , (rio->parmask & PGOBLIN_PATHPARM) ? " path" : ""
                  , (rio->parmask & PGOBLIN_TEXTPARM) ? " text" : ""
                  , (rio->parmask & PGOBLIN_MIFEDES ) ? " mife" : ""
                  , (rio->parmask & PGOBLIN_PQRESULT) ? " pq" : ""
                  );
        ERROUT(EX_DATAERR, EINVAL);
    }
    price = coercomp(exenv->options, rio, ch);
    ifBLIN_QX4( "price %08X<%s%s%s%s%s%s%s%s%s%s%u%s>"
              , price
              , (price & Dx) ? "Dx" : ""
              , (price & Dq) ? "Dq" : ""
              , (price & Do) ? "Do" : ""
              , (price & Dr) ? "Dr" : ""
              , (price & Dl) ? "Dl" : ""
              , (price & Dn) ? "Dn" : ""
              , (price & Dw) ? "Dw" : ""
              , (price & Dm) ? "Dm" : ""
              , (price & Da) ? "Da" : ""
              , (price & Db) ? "Db" : ""
              , price & DC
              , (price & ~(Dx | Dq | Do | Dr | Dl | Dn | Dw | Dm | Da | Db | DC)) ? "?" : ""
              );
    if  (price & Dx) {
        ifBLIN_QX0("No way @%u f=%08X", exenv->ppoint, rio->parmask);
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (price & Dq) {
        if  (0 > (ex = (int)pgoblin_st0_tbl(exenv, r, 0, -2))) {
            ifBLIN_QW0("coercion: No STYLE 0");
            goto out;
        }
        ex = EX_OK;
    }
    if  (price & Do) {
        MARK_IO_MIFE_GO(rio);;
        ;;  rio->mpid = 0;
        ;;  rio->mife = mife_init(PGOBLIN_MIFEFLAGS);
        ;;  rio->freemife = 1;
        ;;  if  (!rio->mife || (0 > mife_ctlfile(rio->mife, rio->path))) {
        ;;      rio->parmask &= ~PGOBLIN_MIFEDES;
        ;;      rio->freemife = 0;
        ;;      ifBLIN_QW0("coercion mife open %s", rio->path);
        ;;      ex = EX_IOERR;
        ;;      goto out;
        ;;  }
        MARK_IO_MIFE_WENT(rio);;
    }
    if  (price & Dr) {
        ssize_t l;
        void *t;

        if  ((l = pgoblin_io_read(rio, (ssize_t)0, (off_t)0)) < 0) {
            ifBLIN_QX0("pgoblin_io_read");
            ex = EX_IOERR;
            goto out;
        }
        if  (!(t = mife_pointer(rio->mife))) {
            ifBLIN_QX0("mife_pointer");
            ex = EX_IOERR;
            goto out;
        }
        MARK_IO_TEXT_GO(rio);;
        ;;  rio->length = (size_t)l;
        ;;  rio->text = t;
        ;;  rio->binparm = 1;
        ;;  rio->freetext = 0;
        MARK_IO_TEXT_WENT(rio);;
    }
    if  (price & Dl) {
        MARK_IO_TEXT_GO(rio);;
        ;;  rio->freetext = 0;
        MARK_IO_TEXT_WENT(rio);;
        MARK_IO_PQ_GO(rio);;
        ;;  pgoblin_db0_create(exenv, rio, 1, (const char *const *)&(rio->text), NULL);
        ;;  rio->freepqre = 1;
        ;;  rio->cortege = -1;
        MARK_IO_PQ_WENT(rio);;
    }
    if  (price & Dn) {/* XXXX */}
    if  (price & Dw) {/* XXXX */}
    if  (price & Dm) {
        mife_descriptor *m;
        int tmpi;

        if  (!rio->text) {
            m = NULL;
            tmpi = 0;
        } else {
            if  (!(m = mife_init(PGOBLIN_MIFEFLAGS /* | MIFE_STRI */))) {
                ifBLIN_QX0("mife_init");
                ex = EX_IOERR;
                goto out;
            }
            if  (!!rio->freetext || !!rio->binparm) {
                tmpi = mife_ctlbuff(m, rio->text, rio->length);
            } else {
                tmpi = mife_ctlcnst(m, rio->text, rio->length);
        }   }
        if  (0 > tmpi) {
            ifBLIN_QX0("mife_ctl");
            ex = EX_IOERR;
            goto out;
        }
        MARK_IO_MIFE_GO(rio);;
        ;;  rio->mife = m;
        ;;  rio->mpid = 0;
        ;;  rio->freemife = 1;
        MARK_IO_MIFE_WENT(rio);;
    }
    if  (price & Da) {/* XXXX */}
    if  (price & Db) {/* XXXX */}
out:
    ifBLIN_QX4("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
waitjob(pgoblin_main *options, pgoblin_nr r) {                      /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    int            status;
    pgoblin_rjb   *rjb;
    struct kevent  kev;
    int            exx = EX_OK;
    int            ex  = EX_OK;
    pgoblin_jobl  *j;
    u_int          i;

    if  (!(rjb = pgoblin_mejob(options, r))) {
        ifBLIN_QX0("No JOB reg %u", r);
        ex = EX_SOFTWARE;
        goto out;
    }
#   undef blin_internal_flags
#   define blin_internal_flags (rjb->flags & BLIN_MASK)
    bzero(&kev, sizeof(kev));
    if  (!(rjb->flags & PGOBLIN_KQUEUED) && ((rjb->kq = kqueue()) < 0)) {
        ex = EX_OSERR;
        goto out;
    }
    MARK_R_JOB_GO(rjb);;
    ;;  rjb->flags |= PGOBLIN_KQUEUED;
    MARK_R_JOB_WENT(rjb);;
try:
    for (i = 0; !ex && (i < MULAR_NEXT(rjb->pids)); i++) {
        j = mular_getix(rjb->pids, i);
        if  (j->pid <= 0) {
            ifBLIN_QX1("#%u cmdn=%"BLIN_D" **pid=%d** status=%08X", i, j->cmdn, j->pid, j->status);
        } else if (j->cmdn < 0) {
            ifBLIN_QX1("#%u **cmdn=%"BLIN_D"** pid=%d status=%08X", i, j->cmdn, j->pid, j->status);
        } else if (j->status == PGOBLIN_NOSTATUS) {
            EV_SET(&kev, j->pid, EVFILT_PROC, EV_ADD | EV_ONESHOT | EV_CLEAR, NOTE_EXIT, 0, NULL);
            if  (0 > kevent(rjb->kq, &kev, 1, NULL, 0, NULL)) {
                ifBLIN_QW0("No pid %d for kevent ADD", (int)j->pid);
                ex = EX_SOFTWARE;
            } else if (0 > (ex = waitpid(j->pid, &status, WNOHANG))) {
                if  (errno == ECHILD) {
                    ifBLIN_QX1("Lost pid %d in %d", j->pid, (int)j->cmdn);
                    MARK_R_JOB_GO(rjb);;
                    ;;  j->status = PGOBLIN_LOSTSTAT;
                    ;;  rjb->dead++;
                    MARK_R_JOB_WENT(rjb);;
                    errno = 0;
                    ex = 0;
                } else {
                    ifBLIN_QW0("Pid %d in %d", j->pid, (int)j->cmdn);
                }
            } else if (0 < ex) {
                if  (ex == j->pid) {
                    EV_SET(&kev, j->pid, EVFILT_PROC, EV_DELETE, NOTE_EXIT, 0, NULL);
                    if  (0 > kevent(rjb->kq, &kev, 1, NULL, 0, NULL)) {
                        ifBLIN_QW1("No pid %d for kevent DELETE", (int)j->pid);
                    }
                    MARK_R_JOB_GO(rjb);;
                    ;;  j->status = status;
                    ;;  rjb->dead++;
                    MARK_R_JOB_WENT(rjb);;
                    ifBLIN_QX3( " st=%08X fl=%08X ex=%d exx=%d IFEX=%d EXST=%d EXSIG=%d SIGST=%d"
                              , j->status
                              , rjb->flags
                              , ex
                              , exx
                              , WIFEXITED(j->status)
                              , WEXITSTATUS(j->status)
                              , WIFSIGNALED(j->status)
                              , WTERMSIG(j->status)
                              );
                    ex = 0;
                    if  (rjb->flags & PGOBLIN_ERROR_SENSOR) {
                        if  (  WIFEXITED(status)
                            && WEXITSTATUS(status)
                            && !exx
                            ) {
                            exx = WEXITSTATUS(status);
                        } else if (WIFSIGNALED(j->status) && !exx) {
                            exx = WTERMSIG(j->status) + 256;
                    }   }
                    if  ((rjb->flags & PGOBLIN_ERROR_SENSIB) && exx) break;
                } else {
                    ifBLIN_QX0("Pid %d<>%d at %d", ex, j->pid, (int)j->cmdn);
    }   }   }   }
    if  (!ex && rjb->concur && (MULAR_NEXT(rjb->pids) >= (rjb->concur + rjb->dead))) {
        kevent(rjb->kq, NULL, 0, &kev, 1, NULL);
        goto try;
    }
out:
    return(ex ? ex : exx);
#   undef blin_internal_flags
}

static int
/*************************************************************************
 **                                                                     **/
pgoblin_inx(pgoblin_exenv *exenv, pgoblin_nr nio, int p[2], int c) {   /**
 **                                                                     **
 *************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rio *rio;
    int          ex = EX_OK; /* Errors must be < 0 */

    GET_RIO(rio, exenv->options, nio);
    if  (c) close(p[1]);
    MARK_IO_MIFE_GO(rio);;
    ;;  if  (  !(rio->mife = mife_init(PGOBLIN_MIFEFLAGS))
            || (0 > mife_ctlfdsc(rio->mife, p[0]))
            ) {
    ;;      ifBLIN_QW0("mife_init inx");
    ;;      ex = -EX_NOINPUT;
    ;;  } else {
    ;;      rio->parmask |= PGOBLIN_MIFEDES;
    ;;      rio->freemife = 1;
    ;;  }
    ;;  rio->mpid = 0;
    MARK_IO_MIFE_WENT(rio);;
out:
    return(ex);
#   undef blin_internal_flags
}

static int
/**************************************************************************
 **                                                                      **/
pgoblin_outx(pgoblin_exenv *exenv, pgoblin_nr nio, int p[2], int c) {   /**
 **                                                                      **
 **************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rio *rio;
    int          ex = EX_OK; /* Errors must be < 0 */

    GET_RIO(rio, exenv->options, nio);
    if  (c) close(p[0]);
    MARK_IO_OUT_GO(rio);;
    ;;  pgoblin_out0_open(rio, p[1]);
    MARK_IO_OUT_WENT(rio);;
out:
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_pipe(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = EX_OK;
    int pipa[2];

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3("+pipe %c.%c...", pgoblin_regn[rn[PGO_COUT]], pgoblin_regn[rn[PGO_CIN]]);
    if  (pipe(pipa) < 0) {
        ifBLIN_QW0("pipe in pipe");
        close(pipa[0]);
        close(pipa[1]);
        ex = EX_OSERR;
    }
    pgoblin_upio(exenv, rn[PGO_CIN]);
    pgoblin_upio(exenv, rn[PGO_COUT]);
    if  (!(ex = pgoblin_inx(exenv, rn[PGO_CIN], pipa, 0))) {
        ex = pgoblin_outx(exenv, rn[PGO_COUT], pipa, 0);
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

#define CICLEWARN(N, A) {                                                                            \
    int CICLEWARN_INTERNAL = N;                                                                      \
    ifBLIN_QX1( "%s:%u cmd[%u]=[%03X(%s %c%c%c%c%c%c)].fl=%08X %s ch=%02X " A                        \
              , finam                                                                                \
              , lfcount                                                                              \
              , exenv->ppoint                                                                        \
              , cmd                                                                                  \
              , a_cmd->str                                                                           \
              , pgoblin_regn[rn[0]]                                                                  \
              , pgoblin_regn[rn[1]]                                                                  \
              , pgoblin_regn[rn[2]]                                                                  \
              , pgoblin_regn[rn[3]]                                                                  \
              , pgoblin_regn[rn[4]]                                                                  \
              , pgoblin_regn[rn[5]]                                                                  \
              , a_cmd->flags                                                                         \
              , pgoblin.p[CICLEWARN_INTERNAL].name                                                   \
              , ch[CICLEWARN_INTERNAL]                                                               \
              );                                                                                     \
    continue;                                                                                        \
}

#define CICLEERR(A) do {                                                                             \
    ifBLIN_QW0( "%s:%u cmd[%u]=%03X(%s %c%c%c%c%c%c) %08X %02X %02X %02X %02X %02X %02X " A          \
              , finam                                                                                \
              , lfcount                                                                              \
              , exenv->ppoint                                                                        \
              , cmd                                                                                  \
              , a_cmd->str                                                                           \
              , pgoblin_regn[rn[0]]                                                                  \
              , pgoblin_regn[rn[1]]                                                                  \
              , pgoblin_regn[rn[2]]                                                                  \
              , pgoblin_regn[rn[3]]                                                                  \
              , pgoblin_regn[rn[4]]                                                                  \
              , pgoblin_regn[rn[5]]                                                                  \
              , a_cmd->flags                                                                         \
              , ch[0]                                                                                \
              , ch[1]                                                                                \
              , ch[2]                                                                                \
              , ch[3]                                                                                \
              , ch[4]                                                                                \
              , ch[5]                                                                                \
              );                                                                                     \
} while(0)

#define DUMPIOREGS do {                                                                              \
    for (pgoblin_nr DUMPIOREGS_I = 0; DUMPIOREGS_I < pgoblin.regsize; DUMPIOREGS_I++) {              \
        if  (  (DUMPIOREGS_I == rn[PGO_COUT])                                                        \
            || (DUMPIOREGS_I == rn[PGO_CCTL])                                                        \
            || (DUMPIOREGS_I == rn[PGO_CIN])                                                         \
            ) {                                                                                      \
            dump_ioreg(options, DUMPIOREGS_I);                                                       \
}   }   } while(0)

int
/***********************************************
 ***********************************************
 **                                           **/
pgoblin_execute( pgoblin_main  *options      /**/
/**/           , pgoblin_prog  *pgm          /**/
/**/           , pgoblin_exenv *dexenv       /**/
/**/           , pgoblin_exenv *sexenv       /**/
/**/           , ssize_t        pp           /**/
/**/           ) {                           /**
 **                                           **
 ***********************************************
 ***********************************************/
    u_int32_t      lfcount = 0;
    pgoblin_exenv *exenv   = NULL;
    const char    *finam   = "";
    int            ex      = EX_OK;
    u_int32_t      ch      [pgoblin.symparam];
    pgoblin_nr     rn      [pgoblin.symparam];
    u_int32_t      m       ;
    union {
        pgoblin_rio *io;                     /* io                                                   */
        pgoblin_rdb *c;                      /* conn                                                 */
        pgoblin_rjb *j;                      /* job                                                  */
        pgoblin_rst *s;                      /* style                                                */
        void        *v;
    } rset[pgoblin.symparam];

#   define blin_internal_flags (options->flags & BLIN_MASK)
    ifBLIN_QX2("+ pgm@%"BLIN_D, MULAR_NEXT(pgm->code));
    if  (!pgm || !!strncmp(pgm->id, "#pGoblin-" VERS, PGOBLIN_STRING_ID_TST)) {
        ifBLIN_QX0("Illegal pgoblin program %s", pgm->id);
        ERROUT(EX_DATAERR, EPROGMISMATCH);
    }
    if  (!(exenv = calloc(1, sizeof(pgoblin_exenv)))) {
        ifBLIN_QW0("no mem");
        ex = EX_OSERR;
        goto out;
    }
    exenv->flags = options->flags & BLIN_MASK;
    if  (!!dexenv) dexenv->next = exenv;
    exenv->dyna = dexenv;
    exenv->stat = sexenv;
    exenv->pgm = pgm;
    exenv->options = options;
    for (exenv->ppoint = (u_int32_t)pp; !(exenv->flags & PGOBLIN_END); exenv->ppoint++) {
        u_int32_t                      jobflags;
        int                            lexlevel;
        pgoblin_tuple                 *command;
        int                            pqjump = 0;
        const struct pgoblin_syntax_a *a_cmd;
        int                            ntyp;
        pgoblin_command                cmd;
        char                          *lit;
        u_int32_t                      t;

    ;   exenv->flags &= PGOBLIN_EXTABLE;
    ;   if  (ex) {
            /*    ,    #trap */
            int            trapdone;
            pgoblin_exenv *ev;

    ;       trapdone = 0;
    ;       for (ev = exenv; ev; ev = ev->stat) {
    ;           if  (ev->flags & PGOBLIN_TRAPDEF) {
    ;               ifBLIN_QX1("%s:%u Trap from %u to %u", finam, lfcount, exenv->ppoint, ev->ctrap);
    ;               ex = pgoblin_execute(options, ev->pgm, exenv, ev->stat, (ssize_t)ev->ctrap);
    ;               if  (!!ex) {
    ;                   ifBLIN_QX1("%s:%u Fail in trap PC %u", finam, lfcount, exenv->ppoint);
    ;                   exenv->flags |= PGOBLIN_END | PGOBLIN_ERROR;
    ;               }
    ;               trapdone++;
    ;               break;
    ;       }   }
    ;       if  (!trapdone) {
    ;           if  (ex < 256) {
    ;               ifBLIN_QX0("%s:%u Fail PC %u", finam, lfcount, exenv->ppoint);
    ;           } else if ((ex < 384) && !!sigids[ex - 256]) {
    ;               ifBLIN_QX0( "%s:%u Fail PC %u: signal SIG%s"
                              , finam
                              , lfcount
                              , exenv->ppoint
                              , sigids[ex - 256]
                              );
    ;           } else {
    ;               ifBLIN_QX0( "%s:%u Fail PC %u: unkhown reason %d"
                              , finam
                              , lfcount
                              , exenv->ppoint
                              , ex
                              );
    ;           }
    ;           exenv->flags |= PGOBLIN_END | PGOBLIN_ERROR;
    ;   }   }
    ;   if  (((size_t)exenv->ppoint < MULAR_NEXT(exenv->pgm->code)) && !(exenv->flags & PGOBLIN_END)) {
    ;       if  (!(command = mular_getix(exenv->pgm->code, exenv->ppoint))) {
    ;           ifBLIN_QW0("%s:%u mular_getix %u", finam, lfcount, exenv->ppoint);
    ;           ex = EX_SOFTWARE;
    ;           goto out;
    ;       }
    ;       lfcount = command->linum;
    ;       t = command->cmd;
    ;       if  ((cmd = t & PGOBLIN_COMMAND) == PGOBLIN_extended) {
    ;           cmd = (command->ecmd & PGOBLIN_COMMAND) | PGOBLIN_EXTENDED;
    ;           lit = NULL;
    ;       } else {
    ;           lit = command->lit;
    ;       }
    ;       if  (cmd >= pgoblin.max || !(~pgoblin.a[cmd].flags & PGOBLIN_ILLEGAL)) {
    ;           ex = EX_DATAERR;
    ;           ifBLIN_QX0("%s:%u cmd[%u]=%03X unknown", finam, lfcount, exenv->ppoint, cmd);
    ;           continue;
    ;       } else if (!pgoblin.a[cmd].flags) {
    ;           continue;
    ;       } else if (!pgoblin.a[cmd].car) {
    ;           ex = EX_DATAERR;
    ;           ifBLIN_QX1( "%s:%u cmd[%u]=%03X(%s) Undefined"
                          , finam
                          , lfcount
                          , exenv->ppoint
                          , cmd
                          , pgoblin.a[cmd].str
                          );
    ;           continue;
    ;       }
    ;       a_cmd = &(pgoblin.a[cmd]);
    ;       if  (!!exenv->lexlevel) {
    ;           if  (a_cmd->flags & PGOBLIN_LEXLVUP) exenv->lexlevel++;
    ;           if  (a_cmd->flags & PGOBLIN_LEXLDOWN) exenv->lexlevel--;
    ;           continue;
    ;       }
    ;       if  (PGOBLIN_ROLLBACK & exenv->flags) continue;
    ;   } else {
    ;       t = 0;
    ;       lfcount = 0;
    ;       lit = NULL;
    ;       cmd = PGOBLIN_return;
    ;       a_cmd = &(pgoblin.a[cmd]);
    ;       exenv->flags |= PGOBLIN_END;
    ;   }
    ;   ifBLIN_QO2 {
            pgoblin_exenv *c;
            int32_t        d;
            int32_t        s;

    ;       for (s = 0, c = exenv; c; c = c->stat) s++;
    ;       for (d = 0, c = exenv; c; c = c->dyna) d++;
    ;       ifBLIN_QX2( "#### %s:%u (%ds %dd) N%u e%06X f%08X c%03X %s%s%s%s"
                      , finam
                      , lfcount
                      , s
                      , d
                      , exenv->ppoint
                      , exenv->flags
                      , a_cmd->flags
                      , cmd
                      , pgoblin.a[cmd].str
                      , (!lit) ? "" : "="
                      , (!lit) ? "" : lit
                      , (!lit) ? "" : "~"
                      );
    ;   }
    ;   for (pgoblin_nr r = 0; r < pgoblin.symparam; r++) {
            int   b;

    ;       if  (0 > (b = pgoblin_breg(cmd, r))) {
    ;           ch[r] = 0;
    ;           rn[r] = 0;
    ;           if  ((a_cmd->flags & pgoblin.p[r].val) || (r == PGO_CJOB)) {
    ;               switch(r) {
    ;               case PGO_CSTY: rset[r].s = pgoblin_upsty(exenv, 0); break;
    ;               case PGO_CJOB: rset[r].j = pgoblin_upjob(exenv, 0); break;
    ;               case PGO_CCON: rset[r].c = pgoblin_upcon(exenv, 0); break;
    ;               default:       rset[r].io = pgoblin_upio(exenv, 0); break;
    ;               }
    ;           } else {
    ;               rset[r].v = NULL;
    ;           }
    ;       } else {
    ;           ch[r] = a_cmd->ch[b];
    ;           rn[r] = (t >> pgoblin.binparams[b]) & PGOBLIN_ARGMASK;
    ;           switch(r) {
    ;           case PGO_CSTY:
    ;               rset[r].s = pgoblin_upsty(exenv, rn[r]);
    ;               break;
    ;           case PGO_CJOB:
    ;               rset[r].j = pgoblin_upjob(exenv, !(ch[r] & PGOBLIN_JOB) ? 0 : rn[r]);
    ;               break;
    ;           case PGO_CCON:
    ;               rset[r].c = pgoblin_upcon(exenv, rn[r]);
    ;               break;
    ;           default:
    ;               rset[r].io = pgoblin_upio(exenv, rn[r]);
    ;               break;
    ;   }   }   }
    ;   ifBLIN_QX2("Registers:");
    ;   ifBLIN_QO2 for (pgoblin_nr r = 0; r < pgoblin.symparam; r++) {
            const char *fico = "# 012345678";
            const char *sco  = &fico[2];
            int         b;

    ;       b = pgoblin_breg(cmd, r);
    ;       ifBLIN_QX2( "%s%c%s%d[%c] %s %"BLIN_X" ch=%s%s%s%s%s%s%s%s[%02X] %08X%s%s=%s%s"
                      , (0 > b) ? "   " : ""
                      , sco[b]
                      , (0 > b) ? "" : "->"
                      , r
                      , pgoblin_regn[rn[r]]
                      , pgoblin.p[r].name
                      , BLIN_I((rset[r].v))
                      , (ch[r] & PGOBLIN_STYLE   ) ? "s" : ""
                      , (ch[r] & PGOBLIN_JOB     ) ? "j" : ""
                      , (ch[r] & PGOBLIN_CONNECT ) ? "c" : ""
                      , (ch[r] & PGOBLIN_OUTSET  ) ? "o" : ""
                      , (ch[r] & PGOBLIN_PQRESULT) ? "q" : ""
                      , (ch[r] & PGOBLIN_MIFEDES ) ? "m" : ""
                      , (ch[r] & PGOBLIN_TEXTPARM) ? "t" : ""
                      , (ch[r] & PGOBLIN_PATHPARM) ? "f" : ""
                      , ch[r]
                      , ( (!!rset[r].v)
                        ? (   (PGO_CSTY == r)
                          ? rset[r].s->flags
                          : ( (PGO_CJOB == r)
                            ? rset[r].j->flags
                            : ( (PGO_CCON == r)
                              ? rset[r].c->flags
                              : rset[r].io->flags
                          ) ) )
                        : 0
                        )
                      , ( (!!rset[r].v)
                        ? ( (PGO_CSTY == r)
                          ? ((!STYLS(rset[r].s->flags)) ? "" : "+")
                          : ( (PGO_CJOB == r)
                            ? ((!JOBE(rset[r] .j->flags)) ? "" : "+")
                            : ( (PGO_CCON == r)
                              ? ((!DBASE(rset[r].c->flags)) ? "" : "+")
                              : ( (PGO_COUT == r)
                                ? ((!SLOUT(rset[r].io->type)) ? "" : "+")
                                : ""
                          ) ) ) )
                        : ""
                        )
                      , ( (!!rset[r].v)
                        ? ( ( (PGO_CSTY == r)
                            ? ((!STYLS(rset[r].s->flags)) ? "-" : STYLS(rset[r].s->flags)->name)
                            : ( (PGO_CJOB == r)
                              ? ((!JOBE(rset[r] .j->flags)) ? "-" : JOBE(rset[r] .j->flags)->name)
                              : ( (PGO_CCON == r)
                                ? ((!DBASE(rset[r].c->flags)) ? "-" : DBASE(rset[r].c->flags)->name)
                                : ( (PGO_COUT == r)
                                  ? ( (!SLOUT(rset[r].io->type))
                                    ? "-"
                                    : SLOUT(rset[r].io->type)->name
                                    )
                                  : ""
                          ) ) ) ) )
                        : ""
                        )
                      , ( (!!rset[r].v)
                        ? ( (PGO_CJOB == r)
                          ? ((!rset[r].j->host  ) ? "" : rset[r].j->host)
                          : ( (PGO_CCON == r)
                            ? ((!rset[r].c->dbname) ? "" : rset[r].c->dbname)
                            : ""
                          ) )
                        : ""
                        )
                      , ( (!!rset[r].v)
                        ? ( (PGO_CJOB == r)
                          ? ((!rset[r].j->host  ) ? "" : "~")
                          : ( (PGO_CCON == r)
                            ? ((!rset[r].c->dbname) ? "" : "~")
                            : ""
                          ) )
                        : ""
                      ) );
    ;       switch(r) {
            case PGO_CSTY:
    ;       case PGO_CJOB:
    ;       case PGO_CCON:
    ;           break;
    ;       default:
    ;           dump_ioreg(options, rn[r]);
    ;   }   }
    ;   pgoblin_toexe(cmd, exenv, rn);
    ;   ifBLIN_QO3 {
    ;       ifBLIN_QX3("exenv->flags=%08X", exenv->flags);
    ;       DUMPIOREGS;
    ;   }
    ;   /**************************
    ;    *   OUT *
    ;    **************************/
    ;   ifBLIN_QX5("OUT %c", (a_cmd->flags & PGOBLIN_OUTSET) ? '+' : '-');
    ;   if  (a_cmd->flags & PGOBLIN_OUTSET) {
    ;       if  (!(ch[PGO_COUT] & PGOBLIN_OUTSET)) {
    ;           if  (!!RNOUT) {
    ;               if  ((ex = cleareg(exenv, RNOUT, PGOBLIN_PATHPARM | PGOBLIN_OUTSET))) {
    ;                   CICLEWARN(0, "Not clear path|wri OUT");
    ;           }   }
    ;       } else if ((ex = propush(exenv, RNOUT, ch[PGO_COUT]))) {
    ;           CICLEWARN(0, "No propush");
    ;       } else if ((RNOUT == RNCTL) || (RNOUT == RNIN)) {
    ;               /* copy XXXX */
    ;       }
    ;       if  (a_cmd->flags & PGOBLIN_PURGE) IO_OUT->purge = 1;
    ;   }
    ;   /**************************
    ;    *   CTL *
    ;    **************************/
    ;   ifBLIN_QX5("CTL %c", (a_cmd->flags & PGOBLIN_CTL) ? '+' : '-');
    ;   if  (a_cmd->flags & PGOBLIN_CTL) {
    ;       if  (ch[PGO_CCTL] & PGOBLIN_OUTSET) {
    ;           ex = EX_SOFTWARE;
    ;           CICLEWARN(1, "CTL&out");
    ;       } else if (!!RNCTL) {
    ;           if  (  (RNCTL == RNOUT)
                    && ( ch[PGO_CCTL]
                       & ch[PGO_COUT]
                       & (PGOBLIN_PATHPARM | PGOBLIN_TEXTPARM | PGOBLIN_PQRESULT)
                    )  ) {
    ;               ifBLIN_QX1( "%s:%u cmd[%u]=[%03X(%s)]    "
                              , finam
                              , lfcount
                              , exenv->ppoint
                              , cmd
                              , a_cmd->str
                              );
    ;           }
    ;           if  (!(IO_CTL->parmask & PGOBLIN_ANYIVL)) {
    ;               if  (RNCTL != RNIN) exenv->flags |= PGOBLIN_FORKCTL;
    ;           } else if (!!(ex = coercion(exenv, RNCTL, ch[PGO_CCTL]))) {
    ;               CICLEWARN(1, "No coercion CTL");
    ;           }
    ;       } else if ((ch[PGO_CCTL] & PGOBLIN_TEXTPARM)) {
    ;           if  ((ex = cleareg(exenv, RNCTL, PGOBLIN_TEXTPARM))) {
    ;               CICLEWARN(1, "Not ready text CTL");
    ;           }
    ;           if  (!lit) {
    ;               MARK_IO_TEXT_GO(IO_CTL);;
    ;               ;;  IO_CTL->text = NULL;
    ;               ;;  IO_CTL->length = 0;
    ;               ;;  IO_CTL->parmask &= ~PGOBLIN_TEXTPARM;
    ;               ;;  IO_CTL->binparm = 0;
    ;               ;;  IO_CTL->freetext = 0;
    ;               MARK_IO_TEXT_WENT(IO_CTL);;
    ;           } else if (!(pgm->flags & PGOBLIN_FREETEXT)) {
    ;               MARK_IO_TEXT_GO(IO_CTL);;
    ;               ;;  IO_CTL->text = lit;
    ;               ;;  IO_CTL->length = strlen(lit);
    ;               ;;  IO_CTL->binparm = 0;
    ;               ;;  IO_CTL->freetext = 0;
    ;               MARK_IO_TEXT_WENT(IO_CTL);;
    ;           } else {
    ;               MARK_IO_TEXT_GO(IO_CTL);;
    ;               ;;  IO_CTL->text = strdup(lit);
    ;               ;;  IO_CTL->length = strlen(lit);
    ;               ;;  IO_CTL->binparm = 0;
    ;               ;;  IO_CTL->freetext = 1;
    ;               MARK_IO_TEXT_WENT(IO_CTL);;
    ;           }
    ;       } else if ((ch[PGO_CCTL] & PGOBLIN_PQRESULT)) {
                const char **cell;
                u_int c;
    ;
    ;           if  ((ex = cleareg(exenv, RNCTL, PGOBLIN_PQRESULT))) {
    ;               CICLEWARN(1, "Not ready pq CTL");
    ;           }
    ;           for (u_int j = 0; ; j++) {
    ;               c = j;
    ;               if  ((size_t)(exenv->ppoint + (u_int)c) >= MULAR_NEXT(exenv->pgm->code)) break;
    ;               if  (!(command = mular_getix(exenv->pgm->code, exenv->ppoint + (u_int)c))) {
    ;                   ifBLIN_QW0("%s:%u mular_getix %u", finam, lfcount, exenv->ppoint);
    ;                   ex = EX_SOFTWARE;
    ;                   goto out;
    ;               }
    ;               if  (!!c && (command->cmd != PGOBLIN_cont)) break;
    ;               if  (!command->lit) break;
    ;           }
    ;           if  (c) {
    ;               if  (!(cell = malloc(c * sizeof(char**)))) {
    ;                   CICLEWARN(1, "No mem for Pq");
    ;               }
    ;               for (u_int j = 0; j < c; j++) {
    ;                   if  (!(command = mular_getix(exenv->pgm->code, exenv->ppoint + j))) {
    ;                       ifBLIN_QW0("%s:%u mular_getix %u", finam, lfcount, exenv->ppoint);
    ;                       ex = EX_SOFTWARE;
    ;                       goto out;
    ;                   }
    ;                   cell[j] = command->lit;
    ;               }
    ;               MARK_IO_PQ_GO(IO_CTL);;
    ;               ;;  pgoblin_db0_create(exenv, IO_CTL, c, cell, NULL);
    ;               ;;  IO_CTL->freepqre = 1;
    ;               ;;  IO_CTL->cortege = -1;
    ;               MARK_IO_PQ_WENT(IO_CTL);;
    ;               free(cell);
    ;           }
    ;           pqjump = (int)pgoblin_db_resinfo(IO_CTL, PGOBLIN_Nfields) - 1;
    ;       } else if (!!(ex = (int)coercomp(options, IO_CTL, ch[PGO_CCTL]))) {
    ;           CICLEWARN(1, "Not compatible CTL");
    ;   }   }
    ;   /**************************
    ;    *    IN *
    ;    **************************/
    ;   ifBLIN_QX5("IN %c", (a_cmd->flags & PGOBLIN_ISIN) ? '+' : '-');
    ;   if  (a_cmd->flags & PGOBLIN_ISIN) {
    ;       if  (ch[PGO_CIN] & PGOBLIN_OUTSET) {
    ;           if  (!!RNIN) {
                    if  ((ex = cleareg(exenv, RNIN, PGOBLIN_PATHPARM | PGOBLIN_MIFEDES))) {
    ;                   CICLEWARN(2, "Not clear path|mife IN");
    ;           }   }
    ;       } else if (!!RNIN) {
    ;           if  (  (RNIN == RNOUT)
                    && ( ch[PGO_CIN]
                       & ch[PGO_COUT]
                       & (PGOBLIN_PATHPARM | PGOBLIN_TEXTPARM | PGOBLIN_PQRESULT)
                    )  ) {
    ;               ifBLIN_QX1( "%s:%u cmd[%u]=[%03X(%s)]    "
                              , finam
                              , lfcount
                              , exenv->ppoint
                              , cmd
                              , a_cmd->str
                              );
    ;           }
    ;           if  (!(IO_IN->parmask & PGOBLIN_ANYIVL)) {
    ;               exenv->flags |= PGOBLIN_FORKIN;
    ;           } else if (!!(ex = coercion(exenv, RNIN, ch[PGO_CIN]))) {
    ;               CICLEWARN(2, "No coercion IN");
    ;           }
    ;       } else if (!!(ex = (int)coercomp(options, IO_IN, ch[PGO_CIN] & ~PGOBLIN_PQRESULT))) {
    ;           CICLEWARN(2, "Not compatible IN");
    ;   }   }
    ;   /***************************
    ;    *   CONN *
    ;    ***************************/
    ;   ifBLIN_QX5("CONN %c", (a_cmd->flags & PGOBLIN_CONNECT) ? '+' : '-');
    ;   if  (a_cmd->flags & PGOBLIN_CONNECT) {
    ;       if  (ch[PGO_CCON] & PGOBLIN_OUTSET) {
    ;           if  (RNCON) {
    ;               pgoblin_db_finish(R_CONN);
    ;               MARK_R_CONN_GO(R_CONN);;
    ;               ;;  if  (R_CONN->flags & PGOBLIN_PARMFREE) free((char*)R_CONN->dbname);
    ;               ;;  R_CONN->conn = NULL;
    ;               ;;  R_CONN->flags = (options->flags & BLIN_MASK)
                /*  ;;  */            | (pgoblin_mecon(options, 0)->flags & PGOBLIN_DB_TYPE)
    ;               ;;  ;
    ;               ;;  R_CONN->dbname = NULL;
    ;               ;;  R_CONN->host = NULL;
    ;               ;;  R_CONN->port = NULL;
    ;               ;;  R_CONN->username = NULL;
    ;               ;;  R_CONN->intran = 0;
    ;               MARK_R_CONN_WENT(R_CONN);;
    ;           }
    ;       } else {
    ;           MARK_R_CONN_GO(R_CONN);;
    ;           ;;  R_CONN->flags = (options->flags & BLIN_MASK) | (R_CONN->flags & ~BLIN_MASK);
    ;           MARK_R_CONN_WENT(R_CONN);;
    ;           if  ((ex = pgoblin_db_shurecon(R_CONN))) {
    ;               CICLEWARN(3, "Not connected");
    ;   }   }   }
    ;   /**************************
    ;    *   JOB *
    ;    **************************/
    ;   ifBLIN_QX5("JOB %c", (a_cmd->flags & PGOBLIN_JOB) ? '+' : '-');
    ;   if  (a_cmd->flags & PGOBLIN_JOB) {
    ;       if  (ch[PGO_CJOB] & PGOBLIN_OUTSET) {
    ;           if  (!!RNJOB) {
    ;               ex = JOBE(R_JOB->flags)->jose(exenv, rn);
    ;               MARK_R_JOB_GO(R_JOB);;
    ;               ;;  mular_destroy(R_JOB->pids);
    ;               ;;  R_JOB->pids = NULL;
    ;               ;;  R_JOB->host = NULL;
    ;               ;;  R_JOB->concur = 0;
    ;               ;;  R_JOB->dead = 0;
    ;               ;;  if  (R_JOB->flags & PGOBLIN_KQUEUED) close(R_JOB->kq);
    ;               ;;  R_JOB->flags = options->flags & BLIN_MASK;
    ;               MARK_R_JOB_WENT(R_JOB);;
    ;               if  (ex) {
    ;                   CICLEERR("Close JOB");
    ;                   continue;
    ;           }   }
    ;       } else if (  !(R_JOB->pids)
                      && !(R_JOB->pids = mular_create(MULAR_ZERO, 3, sizeof(pgoblin_jobl), u12))
                      ) {
    ;           ex = EX_SOFTWARE;
    ;           CICLEERR("No JOB");
    ;           continue;
    ;   }   }
    ;   /****************************
    ;    *   STYLE *
    ;    ****************************/
    ;   ifBLIN_QX5("STYLE %c", (a_cmd->flags & PGOBLIN_STYLE) ? '+' : '-');
    ;   if  (a_cmd->flags & PGOBLIN_STYLE) {
    ;       if  (ch[PGO_CSTY] & PGOBLIN_OUTSET) {
    ;           if  (!!RNSTY) {
    ;               MARK_R_STYLE_GO(R_STYLE);;
    ;               ;;  if  (R_STYLE->style) pgoblin_st_clear(R_STYLE);
    ;               ;;  R_STYLE->style = NULL;
    ;               ;;  R_STYLE->flags = options->flags & BLIN_MASK;
    ;               MARK_R_STYLE_WENT(R_STYLE);;
    ;   }   }   }
    ;   /******************************
    ;    *     *
    ;    ******************************/
    ;   ifBLIN_QX5("FORKIN %c", (exenv->flags & PGOBLIN_FORKIN) ? '+' : '-');
    ;   if  (exenv->flags & PGOBLIN_FORKIN) {
    ;       ifBLIN_QX2("FORKIN")
    ;       if  (!!(ex = pipe(options->pip2))) {
    ;           CICLEERR("pipe #2");
    ;           close(options->pip2[0]);
    ;           close(options->pip2[1]);
    ;           continue;
    ;   }   }
    ;   ifBLIN_QX5("FORKCTL %c", (exenv->flags & PGOBLIN_FORKCTL) ? '+' : '-');
    ;   if  (exenv->flags & PGOBLIN_FORKCTL) {
    ;       ifBLIN_QX2("FORKCTL")
    ;       if  (!!(ex = pipe(options->pip1))) {
    ;           CICLEERR("pipe #1");
    ;           close(options->pip1[0]);
    ;           close(options->pip1[1]);
    ;           continue;
    ;   }   }
    ;   ifBLIN_QX5("FORKOUT %c", (exenv->flags & PGOBLIN_FORKOUT) ? '+' : '-');
    ;   if  (exenv->flags & PGOBLIN_FORKOUT) {
    ;       ifBLIN_QX2("FORKOUT")
    ;       if  (!!(ex = pipe(options->pip0))) {
    ;           CICLEERR("pipe #0");
    ;           close(options->pip0[0]);
    ;           close(options->pip0[1]);
    ;           continue;
    ;   }   }
    ;   ifBLIN_QO3 {
    ;       ifBLIN_QX3("exenv->flags=%08X", exenv->flags);
    ;       DUMPIOREGS;
    ;   }
    ;   /*******************************
    ;    *     *
    ;    *******************************/
    ;   ntyp = 1;
    ;   jobflags = PGOBLIN_TOEXIT;
    ;   lexlevel = exenv->lexlevel;
    ;   if  (a_cmd->flags & PGOBLIN_FORKED) {
    ;       jobflags = PGOBLIN_TOFORK;
    ;       if  (cmd == PGOBLIN_exec)jobflags |= PGOBLIN_TOEXIT;
    ;       if  (!!RNCTL) {
    ;           ntyp = (int)pgoblin_db_resinfo(IO_CTL, PGOBLIN_Ntuples);
    ;   }   }
    ;   if  (exenv->flags & (PGOBLIN_FORKIN | PGOBLIN_FORKCTL | PGOBLIN_FORKOUT)) {
    ;       jobflags |= PGOBLIN_TOFORK;
    ;   }
    ;   for (int sequen = 0; (sequen < ntyp) && !ex; sequen++) {
    ;       if  (!(jobflags & (PGOBLIN_TVFORK | PGOBLIN_TOFORK))) {
    ;           ifBLIN_QX2( "e%06X DO x %d(%d) c%03X %s"
                          , exenv->flags, ntyp, sequen, cmd, a_cmd->str
                          );
    ;           ex = pgoblin_cmdexe(cmd, exenv, rn);
    ;           ifBLIN_QX3("DONE %d", ex);
    ;       } else {
    ;       ;   ifBLIN_QX2( "e%06X FORK x %d(%d) c%03X %s"
                          , exenv->flags, ntyp, sequen, cmd, a_cmd->str
                          );
    ;       ;   if  (R_JOB->concur && (MULAR_NEXT(R_JOB->pids) >= (R_JOB->concur + R_JOB->dead))) {
    ;       ;       if  ((ex = waitjob(exenv->options, RNJOB))) {
    ;       ;           CICLEERR("waitjob");
    ;       ;           continue;
    ;       ;   }   }
    ;       ;   /*  if  ((ex = ((jobflags & PGOBLIN_TOFORK) ? fork() : vfork())) < 0) { */
    ;       ;   if  (!(pgoblin.a[cmd].flags & PGOBLIN_JOB)) {
    ;       ;       CICLEWARN(2, "fork without Ij");
    ;       ;   }
    ;       ;   if  ((ex = fork()) < 0) {
    ;       ;       CICLEERR("fork #1");
    ;       ;       continue;
    ;       ;   } else if (ex == 0) {
    ;       ;       ifBLIN_QX3("FORK CHILD");
    ;       ;       /*********************************
    ;       ;        * ,    *
    ;       ;   ;    *********************************/
    ;       ;   ;   for (pgoblin_nr r = 0; r < pgoblin.regsize; r++) {
                        pgoblin_rdb *con;

    ;       ;   ;       if  (!!(con = pgoblin_mecon(options, r))) con->flags &= ~PGOBLIN_CLOSECONN;
    ;       ;   ;   }
    ;       ;   ;   if  ((cmd == PGOBLIN_fork) && (!pgoblin_pushjob(exenv, RNJOB))) {
    ;       ;   ;       ifBLIN_QW0("pgoblin_pushjob %u", RNJOB);
    ;       ;   ;       break;
    ;       ;   ;   }
    ;       ;   ;   if  (!!(pgoblin.a[cmd].flags & PGOBLIN_CTLCORTG)) {
    ;       ;   ;       MARK_IO_PQ_GO(IO_CTL);;
    ;       ;   ;       ;;  IO_CTL->cortege = sequen;
    ;       ;   ;       MARK_IO_PQ_WENT(IO_CTL);;
    ;       ;   ;   }
    ;       ;   ;   exenv->flags |= PGOBLIN_FORKED | PGOBLIN_CHILD;
    ;       ;   ;   if  (exenv->flags & PGOBLIN_FORKCTL) {
    ;       ;   ;       ifBLIN_QX0("%s:%u fork with CTL", finam, lfcount);
    ;       ;   ;       ex = -EX_SOFTWARE;
    ;       ;   ;       exit(ex);
    ;       ;   ;   }
    ;       ;   ;   if  (exenv->flags & PGOBLIN_FORKIN) {
    ;       ;   ;       if  ((ex = pgoblin_inx(exenv, rn[PGO_CIN], options->pip2, 1))) exit(ex);
    ;       ;   ;   }
    ;       ;   ;   if  (exenv->flags & PGOBLIN_FORKCTL) {
    ;       ;   ;       if  ((ex = pgoblin_inx(exenv, rn[PGO_CCTL], options->pip1, 1))) exit(ex);
    ;       ;   ;   }
    ;       ;   ;   if  (exenv->flags & PGOBLIN_FORKOUT) {
    ;       ;   ;       if  ((ex = pgoblin_outx(exenv, rn[PGO_COUT], options->pip0, 1))) exit(ex);
    ;       ;   ;   }
    ;       ;   ;   if  (exenv->options->flags & PGOBLIN_FORK_WAIT) {
    ;       ;   ;       ifBLIN_QX2( "sleep %us in fork"
                                  , exenv->options->flags & PGOBLIN_FORK_WAIT
                                  );
    ;       ;   ;       sleep(exenv->options->flags & PGOBLIN_FORK_WAIT);
    ;       ;   ;   }
    ;       ;   ;   ex = pgoblin_cmdexe(cmd, exenv, rn);
    ;       ;       ifBLIN_QX3("CHILD DONE %d %d", ex, getpid());
    ;       ;       if  (cmd == PGOBLIN_fork) lexlevel = exenv->lexlevel;
    ;       ;       if  (jobflags & PGOBLIN_TOEXIT) exit(ex);
    ;       ;       break;
    ;       ;   } else {
                    pgoblin_jobl *j;
    ;       ;       ifBLIN_QX3("FORK DONE %d", ex);
    ;       ;       MARK_R_JOB_GO(R_JOB);;
    ;       ;       ;;  j = mular_add(R_JOB->pids);
    ;       ;       ;;  j->cmdn = (ssize_t)exenv->ppoint;
    ;       ;       ;;  j->pid = ex;
    ;       ;       ;;  j->status = PGOBLIN_NOSTATUS;
    ;       ;       MARK_R_JOB_WENT(R_JOB);;
    ;       ;       if  (cmd == PGOBLIN_fork) lexlevel = exenv->lexlevel + 1;
    ;       ;       ex = 0;
    ;   }   }   }
    ;   if  (cmd == PGOBLIN_fork) exenv->lexlevel = lexlevel + ((!ntyp) ? 1 : 0);
    ;   if  (!(exenv->flags & PGOBLIN_CHILD)) {
    ;       if  (exenv->flags & PGOBLIN_FORKIN) {
    ;           if  ((ex = pgoblin_outx(exenv, rn[PGO_CIN], options->pip2, 1))) continue;
    ;       }
    ;       if  (exenv->flags & PGOBLIN_FORKCTL) {
    ;           if  ((ex = pgoblin_outx(exenv, rn[PGO_CCTL], options->pip1, 1))) continue;
    ;       }
    ;       if  (exenv->flags & PGOBLIN_FORKOUT) {
    ;           close(options->pip0[1]);
    ;           MARK_IO_MIFE_GO(IO_OUT);;
    ;           ;;  if  (  !(IO_OUT->mife = mife_init(PGOBLIN_MIFEFLAGS))) {
    ;           ;;      ex = EX_NOINPUT;
    ;           ;;      CICLEERR("mife_init");
    ;           ;;  } else if (0 > mife_ctlfdsc(IO_OUT->mife, options->pip0[0])) {
    ;           ;;      mife_fini(IO_OUT->mife);
    ;           ;;      ex = EX_NOINPUT;
    ;           ;;      CICLEERR("mife_ctlfdsc");
    ;           ;;  } else {
    ;           ;;      IO_OUT->mpid = 0;
    ;           ;;      IO_OUT->parmask |= PGOBLIN_MIFEDES;
    ;           ;;      IO_OUT->freemife = 1;
    ;           ;;  }
    ;           MARK_IO_MIFE_WENT(IO_OUT);;
    ;   }   }
    ;   if  (!!ex) continue;
    ;   /*****************************
    ;    *  IO_OUT  *
    ;    *****************************/
    ;   ifBLIN_QX5("out %c", (a_cmd->flags & PGOBLIN_OUTSET) ? '+' : '-');
    ;   if  (a_cmd->flags & PGOBLIN_OUTSET) {
    ;       ifBLIN_QO3 {
    ;   ;       ifBLIN_QX3("exenv->flags %08X", exenv->flags);
    ;   ;       dump_ioreg(options, rn[PGO_COUT]);
    ;   ;       if  (!ch[PGO_COUT] && !rn[PGO_COUT]) dump_ioreg(options, 0);
    ;   ;   }
    ;   ;   if  (exenv->flags & PGOBLIN_FREEPATH) {
                off_t off;
                mife_descriptor *md;
                char *cont;
                ssize_t bl;

    ;   ;       if  (!(IO_OUT->path)) {
    ;   ;           CICLEWARN(0, "unload no path");
    ;   ;       }
    ;   ;       md = mife_init(((PGOBLIN_RAWIOBUFL << 8) & MIFE_BUFL) | MIFE_BUFX);
    ;   ;       if  (!md || (0 > mife_ctlfile(md, IO_OUT->path))) {
    ;   ;           ex = EX_IOERR;
    ;   ;           CICLEERR("unload mife init");
    ;   ;           continue;
    ;   ;       }
    ;   ;       for (off = 0; !(md->flags & MIFE_EOFL); off += bl) {
    ;   ;           bl = mife_read(md, (ssize_t)(1 << (PGOBLIN_RAWIOBUFL + 16)), off);
    ;   ;           if  (bl < 0) {
    ;   ;               ifBLIN_QW0("%s:%u unload mife read %s:", finam, lfcount, IO_OUT->path);
    ;   ;               ex = EX_IOERR;
    ;   ;               break;
    ;   ;           }
    ;   ;           if  (!(cont = mife_get(md, off))) {
    ;   ;               ifBLIN_QW0("%s:%u unload mife get %s:", finam, lfcount, IO_OUT->path);
    ;   ;               ex = EX_IOERR;
    ;   ;               break;
    ;   ;           }
    ;   ;           if  (pgoblin_io_write(IO_OUT, cont, (size_t)bl) < 0) {
    ;   ;               ifBLIN_QW0("%s:%u unload mife write", finam, lfcount);
    ;   ;               ex = EX_IOERR;
    ;   ;               break;
    ;   ;       }   }
    ;   ;       if  (ex) continue;
    ;   ;       if  (mife_fini(md)) {
    ;   ;           ex = EX_IOERR;
    ;   ;           CICLEERR("unload close");
    ;   ;           continue;
    ;   ;       }
    ;   ;       ex = cleareg(exenv, RNOUT, PGOBLIN_PATHPARM);
    ;   ;       if  (ex) CICLEWARN(0, "IO_OUT->path not cleared");
    ;   ;   }
    ;   ;   if  (exenv->flags & PGOBLIN_FREETEXT) {
    ;   ;       if  (!(IO_OUT->text)) {
    ;   ;           CICLEWARN(0, "unload no text");
    ;   ;       }
    ;   ;       ex = (int)pgoblin_io_write(IO_OUT, IO_OUT->text, IO_OUT->length);
    ;   ;       if  (ex < 0) {
    ;   ;           ex = EX_IOERR;
    ;   ;           CICLEERR("unload text write");
    ;   ;           continue;
    ;   ;       }
    ;   ;       ex = cleareg(exenv, RNOUT, PGOBLIN_TEXTPARM);
    ;   ;       if  (ex) CICLEWARN(0, "IO_OUT->text not cleared");
    ;   ;   }
    ;   ;   if  (exenv->flags & PGOBLIN_FREEPQRE) {
    ;   ;       if  (!IO_OUT->purge) {
    ;   ;           if  (!(IO_OUT->pq)) {
    ;   ;               CICLEWARN(0, "unload no pq");
    ;   ;           }
    ;   ;           ex = (int)pgoblin_st0_tbl(exenv, rn[PGO_COUT], 0, -2);
    ;   ;           if  (ex < 0) {
    ;   ;               ex = EX_IOERR;
    ;   ;               CICLEERR("unload pq");
    ;   ;               continue;
    ;   ;       }   }
    ;   ;       ex = cleareg(exenv, RNOUT, PGOBLIN_PQRESULT);
    ;   ;       if  (ex) CICLEWARN(0, "IO_OUT->pq not cleared");
    ;   ;   }
    ;   ;   if  (!RNOUT) {
    ;   ;       if  (IO_OUT->path && !(IO_OUT->parmask & PGOBLIN_PATHPARM)) {
    ;   ;           ex = cleareg(exenv, RNOUT, PGOBLIN_PATHPARM);
    ;   ;           if  (ex) CICLEWARN(0, "0 IO_OUT->path not cleared");
    ;   ;       }
    ;   ;       if  (IO_OUT->text && !(IO_OUT->parmask & PGOBLIN_TEXTPARM)) {
    ;   ;           ex = cleareg(exenv, RNOUT, PGOBLIN_TEXTPARM);
    ;   ;           if  (ex) CICLEWARN(0, "0 IO_OUT->text not cleared");
    ;   ;       }
    ;   ;       if  (IO_OUT->pq && !(IO_OUT->parmask & PGOBLIN_PQRESULT)) {
    ;   ;           ex = cleareg(exenv, RNOUT, PGOBLIN_PQRESULT);
    ;   ;           if  (ex) CICLEWARN(0, "0 IO_OUT->pq not cleared");
    ;   ;       }
    ;   ;       if  (IO_OUT->mife && !(IO_OUT->parmask & PGOBLIN_MIFEDES)) {
    ;   ;           ifBLIN_QX0("%s:%u Clear mife in io[0]", finam, lfcount);
    ;   ;           ex = cleareg(exenv, RNOUT, PGOBLIN_MIFEDES);
    ;   ;           if  (ex) CICLEWARN(0, "0 IO_OUT->mife not cleared");
    ;   ;       }
    ;   ;       if  (IO_OUT->iod && !(IO_OUT->parmask & PGOBLIN_OUTSET)) {
    ;   ;           ifBLIN_QX0("%s:%u Clear wri in io[0]", finam, lfcount);
    ;   ;           ex = cleareg(exenv, RNOUT, PGOBLIN_OUTSET);
    ;   ;           if  (ex) CICLEWARN(0, "0 IO_OUT not cleared");
    ;   ;   }   }
    ;   ;   ifBLIN_QO3 {
    ;   ;       dump_ioreg(options, rn[PGO_COUT]);
    ;           if  (!ch[PGO_COUT] && !rn[PGO_COUT]) dump_ioreg(options, 0);
    ;   }   }
    ;   if  ((a_cmd->flags & PGOBLIN_CTL) && !RNCTL && (ch[PGO_CCTL] & PGOBLIN_TEXTPARM)) {
    ;       ex = cleareg(exenv, RNCTL, PGOBLIN_TEXTPARM);
    ;       if  (ex) CICLEWARN(0, "0 IO_CTL->text not cleared");
    ;   }
    ;   if  (pqjump > 0) exenv->ppoint += (u_int)pqjump;
    ;   ifBLIN_QO0 iorassert(exenv, cmd, lfcount, finam);
    ;   if  (PGOBLIN_end == cmd) {
    ;       exenv->flags &= ~PGOBLIN_ROLLBACK;
    }   }
    if  (!ex && (exenv->flags & PGOBLIN_ERROR)) ex = -1;
    if  (!!dexenv) {
        dexenv->next = NULL;
    } else if (options->flags & PGOBLIN_CLEAR_ONEXIT) {
        for (pgoblin_nr r = 0; r < pgoblin.regsize; r++) {
            pgoblin_rdb *rdb;
            pgoblin_rjb *rjb;
            pgoblin_rst *rst;

            m = PGOBLIN_PATHPARM | PGOBLIN_TEXTPARM | PGOBLIN_PQRESULT;
            if  (r) m |= PGOBLIN_OUTSET | PGOBLIN_MIFEDES;
            cleareg(exenv, r, m);
            if  (  !!(rdb = pgoblin_mecon(exenv->options, r))
                && !!DBASE(rdb->flags)
                && (rdb->flags & PGOBLIN_CLOSECONN)
                ) {
                MARK_R_CONN_GO(rdb);;
                ;;  pgoblin_db_finish(rdb);
                ;;  rdb->conn = NULL;
                ;;  rdb->flags &= options->flags & BLIN_MASK;
                ;;  rdb->intran = 0;
                MARK_R_CONN_WENT(rdb);;
            }
            if  (!!(rjb = pgoblin_mejob(exenv->options, r)) && !!JOBE(rjb->flags)) {
                MARK_R_JOB_GO(rjb);;
                ;;  mular_destroy(rjb->pids);
                ;;  rjb->pids = NULL;
                ;;  if  (rjb->flags & PGOBLIN_HOSTJFREE) free(rjb->host);
                ;;  rjb->host = NULL;
                ;;  rjb->concur = 0;
                ;;  rjb->dead = 0;
                ;;  rjb->flags = options->flags & BLIN_MASK;
                MARK_R_JOB_WENT(rjb);;
            }
            if  (!!(rst = pgoblin_mesty(exenv->options, r)) && !!STYLS(rst->flags)) {
                MARK_R_STYLE_GO(rst);;
                ;;  pgoblin_st_clear(rst);
                ;;  rst->style = NULL;
                ;;  rst->flags &= ~PGOBLIN_STYLE_TYPE;
                MARK_R_STYLE_WENT(rst);;
    }   }   }
out:
    if  (exenv) free(exenv);
    ifBLIN_QX2("- %d", ex);
    return(ex);
#   undef blin_internal_flags
};
