/*-
 * Copyright (C)2007..2025 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2007..2025 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: descript.c,v 1.123 2025/01/25 00:12:13 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define PGOBLIN_COMPAT   5
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"
#include "cmds.h"
#include "sqlkeywords.h"

#define Pf PGOBLIN_PATHPARM
#define Pt PGOBLIN_TEXTPARM
#define Pm PGOBLIN_MIFEDES
#define Pq PGOBLIN_PQRESULT
#define Po PGOBLIN_OUTSET
#define Ps PGOBLIN_STYLE
#define Pj PGOBLIN_JOB
#define Pc PGOBLIN_CONNECT

#define Fx PGOBLIN_ILLEGAL
#define Fi PGOBLIN_IGNORE
#define Fl PGOBLIN_NOLITER
#define Ff PGOBLIN_FORKED
#define Fe PGOBLIN_EXTENDED
#define Fu PGOBLIN_LEXLVUP
#define Fd PGOBLIN_LEXLDOWN
#define Fc PGOBLIN_CTLCORTG
#define Fq PGOBLIN_PURGE
#define Io PGOBLIN_OUTSET
#define Id PGOBLIN_CTL
#define Ii PGOBLIN_ISIN
#define Ic PGOBLIN_CONNECT
#define Ij PGOBLIN_JOB
#define Is PGOBLIN_STYLE

static pgoblin_ios *outable[PGOBLIN_OUTABLESZ] =
{NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL
,NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL
};
static pgoblin_ios *iotable[PGOBLIN_IOTABLESZ] =
{NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL
,NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL
};
static pgoblin_ios *intable[PGOBLIN_INTABLESZ] =
{NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL
,NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL
};
static pgoblin_dbases *dbasetable[PGOBLIN_DBTABLESZ] =
{NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL
,NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL
};
static pgoblin_styles *styletable[PGOBLIN_STYLETBSZ] =
{NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL
,NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL
};
static pgoblin_jobs *jobtable[PGOBLIN_JOBTABSIZ] =
{NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL
,NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL
};

const char * const pgoblin_syntaxa_flags[] =
{ "ISIN"    ,     NULL, "CTL"   ,     NULL, "OUTSET" ,  "CONNECT", "JOB"    , "STYLE"
, "EXTENDED",     NULL,     NULL, "FORKED",      NULL,       NULL,      NULL, "TMP"
,       NULL,     NULL,     NULL,     NULL, "LEXLVUP", "LEXLDOWN", "NOLITER", "IGNORE"
, "BIT0"    , "BIT1"  , "BIT2"  , "BIT3"  , "BIT4"   , "BIT5"    , "BIT6"   , "BIT7"
};

const pgoblin_syntax pgoblin =
{ PGOBLIN_OUTABLESZ                                            // outablesz
, PGOBLIN_IOTABLESZ                                            // iotablesz
, PGOBLIN_INTABLESZ                                            // intablesz
, PGOBLIN_DBTABLESZ                                            // dbtablesz
, PGOBLIN_JOBTABSIZ                                            // jobtabsiz
, PGOBLIN_STYLETBSZ                                            // styletbsz
, PGOBLIN_SYMREGS                                              // symparam
, PGOBLIN_BINREGS                                              // binparam
, PGOBLIN_REGSIZE                                              // regsize
, 0
, PGOBLIN_max                                                  // max
, 0
#if BLINAP > 4
, 0
#endif
, outable                                                      // outable
, iotable                                                      // iotable
, intable                                                      // intable
, dbasetable                                                   // dbasetable
, jobtable                                                     // jobtable
, styletable                                                   // styletable
, &cmds                                                        // cmds
, &sqlkeywords                                                 // sqlkeywords
, {PGOBLIN_ARG1S, PGOBLIN_ARG2S, PGOBLIN_ARG3S, PGOBLIN_ARG4S} // binparams
#if BLINAP > 4
, 0
#endif
, { { PGOBLIN_OUTSET
    , PGOBLIN_ANYIVL
    , 0
    , 0
#if BLINAP > 4
    , 0
#endif
    , "out"
    }                                                          // Po,F  p[0].sym .val .bin .mask .name
  , { PGOBLIN_CTL
    , PGOBLIN_ANYIVL
    , 1
    , 0
#if BLINAP > 4
    , 0
#endif
    , "ctl"
    }                                                          // Id,F  p[1]
  , { PGOBLIN_ISIN
    , PGOBLIN_ANYIVL
    , 3
    , 0
#if BLINAP > 4
    , 0
#endif
    , "in "
    }                                                          // Ii,F  p[2]
  , { PGOBLIN_CONNECT
    , PGOBLIN_CONNECT
    , 2
    , 0
#if BLINAP > 4
    , 0
#endif
    , "db "
    }                                                          // Ic,Ic p[3]
  , { PGOBLIN_JOB
    , PGOBLIN_JOB
    , 2
    , 0
#if BLINAP > 4
    , 0
#endif
    , "job"
    }                                                          // Ij,Ij p[4]
  , { PGOBLIN_STYLE
    , PGOBLIN_STYLE
    , ~12
    , 3
#if BLINAP > 4
    , 0
#endif
    , "sty"
    }                                                          // Is,Is p[5]
  }                                                            // p
/*
 *  a[].flags       I.odicjs,    .
 *  a[].ch[PGOBLIN_BINREGS]     ,
 *   P.ftmq   I.odi, cjs    .
 *  a[].ch[] o ,      .
 *   ,     ,  
 *    ( #clear   #close).
 *   a[].flags  ,     a[].ch[] ,
 *     0 ,    ,
 *   ,  #getjob,      Pc,
 *    0 Pc.      a[].flags  
 *  a[].ch[]  ,    ,   ,  
 *  0 ,  #strselect,     I.odcs (P.mtcs)
 *  0 Pc (5 ,     ).
 */
, { { Fe                      , {    0,     0,     0,    0}, NULL           , ""         } /* 000 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , {                        0, {    0,     0,     0,    0}, NULL /* cont */, ""         } /* 002 */
//     
//a
// Pq
//a
// 
//a
// CTL
//a
// ,     
//a
// Pq
//a .
//      , .
//     .
  , { Fi                      , {    0,     0,     0,    0}, NULL           , "!"        } /* 003 */
//       
//e
// #!/usr/local/bin/pgoblin
//e
//      .
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , {       Id|      Is|0x3000, {    0,    Pt,     0,   Ps}, pgoblin_pusho  , "pusho"    } /* 008 */
//   
//a
// IO
//a
// ,         
//       ,     .
// 
//a
// STY
//a
// 0,     
//a
// CTL
//a
// ,       
//a
// CTL
//a
//   
//a
// STY
//a
// .         
//  ()   .
  , {       Id|      Is|0x3000, {    0,    Pt,     0,   Ps}, pgoblin_pushc  , "pushc"    } /* 009 */
//   
//a
// CONN
//a
// ,         
//       ,     .
// 
//a
// STY
//a
// 0,     
//a
// CTL
//a
// ,       
//a
// CTL
//a
//   
//a
// STY
//a
// .         
//  ()   .
  , {       Id|      Is|0x3000, {    0,    Pt,     0,   Ps}, pgoblin_pushj  , "pushj"    } /* 00A */
//   
//a
// JOB
//a
// ,         
//       ,     .
// 
//a
// STY
//a
// 0,     
//a
// CTL
//a
// ,       
//a
// CTL
//a
//   
//a
// STY
//a
// .         
//  ()   .
  , {       Id|      Is|0x3000, {    0,    Pt,     0,   Ps}, pgoblin_pushs  , "pushs"    } /* 00B */
//   
//a
// STY
//a
// ,         
//       ,     .
// 
//a
// STY
//a
// 0,     
//a
// CTL
//a
// ,       
//a
// CTL
//a
//   
//a
// STY
//a
// .         
//  ()   .
  , {       Id|      Is|0x3000, {    0,    Pt,     0,   Ps}, pgoblin_popo   , "popo"     } /* 00C */
//   
//a
// IO
//a
// ,         
//       ,     .
// 
//a
// STY
//a
// 0,     
//a
// CTL
//a
// ,       
//a
// CTL
//a
//   
//a
// STY
//a
// .         
//     (  ).
  , {       Id|      Is|0x3000, {    0,    Pt,     0,   Ps}, pgoblin_popc   , "popc"     } /* 00D */
//   
//a
// CONN
//a
// ,         
//       ,     .
// 
//a
// STY
//a
// 0,     
//a
// CTL
//a
// ,       
//a
// CTL
//a
//   
//a
// STY
//a
// .         
//     (  ).
  , {       Id|      Is|0x3000, {    0,    Pt,     0,   Ps}, pgoblin_popj   , "popj"     } /* 00E */
//   
//a
// JOB
//a
// ,         
//       ,     .
// 
//a
// STY
//a
// 0,     
//a
// CTL
//a
// ,       
//a
// CTL
//a
//   
//a
// STY
//a
// .         
//     (  ).
  , {       Id|      Is|0x3000, {    0,    Pt,     0,   Ps}, pgoblin_pops   , "pops"     } /* 00F */
//   
//a
// STY
//a
// ,         
//       ,     .
// 
//a
// STY
//a
// 0,     
//a
// CTL
//a
// ,       
//a
// CTL
//a
//   
//a
// STY
//a
// .         
//     (  ).

  , {       Id|   Ic          , {    0,    Pt, Po|Pc,    0}, pgoblin_connect, "connect"  } /* 010 */
//  ,  
//a
// CTL
//a
//   ,  
//a
// CON
//a
// .
//a
// CTL
//a
//     ,  
//      .
//         ,
//      ,    ..
  , {    Io|Id|Ii|Ic          , {Po|Pq,    Pt,    Pc,   Pt}, pgoblin_listen , "listen"   } /* 011 */
//  notify  ,  
//a
// CTL
//a
// .    ,    
//a
// IN
//a
// . 
//a
// NOTIFY
//a
//  
//a
// Po
//a
// ,    0.

// !      
//   64     
//   UNIX .   
//  :
//e
// #binpresel
// SELECT (( date_part('epoch', DateTimeWaitTo)
//         + date_part('second', DateTimeWaitTo)
//         - floor(date_part('second', DateTimeWaitTo))
//         ) * 1000000
//        )::int8
//e
// !    
//a
// Pq
//a
// ,      .    
//    .
  , { Ff|Io|Id|Ii|   Ij|    Fc, {Po|Pm,    Pq,    Pj,   Pm}, pgoblin_exec   , "exec"     } /* 012 */
//    
//a
// JOB
//a
// ,   
//a
// CTL
//a
// ,      
//a
// Pq
//a
// 
//a
// CTL
//a
// .
//a
// stdin
//a
// 
//a
// stdout
//a
//     
//a
// IN
//a
// 
//a
// OUT
//a
// .
//         
//a
// JOB
//a
// .
// ,       ,
//   - . NULL      
//      / ,    .
  , { Fu                      , {    0,     0,     0,    0}, pgoblin_trap   , "trap"     } /* 013 */
//  ,    ,
//    .
//     ,    
//     (
//a
// #return
//a
// 
//a
// #exit
//a
// )  ,   .
  , { Fx                      , {    0,     0,     0,    0}, pgoblin_call   , "call"     } /* 014 */
  , {       Id|Ii             , {    0,    Pt,     0,   Pq}, pgoblin_eval   , "eval"     } /* 015 */
//a
// CTL
//a
//    
//a
// pgoblin
//a
// .
//          ,
//    
//a
// #trap
//a
// .  
//a
// #trap
//a
//    ,
//        
//a
// #trap
//a
//   .  
//a
// #trap
//a
//  ,  
//          .
// 
//a
// IN
//a
// 
//a
// 0
//a
// , 
//a
// CTL
//a
//     
//a
// IN
//a
// ,    
//      . 
//  ,   
//a
// IN
//a
// , 
//a
// CTL
//a
//    .
  , {    Io|Id|Ii|   Is|0x2000, {Po|Pm,    Pt,    Ps,   Pt}, pgoblin_style  , "style"    } /* 016 */
//   
//a
// STY
//a
//  ,  
//a
// CTL
//a
// ,
//   ,   
//a
// IN
//a
// .
// 
//a
// 0
//a
//  
//a
// STY
//a
//   ,  
//      .
// 
//a
// CTL
//a
//     .
  , {       Id|      Ij       , {    0,    Pt,    Pj,    0}, pgoblin_job    , "job"      } /* 017 */
//   ,  
//a
// CTL
//a
// ,   
//a
// JOB
//a
// .
//a
// CTL
//a
//     ,  
//     ,      ,
//       
//  .    
//a
// JOB
//a
//   
//   ,     
//         .
//   :
//u
// -z        1
// -Z      
//u
//   3  
//u
// 0 -      
// 1 -  #wait      ,       
// 2 -         
//u
//     0.
  , {    Io|Id|      Is|0x3000, {Po|Pt,    Pt,     0,   Ps}, pgoblin_echo   , "echo"     } /* 018 */
//   STY 0,   OUT    CTL,  
//a
// OUT
//a
//    
//a
// STY
//a
// ,    
//a
// CTL
//a
// .
  , {    Io|Id|      Is|0x3000, {Po|Pf,    Pt,     0,   Ps}, pgoblin_file   , "file"     } /* 019 */
//  
//a
// STY 0
//a
// ,  
//a
// OUT
//a
//  ,    
//a
// CTL
//a
// ,  ,       
//a
// STY
//a
// ,    
//a
// CTL
//a
// .
//           
//  ,       .
//          ,
//      ,    .
//     ,     .
  , {    Io|Id|      Is|0x3000, {Po|Pf,    Pt,     0,   Ps}, pgoblin_cat    , "cat"      } /* 01A */
//  
//a
// STY 0
//a
// ,  
//a
// OUT
//a
//  ,    
//a
// CTL
//a
// ,  ,       
//a
// STY
//a
// ,    
//a
// CTL
//a
// .
//           
//  ,       .
//          ,
//        ,    .
//     ,     .
  , {    Fd|Id|   Ic          , {    0,    Pt, Po|Pc,    0}, pgoblin_exit   , "exit"     } /* 01B */
//   .
//         .
//       ,
//    .    ,
//      
//a
// #return
//a
// .   
//a
// 0
//a
//  
//a
// CON
//a
// ,       ,    ,
//      ,      
//     .
// 
//a
// CTL
//a
//  ,         -  .
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL} /* 01C */
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}

  , { Fq|Io|Id|Ii|Ic          , {Po|Pq, Pt|Pq,    Pc,   Pq}, pgoblin_perform, "perform"  } /* 020 */
//  , 
//a
// CONN
//a
// ,  , 
//a
// CTL
//a
// .
//     .   
//a
// IN
//a
// ,  
//a
// Pq
//a
//   ,    
//  .   
//a
// CONN
//a
// .
//   
//a
// CTL
//a
// 
//a
// Pt
//a
// ,   
//a
//  CON
//a
//   ,    
//a
// Pq
//a
// ,     
//a
//  CTL Pq
//a
//    ,  0   .
//      ,
//      .  
//a
// OUT
//a
//  0,   ,      .
  , {    Io|Id|   Ic          , {Po|Pq, Pt|Pq,    Pc,    0}, pgoblin_binpre , "binpresel"} /* 021 */
//  
//a
// CTL
//a
//    
//a
// OUT.
  , {    Io|Id|Ii|Ic          , {Po|Pq, Pt|Pq,    Pc,   Pq}, pgoblin_select , "select"   } /* 022 */
//       
//a
// OUT
//a
// .   
//a
// IN
//a
// ,    
//a
// IN Pq
//a
//  
//    .   
//a
// CONN
//a
// .
  , {    Io|Id|Ij|Ic|Is|0x3000, {Po|Pm,    Pt,    Pc,   Ps}, pgoblin_binsel , "binselect"} /* 023 */
//  
//a
// CTL
//a
//     
//a
// OUT
//a
//   STY.
  , {    Io|Id|Ij|Ic|Is|0x3000, {Po|Pm,    Pt,    Pc,   Ps}, pgoblin_strsel , "strselect"} /* 024 */
//  
//a
// CTL
//a
//    
//a
// OUT
//a
//  
//a
// STY.
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , {    Io|Id|Ii|Ic          , {Po|Pq,    Pt,    Pc,   Pm}, pgoblin_copyin , "copyin"   } /* 028 */
// 
//a
// IN
//a
//    
//a
// CTL
//a
//  
//a
// COPY
//a
// .  
//a
// OUT
//a
//  0,   ,      .
  , {    Io|Id|   Ic|Ij       , {Po|Pm,    Pt,    Pc,    0}, pgoblin_copyout, "copyout"  } /* 029 */
//  
//a
// CTL
//a
//   
//a
// OUT
//a
//  
//a
// COPY
  , { Fl|Io|   Ii|   Ij       , {Po|Pm,     0,    Pj,   Pm}, pgoblin_getstr , "getstr"   } /* 02A */
// 
//a
// CTL
//a
// ,  
//a
// OUT
//a
//    2   
//a
// COPY
//a
//n
//    ,   0
//  
//n
//      IN.
//    CTL   .
  , {    Io|Id|Ii|   Ij       , {Po|Pm,    Pt,    Pj,   Pq}, pgoblin_getdir , "getdir"   } /* 02B */
// 
//a
// CTL
//a
//     ,     .
//         IN. 
//a
// OUT
//a
//    
//a
// COPY
//a
//  :
//u
// - 0x01    ,   0
// - 0x02  
// - 0x04  
// - 0x08 mode 
// - 0x10 uid 
// - 0x20 gid 
  , {    Io|Id|Ii|   Ij       , {Po|Pm,    Pt,    Pj,   Pm}, pgoblin_getcsv , "getcsv"   } /* 02C */
//  CSV  
//a
// COPY
//a
// .
// 
//a
// CTL
//a
//    2      ,
//      ,
//         ,
//     NULL  .
//    ,       
// ,      .
// 
//a
// CTL
//a
// ,      ';',
//     '"'.
  , {    Io|Id|      Ij       , {Po|Pm,    Pt,    Pj,    0}, pgoblin_getopt , "getopt"   } /* 02D */
// 
//a
// OUT
//a
//       
//a
// COPY
//a
//  3 :
//n
// -   
// - 
// -    text[],  NULL,    .
//n
// 
//a
// CTL
//a
//  ,    ,  
//  
//a
// babolo_setopts (3)
//a
// .      
//a
// Bpars_NONU
//a
// ,
//a
// 1
//a
// -  ,
//a
// 0
//a
// - .
//  ,  
//a
// Bpars_SYME | Bpars_ESYM | Bpars_EPRM
//a
// 
//a
// symr
//a
//  
//a
// Z
  , {    Io|Id|      Ij       , {Po|Pm,    Pt,    Pj,    0}, pgoblin_getarg , "getarg"   } /* 02E */
// 
//a
// OUT
//a
//    
//a
// COPY
//a
//  2 :
//n
// -  ,   0
// -  
//n
// 
//a
// CTL
//a
// ,   
//a
// #getarg
//a
//  
//a
// #getopt
//a
// ,   ,      
//     
//a
// pgoblin
//a
// ,   .  
//a
// #getopt
//a
// 
//a
// CTL
//a
// ,   ,   ,
//      .
//      ,
//     
//a
// #getopt
//a
// .
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , {    Io|Id|   Ic          , {Po|Pq,    Pt,    Pc,    0}, pgoblin_begin  , "begin"    } /* 030 */
//      pgoblin  ,   .
//  
//a
// BEGIN
//a
//  ,  
//a
// CON
//a
// ,     .     
//a
// END
//a
//   ,    .  
//a
// #begin
//a
// -
//a
// #end
//a
//   
//a
// BEGIN
//a
// -
//a
// END
//a
//    .      
//     ,      PostgreSQL.  
//a
// OUT
//a
// 
//a
// 0
//a
// ,   ,      .
  , {    Io|Id|   Ic          , {Po|Pq,    Pt,    Pc,    0}, pgoblin_end    , "end"      } /* 031 */
//      
//a
// #begin
//a
// ,   ,     .
//    
//a
// END
//a
//  ,  
//a
// CON
//a
// .     
//a
// END
//a
//  ,    .  
//a
// OUT
//a
// 
//a
// 0
//a
// ,   ,      .
  , {    Io|Id|   Ic          , {Po|Pq,    Pt,    Pc,    0}, pgoblin_rollbk , "rollback" } /* 032 */
//  ROLLBACK.  
//a
// OUT
//a
// 
//a
// 0
//a
// ,   ,      .
  , { Ff|Io|Id|Ii|   Ij|    Fc, {Po|Pm,    Pq,    Pj,   Pm}, pgoblin_fork   , "fork"     } /* 033 */
//a
// pgoblin
//a
// ,     
//a
// #fork
//a
// 
//a
// #exit
//a
// 
//a
// #return
//a
// ,
//   ,     .
//         ,
//     .
//        ,
//           .
//         
//    ,     
//  . 
//a
// OUT
//a
//          ,  
//a
// IN
//a
//          ,
//   . 
//a
// CTL
//a
// 
//a
// 0
//a
// ,    ,   
//a
// CTL
//a
// ,      
//a
// CTL
//a
//       
//a
// CTL
//a
// .
  , {    Io|Id|Ii|   Ij|    Fc, {Po   ,    Pt,    Pj,   Pq}, pgoblin_out    , "out"      } /* 034 */
//  
//a
// CTL
//a
//    
//a
// OUT
//a
// . 
//a
// IN
//a
// 
//a
// 0
//a
// ,         .      
//a
// CTL
//a
// .    .     
//a
// JOB
//a
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL} /* 038 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL} /* 040 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL} /* 050 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL} /* 060 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL} /* 070 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL} /* 080 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL} /* 090 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL} /* 0A0 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL} /* 0B0 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL} /* 0C0 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL} /* 0D0 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL} /* 0E0 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL} /* 0F0 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL} /* 100 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL} /* 101 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL} /* 102 */
  , { Fl|            Ij       , {    0,     0,    Pj,    0}, pgoblin_wait   , "wait"     } /* 103 */
//    ,  
//a
// JOB
//a
// .
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL} /* 104 */
  , { Fl|Fd|      Ic          , {    0,     0, Po|Pc,    0}, pgoblin_return , "return"   } /* 105 */
//     
//a
// #fork
//a
// ,    
//a
// #exit
//a
// 
//a
// CTL
//a
// .    
//a
// #trap
//a
// ,       ,  
//a
// CON
//a
//  .
  , { Fl|Io|   Ii|Ij|Is|0x2000, {Po|Pm,     0,    Ps,   Pq}, pgoblin_display, "display"  } /* 106 */
// IN   Pq   OUT      STY.
  , { Fl|Io|   Ii             , {   Pm,     0,     0,Po|Pm}, pgoblin_pipe   , "pipe"     } /* 107 */
//   
//a
// OUT
//a
//   
//a
// IN
//a
// .      
//     .
//a
// 0
//a
//   ,   .
  , { Fl|Io|   Ii|Ic|Is|0x1000, {   Pm, Po|Ps, Po|Pc,Po|Pm}, pgoblin_close  , "close"    } /* 108 */
//   
//a
// OUT
//a
// ,  
//a
// IN
//a
// , 
//a
// STY
//a
//    
//a
// CON
//a
// .
//       
//a
// IN
//a
// 
//a
// OUT
//a
// .      0   .  
//a
// CON
//a
// ,  
//a
// 0
//a
// ,  ,    
//      .
  , { Fl|Io|      Ij|Is|0x3000, {Po|Pt,     0, Po|Pj,Po|Ps}, pgoblin_clear  , "clear"    } /* 109 */
// 
//a
// JOB
//a
// 
//a
// STY
//a
// ,  
//a
// 0
//a
// .
//a
// 0
//a
// 
//a
// JOB
//a
// 
//a
// STY
//a
//  .    
//a
// 0
//a
// 
//a
// OUT
//a
// ,   
//a
// Po|Pm.
  , { Fl                      , {    0,     0,     0,    0}, pgoblin_untrap , "untrap"   } /* 10A */
//   
//a
// #trap.
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           ,        NULL} /* 110 */
  , { Fl|Io|         Ij       , {Po|Pm,     0,    Pj,    0}, pgoblin_getenv , "getenv"   } /* 111 */
//  OUT     COPY  3 :
//n
// -    ,   0
// -   
// -  
  , { Fl|Io|         Ij       , {Po|Pm,     0,    Pj,    0}, pgoblin_getget , "getget"   } /* 112 */
// 
//a
// OUT
//a
//    
//a
// COPY
//a
//  3 :
//n
// -    ,   0
// -    HTTP GET
// -  
//n
//     
//a
// CGI
//a
// , 
//a
// GET
//a
// .
  , { Fl|Io|   Ii|   Ij       , {Po|Pm,     0,    Pj,   Pm}, pgoblin_getpost, "getpost"  } /* 113 */
// 
//a
// OUT
//a
//    
//a
// COPY
//a
//  3 :
//n
// -    ,   0
// -    HTTP POST
// -  
//n
//     
//a
// IN
//a
// .     
//a
// CGI
//a
// , 
//a
// POST
//a
// .
  , { Fl|Io|         Ij       , {Po|Pm,     0,    Pj,    0}, pgoblin_getproc, "getproc"  } /* 114 */
// 
//a
// OUT
//a
//    
//a
// COPY
//a
//  3 :
//n
// - PID 
// -  ,   0
// -  
//n
//     .
//  0   exec()     -1.
  , { Fl|Io|         Ij       , {Po|Pm,     0,     0,    0}, pgoblin_getjob , "getjob"   } /*!ch[2] */
// 
//a
// OUT
//a
//    
//a
// COPY
//a
//  4 :
//n
// -    ,   0
// -  ,    
// - PID 
// -  
//n
//     
//a
// JOB
//a
// . 
//a
// #getjob
//a
//  
//a
// JOB 0
//a
// .
  , { Fx                      , {    0,     0,     0,    0}, pgoblin_getspq , "getspq"   } /* 116 */
  , { Fl|Io|   Ii             , {Po|Pm,     0,     0,   Pq}, pgoblin_getmeta, "getmeta"  } /* 117 */
// 
//a
// OUT
//a
//       
//a
// IN Pq
//a
//  
//a
// COPY
//a
//  7 :
//n
// -  ,   0
// -  
// -  
// -  
// -   ( ,   )
// NULL
// NULL
//n
//    
//a
// IN
//a
//      NULL.
//     NULL    .
  , { Fl|Io|   Ii             , {Po|Pq,     0,     0,   Pq}, pgoblin_info   , "info"     } /* 118 */
  , { Fl|Io                   , {Po|Pm,     0,     0,    0}, pgoblin_dump   , "dump"     } /* 119 */
//   .
} };
