/*-
 * Copyright (C)2008..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2008..2024 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: db_0.c,v 1.110 2024/07/14 00:00:02 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define PGOBLIN_MODULE   2
#define PGOBLIN_COMPAT   5
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

#define INDX(R, C) ((R) * rio->pq->ncol + (C))  /*           */

                                           /* Pc  db_0  NULL                                */
struct pgoblin_realpq {                      /*  Pq                                           */
    BLIN_flag flags;
/*            PGOBLIN_DB_TYPE               *                                                        */
#   define    PGOBLIN_DB_0FREEC 0x010000   /*     free()                       */
#   define    PGOBLIN_DB_0FREEA 0x020000   /* cell  free()                                       */
#   define    PGOBLIN_DB_0FREES 0x040000   /* serv  free()                                       */
#   define    PGOBLIN_DB_0FREET 0x080000   /*   serv  free()                          */
#   define    PGOBLIN_DB_0FREEL 0x100000   /* llen  free()                                       */
#   define    PGOBLIN_DB_0INDIR 0xC00000   /*   Pq    Pq (1),  (2), (3)  */
#if BLINAP > 4
    int32_t   dummy;
#endif
    size_t    nrow;                        /*                                 */
    size_t    ncol;                        /*                               */
    char    **cell;                        /*                */
    size_t   *llen;                        /*        *
                                            *  ,         *
                                            *  strlen()                                  */
    char    **serv;                        /*  ͣ                                */
};

pgoblin_realpq *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_db00(pgoblin_exenv *exenv) {                                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int             loaded;
    pgoblin_realpq *rsv   = NULL;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    if  (!(rsv = calloc(1, sizeof(pgoblin_realpq)))) {
        ifBLIN_QW0("");
    } else if (0 > (loaded = pgoblin_load(exenv, 3, "0", -1))) {
        ifBLIN_QW0("");
    } else {
        rsv->flags = (exenv->options->flags & BLIN_MASK) | (u_int)loaded;
    }
    return(rsv);
#   undef blin_internal_flags
}

static pgoblin_realpq *
/**********************************************************************
 **                                                                  **/
resv(pgoblin_exenv *exenv) {                                        /**
 **                                                                  **
 **********************************************************************/
    return(pgoblin_db00(exenv));
}

int
/*******************************************************************************************
 *******************************************************************************************
 **                                                                                       **/
pgoblin_db0_create( pgoblin_exenv      *exenv                                            /**/
                  , pgoblin_rio        *rou                                              /**/
                  , size_t              cnt                                              /**/
                  , const char * const *val                                              /**/
                  , const size_t       *len                                              /**/
                  ) {                                                                    /**
 **                                                                                       **
 *******************************************************************************************
 *******************************************************************************************/
#   define blin_internal_flags (rou->flags & BLIN_MASK)
    int            ex = EX_OK;

    rou->pq = pgoblin_db00(exenv);
    if  (!rou->pq) {
        ifBLIN_QX0("No mem #1");
        errno = ENOMEM;
        ex = EX_OSERR;
    } else if (!(rou->pq->llen = malloc(cnt * sizeof(size_t)))) {
        free(rou->pq);
        ifBLIN_QX0("No mem #2");
        errno = ENOMEM;
        ex = EX_OSERR;
    } else if (!(rou->pq->cell = malloc(cnt * sizeof(char*)))) {
        free(rou->pq->llen);
        free(rou->pq);
        ifBLIN_QX0("No mem #3");
        errno = ENOMEM;
        ex = EX_OSERR;
    } else {
        rou->pq->flags |= PGOBLIN_DB_0FREEL | PGOBLIN_DB_0FREEC | PGOBLIN_DB_0FREEA;
        rou->pq->nrow = 1;
        rou->pq->ncol = cnt;
        for (size_t i = 0; i < cnt; i++) {
            if  (!val || !val[i]) {
                rou->pq->cell[i] = NULL;
                rou->pq->llen[i] = 0;
            } else if (!len) {
                rou->pq->cell[i] = strdup(val[i]);
                rou->pq->llen[i] = strlen(val[i]);
            } else {
                rou->pq->cell[i] = malloc(len[i] + 1);
                bcopy(val[i], rou->pq->cell[i], len[i]);
                rou->pq->cell[i][len[i]] = '\0';
                rou->pq->llen[i] = len[i];
    }   }   }
    if  (!!ex) rou->pq = NULL;
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
init(pgoblin_exenv *exenv, u_int slot) {                            /**
 **                                                                  **
 **********************************************************************/
    pgoblin_db_0.flags = (pgoblin_db_0.flags & ~(BLIN_MASK | PGOBLIN_DB_TYPE))
                       | (exenv->options->flags & BLIN_MASK)
                       | (slot & PGOBLIN_DB_TYPE)
    ;
    return(0);
}

static int
/**********************************************************************
 **                                                                  **/
fini(pgoblin_exenv *exenv) {                                        /**
 **                                                                  **
 **********************************************************************/
    (void)exenv;
    return(0);
}

static int
/**********************************************************************
 **                                                                  **/
shurecon(pgoblin_rdb *rdb) {                                        /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (rdb->flags & BLIN_MASK)
    int          ex = EX_OK;

    MARK_R_CONN_GO(rdb);;
    ;;  rdb->conn = NULL;                                                              /* Pc  */
    ;;  rdb->flags = (rdb->flags & ~(BLIN_MASK | PGOBLIN_DB_TYPE))
 /* ;; */          | (pgoblin_db_0.flags & (BLIN_MASK | PGOBLIN_DB_TYPE))
    ;;  ;
    MARK_R_CONN_WENT(rdb);;
    ifBLIN_QX4("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/********************************************************************************
 **                                                                            **/
query(pgoblin_exenv *exenv, pgoblin_nr *rn) {                                 /**
 **                                                                            **
 ********************************************************************************
 **  #select      NULL,                       **
 **    qry "rows cols"                                             **
 ********************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rdb   *rdb;
    pgoblin_rio   *rou;
    pgoblin_rio   *rct;
    int            ex = EX_SOFTWARE;
    char          *q;

    GET_CON(rdb, exenv->options, rn[PGO_CCON]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    if  (!(rou->pq = resv(exenv))) {
        ifBLIN_QX0("No mem");
        errno = ENOMEM;
        ex = EX_OSERR;
    } else if (rct->text) {
        rou->pq->nrow = strtoul(rct->text, &q, 0);
        rou->pq->ncol = strtoul(q, &q, 0);
        ex = EX_OK;
    }
out:
    ifBLIN_QX4("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************
 **                                                 **/
execute(pgoblin_exenv *exenv, pgoblin_nr *rn) {    /**
 **                                                 **
 *****************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rdb *rdb;
    pgoblin_rio *rou;
    int          ex = EX_SOFTWARE;

    GET_CON(rdb, exenv->options, rn[PGO_CCON]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    if  (!(rou->pq = resv(exenv))) {
        ifBLIN_QX0("No mem #1");
        errno = ENOMEM;
        ex = EX_OSERR;
    }
out:
    return(ex);
#   undef blin_internal_flags
}

static int64_t
/**********************************************************************
 **                                                                  **/
resinfo(pgoblin_rio *rio, int kind) {                               /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (rio->flags & BLIN_MASK)
    int64_t       ex = 0;

    ifBLIN_QX3("+ %d", kind);
    if  (!rio->pq) {
        errno = EFAULT;
        ex = -1;
    } else {
        switch (kind) {
        case PGOBLIN_Ntuples:
            ex = (int64_t)rio->pq->nrow;
            break;
        case PGOBLIN_Nfields:
            ex = (int64_t)rio->pq->ncol;
            break;
        default:
            ex = -1;
            errno = ENOTSUP;
    }   }
    ifBLIN_QX3("- %"BLIN_O"d", ex);
    return(ex);
#   undef blin_internal_flags
}

static const char *
/***************************************************************************
 **                                                                       **/
subinfo(pgoblin_rio *rio, int kind, int64_t sub) {                       /**
 **                                                                       **
 ***************************************************************************/
#   define blin_internal_flags (rio->flags & BLIN_MASK)
    const char   *cx = NULL;
    size_t        s  = (size_t)sub;

    ifBLIN_QX3("+ %d sub=%"BLIN_O"d", kind, sub);
    switch (kind) {
    case PGOBLIN_ColName:
        if  (0 > sub) {
            ifBLIN_QX0("sub=%"BLIN_O"d", sub);
            errno = EDOM;
            goto out;
        }
        if  (!!rio->pq->serv && (rio->pq->ncol > s)) cx = rio->pq->serv[s];
        break;
    case PGOBLIN_TypeNm:
        if  (0 > sub) {
            ifBLIN_QX0("sub=%"BLIN_O"d", sub);
            errno = EDOM;
            goto out;
        }
        if  (!!rio->pq->serv && (rio->pq->ncol > s)) cx = rio->pq->serv[s + rio->pq->ncol];
        break;
    default:;
    }
out:
    if  (!cx) {
        ifBLIN_QX3("-");
    } else {
        ifBLIN_QX3("- %s", cx);
    }
    return(cx);
#   undef blin_internal_flags
}

static char *
/**********************************************************************
 **                                                                  **/
erinfo(pgoblin_rio *rio) {                                          /**
 **                                                                  **
 **********************************************************************/
    char *cx = NULL;

    (void)rio;
    return(cx);
}

static ssize_t
/********************************************************************************
 **                                                                            **/
valinfo(pgoblin_rio *rio, int kind, ssize_t row, ssize_t col) {               /**
 **                                                                            **
 ********************************************************************************/
#   define blin_internal_flags (rio->flags & BLIN_MASK)
    ssize_t       ex = PGOBLIN_SSIZE_MIN;

    ifBLIN_QX3("+ %zd %zd", row, col);
    if  (!rio) {
        errno = EFAULT;
        goto out;
    }
    switch (kind) {
    case PGOBLIN_IsNull:
        if  (rio->pq) {
            if  (!rio->pq->cell) {
                ex = 1;
            } else if (  (row >= 0)
                      && ((size_t)row < rio->pq->nrow)
                      && (col >= 0)
                      && ((size_t)col < rio->pq->ncol)
                      ) {
                ex = !rio->pq->cell[INDX((size_t)row, (size_t)col)];
            } else {
                ifBLIN_QX1( "+ row %zd %s in [0..%zd], col %zd %s in [0..%zd]"
                          , row
                          , (row >= 0 && (size_t)row < rio->pq->nrow) ? "" : "NOT"
                          , rio->pq->nrow - 1
                          , col
                          , (col >= 0 && (size_t)col < rio->pq->ncol) ? "" : "NOT"
                          , rio->pq->ncol - 1
                          );
                errno = EINVAL;
            }
        } else if (row == 0 && col == 0) {
            ex = 1;
        } else {
            ifBLIN_QX0( "row %zd col %zd in emty", row, col);
            errno = EINVAL;
        }
        break;
    case PGOBLIN_Length:
        if  (!rio->pq) {
            errno = EFAULT;
        } else if (  (0 > row)
                  || ((size_t)row >= rio->pq->nrow)
                  || (0 > col)
                  || ((size_t)col >= rio->pq->ncol)
                  ) {
            errno = EINVAL;
        } else if (!!valinfo(rio, PGOBLIN_IsNull, row, col)) {
            errno = EFAULT;
        } else if (rio->pq->llen) {
            ex = (ssize_t)rio->pq->llen[INDX((size_t)row, (size_t)col)];
        } else if (rio->pq->cell) {
            ex = (ssize_t)strlen(rio->pq->cell[INDX((size_t)row, (size_t)col)]);
        }
        break;
    default:
        errno = ENOTSUP;
    }
out:
    ifBLIN_QX3("- %zd", ex);
    return(ex);
#   undef blin_internal_flags
}

static char *
/************************************************************************
 **                                                                    **/
getvalue(pgoblin_rio *rio, ssize_t row, ssize_t col) {                /**
 **                                                                    **
 ************************************************************************/
#   define blin_internal_flags (rio->flags & BLIN_MASK)
    char         *c = NULL;

    ifBLIN_QX3("+ %zd %zd", row, col);
    if  (!rio || !rio->pq) {
        errno = EINVAL;
    } else if (!valinfo(rio, PGOBLIN_IsNull, row, col)) {
        c = rio->pq->cell[INDX((size_t)row, (size_t)col)];
    }
    ifBLIN_QX3("- %s", c);
    return(c);
#   undef blin_internal_flags
}

static int
/***********************************************************************************
 **                                                                               **/
getstream(pgoblin_exenv *exenv, pgoblin_nr *rn, int quant) {                     /**
 **                                                                               **
 ***********************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    (void)rn;
    (void)quant;
    ifBLIN_QX0("Unimplemented in 0");
    errno = ENOTSUP;
    return(-1);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
getcopy(pgoblin_exenv *exenv, pgoblin_nr *rn, void **buf) {         /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    (void)rn;
    (void)buf;
    ifBLIN_QX0("Unimplemented in 0");
    errno = ENOTSUP;
    return(-1);
#   undef blin_internal_flags
}

static int
/********************************************************************************
 **                                                                            **/
putcopy(pgoblin_exenv *exenv, pgoblin_nr *rn, const void *buf, ssize_t len) { /**
 **                                                                            **
 ********************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    (void)rn;
    (void)buf;
    (void)len;
    ifBLIN_QX0("Unimplemented in 0");
    errno = ENOTSUP;
    return(-1);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
endstream(pgoblin_exenv *exenv, pgoblin_nr *rn) {                   /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    (void)rn;
    ifBLIN_QX0("Unimplemented in 0");
    errno = ENOTSUP;
    return(-1);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
tarry(pgoblin_rdb *rdb, int timeout) {                              /**
 **                                                                  **
 **********************************************************************/
    (void)rdb;
    (void)timeout;
    return(0);
}

static void*
/**********************************************************************
 **                                                                  **/
notifies(pgoblin_rdb *rdb) {                                        /**
 **                                                                  **
 **********************************************************************/
    (void)rdb;
    return(NULL);
}

static int
/**********************************************************************
 **                                                                  **/
finish(pgoblin_rdb *rdb) {                                          /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (rdb->flags & BLIN_MASK)
    int          ex = EX_OK;

    ifBLIN_QX3("+");
    rdb->conn = NULL;
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
clear(pgoblin_rio *rio) {                                           /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (rio->flags & BLIN_MASK)
    int           ex = EX_OK;
    size_t        i;

    if  (!!rio->pq) {
        ifBLIN_QX4("No rio->pq");
        if  ((rio->pq->llen) && (rio->pq->flags & PGOBLIN_DB_0FREEL)) {
            free(rio->pq->llen);
            rio->pq->llen = NULL;
        }
        if  (rio->pq->serv) {
            if  (rio->pq->flags & PGOBLIN_DB_0FREET) {
                for (i = 0; i < rio->pq->ncol; i++) {
                    free(rio->pq->serv[i]);
                    rio->pq->serv[i] = NULL;
            }   }
            if  (rio->pq->flags & PGOBLIN_DB_0FREES) {
                free(rio->pq->serv);
                rio->pq->serv = NULL;
        }   }
        if  (rio->pq->cell) {
            if  (rio->pq->flags & PGOBLIN_DB_0FREEC) {
                for (i = 0; i < rio->pq->nrow * rio->pq->ncol; i++) {
                    free(rio->pq->cell[i]);
                    rio->pq->cell[i] = NULL;
            }   }
            if  (rio->pq->flags & PGOBLIN_DB_0FREEA) {
                free(rio->pq->cell);
                rio->pq->cell = NULL;
        }   }
        free(rio->pq);
        rio->pq = NULL;
    }
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
denote(pgoblin_rdb *rdb, void **note) {                             /**
 **                                                                  **
 **********************************************************************/
    (void)rdb;
    (void)note;
    return(EX_OK);
}

pgoblin_dbases pgoblin_db_0 =
{ 0
, "3pGoblin-" VERS
, "0\0" VERS
, 0
, init
, fini
, shurecon
, NULL      /* erconn  */
, notifies
, finish
, tarry
, denote
, erinfo
, clear
, resinfo
, subinfo
, valinfo
, getvalue
, query
, NULL      /* prepare */
, NULL      /* prexec  */
, execute
, getstream
, getcopy
, putcopy
, endstream
, NULL      /* dummy1  */
, NULL      /* dummy2  */
};
